/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ContentProviderOperation;
import android.content.ContentProviderProxy;
import android.content.ContentValues;
import android.content.IContentProvider;
import android.content.res.AssetFileDescriptor;
import android.database.BulkCursorDescriptor;
import android.database.Cursor;
import android.database.CursorToBulkCursorAdaptor;
import android.database.DatabaseUtils;
import android.database.IContentObserver;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.ICancellationSignal;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class ContentProviderNative
extends Binder
implements IContentProvider,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;

    private void $$robo$$android_content_ContentProviderNative$__constructor__() {
        this.attachInterface(this, "android.content.IContentProvider");
    }

    private static final IContentProvider $$robo$$android_content_ContentProviderNative$asInterface(IBinder obj) {
        if (obj == null) {
            return null;
        }
        IContentProvider in = (IContentProvider)obj.queryLocalInterface("android.content.IContentProvider");
        if (in != null) {
            return in;
        }
        return new ContentProviderProxy(obj);
    }

    public abstract String getProviderName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_content_ContentProviderNative$onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        try {
            switch (code) {
                case 1: {
                    data.enforceInterface("android.content.IContentProvider");
                    String callingPkg = data.readString();
                    Uri url = Uri.CREATOR.createFromParcel(data);
                    int num = data.readInt();
                    String[] projection = null;
                    if (num > 0) {
                        projection = new String[num];
                        for (int i = 0; i < num; ++i) {
                            projection[i] = data.readString();
                        }
                    }
                    String selection = data.readString();
                    num = data.readInt();
                    String[] selectionArgs = null;
                    if (num > 0) {
                        selectionArgs = new String[num];
                        for (int i = 0; i < num; ++i) {
                            selectionArgs[i] = data.readString();
                        }
                    }
                    String sortOrder = data.readString();
                    IContentObserver observer = IContentObserver.Stub.asInterface(data.readStrongBinder());
                    ICancellationSignal cancellationSignal = ICancellationSignal.Stub.asInterface(data.readStrongBinder());
                    Cursor cursor = this.query(callingPkg, url, projection, selection, selectionArgs, sortOrder, cancellationSignal);
                    if (cursor != null) {
                        CursorToBulkCursorAdaptor adaptor = null;
                        try {
                            adaptor = new CursorToBulkCursorAdaptor(cursor, observer, this.getProviderName());
                            cursor = null;
                            BulkCursorDescriptor d = adaptor.getBulkCursorDescriptor();
                            adaptor = null;
                            reply.writeNoException();
                            reply.writeInt(1);
                            d.writeToParcel(reply, 1);
                        }
                        finally {
                            if (adaptor != null) {
                                adaptor.close();
                            }
                            if (cursor != null) {
                                cursor.close();
                            }
                        }
                    } else {
                        reply.writeNoException();
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 2: {
                    data.enforceInterface("android.content.IContentProvider");
                    Uri url = Uri.CREATOR.createFromParcel(data);
                    String type = this.getType(url);
                    reply.writeNoException();
                    reply.writeString(type);
                    return true;
                }
                case 3: {
                    data.enforceInterface("android.content.IContentProvider");
                    String callingPkg = data.readString();
                    Uri url = Uri.CREATOR.createFromParcel(data);
                    ContentValues values = ContentValues.CREATOR.createFromParcel(data);
                    Uri out = this.insert(callingPkg, url, values);
                    reply.writeNoException();
                    Uri.writeToParcel(reply, out);
                    return true;
                }
                case 13: {
                    data.enforceInterface("android.content.IContentProvider");
                    String callingPkg = data.readString();
                    Uri url = Uri.CREATOR.createFromParcel(data);
                    ContentValues[] values = data.createTypedArray(ContentValues.CREATOR);
                    int count = this.bulkInsert(callingPkg, url, values);
                    reply.writeNoException();
                    reply.writeInt(count);
                    return true;
                }
                case 20: {
                    data.enforceInterface("android.content.IContentProvider");
                    String callingPkg = data.readString();
                    int numOperations = data.readInt();
                    ArrayList<ContentProviderOperation> operations = new ArrayList<ContentProviderOperation>(numOperations);
                    for (int i = 0; i < numOperations; ++i) {
                        operations.add(i, ContentProviderOperation.CREATOR.createFromParcel(data));
                    }
                    Parcelable[] results = this.applyBatch(callingPkg, operations);
                    reply.writeNoException();
                    reply.writeTypedArray(results, 0);
                    return true;
                }
                case 4: {
                    data.enforceInterface("android.content.IContentProvider");
                    String callingPkg = data.readString();
                    Uri url = Uri.CREATOR.createFromParcel(data);
                    String selection = data.readString();
                    String[] selectionArgs = data.readStringArray();
                    int count = this.delete(callingPkg, url, selection, selectionArgs);
                    reply.writeNoException();
                    reply.writeInt(count);
                    return true;
                }
                case 10: {
                    data.enforceInterface("android.content.IContentProvider");
                    String callingPkg = data.readString();
                    Uri url = Uri.CREATOR.createFromParcel(data);
                    ContentValues values = ContentValues.CREATOR.createFromParcel(data);
                    String selection = data.readString();
                    String[] selectionArgs = data.readStringArray();
                    int count = this.update(callingPkg, url, values, selection, selectionArgs);
                    reply.writeNoException();
                    reply.writeInt(count);
                    return true;
                }
                case 14: {
                    data.enforceInterface("android.content.IContentProvider");
                    String callingPkg = data.readString();
                    Uri url = Uri.CREATOR.createFromParcel(data);
                    String mode = data.readString();
                    ICancellationSignal signal = ICancellationSignal.Stub.asInterface(data.readStrongBinder());
                    IBinder callerToken = data.readStrongBinder();
                    ParcelFileDescriptor fd = this.openFile(callingPkg, url, mode, signal, callerToken);
                    reply.writeNoException();
                    if (fd != null) {
                        reply.writeInt(1);
                        fd.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 15: {
                    data.enforceInterface("android.content.IContentProvider");
                    String callingPkg = data.readString();
                    Uri url = Uri.CREATOR.createFromParcel(data);
                    String mode = data.readString();
                    ICancellationSignal signal = ICancellationSignal.Stub.asInterface(data.readStrongBinder());
                    AssetFileDescriptor fd = this.openAssetFile(callingPkg, url, mode, signal);
                    reply.writeNoException();
                    if (fd != null) {
                        reply.writeInt(1);
                        fd.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 21: {
                    data.enforceInterface("android.content.IContentProvider");
                    String callingPkg = data.readString();
                    String method = data.readString();
                    String stringArg = data.readString();
                    Bundle args = data.readBundle();
                    Bundle responseBundle = this.call(callingPkg, method, stringArg, args);
                    reply.writeNoException();
                    reply.writeBundle(responseBundle);
                    return true;
                }
                case 22: {
                    data.enforceInterface("android.content.IContentProvider");
                    Uri url = Uri.CREATOR.createFromParcel(data);
                    String mimeTypeFilter = data.readString();
                    String[] types = this.getStreamTypes(url, mimeTypeFilter);
                    reply.writeNoException();
                    reply.writeStringArray(types);
                    return true;
                }
                case 23: {
                    data.enforceInterface("android.content.IContentProvider");
                    String callingPkg = data.readString();
                    Uri url = Uri.CREATOR.createFromParcel(data);
                    String mimeType = data.readString();
                    Bundle opts = data.readBundle();
                    ICancellationSignal signal = ICancellationSignal.Stub.asInterface(data.readStrongBinder());
                    AssetFileDescriptor fd = this.openTypedAssetFile(callingPkg, url, mimeType, opts, signal);
                    reply.writeNoException();
                    if (fd != null) {
                        reply.writeInt(1);
                        fd.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 24: {
                    data.enforceInterface("android.content.IContentProvider");
                    ICancellationSignal cancellationSignal = this.createCancellationSignal();
                    reply.writeNoException();
                    reply.writeStrongBinder(cancellationSignal.asBinder());
                    return true;
                }
                case 25: {
                    data.enforceInterface("android.content.IContentProvider");
                    String callingPkg = data.readString();
                    Uri url = Uri.CREATOR.createFromParcel(data);
                    Uri out = this.canonicalize(callingPkg, url);
                    reply.writeNoException();
                    Uri.writeToParcel(reply, out);
                    return true;
                }
                case 26: {
                    data.enforceInterface("android.content.IContentProvider");
                    String callingPkg = data.readString();
                    Uri url = Uri.CREATOR.createFromParcel(data);
                    Uri out = this.uncanonicalize(callingPkg, url);
                    reply.writeNoException();
                    Uri.writeToParcel(reply, out);
                    return true;
                }
            }
        }
        catch (Exception e) {
            DatabaseUtils.writeExceptionToParcel(reply, e);
            return true;
        }
        return super.onTransact(code, data, reply, flags);
    }

    private final IBinder $$robo$$android_content_ContentProviderNative$asBinder() {
        return this;
    }

    private void __constructor__() {
        this.$$robo$$android_content_ContentProviderNative$__constructor__();
    }

    public ContentProviderNative() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_ContentProviderNative$__constructor__(), 0, this);
    }

    public static IContentProvider asInterface(IBinder iBinder) {
        return InvokeDynamicSupport.bootstrapStatic("asInterface", $$robo$$android_content_ContentProviderNative$asInterface(android.os.IBinder ), 0, (IBinder)iBinder);
    }

    @Override
    public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
        return (boolean)InvokeDynamicSupport.bootstrap("onTransact", $$robo$$android_content_ContentProviderNative$onTransact(int android.os.Parcel android.os.Parcel int ), 0, this, n, parcel, parcel2, n2);
    }

    @Override
    public IBinder asBinder() {
        return InvokeDynamicSupport.bootstrap("asBinder", $$robo$$android_content_ContentProviderNative$asBinder(), 0, this);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ContentProviderNative)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

