/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.os.ParcelUuid;
import com.google.errorprone.annotations.DoNotMock;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.UUID;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class BluetoothUuid
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static ParcelUuid AudioSink;
    public static ParcelUuid AudioSource;
    public static ParcelUuid AdvAudioDist;
    public static ParcelUuid HSP;
    public static ParcelUuid HSP_AG;
    public static ParcelUuid Handsfree;
    public static ParcelUuid Handsfree_AG;
    public static ParcelUuid AvrcpController;
    public static ParcelUuid AvrcpTarget;
    public static ParcelUuid ObexObjectPush;
    public static ParcelUuid Hid;
    public static ParcelUuid Hogp;
    public static ParcelUuid PANU;
    public static ParcelUuid NAP;
    public static ParcelUuid BNEP;
    public static ParcelUuid PBAP_PCE;
    public static ParcelUuid PBAP_PSE;
    public static ParcelUuid MAP;
    public static ParcelUuid MNS;
    public static ParcelUuid MAS;
    public static ParcelUuid SAP;
    public static ParcelUuid BASE_UUID;
    public static int UUID_BYTES_16_BIT = 2;
    public static int UUID_BYTES_32_BIT = 4;
    public static int UUID_BYTES_128_BIT = 16;
    public static ParcelUuid[] RESERVED_UUIDS;

    private void $$robo$$android_bluetooth_BluetoothUuid$__constructor__() {
    }

    private static final boolean $$robo$$android_bluetooth_BluetoothUuid$isAudioSource(ParcelUuid uuid) {
        return uuid.equals(AudioSource);
    }

    private static final boolean $$robo$$android_bluetooth_BluetoothUuid$isAudioSink(ParcelUuid uuid) {
        return uuid.equals(AudioSink);
    }

    private static final boolean $$robo$$android_bluetooth_BluetoothUuid$isAdvAudioDist(ParcelUuid uuid) {
        return uuid.equals(AdvAudioDist);
    }

    private static final boolean $$robo$$android_bluetooth_BluetoothUuid$isHandsfree(ParcelUuid uuid) {
        return uuid.equals(Handsfree);
    }

    private static final boolean $$robo$$android_bluetooth_BluetoothUuid$isHeadset(ParcelUuid uuid) {
        return uuid.equals(HSP);
    }

    private static final boolean $$robo$$android_bluetooth_BluetoothUuid$isAvrcpController(ParcelUuid uuid) {
        return uuid.equals(AvrcpController);
    }

    private static final boolean $$robo$$android_bluetooth_BluetoothUuid$isAvrcpTarget(ParcelUuid uuid) {
        return uuid.equals(AvrcpTarget);
    }

    private static final boolean $$robo$$android_bluetooth_BluetoothUuid$isInputDevice(ParcelUuid uuid) {
        return uuid.equals(Hid);
    }

    private static final boolean $$robo$$android_bluetooth_BluetoothUuid$isPanu(ParcelUuid uuid) {
        return uuid.equals(PANU);
    }

    private static final boolean $$robo$$android_bluetooth_BluetoothUuid$isNap(ParcelUuid uuid) {
        return uuid.equals(NAP);
    }

    private static final boolean $$robo$$android_bluetooth_BluetoothUuid$isBnep(ParcelUuid uuid) {
        return uuid.equals(BNEP);
    }

    private static final boolean $$robo$$android_bluetooth_BluetoothUuid$isMap(ParcelUuid uuid) {
        return uuid.equals(MAP);
    }

    private static final boolean $$robo$$android_bluetooth_BluetoothUuid$isMns(ParcelUuid uuid) {
        return uuid.equals(MNS);
    }

    private static final boolean $$robo$$android_bluetooth_BluetoothUuid$isMas(ParcelUuid uuid) {
        return uuid.equals(MAS);
    }

    private static final boolean $$robo$$android_bluetooth_BluetoothUuid$isSap(ParcelUuid uuid) {
        return uuid.equals(SAP);
    }

    private static final boolean $$robo$$android_bluetooth_BluetoothUuid$isUuidPresent(ParcelUuid[] uuidArray, ParcelUuid uuid) {
        if ((uuidArray == null || uuidArray.length == 0) && uuid == null) {
            return true;
        }
        if (uuidArray == null) {
            return false;
        }
        for (ParcelUuid element : uuidArray) {
            if (!element.equals(uuid)) continue;
            return true;
        }
        return false;
    }

    private static final boolean $$robo$$android_bluetooth_BluetoothUuid$containsAnyUuid(ParcelUuid[] uuidA, ParcelUuid[] uuidB) {
        if (uuidA == null && uuidB == null) {
            return true;
        }
        if (uuidA == null) {
            return uuidB.length == 0;
        }
        if (uuidB == null) {
            return uuidA.length == 0;
        }
        HashSet<ParcelUuid> uuidSet = new HashSet<ParcelUuid>(Arrays.asList(uuidA));
        for (ParcelUuid uuid : uuidB) {
            if (!uuidSet.contains(uuid)) continue;
            return true;
        }
        return false;
    }

    private static final boolean $$robo$$android_bluetooth_BluetoothUuid$containsAllUuids(ParcelUuid[] uuidA, ParcelUuid[] uuidB) {
        if (uuidA == null && uuidB == null) {
            return true;
        }
        if (uuidA == null) {
            return uuidB.length == 0;
        }
        if (uuidB == null) {
            return true;
        }
        HashSet<ParcelUuid> uuidSet = new HashSet<ParcelUuid>(Arrays.asList(uuidA));
        for (ParcelUuid uuid : uuidB) {
            if (uuidSet.contains(uuid)) continue;
            return false;
        }
        return true;
    }

    private static final int $$robo$$android_bluetooth_BluetoothUuid$getServiceIdentifierFromParcelUuid(ParcelUuid parcelUuid) {
        UUID uuid = parcelUuid.getUuid();
        long value = (uuid.getMostSignificantBits() & 0xFFFF00000000L) >>> 32;
        return (int)value;
    }

    private static final ParcelUuid $$robo$$android_bluetooth_BluetoothUuid$parseUuidFrom(byte[] uuidBytes) {
        long shortUuid;
        if (uuidBytes == null) {
            throw new IllegalArgumentException("uuidBytes cannot be null");
        }
        int length = uuidBytes.length;
        if (length != 2 && length != 4 && length != 16) {
            throw new IllegalArgumentException("uuidBytes length invalid - " + length);
        }
        if (length == 16) {
            ByteBuffer buf = ByteBuffer.wrap(uuidBytes).order(ByteOrder.LITTLE_ENDIAN);
            long msb = buf.getLong(8);
            long lsb = buf.getLong(0);
            return new ParcelUuid(new UUID(msb, lsb));
        }
        if (length == 2) {
            shortUuid = uuidBytes[0] & 0xFF;
            shortUuid += (long)((uuidBytes[1] & 0xFF) << 8);
        } else {
            shortUuid = uuidBytes[0] & 0xFF;
            shortUuid += (long)((uuidBytes[1] & 0xFF) << 8);
            shortUuid += (long)((uuidBytes[2] & 0xFF) << 16);
            shortUuid += (long)((uuidBytes[3] & 0xFF) << 24);
        }
        long msb = BASE_UUID.getUuid().getMostSignificantBits() + (shortUuid << 32);
        long lsb = BASE_UUID.getUuid().getLeastSignificantBits();
        return new ParcelUuid(new UUID(msb, lsb));
    }

    private static final boolean $$robo$$android_bluetooth_BluetoothUuid$is16BitUuid(ParcelUuid parcelUuid) {
        UUID uuid = parcelUuid.getUuid();
        if (uuid.getLeastSignificantBits() != BASE_UUID.getUuid().getLeastSignificantBits()) {
            return false;
        }
        return (uuid.getMostSignificantBits() & 0xFFFF0000FFFFFFFFL) == 4096L;
    }

    private static final boolean $$robo$$android_bluetooth_BluetoothUuid$is32BitUuid(ParcelUuid parcelUuid) {
        UUID uuid = parcelUuid.getUuid();
        if (uuid.getLeastSignificantBits() != BASE_UUID.getUuid().getLeastSignificantBits()) {
            return false;
        }
        if (BluetoothUuid.is16BitUuid(parcelUuid)) {
            return false;
        }
        return (uuid.getMostSignificantBits() & 0xFFFFFFFFL) == 4096L;
    }

    static void __staticInitializer__() {
        AudioSink = ParcelUuid.fromString("0000110B-0000-1000-8000-00805F9B34FB");
        AudioSource = ParcelUuid.fromString("0000110A-0000-1000-8000-00805F9B34FB");
        AdvAudioDist = ParcelUuid.fromString("0000110D-0000-1000-8000-00805F9B34FB");
        HSP = ParcelUuid.fromString("00001108-0000-1000-8000-00805F9B34FB");
        HSP_AG = ParcelUuid.fromString("00001112-0000-1000-8000-00805F9B34FB");
        Handsfree = ParcelUuid.fromString("0000111E-0000-1000-8000-00805F9B34FB");
        Handsfree_AG = ParcelUuid.fromString("0000111F-0000-1000-8000-00805F9B34FB");
        AvrcpController = ParcelUuid.fromString("0000110E-0000-1000-8000-00805F9B34FB");
        AvrcpTarget = ParcelUuid.fromString("0000110C-0000-1000-8000-00805F9B34FB");
        ObexObjectPush = ParcelUuid.fromString("00001105-0000-1000-8000-00805f9b34fb");
        Hid = ParcelUuid.fromString("00001124-0000-1000-8000-00805f9b34fb");
        Hogp = ParcelUuid.fromString("00001812-0000-1000-8000-00805f9b34fb");
        PANU = ParcelUuid.fromString("00001115-0000-1000-8000-00805F9B34FB");
        NAP = ParcelUuid.fromString("00001116-0000-1000-8000-00805F9B34FB");
        BNEP = ParcelUuid.fromString("0000000f-0000-1000-8000-00805F9B34FB");
        PBAP_PCE = ParcelUuid.fromString("0000112e-0000-1000-8000-00805F9B34FB");
        PBAP_PSE = ParcelUuid.fromString("0000112f-0000-1000-8000-00805F9B34FB");
        MAP = ParcelUuid.fromString("00001134-0000-1000-8000-00805F9B34FB");
        MNS = ParcelUuid.fromString("00001133-0000-1000-8000-00805F9B34FB");
        MAS = ParcelUuid.fromString("00001132-0000-1000-8000-00805F9B34FB");
        SAP = ParcelUuid.fromString("0000112D-0000-1000-8000-00805F9B34FB");
        BASE_UUID = ParcelUuid.fromString("00000000-0000-1000-8000-00805F9B34FB");
        RESERVED_UUIDS = new ParcelUuid[]{AudioSink, AudioSource, AdvAudioDist, HSP, Handsfree, AvrcpController, AvrcpTarget, ObexObjectPush, PANU, NAP, MAP, MNS, MAS, SAP};
    }

    private void __constructor__() {
        this.$$robo$$android_bluetooth_BluetoothUuid$__constructor__();
    }

    public BluetoothUuid() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothUuid$__constructor__(), 0, this);
    }

    public static boolean isAudioSource(ParcelUuid parcelUuid) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isAudioSource", $$robo$$android_bluetooth_BluetoothUuid$isAudioSource(android.os.ParcelUuid ), 0, (ParcelUuid)parcelUuid);
    }

    public static boolean isAudioSink(ParcelUuid parcelUuid) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isAudioSink", $$robo$$android_bluetooth_BluetoothUuid$isAudioSink(android.os.ParcelUuid ), 0, (ParcelUuid)parcelUuid);
    }

    public static boolean isAdvAudioDist(ParcelUuid parcelUuid) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isAdvAudioDist", $$robo$$android_bluetooth_BluetoothUuid$isAdvAudioDist(android.os.ParcelUuid ), 0, (ParcelUuid)parcelUuid);
    }

    public static boolean isHandsfree(ParcelUuid parcelUuid) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isHandsfree", $$robo$$android_bluetooth_BluetoothUuid$isHandsfree(android.os.ParcelUuid ), 0, (ParcelUuid)parcelUuid);
    }

    public static boolean isHeadset(ParcelUuid parcelUuid) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isHeadset", $$robo$$android_bluetooth_BluetoothUuid$isHeadset(android.os.ParcelUuid ), 0, (ParcelUuid)parcelUuid);
    }

    public static boolean isAvrcpController(ParcelUuid parcelUuid) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isAvrcpController", $$robo$$android_bluetooth_BluetoothUuid$isAvrcpController(android.os.ParcelUuid ), 0, (ParcelUuid)parcelUuid);
    }

    public static boolean isAvrcpTarget(ParcelUuid parcelUuid) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isAvrcpTarget", $$robo$$android_bluetooth_BluetoothUuid$isAvrcpTarget(android.os.ParcelUuid ), 0, (ParcelUuid)parcelUuid);
    }

    public static boolean isInputDevice(ParcelUuid parcelUuid) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isInputDevice", $$robo$$android_bluetooth_BluetoothUuid$isInputDevice(android.os.ParcelUuid ), 0, (ParcelUuid)parcelUuid);
    }

    public static boolean isPanu(ParcelUuid parcelUuid) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isPanu", $$robo$$android_bluetooth_BluetoothUuid$isPanu(android.os.ParcelUuid ), 0, (ParcelUuid)parcelUuid);
    }

    public static boolean isNap(ParcelUuid parcelUuid) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isNap", $$robo$$android_bluetooth_BluetoothUuid$isNap(android.os.ParcelUuid ), 0, (ParcelUuid)parcelUuid);
    }

    public static boolean isBnep(ParcelUuid parcelUuid) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isBnep", $$robo$$android_bluetooth_BluetoothUuid$isBnep(android.os.ParcelUuid ), 0, (ParcelUuid)parcelUuid);
    }

    public static boolean isMap(ParcelUuid parcelUuid) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isMap", $$robo$$android_bluetooth_BluetoothUuid$isMap(android.os.ParcelUuid ), 0, (ParcelUuid)parcelUuid);
    }

    public static boolean isMns(ParcelUuid parcelUuid) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isMns", $$robo$$android_bluetooth_BluetoothUuid$isMns(android.os.ParcelUuid ), 0, (ParcelUuid)parcelUuid);
    }

    public static boolean isMas(ParcelUuid parcelUuid) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isMas", $$robo$$android_bluetooth_BluetoothUuid$isMas(android.os.ParcelUuid ), 0, (ParcelUuid)parcelUuid);
    }

    public static boolean isSap(ParcelUuid parcelUuid) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSap", $$robo$$android_bluetooth_BluetoothUuid$isSap(android.os.ParcelUuid ), 0, (ParcelUuid)parcelUuid);
    }

    public static boolean isUuidPresent(ParcelUuid[] parcelUuidArray, ParcelUuid parcelUuid) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isUuidPresent", $$robo$$android_bluetooth_BluetoothUuid$isUuidPresent(android.os.ParcelUuid[] android.os.ParcelUuid ), 0, (ParcelUuid[])parcelUuidArray, (ParcelUuid)parcelUuid);
    }

    public static boolean containsAnyUuid(ParcelUuid[] parcelUuidArray, ParcelUuid[] parcelUuidArray2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("containsAnyUuid", $$robo$$android_bluetooth_BluetoothUuid$containsAnyUuid(android.os.ParcelUuid[] android.os.ParcelUuid[] ), 0, (ParcelUuid[])parcelUuidArray, (ParcelUuid[])parcelUuidArray2);
    }

    public static boolean containsAllUuids(ParcelUuid[] parcelUuidArray, ParcelUuid[] parcelUuidArray2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("containsAllUuids", $$robo$$android_bluetooth_BluetoothUuid$containsAllUuids(android.os.ParcelUuid[] android.os.ParcelUuid[] ), 0, (ParcelUuid[])parcelUuidArray, (ParcelUuid[])parcelUuidArray2);
    }

    public static int getServiceIdentifierFromParcelUuid(ParcelUuid parcelUuid) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getServiceIdentifierFromParcelUuid", $$robo$$android_bluetooth_BluetoothUuid$getServiceIdentifierFromParcelUuid(android.os.ParcelUuid ), 0, (ParcelUuid)parcelUuid);
    }

    public static ParcelUuid parseUuidFrom(byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("parseUuidFrom", $$robo$$android_bluetooth_BluetoothUuid$parseUuidFrom(byte[] ), 0, (byte[])byArray);
    }

    public static boolean is16BitUuid(ParcelUuid parcelUuid) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("is16BitUuid", $$robo$$android_bluetooth_BluetoothUuid$is16BitUuid(android.os.ParcelUuid ), 0, (ParcelUuid)parcelUuid);
    }

    public static boolean is32BitUuid(ParcelUuid parcelUuid) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("is32BitUuid", $$robo$$android_bluetooth_BluetoothUuid$is32BitUuid(android.os.ParcelUuid ), 0, (ParcelUuid)parcelUuid);
    }

    static {
        RobolectricInternals.classInitializing(BluetoothUuid.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BluetoothUuid)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

