/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothAvrcpPlayerSettings;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.IBluetoothAvrcpController;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.media.MediaMetadata;
import android.media.session.PlaybackState;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class BluetoothAvrcpController
implements BluetoothProfile,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "BluetoothAvrcpController";
    private static boolean DBG = false;
    private static boolean VDBG = false;
    public static String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.avrcp-controller.profile.action.CONNECTION_STATE_CHANGED";
    public static String ACTION_TRACK_EVENT = "android.bluetooth.avrcp-controller.profile.action.TRACK_EVENT";
    public static String ACTION_PLAYER_SETTING = "android.bluetooth.avrcp-controller.profile.action.PLAYER_SETTING";
    public static String EXTRA_METADATA = "android.bluetooth.avrcp-controller.profile.extra.METADATA";
    public static String EXTRA_PLAYBACK = "android.bluetooth.avrcp-controller.profile.extra.PLAYBACK";
    public static String EXTRA_PLAYER_SETTING = "android.bluetooth.avrcp-controller.profile.extra.PLAYER_SETTING";
    public static int PASS_THRU_CMD_ID_PLAY = 68;
    public static int PASS_THRU_CMD_ID_PAUSE = 70;
    public static int PASS_THRU_CMD_ID_VOL_UP = 65;
    public static int PASS_THRU_CMD_ID_VOL_DOWN = 66;
    public static int PASS_THRU_CMD_ID_STOP = 69;
    public static int PASS_THRU_CMD_ID_FF = 73;
    public static int PASS_THRU_CMD_ID_REWIND = 72;
    public static int PASS_THRU_CMD_ID_FORWARD = 75;
    public static int PASS_THRU_CMD_ID_BACKWARD = 76;
    public static int KEY_STATE_PRESSED = 0;
    public static int KEY_STATE_RELEASED = 1;
    public static int PASS_THRU_CMD_ID_NEXT_GRP = 0;
    public static int PASS_THRU_CMD_ID_PREV_GRP = 1;
    private Context mContext;
    private BluetoothProfile.ServiceListener mServiceListener;
    private IBluetoothAvrcpController mService;
    private BluetoothAdapter mAdapter;
    private IBluetoothStateChangeCallback mBluetoothStateChangeCallback;
    private ServiceConnection mConnection;

    private void $$robo$$android_bluetooth_BluetoothAvrcpController$__constructor__(Context context, BluetoothProfile.ServiceListener l) {
        this.mBluetoothStateChangeCallback = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ BluetoothAvrcpController this$0;

            private void $$robo$$android_bluetooth_BluetoothAvrcpController_1$__constructor__(BluetoothAvrcpController this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_BluetoothAvrcpController_1$onBluetoothStateChange(boolean up) {
                if (!up) {
                    ServiceConnection serviceConnection = this.this$0.mConnection;
                    synchronized (serviceConnection) {
                        try {
                            this.this$0.mService = null;
                            this.this$0.mContext.unbindService(this.this$0.mConnection);
                        }
                        catch (Exception re) {
                            Log.e("BluetoothAvrcpController", "", re);
                        }
                    }
                }
                ServiceConnection serviceConnection = this.this$0.mConnection;
                synchronized (serviceConnection) {
                    try {
                        if (this.this$0.mService == null) {
                            this.this$0.doBind();
                        }
                    }
                    catch (Exception re) {
                        Log.e("BluetoothAvrcpController", "", re);
                    }
                }
            }

            private void __constructor__(BluetoothAvrcpController bluetoothAvrcpController) {
                this.$$robo$$android_bluetooth_BluetoothAvrcpController_1$__constructor__(bluetoothAvrcpController);
            }
            {
                this.this$0 = bluetoothAvrcpController;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothAvrcpController_1$__constructor__(android.bluetooth.BluetoothAvrcpController ), 0, this, bluetoothAvrcpController);
            }

            @Override
            public void onBluetoothStateChange(boolean bl) {
                InvokeDynamicSupport.bootstrap("onBluetoothStateChange", $$robo$$android_bluetooth_BluetoothAvrcpController_1$onBluetoothStateChange(boolean ), 0, this, bl);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mConnection = new ServiceConnection(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ BluetoothAvrcpController this$0;

            private void $$robo$$android_bluetooth_BluetoothAvrcpController_2$__constructor__(BluetoothAvrcpController this$0) {
            }

            private final void $$robo$$android_bluetooth_BluetoothAvrcpController_2$onServiceConnected(ComponentName className, IBinder service) {
                this.this$0.mService = IBluetoothAvrcpController.Stub.asInterface(service);
                if (this.this$0.mServiceListener != null) {
                    this.this$0.mServiceListener.onServiceConnected(12, this.this$0);
                }
            }

            private final void $$robo$$android_bluetooth_BluetoothAvrcpController_2$onServiceDisconnected(ComponentName className) {
                this.this$0.mService = null;
                if (this.this$0.mServiceListener != null) {
                    this.this$0.mServiceListener.onServiceDisconnected(12);
                }
            }

            private void __constructor__(BluetoothAvrcpController bluetoothAvrcpController) {
                this.$$robo$$android_bluetooth_BluetoothAvrcpController_2$__constructor__(bluetoothAvrcpController);
            }
            {
                this.this$0 = bluetoothAvrcpController;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothAvrcpController_2$__constructor__(android.bluetooth.BluetoothAvrcpController ), 0, this, bluetoothAvrcpController);
            }

            @Override
            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$android_bluetooth_BluetoothAvrcpController_2$onServiceConnected(android.content.ComponentName android.os.IBinder ), 0, this, componentName, iBinder);
            }

            @Override
            public void onServiceDisconnected(ComponentName componentName) {
                InvokeDynamicSupport.bootstrap("onServiceDisconnected", $$robo$$android_bluetooth_BluetoothAvrcpController_2$onServiceDisconnected(android.content.ComponentName ), 0, this, componentName);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mContext = context;
        this.mServiceListener = l;
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.registerStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (RemoteException e) {
                Log.e("BluetoothAvrcpController", "", e);
            }
        }
        this.doBind();
    }

    private final boolean $$robo$$android_bluetooth_BluetoothAvrcpController$doBind() {
        Intent intent = new Intent(IBluetoothAvrcpController.class.getName());
        ComponentName comp = intent.resolveSystemService(this.mContext.getPackageManager(), 0);
        intent.setComponent(comp);
        if (comp == null || !this.mContext.bindServiceAsUser(intent, this.mConnection, 0, Process.myUserHandle())) {
            Log.e("BluetoothAvrcpController", "Could not bind to Bluetooth AVRCP Controller Service with " + intent);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_bluetooth_BluetoothAvrcpController$close() {
        this.mServiceListener = null;
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.unregisterStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (Exception e) {
                Log.e("BluetoothAvrcpController", "", e);
            }
        }
        ServiceConnection serviceConnection = this.mConnection;
        synchronized (serviceConnection) {
            if (this.mService != null) {
                try {
                    this.mService = null;
                    this.mContext.unbindService(this.mConnection);
                }
                catch (Exception re) {
                    Log.e("BluetoothAvrcpController", "", re);
                }
            }
        }
    }

    private final void $$robo$$android_bluetooth_BluetoothAvrcpController$finalize() {
        this.close();
    }

    private final List<BluetoothDevice> $$robo$$android_bluetooth_BluetoothAvrcpController$getConnectedDevices() {
        if (this.mService != null && this.isEnabled()) {
            try {
                return this.mService.getConnectedDevices();
            }
            catch (RemoteException e) {
                Log.e("BluetoothAvrcpController", "Stack:" + Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothAvrcpController", "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    private final List<BluetoothDevice> $$robo$$android_bluetooth_BluetoothAvrcpController$getDevicesMatchingConnectionStates(int[] states) {
        if (this.mService != null && this.isEnabled()) {
            try {
                return this.mService.getDevicesMatchingConnectionStates(states);
            }
            catch (RemoteException e) {
                Log.e("BluetoothAvrcpController", "Stack:" + Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothAvrcpController", "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    private final int $$robo$$android_bluetooth_BluetoothAvrcpController$getConnectionState(BluetoothDevice device) {
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            try {
                return this.mService.getConnectionState(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothAvrcpController", "Stack:" + Log.getStackTraceString(new Throwable()));
                return 0;
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothAvrcpController", "Proxy not attached to service");
        }
        return 0;
    }

    private final void $$robo$$android_bluetooth_BluetoothAvrcpController$sendPassThroughCmd(BluetoothDevice device, int keyCode, int keyState) {
        if (this.mService != null && this.isEnabled()) {
            try {
                this.mService.sendPassThroughCmd(device, keyCode, keyState);
                return;
            }
            catch (RemoteException e) {
                Log.e("BluetoothAvrcpController", "Error talking to BT service in sendPassThroughCmd()", e);
                return;
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothAvrcpController", "Proxy not attached to service");
        }
    }

    private final BluetoothAvrcpPlayerSettings $$robo$$android_bluetooth_BluetoothAvrcpController$getPlayerSettings(BluetoothDevice device) {
        BluetoothAvrcpPlayerSettings settings = null;
        if (this.mService != null && this.isEnabled()) {
            try {
                settings = this.mService.getPlayerSettings(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothAvrcpController", "Error talking to BT service in getMetadata() " + e);
                return null;
            }
        }
        return settings;
    }

    private final MediaMetadata $$robo$$android_bluetooth_BluetoothAvrcpController$getMetadata(BluetoothDevice device) {
        MediaMetadata metadata = null;
        if (this.mService != null && this.isEnabled()) {
            try {
                metadata = this.mService.getMetadata(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothAvrcpController", "Error talking to BT service in getMetadata() " + e);
                return null;
            }
        }
        return metadata;
    }

    private final PlaybackState $$robo$$android_bluetooth_BluetoothAvrcpController$getPlaybackState(BluetoothDevice device) {
        PlaybackState playbackState = null;
        if (this.mService != null && this.isEnabled()) {
            try {
                playbackState = this.mService.getPlaybackState(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothAvrcpController", "Error talking to BT service in getPlaybackState() " + e);
                return null;
            }
        }
        return playbackState;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothAvrcpController$setPlayerApplicationSetting(BluetoothAvrcpPlayerSettings plAppSetting) {
        if (this.mService != null && this.isEnabled()) {
            try {
                return this.mService.setPlayerApplicationSetting(plAppSetting);
            }
            catch (RemoteException e) {
                Log.e("BluetoothAvrcpController", "Error talking to BT service in setPlayerApplicationSetting() " + e);
                return false;
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothAvrcpController", "Proxy not attached to service");
        }
        return false;
    }

    private final void $$robo$$android_bluetooth_BluetoothAvrcpController$sendGroupNavigationCmd(BluetoothDevice device, int keyCode, int keyState) {
        Log.d("BluetoothAvrcpController", "sendGroupNavigationCmd dev = " + device + " key " + keyCode + " State = " + keyState);
        if (this.mService != null && this.isEnabled()) {
            try {
                this.mService.sendGroupNavigationCmd(device, keyCode, keyState);
                return;
            }
            catch (RemoteException e) {
                Log.e("BluetoothAvrcpController", "Error talking to BT service in sendGroupNavigationCmd()", e);
                return;
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothAvrcpController", "Proxy not attached to service");
        }
    }

    private final boolean $$robo$$android_bluetooth_BluetoothAvrcpController$isEnabled() {
        return this.mAdapter.getState() == 12;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothAvrcpController$isValidDevice(BluetoothDevice device) {
        if (device == null) {
            return false;
        }
        return BluetoothAdapter.checkBluetoothAddress(device.getAddress());
    }

    private static final void $$robo$$android_bluetooth_BluetoothAvrcpController$log(String msg) {
        Log.d("BluetoothAvrcpController", msg);
    }

    private void __constructor__(Context context, BluetoothProfile.ServiceListener serviceListener) {
        this.$$robo$$android_bluetooth_BluetoothAvrcpController$__constructor__(context, serviceListener);
    }

    BluetoothAvrcpController(Context context, BluetoothProfile.ServiceListener serviceListener) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothAvrcpController$__constructor__(android.content.Context android.bluetooth.BluetoothProfile$ServiceListener ), 0, this, context, serviceListener);
    }

    boolean doBind() {
        return (boolean)InvokeDynamicSupport.bootstrap("doBind", $$robo$$android_bluetooth_BluetoothAvrcpController$doBind(), 0, this);
    }

    void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_bluetooth_BluetoothAvrcpController$close(), 0, this);
    }

    public void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_bluetooth_BluetoothAvrcpController$finalize(), 0, this);
    }

    @Override
    public List<BluetoothDevice> getConnectedDevices() {
        return InvokeDynamicSupport.bootstrap("getConnectedDevices", $$robo$$android_bluetooth_BluetoothAvrcpController$getConnectedDevices(), 0, this);
    }

    @Override
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] nArray) {
        return InvokeDynamicSupport.bootstrap("getDevicesMatchingConnectionStates", $$robo$$android_bluetooth_BluetoothAvrcpController$getDevicesMatchingConnectionStates(int[] ), 0, this, nArray);
    }

    @Override
    public int getConnectionState(BluetoothDevice bluetoothDevice) {
        return (int)InvokeDynamicSupport.bootstrap("getConnectionState", $$robo$$android_bluetooth_BluetoothAvrcpController$getConnectionState(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public void sendPassThroughCmd(BluetoothDevice bluetoothDevice, int n, int n2) {
        InvokeDynamicSupport.bootstrap("sendPassThroughCmd", $$robo$$android_bluetooth_BluetoothAvrcpController$sendPassThroughCmd(android.bluetooth.BluetoothDevice int int ), 0, this, bluetoothDevice, n, n2);
    }

    public BluetoothAvrcpPlayerSettings getPlayerSettings(BluetoothDevice bluetoothDevice) {
        return InvokeDynamicSupport.bootstrap("getPlayerSettings", $$robo$$android_bluetooth_BluetoothAvrcpController$getPlayerSettings(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public MediaMetadata getMetadata(BluetoothDevice bluetoothDevice) {
        return InvokeDynamicSupport.bootstrap("getMetadata", $$robo$$android_bluetooth_BluetoothAvrcpController$getMetadata(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public PlaybackState getPlaybackState(BluetoothDevice bluetoothDevice) {
        return InvokeDynamicSupport.bootstrap("getPlaybackState", $$robo$$android_bluetooth_BluetoothAvrcpController$getPlaybackState(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public boolean setPlayerApplicationSetting(BluetoothAvrcpPlayerSettings bluetoothAvrcpPlayerSettings) {
        return (boolean)InvokeDynamicSupport.bootstrap("setPlayerApplicationSetting", $$robo$$android_bluetooth_BluetoothAvrcpController$setPlayerApplicationSetting(android.bluetooth.BluetoothAvrcpPlayerSettings ), 0, this, bluetoothAvrcpPlayerSettings);
    }

    public void sendGroupNavigationCmd(BluetoothDevice bluetoothDevice, int n, int n2) {
        InvokeDynamicSupport.bootstrap("sendGroupNavigationCmd", $$robo$$android_bluetooth_BluetoothAvrcpController$sendGroupNavigationCmd(android.bluetooth.BluetoothDevice int int ), 0, this, bluetoothDevice, n, n2);
    }

    private boolean isEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_bluetooth_BluetoothAvrcpController$isEnabled(), 0, this);
    }

    private boolean isValidDevice(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("isValidDevice", $$robo$$android_bluetooth_BluetoothAvrcpController$isValidDevice(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    private static void log(String string2) {
        InvokeDynamicSupport.bootstrapStatic("log", $$robo$$android_bluetooth_BluetoothAvrcpController$log(java.lang.String ), 0, (String)string2);
    }

    public /* synthetic */ BluetoothAvrcpController() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BluetoothAvrcpController)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

