/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import android.app.WallpaperManager;
import android.app.backup.BackupDataInputStream;
import android.app.backup.BackupDataOutput;
import android.app.backup.BackupHelper;
import android.app.backup.FileBackupHelperBase;
import android.content.Context;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.util.Slog;
import android.view.Display;
import android.view.WindowManager;
import java.io.File;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class WallpaperBackupHelper
extends FileBackupHelperBase
implements BackupHelper,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "WallpaperBackupHelper";
    private static boolean DEBUG = false;
    private static boolean REJECT_OUTSIZED_RESTORE = true;
    private static double MAX_HEIGHT_RATIO = 1.35;
    private static double MIN_HEIGHT_RATIO = 0.0;
    public static String WALLPAPER_IMAGE;
    public static String WALLPAPER_INFO;
    public static String WALLPAPER_IMAGE_KEY = "/data/data/com.android.settings/files/wallpaper";
    public static String WALLPAPER_INFO_KEY = "/data/system/wallpaper_info.xml";
    private static String STAGE_FILE;
    Context mContext;
    String[] mFiles;
    String[] mKeys;
    double mDesiredMinWidth;
    double mDesiredMinHeight;

    private void $$robo$$android_app_backup_WallpaperBackupHelper$__constructor__(Context context, String[] files, String[] keys) {
        this.mContext = context;
        this.mFiles = files;
        this.mKeys = keys;
        WindowManager wm = (WindowManager)context.getSystemService("window");
        WallpaperManager wpm = (WallpaperManager)context.getSystemService("wallpaper");
        Display d = wm.getDefaultDisplay();
        Point size = new Point();
        d.getSize(size);
        this.mDesiredMinWidth = Math.min(size.x, size.y);
        this.mDesiredMinHeight = wpm.getDesiredMinimumHeight();
        if (this.mDesiredMinHeight <= 0.0) {
            this.mDesiredMinHeight = size.y;
        }
    }

    private final void $$robo$$android_app_backup_WallpaperBackupHelper$performBackup(ParcelFileDescriptor oldState, BackupDataOutput data, ParcelFileDescriptor newState) {
        WallpaperBackupHelper.performBackup_checked(oldState, data, newState, this.mFiles, this.mKeys);
    }

    private final void $$robo$$android_app_backup_WallpaperBackupHelper$restoreEntity(BackupDataInputStream data) {
        String key = data.getKey();
        if (this.isKeyInList(key, this.mKeys)) {
            if (key.equals("/data/data/com.android.settings/files/wallpaper")) {
                File f = new File(STAGE_FILE);
                if (this.writeFile(f, data)) {
                    BitmapFactory.Options options = new BitmapFactory.Options();
                    options.inJustDecodeBounds = true;
                    BitmapFactory.decodeFile(STAGE_FILE, options);
                    double heightRatio = this.mDesiredMinHeight / (double)options.outHeight;
                    if ((double)options.outWidth < this.mDesiredMinWidth || (double)options.outHeight < this.mDesiredMinWidth || heightRatio >= 1.35 || heightRatio <= 0.0) {
                        Slog.i("WallpaperBackupHelper", "Restored image dimensions (w=" + options.outWidth + ", h=" + options.outHeight + ") too far off target (tw=" + this.mDesiredMinWidth + ", th=" + this.mDesiredMinHeight + "); falling back to default wallpaper.");
                        f.delete();
                        return;
                    }
                }
            } else if (key.equals("/data/system/wallpaper_info.xml")) {
                File f = new File(WALLPAPER_INFO);
                this.writeFile(f, data);
            }
        }
    }

    private final void $$robo$$android_app_backup_WallpaperBackupHelper$onRestoreFinished() {
        File f = new File(STAGE_FILE);
        if (f.exists()) {
            Slog.d("WallpaperBackupHelper", "Applying restored wallpaper image.");
            f.renameTo(new File(WALLPAPER_IMAGE));
        }
    }

    static void __staticInitializer__() {
        WALLPAPER_IMAGE = new File(Environment.getUserSystemDirectory(0), "wallpaper").getAbsolutePath();
        WALLPAPER_INFO = new File(Environment.getUserSystemDirectory(0), "wallpaper_info.xml").getAbsolutePath();
        STAGE_FILE = new File(Environment.getUserSystemDirectory(0), "wallpaper-tmp").getAbsolutePath();
    }

    private void __constructor__(Context context, String[] stringArray, String[] stringArray2) {
        this.$$robo$$android_app_backup_WallpaperBackupHelper$__constructor__(context, stringArray, stringArray2);
    }

    public WallpaperBackupHelper(Context context, String[] stringArray, String[] stringArray2) {
        super(context);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_backup_WallpaperBackupHelper$__constructor__(android.content.Context java.lang.String[] java.lang.String[] ), 0, this, context, stringArray, stringArray2);
    }

    @Override
    public void performBackup(ParcelFileDescriptor parcelFileDescriptor, BackupDataOutput backupDataOutput, ParcelFileDescriptor parcelFileDescriptor2) {
        InvokeDynamicSupport.bootstrap("performBackup", $$robo$$android_app_backup_WallpaperBackupHelper$performBackup(android.os.ParcelFileDescriptor android.app.backup.BackupDataOutput android.os.ParcelFileDescriptor ), 0, this, parcelFileDescriptor, backupDataOutput, parcelFileDescriptor2);
    }

    @Override
    public void restoreEntity(BackupDataInputStream backupDataInputStream) {
        InvokeDynamicSupport.bootstrap("restoreEntity", $$robo$$android_app_backup_WallpaperBackupHelper$restoreEntity(android.app.backup.BackupDataInputStream ), 0, this, backupDataInputStream);
    }

    public void onRestoreFinished() {
        InvokeDynamicSupport.bootstrap("onRestoreFinished", $$robo$$android_app_backup_WallpaperBackupHelper$onRestoreFinished(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(WallpaperBackupHelper.class);
    }

    public /* synthetic */ WallpaperBackupHelper() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WallpaperBackupHelper)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

