/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import android.app.backup.BackupDataInputStream;
import android.app.backup.BackupDataOutput;
import android.app.backup.BackupHelper;
import android.os.ParcelFileDescriptor;
import android.util.ArrayMap;
import android.util.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class BlobBackupHelper
implements BackupHelper,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "BlobBackupHelper";
    private static boolean DEBUG = false;
    private int mCurrentBlobVersion;
    private String[] mKeys;

    private void $$robo$$android_app_backup_BlobBackupHelper$__constructor__(int currentBlobVersion, String ... keys) {
        this.mCurrentBlobVersion = currentBlobVersion;
        this.mKeys = keys;
    }

    protected abstract byte[] getBackupPayload(String var1);

    protected abstract void applyRestoredPayload(String var1, byte[] var2);

    private final ArrayMap<String, Long> $$robo$$android_app_backup_BlobBackupHelper$readOldState(ParcelFileDescriptor oldStateFd) {
        ArrayMap<String, Long> state = new ArrayMap<String, Long>();
        FileInputStream fis = new FileInputStream(oldStateFd.getFileDescriptor());
        DataInputStream in = new DataInputStream(fis);
        try {
            int version = in.readInt();
            if (version <= this.mCurrentBlobVersion) {
                int numKeys = in.readInt();
                for (int i = 0; i < numKeys; ++i) {
                    String key = in.readUTF();
                    long checksum = in.readLong();
                    state.put(key, checksum);
                }
            } else {
                Log.w("BlobBackupHelper", "Prior state from unrecognized version " + version);
            }
        }
        catch (EOFException e) {
            state.clear();
        }
        catch (Exception e) {
            Log.e("BlobBackupHelper", "Error examining prior backup state " + e.getMessage());
            state.clear();
        }
        return state;
    }

    private final void $$robo$$android_app_backup_BlobBackupHelper$writeBackupState(ArrayMap<String, Long> state, ParcelFileDescriptor stateFile) {
        try {
            FileOutputStream fos = new FileOutputStream(stateFile.getFileDescriptor());
            DataOutputStream out = new DataOutputStream(fos);
            out.writeInt(this.mCurrentBlobVersion);
            int N = state != null ? state.size() : 0;
            out.writeInt(N);
            for (int i = 0; i < N; ++i) {
                String key = state.keyAt(i);
                long checksum = state.valueAt(i);
                out.writeUTF(key);
                out.writeLong(checksum);
            }
        }
        catch (IOException e) {
            Log.e("BlobBackupHelper", "Unable to write updated state", e);
        }
    }

    private final byte[] $$robo$$android_app_backup_BlobBackupHelper$deflate(byte[] data) {
        byte[] result = null;
        if (data != null) {
            try {
                ByteArrayOutputStream sink = new ByteArrayOutputStream();
                DataOutputStream headerOut = new DataOutputStream(sink);
                headerOut.writeInt(this.mCurrentBlobVersion);
                DeflaterOutputStream out = new DeflaterOutputStream(sink);
                out.write(data);
                out.close();
                result = sink.toByteArray();
            }
            catch (IOException e) {
                Log.w("BlobBackupHelper", "Unable to process payload: " + e.getMessage());
            }
        }
        return result;
    }

    private final byte[] $$robo$$android_app_backup_BlobBackupHelper$inflate(byte[] compressedData) {
        byte[] result = null;
        if (compressedData != null) {
            try {
                int nRead;
                ByteArrayInputStream source = new ByteArrayInputStream(compressedData);
                DataInputStream headerIn = new DataInputStream(source);
                int version = headerIn.readInt();
                if (version > this.mCurrentBlobVersion) {
                    Log.w("BlobBackupHelper", "Saved payload from unrecognized version " + version);
                    return null;
                }
                InflaterInputStream in = new InflaterInputStream(source);
                ByteArrayOutputStream inflated = new ByteArrayOutputStream();
                byte[] buffer = new byte[4096];
                while ((nRead = in.read(buffer)) > 0) {
                    inflated.write(buffer, 0, nRead);
                }
                in.close();
                inflated.flush();
                result = inflated.toByteArray();
            }
            catch (IOException e) {
                Log.w("BlobBackupHelper", "Unable to process restored payload: " + e.getMessage());
            }
        }
        return result;
    }

    private final long $$robo$$android_app_backup_BlobBackupHelper$checksum(byte[] buffer) {
        if (buffer != null) {
            try {
                CRC32 crc = new CRC32();
                ByteArrayInputStream bis = new ByteArrayInputStream(buffer);
                byte[] buf = new byte[4096];
                int nRead = 0;
                while ((nRead = bis.read(buf)) >= 0) {
                    crc.update(buf, 0, nRead);
                }
                return crc.getValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_backup_BlobBackupHelper$performBackup(ParcelFileDescriptor oldStateFd, BackupDataOutput data, ParcelFileDescriptor newStateFd) {
        ArrayMap<String, Long> oldState = this.readOldState(oldStateFd);
        ArrayMap<String, Long> newState = new ArrayMap<String, Long>();
        try {
            for (String key : this.mKeys) {
                byte[] payload = this.deflate(this.getBackupPayload(key));
                long checksum = this.checksum(payload);
                newState.put(key, checksum);
                Long oldChecksum = oldState.get(key);
                if (oldChecksum != null && checksum == oldChecksum) continue;
                if (payload != null) {
                    data.writeEntityHeader(key, payload.length);
                    data.writeEntityData(payload, payload.length);
                    continue;
                }
                data.writeEntityHeader(key, -1);
            }
        }
        catch (Exception e) {
            Log.w("BlobBackupHelper", "Unable to record notification state: " + e.getMessage());
            newState.clear();
        }
        finally {
            this.writeBackupState(newState, newStateFd);
        }
    }

    private final void $$robo$$android_app_backup_BlobBackupHelper$restoreEntity(BackupDataInputStream data) {
        String key = data.getKey();
        try {
            int which;
            for (which = 0; which < this.mKeys.length && !key.equals(this.mKeys[which]); ++which) {
            }
            if (which >= this.mKeys.length) {
                Log.e("BlobBackupHelper", "Unrecognized key " + key + ", ignoring");
                return;
            }
            byte[] compressed = new byte[data.size()];
            data.read(compressed);
            byte[] payload = this.inflate(compressed);
            this.applyRestoredPayload(key, payload);
        }
        catch (Exception e) {
            Log.e("BlobBackupHelper", "Exception restoring entity " + key + " : " + e.getMessage());
        }
    }

    private final void $$robo$$android_app_backup_BlobBackupHelper$writeNewStateDescription(ParcelFileDescriptor newState) {
        this.writeBackupState(null, newState);
    }

    private void __constructor__(int n, String ... stringArray) {
        this.$$robo$$android_app_backup_BlobBackupHelper$__constructor__(n, stringArray);
    }

    public BlobBackupHelper(int n, String ... stringArray) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_backup_BlobBackupHelper$__constructor__(int java.lang.String[] ), 0, this, n, stringArray);
    }

    private ArrayMap<String, Long> readOldState(ParcelFileDescriptor parcelFileDescriptor) {
        return InvokeDynamicSupport.bootstrap("readOldState", $$robo$$android_app_backup_BlobBackupHelper$readOldState(android.os.ParcelFileDescriptor ), 0, this, parcelFileDescriptor);
    }

    private void writeBackupState(ArrayMap<String, Long> arrayMap, ParcelFileDescriptor parcelFileDescriptor) {
        InvokeDynamicSupport.bootstrap("writeBackupState", $$robo$$android_app_backup_BlobBackupHelper$writeBackupState(android.util.ArrayMap<java.lang.String, java.lang.Long> android.os.ParcelFileDescriptor ), 0, this, arrayMap, parcelFileDescriptor);
    }

    private byte[] deflate(byte[] byArray) {
        return InvokeDynamicSupport.bootstrap("deflate", $$robo$$android_app_backup_BlobBackupHelper$deflate(byte[] ), 0, this, byArray);
    }

    private byte[] inflate(byte[] byArray) {
        return InvokeDynamicSupport.bootstrap("inflate", $$robo$$android_app_backup_BlobBackupHelper$inflate(byte[] ), 0, this, byArray);
    }

    private long checksum(byte[] byArray) {
        return (long)InvokeDynamicSupport.bootstrap("checksum", $$robo$$android_app_backup_BlobBackupHelper$checksum(byte[] ), 0, this, byArray);
    }

    @Override
    public void performBackup(ParcelFileDescriptor parcelFileDescriptor, BackupDataOutput backupDataOutput, ParcelFileDescriptor parcelFileDescriptor2) {
        InvokeDynamicSupport.bootstrap("performBackup", $$robo$$android_app_backup_BlobBackupHelper$performBackup(android.os.ParcelFileDescriptor android.app.backup.BackupDataOutput android.os.ParcelFileDescriptor ), 0, this, parcelFileDescriptor, backupDataOutput, parcelFileDescriptor2);
    }

    @Override
    public void restoreEntity(BackupDataInputStream backupDataInputStream) {
        InvokeDynamicSupport.bootstrap("restoreEntity", $$robo$$android_app_backup_BlobBackupHelper$restoreEntity(android.app.backup.BackupDataInputStream ), 0, this, backupDataInputStream);
    }

    @Override
    public void writeNewStateDescription(ParcelFileDescriptor parcelFileDescriptor) {
        InvokeDynamicSupport.bootstrap("writeNewStateDescription", $$robo$$android_app_backup_BlobBackupHelper$writeNewStateDescription(android.os.ParcelFileDescriptor ), 0, this, parcelFileDescriptor);
    }

    public /* synthetic */ BlobBackupHelper() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BlobBackupHelper)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

