/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import android.app.backup.BackupObserver;
import android.app.backup.BackupProgress;
import android.app.backup.IBackupManager;
import android.app.backup.IBackupObserver;
import android.app.backup.IRestoreSession;
import android.app.backup.RestoreObserver;
import android.app.backup.RestoreSession;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import android.util.Pair;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class BackupManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "BackupManager";
    public static int SUCCESS = 0;
    public static int ERROR_BACKUP_NOT_ALLOWED = -2001;
    public static int ERROR_PACKAGE_NOT_FOUND = -2002;
    public static int ERROR_TRANSPORT_ABORTED = -1000;
    public static int ERROR_TRANSPORT_PACKAGE_REJECTED = -1002;
    public static int ERROR_TRANSPORT_QUOTA_EXCEEDED = -1005;
    public static int ERROR_AGENT_FAILURE = -1003;
    private Context mContext;
    private static IBackupManager sService;

    private static final void $$robo$$android_app_backup_BackupManager$checkServiceBinder() {
        if (sService == null) {
            sService = IBackupManager.Stub.asInterface(ServiceManager.getService("backup"));
        }
    }

    private void $$robo$$android_app_backup_BackupManager$__constructor__(Context context) {
        this.mContext = context;
    }

    private final void $$robo$$android_app_backup_BackupManager$dataChanged() {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                sService.dataChanged(this.mContext.getPackageName());
            }
            catch (RemoteException e) {
                Log.d("BackupManager", "dataChanged() couldn't connect");
            }
        }
    }

    private static final void $$robo$$android_app_backup_BackupManager$dataChanged(String packageName) {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                sService.dataChanged(packageName);
            }
            catch (RemoteException e) {
                Log.e("BackupManager", "dataChanged(pkg) couldn't connect");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_app_backup_BackupManager$requestRestore(RestoreObserver observer) {
        int result = -1;
        BackupManager.checkServiceBinder();
        if (sService != null) {
            RestoreSession session = null;
            try {
                IRestoreSession binder = sService.beginRestoreSession(this.mContext.getPackageName(), null);
                if (binder != null) {
                    session = new RestoreSession(this.mContext, binder);
                    result = session.restorePackage(this.mContext.getPackageName(), observer);
                }
            }
            catch (RemoteException e) {
                Log.e("BackupManager", "restoreSelf() unable to contact service");
            }
            finally {
                if (session != null) {
                    session.endRestoreSession();
                }
            }
        }
        return result;
    }

    private final RestoreSession $$robo$$android_app_backup_BackupManager$beginRestoreSession() {
        RestoreSession session = null;
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                IRestoreSession binder = sService.beginRestoreSession(null, null);
                if (binder != null) {
                    session = new RestoreSession(this.mContext, binder);
                }
            }
            catch (RemoteException e) {
                Log.e("BackupManager", "beginRestoreSession() couldn't connect");
            }
        }
        return session;
    }

    private final void $$robo$$android_app_backup_BackupManager$setBackupEnabled(boolean isEnabled) {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                sService.setBackupEnabled(isEnabled);
            }
            catch (RemoteException e) {
                Log.e("BackupManager", "setBackupEnabled() couldn't connect");
            }
        }
    }

    private final boolean $$robo$$android_app_backup_BackupManager$isBackupEnabled() {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                return sService.isBackupEnabled();
            }
            catch (RemoteException e) {
                Log.e("BackupManager", "isBackupEnabled() couldn't connect");
            }
        }
        return false;
    }

    private final void $$robo$$android_app_backup_BackupManager$setAutoRestore(boolean isEnabled) {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                sService.setAutoRestore(isEnabled);
            }
            catch (RemoteException e) {
                Log.e("BackupManager", "setAutoRestore() couldn't connect");
            }
        }
    }

    private final String $$robo$$android_app_backup_BackupManager$getCurrentTransport() {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                return sService.getCurrentTransport();
            }
            catch (RemoteException e) {
                Log.e("BackupManager", "getCurrentTransport() couldn't connect");
            }
        }
        return null;
    }

    private final String[] $$robo$$android_app_backup_BackupManager$listAllTransports() {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                return sService.listAllTransports();
            }
            catch (RemoteException e) {
                Log.e("BackupManager", "listAllTransports() couldn't connect");
            }
        }
        return null;
    }

    private final String $$robo$$android_app_backup_BackupManager$selectBackupTransport(String transport) {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                return sService.selectBackupTransport(transport);
            }
            catch (RemoteException e) {
                Log.e("BackupManager", "selectBackupTransport() couldn't connect");
            }
        }
        return null;
    }

    private final void $$robo$$android_app_backup_BackupManager$backupNow() {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                sService.backupNow();
            }
            catch (RemoteException e) {
                Log.e("BackupManager", "backupNow() couldn't connect");
            }
        }
    }

    private final long $$robo$$android_app_backup_BackupManager$getAvailableRestoreToken(String packageName) {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                return sService.getAvailableRestoreToken(packageName);
            }
            catch (RemoteException e) {
                Log.e("BackupManager", "getAvailableRestoreToken() couldn't connect");
            }
        }
        return 0L;
    }

    private final boolean $$robo$$android_app_backup_BackupManager$isAppEligibleForBackup(String packageName) {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                return sService.isAppEligibleForBackup(packageName);
            }
            catch (RemoteException e) {
                Log.e("BackupManager", "isAppEligibleForBackup(pkg) couldn't connect");
            }
        }
        return false;
    }

    private final int $$robo$$android_app_backup_BackupManager$requestBackup(String[] packages, BackupObserver observer) {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                BackupObserverWrapper observerWrapper = observer == null ? null : new BackupObserverWrapper(this, this.mContext, observer);
                return sService.requestBackup(packages, observerWrapper);
            }
            catch (RemoteException e) {
                Log.e("BackupManager", "requestBackup() couldn't connect");
            }
        }
        return -1;
    }

    private static void checkServiceBinder() {
        InvokeDynamicSupport.bootstrapStatic("checkServiceBinder", $$robo$$android_app_backup_BackupManager$checkServiceBinder(), 0);
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_app_backup_BackupManager$__constructor__(context);
    }

    public BackupManager(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_backup_BackupManager$__constructor__(android.content.Context ), 0, this, context);
    }

    public void dataChanged() {
        InvokeDynamicSupport.bootstrap("dataChanged", $$robo$$android_app_backup_BackupManager$dataChanged(), 0, this);
    }

    public static void dataChanged(String string2) {
        InvokeDynamicSupport.bootstrapStatic("dataChanged", $$robo$$android_app_backup_BackupManager$dataChanged(java.lang.String ), 0, (String)string2);
    }

    public int requestRestore(RestoreObserver restoreObserver) {
        return (int)InvokeDynamicSupport.bootstrap("requestRestore", $$robo$$android_app_backup_BackupManager$requestRestore(android.app.backup.RestoreObserver ), 0, this, restoreObserver);
    }

    public RestoreSession beginRestoreSession() {
        return InvokeDynamicSupport.bootstrap("beginRestoreSession", $$robo$$android_app_backup_BackupManager$beginRestoreSession(), 0, this);
    }

    public void setBackupEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setBackupEnabled", $$robo$$android_app_backup_BackupManager$setBackupEnabled(boolean ), 0, this, bl);
    }

    public boolean isBackupEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isBackupEnabled", $$robo$$android_app_backup_BackupManager$isBackupEnabled(), 0, this);
    }

    public void setAutoRestore(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAutoRestore", $$robo$$android_app_backup_BackupManager$setAutoRestore(boolean ), 0, this, bl);
    }

    public String getCurrentTransport() {
        return InvokeDynamicSupport.bootstrap("getCurrentTransport", $$robo$$android_app_backup_BackupManager$getCurrentTransport(), 0, this);
    }

    public String[] listAllTransports() {
        return InvokeDynamicSupport.bootstrap("listAllTransports", $$robo$$android_app_backup_BackupManager$listAllTransports(), 0, this);
    }

    public String selectBackupTransport(String string2) {
        return InvokeDynamicSupport.bootstrap("selectBackupTransport", $$robo$$android_app_backup_BackupManager$selectBackupTransport(java.lang.String ), 0, this, string2);
    }

    public void backupNow() {
        InvokeDynamicSupport.bootstrap("backupNow", $$robo$$android_app_backup_BackupManager$backupNow(), 0, this);
    }

    public long getAvailableRestoreToken(String string2) {
        return (long)InvokeDynamicSupport.bootstrap("getAvailableRestoreToken", $$robo$$android_app_backup_BackupManager$getAvailableRestoreToken(java.lang.String ), 0, this, string2);
    }

    public boolean isAppEligibleForBackup(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isAppEligibleForBackup", $$robo$$android_app_backup_BackupManager$isAppEligibleForBackup(java.lang.String ), 0, this, string2);
    }

    public int requestBackup(String[] stringArray, BackupObserver backupObserver) {
        return (int)InvokeDynamicSupport.bootstrap("requestBackup", $$robo$$android_app_backup_BackupManager$requestBackup(java.lang.String[] android.app.backup.BackupObserver ), 0, this, stringArray, backupObserver);
    }

    public /* synthetic */ BackupManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BackupManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class BackupObserverWrapper
    extends IBackupObserver.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        Handler mHandler;
        BackupObserver mObserver;
        static int MSG_UPDATE = 1;
        static int MSG_RESULT = 2;
        static int MSG_FINISHED = 3;
        /* synthetic */ BackupManager this$0;

        private void $$robo$$android_app_backup_BackupManager_BackupObserverWrapper$__constructor__(BackupManager backupManager, Context context, BackupObserver observer) {
            this.mHandler = new ShadowedObject(this, context.getMainLooper(), backupManager){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ BackupManager val$this$0;
                /* synthetic */ BackupObserverWrapper this$1;

                private void $$robo$$android_app_backup_BackupManager_BackupObserverWrapper_1$__constructor__(BackupObserverWrapper this$1, Looper looper, BackupManager backupManager) {
                }

                private final void $$robo$$android_app_backup_BackupManager_BackupObserverWrapper_1$handleMessage(Message msg) {
                    switch (msg.what) {
                        case 1: {
                            Pair obj = (Pair)msg.obj;
                            this.this$1.mObserver.onUpdate((String)obj.first, (BackupProgress)obj.second);
                            break;
                        }
                        case 2: {
                            this.this$1.mObserver.onResult((String)msg.obj, msg.arg1);
                            break;
                        }
                        case 3: {
                            this.this$1.mObserver.backupFinished(msg.arg1);
                            break;
                        }
                        default: {
                            Log.w("BackupManager", "Unknown message: " + msg);
                        }
                    }
                }

                private void __constructor__(BackupObserverWrapper backupObserverWrapper, Looper looper, BackupManager backupManager) {
                    this.$$robo$$android_app_backup_BackupManager_BackupObserverWrapper_1$__constructor__(backupObserverWrapper, looper, backupManager);
                }
                {
                    this.this$1 = backupObserverWrapper;
                    this.val$this$0 = backupManager;
                    super(looper);
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_backup_BackupManager_BackupObserverWrapper_1$__constructor__(android.app.backup.BackupManager$BackupObserverWrapper android.os.Looper android.app.backup.BackupManager ), 0, this, backupObserverWrapper, looper, backupManager);
                }

                @Override
                public void handleMessage(Message message) {
                    InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_app_backup_BackupManager_BackupObserverWrapper_1$handleMessage(android.os.Message ), 0, this, message);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mObserver = observer;
        }

        private final void $$robo$$android_app_backup_BackupManager_BackupObserverWrapper$onUpdate(String currentPackage, BackupProgress backupProgress) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(1, Pair.create(currentPackage, backupProgress)));
        }

        private final void $$robo$$android_app_backup_BackupManager_BackupObserverWrapper$onResult(String currentPackage, int status) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(2, status, 0, currentPackage));
        }

        private final void $$robo$$android_app_backup_BackupManager_BackupObserverWrapper$backupFinished(int status) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, status, 0));
        }

        private void __constructor__(BackupManager backupManager, Context context, BackupObserver backupObserver) {
            this.$$robo$$android_app_backup_BackupManager_BackupObserverWrapper$__constructor__(backupManager, context, backupObserver);
        }

        BackupObserverWrapper(BackupManager backupManager, Context context, BackupObserver backupObserver) {
            this.this$0 = backupManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_backup_BackupManager_BackupObserverWrapper$__constructor__(android.app.backup.BackupManager android.content.Context android.app.backup.BackupObserver ), 0, this, backupManager, context, backupObserver);
        }

        @Override
        public void onUpdate(String string2, BackupProgress backupProgress) {
            InvokeDynamicSupport.bootstrap("onUpdate", $$robo$$android_app_backup_BackupManager_BackupObserverWrapper$onUpdate(java.lang.String android.app.backup.BackupProgress ), 0, this, string2, backupProgress);
        }

        @Override
        public void onResult(String string2, int n) {
            InvokeDynamicSupport.bootstrap("onResult", $$robo$$android_app_backup_BackupManager_BackupObserverWrapper$onResult(java.lang.String int ), 0, this, string2, n);
        }

        @Override
        public void backupFinished(int n) {
            InvokeDynamicSupport.bootstrap("backupFinished", $$robo$$android_app_backup_BackupManager_BackupObserverWrapper$backupFinished(int ), 0, this, n);
        }

        public /* synthetic */ BackupObserverWrapper() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BackupObserverWrapper)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

