/*
 * Decompiled with CFR 0.152.
 */
package android.app.assist;

import android.app.Activity;
import android.content.ComponentName;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.os.BadParcelableException;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PooledStringReader;
import android.os.PooledStringWriter;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewRootImpl;
import android.view.ViewStructure;
import android.view.WindowManagerGlobal;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AssistStructure
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String TAG = "AssistStructure";
    static boolean DEBUG_PARCEL = false;
    static boolean DEBUG_PARCEL_CHILDREN = false;
    static boolean DEBUG_PARCEL_TREE = false;
    static int VALIDATE_WINDOW_TOKEN = 0x11111111;
    static int VALIDATE_VIEW_TOKEN = 0x22222222;
    boolean mHaveData;
    ComponentName mActivityComponent;
    ArrayList<WindowNode> mWindowNodes;
    ArrayList<ViewNodeBuilder> mPendingAsyncChildren;
    SendChannel mSendChannel;
    IBinder mReceiveChannel;
    Rect mTmpRect;
    static int TRANSACTION_XFER = 2;
    static String DESCRIPTOR = "android.app.AssistStructure";
    public static Parcelable.Creator<AssistStructure> CREATOR;

    private void $$robo$$android_app_assist_AssistStructure$__constructor__(Activity activity) {
        this.mWindowNodes = new ArrayList();
        this.mPendingAsyncChildren = new ArrayList();
        this.mTmpRect = new Rect();
        this.mHaveData = true;
        this.mActivityComponent = activity.getComponentName();
        ArrayList<ViewRootImpl> views = WindowManagerGlobal.getInstance().getRootViews(activity.getActivityToken());
        for (int i = 0; i < views.size(); ++i) {
            ViewRootImpl root = views.get(i);
            this.mWindowNodes.add(new WindowNode(this, root));
        }
    }

    private void $$robo$$android_app_assist_AssistStructure$__constructor__() {
        this.mWindowNodes = new ArrayList();
        this.mPendingAsyncChildren = new ArrayList();
        this.mTmpRect = new Rect();
        this.mHaveData = true;
        this.mActivityComponent = null;
    }

    private void $$robo$$android_app_assist_AssistStructure$__constructor__(Parcel in) {
        this.mWindowNodes = new ArrayList();
        this.mPendingAsyncChildren = new ArrayList();
        this.mTmpRect = new Rect();
        this.mReceiveChannel = in.readStrongBinder();
    }

    private final void $$robo$$android_app_assist_AssistStructure$dump() {
        Log.i("AssistStructure", "Activity: " + this.mActivityComponent.flattenToShortString());
        int N = this.getWindowNodeCount();
        for (int i = 0; i < N; ++i) {
            WindowNode node = this.getWindowNodeAt(i);
            Log.i("AssistStructure", "Window #" + i + " [" + node.getLeft() + "," + node.getTop() + " " + node.getWidth() + "x" + node.getHeight() + "] " + node.getTitle());
            this.dump("  ", node.getRootViewNode());
        }
    }

    private final void $$robo$$android_app_assist_AssistStructure$dump(String prefix, ViewNode node) {
        int NCHILDREN;
        Bundle extras;
        String hint;
        CharSequence text;
        CharSequence contentDescription;
        float alpha;
        float elevation;
        Matrix matrix;
        Log.i("AssistStructure", prefix + "View [" + node.getLeft() + "," + node.getTop() + " " + node.getWidth() + "x" + node.getHeight() + "] " + node.getClassName());
        int id2 = node.getId();
        if (id2 != 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(prefix);
            sb.append("  ID: #");
            sb.append(Integer.toHexString(id2));
            String entry = node.getIdEntry();
            if (entry != null) {
                String type = node.getIdType();
                String pkg = node.getIdPackage();
                sb.append(" ");
                sb.append(pkg);
                sb.append(":");
                sb.append(type);
                sb.append("/");
                sb.append(entry);
            }
            Log.i("AssistStructure", sb.toString());
        }
        int scrollX = node.getScrollX();
        int scrollY = node.getScrollY();
        if (scrollX != 0 || scrollY != 0) {
            Log.i("AssistStructure", prefix + "  Scroll: " + scrollX + "," + scrollY);
        }
        if ((matrix = node.getTransformation()) != null) {
            Log.i("AssistStructure", prefix + "  Transformation: " + matrix);
        }
        if ((elevation = node.getElevation()) != 0.0f) {
            Log.i("AssistStructure", prefix + "  Elevation: " + elevation);
        }
        if ((alpha = node.getAlpha()) != 0.0f) {
            Log.i("AssistStructure", prefix + "  Alpha: " + elevation);
        }
        if ((contentDescription = node.getContentDescription()) != null) {
            Log.i("AssistStructure", prefix + "  Content description: " + contentDescription);
        }
        if ((text = node.getText()) != null) {
            Log.i("AssistStructure", prefix + "  Text (sel " + node.getTextSelectionStart() + "-" + node.getTextSelectionEnd() + "): " + text);
            Log.i("AssistStructure", prefix + "  Text size: " + node.getTextSize() + " , style: #" + node.getTextStyle());
            Log.i("AssistStructure", prefix + "  Text color fg: #" + Integer.toHexString(node.getTextColor()) + ", bg: #" + Integer.toHexString(node.getTextBackgroundColor()));
        }
        if ((hint = node.getHint()) != null) {
            Log.i("AssistStructure", prefix + "  Hint: " + hint);
        }
        if ((extras = node.getExtras()) != null) {
            Log.i("AssistStructure", prefix + "  Extras: " + extras);
        }
        if (node.isAssistBlocked()) {
            Log.i("AssistStructure", prefix + "  BLOCKED");
        }
        if ((NCHILDREN = node.getChildCount()) > 0) {
            Log.i("AssistStructure", prefix + "  Children:");
            String cprefix = prefix + "    ";
            for (int i = 0; i < NCHILDREN; ++i) {
                ViewNode cnode = node.getChildAt(i);
                this.dump(cprefix, cnode);
            }
        }
    }

    private final ComponentName $$robo$$android_app_assist_AssistStructure$getActivityComponent() {
        this.ensureData();
        return this.mActivityComponent;
    }

    private final int $$robo$$android_app_assist_AssistStructure$getWindowNodeCount() {
        this.ensureData();
        return this.mWindowNodes.size();
    }

    private final WindowNode $$robo$$android_app_assist_AssistStructure$getWindowNodeAt(int index) {
        this.ensureData();
        return this.mWindowNodes.get(index);
    }

    private final void $$robo$$android_app_assist_AssistStructure$ensureData() {
        if (this.mHaveData) {
            return;
        }
        this.mHaveData = true;
        ParcelTransferReader reader = new ParcelTransferReader(this, this.mReceiveChannel);
        reader.go();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_app_assist_AssistStructure$waitForReady() {
        boolean skipStructure = false;
        AssistStructure assistStructure = this;
        synchronized (assistStructure) {
            long now;
            long endTime = SystemClock.uptimeMillis() + 5000L;
            while (this.mPendingAsyncChildren.size() > 0 && (now = SystemClock.uptimeMillis()) < endTime) {
                try {
                    this.wait(endTime - now);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.mPendingAsyncChildren.size() > 0) {
                Log.w("AssistStructure", "Skipping assist structure, waiting too long for async children (have " + this.mPendingAsyncChildren.size() + " remaining");
                skipStructure = true;
            }
        }
        return !skipStructure;
    }

    private final void $$robo$$android_app_assist_AssistStructure$clearSendChannel() {
        if (this.mSendChannel != null) {
            this.mSendChannel.mAssistStructure = null;
        }
    }

    private final int $$robo$$android_app_assist_AssistStructure$describeContents() {
        return 0;
    }

    private final void $$robo$$android_app_assist_AssistStructure$writeToParcel(Parcel out, int flags) {
        if (this.mHaveData) {
            if (this.mSendChannel == null) {
                this.mSendChannel = new SendChannel(this);
            }
            out.writeStrongBinder(this.mSendChannel);
        } else {
            out.writeStrongBinder(this.mReceiveChannel);
        }
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<AssistStructure>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_app_assist_AssistStructure_1$__constructor__() {
            }

            private final AssistStructure $$robo$$android_app_assist_AssistStructure_1$createFromParcel(Parcel in) {
                return new AssistStructure(in);
            }

            private final AssistStructure[] $$robo$$android_app_assist_AssistStructure_1$newArray(int size) {
                return new AssistStructure[size];
            }

            private void __constructor__() {
                this.$$robo$$android_app_assist_AssistStructure_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_assist_AssistStructure_1$__constructor__(), 0, this);
            }

            @Override
            public AssistStructure createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_app_assist_AssistStructure_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public AssistStructure[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_app_assist_AssistStructure_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(Activity activity) {
        this.$$robo$$android_app_assist_AssistStructure$__constructor__(activity);
    }

    public AssistStructure(Activity activity) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_assist_AssistStructure$__constructor__(android.app.Activity ), 0, this, activity);
    }

    private void __constructor__() {
        this.$$robo$$android_app_assist_AssistStructure$__constructor__();
    }

    public AssistStructure() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_assist_AssistStructure$__constructor__(), 0, this);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_app_assist_AssistStructure$__constructor__(parcel);
    }

    public AssistStructure(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_assist_AssistStructure$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    public void dump() {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_app_assist_AssistStructure$dump(), 0, this);
    }

    void dump(String string2, ViewNode viewNode) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_app_assist_AssistStructure$dump(java.lang.String android.app.assist.AssistStructure$ViewNode ), 0, this, string2, viewNode);
    }

    public ComponentName getActivityComponent() {
        return InvokeDynamicSupport.bootstrap("getActivityComponent", $$robo$$android_app_assist_AssistStructure$getActivityComponent(), 0, this);
    }

    public int getWindowNodeCount() {
        return (int)InvokeDynamicSupport.bootstrap("getWindowNodeCount", $$robo$$android_app_assist_AssistStructure$getWindowNodeCount(), 0, this);
    }

    public WindowNode getWindowNodeAt(int n) {
        return InvokeDynamicSupport.bootstrap("getWindowNodeAt", $$robo$$android_app_assist_AssistStructure$getWindowNodeAt(int ), 0, this, n);
    }

    public void ensureData() {
        InvokeDynamicSupport.bootstrap("ensureData", $$robo$$android_app_assist_AssistStructure$ensureData(), 0, this);
    }

    boolean waitForReady() {
        return (boolean)InvokeDynamicSupport.bootstrap("waitForReady", $$robo$$android_app_assist_AssistStructure$waitForReady(), 0, this);
    }

    public void clearSendChannel() {
        InvokeDynamicSupport.bootstrap("clearSendChannel", $$robo$$android_app_assist_AssistStructure$clearSendChannel(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_app_assist_AssistStructure$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_app_assist_AssistStructure$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    static {
        RobolectricInternals.classInitializing(AssistStructure.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AssistStructure)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class ViewNodeBuilder
    extends ViewStructure
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        AssistStructure mAssist;
        ViewNode mNode;
        boolean mAsync;

        private void $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$__constructor__(AssistStructure assist, ViewNode node, boolean async) {
            this.mAssist = assist;
            this.mNode = node;
            this.mAsync = async;
        }

        private final void $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setId(int id2, String packageName, String typeName, String entryName) {
            this.mNode.mId = id2;
            this.mNode.mIdPackage = packageName;
            this.mNode.mIdType = typeName;
            this.mNode.mIdEntry = entryName;
        }

        private final void $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setDimens(int left, int top, int scrollX, int scrollY, int width, int height) {
            this.mNode.mX = left;
            this.mNode.mY = top;
            this.mNode.mScrollX = scrollX;
            this.mNode.mScrollY = scrollY;
            this.mNode.mWidth = width;
            this.mNode.mHeight = height;
        }

        private final void $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setTransformation(Matrix matrix) {
            this.mNode.mMatrix = matrix == null ? null : new Matrix(matrix);
        }

        private final void $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setElevation(float elevation) {
            this.mNode.mElevation = elevation;
        }

        private final void $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setAlpha(float alpha) {
            this.mNode.mAlpha = alpha;
        }

        private final void $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setVisibility(int visibility) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFFFF3 | visibility;
        }

        private final void $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setAssistBlocked(boolean state) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFFF7F | (state ? 128 : 0);
        }

        private final void $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setEnabled(boolean state) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFFFFE | (state ? 0 : 1);
        }

        private final void $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setClickable(boolean state) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFFBFF | (state ? 1024 : 0);
        }

        private final void $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setLongClickable(boolean state) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFF7FF | (state ? 2048 : 0);
        }

        private final void $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setContextClickable(boolean state) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFBFFF | (state ? 16384 : 0);
        }

        private final void $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setFocusable(boolean state) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFFFEF | (state ? 16 : 0);
        }

        private final void $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setFocused(boolean state) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFFFDF | (state ? 32 : 0);
        }

        private final void $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setAccessibilityFocused(boolean state) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFEFFF | (state ? 4096 : 0);
        }

        private final void $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setCheckable(boolean state) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFFEFF | (state ? 256 : 0);
        }

        private final void $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setChecked(boolean state) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFFDFF | (state ? 512 : 0);
        }

        private final void $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setSelected(boolean state) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFFFBF | (state ? 64 : 0);
        }

        private final void $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setActivated(boolean state) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFDFFF | (state ? 8192 : 0);
        }

        private final void $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setClassName(String className) {
            this.mNode.mClassName = className;
        }

        private final void $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setContentDescription(CharSequence contentDescription) {
            this.mNode.mContentDescription = contentDescription;
        }

        private final ViewNodeText $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$getNodeText() {
            if (this.mNode.mText != null) {
                return this.mNode.mText;
            }
            this.mNode.mText = new ViewNodeText();
            return this.mNode.mText;
        }

        private final void $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setText(CharSequence text) {
            ViewNodeText t = this.getNodeText();
            t.mText = text;
            t.mTextSelectionEnd = -1;
            t.mTextSelectionStart = -1;
        }

        private final void $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setText(CharSequence text, int selectionStart, int selectionEnd) {
            ViewNodeText t = this.getNodeText();
            t.mText = text;
            t.mTextSelectionStart = selectionStart;
            t.mTextSelectionEnd = selectionEnd;
        }

        private final void $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setTextStyle(float size, int fgColor, int bgColor, int style2) {
            ViewNodeText t = this.getNodeText();
            t.mTextColor = fgColor;
            t.mTextBackgroundColor = bgColor;
            t.mTextSize = size;
            t.mTextStyle = style2;
        }

        private final void $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setTextLines(int[] charOffsets, int[] baselines) {
            ViewNodeText t = this.getNodeText();
            t.mLineCharOffsets = charOffsets;
            t.mLineBaselines = baselines;
        }

        private final void $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setHint(CharSequence hint) {
            this.getNodeText().mHint = hint != null ? hint.toString() : null;
        }

        private final CharSequence $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$getText() {
            return this.mNode.mText != null ? this.mNode.mText.mText : null;
        }

        private final int $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$getTextSelectionStart() {
            return this.mNode.mText != null ? this.mNode.mText.mTextSelectionStart : -1;
        }

        private final int $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$getTextSelectionEnd() {
            return this.mNode.mText != null ? this.mNode.mText.mTextSelectionEnd : -1;
        }

        private final CharSequence $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$getHint() {
            return this.mNode.mText != null ? this.mNode.mText.mHint : null;
        }

        private final Bundle $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$getExtras() {
            if (this.mNode.mExtras != null) {
                return this.mNode.mExtras;
            }
            this.mNode.mExtras = new Bundle();
            return this.mNode.mExtras;
        }

        private final boolean $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$hasExtras() {
            return this.mNode.mExtras != null;
        }

        private final void $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setChildCount(int num) {
            this.mNode.mChildren = new ViewNode[num];
        }

        private final int $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$addChildCount(int num) {
            if (this.mNode.mChildren == null) {
                this.setChildCount(num);
                return 0;
            }
            int start = this.mNode.mChildren.length;
            ViewNode[] newArray = new ViewNode[start + num];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mNode.mChildren, (int)0, (Object)newArray, (int)0, (int)start);
            this.mNode.mChildren = newArray;
            return start;
        }

        private final int $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$getChildCount() {
            return this.mNode.mChildren != null ? this.mNode.mChildren.length : 0;
        }

        private final ViewStructure $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$newChild(int index) {
            ViewNode node;
            this.mNode.mChildren[index] = node = new ViewNode();
            return new ViewNodeBuilder(this.mAssist, node, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final ViewStructure $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$asyncNewChild(int index) {
            AssistStructure assistStructure = this.mAssist;
            synchronized (assistStructure) {
                ViewNode node;
                this.mNode.mChildren[index] = node = new ViewNode();
                ViewNodeBuilder builder = new ViewNodeBuilder(this.mAssist, node, true);
                this.mAssist.mPendingAsyncChildren.add(builder);
                return builder;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$asyncCommit() {
            AssistStructure assistStructure = this.mAssist;
            synchronized (assistStructure) {
                if (!this.mAsync) {
                    throw new IllegalStateException("Child " + this + " was not created with ViewStructure.asyncNewChild");
                }
                if (!this.mAssist.mPendingAsyncChildren.remove(this)) {
                    throw new IllegalStateException("Child " + this + " already committed");
                }
                this.mAssist.notifyAll();
            }
        }

        private final Rect $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$getTempRect() {
            return this.mAssist.mTmpRect;
        }

        private void __constructor__(AssistStructure assistStructure, ViewNode viewNode, boolean bl) {
            this.$$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$__constructor__(assistStructure, viewNode, bl);
        }

        ViewNodeBuilder(AssistStructure assistStructure, ViewNode viewNode, boolean bl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$__constructor__(android.app.assist.AssistStructure android.app.assist.AssistStructure$ViewNode boolean ), 0, this, assistStructure, viewNode, bl);
        }

        @Override
        public void setId(int n, String string2, String string3, String string4) {
            InvokeDynamicSupport.bootstrap("setId", $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setId(int java.lang.String java.lang.String java.lang.String ), 0, this, n, string2, string3, string4);
        }

        @Override
        public void setDimens(int n, int n2, int n3, int n4, int n5, int n6) {
            InvokeDynamicSupport.bootstrap("setDimens", $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setDimens(int int int int int int ), 0, this, n, n2, n3, n4, n5, n6);
        }

        @Override
        public void setTransformation(Matrix matrix) {
            InvokeDynamicSupport.bootstrap("setTransformation", $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setTransformation(android.graphics.Matrix ), 0, this, matrix);
        }

        @Override
        public void setElevation(float f) {
            InvokeDynamicSupport.bootstrap("setElevation", $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setElevation(float ), 0, this, f);
        }

        @Override
        public void setAlpha(float f) {
            InvokeDynamicSupport.bootstrap("setAlpha", $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setAlpha(float ), 0, this, f);
        }

        @Override
        public void setVisibility(int n) {
            InvokeDynamicSupport.bootstrap("setVisibility", $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setVisibility(int ), 0, this, n);
        }

        @Override
        public void setAssistBlocked(boolean bl) {
            InvokeDynamicSupport.bootstrap("setAssistBlocked", $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setAssistBlocked(boolean ), 0, this, bl);
        }

        @Override
        public void setEnabled(boolean bl) {
            InvokeDynamicSupport.bootstrap("setEnabled", $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setEnabled(boolean ), 0, this, bl);
        }

        @Override
        public void setClickable(boolean bl) {
            InvokeDynamicSupport.bootstrap("setClickable", $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setClickable(boolean ), 0, this, bl);
        }

        @Override
        public void setLongClickable(boolean bl) {
            InvokeDynamicSupport.bootstrap("setLongClickable", $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setLongClickable(boolean ), 0, this, bl);
        }

        @Override
        public void setContextClickable(boolean bl) {
            InvokeDynamicSupport.bootstrap("setContextClickable", $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setContextClickable(boolean ), 0, this, bl);
        }

        @Override
        public void setFocusable(boolean bl) {
            InvokeDynamicSupport.bootstrap("setFocusable", $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setFocusable(boolean ), 0, this, bl);
        }

        @Override
        public void setFocused(boolean bl) {
            InvokeDynamicSupport.bootstrap("setFocused", $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setFocused(boolean ), 0, this, bl);
        }

        @Override
        public void setAccessibilityFocused(boolean bl) {
            InvokeDynamicSupport.bootstrap("setAccessibilityFocused", $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setAccessibilityFocused(boolean ), 0, this, bl);
        }

        @Override
        public void setCheckable(boolean bl) {
            InvokeDynamicSupport.bootstrap("setCheckable", $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setCheckable(boolean ), 0, this, bl);
        }

        @Override
        public void setChecked(boolean bl) {
            InvokeDynamicSupport.bootstrap("setChecked", $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setChecked(boolean ), 0, this, bl);
        }

        @Override
        public void setSelected(boolean bl) {
            InvokeDynamicSupport.bootstrap("setSelected", $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setSelected(boolean ), 0, this, bl);
        }

        @Override
        public void setActivated(boolean bl) {
            InvokeDynamicSupport.bootstrap("setActivated", $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setActivated(boolean ), 0, this, bl);
        }

        @Override
        public void setClassName(String string2) {
            InvokeDynamicSupport.bootstrap("setClassName", $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setClassName(java.lang.String ), 0, this, string2);
        }

        @Override
        public void setContentDescription(CharSequence charSequence) {
            InvokeDynamicSupport.bootstrap("setContentDescription", $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setContentDescription(java.lang.CharSequence ), 0, this, charSequence);
        }

        private ViewNodeText getNodeText() {
            return InvokeDynamicSupport.bootstrap("getNodeText", $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$getNodeText(), 0, this);
        }

        @Override
        public void setText(CharSequence charSequence) {
            InvokeDynamicSupport.bootstrap("setText", $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setText(java.lang.CharSequence ), 0, this, charSequence);
        }

        @Override
        public void setText(CharSequence charSequence, int n, int n2) {
            InvokeDynamicSupport.bootstrap("setText", $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setText(java.lang.CharSequence int int ), 0, this, charSequence, n, n2);
        }

        @Override
        public void setTextStyle(float f, int n, int n2, int n3) {
            InvokeDynamicSupport.bootstrap("setTextStyle", $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setTextStyle(float int int int ), 0, this, f, n, n2, n3);
        }

        @Override
        public void setTextLines(int[] nArray, int[] nArray2) {
            InvokeDynamicSupport.bootstrap("setTextLines", $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setTextLines(int[] int[] ), 0, this, nArray, nArray2);
        }

        @Override
        public void setHint(CharSequence charSequence) {
            InvokeDynamicSupport.bootstrap("setHint", $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setHint(java.lang.CharSequence ), 0, this, charSequence);
        }

        @Override
        public CharSequence getText() {
            return InvokeDynamicSupport.bootstrap("getText", $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$getText(), 0, this);
        }

        @Override
        public int getTextSelectionStart() {
            return (int)InvokeDynamicSupport.bootstrap("getTextSelectionStart", $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$getTextSelectionStart(), 0, this);
        }

        @Override
        public int getTextSelectionEnd() {
            return (int)InvokeDynamicSupport.bootstrap("getTextSelectionEnd", $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$getTextSelectionEnd(), 0, this);
        }

        @Override
        public CharSequence getHint() {
            return InvokeDynamicSupport.bootstrap("getHint", $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$getHint(), 0, this);
        }

        @Override
        public Bundle getExtras() {
            return InvokeDynamicSupport.bootstrap("getExtras", $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$getExtras(), 0, this);
        }

        @Override
        public boolean hasExtras() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasExtras", $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$hasExtras(), 0, this);
        }

        @Override
        public void setChildCount(int n) {
            InvokeDynamicSupport.bootstrap("setChildCount", $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$setChildCount(int ), 0, this, n);
        }

        @Override
        public int addChildCount(int n) {
            return (int)InvokeDynamicSupport.bootstrap("addChildCount", $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$addChildCount(int ), 0, this, n);
        }

        @Override
        public int getChildCount() {
            return (int)InvokeDynamicSupport.bootstrap("getChildCount", $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$getChildCount(), 0, this);
        }

        @Override
        public ViewStructure newChild(int n) {
            return InvokeDynamicSupport.bootstrap("newChild", $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$newChild(int ), 0, this, n);
        }

        @Override
        public ViewStructure asyncNewChild(int n) {
            return InvokeDynamicSupport.bootstrap("asyncNewChild", $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$asyncNewChild(int ), 0, this, n);
        }

        @Override
        public void asyncCommit() {
            InvokeDynamicSupport.bootstrap("asyncCommit", $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$asyncCommit(), 0, this);
        }

        @Override
        public Rect getTempRect() {
            return InvokeDynamicSupport.bootstrap("getTempRect", $$robo$$android_app_assist_AssistStructure_ViewNodeBuilder$getTempRect(), 0, this);
        }

        public /* synthetic */ ViewNodeBuilder() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ViewNodeBuilder)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ViewNode
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int TEXT_COLOR_UNDEFINED = 1;
        public static int TEXT_STYLE_BOLD = 1;
        public static int TEXT_STYLE_ITALIC = 2;
        public static int TEXT_STYLE_UNDERLINE = 4;
        public static int TEXT_STYLE_STRIKE_THRU = 8;
        int mId;
        String mIdPackage;
        String mIdType;
        String mIdEntry;
        int mX;
        int mY;
        int mScrollX;
        int mScrollY;
        int mWidth;
        int mHeight;
        Matrix mMatrix;
        float mElevation;
        float mAlpha;
        static int FLAGS_DISABLED = 1;
        static int FLAGS_VISIBILITY_MASK = 12;
        static int FLAGS_FOCUSABLE = 16;
        static int FLAGS_FOCUSED = 32;
        static int FLAGS_SELECTED = 64;
        static int FLAGS_ASSIST_BLOCKED = 128;
        static int FLAGS_CHECKABLE = 256;
        static int FLAGS_CHECKED = 512;
        static int FLAGS_CLICKABLE = 1024;
        static int FLAGS_LONG_CLICKABLE = 2048;
        static int FLAGS_ACCESSIBILITY_FOCUSED = 4096;
        static int FLAGS_ACTIVATED = 8192;
        static int FLAGS_CONTEXT_CLICKABLE = 16384;
        static int FLAGS_HAS_MATRIX = 0x40000000;
        static int FLAGS_HAS_ALPHA = 0x20000000;
        static int FLAGS_HAS_ELEVATION = 0x10000000;
        static int FLAGS_HAS_SCROLL = 0x8000000;
        static int FLAGS_HAS_LARGE_COORDS = 0x4000000;
        static int FLAGS_HAS_CONTENT_DESCRIPTION = 0x2000000;
        static int FLAGS_HAS_TEXT = 0x1000000;
        static int FLAGS_HAS_COMPLEX_TEXT = 0x800000;
        static int FLAGS_HAS_EXTRAS = 0x400000;
        static int FLAGS_HAS_ID = 0x200000;
        static int FLAGS_HAS_CHILDREN = 0x100000;
        static int FLAGS_ALL_CONTROL = -1048576;
        int mFlags;
        String mClassName;
        CharSequence mContentDescription;
        ViewNodeText mText;
        Bundle mExtras;
        ViewNode[] mChildren;

        private void $$robo$$android_app_assist_AssistStructure_ViewNode$__constructor__() {
            this.mId = -1;
            this.mAlpha = 1.0f;
        }

        private void $$robo$$android_app_assist_AssistStructure_ViewNode$__constructor__(ParcelTransferReader reader, int nestingLevel) {
            this.mId = -1;
            this.mAlpha = 1.0f;
            Parcel in = reader.readParcel(0x22222222, nestingLevel);
            ++reader.mNumReadViews;
            PooledStringReader preader = reader.mStringReader;
            this.mClassName = preader.readString();
            this.mFlags = in.readInt();
            int flags = this.mFlags;
            if ((flags & 0x200000) != 0) {
                this.mId = in.readInt();
                if (this.mId != 0) {
                    this.mIdEntry = preader.readString();
                    if (this.mIdEntry != null) {
                        this.mIdType = preader.readString();
                        this.mIdPackage = preader.readString();
                    }
                }
            }
            if ((flags & 0x4000000) != 0) {
                this.mX = in.readInt();
                this.mY = in.readInt();
                this.mWidth = in.readInt();
                this.mHeight = in.readInt();
            } else {
                int val = in.readInt();
                this.mX = val & Short.MAX_VALUE;
                this.mY = val >> 16 & Short.MAX_VALUE;
                val = in.readInt();
                this.mWidth = val & Short.MAX_VALUE;
                this.mHeight = val >> 16 & Short.MAX_VALUE;
            }
            if ((flags & 0x8000000) != 0) {
                this.mScrollX = in.readInt();
                this.mScrollY = in.readInt();
            }
            if ((flags & 0x40000000) != 0) {
                this.mMatrix = new Matrix();
                in.readFloatArray(reader.mTmpMatrix);
                this.mMatrix.setValues(reader.mTmpMatrix);
            }
            if ((flags & 0x10000000) != 0) {
                this.mElevation = in.readFloat();
            }
            if ((flags & 0x20000000) != 0) {
                this.mAlpha = in.readFloat();
            }
            if ((flags & 0x2000000) != 0) {
                this.mContentDescription = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            }
            if ((flags & 0x1000000) != 0) {
                this.mText = new ViewNodeText(in, (flags & 0x800000) == 0);
            }
            if ((flags & 0x400000) != 0) {
                this.mExtras = in.readBundle();
            }
            if ((flags & 0x100000) != 0) {
                int NCHILDREN = in.readInt();
                this.mChildren = new ViewNode[NCHILDREN];
                for (int i = 0; i < NCHILDREN; ++i) {
                    this.mChildren[i] = new ViewNode(reader, nestingLevel + 1);
                }
            }
        }

        private final int $$robo$$android_app_assist_AssistStructure_ViewNode$writeSelfToParcel(Parcel out, PooledStringWriter pwriter, float[] tmpMatrix) {
            int flags = this.mFlags & 0xFFFFF;
            if (this.mId != -1) {
                flags |= 0x200000;
            }
            if ((this.mX & Short.MIN_VALUE) != 0 || (this.mY & Short.MIN_VALUE) != 0 || (this.mWidth & Short.MIN_VALUE) != 0 | (this.mHeight & Short.MIN_VALUE) != 0) {
                flags |= 0x4000000;
            }
            if (this.mScrollX != 0 || this.mScrollY != 0) {
                flags |= 0x8000000;
            }
            if (this.mMatrix != null) {
                flags |= 0x40000000;
            }
            if (this.mElevation != 0.0f) {
                flags |= 0x10000000;
            }
            if (this.mAlpha != 1.0f) {
                flags |= 0x20000000;
            }
            if (this.mContentDescription != null) {
                flags |= 0x2000000;
            }
            if (this.mText != null) {
                flags |= 0x1000000;
                if (!this.mText.isSimple()) {
                    flags |= 0x800000;
                }
            }
            if (this.mExtras != null) {
                flags |= 0x400000;
            }
            if (this.mChildren != null) {
                flags |= 0x100000;
            }
            pwriter.writeString(this.mClassName);
            out.writeInt(flags);
            if ((flags & 0x200000) != 0) {
                out.writeInt(this.mId);
                if (this.mId != 0) {
                    pwriter.writeString(this.mIdEntry);
                    if (this.mIdEntry != null) {
                        pwriter.writeString(this.mIdType);
                        pwriter.writeString(this.mIdPackage);
                    }
                }
            }
            if ((flags & 0x4000000) != 0) {
                out.writeInt(this.mX);
                out.writeInt(this.mY);
                out.writeInt(this.mWidth);
                out.writeInt(this.mHeight);
            } else {
                out.writeInt(this.mY << 16 | this.mX);
                out.writeInt(this.mHeight << 16 | this.mWidth);
            }
            if ((flags & 0x8000000) != 0) {
                out.writeInt(this.mScrollX);
                out.writeInt(this.mScrollY);
            }
            if ((flags & 0x40000000) != 0) {
                this.mMatrix.getValues(tmpMatrix);
                out.writeFloatArray(tmpMatrix);
            }
            if ((flags & 0x10000000) != 0) {
                out.writeFloat(this.mElevation);
            }
            if ((flags & 0x20000000) != 0) {
                out.writeFloat(this.mAlpha);
            }
            if ((flags & 0x2000000) != 0) {
                TextUtils.writeToParcel(this.mContentDescription, out, 0);
            }
            if ((flags & 0x1000000) != 0) {
                this.mText.writeToParcel(out, (flags & 0x800000) == 0);
            }
            if ((flags & 0x400000) != 0) {
                out.writeBundle(this.mExtras);
            }
            return flags;
        }

        private final int $$robo$$android_app_assist_AssistStructure_ViewNode$getId() {
            return this.mId;
        }

        private final String $$robo$$android_app_assist_AssistStructure_ViewNode$getIdPackage() {
            return this.mIdPackage;
        }

        private final String $$robo$$android_app_assist_AssistStructure_ViewNode$getIdType() {
            return this.mIdType;
        }

        private final String $$robo$$android_app_assist_AssistStructure_ViewNode$getIdEntry() {
            return this.mIdEntry;
        }

        private final int $$robo$$android_app_assist_AssistStructure_ViewNode$getLeft() {
            return this.mX;
        }

        private final int $$robo$$android_app_assist_AssistStructure_ViewNode$getTop() {
            return this.mY;
        }

        private final int $$robo$$android_app_assist_AssistStructure_ViewNode$getScrollX() {
            return this.mScrollX;
        }

        private final int $$robo$$android_app_assist_AssistStructure_ViewNode$getScrollY() {
            return this.mScrollY;
        }

        private final int $$robo$$android_app_assist_AssistStructure_ViewNode$getWidth() {
            return this.mWidth;
        }

        private final int $$robo$$android_app_assist_AssistStructure_ViewNode$getHeight() {
            return this.mHeight;
        }

        private final Matrix $$robo$$android_app_assist_AssistStructure_ViewNode$getTransformation() {
            return this.mMatrix;
        }

        private final float $$robo$$android_app_assist_AssistStructure_ViewNode$getElevation() {
            return this.mElevation;
        }

        private final float $$robo$$android_app_assist_AssistStructure_ViewNode$getAlpha() {
            return this.mAlpha;
        }

        private final int $$robo$$android_app_assist_AssistStructure_ViewNode$getVisibility() {
            return this.mFlags & 0xC;
        }

        private final boolean $$robo$$android_app_assist_AssistStructure_ViewNode$isAssistBlocked() {
            return (this.mFlags & 0x80) != 0;
        }

        private final boolean $$robo$$android_app_assist_AssistStructure_ViewNode$isEnabled() {
            return (this.mFlags & 1) == 0;
        }

        private final boolean $$robo$$android_app_assist_AssistStructure_ViewNode$isClickable() {
            return (this.mFlags & 0x400) != 0;
        }

        private final boolean $$robo$$android_app_assist_AssistStructure_ViewNode$isFocusable() {
            return (this.mFlags & 0x10) != 0;
        }

        private final boolean $$robo$$android_app_assist_AssistStructure_ViewNode$isFocused() {
            return (this.mFlags & 0x20) != 0;
        }

        private final boolean $$robo$$android_app_assist_AssistStructure_ViewNode$isAccessibilityFocused() {
            return (this.mFlags & 0x1000) != 0;
        }

        private final boolean $$robo$$android_app_assist_AssistStructure_ViewNode$isCheckable() {
            return (this.mFlags & 0x100) != 0;
        }

        private final boolean $$robo$$android_app_assist_AssistStructure_ViewNode$isChecked() {
            return (this.mFlags & 0x200) != 0;
        }

        private final boolean $$robo$$android_app_assist_AssistStructure_ViewNode$isSelected() {
            return (this.mFlags & 0x40) != 0;
        }

        private final boolean $$robo$$android_app_assist_AssistStructure_ViewNode$isActivated() {
            return (this.mFlags & 0x2000) != 0;
        }

        private final boolean $$robo$$android_app_assist_AssistStructure_ViewNode$isLongClickable() {
            return (this.mFlags & 0x800) != 0;
        }

        private final boolean $$robo$$android_app_assist_AssistStructure_ViewNode$isContextClickable() {
            return (this.mFlags & 0x4000) != 0;
        }

        private final String $$robo$$android_app_assist_AssistStructure_ViewNode$getClassName() {
            return this.mClassName;
        }

        private final CharSequence $$robo$$android_app_assist_AssistStructure_ViewNode$getContentDescription() {
            return this.mContentDescription;
        }

        private final CharSequence $$robo$$android_app_assist_AssistStructure_ViewNode$getText() {
            return this.mText != null ? this.mText.mText : null;
        }

        private final int $$robo$$android_app_assist_AssistStructure_ViewNode$getTextSelectionStart() {
            return this.mText != null ? this.mText.mTextSelectionStart : -1;
        }

        private final int $$robo$$android_app_assist_AssistStructure_ViewNode$getTextSelectionEnd() {
            return this.mText != null ? this.mText.mTextSelectionEnd : -1;
        }

        private final int $$robo$$android_app_assist_AssistStructure_ViewNode$getTextColor() {
            return this.mText != null ? this.mText.mTextColor : 1;
        }

        private final int $$robo$$android_app_assist_AssistStructure_ViewNode$getTextBackgroundColor() {
            return this.mText != null ? this.mText.mTextBackgroundColor : 1;
        }

        private final float $$robo$$android_app_assist_AssistStructure_ViewNode$getTextSize() {
            return this.mText != null ? this.mText.mTextSize : 0.0f;
        }

        private final int $$robo$$android_app_assist_AssistStructure_ViewNode$getTextStyle() {
            return this.mText != null ? this.mText.mTextStyle : 0;
        }

        private final int[] $$robo$$android_app_assist_AssistStructure_ViewNode$getTextLineCharOffsets() {
            return this.mText != null ? this.mText.mLineCharOffsets : null;
        }

        private final int[] $$robo$$android_app_assist_AssistStructure_ViewNode$getTextLineBaselines() {
            return this.mText != null ? this.mText.mLineBaselines : null;
        }

        private final String $$robo$$android_app_assist_AssistStructure_ViewNode$getHint() {
            return this.mText != null ? this.mText.mHint : null;
        }

        private final Bundle $$robo$$android_app_assist_AssistStructure_ViewNode$getExtras() {
            return this.mExtras;
        }

        private final int $$robo$$android_app_assist_AssistStructure_ViewNode$getChildCount() {
            return this.mChildren != null ? this.mChildren.length : 0;
        }

        private final ViewNode $$robo$$android_app_assist_AssistStructure_ViewNode$getChildAt(int index) {
            return this.mChildren[index];
        }

        private void __constructor__() {
            this.$$robo$$android_app_assist_AssistStructure_ViewNode$__constructor__();
        }

        ViewNode() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_assist_AssistStructure_ViewNode$__constructor__(), 0, this);
        }

        private void __constructor__(ParcelTransferReader parcelTransferReader, int n) {
            this.$$robo$$android_app_assist_AssistStructure_ViewNode$__constructor__(parcelTransferReader, n);
        }

        ViewNode(ParcelTransferReader parcelTransferReader, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_assist_AssistStructure_ViewNode$__constructor__(android.app.assist.AssistStructure$ParcelTransferReader int ), 0, this, parcelTransferReader, n);
        }

        int writeSelfToParcel(Parcel parcel, PooledStringWriter pooledStringWriter, float[] fArray) {
            return (int)InvokeDynamicSupport.bootstrap("writeSelfToParcel", $$robo$$android_app_assist_AssistStructure_ViewNode$writeSelfToParcel(android.os.Parcel android.os.PooledStringWriter float[] ), 0, this, parcel, pooledStringWriter, fArray);
        }

        public int getId() {
            return (int)InvokeDynamicSupport.bootstrap("getId", $$robo$$android_app_assist_AssistStructure_ViewNode$getId(), 0, this);
        }

        public String getIdPackage() {
            return InvokeDynamicSupport.bootstrap("getIdPackage", $$robo$$android_app_assist_AssistStructure_ViewNode$getIdPackage(), 0, this);
        }

        public String getIdType() {
            return InvokeDynamicSupport.bootstrap("getIdType", $$robo$$android_app_assist_AssistStructure_ViewNode$getIdType(), 0, this);
        }

        public String getIdEntry() {
            return InvokeDynamicSupport.bootstrap("getIdEntry", $$robo$$android_app_assist_AssistStructure_ViewNode$getIdEntry(), 0, this);
        }

        public int getLeft() {
            return (int)InvokeDynamicSupport.bootstrap("getLeft", $$robo$$android_app_assist_AssistStructure_ViewNode$getLeft(), 0, this);
        }

        public int getTop() {
            return (int)InvokeDynamicSupport.bootstrap("getTop", $$robo$$android_app_assist_AssistStructure_ViewNode$getTop(), 0, this);
        }

        public int getScrollX() {
            return (int)InvokeDynamicSupport.bootstrap("getScrollX", $$robo$$android_app_assist_AssistStructure_ViewNode$getScrollX(), 0, this);
        }

        public int getScrollY() {
            return (int)InvokeDynamicSupport.bootstrap("getScrollY", $$robo$$android_app_assist_AssistStructure_ViewNode$getScrollY(), 0, this);
        }

        public int getWidth() {
            return (int)InvokeDynamicSupport.bootstrap("getWidth", $$robo$$android_app_assist_AssistStructure_ViewNode$getWidth(), 0, this);
        }

        public int getHeight() {
            return (int)InvokeDynamicSupport.bootstrap("getHeight", $$robo$$android_app_assist_AssistStructure_ViewNode$getHeight(), 0, this);
        }

        public Matrix getTransformation() {
            return InvokeDynamicSupport.bootstrap("getTransformation", $$robo$$android_app_assist_AssistStructure_ViewNode$getTransformation(), 0, this);
        }

        public float getElevation() {
            return (float)InvokeDynamicSupport.bootstrap("getElevation", $$robo$$android_app_assist_AssistStructure_ViewNode$getElevation(), 0, this);
        }

        public float getAlpha() {
            return (float)InvokeDynamicSupport.bootstrap("getAlpha", $$robo$$android_app_assist_AssistStructure_ViewNode$getAlpha(), 0, this);
        }

        public int getVisibility() {
            return (int)InvokeDynamicSupport.bootstrap("getVisibility", $$robo$$android_app_assist_AssistStructure_ViewNode$getVisibility(), 0, this);
        }

        public boolean isAssistBlocked() {
            return (boolean)InvokeDynamicSupport.bootstrap("isAssistBlocked", $$robo$$android_app_assist_AssistStructure_ViewNode$isAssistBlocked(), 0, this);
        }

        public boolean isEnabled() {
            return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_app_assist_AssistStructure_ViewNode$isEnabled(), 0, this);
        }

        public boolean isClickable() {
            return (boolean)InvokeDynamicSupport.bootstrap("isClickable", $$robo$$android_app_assist_AssistStructure_ViewNode$isClickable(), 0, this);
        }

        public boolean isFocusable() {
            return (boolean)InvokeDynamicSupport.bootstrap("isFocusable", $$robo$$android_app_assist_AssistStructure_ViewNode$isFocusable(), 0, this);
        }

        public boolean isFocused() {
            return (boolean)InvokeDynamicSupport.bootstrap("isFocused", $$robo$$android_app_assist_AssistStructure_ViewNode$isFocused(), 0, this);
        }

        public boolean isAccessibilityFocused() {
            return (boolean)InvokeDynamicSupport.bootstrap("isAccessibilityFocused", $$robo$$android_app_assist_AssistStructure_ViewNode$isAccessibilityFocused(), 0, this);
        }

        public boolean isCheckable() {
            return (boolean)InvokeDynamicSupport.bootstrap("isCheckable", $$robo$$android_app_assist_AssistStructure_ViewNode$isCheckable(), 0, this);
        }

        public boolean isChecked() {
            return (boolean)InvokeDynamicSupport.bootstrap("isChecked", $$robo$$android_app_assist_AssistStructure_ViewNode$isChecked(), 0, this);
        }

        public boolean isSelected() {
            return (boolean)InvokeDynamicSupport.bootstrap("isSelected", $$robo$$android_app_assist_AssistStructure_ViewNode$isSelected(), 0, this);
        }

        public boolean isActivated() {
            return (boolean)InvokeDynamicSupport.bootstrap("isActivated", $$robo$$android_app_assist_AssistStructure_ViewNode$isActivated(), 0, this);
        }

        public boolean isLongClickable() {
            return (boolean)InvokeDynamicSupport.bootstrap("isLongClickable", $$robo$$android_app_assist_AssistStructure_ViewNode$isLongClickable(), 0, this);
        }

        public boolean isContextClickable() {
            return (boolean)InvokeDynamicSupport.bootstrap("isContextClickable", $$robo$$android_app_assist_AssistStructure_ViewNode$isContextClickable(), 0, this);
        }

        public String getClassName() {
            return InvokeDynamicSupport.bootstrap("getClassName", $$robo$$android_app_assist_AssistStructure_ViewNode$getClassName(), 0, this);
        }

        public CharSequence getContentDescription() {
            return InvokeDynamicSupport.bootstrap("getContentDescription", $$robo$$android_app_assist_AssistStructure_ViewNode$getContentDescription(), 0, this);
        }

        public CharSequence getText() {
            return InvokeDynamicSupport.bootstrap("getText", $$robo$$android_app_assist_AssistStructure_ViewNode$getText(), 0, this);
        }

        public int getTextSelectionStart() {
            return (int)InvokeDynamicSupport.bootstrap("getTextSelectionStart", $$robo$$android_app_assist_AssistStructure_ViewNode$getTextSelectionStart(), 0, this);
        }

        public int getTextSelectionEnd() {
            return (int)InvokeDynamicSupport.bootstrap("getTextSelectionEnd", $$robo$$android_app_assist_AssistStructure_ViewNode$getTextSelectionEnd(), 0, this);
        }

        public int getTextColor() {
            return (int)InvokeDynamicSupport.bootstrap("getTextColor", $$robo$$android_app_assist_AssistStructure_ViewNode$getTextColor(), 0, this);
        }

        public int getTextBackgroundColor() {
            return (int)InvokeDynamicSupport.bootstrap("getTextBackgroundColor", $$robo$$android_app_assist_AssistStructure_ViewNode$getTextBackgroundColor(), 0, this);
        }

        public float getTextSize() {
            return (float)InvokeDynamicSupport.bootstrap("getTextSize", $$robo$$android_app_assist_AssistStructure_ViewNode$getTextSize(), 0, this);
        }

        public int getTextStyle() {
            return (int)InvokeDynamicSupport.bootstrap("getTextStyle", $$robo$$android_app_assist_AssistStructure_ViewNode$getTextStyle(), 0, this);
        }

        public int[] getTextLineCharOffsets() {
            return InvokeDynamicSupport.bootstrap("getTextLineCharOffsets", $$robo$$android_app_assist_AssistStructure_ViewNode$getTextLineCharOffsets(), 0, this);
        }

        public int[] getTextLineBaselines() {
            return InvokeDynamicSupport.bootstrap("getTextLineBaselines", $$robo$$android_app_assist_AssistStructure_ViewNode$getTextLineBaselines(), 0, this);
        }

        public String getHint() {
            return InvokeDynamicSupport.bootstrap("getHint", $$robo$$android_app_assist_AssistStructure_ViewNode$getHint(), 0, this);
        }

        public Bundle getExtras() {
            return InvokeDynamicSupport.bootstrap("getExtras", $$robo$$android_app_assist_AssistStructure_ViewNode$getExtras(), 0, this);
        }

        public int getChildCount() {
            return (int)InvokeDynamicSupport.bootstrap("getChildCount", $$robo$$android_app_assist_AssistStructure_ViewNode$getChildCount(), 0, this);
        }

        public ViewNode getChildAt(int n) {
            return InvokeDynamicSupport.bootstrap("getChildAt", $$robo$$android_app_assist_AssistStructure_ViewNode$getChildAt(int ), 0, this, n);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ViewNode)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class WindowNode
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int mX;
        int mY;
        int mWidth;
        int mHeight;
        CharSequence mTitle;
        int mDisplayId;
        ViewNode mRoot;

        private void $$robo$$android_app_assist_AssistStructure_WindowNode$__constructor__(AssistStructure assist, ViewRootImpl root) {
            View view = root.getView();
            Rect rect = new Rect();
            view.getBoundsOnScreen(rect);
            this.mX = rect.left - view.getLeft();
            this.mY = rect.top - view.getTop();
            this.mWidth = rect.width();
            this.mHeight = rect.height();
            this.mTitle = root.getTitle();
            this.mDisplayId = root.getDisplayId();
            this.mRoot = new ViewNode();
            ViewNodeBuilder builder = new ViewNodeBuilder(assist, this.mRoot, false);
            if ((root.getWindowFlags() & 0x2000) != 0) {
                view.onProvideStructure(builder);
                builder.setAssistBlocked(true);
                return;
            }
            view.dispatchProvideStructure(builder);
        }

        private void $$robo$$android_app_assist_AssistStructure_WindowNode$__constructor__(ParcelTransferReader reader) {
            Parcel in = reader.readParcel(0x11111111, 0);
            ++reader.mNumReadWindows;
            this.mX = in.readInt();
            this.mY = in.readInt();
            this.mWidth = in.readInt();
            this.mHeight = in.readInt();
            this.mTitle = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            this.mDisplayId = in.readInt();
            this.mRoot = new ViewNode(reader, 0);
        }

        private final void $$robo$$android_app_assist_AssistStructure_WindowNode$writeSelfToParcel(Parcel out, PooledStringWriter pwriter, float[] tmpMatrix) {
            out.writeInt(this.mX);
            out.writeInt(this.mY);
            out.writeInt(this.mWidth);
            out.writeInt(this.mHeight);
            TextUtils.writeToParcel(this.mTitle, out, 0);
            out.writeInt(this.mDisplayId);
        }

        private final int $$robo$$android_app_assist_AssistStructure_WindowNode$getLeft() {
            return this.mX;
        }

        private final int $$robo$$android_app_assist_AssistStructure_WindowNode$getTop() {
            return this.mY;
        }

        private final int $$robo$$android_app_assist_AssistStructure_WindowNode$getWidth() {
            return this.mWidth;
        }

        private final int $$robo$$android_app_assist_AssistStructure_WindowNode$getHeight() {
            return this.mHeight;
        }

        private final CharSequence $$robo$$android_app_assist_AssistStructure_WindowNode$getTitle() {
            return this.mTitle;
        }

        private final int $$robo$$android_app_assist_AssistStructure_WindowNode$getDisplayId() {
            return this.mDisplayId;
        }

        private final ViewNode $$robo$$android_app_assist_AssistStructure_WindowNode$getRootViewNode() {
            return this.mRoot;
        }

        private void __constructor__(AssistStructure assistStructure, ViewRootImpl viewRootImpl) {
            this.$$robo$$android_app_assist_AssistStructure_WindowNode$__constructor__(assistStructure, viewRootImpl);
        }

        WindowNode(AssistStructure assistStructure, ViewRootImpl viewRootImpl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_assist_AssistStructure_WindowNode$__constructor__(android.app.assist.AssistStructure android.view.ViewRootImpl ), 0, this, assistStructure, viewRootImpl);
        }

        private void __constructor__(ParcelTransferReader parcelTransferReader) {
            this.$$robo$$android_app_assist_AssistStructure_WindowNode$__constructor__(parcelTransferReader);
        }

        WindowNode(ParcelTransferReader parcelTransferReader) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_assist_AssistStructure_WindowNode$__constructor__(android.app.assist.AssistStructure$ParcelTransferReader ), 0, this, parcelTransferReader);
        }

        void writeSelfToParcel(Parcel parcel, PooledStringWriter pooledStringWriter, float[] fArray) {
            InvokeDynamicSupport.bootstrap("writeSelfToParcel", $$robo$$android_app_assist_AssistStructure_WindowNode$writeSelfToParcel(android.os.Parcel android.os.PooledStringWriter float[] ), 0, this, parcel, pooledStringWriter, fArray);
        }

        public int getLeft() {
            return (int)InvokeDynamicSupport.bootstrap("getLeft", $$robo$$android_app_assist_AssistStructure_WindowNode$getLeft(), 0, this);
        }

        public int getTop() {
            return (int)InvokeDynamicSupport.bootstrap("getTop", $$robo$$android_app_assist_AssistStructure_WindowNode$getTop(), 0, this);
        }

        public int getWidth() {
            return (int)InvokeDynamicSupport.bootstrap("getWidth", $$robo$$android_app_assist_AssistStructure_WindowNode$getWidth(), 0, this);
        }

        public int getHeight() {
            return (int)InvokeDynamicSupport.bootstrap("getHeight", $$robo$$android_app_assist_AssistStructure_WindowNode$getHeight(), 0, this);
        }

        public CharSequence getTitle() {
            return InvokeDynamicSupport.bootstrap("getTitle", $$robo$$android_app_assist_AssistStructure_WindowNode$getTitle(), 0, this);
        }

        public int getDisplayId() {
            return (int)InvokeDynamicSupport.bootstrap("getDisplayId", $$robo$$android_app_assist_AssistStructure_WindowNode$getDisplayId(), 0, this);
        }

        public ViewNode getRootViewNode() {
            return InvokeDynamicSupport.bootstrap("getRootViewNode", $$robo$$android_app_assist_AssistStructure_WindowNode$getRootViewNode(), 0, this);
        }

        public /* synthetic */ WindowNode() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WindowNode)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class ViewNodeText
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        CharSequence mText;
        float mTextSize;
        int mTextStyle;
        int mTextColor;
        int mTextBackgroundColor;
        int mTextSelectionStart;
        int mTextSelectionEnd;
        int[] mLineCharOffsets;
        int[] mLineBaselines;
        String mHint;

        private void $$robo$$android_app_assist_AssistStructure_ViewNodeText$__constructor__() {
            this.mTextColor = 1;
            this.mTextBackgroundColor = 1;
        }

        private final boolean $$robo$$android_app_assist_AssistStructure_ViewNodeText$isSimple() {
            return this.mTextBackgroundColor == 1 && this.mTextSelectionStart == 0 && this.mTextSelectionEnd == 0 && this.mLineCharOffsets == null && this.mLineBaselines == null && this.mHint == null;
        }

        private void $$robo$$android_app_assist_AssistStructure_ViewNodeText$__constructor__(Parcel in, boolean simple) {
            this.mTextColor = 1;
            this.mTextBackgroundColor = 1;
            this.mText = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            this.mTextSize = in.readFloat();
            this.mTextStyle = in.readInt();
            this.mTextColor = in.readInt();
            if (!simple) {
                this.mTextBackgroundColor = in.readInt();
                this.mTextSelectionStart = in.readInt();
                this.mTextSelectionEnd = in.readInt();
                this.mLineCharOffsets = in.createIntArray();
                this.mLineBaselines = in.createIntArray();
                this.mHint = in.readString();
            }
        }

        private final void $$robo$$android_app_assist_AssistStructure_ViewNodeText$writeToParcel(Parcel out, boolean simple) {
            TextUtils.writeToParcel(this.mText, out, 0);
            out.writeFloat(this.mTextSize);
            out.writeInt(this.mTextStyle);
            out.writeInt(this.mTextColor);
            if (!simple) {
                out.writeInt(this.mTextBackgroundColor);
                out.writeInt(this.mTextSelectionStart);
                out.writeInt(this.mTextSelectionEnd);
                out.writeIntArray(this.mLineCharOffsets);
                out.writeIntArray(this.mLineBaselines);
                out.writeString(this.mHint);
            }
        }

        private void __constructor__() {
            this.$$robo$$android_app_assist_AssistStructure_ViewNodeText$__constructor__();
        }

        ViewNodeText() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_assist_AssistStructure_ViewNodeText$__constructor__(), 0, this);
        }

        boolean isSimple() {
            return (boolean)InvokeDynamicSupport.bootstrap("isSimple", $$robo$$android_app_assist_AssistStructure_ViewNodeText$isSimple(), 0, this);
        }

        private void __constructor__(Parcel parcel, boolean bl) {
            this.$$robo$$android_app_assist_AssistStructure_ViewNodeText$__constructor__(parcel, bl);
        }

        ViewNodeText(Parcel parcel, boolean bl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_assist_AssistStructure_ViewNodeText$__constructor__(android.os.Parcel boolean ), 0, this, parcel, bl);
        }

        void writeToParcel(Parcel parcel, boolean bl) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_app_assist_AssistStructure_ViewNodeText$writeToParcel(android.os.Parcel boolean ), 0, this, parcel, bl);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ViewNodeText)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public final class ParcelTransferReader
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        float[] mTmpMatrix;
        PooledStringReader mStringReader;
        int mNumReadWindows;
        int mNumReadViews;
        private IBinder mChannel;
        private IBinder mTransferToken;
        private Parcel mCurParcel;
        /* synthetic */ AssistStructure this$0;

        private void $$robo$$android_app_assist_AssistStructure_ParcelTransferReader$__constructor__(AssistStructure this$0, IBinder channel) {
            this.mTmpMatrix = new float[9];
            this.mChannel = channel;
        }

        private final void $$robo$$android_app_assist_AssistStructure_ParcelTransferReader$go() {
            this.fetchData();
            this.this$0.mActivityComponent = ComponentName.readFromParcel(this.mCurParcel);
            int N = this.mCurParcel.readInt();
            if (N > 0) {
                this.mStringReader = new PooledStringReader(this.mCurParcel);
                for (int i = 0; i < N; ++i) {
                    this.this$0.mWindowNodes.add(new WindowNode(this));
                }
            }
        }

        private final Parcel $$robo$$android_app_assist_AssistStructure_ParcelTransferReader$readParcel(int validateToken, int level) {
            int token = this.mCurParcel.readInt();
            if (token != 0) {
                if (token != validateToken) {
                    throw new BadParcelableException("Got token " + Integer.toHexString(token) + ", expected token " + Integer.toHexString(validateToken));
                }
                return this.mCurParcel;
            }
            this.mTransferToken = this.mCurParcel.readStrongBinder();
            if (this.mTransferToken == null) {
                throw new IllegalStateException("Reached end of partial data without transfer token");
            }
            this.fetchData();
            this.mStringReader = new PooledStringReader(this.mCurParcel);
            this.mCurParcel.readInt();
            return this.mCurParcel;
        }

        private final void $$robo$$android_app_assist_AssistStructure_ParcelTransferReader$fetchData() {
            Parcel data = Parcel.obtain();
            data.writeInterfaceToken("android.app.AssistStructure");
            data.writeStrongBinder(this.mTransferToken);
            if (this.mCurParcel != null) {
                this.mCurParcel.recycle();
            }
            this.mCurParcel = Parcel.obtain();
            try {
                this.mChannel.transact(2, data, this.mCurParcel, 0);
            }
            catch (RemoteException e) {
                Log.w("AssistStructure", "Failure reading AssistStructure data", e);
                throw new IllegalStateException("Failure reading AssistStructure data: " + e);
            }
            data.recycle();
            this.mNumReadViews = 0;
            this.mNumReadWindows = 0;
        }

        private void __constructor__(AssistStructure assistStructure, IBinder iBinder) {
            this.$$robo$$android_app_assist_AssistStructure_ParcelTransferReader$__constructor__(assistStructure, iBinder);
        }

        ParcelTransferReader(AssistStructure assistStructure, IBinder iBinder) {
            this.this$0 = assistStructure;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_assist_AssistStructure_ParcelTransferReader$__constructor__(android.app.assist.AssistStructure android.os.IBinder ), 0, this, assistStructure, iBinder);
        }

        void go() {
            InvokeDynamicSupport.bootstrap("go", $$robo$$android_app_assist_AssistStructure_ParcelTransferReader$go(), 0, this);
        }

        Parcel readParcel(int n, int n2) {
            return InvokeDynamicSupport.bootstrap("readParcel", $$robo$$android_app_assist_AssistStructure_ParcelTransferReader$readParcel(int int ), 0, this, n, n2);
        }

        private void fetchData() {
            InvokeDynamicSupport.bootstrap("fetchData", $$robo$$android_app_assist_AssistStructure_ParcelTransferReader$fetchData(), 0, this);
        }

        public /* synthetic */ ParcelTransferReader() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ParcelTransferReader)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class ParcelTransferWriter
    extends Binder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        boolean mWriteStructure;
        int mCurWindow;
        int mNumWindows;
        ArrayList<ViewStackEntry> mViewStack;
        ViewStackEntry mCurViewStackEntry;
        int mCurViewStackPos;
        int mNumWrittenWindows;
        int mNumWrittenViews;
        float[] mTmpMatrix;

        private void $$robo$$android_app_assist_AssistStructure_ParcelTransferWriter$__constructor__(AssistStructure as, Parcel out) {
            this.mViewStack = new ArrayList();
            this.mTmpMatrix = new float[9];
            this.mWriteStructure = as.waitForReady();
            ComponentName.writeToParcel(as.mActivityComponent, out);
            this.mNumWindows = as.mWindowNodes.size();
            if (this.mWriteStructure && this.mNumWindows > 0) {
                out.writeInt(this.mNumWindows);
            } else {
                out.writeInt(0);
            }
        }

        private final void $$robo$$android_app_assist_AssistStructure_ParcelTransferWriter$writeToParcel(AssistStructure as, Parcel out) {
            int start = out.dataPosition();
            this.mNumWrittenWindows = 0;
            this.mNumWrittenViews = 0;
            boolean more = this.writeToParcelInner(as, out);
            Log.i("AssistStructure", "Flattened " + (more ? "partial" : "final") + " assist data: " + (out.dataPosition() - start) + " bytes, containing " + this.mNumWrittenWindows + " windows, " + this.mNumWrittenViews + " views");
        }

        private final boolean $$robo$$android_app_assist_AssistStructure_ParcelTransferWriter$writeToParcelInner(AssistStructure as, Parcel out) {
            if (this.mNumWindows == 0) {
                return false;
            }
            PooledStringWriter pwriter = new PooledStringWriter(out);
            while (this.writeNextEntryToParcel(as, out, pwriter)) {
                if (out.dataSize() <= 65536) continue;
                out.writeInt(0);
                out.writeStrongBinder(this);
                pwriter.finish();
                return true;
            }
            pwriter.finish();
            this.mViewStack.clear();
            return false;
        }

        private final void $$robo$$android_app_assist_AssistStructure_ParcelTransferWriter$pushViewStackEntry(ViewNode node, int pos) {
            ViewStackEntry entry;
            if (pos >= this.mViewStack.size()) {
                entry = new ViewStackEntry();
                this.mViewStack.add(entry);
            } else {
                entry = this.mViewStack.get(pos);
            }
            entry.node = node;
            entry.numChildren = node.getChildCount();
            entry.curChild = 0;
            this.mCurViewStackEntry = entry;
        }

        private final void $$robo$$android_app_assist_AssistStructure_ParcelTransferWriter$writeView(ViewNode child, Parcel out, PooledStringWriter pwriter, int levelAdj) {
            out.writeInt(0x22222222);
            int flags = child.writeSelfToParcel(out, pwriter, this.mTmpMatrix);
            ++this.mNumWrittenViews;
            if ((flags & 0x100000) != 0) {
                out.writeInt(child.mChildren.length);
                int pos = ++this.mCurViewStackPos;
                this.pushViewStackEntry(child, pos);
            }
        }

        private final boolean $$robo$$android_app_assist_AssistStructure_ParcelTransferWriter$writeNextEntryToParcel(AssistStructure as, Parcel out, PooledStringWriter pwriter) {
            int pos;
            if (this.mCurViewStackEntry != null) {
                if (this.mCurViewStackEntry.curChild < this.mCurViewStackEntry.numChildren) {
                    ViewNode child = this.mCurViewStackEntry.node.mChildren[this.mCurViewStackEntry.curChild];
                    ++this.mCurViewStackEntry.curChild;
                    this.writeView(child, out, pwriter, 1);
                    return true;
                }
                do {
                    int pos2;
                    if ((pos2 = --this.mCurViewStackPos) < 0) {
                        this.mCurViewStackEntry = null;
                        break;
                    }
                    this.mCurViewStackEntry = this.mViewStack.get(pos2);
                } while (this.mCurViewStackEntry.curChild >= this.mCurViewStackEntry.numChildren);
                return true;
            }
            if ((pos = this.mCurWindow++) < this.mNumWindows) {
                WindowNode win = as.mWindowNodes.get(pos);
                out.writeInt(0x11111111);
                win.writeSelfToParcel(out, pwriter, this.mTmpMatrix);
                ++this.mNumWrittenWindows;
                ViewNode root = win.mRoot;
                this.mCurViewStackPos = 0;
                this.writeView(root, out, pwriter, 0);
                return true;
            }
            return false;
        }

        private void __constructor__(AssistStructure assistStructure, Parcel parcel) {
            this.$$robo$$android_app_assist_AssistStructure_ParcelTransferWriter$__constructor__(assistStructure, parcel);
        }

        ParcelTransferWriter(AssistStructure assistStructure, Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_assist_AssistStructure_ParcelTransferWriter$__constructor__(android.app.assist.AssistStructure android.os.Parcel ), 0, this, assistStructure, parcel);
        }

        void writeToParcel(AssistStructure assistStructure, Parcel parcel) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_app_assist_AssistStructure_ParcelTransferWriter$writeToParcel(android.app.assist.AssistStructure android.os.Parcel ), 0, this, assistStructure, parcel);
        }

        boolean writeToParcelInner(AssistStructure assistStructure, Parcel parcel) {
            return (boolean)InvokeDynamicSupport.bootstrap("writeToParcelInner", $$robo$$android_app_assist_AssistStructure_ParcelTransferWriter$writeToParcelInner(android.app.assist.AssistStructure android.os.Parcel ), 0, this, assistStructure, parcel);
        }

        void pushViewStackEntry(ViewNode viewNode, int n) {
            InvokeDynamicSupport.bootstrap("pushViewStackEntry", $$robo$$android_app_assist_AssistStructure_ParcelTransferWriter$pushViewStackEntry(android.app.assist.AssistStructure$ViewNode int ), 0, this, viewNode, n);
        }

        void writeView(ViewNode viewNode, Parcel parcel, PooledStringWriter pooledStringWriter, int n) {
            InvokeDynamicSupport.bootstrap("writeView", $$robo$$android_app_assist_AssistStructure_ParcelTransferWriter$writeView(android.app.assist.AssistStructure$ViewNode android.os.Parcel android.os.PooledStringWriter int ), 0, this, viewNode, parcel, pooledStringWriter, n);
        }

        boolean writeNextEntryToParcel(AssistStructure assistStructure, Parcel parcel, PooledStringWriter pooledStringWriter) {
            return (boolean)InvokeDynamicSupport.bootstrap("writeNextEntryToParcel", $$robo$$android_app_assist_AssistStructure_ParcelTransferWriter$writeNextEntryToParcel(android.app.assist.AssistStructure android.os.Parcel android.os.PooledStringWriter ), 0, this, assistStructure, parcel, pooledStringWriter);
        }

        public /* synthetic */ ParcelTransferWriter() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ParcelTransferWriter)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class ViewStackEntry
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        ViewNode node;
        int curChild;
        int numChildren;

        private void $$robo$$android_app_assist_AssistStructure_ViewStackEntry$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_app_assist_AssistStructure_ViewStackEntry$__constructor__();
        }

        ViewStackEntry() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_assist_AssistStructure_ViewStackEntry$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ViewStackEntry)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class SendChannel
    extends Binder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        volatile AssistStructure mAssistStructure;

        private void $$robo$$android_app_assist_AssistStructure_SendChannel$__constructor__(AssistStructure as) {
            this.mAssistStructure = as;
        }

        private final boolean $$robo$$android_app_assist_AssistStructure_SendChannel$onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            if (code == 2) {
                AssistStructure as = this.mAssistStructure;
                if (as == null) {
                    return true;
                }
                data.enforceInterface("android.app.AssistStructure");
                IBinder token = data.readStrongBinder();
                if (token != null) {
                    if (token instanceof ParcelTransferWriter) {
                        ParcelTransferWriter xfer = (ParcelTransferWriter)token;
                        xfer.writeToParcel(as, reply);
                        return true;
                    }
                    Log.w("AssistStructure", "Caller supplied bad token type: " + token);
                    return true;
                }
                ParcelTransferWriter xfer = new ParcelTransferWriter(as, reply);
                xfer.writeToParcel(as, reply);
                return true;
            }
            return super.onTransact(code, data, reply, flags);
        }

        private void __constructor__(AssistStructure assistStructure) {
            this.$$robo$$android_app_assist_AssistStructure_SendChannel$__constructor__(assistStructure);
        }

        SendChannel(AssistStructure assistStructure) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_assist_AssistStructure_SendChannel$__constructor__(android.app.assist.AssistStructure ), 0, this, assistStructure);
        }

        @Override
        protected boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            return (boolean)InvokeDynamicSupport.bootstrap("onTransact", $$robo$$android_app_assist_AssistStructure_SendChannel$onTransact(int android.os.Parcel android.os.Parcel int ), 0, this, n, parcel, parcel2, n2);
        }

        public /* synthetic */ SendChannel() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SendChannel)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

