/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.UserHandle;
import android.util.Log;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TaskStackBuilder
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "TaskStackBuilder";
    private ArrayList<Intent> mIntents;
    private Context mSourceContext;

    private void $$robo$$android_app_TaskStackBuilder$__constructor__(Context a) {
        this.mIntents = new ArrayList();
        this.mSourceContext = a;
    }

    private static final TaskStackBuilder $$robo$$android_app_TaskStackBuilder$create(Context context) {
        return new TaskStackBuilder(context);
    }

    private final TaskStackBuilder $$robo$$android_app_TaskStackBuilder$addNextIntent(Intent nextIntent) {
        this.mIntents.add(nextIntent);
        return this;
    }

    private final TaskStackBuilder $$robo$$android_app_TaskStackBuilder$addNextIntentWithParentStack(Intent nextIntent) {
        ComponentName target = nextIntent.getComponent();
        if (target == null) {
            target = nextIntent.resolveActivity(this.mSourceContext.getPackageManager());
        }
        if (target != null) {
            this.addParentStack(target);
        }
        this.addNextIntent(nextIntent);
        return this;
    }

    private final TaskStackBuilder $$robo$$android_app_TaskStackBuilder$addParentStack(Activity sourceActivity) {
        Intent parent = sourceActivity.getParentActivityIntent();
        if (parent != null) {
            ComponentName target = parent.getComponent();
            if (target == null) {
                target = parent.resolveActivity(this.mSourceContext.getPackageManager());
            }
            this.addParentStack(target);
            this.addNextIntent(parent);
        }
        return this;
    }

    private final TaskStackBuilder $$robo$$android_app_TaskStackBuilder$addParentStack(Class<?> sourceActivityClass) {
        return this.addParentStack(new ComponentName(this.mSourceContext, sourceActivityClass));
    }

    private final TaskStackBuilder $$robo$$android_app_TaskStackBuilder$addParentStack(ComponentName sourceActivityName) {
        int insertAt = this.mIntents.size();
        PackageManager pm = this.mSourceContext.getPackageManager();
        try {
            ActivityInfo info = pm.getActivityInfo(sourceActivityName, 0);
            String parentActivity = info.parentActivityName;
            while (parentActivity != null) {
                ComponentName target = new ComponentName(info.packageName, parentActivity);
                info = pm.getActivityInfo(target, 0);
                parentActivity = info.parentActivityName;
                Intent parent = parentActivity == null && insertAt == 0 ? Intent.makeMainActivity(target) : new Intent().setComponent(target);
                this.mIntents.add(insertAt, parent);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e("TaskStackBuilder", "Bad ComponentName while traversing activity parent metadata");
            throw new IllegalArgumentException(e);
        }
        return this;
    }

    private final int $$robo$$android_app_TaskStackBuilder$getIntentCount() {
        return this.mIntents.size();
    }

    private final Intent $$robo$$android_app_TaskStackBuilder$editIntentAt(int index) {
        return this.mIntents.get(index);
    }

    private final void $$robo$$android_app_TaskStackBuilder$startActivities() {
        this.startActivities(null);
    }

    private final void $$robo$$android_app_TaskStackBuilder$startActivities(Bundle options, UserHandle userHandle) {
        if (this.mIntents.isEmpty()) {
            throw new IllegalStateException("No intents added to TaskStackBuilder; cannot startActivities");
        }
        this.mSourceContext.startActivitiesAsUser(this.getIntents(), options, userHandle);
    }

    private final void $$robo$$android_app_TaskStackBuilder$startActivities(Bundle options) {
        this.startActivities(options, new UserHandle(UserHandle.myUserId()));
    }

    private final PendingIntent $$robo$$android_app_TaskStackBuilder$getPendingIntent(int requestCode, int flags) {
        return this.getPendingIntent(requestCode, flags, null);
    }

    private final PendingIntent $$robo$$android_app_TaskStackBuilder$getPendingIntent(int requestCode, int flags, Bundle options) {
        if (this.mIntents.isEmpty()) {
            throw new IllegalStateException("No intents added to TaskStackBuilder; cannot getPendingIntent");
        }
        return PendingIntent.getActivities(this.mSourceContext, requestCode, this.getIntents(), flags, options);
    }

    private final PendingIntent $$robo$$android_app_TaskStackBuilder$getPendingIntent(int requestCode, int flags, Bundle options, UserHandle user) {
        if (this.mIntents.isEmpty()) {
            throw new IllegalStateException("No intents added to TaskStackBuilder; cannot getPendingIntent");
        }
        return PendingIntent.getActivitiesAsUser(this.mSourceContext, requestCode, this.getIntents(), flags, options, user);
    }

    private final Intent[] $$robo$$android_app_TaskStackBuilder$getIntents() {
        Intent[] intents = new Intent[this.mIntents.size()];
        if (intents.length == 0) {
            return intents;
        }
        intents[0] = new Intent(this.mIntents.get(0)).addFlags(0x1000C000);
        for (int i = 1; i < intents.length; ++i) {
            intents[i] = new Intent(this.mIntents.get(i));
        }
        return intents;
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_app_TaskStackBuilder$__constructor__(context);
    }

    private TaskStackBuilder(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_TaskStackBuilder$__constructor__(android.content.Context ), 0, this, context);
    }

    public static TaskStackBuilder create(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$android_app_TaskStackBuilder$create(android.content.Context ), 0, (Context)context);
    }

    public TaskStackBuilder addNextIntent(Intent intent) {
        return InvokeDynamicSupport.bootstrap("addNextIntent", $$robo$$android_app_TaskStackBuilder$addNextIntent(android.content.Intent ), 0, this, intent);
    }

    public TaskStackBuilder addNextIntentWithParentStack(Intent intent) {
        return InvokeDynamicSupport.bootstrap("addNextIntentWithParentStack", $$robo$$android_app_TaskStackBuilder$addNextIntentWithParentStack(android.content.Intent ), 0, this, intent);
    }

    public TaskStackBuilder addParentStack(Activity activity) {
        return InvokeDynamicSupport.bootstrap("addParentStack", $$robo$$android_app_TaskStackBuilder$addParentStack(android.app.Activity ), 0, this, activity);
    }

    public TaskStackBuilder addParentStack(Class<?> clazz) {
        return InvokeDynamicSupport.bootstrap("addParentStack", $$robo$$android_app_TaskStackBuilder$addParentStack(java.lang.Class<?> ), 0, this, clazz);
    }

    public TaskStackBuilder addParentStack(ComponentName componentName) {
        return InvokeDynamicSupport.bootstrap("addParentStack", $$robo$$android_app_TaskStackBuilder$addParentStack(android.content.ComponentName ), 0, this, componentName);
    }

    public int getIntentCount() {
        return (int)InvokeDynamicSupport.bootstrap("getIntentCount", $$robo$$android_app_TaskStackBuilder$getIntentCount(), 0, this);
    }

    public Intent editIntentAt(int n) {
        return InvokeDynamicSupport.bootstrap("editIntentAt", $$robo$$android_app_TaskStackBuilder$editIntentAt(int ), 0, this, n);
    }

    public void startActivities() {
        InvokeDynamicSupport.bootstrap("startActivities", $$robo$$android_app_TaskStackBuilder$startActivities(), 0, this);
    }

    public void startActivities(Bundle bundle, UserHandle userHandle) {
        InvokeDynamicSupport.bootstrap("startActivities", $$robo$$android_app_TaskStackBuilder$startActivities(android.os.Bundle android.os.UserHandle ), 0, this, bundle, userHandle);
    }

    public void startActivities(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("startActivities", $$robo$$android_app_TaskStackBuilder$startActivities(android.os.Bundle ), 0, this, bundle);
    }

    public PendingIntent getPendingIntent(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getPendingIntent", $$robo$$android_app_TaskStackBuilder$getPendingIntent(int int ), 0, this, n, n2);
    }

    public PendingIntent getPendingIntent(int n, int n2, Bundle bundle) {
        return InvokeDynamicSupport.bootstrap("getPendingIntent", $$robo$$android_app_TaskStackBuilder$getPendingIntent(int int android.os.Bundle ), 0, this, n, n2, bundle);
    }

    public PendingIntent getPendingIntent(int n, int n2, Bundle bundle, UserHandle userHandle) {
        return InvokeDynamicSupport.bootstrap("getPendingIntent", $$robo$$android_app_TaskStackBuilder$getPendingIntent(int int android.os.Bundle android.os.UserHandle ), 0, this, n, n2, bundle, userHandle);
    }

    public Intent[] getIntents() {
        return InvokeDynamicSupport.bootstrap("getIntents", $$robo$$android_app_TaskStackBuilder$getIntents(), 0, this);
    }

    public /* synthetic */ TaskStackBuilder() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TaskStackBuilder)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

