/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Dialog;
import android.app.SearchManager;
import android.app.SearchableInfo;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.view.ActionMode;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.Window;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.AutoCompleteTextView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.SearchView;
import android.widget.TextView;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SearchDialog
extends Dialog
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DBG = false;
    private static String LOG_TAG = "SearchDialog";
    private static String INSTANCE_KEY_COMPONENT = "comp";
    private static String INSTANCE_KEY_APPDATA = "data";
    private static String INSTANCE_KEY_USER_QUERY = "uQry";
    private static String IME_OPTION_NO_MICROPHONE = "nm";
    private static int SEARCH_PLATE_LEFT_PADDING_NON_GLOBAL = 7;
    private TextView mBadgeLabel;
    private ImageView mAppIcon;
    private AutoCompleteTextView mSearchAutoComplete;
    private View mSearchPlate;
    private SearchView mSearchView;
    private Drawable mWorkingSpinner;
    private View mCloseSearch;
    private SearchableInfo mSearchable;
    private ComponentName mLaunchComponent;
    private Bundle mAppSearchData;
    private Context mActivityContext;
    private Intent mVoiceWebSearchIntent;
    private Intent mVoiceAppSearchIntent;
    private String mUserQuery;
    private int mSearchAutoCompleteImeOptions;
    private BroadcastReceiver mConfChangeListener;
    private SearchView.OnCloseListener mOnCloseListener;
    private SearchView.OnQueryTextListener mOnQueryChangeListener;
    private SearchView.OnSuggestionListener mOnSuggestionSelectionListener;

    private static final int $$robo$$android_app_SearchDialog$resolveDialogTheme(Context context) {
        TypedValue outValue = new TypedValue();
        context.getTheme().resolveAttribute(18219053, outValue, true);
        return outValue.resourceId;
    }

    private void $$robo$$android_app_SearchDialog$__constructor__(Context context, SearchManager searchManager) {
        this.mConfChangeListener = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ SearchDialog this$0;

            private void $$robo$$android_app_SearchDialog_1$__constructor__(SearchDialog this$0) {
            }

            private final void $$robo$$android_app_SearchDialog_1$onReceive(Context context, Intent intent) {
                if (intent.getAction().equals("android.intent.action.CONFIGURATION_CHANGED")) {
                    this.this$0.onConfigurationChanged();
                }
            }

            private void __constructor__(SearchDialog searchDialog) {
                this.$$robo$$android_app_SearchDialog_1$__constructor__(searchDialog);
            }
            {
                this.this$0 = searchDialog;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_SearchDialog_1$__constructor__(android.app.SearchDialog ), 0, this, searchDialog);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$android_app_SearchDialog_1$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mOnCloseListener = new SearchView.OnCloseListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ SearchDialog this$0;

            private void $$robo$$android_app_SearchDialog_3$__constructor__(SearchDialog this$0) {
            }

            private final boolean $$robo$$android_app_SearchDialog_3$onClose() {
                return this.this$0.onClosePressed();
            }

            private void __constructor__(SearchDialog searchDialog) {
                this.$$robo$$android_app_SearchDialog_3$__constructor__(searchDialog);
            }
            {
                this.this$0 = searchDialog;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_SearchDialog_3$__constructor__(android.app.SearchDialog ), 0, this, searchDialog);
            }

            @Override
            public boolean onClose() {
                return (boolean)InvokeDynamicSupport.bootstrap("onClose", $$robo$$android_app_SearchDialog_3$onClose(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mOnQueryChangeListener = new SearchView.OnQueryTextListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ SearchDialog this$0;

            private void $$robo$$android_app_SearchDialog_4$__constructor__(SearchDialog this$0) {
            }

            private final boolean $$robo$$android_app_SearchDialog_4$onQueryTextSubmit(String query) {
                this.this$0.dismiss();
                return false;
            }

            private final boolean $$robo$$android_app_SearchDialog_4$onQueryTextChange(String newText) {
                return false;
            }

            private void __constructor__(SearchDialog searchDialog) {
                this.$$robo$$android_app_SearchDialog_4$__constructor__(searchDialog);
            }
            {
                this.this$0 = searchDialog;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_SearchDialog_4$__constructor__(android.app.SearchDialog ), 0, this, searchDialog);
            }

            @Override
            public boolean onQueryTextSubmit(String string2) {
                return (boolean)InvokeDynamicSupport.bootstrap("onQueryTextSubmit", $$robo$$android_app_SearchDialog_4$onQueryTextSubmit(java.lang.String ), 0, this, string2);
            }

            @Override
            public boolean onQueryTextChange(String string2) {
                return (boolean)InvokeDynamicSupport.bootstrap("onQueryTextChange", $$robo$$android_app_SearchDialog_4$onQueryTextChange(java.lang.String ), 0, this, string2);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mOnSuggestionSelectionListener = new SearchView.OnSuggestionListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ SearchDialog this$0;

            private void $$robo$$android_app_SearchDialog_5$__constructor__(SearchDialog this$0) {
            }

            private final boolean $$robo$$android_app_SearchDialog_5$onSuggestionSelect(int position) {
                return false;
            }

            private final boolean $$robo$$android_app_SearchDialog_5$onSuggestionClick(int position) {
                this.this$0.dismiss();
                return false;
            }

            private void __constructor__(SearchDialog searchDialog) {
                this.$$robo$$android_app_SearchDialog_5$__constructor__(searchDialog);
            }
            {
                this.this$0 = searchDialog;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_SearchDialog_5$__constructor__(android.app.SearchDialog ), 0, this, searchDialog);
            }

            @Override
            public boolean onSuggestionSelect(int n) {
                return (boolean)InvokeDynamicSupport.bootstrap("onSuggestionSelect", $$robo$$android_app_SearchDialog_5$onSuggestionSelect(int ), 0, this, n);
            }

            @Override
            public boolean onSuggestionClick(int n) {
                return (boolean)InvokeDynamicSupport.bootstrap("onSuggestionClick", $$robo$$android_app_SearchDialog_5$onSuggestionClick(int ), 0, this, n);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mVoiceWebSearchIntent = new Intent("android.speech.action.WEB_SEARCH");
        this.mVoiceWebSearchIntent.addFlags(0x10000000);
        this.mVoiceWebSearchIntent.putExtra("android.speech.extra.LANGUAGE_MODEL", "web_search");
        this.mVoiceAppSearchIntent = new Intent("android.speech.action.RECOGNIZE_SPEECH");
        this.mVoiceAppSearchIntent.addFlags(0x10000000);
    }

    private final void $$robo$$android_app_SearchDialog$onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Window theWindow = this.getWindow();
        WindowManager.LayoutParams lp = theWindow.getAttributes();
        lp.width = -1;
        lp.height = -1;
        lp.gravity = 55;
        lp.softInputMode = 16;
        theWindow.setAttributes(lp);
        this.setCanceledOnTouchOutside(true);
    }

    private final void $$robo$$android_app_SearchDialog$createContentView() {
        this.setContentView(17367254);
        this.mSearchView = (SearchView)this.findViewById(16909300);
        this.mSearchView.setIconified(false);
        this.mSearchView.setOnCloseListener(this.mOnCloseListener);
        this.mSearchView.setOnQueryTextListener(this.mOnQueryChangeListener);
        this.mSearchView.setOnSuggestionListener(this.mOnSuggestionSelectionListener);
        this.mSearchView.onActionViewExpanded();
        this.mCloseSearch = this.findViewById(16908327);
        this.mCloseSearch.setOnClickListener(new View.OnClickListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ SearchDialog this$0;

            private void $$robo$$android_app_SearchDialog_2$__constructor__(SearchDialog this$0) {
            }

            private final void $$robo$$android_app_SearchDialog_2$onClick(View v) {
                this.this$0.dismiss();
            }

            private void __constructor__(SearchDialog searchDialog) {
                this.$$robo$$android_app_SearchDialog_2$__constructor__(searchDialog);
            }
            {
                this.this$0 = searchDialog;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_SearchDialog_2$__constructor__(android.app.SearchDialog ), 0, this, searchDialog);
            }

            @Override
            public void onClick(View view) {
                InvokeDynamicSupport.bootstrap("onClick", $$robo$$android_app_SearchDialog_2$onClick(android.view.View ), 0, this, view);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        this.mBadgeLabel = (TextView)this.mSearchView.findViewById(16909302);
        this.mSearchAutoComplete = (AutoCompleteTextView)this.mSearchView.findViewById(16909307);
        this.mAppIcon = (ImageView)this.findViewById(16909299);
        this.mSearchPlate = this.mSearchView.findViewById(16909306);
        this.mWorkingSpinner = this.getContext().getDrawable(17303134);
        this.setWorking(false);
        this.mBadgeLabel.setVisibility(8);
        this.mSearchAutoCompleteImeOptions = this.mSearchAutoComplete.getImeOptions();
    }

    private final boolean $$robo$$android_app_SearchDialog$show(String initialQuery, boolean selectInitialQuery, ComponentName componentName, Bundle appSearchData) {
        boolean success = this.doShow(initialQuery, selectInitialQuery, componentName, appSearchData);
        if (success) {
            this.mSearchAutoComplete.showDropDownAfterLayout();
        }
        return success;
    }

    private final boolean $$robo$$android_app_SearchDialog$doShow(String initialQuery, boolean selectInitialQuery, ComponentName componentName, Bundle appSearchData) {
        if (!this.show(componentName, appSearchData)) {
            return false;
        }
        this.setUserQuery(initialQuery);
        if (selectInitialQuery) {
            this.mSearchAutoComplete.selectAll();
        }
        return true;
    }

    private final boolean $$robo$$android_app_SearchDialog$show(ComponentName componentName, Bundle appSearchData) {
        SearchManager searchManager = (SearchManager)this.mContext.getSystemService("search");
        this.mSearchable = searchManager.getSearchableInfo(componentName);
        if (this.mSearchable == null) {
            return false;
        }
        this.mLaunchComponent = componentName;
        this.mAppSearchData = appSearchData;
        this.mActivityContext = this.mSearchable.getActivityContext(this.getContext());
        if (!this.isShowing()) {
            this.createContentView();
            this.mSearchView.setSearchableInfo(this.mSearchable);
            this.mSearchView.setAppSearchData(this.mAppSearchData);
            this.show();
        }
        this.updateUI();
        return true;
    }

    private final void $$robo$$android_app_SearchDialog$onStart() {
        super.onStart();
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.CONFIGURATION_CHANGED");
        this.getContext().registerReceiver(this.mConfChangeListener, filter);
    }

    private final void $$robo$$android_app_SearchDialog$onStop() {
        super.onStop();
        this.getContext().unregisterReceiver(this.mConfChangeListener);
        this.mLaunchComponent = null;
        this.mAppSearchData = null;
        this.mSearchable = null;
        this.mUserQuery = null;
    }

    private final void $$robo$$android_app_SearchDialog$setWorking(boolean working) {
        this.mWorkingSpinner.setAlpha(working ? 255 : 0);
        this.mWorkingSpinner.setVisible(working, false);
        this.mWorkingSpinner.invalidateSelf();
    }

    private final Bundle $$robo$$android_app_SearchDialog$onSaveInstanceState() {
        if (!this.isShowing()) {
            return null;
        }
        Bundle bundle = new Bundle();
        bundle.putParcelable("comp", this.mLaunchComponent);
        bundle.putBundle("data", this.mAppSearchData);
        bundle.putString("uQry", this.mUserQuery);
        return bundle;
    }

    private final void $$robo$$android_app_SearchDialog$onRestoreInstanceState(Bundle savedInstanceState) {
        if (savedInstanceState == null) {
            return;
        }
        ComponentName launchComponent = (ComponentName)savedInstanceState.getParcelable("comp");
        Bundle appSearchData = savedInstanceState.getBundle("data");
        String userQuery = savedInstanceState.getString("uQry");
        if (!this.doShow(userQuery, false, launchComponent, appSearchData)) {
            return;
        }
    }

    private final void $$robo$$android_app_SearchDialog$onConfigurationChanged() {
        if (this.mSearchable != null && this.isShowing()) {
            this.updateSearchAppIcon();
            this.updateSearchBadge();
            if (SearchDialog.isLandscapeMode(this.getContext())) {
                this.mSearchAutoComplete.ensureImeVisible(true);
            }
        }
    }

    private static final boolean $$robo$$android_app_SearchDialog$isLandscapeMode(Context context) {
        return context.getResources().getConfiguration().orientation == 2;
    }

    private final void $$robo$$android_app_SearchDialog$updateUI() {
        if (this.mSearchable != null) {
            this.mDecor.setVisibility(0);
            this.updateSearchAutoComplete();
            this.updateSearchAppIcon();
            this.updateSearchBadge();
            int inputType = this.mSearchable.getInputType();
            if ((inputType & 0xF) == 1) {
                inputType &= 0xFFFEFFFF;
                if (this.mSearchable.getSuggestAuthority() != null) {
                    inputType |= 0x10000;
                }
            }
            this.mSearchAutoComplete.setInputType(inputType);
            this.mSearchAutoCompleteImeOptions = this.mSearchable.getImeOptions();
            this.mSearchAutoComplete.setImeOptions(this.mSearchAutoCompleteImeOptions);
            if (this.mSearchable.getVoiceSearchEnabled()) {
                this.mSearchAutoComplete.setPrivateImeOptions("nm");
            } else {
                this.mSearchAutoComplete.setPrivateImeOptions(null);
            }
        }
    }

    private final void $$robo$$android_app_SearchDialog$updateSearchAutoComplete() {
        this.mSearchAutoComplete.setDropDownDismissedOnCompletion(false);
        this.mSearchAutoComplete.setForceIgnoreOutsideTouch(false);
    }

    private final void $$robo$$android_app_SearchDialog$updateSearchAppIcon() {
        Drawable icon;
        PackageManager pm = this.getContext().getPackageManager();
        try {
            ActivityInfo info = pm.getActivityInfo(this.mLaunchComponent, 0);
            icon = pm.getApplicationIcon(info.applicationInfo);
        }
        catch (PackageManager.NameNotFoundException e) {
            icon = pm.getDefaultActivityIcon();
            Log.w("SearchDialog", this.mLaunchComponent + " not found, using generic app icon");
        }
        this.mAppIcon.setImageDrawable(icon);
        this.mAppIcon.setVisibility(0);
        this.mSearchPlate.setPadding(7, this.mSearchPlate.getPaddingTop(), this.mSearchPlate.getPaddingRight(), this.mSearchPlate.getPaddingBottom());
    }

    private final void $$robo$$android_app_SearchDialog$updateSearchBadge() {
        int visibility = 8;
        Drawable icon = null;
        String text = null;
        if (this.mSearchable.useBadgeIcon()) {
            icon = this.mActivityContext.getDrawable(this.mSearchable.getIconId());
            visibility = 0;
        } else if (this.mSearchable.useBadgeLabel()) {
            text = this.mActivityContext.getResources().getText(this.mSearchable.getLabelId()).toString();
            visibility = 0;
        }
        this.mBadgeLabel.setCompoundDrawablesWithIntrinsicBounds(icon, null, null, null);
        this.mBadgeLabel.setText(text);
        this.mBadgeLabel.setVisibility(visibility);
    }

    private final boolean $$robo$$android_app_SearchDialog$onTouchEvent(MotionEvent event) {
        if (!this.mSearchAutoComplete.isPopupShowing() && this.isOutOfBounds(this.mSearchPlate, event)) {
            this.cancel();
            return true;
        }
        return super.onTouchEvent(event);
    }

    private final boolean $$robo$$android_app_SearchDialog$isOutOfBounds(View v, MotionEvent event) {
        int x = (int)event.getX();
        int y = (int)event.getY();
        int slop = ViewConfiguration.get(this.mContext).getScaledWindowTouchSlop();
        return x < -slop || y < -slop || x > v.getWidth() + slop || y > v.getHeight() + slop;
    }

    private final void $$robo$$android_app_SearchDialog$hide() {
        if (!this.isShowing()) {
            return;
        }
        InputMethodManager imm = this.getContext().getSystemService(InputMethodManager.class);
        if (imm != null) {
            imm.hideSoftInputFromWindow(this.getWindow().getDecorView().getWindowToken(), 0);
        }
        super.hide();
    }

    private final void $$robo$$android_app_SearchDialog$launchQuerySearch() {
        this.launchQuerySearch(0, null);
    }

    private final void $$robo$$android_app_SearchDialog$launchQuerySearch(int actionKey, String actionMsg) {
        String query = ((Object)this.mSearchAutoComplete.getText()).toString();
        String action = "android.intent.action.SEARCH";
        Intent intent = this.createIntent(action, null, null, query, actionKey, actionMsg);
        this.launchIntent(intent);
    }

    private final void $$robo$$android_app_SearchDialog$launchIntent(Intent intent) {
        if (intent == null) {
            return;
        }
        Log.d("SearchDialog", "launching " + intent);
        try {
            this.getContext().startActivity(intent);
            this.dismiss();
        }
        catch (RuntimeException ex) {
            Log.e("SearchDialog", "Failed launch activity: " + intent, ex);
        }
    }

    private final void $$robo$$android_app_SearchDialog$setListSelection(int index) {
        this.mSearchAutoComplete.setListSelection(index);
    }

    private final Intent $$robo$$android_app_SearchDialog$createIntent(String action, Uri data, String extraData, String query, int actionKey, String actionMsg) {
        Intent intent = new Intent(action);
        intent.addFlags(0x10000000);
        if (data != null) {
            intent.setData(data);
        }
        intent.putExtra("user_query", this.mUserQuery);
        if (query != null) {
            intent.putExtra("query", query);
        }
        if (extraData != null) {
            intent.putExtra("intent_extra_data_key", extraData);
        }
        if (this.mAppSearchData != null) {
            intent.putExtra("app_data", this.mAppSearchData);
        }
        if (actionKey != 0) {
            intent.putExtra("action_key", actionKey);
            intent.putExtra("action_msg", actionMsg);
        }
        intent.setComponent(this.mSearchable.getSearchActivity());
        return intent;
    }

    private final boolean $$robo$$android_app_SearchDialog$isEmpty(AutoCompleteTextView actv) {
        return TextUtils.getTrimmedLength(actv.getText()) == 0;
    }

    private final void $$robo$$android_app_SearchDialog$onBackPressed() {
        InputMethodManager imm = this.getContext().getSystemService(InputMethodManager.class);
        if (imm != null && imm.isFullscreenMode() && imm.hideSoftInputFromWindow(this.getWindow().getDecorView().getWindowToken(), 0)) {
            return;
        }
        this.cancel();
    }

    private final boolean $$robo$$android_app_SearchDialog$onClosePressed() {
        if (this.isEmpty(this.mSearchAutoComplete)) {
            this.dismiss();
            return true;
        }
        return false;
    }

    private final void $$robo$$android_app_SearchDialog$setUserQuery(String query) {
        if (query == null) {
            query = "";
        }
        this.mUserQuery = query;
        this.mSearchAutoComplete.setText(query);
        this.mSearchAutoComplete.setSelection(query.length());
    }

    static int resolveDialogTheme(Context context) {
        return (int)InvokeDynamicSupport.bootstrapStatic("resolveDialogTheme", $$robo$$android_app_SearchDialog$resolveDialogTheme(android.content.Context ), 0, (Context)context);
    }

    private void __constructor__(Context context, SearchManager searchManager) {
        this.$$robo$$android_app_SearchDialog$__constructor__(context, searchManager);
    }

    public SearchDialog(Context context, SearchManager searchManager) {
        super(context, SearchDialog.resolveDialogTheme(context));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_SearchDialog$__constructor__(android.content.Context android.app.SearchManager ), 0, this, context, searchManager);
    }

    @Override
    protected void onCreate(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onCreate", $$robo$$android_app_SearchDialog$onCreate(android.os.Bundle ), 0, this, bundle);
    }

    private void createContentView() {
        InvokeDynamicSupport.bootstrap("createContentView", $$robo$$android_app_SearchDialog$createContentView(), 0, this);
    }

    public boolean show(String string2, boolean bl, ComponentName componentName, Bundle bundle) {
        return (boolean)InvokeDynamicSupport.bootstrap("show", $$robo$$android_app_SearchDialog$show(java.lang.String boolean android.content.ComponentName android.os.Bundle ), 0, this, string2, bl, componentName, bundle);
    }

    private boolean doShow(String string2, boolean bl, ComponentName componentName, Bundle bundle) {
        return (boolean)InvokeDynamicSupport.bootstrap("doShow", $$robo$$android_app_SearchDialog$doShow(java.lang.String boolean android.content.ComponentName android.os.Bundle ), 0, this, string2, bl, componentName, bundle);
    }

    private boolean show(ComponentName componentName, Bundle bundle) {
        return (boolean)InvokeDynamicSupport.bootstrap("show", $$robo$$android_app_SearchDialog$show(android.content.ComponentName android.os.Bundle ), 0, this, componentName, bundle);
    }

    @Override
    public void onStart() {
        InvokeDynamicSupport.bootstrap("onStart", $$robo$$android_app_SearchDialog$onStart(), 0, this);
    }

    @Override
    public void onStop() {
        InvokeDynamicSupport.bootstrap("onStop", $$robo$$android_app_SearchDialog$onStop(), 0, this);
    }

    public void setWorking(boolean bl) {
        InvokeDynamicSupport.bootstrap("setWorking", $$robo$$android_app_SearchDialog$setWorking(boolean ), 0, this, bl);
    }

    @Override
    public Bundle onSaveInstanceState() {
        return InvokeDynamicSupport.bootstrap("onSaveInstanceState", $$robo$$android_app_SearchDialog$onSaveInstanceState(), 0, this);
    }

    @Override
    public void onRestoreInstanceState(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onRestoreInstanceState", $$robo$$android_app_SearchDialog$onRestoreInstanceState(android.os.Bundle ), 0, this, bundle);
    }

    public void onConfigurationChanged() {
        InvokeDynamicSupport.bootstrap("onConfigurationChanged", $$robo$$android_app_SearchDialog$onConfigurationChanged(), 0, this);
    }

    static boolean isLandscapeMode(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isLandscapeMode", $$robo$$android_app_SearchDialog$isLandscapeMode(android.content.Context ), 0, (Context)context);
    }

    private void updateUI() {
        InvokeDynamicSupport.bootstrap("updateUI", $$robo$$android_app_SearchDialog$updateUI(), 0, this);
    }

    private void updateSearchAutoComplete() {
        InvokeDynamicSupport.bootstrap("updateSearchAutoComplete", $$robo$$android_app_SearchDialog$updateSearchAutoComplete(), 0, this);
    }

    private void updateSearchAppIcon() {
        InvokeDynamicSupport.bootstrap("updateSearchAppIcon", $$robo$$android_app_SearchDialog$updateSearchAppIcon(), 0, this);
    }

    private void updateSearchBadge() {
        InvokeDynamicSupport.bootstrap("updateSearchBadge", $$robo$$android_app_SearchDialog$updateSearchBadge(), 0, this);
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$android_app_SearchDialog$onTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private boolean isOutOfBounds(View view, MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("isOutOfBounds", $$robo$$android_app_SearchDialog$isOutOfBounds(android.view.View android.view.MotionEvent ), 0, this, view, motionEvent);
    }

    @Override
    public void hide() {
        InvokeDynamicSupport.bootstrap("hide", $$robo$$android_app_SearchDialog$hide(), 0, this);
    }

    public void launchQuerySearch() {
        InvokeDynamicSupport.bootstrap("launchQuerySearch", $$robo$$android_app_SearchDialog$launchQuerySearch(), 0, this);
    }

    protected void launchQuerySearch(int n, String string2) {
        InvokeDynamicSupport.bootstrap("launchQuerySearch", $$robo$$android_app_SearchDialog$launchQuerySearch(int java.lang.String ), 0, this, n, string2);
    }

    private void launchIntent(Intent intent) {
        InvokeDynamicSupport.bootstrap("launchIntent", $$robo$$android_app_SearchDialog$launchIntent(android.content.Intent ), 0, this, intent);
    }

    public void setListSelection(int n) {
        InvokeDynamicSupport.bootstrap("setListSelection", $$robo$$android_app_SearchDialog$setListSelection(int ), 0, this, n);
    }

    private Intent createIntent(String string2, Uri uri, String string3, String string4, int n, String string5) {
        return InvokeDynamicSupport.bootstrap("createIntent", $$robo$$android_app_SearchDialog$createIntent(java.lang.String android.net.Uri java.lang.String java.lang.String int java.lang.String ), 0, this, string2, uri, string3, string4, n, string5);
    }

    private boolean isEmpty(AutoCompleteTextView autoCompleteTextView) {
        return (boolean)InvokeDynamicSupport.bootstrap("isEmpty", $$robo$$android_app_SearchDialog$isEmpty(android.widget.AutoCompleteTextView ), 0, this, autoCompleteTextView);
    }

    @Override
    public void onBackPressed() {
        InvokeDynamicSupport.bootstrap("onBackPressed", $$robo$$android_app_SearchDialog$onBackPressed(), 0, this);
    }

    private boolean onClosePressed() {
        return (boolean)InvokeDynamicSupport.bootstrap("onClosePressed", $$robo$$android_app_SearchDialog$onClosePressed(), 0, this);
    }

    private void setUserQuery(String string2) {
        InvokeDynamicSupport.bootstrap("setUserQuery", $$robo$$android_app_SearchDialog$setUserQuery(java.lang.String ), 0, this, string2);
    }

    public /* synthetic */ SearchDialog() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SearchDialog)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class SearchBar
    extends LinearLayout
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_app_SearchDialog_SearchBar$__constructor__(Context context, AttributeSet attrs) {
        }

        private void $$robo$$android_app_SearchDialog_SearchBar$__constructor__(Context context) {
        }

        private final ActionMode $$robo$$android_app_SearchDialog_SearchBar$startActionModeForChild(View child, ActionMode.Callback callback, int type) {
            if (type != 0) {
                return super.startActionModeForChild(child, callback, type);
            }
            return null;
        }

        private void __constructor__(Context context, AttributeSet attributeSet) {
            this.$$robo$$android_app_SearchDialog_SearchBar$__constructor__(context, attributeSet);
        }

        public SearchBar(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_SearchDialog_SearchBar$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
        }

        private void __constructor__(Context context) {
            this.$$robo$$android_app_SearchDialog_SearchBar$__constructor__(context);
        }

        public SearchBar(Context context) {
            super(context);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_SearchDialog_SearchBar$__constructor__(android.content.Context ), 0, this, context);
        }

        @Override
        public ActionMode startActionModeForChild(View view, ActionMode.Callback callback, int n) {
            return InvokeDynamicSupport.bootstrap("startActionModeForChild", $$robo$$android_app_SearchDialog_SearchBar$startActionModeForChild(android.view.View android.view.ActionMode$Callback int ), 0, this, view, callback, n);
        }

        public /* synthetic */ SearchBar() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SearchBar)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

