/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.PendingIntent;
import android.app.RemoteInput;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.ColorStateList;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.media.AudioAttributes;
import android.media.session.MediaSession;
import android.net.Uri;
import android.os.BadParcelableException;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.os.UserHandle;
import android.text.BidiFormatter;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.CharacterStyle;
import android.text.style.RelativeSizeSpan;
import android.text.style.TextAppearanceSpan;
import android.util.ArraySet;
import android.util.Log;
import android.util.SparseArray;
import android.widget.RemoteViews;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.NotificationColorUtil;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Notification
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "Notification";
    public static String INTENT_CATEGORY_NOTIFICATION_PREFERENCES = "android.intent.category.NOTIFICATION_PREFERENCES";
    public static int DEFAULT_ALL = -1;
    public static int DEFAULT_SOUND = 1;
    public static int DEFAULT_VIBRATE = 2;
    public static int DEFAULT_LIGHTS = 4;
    private static int MAX_CHARSEQUENCE_LENGTH = 5120;
    private static int MAX_REPLY_HISTORY = 5;
    public long when;
    private long creationTime;
    @Deprecated
    public int icon;
    public int iconLevel;
    public int number;
    public PendingIntent contentIntent;
    public PendingIntent deleteIntent;
    public PendingIntent fullScreenIntent;
    public CharSequence tickerText;
    @Deprecated
    public RemoteViews tickerView;
    @Deprecated
    public RemoteViews contentView;
    @Deprecated
    public RemoteViews bigContentView;
    @Deprecated
    public RemoteViews headsUpContentView;
    @Deprecated
    public Bitmap largeIcon;
    public Uri sound;
    @Deprecated
    public static int STREAM_DEFAULT = -1;
    @Deprecated
    public int audioStreamType;
    public static AudioAttributes AUDIO_ATTRIBUTES_DEFAULT;
    public AudioAttributes audioAttributes;
    public long[] vibrate;
    public int ledARGB;
    public int ledOnMS;
    public int ledOffMS;
    public int defaults;
    public static int FLAG_SHOW_LIGHTS = 1;
    public static int FLAG_ONGOING_EVENT = 2;
    public static int FLAG_INSISTENT = 4;
    public static int FLAG_ONLY_ALERT_ONCE = 8;
    public static int FLAG_AUTO_CANCEL = 16;
    public static int FLAG_NO_CLEAR = 32;
    public static int FLAG_FOREGROUND_SERVICE = 64;
    public static int FLAG_HIGH_PRIORITY = 128;
    public static int FLAG_LOCAL_ONLY = 256;
    public static int FLAG_GROUP_SUMMARY = 512;
    public static int FLAG_AUTOGROUP_SUMMARY = 1024;
    public int flags;
    public static int PRIORITY_DEFAULT = 0;
    public static int PRIORITY_LOW = -1;
    public static int PRIORITY_MIN = -2;
    public static int PRIORITY_HIGH = 1;
    public static int PRIORITY_MAX = 2;
    public int priority;
    public int color;
    public static int COLOR_DEFAULT = 0;
    private static int COLOR_INVALID = 1;
    public int visibility;
    public static int VISIBILITY_PUBLIC = 1;
    public static int VISIBILITY_PRIVATE = 0;
    public static int VISIBILITY_SECRET = -1;
    public static String CATEGORY_CALL = "call";
    public static String CATEGORY_MESSAGE = "msg";
    public static String CATEGORY_EMAIL = "email";
    public static String CATEGORY_EVENT = "event";
    public static String CATEGORY_PROMO = "promo";
    public static String CATEGORY_ALARM = "alarm";
    public static String CATEGORY_PROGRESS = "progress";
    public static String CATEGORY_SOCIAL = "social";
    public static String CATEGORY_ERROR = "err";
    public static String CATEGORY_TRANSPORT = "transport";
    public static String CATEGORY_SYSTEM = "sys";
    public static String CATEGORY_SERVICE = "service";
    public static String CATEGORY_RECOMMENDATION = "recommendation";
    public static String CATEGORY_STATUS = "status";
    public static String CATEGORY_REMINDER = "reminder";
    public String category;
    private String mGroupKey;
    private String mSortKey;
    public Bundle extras;
    public ArraySet<PendingIntent> allPendingIntents;
    public static String EXTRA_TITLE = "android.title";
    public static String EXTRA_TITLE_BIG = "android.title.big";
    public static String EXTRA_TEXT = "android.text";
    public static String EXTRA_SUB_TEXT = "android.subText";
    public static String EXTRA_REMOTE_INPUT_HISTORY = "android.remoteInputHistory";
    public static String EXTRA_INFO_TEXT = "android.infoText";
    public static String EXTRA_SUMMARY_TEXT = "android.summaryText";
    public static String EXTRA_BIG_TEXT = "android.bigText";
    public static String EXTRA_SMALL_ICON = "android.icon";
    public static String EXTRA_LARGE_ICON = "android.largeIcon";
    public static String EXTRA_LARGE_ICON_BIG = "android.largeIcon.big";
    public static String EXTRA_PROGRESS = "android.progress";
    public static String EXTRA_PROGRESS_MAX = "android.progressMax";
    public static String EXTRA_PROGRESS_INDETERMINATE = "android.progressIndeterminate";
    public static String EXTRA_SHOW_CHRONOMETER = "android.showChronometer";
    public static String EXTRA_CHRONOMETER_COUNT_DOWN = "android.chronometerCountDown";
    public static String EXTRA_SHOW_WHEN = "android.showWhen";
    public static String EXTRA_PICTURE = "android.picture";
    public static String EXTRA_TEXT_LINES = "android.textLines";
    public static String EXTRA_TEMPLATE = "android.template";
    public static String EXTRA_PEOPLE = "android.people";
    public static String EXTRA_ALLOW_DURING_SETUP = "android.allowDuringSetup";
    public static String EXTRA_BACKGROUND_IMAGE_URI = "android.backgroundImageUri";
    public static String EXTRA_MEDIA_SESSION = "android.mediaSession";
    public static String EXTRA_COMPACT_ACTIONS = "android.compactActions";
    public static String EXTRA_SELF_DISPLAY_NAME = "android.selfDisplayName";
    public static String EXTRA_CONVERSATION_TITLE = "android.conversationTitle";
    public static String EXTRA_MESSAGES = "android.messages";
    public static String EXTRA_ORIGINATING_USERID = "android.originatingUserId";
    public static String EXTRA_BUILDER_APPLICATION_INFO = "android.appInfo";
    public static String EXTRA_CONTAINS_CUSTOM_VIEW = "android.contains.customView";
    public static String EXTRA_SUBSTITUTE_APP_NAME = "android.substName";
    private Icon mSmallIcon;
    private Icon mLargeIcon;
    public Action[] actions;
    public Notification publicVersion;
    public static Parcelable.Creator<Notification> CREATOR;

    private final String $$robo$$android_app_Notification$getGroup() {
        return this.mGroupKey;
    }

    private final String $$robo$$android_app_Notification$getSortKey() {
        return this.mSortKey;
    }

    private void $$robo$$android_app_Notification$__constructor__() {
        this.audioStreamType = -1;
        this.audioAttributes = AUDIO_ATTRIBUTES_DEFAULT;
        this.color = 0;
        this.extras = new Bundle();
        this.when = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        this.creationTime = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        this.priority = 0;
    }

    private void $$robo$$android_app_Notification$__constructor__(Context context, int icon, CharSequence tickerText, long when, CharSequence contentTitle, CharSequence contentText, Intent contentIntent) {
        this.audioStreamType = -1;
        this.audioAttributes = AUDIO_ATTRIBUTES_DEFAULT;
        this.color = 0;
        this.extras = new Bundle();
        new Builder(context).setWhen(when).setSmallIcon(icon).setTicker(tickerText).setContentTitle(contentTitle).setContentText(contentText).setContentIntent(PendingIntent.getActivity(context, 0, contentIntent, 0)).buildInto(this);
    }

    @Deprecated
    private void $$robo$$android_app_Notification$__constructor__(int icon, CharSequence tickerText, long when) {
        this.audioStreamType = -1;
        this.audioAttributes = AUDIO_ATTRIBUTES_DEFAULT;
        this.color = 0;
        this.extras = new Bundle();
        this.icon = icon;
        this.tickerText = tickerText;
        this.when = when;
        this.creationTime = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
    }

    private void $$robo$$android_app_Notification$__constructor__(Parcel parcel) {
        this.audioStreamType = -1;
        this.audioAttributes = AUDIO_ATTRIBUTES_DEFAULT;
        this.color = 0;
        this.extras = new Bundle();
        this.readFromParcelImpl(parcel);
        this.allPendingIntents = parcel.readArraySet(null);
    }

    private final void $$robo$$android_app_Notification$readFromParcelImpl(Parcel parcel) {
        int version = parcel.readInt();
        this.when = parcel.readLong();
        this.creationTime = parcel.readLong();
        if (parcel.readInt() != 0) {
            this.mSmallIcon = Icon.CREATOR.createFromParcel(parcel);
            if (this.mSmallIcon.getType() == 2) {
                this.icon = this.mSmallIcon.getResId();
            }
        }
        this.number = parcel.readInt();
        if (parcel.readInt() != 0) {
            this.contentIntent = PendingIntent.CREATOR.createFromParcel(parcel);
        }
        if (parcel.readInt() != 0) {
            this.deleteIntent = PendingIntent.CREATOR.createFromParcel(parcel);
        }
        if (parcel.readInt() != 0) {
            this.tickerText = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
        }
        if (parcel.readInt() != 0) {
            this.tickerView = RemoteViews.CREATOR.createFromParcel(parcel);
        }
        if (parcel.readInt() != 0) {
            this.contentView = RemoteViews.CREATOR.createFromParcel(parcel);
        }
        if (parcel.readInt() != 0) {
            this.mLargeIcon = Icon.CREATOR.createFromParcel(parcel);
        }
        this.defaults = parcel.readInt();
        this.flags = parcel.readInt();
        if (parcel.readInt() != 0) {
            this.sound = Uri.CREATOR.createFromParcel(parcel);
        }
        this.audioStreamType = parcel.readInt();
        if (parcel.readInt() != 0) {
            this.audioAttributes = AudioAttributes.CREATOR.createFromParcel(parcel);
        }
        this.vibrate = parcel.createLongArray();
        this.ledARGB = parcel.readInt();
        this.ledOnMS = parcel.readInt();
        this.ledOffMS = parcel.readInt();
        this.iconLevel = parcel.readInt();
        if (parcel.readInt() != 0) {
            this.fullScreenIntent = PendingIntent.CREATOR.createFromParcel(parcel);
        }
        this.priority = parcel.readInt();
        this.category = parcel.readString();
        this.mGroupKey = parcel.readString();
        this.mSortKey = parcel.readString();
        this.extras = Bundle.setDefusable(parcel.readBundle(), true);
        this.actions = parcel.createTypedArray(Action.CREATOR);
        if (parcel.readInt() != 0) {
            this.bigContentView = RemoteViews.CREATOR.createFromParcel(parcel);
        }
        if (parcel.readInt() != 0) {
            this.headsUpContentView = RemoteViews.CREATOR.createFromParcel(parcel);
        }
        this.visibility = parcel.readInt();
        if (parcel.readInt() != 0) {
            this.publicVersion = CREATOR.createFromParcel(parcel);
        }
        this.color = parcel.readInt();
    }

    private final Notification $$robo$$android_app_Notification$clone() {
        Notification that = new Notification();
        this.cloneInto(that, true);
        return that;
    }

    private final void $$robo$$android_app_Notification$cloneInto(Notification that, boolean heavy) {
        long[] vibrate;
        that.when = this.when;
        that.creationTime = this.creationTime;
        that.mSmallIcon = this.mSmallIcon;
        that.number = this.number;
        that.contentIntent = this.contentIntent;
        that.deleteIntent = this.deleteIntent;
        that.fullScreenIntent = this.fullScreenIntent;
        if (this.tickerText != null) {
            that.tickerText = this.tickerText.toString();
        }
        if (heavy && this.tickerView != null) {
            that.tickerView = this.tickerView.clone();
        }
        if (heavy && this.contentView != null) {
            that.contentView = this.contentView.clone();
        }
        if (heavy && this.mLargeIcon != null) {
            that.mLargeIcon = this.mLargeIcon;
        }
        that.iconLevel = this.iconLevel;
        that.sound = this.sound;
        that.audioStreamType = this.audioStreamType;
        if (this.audioAttributes != null) {
            that.audioAttributes = new AudioAttributes.Builder(this.audioAttributes).build();
        }
        if ((vibrate = this.vibrate) != null) {
            int N = vibrate.length;
            that.vibrate = new long[N];
            long[] vib = that.vibrate;
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (long[])vibrate, (int)0, (long[])vib, (int)0, (int)N);
        }
        that.ledARGB = this.ledARGB;
        that.ledOnMS = this.ledOnMS;
        that.ledOffMS = this.ledOffMS;
        that.defaults = this.defaults;
        that.flags = this.flags;
        that.priority = this.priority;
        that.category = this.category;
        that.mGroupKey = this.mGroupKey;
        that.mSortKey = this.mSortKey;
        if (this.extras != null) {
            try {
                that.extras = new Bundle(this.extras);
                that.extras.size();
            }
            catch (BadParcelableException e) {
                Log.e("Notification", "could not unparcel extras from notification: " + this, e);
                that.extras = null;
            }
        }
        if (!ArrayUtils.isEmpty(this.allPendingIntents)) {
            that.allPendingIntents = new ArraySet<PendingIntent>(this.allPendingIntents);
        }
        if (this.actions != null) {
            that.actions = new Action[this.actions.length];
            for (int i = 0; i < this.actions.length; ++i) {
                that.actions[i] = this.actions[i].clone();
            }
        }
        if (heavy && this.bigContentView != null) {
            that.bigContentView = this.bigContentView.clone();
        }
        if (heavy && this.headsUpContentView != null) {
            that.headsUpContentView = this.headsUpContentView.clone();
        }
        that.visibility = this.visibility;
        if (this.publicVersion != null) {
            that.publicVersion = new Notification();
            this.publicVersion.cloneInto(that.publicVersion, heavy);
        }
        that.color = this.color;
        if (!heavy) {
            that.lightenPayload();
        }
    }

    private final void $$robo$$android_app_Notification$lightenPayload() {
        this.tickerView = null;
        this.contentView = null;
        this.bigContentView = null;
        this.headsUpContentView = null;
        this.mLargeIcon = null;
        if (this.extras != null && !this.extras.isEmpty()) {
            Set<String> keyset = this.extras.keySet();
            int N = keyset.size();
            String[] keys = keyset.toArray(new String[N]);
            for (int i = 0; i < N; ++i) {
                String key = keys[i];
                Object obj = this.extras.get(key);
                if (obj == null || !(obj instanceof Parcelable) && !(obj instanceof Parcelable[]) && !(obj instanceof SparseArray) && !(obj instanceof ArrayList)) continue;
                this.extras.remove(key);
            }
        }
    }

    private static final CharSequence $$robo$$android_app_Notification$safeCharSequence(CharSequence cs) {
        if (cs == null) {
            return cs;
        }
        if (cs.length() > 5120) {
            cs = cs.subSequence(0, 5120);
        }
        if (cs instanceof Parcelable) {
            Log.e("Notification", "warning: " + cs.getClass().getCanonicalName() + " instance is a custom Parcelable and not allowed in Notification");
            return cs.toString();
        }
        return Notification.removeTextSizeSpans(cs);
    }

    private static final CharSequence $$robo$$android_app_Notification$removeTextSizeSpans(CharSequence charSequence) {
        if (charSequence instanceof Spanned) {
            Spanned ss = (Spanned)charSequence;
            Object[] spans = ss.getSpans(0, ss.length(), Object.class);
            SpannableStringBuilder builder = new SpannableStringBuilder(ss.toString());
            for (Object span : spans) {
                Object resultSpan = span;
                if (resultSpan instanceof CharacterStyle) {
                    resultSpan = ((CharacterStyle)span).getUnderlying();
                }
                if (resultSpan instanceof TextAppearanceSpan) {
                    TextAppearanceSpan originalSpan = (TextAppearanceSpan)resultSpan;
                    resultSpan = new TextAppearanceSpan(originalSpan.getFamily(), originalSpan.getTextStyle(), -1, originalSpan.getTextColor(), originalSpan.getLinkTextColor());
                } else {
                    if (resultSpan instanceof RelativeSizeSpan || resultSpan instanceof AbsoluteSizeSpan) continue;
                    resultSpan = span;
                }
                builder.setSpan(resultSpan, ss.getSpanStart(span), ss.getSpanEnd(span), ss.getSpanFlags(span));
            }
            return builder;
        }
        return charSequence;
    }

    private final int $$robo$$android_app_Notification$describeContents() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_Notification$writeToParcel(Parcel parcel, int flags) {
        boolean collectPendingIntents;
        boolean bl = collectPendingIntents = this.allPendingIntents == null;
        if (collectPendingIntents) {
            PendingIntent.setOnMarshaledListener((intent, out, outFlags) -> {
                if (parcel == out) {
                    if (this.allPendingIntents == null) {
                        this.allPendingIntents = new ArraySet();
                    }
                    this.allPendingIntents.add(intent);
                }
            });
        }
        try {
            this.writeToParcelImpl(parcel, flags);
            parcel.writeArraySet(this.allPendingIntents);
        }
        finally {
            if (collectPendingIntents) {
                PendingIntent.setOnMarshaledListener(null);
            }
        }
    }

    private final void $$robo$$android_app_Notification$writeToParcelImpl(Parcel parcel, int flags) {
        parcel.writeInt(1);
        parcel.writeLong(this.when);
        parcel.writeLong(this.creationTime);
        if (this.mSmallIcon == null && this.icon != 0) {
            this.mSmallIcon = Icon.createWithResource("", this.icon);
        }
        if (this.mSmallIcon != null) {
            parcel.writeInt(1);
            this.mSmallIcon.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.number);
        if (this.contentIntent != null) {
            parcel.writeInt(1);
            this.contentIntent.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        if (this.deleteIntent != null) {
            parcel.writeInt(1);
            this.deleteIntent.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        if (this.tickerText != null) {
            parcel.writeInt(1);
            TextUtils.writeToParcel(this.tickerText, parcel, flags);
        } else {
            parcel.writeInt(0);
        }
        if (this.tickerView != null) {
            parcel.writeInt(1);
            this.tickerView.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        if (this.contentView != null) {
            parcel.writeInt(1);
            this.contentView.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        if (this.mLargeIcon == null && this.largeIcon != null) {
            this.mLargeIcon = Icon.createWithBitmap(this.largeIcon);
        }
        if (this.mLargeIcon != null) {
            parcel.writeInt(1);
            this.mLargeIcon.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.defaults);
        parcel.writeInt(this.flags);
        if (this.sound != null) {
            parcel.writeInt(1);
            this.sound.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.audioStreamType);
        if (this.audioAttributes != null) {
            parcel.writeInt(1);
            this.audioAttributes.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeLongArray(this.vibrate);
        parcel.writeInt(this.ledARGB);
        parcel.writeInt(this.ledOnMS);
        parcel.writeInt(this.ledOffMS);
        parcel.writeInt(this.iconLevel);
        if (this.fullScreenIntent != null) {
            parcel.writeInt(1);
            this.fullScreenIntent.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.priority);
        parcel.writeString(this.category);
        parcel.writeString(this.mGroupKey);
        parcel.writeString(this.mSortKey);
        parcel.writeBundle(this.extras);
        parcel.writeTypedArray(this.actions, 0);
        if (this.bigContentView != null) {
            parcel.writeInt(1);
            this.bigContentView.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        if (this.headsUpContentView != null) {
            parcel.writeInt(1);
            this.headsUpContentView.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.visibility);
        if (this.publicVersion != null) {
            parcel.writeInt(1);
            this.publicVersion.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.color);
    }

    @Deprecated
    private final void $$robo$$android_app_Notification$setLatestEventInfo(Context context, CharSequence contentTitle, CharSequence contentText, PendingIntent contentIntent) {
        if (context.getApplicationInfo().targetSdkVersion > 22) {
            Log.e("Notification", "setLatestEventInfo() is deprecated and you should feel deprecated.", new Throwable());
        }
        if (context.getApplicationInfo().targetSdkVersion < 24) {
            this.extras.putBoolean("android.showWhen", true);
        }
        Builder builder = new Builder(context, this);
        if (contentTitle != null) {
            builder.setContentTitle(contentTitle);
        }
        if (contentText != null) {
            builder.setContentText(contentText);
        }
        builder.setContentIntent(contentIntent);
        builder.build();
    }

    private static final void $$robo$$android_app_Notification$addFieldsFromContext(Context context, Notification notification) {
        Notification.addFieldsFromContext(context.getApplicationInfo(), context.getUserId(), notification);
    }

    private static final void $$robo$$android_app_Notification$addFieldsFromContext(ApplicationInfo ai, int userId, Notification notification) {
        notification.extras.putParcelable("android.appInfo", ai);
        notification.extras.putInt("android.originatingUserId", userId);
    }

    private final String $$robo$$android_app_Notification$toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Notification(pri=");
        sb.append(this.priority);
        sb.append(" contentView=");
        if (this.contentView != null) {
            sb.append(this.contentView.getPackage());
            sb.append("/0x");
            sb.append(Integer.toHexString(this.contentView.getLayoutId()));
        } else {
            sb.append("null");
        }
        sb.append(" vibrate=");
        if ((this.defaults & 2) != 0) {
            sb.append("default");
        } else if (this.vibrate != null) {
            int N = this.vibrate.length - 1;
            sb.append("[");
            for (int i = 0; i < N; ++i) {
                sb.append(this.vibrate[i]);
                sb.append(',');
            }
            if (N != -1) {
                sb.append(this.vibrate[N]);
            }
            sb.append("]");
        } else {
            sb.append("null");
        }
        sb.append(" sound=");
        if ((this.defaults & 1) != 0) {
            sb.append("default");
        } else if (this.sound != null) {
            sb.append(this.sound.toString());
        } else {
            sb.append("null");
        }
        if (this.tickerText != null) {
            sb.append(" tick");
        }
        sb.append(" defaults=0x");
        sb.append(Integer.toHexString(this.defaults));
        sb.append(" flags=0x");
        sb.append(Integer.toHexString(this.flags));
        sb.append(String.format(" color=0x%08x", this.color));
        if (this.category != null) {
            sb.append(" category=");
            sb.append(this.category);
        }
        if (this.mGroupKey != null) {
            sb.append(" groupKey=");
            sb.append(this.mGroupKey);
        }
        if (this.mSortKey != null) {
            sb.append(" sortKey=");
            sb.append(this.mSortKey);
        }
        if (this.actions != null) {
            sb.append(" actions=");
            sb.append(this.actions.length);
        }
        sb.append(" vis=");
        sb.append(Notification.visibilityToString(this.visibility));
        if (this.publicVersion != null) {
            sb.append(" publicVersion=");
            sb.append(this.publicVersion.toString());
        }
        sb.append(")");
        return sb.toString();
    }

    private static final String $$robo$$android_app_Notification$visibilityToString(int vis) {
        switch (vis) {
            case 0: {
                return "PRIVATE";
            }
            case 1: {
                return "PUBLIC";
            }
            case -1: {
                return "SECRET";
            }
        }
        return "UNKNOWN(" + String.valueOf(vis) + ")";
    }

    private static final String $$robo$$android_app_Notification$priorityToString(int pri) {
        switch (pri) {
            case -2: {
                return "MIN";
            }
            case -1: {
                return "LOW";
            }
            case 0: {
                return "DEFAULT";
            }
            case 1: {
                return "HIGH";
            }
            case 2: {
                return "MAX";
            }
        }
        return "UNKNOWN(" + String.valueOf(pri) + ")";
    }

    private final Icon $$robo$$android_app_Notification$getSmallIcon() {
        return this.mSmallIcon;
    }

    private final void $$robo$$android_app_Notification$setSmallIcon(Icon icon) {
        this.mSmallIcon = icon;
    }

    private final Icon $$robo$$android_app_Notification$getLargeIcon() {
        return this.mLargeIcon;
    }

    private final boolean $$robo$$android_app_Notification$isGroupSummary() {
        return this.mGroupKey != null && (this.flags & 0x200) != 0;
    }

    private final boolean $$robo$$android_app_Notification$isGroupChild() {
        return this.mGroupKey != null && (this.flags & 0x200) == 0;
    }

    private final boolean $$robo$$android_app_Notification$hasLargeIcon() {
        return this.mLargeIcon != null || this.largeIcon != null;
    }

    private final boolean $$robo$$android_app_Notification$showsTime() {
        return this.when != 0L && this.extras.getBoolean("android.showWhen");
    }

    private final boolean $$robo$$android_app_Notification$showsChronometer() {
        return this.when != 0L && this.extras.getBoolean("android.showChronometer");
    }

    private static final Notification[] $$robo$$android_app_Notification$getNotificationArrayFromBundle(Bundle bundle, String key) {
        Parcelable[] array2 = bundle.getParcelableArray(key);
        if (array2 instanceof Notification[] || array2 == null) {
            return (Notification[])array2;
        }
        Parcelable[] typedArray = (Notification[])Arrays.copyOf(array2, array2.length, Notification[].class);
        bundle.putParcelableArray(key, typedArray);
        return typedArray;
    }

    static void __staticInitializer__() {
        AUDIO_ATTRIBUTES_DEFAULT = new AudioAttributes.Builder().setContentType(4).setUsage(5).build();
        CREATOR = new Parcelable.Creator<Notification>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_app_Notification_1$__constructor__() {
            }

            private final Notification $$robo$$android_app_Notification_1$createFromParcel(Parcel parcel) {
                return new Notification(parcel);
            }

            private final Notification[] $$robo$$android_app_Notification_1$newArray(int size) {
                return new Notification[size];
            }

            private void __constructor__() {
                this.$$robo$$android_app_Notification_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_1$__constructor__(), 0, this);
            }

            @Override
            public Notification createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_app_Notification_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public Notification[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_app_Notification_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    public String getGroup() {
        return InvokeDynamicSupport.bootstrap("getGroup", $$robo$$android_app_Notification$getGroup(), 0, this);
    }

    public String getSortKey() {
        return InvokeDynamicSupport.bootstrap("getSortKey", $$robo$$android_app_Notification$getSortKey(), 0, this);
    }

    private void __constructor__() {
        this.$$robo$$android_app_Notification$__constructor__();
    }

    public Notification() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification$__constructor__(), 0, this);
    }

    private void __constructor__(Context context, int n, CharSequence charSequence, long l, CharSequence charSequence2, CharSequence charSequence3, Intent intent) {
        this.$$robo$$android_app_Notification$__constructor__(context, n, charSequence, l, charSequence2, charSequence3, intent);
    }

    public Notification(Context context, int n, CharSequence charSequence, long l, CharSequence charSequence2, CharSequence charSequence3, Intent intent) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification$__constructor__(android.content.Context int java.lang.CharSequence long java.lang.CharSequence java.lang.CharSequence android.content.Intent ), 0, this, context, n, charSequence, l, charSequence2, charSequence3, intent);
    }

    private void __constructor__(int n, CharSequence charSequence, long l) {
        this.$$robo$$android_app_Notification$__constructor__(n, charSequence, l);
    }

    public Notification(int n, CharSequence charSequence, long l) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification$__constructor__(int java.lang.CharSequence long ), 0, this, n, charSequence, l);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_app_Notification$__constructor__(parcel);
    }

    public Notification(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    private void readFromParcelImpl(Parcel parcel) {
        InvokeDynamicSupport.bootstrap("readFromParcelImpl", $$robo$$android_app_Notification$readFromParcelImpl(android.os.Parcel ), 0, this, parcel);
    }

    public Notification clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_app_Notification$clone(), 0, this);
    }

    public void cloneInto(Notification notification, boolean bl) {
        InvokeDynamicSupport.bootstrap("cloneInto", $$robo$$android_app_Notification$cloneInto(android.app.Notification boolean ), 0, this, notification, bl);
    }

    public void lightenPayload() {
        InvokeDynamicSupport.bootstrap("lightenPayload", $$robo$$android_app_Notification$lightenPayload(), 0, this);
    }

    public static CharSequence safeCharSequence(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrapStatic("safeCharSequence", $$robo$$android_app_Notification$safeCharSequence(java.lang.CharSequence ), 0, (CharSequence)charSequence);
    }

    private static CharSequence removeTextSizeSpans(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrapStatic("removeTextSizeSpans", $$robo$$android_app_Notification$removeTextSizeSpans(java.lang.CharSequence ), 0, (CharSequence)charSequence);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_app_Notification$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_app_Notification$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    private void writeToParcelImpl(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcelImpl", $$robo$$android_app_Notification$writeToParcelImpl(android.os.Parcel int ), 0, this, parcel, n);
    }

    @Deprecated
    public void setLatestEventInfo(Context context, CharSequence charSequence, CharSequence charSequence2, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("setLatestEventInfo", $$robo$$android_app_Notification$setLatestEventInfo(android.content.Context java.lang.CharSequence java.lang.CharSequence android.app.PendingIntent ), 0, this, context, charSequence, charSequence2, pendingIntent);
    }

    public static void addFieldsFromContext(Context context, Notification notification) {
        InvokeDynamicSupport.bootstrapStatic("addFieldsFromContext", $$robo$$android_app_Notification$addFieldsFromContext(android.content.Context android.app.Notification ), 0, (Context)context, (Notification)notification);
    }

    public static void addFieldsFromContext(ApplicationInfo applicationInfo, int n, Notification notification) {
        InvokeDynamicSupport.bootstrapStatic("addFieldsFromContext", $$robo$$android_app_Notification$addFieldsFromContext(android.content.pm.ApplicationInfo int android.app.Notification ), 0, (ApplicationInfo)applicationInfo, (int)n, (Notification)notification);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_app_Notification$toString(), 0, this);
    }

    public static String visibilityToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("visibilityToString", $$robo$$android_app_Notification$visibilityToString(int ), 0, (int)n);
    }

    public static String priorityToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("priorityToString", $$robo$$android_app_Notification$priorityToString(int ), 0, (int)n);
    }

    public Icon getSmallIcon() {
        return InvokeDynamicSupport.bootstrap("getSmallIcon", $$robo$$android_app_Notification$getSmallIcon(), 0, this);
    }

    public void setSmallIcon(Icon icon) {
        InvokeDynamicSupport.bootstrap("setSmallIcon", $$robo$$android_app_Notification$setSmallIcon(android.graphics.drawable.Icon ), 0, this, icon);
    }

    public Icon getLargeIcon() {
        return InvokeDynamicSupport.bootstrap("getLargeIcon", $$robo$$android_app_Notification$getLargeIcon(), 0, this);
    }

    public boolean isGroupSummary() {
        return (boolean)InvokeDynamicSupport.bootstrap("isGroupSummary", $$robo$$android_app_Notification$isGroupSummary(), 0, this);
    }

    public boolean isGroupChild() {
        return (boolean)InvokeDynamicSupport.bootstrap("isGroupChild", $$robo$$android_app_Notification$isGroupChild(), 0, this);
    }

    private boolean hasLargeIcon() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasLargeIcon", $$robo$$android_app_Notification$hasLargeIcon(), 0, this);
    }

    public boolean showsTime() {
        return (boolean)InvokeDynamicSupport.bootstrap("showsTime", $$robo$$android_app_Notification$showsTime(), 0, this);
    }

    public boolean showsChronometer() {
        return (boolean)InvokeDynamicSupport.bootstrap("showsChronometer", $$robo$$android_app_Notification$showsChronometer(), 0, this);
    }

    private static Notification[] getNotificationArrayFromBundle(Bundle bundle, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getNotificationArrayFromBundle", $$robo$$android_app_Notification$getNotificationArrayFromBundle(android.os.Bundle java.lang.String ), 0, (Bundle)bundle, (String)string2);
    }

    static {
        RobolectricInternals.classInitializing(Notification.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Notification)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class BuilderRemoteViews
    extends RemoteViews
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_app_Notification_BuilderRemoteViews$__constructor__(Parcel parcel) {
        }

        private void $$robo$$android_app_Notification_BuilderRemoteViews$__constructor__(ApplicationInfo appInfo, int layoutId) {
        }

        private final BuilderRemoteViews $$robo$$android_app_Notification_BuilderRemoteViews$clone() {
            Parcel p = Parcel.obtain();
            this.writeToParcel(p, 0);
            p.setDataPosition(0);
            BuilderRemoteViews brv = new BuilderRemoteViews(p);
            p.recycle();
            return brv;
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_app_Notification_BuilderRemoteViews$__constructor__(parcel);
        }

        public BuilderRemoteViews(Parcel parcel) {
            super(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_BuilderRemoteViews$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        private void __constructor__(ApplicationInfo applicationInfo, int n) {
            this.$$robo$$android_app_Notification_BuilderRemoteViews$__constructor__(applicationInfo, n);
        }

        public BuilderRemoteViews(ApplicationInfo applicationInfo, int n) {
            super(applicationInfo, n);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_BuilderRemoteViews$__constructor__(android.content.pm.ApplicationInfo int ), 0, this, applicationInfo, n);
        }

        @Override
        public BuilderRemoteViews clone() {
            return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_app_Notification_BuilderRemoteViews$clone(), 0, this);
        }

        public /* synthetic */ BuilderRemoteViews() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BuilderRemoteViews)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class CarExtender
    implements Extender,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static String TAG = "CarExtender";
        private static String EXTRA_CAR_EXTENDER = "android.car.EXTENSIONS";
        private static String EXTRA_LARGE_ICON = "large_icon";
        private static String EXTRA_CONVERSATION = "car_conversation";
        private static String EXTRA_COLOR = "app_color";
        private Bitmap mLargeIcon;
        private UnreadConversation mUnreadConversation;
        private int mColor;

        private void $$robo$$android_app_Notification_CarExtender$__constructor__() {
            this.mColor = 0;
        }

        private void $$robo$$android_app_Notification_CarExtender$__constructor__(Notification notif) {
            Bundle carBundle;
            this.mColor = 0;
            Bundle bundle = carBundle = notif.extras == null ? null : notif.extras.getBundle("android.car.EXTENSIONS");
            if (carBundle != null) {
                this.mLargeIcon = (Bitmap)carBundle.getParcelable("large_icon");
                this.mColor = carBundle.getInt("app_color", 0);
                Bundle b = carBundle.getBundle("car_conversation");
                this.mUnreadConversation = UnreadConversation.getUnreadConversationFromBundle(b);
            }
        }

        private final android.app.Notification$Builder $$robo$$android_app_Notification_CarExtender$extend(android.app.Notification$Builder builder) {
            Bundle carExtensions = new Bundle();
            if (this.mLargeIcon != null) {
                carExtensions.putParcelable("large_icon", this.mLargeIcon);
            }
            if (this.mColor != 0) {
                carExtensions.putInt("app_color", this.mColor);
            }
            if (this.mUnreadConversation != null) {
                Bundle b = this.mUnreadConversation.getBundleForUnreadConversation();
                carExtensions.putBundle("car_conversation", b);
            }
            builder.getExtras().putBundle("android.car.EXTENSIONS", carExtensions);
            return builder;
        }

        private final CarExtender $$robo$$android_app_Notification_CarExtender$setColor(int color2) {
            this.mColor = color2;
            return this;
        }

        private final int $$robo$$android_app_Notification_CarExtender$getColor() {
            return this.mColor;
        }

        private final CarExtender $$robo$$android_app_Notification_CarExtender$setLargeIcon(Bitmap largeIcon) {
            this.mLargeIcon = largeIcon;
            return this;
        }

        private final Bitmap $$robo$$android_app_Notification_CarExtender$getLargeIcon() {
            return this.mLargeIcon;
        }

        private final CarExtender $$robo$$android_app_Notification_CarExtender$setUnreadConversation(UnreadConversation unreadConversation) {
            this.mUnreadConversation = unreadConversation;
            return this;
        }

        private final UnreadConversation $$robo$$android_app_Notification_CarExtender$getUnreadConversation() {
            return this.mUnreadConversation;
        }

        private void __constructor__() {
            this.$$robo$$android_app_Notification_CarExtender$__constructor__();
        }

        public CarExtender() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_CarExtender$__constructor__(), 0, this);
        }

        private void __constructor__(Notification notification) {
            this.$$robo$$android_app_Notification_CarExtender$__constructor__(notification);
        }

        public CarExtender(Notification notification) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_CarExtender$__constructor__(android.app.Notification ), 0, this, notification);
        }

        @Override
        public android.app.Notification$Builder extend(android.app.Notification$Builder builder) {
            return InvokeDynamicSupport.bootstrap("extend", $$robo$$android_app_Notification_CarExtender$extend(android.app.Notification$Builder ), 0, this, builder);
        }

        public CarExtender setColor(int n) {
            return InvokeDynamicSupport.bootstrap("setColor", $$robo$$android_app_Notification_CarExtender$setColor(int ), 0, this, n);
        }

        public int getColor() {
            return (int)InvokeDynamicSupport.bootstrap("getColor", $$robo$$android_app_Notification_CarExtender$getColor(), 0, this);
        }

        public CarExtender setLargeIcon(Bitmap bitmap) {
            return InvokeDynamicSupport.bootstrap("setLargeIcon", $$robo$$android_app_Notification_CarExtender$setLargeIcon(android.graphics.Bitmap ), 0, this, bitmap);
        }

        public Bitmap getLargeIcon() {
            return InvokeDynamicSupport.bootstrap("getLargeIcon", $$robo$$android_app_Notification_CarExtender$getLargeIcon(), 0, this);
        }

        public CarExtender setUnreadConversation(UnreadConversation unreadConversation) {
            return InvokeDynamicSupport.bootstrap("setUnreadConversation", $$robo$$android_app_Notification_CarExtender$setUnreadConversation(android.app.Notification$CarExtender$UnreadConversation ), 0, this, unreadConversation);
        }

        public UnreadConversation getUnreadConversation() {
            return InvokeDynamicSupport.bootstrap("getUnreadConversation", $$robo$$android_app_Notification_CarExtender$getUnreadConversation(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CarExtender)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        public static class Builder
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            private List<String> mMessages;
            private String mParticipant;
            private RemoteInput mRemoteInput;
            private PendingIntent mReadPendingIntent;
            private PendingIntent mReplyPendingIntent;
            private long mLatestTimestamp;

            private void $$robo$$android_app_Notification_CarExtender_Builder$__constructor__(String name) {
                this.mMessages = new ArrayList<String>();
                this.mParticipant = name;
            }

            private final Builder $$robo$$android_app_Notification_CarExtender_Builder$addMessage(String message) {
                this.mMessages.add(message);
                return this;
            }

            private final Builder $$robo$$android_app_Notification_CarExtender_Builder$setReplyAction(PendingIntent pendingIntent, RemoteInput remoteInput) {
                this.mRemoteInput = remoteInput;
                this.mReplyPendingIntent = pendingIntent;
                return this;
            }

            private final Builder $$robo$$android_app_Notification_CarExtender_Builder$setReadPendingIntent(PendingIntent pendingIntent) {
                this.mReadPendingIntent = pendingIntent;
                return this;
            }

            private final Builder $$robo$$android_app_Notification_CarExtender_Builder$setLatestTimestamp(long timestamp) {
                this.mLatestTimestamp = timestamp;
                return this;
            }

            private final UnreadConversation $$robo$$android_app_Notification_CarExtender_Builder$build() {
                String[] messages = this.mMessages.toArray(new String[this.mMessages.size()]);
                String[] participants = new String[]{this.mParticipant};
                return new UnreadConversation(messages, this.mRemoteInput, this.mReplyPendingIntent, this.mReadPendingIntent, participants, this.mLatestTimestamp);
            }

            private void __constructor__(String string2) {
                this.$$robo$$android_app_Notification_CarExtender_Builder$__constructor__(string2);
            }

            public Builder(String string2) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_CarExtender_Builder$__constructor__(java.lang.String ), 0, this, string2);
            }

            public Builder addMessage(String string2) {
                return InvokeDynamicSupport.bootstrap("addMessage", $$robo$$android_app_Notification_CarExtender_Builder$addMessage(java.lang.String ), 0, this, string2);
            }

            public Builder setReplyAction(PendingIntent pendingIntent, RemoteInput remoteInput) {
                return InvokeDynamicSupport.bootstrap("setReplyAction", $$robo$$android_app_Notification_CarExtender_Builder$setReplyAction(android.app.PendingIntent android.app.RemoteInput ), 0, this, pendingIntent, remoteInput);
            }

            public Builder setReadPendingIntent(PendingIntent pendingIntent) {
                return InvokeDynamicSupport.bootstrap("setReadPendingIntent", $$robo$$android_app_Notification_CarExtender_Builder$setReadPendingIntent(android.app.PendingIntent ), 0, this, pendingIntent);
            }

            public Builder setLatestTimestamp(long l) {
                return InvokeDynamicSupport.bootstrap("setLatestTimestamp", $$robo$$android_app_Notification_CarExtender_Builder$setLatestTimestamp(long ), 0, this, l);
            }

            public UnreadConversation build() {
                return InvokeDynamicSupport.bootstrap("build", $$robo$$android_app_Notification_CarExtender_Builder$build(), 0, this);
            }

            public /* synthetic */ Builder() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        public static class UnreadConversation
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            private static String KEY_AUTHOR = "author";
            private static String KEY_TEXT = "text";
            private static String KEY_MESSAGES = "messages";
            private static String KEY_REMOTE_INPUT = "remote_input";
            private static String KEY_ON_REPLY = "on_reply";
            private static String KEY_ON_READ = "on_read";
            private static String KEY_PARTICIPANTS = "participants";
            private static String KEY_TIMESTAMP = "timestamp";
            private String[] mMessages;
            private RemoteInput mRemoteInput;
            private PendingIntent mReplyPendingIntent;
            private PendingIntent mReadPendingIntent;
            private String[] mParticipants;
            private long mLatestTimestamp;

            private void $$robo$$android_app_Notification_CarExtender_UnreadConversation$__constructor__(String[] messages, RemoteInput remoteInput, PendingIntent replyPendingIntent, PendingIntent readPendingIntent, String[] participants, long latestTimestamp) {
                this.mMessages = messages;
                this.mRemoteInput = remoteInput;
                this.mReadPendingIntent = readPendingIntent;
                this.mReplyPendingIntent = replyPendingIntent;
                this.mParticipants = participants;
                this.mLatestTimestamp = latestTimestamp;
            }

            private final String[] $$robo$$android_app_Notification_CarExtender_UnreadConversation$getMessages() {
                return this.mMessages;
            }

            private final RemoteInput $$robo$$android_app_Notification_CarExtender_UnreadConversation$getRemoteInput() {
                return this.mRemoteInput;
            }

            private final PendingIntent $$robo$$android_app_Notification_CarExtender_UnreadConversation$getReplyPendingIntent() {
                return this.mReplyPendingIntent;
            }

            private final PendingIntent $$robo$$android_app_Notification_CarExtender_UnreadConversation$getReadPendingIntent() {
                return this.mReadPendingIntent;
            }

            private final String[] $$robo$$android_app_Notification_CarExtender_UnreadConversation$getParticipants() {
                return this.mParticipants;
            }

            private final String $$robo$$android_app_Notification_CarExtender_UnreadConversation$getParticipant() {
                return this.mParticipants.length > 0 ? this.mParticipants[0] : null;
            }

            private final long $$robo$$android_app_Notification_CarExtender_UnreadConversation$getLatestTimestamp() {
                return this.mLatestTimestamp;
            }

            private final Bundle $$robo$$android_app_Notification_CarExtender_UnreadConversation$getBundleForUnreadConversation() {
                Bundle b = new Bundle();
                String author = null;
                if (this.mParticipants != null && this.mParticipants.length > 1) {
                    author = this.mParticipants[0];
                }
                Parcelable[] messages = new Parcelable[this.mMessages.length];
                for (int i = 0; i < messages.length; ++i) {
                    Bundle m = new Bundle();
                    m.putString("text", this.mMessages[i]);
                    m.putString("author", author);
                    messages[i] = m;
                }
                b.putParcelableArray("messages", messages);
                if (this.mRemoteInput != null) {
                    b.putParcelable("remote_input", this.mRemoteInput);
                }
                b.putParcelable("on_reply", this.mReplyPendingIntent);
                b.putParcelable("on_read", this.mReadPendingIntent);
                b.putStringArray("participants", this.mParticipants);
                b.putLong("timestamp", this.mLatestTimestamp);
                return b;
            }

            private static final UnreadConversation $$robo$$android_app_Notification_CarExtender_UnreadConversation$getUnreadConversationFromBundle(Bundle b) {
                if (b == null) {
                    return null;
                }
                Parcelable[] parcelableMessages = b.getParcelableArray("messages");
                String[] messages = null;
                if (parcelableMessages != null) {
                    String[] tmp = new String[parcelableMessages.length];
                    boolean success = true;
                    for (int i = 0; i < tmp.length; ++i) {
                        if (!(parcelableMessages[i] instanceof Bundle)) {
                            success = false;
                            break;
                        }
                        tmp[i] = ((Bundle)parcelableMessages[i]).getString("text");
                        if (tmp[i] != null) continue;
                        success = false;
                        break;
                    }
                    if (success) {
                        messages = tmp;
                    } else {
                        return null;
                    }
                }
                PendingIntent onRead = (PendingIntent)b.getParcelable("on_read");
                PendingIntent onReply = (PendingIntent)b.getParcelable("on_reply");
                RemoteInput remoteInput = (RemoteInput)b.getParcelable("remote_input");
                String[] participants = b.getStringArray("participants");
                if (participants == null || participants.length != 1) {
                    return null;
                }
                return new UnreadConversation(messages, remoteInput, onReply, onRead, participants, b.getLong("timestamp"));
            }

            private void __constructor__(String[] stringArray, RemoteInput remoteInput, PendingIntent pendingIntent, PendingIntent pendingIntent2, String[] stringArray2, long l) {
                this.$$robo$$android_app_Notification_CarExtender_UnreadConversation$__constructor__(stringArray, remoteInput, pendingIntent, pendingIntent2, stringArray2, l);
            }

            UnreadConversation(String[] stringArray, RemoteInput remoteInput, PendingIntent pendingIntent, PendingIntent pendingIntent2, String[] stringArray2, long l) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_CarExtender_UnreadConversation$__constructor__(java.lang.String[] android.app.RemoteInput android.app.PendingIntent android.app.PendingIntent java.lang.String[] long ), 0, this, stringArray, remoteInput, pendingIntent, pendingIntent2, stringArray2, l);
            }

            public String[] getMessages() {
                return InvokeDynamicSupport.bootstrap("getMessages", $$robo$$android_app_Notification_CarExtender_UnreadConversation$getMessages(), 0, this);
            }

            public RemoteInput getRemoteInput() {
                return InvokeDynamicSupport.bootstrap("getRemoteInput", $$robo$$android_app_Notification_CarExtender_UnreadConversation$getRemoteInput(), 0, this);
            }

            public PendingIntent getReplyPendingIntent() {
                return InvokeDynamicSupport.bootstrap("getReplyPendingIntent", $$robo$$android_app_Notification_CarExtender_UnreadConversation$getReplyPendingIntent(), 0, this);
            }

            public PendingIntent getReadPendingIntent() {
                return InvokeDynamicSupport.bootstrap("getReadPendingIntent", $$robo$$android_app_Notification_CarExtender_UnreadConversation$getReadPendingIntent(), 0, this);
            }

            public String[] getParticipants() {
                return InvokeDynamicSupport.bootstrap("getParticipants", $$robo$$android_app_Notification_CarExtender_UnreadConversation$getParticipants(), 0, this);
            }

            public String getParticipant() {
                return InvokeDynamicSupport.bootstrap("getParticipant", $$robo$$android_app_Notification_CarExtender_UnreadConversation$getParticipant(), 0, this);
            }

            public long getLatestTimestamp() {
                return (long)InvokeDynamicSupport.bootstrap("getLatestTimestamp", $$robo$$android_app_Notification_CarExtender_UnreadConversation$getLatestTimestamp(), 0, this);
            }

            Bundle getBundleForUnreadConversation() {
                return InvokeDynamicSupport.bootstrap("getBundleForUnreadConversation", $$robo$$android_app_Notification_CarExtender_UnreadConversation$getBundleForUnreadConversation(), 0, this);
            }

            static UnreadConversation getUnreadConversationFromBundle(Bundle bundle) {
                return InvokeDynamicSupport.bootstrapStatic("getUnreadConversationFromBundle", $$robo$$android_app_Notification_CarExtender_UnreadConversation$getUnreadConversationFromBundle(android.os.Bundle ), 0, (Bundle)bundle);
            }

            public /* synthetic */ UnreadConversation() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UnreadConversation)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class WearableExtender
    implements Extender,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int UNSET_ACTION_INDEX = -1;
        public static int SIZE_DEFAULT = 0;
        public static int SIZE_XSMALL = 1;
        public static int SIZE_SMALL = 2;
        public static int SIZE_MEDIUM = 3;
        public static int SIZE_LARGE = 4;
        public static int SIZE_FULL_SCREEN = 5;
        public static int SCREEN_TIMEOUT_SHORT = 0;
        public static int SCREEN_TIMEOUT_LONG = -1;
        private static String EXTRA_WEARABLE_EXTENSIONS = "android.wearable.EXTENSIONS";
        private static String KEY_ACTIONS = "actions";
        private static String KEY_FLAGS = "flags";
        private static String KEY_DISPLAY_INTENT = "displayIntent";
        private static String KEY_PAGES = "pages";
        private static String KEY_BACKGROUND = "background";
        private static String KEY_CONTENT_ICON = "contentIcon";
        private static String KEY_CONTENT_ICON_GRAVITY = "contentIconGravity";
        private static String KEY_CONTENT_ACTION_INDEX = "contentActionIndex";
        private static String KEY_CUSTOM_SIZE_PRESET = "customSizePreset";
        private static String KEY_CUSTOM_CONTENT_HEIGHT = "customContentHeight";
        private static String KEY_GRAVITY = "gravity";
        private static String KEY_HINT_SCREEN_TIMEOUT = "hintScreenTimeout";
        private static String KEY_DISMISSAL_ID = "dismissalId";
        private static int FLAG_CONTENT_INTENT_AVAILABLE_OFFLINE = 1;
        private static int FLAG_HINT_HIDE_ICON = 2;
        private static int FLAG_HINT_SHOW_BACKGROUND_ONLY = 4;
        private static int FLAG_START_SCROLL_BOTTOM = 8;
        private static int FLAG_HINT_AVOID_BACKGROUND_CLIPPING = 16;
        private static int FLAG_BIG_PICTURE_AMBIENT = 32;
        private static int FLAG_HINT_CONTENT_INTENT_LAUNCHES_ACTIVITY = 64;
        private static int DEFAULT_FLAGS = 1;
        private static int DEFAULT_CONTENT_ICON_GRAVITY = 0x800005;
        private static int DEFAULT_GRAVITY = 80;
        private ArrayList<Action> mActions;
        private int mFlags;
        private PendingIntent mDisplayIntent;
        private ArrayList<Notification> mPages;
        private Bitmap mBackground;
        private int mContentIcon;
        private int mContentIconGravity;
        private int mContentActionIndex;
        private int mCustomSizePreset;
        private int mCustomContentHeight;
        private int mGravity;
        private int mHintScreenTimeout;
        private String mDismissalId;

        private void $$robo$$android_app_Notification_WearableExtender$__constructor__() {
            this.mActions = new ArrayList();
            this.mFlags = 1;
            this.mPages = new ArrayList();
            this.mContentIconGravity = 0x800005;
            this.mContentActionIndex = -1;
            this.mCustomSizePreset = 0;
            this.mGravity = 80;
        }

        private void $$robo$$android_app_Notification_WearableExtender$__constructor__(Notification notif) {
            this.mActions = new ArrayList();
            this.mFlags = 1;
            this.mPages = new ArrayList();
            this.mContentIconGravity = 0x800005;
            this.mContentActionIndex = -1;
            this.mCustomSizePreset = 0;
            this.mGravity = 80;
            Bundle wearableBundle = notif.extras.getBundle("android.wearable.EXTENSIONS");
            if (wearableBundle != null) {
                ArrayList actions = wearableBundle.getParcelableArrayList("actions");
                if (actions != null) {
                    this.mActions.addAll(actions);
                }
                this.mFlags = wearableBundle.getInt("flags", 1);
                this.mDisplayIntent = (PendingIntent)wearableBundle.getParcelable("displayIntent");
                Notification[] pages = Notification.getNotificationArrayFromBundle(wearableBundle, "pages");
                if (pages != null) {
                    Collections.addAll(this.mPages, pages);
                }
                this.mBackground = (Bitmap)wearableBundle.getParcelable("background");
                this.mContentIcon = wearableBundle.getInt("contentIcon");
                this.mContentIconGravity = wearableBundle.getInt("contentIconGravity", 0x800005);
                this.mContentActionIndex = wearableBundle.getInt("contentActionIndex", -1);
                this.mCustomSizePreset = wearableBundle.getInt("customSizePreset", 0);
                this.mCustomContentHeight = wearableBundle.getInt("customContentHeight");
                this.mGravity = wearableBundle.getInt("gravity", 80);
                this.mHintScreenTimeout = wearableBundle.getInt("hintScreenTimeout");
                this.mDismissalId = wearableBundle.getString("dismissalId");
            }
        }

        private final Builder $$robo$$android_app_Notification_WearableExtender$extend(Builder builder) {
            Bundle wearableBundle = new Bundle();
            if (!this.mActions.isEmpty()) {
                wearableBundle.putParcelableArrayList("actions", this.mActions);
            }
            if (this.mFlags != 1) {
                wearableBundle.putInt("flags", this.mFlags);
            }
            if (this.mDisplayIntent != null) {
                wearableBundle.putParcelable("displayIntent", this.mDisplayIntent);
            }
            if (!this.mPages.isEmpty()) {
                wearableBundle.putParcelableArray("pages", this.mPages.toArray(new Notification[this.mPages.size()]));
            }
            if (this.mBackground != null) {
                wearableBundle.putParcelable("background", this.mBackground);
            }
            if (this.mContentIcon != 0) {
                wearableBundle.putInt("contentIcon", this.mContentIcon);
            }
            if (this.mContentIconGravity != 0x800005) {
                wearableBundle.putInt("contentIconGravity", this.mContentIconGravity);
            }
            if (this.mContentActionIndex != -1) {
                wearableBundle.putInt("contentActionIndex", this.mContentActionIndex);
            }
            if (this.mCustomSizePreset != 0) {
                wearableBundle.putInt("customSizePreset", this.mCustomSizePreset);
            }
            if (this.mCustomContentHeight != 0) {
                wearableBundle.putInt("customContentHeight", this.mCustomContentHeight);
            }
            if (this.mGravity != 80) {
                wearableBundle.putInt("gravity", this.mGravity);
            }
            if (this.mHintScreenTimeout != 0) {
                wearableBundle.putInt("hintScreenTimeout", this.mHintScreenTimeout);
            }
            if (this.mDismissalId != null) {
                wearableBundle.putString("dismissalId", this.mDismissalId);
            }
            builder.getExtras().putBundle("android.wearable.EXTENSIONS", wearableBundle);
            return builder;
        }

        private final WearableExtender $$robo$$android_app_Notification_WearableExtender$clone() {
            WearableExtender that = new WearableExtender();
            that.mActions = new ArrayList<Action>(this.mActions);
            that.mFlags = this.mFlags;
            that.mDisplayIntent = this.mDisplayIntent;
            that.mPages = new ArrayList<Notification>(this.mPages);
            that.mBackground = this.mBackground;
            that.mContentIcon = this.mContentIcon;
            that.mContentIconGravity = this.mContentIconGravity;
            that.mContentActionIndex = this.mContentActionIndex;
            that.mCustomSizePreset = this.mCustomSizePreset;
            that.mCustomContentHeight = this.mCustomContentHeight;
            that.mGravity = this.mGravity;
            that.mHintScreenTimeout = this.mHintScreenTimeout;
            that.mDismissalId = this.mDismissalId;
            return that;
        }

        private final WearableExtender $$robo$$android_app_Notification_WearableExtender$addAction(Action action) {
            this.mActions.add(action);
            return this;
        }

        private final WearableExtender $$robo$$android_app_Notification_WearableExtender$addActions(List<Action> actions) {
            this.mActions.addAll(actions);
            return this;
        }

        private final WearableExtender $$robo$$android_app_Notification_WearableExtender$clearActions() {
            this.mActions.clear();
            return this;
        }

        private final List<Action> $$robo$$android_app_Notification_WearableExtender$getActions() {
            return this.mActions;
        }

        private final WearableExtender $$robo$$android_app_Notification_WearableExtender$setDisplayIntent(PendingIntent intent) {
            this.mDisplayIntent = intent;
            return this;
        }

        private final PendingIntent $$robo$$android_app_Notification_WearableExtender$getDisplayIntent() {
            return this.mDisplayIntent;
        }

        private final WearableExtender $$robo$$android_app_Notification_WearableExtender$addPage(Notification page) {
            this.mPages.add(page);
            return this;
        }

        private final WearableExtender $$robo$$android_app_Notification_WearableExtender$addPages(List<Notification> pages) {
            this.mPages.addAll(pages);
            return this;
        }

        private final WearableExtender $$robo$$android_app_Notification_WearableExtender$clearPages() {
            this.mPages.clear();
            return this;
        }

        private final List<Notification> $$robo$$android_app_Notification_WearableExtender$getPages() {
            return this.mPages;
        }

        private final WearableExtender $$robo$$android_app_Notification_WearableExtender$setBackground(Bitmap background) {
            this.mBackground = background;
            return this;
        }

        private final Bitmap $$robo$$android_app_Notification_WearableExtender$getBackground() {
            return this.mBackground;
        }

        private final WearableExtender $$robo$$android_app_Notification_WearableExtender$setContentIcon(int icon) {
            this.mContentIcon = icon;
            return this;
        }

        private final int $$robo$$android_app_Notification_WearableExtender$getContentIcon() {
            return this.mContentIcon;
        }

        private final WearableExtender $$robo$$android_app_Notification_WearableExtender$setContentIconGravity(int contentIconGravity) {
            this.mContentIconGravity = contentIconGravity;
            return this;
        }

        private final int $$robo$$android_app_Notification_WearableExtender$getContentIconGravity() {
            return this.mContentIconGravity;
        }

        private final WearableExtender $$robo$$android_app_Notification_WearableExtender$setContentAction(int actionIndex) {
            this.mContentActionIndex = actionIndex;
            return this;
        }

        private final int $$robo$$android_app_Notification_WearableExtender$getContentAction() {
            return this.mContentActionIndex;
        }

        private final WearableExtender $$robo$$android_app_Notification_WearableExtender$setGravity(int gravity) {
            this.mGravity = gravity;
            return this;
        }

        private final int $$robo$$android_app_Notification_WearableExtender$getGravity() {
            return this.mGravity;
        }

        private final WearableExtender $$robo$$android_app_Notification_WearableExtender$setCustomSizePreset(int sizePreset) {
            this.mCustomSizePreset = sizePreset;
            return this;
        }

        private final int $$robo$$android_app_Notification_WearableExtender$getCustomSizePreset() {
            return this.mCustomSizePreset;
        }

        private final WearableExtender $$robo$$android_app_Notification_WearableExtender$setCustomContentHeight(int height) {
            this.mCustomContentHeight = height;
            return this;
        }

        private final int $$robo$$android_app_Notification_WearableExtender$getCustomContentHeight() {
            return this.mCustomContentHeight;
        }

        private final WearableExtender $$robo$$android_app_Notification_WearableExtender$setStartScrollBottom(boolean startScrollBottom) {
            this.setFlag(8, startScrollBottom);
            return this;
        }

        private final boolean $$robo$$android_app_Notification_WearableExtender$getStartScrollBottom() {
            return (this.mFlags & 8) != 0;
        }

        private final WearableExtender $$robo$$android_app_Notification_WearableExtender$setContentIntentAvailableOffline(boolean contentIntentAvailableOffline) {
            this.setFlag(1, contentIntentAvailableOffline);
            return this;
        }

        private final boolean $$robo$$android_app_Notification_WearableExtender$getContentIntentAvailableOffline() {
            return (this.mFlags & 1) != 0;
        }

        private final WearableExtender $$robo$$android_app_Notification_WearableExtender$setHintHideIcon(boolean hintHideIcon) {
            this.setFlag(2, hintHideIcon);
            return this;
        }

        private final boolean $$robo$$android_app_Notification_WearableExtender$getHintHideIcon() {
            return (this.mFlags & 2) != 0;
        }

        private final WearableExtender $$robo$$android_app_Notification_WearableExtender$setHintShowBackgroundOnly(boolean hintShowBackgroundOnly) {
            this.setFlag(4, hintShowBackgroundOnly);
            return this;
        }

        private final boolean $$robo$$android_app_Notification_WearableExtender$getHintShowBackgroundOnly() {
            return (this.mFlags & 4) != 0;
        }

        private final WearableExtender $$robo$$android_app_Notification_WearableExtender$setHintAvoidBackgroundClipping(boolean hintAvoidBackgroundClipping) {
            this.setFlag(16, hintAvoidBackgroundClipping);
            return this;
        }

        private final boolean $$robo$$android_app_Notification_WearableExtender$getHintAvoidBackgroundClipping() {
            return (this.mFlags & 0x10) != 0;
        }

        private final WearableExtender $$robo$$android_app_Notification_WearableExtender$setHintScreenTimeout(int timeout) {
            this.mHintScreenTimeout = timeout;
            return this;
        }

        private final int $$robo$$android_app_Notification_WearableExtender$getHintScreenTimeout() {
            return this.mHintScreenTimeout;
        }

        private final WearableExtender $$robo$$android_app_Notification_WearableExtender$setHintAmbientBigPicture(boolean hintAmbientBigPicture) {
            this.setFlag(32, hintAmbientBigPicture);
            return this;
        }

        private final boolean $$robo$$android_app_Notification_WearableExtender$getHintAmbientBigPicture() {
            return (this.mFlags & 0x20) != 0;
        }

        private final WearableExtender $$robo$$android_app_Notification_WearableExtender$setHintContentIntentLaunchesActivity(boolean hintContentIntentLaunchesActivity) {
            this.setFlag(64, hintContentIntentLaunchesActivity);
            return this;
        }

        private final boolean $$robo$$android_app_Notification_WearableExtender$getHintContentIntentLaunchesActivity() {
            return (this.mFlags & 0x40) != 0;
        }

        private final WearableExtender $$robo$$android_app_Notification_WearableExtender$setDismissalId(String dismissalId) {
            this.mDismissalId = dismissalId;
            return this;
        }

        private final String $$robo$$android_app_Notification_WearableExtender$getDismissalId() {
            return this.mDismissalId;
        }

        private final void $$robo$$android_app_Notification_WearableExtender$setFlag(int mask, boolean value) {
            this.mFlags = value ? (this.mFlags |= mask) : (this.mFlags &= ~mask);
        }

        private void __constructor__() {
            this.$$robo$$android_app_Notification_WearableExtender$__constructor__();
        }

        public WearableExtender() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_WearableExtender$__constructor__(), 0, this);
        }

        private void __constructor__(Notification notification) {
            this.$$robo$$android_app_Notification_WearableExtender$__constructor__(notification);
        }

        public WearableExtender(Notification notification) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_WearableExtender$__constructor__(android.app.Notification ), 0, this, notification);
        }

        @Override
        public Builder extend(Builder builder) {
            return InvokeDynamicSupport.bootstrap("extend", $$robo$$android_app_Notification_WearableExtender$extend(android.app.Notification$Builder ), 0, this, builder);
        }

        public WearableExtender clone() {
            return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_app_Notification_WearableExtender$clone(), 0, this);
        }

        public WearableExtender addAction(Action action) {
            return InvokeDynamicSupport.bootstrap("addAction", $$robo$$android_app_Notification_WearableExtender$addAction(android.app.Notification$Action ), 0, this, action);
        }

        public WearableExtender addActions(List<Action> list) {
            return InvokeDynamicSupport.bootstrap("addActions", $$robo$$android_app_Notification_WearableExtender$addActions(java.util.List<android.app.Notification$Action> ), 0, this, list);
        }

        public WearableExtender clearActions() {
            return InvokeDynamicSupport.bootstrap("clearActions", $$robo$$android_app_Notification_WearableExtender$clearActions(), 0, this);
        }

        public List<Action> getActions() {
            return InvokeDynamicSupport.bootstrap("getActions", $$robo$$android_app_Notification_WearableExtender$getActions(), 0, this);
        }

        public WearableExtender setDisplayIntent(PendingIntent pendingIntent) {
            return InvokeDynamicSupport.bootstrap("setDisplayIntent", $$robo$$android_app_Notification_WearableExtender$setDisplayIntent(android.app.PendingIntent ), 0, this, pendingIntent);
        }

        public PendingIntent getDisplayIntent() {
            return InvokeDynamicSupport.bootstrap("getDisplayIntent", $$robo$$android_app_Notification_WearableExtender$getDisplayIntent(), 0, this);
        }

        public WearableExtender addPage(Notification notification) {
            return InvokeDynamicSupport.bootstrap("addPage", $$robo$$android_app_Notification_WearableExtender$addPage(android.app.Notification ), 0, this, notification);
        }

        public WearableExtender addPages(List<Notification> list) {
            return InvokeDynamicSupport.bootstrap("addPages", $$robo$$android_app_Notification_WearableExtender$addPages(java.util.List<android.app.Notification> ), 0, this, list);
        }

        public WearableExtender clearPages() {
            return InvokeDynamicSupport.bootstrap("clearPages", $$robo$$android_app_Notification_WearableExtender$clearPages(), 0, this);
        }

        public List<Notification> getPages() {
            return InvokeDynamicSupport.bootstrap("getPages", $$robo$$android_app_Notification_WearableExtender$getPages(), 0, this);
        }

        public WearableExtender setBackground(Bitmap bitmap) {
            return InvokeDynamicSupport.bootstrap("setBackground", $$robo$$android_app_Notification_WearableExtender$setBackground(android.graphics.Bitmap ), 0, this, bitmap);
        }

        public Bitmap getBackground() {
            return InvokeDynamicSupport.bootstrap("getBackground", $$robo$$android_app_Notification_WearableExtender$getBackground(), 0, this);
        }

        public WearableExtender setContentIcon(int n) {
            return InvokeDynamicSupport.bootstrap("setContentIcon", $$robo$$android_app_Notification_WearableExtender$setContentIcon(int ), 0, this, n);
        }

        public int getContentIcon() {
            return (int)InvokeDynamicSupport.bootstrap("getContentIcon", $$robo$$android_app_Notification_WearableExtender$getContentIcon(), 0, this);
        }

        public WearableExtender setContentIconGravity(int n) {
            return InvokeDynamicSupport.bootstrap("setContentIconGravity", $$robo$$android_app_Notification_WearableExtender$setContentIconGravity(int ), 0, this, n);
        }

        public int getContentIconGravity() {
            return (int)InvokeDynamicSupport.bootstrap("getContentIconGravity", $$robo$$android_app_Notification_WearableExtender$getContentIconGravity(), 0, this);
        }

        public WearableExtender setContentAction(int n) {
            return InvokeDynamicSupport.bootstrap("setContentAction", $$robo$$android_app_Notification_WearableExtender$setContentAction(int ), 0, this, n);
        }

        public int getContentAction() {
            return (int)InvokeDynamicSupport.bootstrap("getContentAction", $$robo$$android_app_Notification_WearableExtender$getContentAction(), 0, this);
        }

        public WearableExtender setGravity(int n) {
            return InvokeDynamicSupport.bootstrap("setGravity", $$robo$$android_app_Notification_WearableExtender$setGravity(int ), 0, this, n);
        }

        public int getGravity() {
            return (int)InvokeDynamicSupport.bootstrap("getGravity", $$robo$$android_app_Notification_WearableExtender$getGravity(), 0, this);
        }

        public WearableExtender setCustomSizePreset(int n) {
            return InvokeDynamicSupport.bootstrap("setCustomSizePreset", $$robo$$android_app_Notification_WearableExtender$setCustomSizePreset(int ), 0, this, n);
        }

        public int getCustomSizePreset() {
            return (int)InvokeDynamicSupport.bootstrap("getCustomSizePreset", $$robo$$android_app_Notification_WearableExtender$getCustomSizePreset(), 0, this);
        }

        public WearableExtender setCustomContentHeight(int n) {
            return InvokeDynamicSupport.bootstrap("setCustomContentHeight", $$robo$$android_app_Notification_WearableExtender$setCustomContentHeight(int ), 0, this, n);
        }

        public int getCustomContentHeight() {
            return (int)InvokeDynamicSupport.bootstrap("getCustomContentHeight", $$robo$$android_app_Notification_WearableExtender$getCustomContentHeight(), 0, this);
        }

        public WearableExtender setStartScrollBottom(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setStartScrollBottom", $$robo$$android_app_Notification_WearableExtender$setStartScrollBottom(boolean ), 0, this, bl);
        }

        public boolean getStartScrollBottom() {
            return (boolean)InvokeDynamicSupport.bootstrap("getStartScrollBottom", $$robo$$android_app_Notification_WearableExtender$getStartScrollBottom(), 0, this);
        }

        public WearableExtender setContentIntentAvailableOffline(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setContentIntentAvailableOffline", $$robo$$android_app_Notification_WearableExtender$setContentIntentAvailableOffline(boolean ), 0, this, bl);
        }

        public boolean getContentIntentAvailableOffline() {
            return (boolean)InvokeDynamicSupport.bootstrap("getContentIntentAvailableOffline", $$robo$$android_app_Notification_WearableExtender$getContentIntentAvailableOffline(), 0, this);
        }

        public WearableExtender setHintHideIcon(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setHintHideIcon", $$robo$$android_app_Notification_WearableExtender$setHintHideIcon(boolean ), 0, this, bl);
        }

        public boolean getHintHideIcon() {
            return (boolean)InvokeDynamicSupport.bootstrap("getHintHideIcon", $$robo$$android_app_Notification_WearableExtender$getHintHideIcon(), 0, this);
        }

        public WearableExtender setHintShowBackgroundOnly(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setHintShowBackgroundOnly", $$robo$$android_app_Notification_WearableExtender$setHintShowBackgroundOnly(boolean ), 0, this, bl);
        }

        public boolean getHintShowBackgroundOnly() {
            return (boolean)InvokeDynamicSupport.bootstrap("getHintShowBackgroundOnly", $$robo$$android_app_Notification_WearableExtender$getHintShowBackgroundOnly(), 0, this);
        }

        public WearableExtender setHintAvoidBackgroundClipping(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setHintAvoidBackgroundClipping", $$robo$$android_app_Notification_WearableExtender$setHintAvoidBackgroundClipping(boolean ), 0, this, bl);
        }

        public boolean getHintAvoidBackgroundClipping() {
            return (boolean)InvokeDynamicSupport.bootstrap("getHintAvoidBackgroundClipping", $$robo$$android_app_Notification_WearableExtender$getHintAvoidBackgroundClipping(), 0, this);
        }

        public WearableExtender setHintScreenTimeout(int n) {
            return InvokeDynamicSupport.bootstrap("setHintScreenTimeout", $$robo$$android_app_Notification_WearableExtender$setHintScreenTimeout(int ), 0, this, n);
        }

        public int getHintScreenTimeout() {
            return (int)InvokeDynamicSupport.bootstrap("getHintScreenTimeout", $$robo$$android_app_Notification_WearableExtender$getHintScreenTimeout(), 0, this);
        }

        public WearableExtender setHintAmbientBigPicture(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setHintAmbientBigPicture", $$robo$$android_app_Notification_WearableExtender$setHintAmbientBigPicture(boolean ), 0, this, bl);
        }

        public boolean getHintAmbientBigPicture() {
            return (boolean)InvokeDynamicSupport.bootstrap("getHintAmbientBigPicture", $$robo$$android_app_Notification_WearableExtender$getHintAmbientBigPicture(), 0, this);
        }

        public WearableExtender setHintContentIntentLaunchesActivity(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setHintContentIntentLaunchesActivity", $$robo$$android_app_Notification_WearableExtender$setHintContentIntentLaunchesActivity(boolean ), 0, this, bl);
        }

        public boolean getHintContentIntentLaunchesActivity() {
            return (boolean)InvokeDynamicSupport.bootstrap("getHintContentIntentLaunchesActivity", $$robo$$android_app_Notification_WearableExtender$getHintContentIntentLaunchesActivity(), 0, this);
        }

        public WearableExtender setDismissalId(String string2) {
            return InvokeDynamicSupport.bootstrap("setDismissalId", $$robo$$android_app_Notification_WearableExtender$setDismissalId(java.lang.String ), 0, this, string2);
        }

        public String getDismissalId() {
            return InvokeDynamicSupport.bootstrap("getDismissalId", $$robo$$android_app_Notification_WearableExtender$getDismissalId(), 0, this);
        }

        private void setFlag(int n, boolean bl) {
            InvokeDynamicSupport.bootstrap("setFlag", $$robo$$android_app_Notification_WearableExtender$setFlag(int boolean ), 0, this, n, bl);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WearableExtender)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface Extender
    extends InstrumentedInterface {
        public Builder extend(Builder var1);
    }

    public static class DecoratedMediaCustomViewStyle
    extends MediaStyle
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_app_Notification_DecoratedMediaCustomViewStyle$__constructor__() {
        }

        private final boolean $$robo$$android_app_Notification_DecoratedMediaCustomViewStyle$displayCustomViewInline() {
            return true;
        }

        private final RemoteViews $$robo$$android_app_Notification_DecoratedMediaCustomViewStyle$makeContentView() {
            RemoteViews remoteViews = super.makeContentView();
            return this.buildIntoRemoteView(remoteViews, 16909245, ((Builder)this.mBuilder).mN.contentView);
        }

        private final RemoteViews $$robo$$android_app_Notification_DecoratedMediaCustomViewStyle$makeBigContentView() {
            RemoteViews customRemoteView = ((Builder)this.mBuilder).mN.bigContentView != null ? ((Builder)this.mBuilder).mN.bigContentView : ((Builder)this.mBuilder).mN.contentView;
            return this.makeBigContentViewWithCustomContent(customRemoteView);
        }

        private final RemoteViews $$robo$$android_app_Notification_DecoratedMediaCustomViewStyle$makeBigContentViewWithCustomContent(RemoteViews customRemoteView) {
            RemoteViews remoteViews = super.makeBigContentView();
            if (remoteViews != null) {
                return this.buildIntoRemoteView(remoteViews, 16909233, customRemoteView);
            }
            if (customRemoteView != ((Builder)this.mBuilder).mN.contentView) {
                remoteViews = super.makeContentView();
                return this.buildIntoRemoteView(remoteViews, 16909245, customRemoteView);
            }
            return null;
        }

        private final RemoteViews $$robo$$android_app_Notification_DecoratedMediaCustomViewStyle$makeHeadsUpContentView() {
            RemoteViews customRemoteView = ((Builder)this.mBuilder).mN.headsUpContentView != null ? ((Builder)this.mBuilder).mN.headsUpContentView : ((Builder)this.mBuilder).mN.contentView;
            return this.makeBigContentViewWithCustomContent(customRemoteView);
        }

        private final RemoteViews $$robo$$android_app_Notification_DecoratedMediaCustomViewStyle$buildIntoRemoteView(RemoteViews remoteViews, int id2, RemoteViews customContent) {
            if (customContent != null) {
                customContent = ((RemoteViews)customContent).clone();
                remoteViews.removeAllViews(id2);
                remoteViews.addView(id2, (RemoteViews)customContent);
            }
            return remoteViews;
        }

        private void __constructor__() {
            this.$$robo$$android_app_Notification_DecoratedMediaCustomViewStyle$__constructor__();
        }

        public DecoratedMediaCustomViewStyle() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_DecoratedMediaCustomViewStyle$__constructor__(), 0, this);
        }

        @Override
        public boolean displayCustomViewInline() {
            return (boolean)InvokeDynamicSupport.bootstrap("displayCustomViewInline", $$robo$$android_app_Notification_DecoratedMediaCustomViewStyle$displayCustomViewInline(), 0, this);
        }

        @Override
        public RemoteViews makeContentView() {
            return InvokeDynamicSupport.bootstrap("makeContentView", $$robo$$android_app_Notification_DecoratedMediaCustomViewStyle$makeContentView(), 0, this);
        }

        @Override
        public RemoteViews makeBigContentView() {
            return InvokeDynamicSupport.bootstrap("makeBigContentView", $$robo$$android_app_Notification_DecoratedMediaCustomViewStyle$makeBigContentView(), 0, this);
        }

        private RemoteViews makeBigContentViewWithCustomContent(RemoteViews remoteViews) {
            return InvokeDynamicSupport.bootstrap("makeBigContentViewWithCustomContent", $$robo$$android_app_Notification_DecoratedMediaCustomViewStyle$makeBigContentViewWithCustomContent(android.widget.RemoteViews ), 0, this, remoteViews);
        }

        @Override
        public RemoteViews makeHeadsUpContentView() {
            return InvokeDynamicSupport.bootstrap("makeHeadsUpContentView", $$robo$$android_app_Notification_DecoratedMediaCustomViewStyle$makeHeadsUpContentView(), 0, this);
        }

        private RemoteViews buildIntoRemoteView(RemoteViews remoteViews, int n, RemoteViews remoteViews2) {
            return InvokeDynamicSupport.bootstrap("buildIntoRemoteView", $$robo$$android_app_Notification_DecoratedMediaCustomViewStyle$buildIntoRemoteView(android.widget.RemoteViews int android.widget.RemoteViews ), 0, this, remoteViews, n, remoteViews2);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DecoratedMediaCustomViewStyle)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class DecoratedCustomViewStyle
    extends Style
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_app_Notification_DecoratedCustomViewStyle$__constructor__() {
        }

        private final boolean $$robo$$android_app_Notification_DecoratedCustomViewStyle$displayCustomViewInline() {
            return true;
        }

        private final RemoteViews $$robo$$android_app_Notification_DecoratedCustomViewStyle$makeContentView() {
            return this.makeStandardTemplateWithCustomContent(((Builder)this.mBuilder).mN.contentView);
        }

        private final RemoteViews $$robo$$android_app_Notification_DecoratedCustomViewStyle$makeBigContentView() {
            return this.makeDecoratedBigContentView();
        }

        private final RemoteViews $$robo$$android_app_Notification_DecoratedCustomViewStyle$makeHeadsUpContentView() {
            return this.makeDecoratedHeadsUpContentView();
        }

        private final RemoteViews $$robo$$android_app_Notification_DecoratedCustomViewStyle$makeDecoratedHeadsUpContentView() {
            RemoteViews headsUpContentView;
            RemoteViews remoteViews = headsUpContentView = ((Builder)this.mBuilder).mN.headsUpContentView == null ? ((Builder)this.mBuilder).mN.contentView : ((Builder)this.mBuilder).mN.headsUpContentView;
            if (this.mBuilder.mActions.size() == 0) {
                return this.makeStandardTemplateWithCustomContent(headsUpContentView);
            }
            RemoteViews remoteViews2 = this.mBuilder.applyStandardTemplateWithActions(this.mBuilder.getBigBaseLayoutResource());
            this.buildIntoRemoteViewContent(remoteViews2, headsUpContentView);
            return remoteViews2;
        }

        private final RemoteViews $$robo$$android_app_Notification_DecoratedCustomViewStyle$makeStandardTemplateWithCustomContent(RemoteViews customContent) {
            RemoteViews remoteViews = this.mBuilder.applyStandardTemplate(this.mBuilder.getBaseLayoutResource());
            this.buildIntoRemoteViewContent(remoteViews, customContent);
            return remoteViews;
        }

        private final RemoteViews $$robo$$android_app_Notification_DecoratedCustomViewStyle$makeDecoratedBigContentView() {
            RemoteViews bigContentView;
            RemoteViews remoteViews = bigContentView = ((Builder)this.mBuilder).mN.bigContentView == null ? ((Builder)this.mBuilder).mN.contentView : ((Builder)this.mBuilder).mN.bigContentView;
            if (this.mBuilder.mActions.size() == 0) {
                return this.makeStandardTemplateWithCustomContent(bigContentView);
            }
            RemoteViews remoteViews2 = this.mBuilder.applyStandardTemplateWithActions(this.mBuilder.getBigBaseLayoutResource());
            this.buildIntoRemoteViewContent(remoteViews2, bigContentView);
            return remoteViews2;
        }

        private final void $$robo$$android_app_Notification_DecoratedCustomViewStyle$buildIntoRemoteViewContent(RemoteViews remoteViews, RemoteViews customContent) {
            if (customContent != null) {
                customContent = ((RemoteViews)customContent).clone();
                remoteViews.removeAllViews(16909233);
                remoteViews.addView(16909233, (RemoteViews)customContent);
            }
            int endMargin = 17104960;
            if (this.mBuilder.mN.hasLargeIcon()) {
                endMargin = 17104962;
            }
            remoteViews.setViewLayoutMarginEndDimen(16909233, endMargin);
        }

        private void __constructor__() {
            this.$$robo$$android_app_Notification_DecoratedCustomViewStyle$__constructor__();
        }

        public DecoratedCustomViewStyle() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_DecoratedCustomViewStyle$__constructor__(), 0, this);
        }

        @Override
        public boolean displayCustomViewInline() {
            return (boolean)InvokeDynamicSupport.bootstrap("displayCustomViewInline", $$robo$$android_app_Notification_DecoratedCustomViewStyle$displayCustomViewInline(), 0, this);
        }

        @Override
        public RemoteViews makeContentView() {
            return InvokeDynamicSupport.bootstrap("makeContentView", $$robo$$android_app_Notification_DecoratedCustomViewStyle$makeContentView(), 0, this);
        }

        @Override
        public RemoteViews makeBigContentView() {
            return InvokeDynamicSupport.bootstrap("makeBigContentView", $$robo$$android_app_Notification_DecoratedCustomViewStyle$makeBigContentView(), 0, this);
        }

        @Override
        public RemoteViews makeHeadsUpContentView() {
            return InvokeDynamicSupport.bootstrap("makeHeadsUpContentView", $$robo$$android_app_Notification_DecoratedCustomViewStyle$makeHeadsUpContentView(), 0, this);
        }

        private RemoteViews makeDecoratedHeadsUpContentView() {
            return InvokeDynamicSupport.bootstrap("makeDecoratedHeadsUpContentView", $$robo$$android_app_Notification_DecoratedCustomViewStyle$makeDecoratedHeadsUpContentView(), 0, this);
        }

        private RemoteViews makeStandardTemplateWithCustomContent(RemoteViews remoteViews) {
            return InvokeDynamicSupport.bootstrap("makeStandardTemplateWithCustomContent", $$robo$$android_app_Notification_DecoratedCustomViewStyle$makeStandardTemplateWithCustomContent(android.widget.RemoteViews ), 0, this, remoteViews);
        }

        private RemoteViews makeDecoratedBigContentView() {
            return InvokeDynamicSupport.bootstrap("makeDecoratedBigContentView", $$robo$$android_app_Notification_DecoratedCustomViewStyle$makeDecoratedBigContentView(), 0, this);
        }

        private void buildIntoRemoteViewContent(RemoteViews remoteViews, RemoteViews remoteViews2) {
            InvokeDynamicSupport.bootstrap("buildIntoRemoteViewContent", $$robo$$android_app_Notification_DecoratedCustomViewStyle$buildIntoRemoteViewContent(android.widget.RemoteViews android.widget.RemoteViews ), 0, this, remoteViews, remoteViews2);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DecoratedCustomViewStyle)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class MediaStyle
    extends Style
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        static int MAX_MEDIA_BUTTONS_IN_COMPACT = 3;
        static int MAX_MEDIA_BUTTONS = 5;
        private int[] mActionsToShowInCompact;
        private MediaSession.Token mToken;

        private void $$robo$$android_app_Notification_MediaStyle$__constructor__() {
            this.mActionsToShowInCompact = null;
        }

        @Deprecated
        private void $$robo$$android_app_Notification_MediaStyle$__constructor__(Builder builder) {
            this.mActionsToShowInCompact = null;
            this.setBuilder(builder);
        }

        private final MediaStyle $$robo$$android_app_Notification_MediaStyle$setShowActionsInCompactView(int ... actions) {
            this.mActionsToShowInCompact = actions;
            return this;
        }

        private final MediaStyle $$robo$$android_app_Notification_MediaStyle$setMediaSession(MediaSession.Token token) {
            this.mToken = token;
            return this;
        }

        private final Notification $$robo$$android_app_Notification_MediaStyle$buildStyled(Notification wip) {
            super.buildStyled(wip);
            if (wip.category == null) {
                wip.category = "transport";
            }
            return wip;
        }

        private final RemoteViews $$robo$$android_app_Notification_MediaStyle$makeContentView() {
            return this.makeMediaContentView();
        }

        private final RemoteViews $$robo$$android_app_Notification_MediaStyle$makeBigContentView() {
            return this.makeMediaBigContentView();
        }

        private final RemoteViews $$robo$$android_app_Notification_MediaStyle$makeHeadsUpContentView() {
            RemoteViews expanded = this.makeMediaBigContentView();
            return expanded != null ? expanded : this.makeMediaContentView();
        }

        private final void $$robo$$android_app_Notification_MediaStyle$addExtras(Bundle extras) {
            super.addExtras(extras);
            if (this.mToken != null) {
                extras.putParcelable("android.mediaSession", this.mToken);
            }
            if (this.mActionsToShowInCompact != null) {
                extras.putIntArray("android.compactActions", this.mActionsToShowInCompact);
            }
        }

        private final void $$robo$$android_app_Notification_MediaStyle$restoreFromExtras(Bundle extras) {
            super.restoreFromExtras(extras);
            if (extras.containsKey("android.mediaSession")) {
                this.mToken = (MediaSession.Token)extras.getParcelable("android.mediaSession");
            }
            if (extras.containsKey("android.compactActions")) {
                this.mActionsToShowInCompact = extras.getIntArray("android.compactActions");
            }
        }

        private final RemoteViews $$robo$$android_app_Notification_MediaStyle$generateMediaActionButton(Action action, int color2) {
            boolean tombstone = action.actionIntent == null;
            BuilderRemoteViews button = new BuilderRemoteViews(this.mBuilder.mContext.getApplicationInfo(), 17367176);
            button.setImageViewIcon(16909215, action.getIcon());
            button.setDrawableParameters(16909215, false, -1, color2, PorterDuff.Mode.SRC_ATOP, -1);
            if (!tombstone) {
                button.setOnClickPendingIntent(16909215, action.actionIntent);
            }
            button.setContentDescription(16909215, action.title);
            return button;
        }

        private final RemoteViews $$robo$$android_app_Notification_MediaStyle$makeMediaContentView() {
            int N;
            RemoteViews view = this.mBuilder.applyStandardTemplate(0x1090091, false);
            int numActions = this.mBuilder.mActions.size();
            int n = N = this.mActionsToShowInCompact == null ? 0 : Math.min(this.mActionsToShowInCompact.length, 3);
            if (N > 0) {
                view.removeAllViews(16909235);
                for (int i = 0; i < N; ++i) {
                    if (i >= numActions) {
                        throw new IllegalArgumentException(String.format("setShowActionsInCompactView: action %d out of bounds (max %d)", i, numActions - 1));
                    }
                    Action action = (Action)this.mBuilder.mActions.get(this.mActionsToShowInCompact[i]);
                    RemoteViews button = this.generateMediaActionButton(action, this.mBuilder.resolveContrastColor());
                    view.addView(16909235, button);
                }
            }
            this.handleImage(view);
            int endMargin = 17104960;
            if (this.mBuilder.mN.hasLargeIcon()) {
                endMargin = 17104962;
            }
            view.setViewLayoutMarginEndDimen(16909233, endMargin);
            return view;
        }

        private final RemoteViews $$robo$$android_app_Notification_MediaStyle$makeMediaBigContentView() {
            int actionsInCompact;
            int actionCount = Math.min(this.mBuilder.mActions.size(), 5);
            int n = actionsInCompact = this.mActionsToShowInCompact == null ? 0 : Math.min(this.mActionsToShowInCompact.length, 3);
            if (!this.mBuilder.mN.hasLargeIcon() && actionCount <= actionsInCompact) {
                return null;
            }
            RemoteViews big = this.mBuilder.applyStandardTemplate(17367181, false);
            if (actionCount > 0) {
                big.removeAllViews(16909235);
                for (int i = 0; i < actionCount; ++i) {
                    RemoteViews button = this.generateMediaActionButton((Action)this.mBuilder.mActions.get(i), this.mBuilder.resolveContrastColor());
                    big.addView(16909235, button);
                }
            }
            this.handleImage(big);
            return big;
        }

        private final void $$robo$$android_app_Notification_MediaStyle$handleImage(RemoteViews contentView) {
            if (this.mBuilder.mN.hasLargeIcon()) {
                contentView.setViewLayoutMarginEndDimen(16909247, 0);
                contentView.setViewLayoutMarginEndDimen(16908413, 0);
            }
        }

        private final boolean $$robo$$android_app_Notification_MediaStyle$hasProgress() {
            return false;
        }

        private void __constructor__() {
            this.$$robo$$android_app_Notification_MediaStyle$__constructor__();
        }

        public MediaStyle() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_MediaStyle$__constructor__(), 0, this);
        }

        private void __constructor__(Builder builder) {
            this.$$robo$$android_app_Notification_MediaStyle$__constructor__(builder);
        }

        public MediaStyle(Builder builder) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_MediaStyle$__constructor__(android.app.Notification$Builder ), 0, this, builder);
        }

        public MediaStyle setShowActionsInCompactView(int ... nArray) {
            return InvokeDynamicSupport.bootstrap("setShowActionsInCompactView", $$robo$$android_app_Notification_MediaStyle$setShowActionsInCompactView(int[] ), 0, this, nArray);
        }

        public MediaStyle setMediaSession(MediaSession.Token token) {
            return InvokeDynamicSupport.bootstrap("setMediaSession", $$robo$$android_app_Notification_MediaStyle$setMediaSession(android.media.session.MediaSession$Token ), 0, this, token);
        }

        @Override
        public Notification buildStyled(Notification notification) {
            return InvokeDynamicSupport.bootstrap("buildStyled", $$robo$$android_app_Notification_MediaStyle$buildStyled(android.app.Notification ), 0, this, notification);
        }

        @Override
        public RemoteViews makeContentView() {
            return InvokeDynamicSupport.bootstrap("makeContentView", $$robo$$android_app_Notification_MediaStyle$makeContentView(), 0, this);
        }

        @Override
        public RemoteViews makeBigContentView() {
            return InvokeDynamicSupport.bootstrap("makeBigContentView", $$robo$$android_app_Notification_MediaStyle$makeBigContentView(), 0, this);
        }

        @Override
        public RemoteViews makeHeadsUpContentView() {
            return InvokeDynamicSupport.bootstrap("makeHeadsUpContentView", $$robo$$android_app_Notification_MediaStyle$makeHeadsUpContentView(), 0, this);
        }

        @Override
        public void addExtras(Bundle bundle) {
            InvokeDynamicSupport.bootstrap("addExtras", $$robo$$android_app_Notification_MediaStyle$addExtras(android.os.Bundle ), 0, this, bundle);
        }

        @Override
        protected void restoreFromExtras(Bundle bundle) {
            InvokeDynamicSupport.bootstrap("restoreFromExtras", $$robo$$android_app_Notification_MediaStyle$restoreFromExtras(android.os.Bundle ), 0, this, bundle);
        }

        private RemoteViews generateMediaActionButton(Action action, int n) {
            return InvokeDynamicSupport.bootstrap("generateMediaActionButton", $$robo$$android_app_Notification_MediaStyle$generateMediaActionButton(android.app.Notification$Action int ), 0, this, action, n);
        }

        private RemoteViews makeMediaContentView() {
            return InvokeDynamicSupport.bootstrap("makeMediaContentView", $$robo$$android_app_Notification_MediaStyle$makeMediaContentView(), 0, this);
        }

        private RemoteViews makeMediaBigContentView() {
            return InvokeDynamicSupport.bootstrap("makeMediaBigContentView", $$robo$$android_app_Notification_MediaStyle$makeMediaBigContentView(), 0, this);
        }

        private void handleImage(RemoteViews remoteViews) {
            InvokeDynamicSupport.bootstrap("handleImage", $$robo$$android_app_Notification_MediaStyle$handleImage(android.widget.RemoteViews ), 0, this, remoteViews);
        }

        @Override
        protected boolean hasProgress() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasProgress", $$robo$$android_app_Notification_MediaStyle$hasProgress(), 0, this);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaStyle)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class InboxStyle
    extends Style
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private ArrayList<CharSequence> mTexts;

        private void $$robo$$android_app_Notification_InboxStyle$__constructor__() {
            this.mTexts = new ArrayList(5);
        }

        @Deprecated
        private void $$robo$$android_app_Notification_InboxStyle$__constructor__(Builder builder) {
            this.mTexts = new ArrayList(5);
            this.setBuilder(builder);
        }

        private final InboxStyle $$robo$$android_app_Notification_InboxStyle$setBigContentTitle(CharSequence title) {
            this.internalSetBigContentTitle(Notification.safeCharSequence(title));
            return this;
        }

        private final InboxStyle $$robo$$android_app_Notification_InboxStyle$setSummaryText(CharSequence cs) {
            this.internalSetSummaryText(Notification.safeCharSequence(cs));
            return this;
        }

        private final InboxStyle $$robo$$android_app_Notification_InboxStyle$addLine(CharSequence cs) {
            this.mTexts.add(Notification.safeCharSequence(cs));
            return this;
        }

        private final void $$robo$$android_app_Notification_InboxStyle$addExtras(Bundle extras) {
            super.addExtras(extras);
            CharSequence[] a = new CharSequence[this.mTexts.size()];
            extras.putCharSequenceArray("android.textLines", this.mTexts.toArray(a));
        }

        private final void $$robo$$android_app_Notification_InboxStyle$restoreFromExtras(Bundle extras) {
            super.restoreFromExtras(extras);
            this.mTexts.clear();
            if (extras.containsKey("android.textLines")) {
                Collections.addAll(this.mTexts, extras.getCharSequenceArray("android.textLines"));
            }
        }

        private final RemoteViews $$robo$$android_app_Notification_InboxStyle$makeBigContentView() {
            int[] rowIds;
            CharSequence oldBuilderContentText = ((Builder)this.mBuilder).mN.extras.getCharSequence("android.text");
            this.mBuilder.getAllExtras().putCharSequence("android.text", null);
            RemoteViews contentView = this.getStandardView(this.mBuilder.getInboxLayoutResource());
            this.mBuilder.getAllExtras().putCharSequence("android.text", oldBuilderContentText);
            for (int rowId : rowIds = new int[]{16909238, 16909239, 16909240, 16909241, 16909242, 16909243, 16909244}) {
                contentView.setViewVisibility(rowId, 8);
            }
            int i = 0;
            int topPadding = this.mBuilder.mContext.getResources().getDimensionPixelSize(17105016);
            boolean first = true;
            int onlyViewId = 0;
            int maxRows = rowIds.length;
            if (this.mBuilder.mActions.size() > 0) {
                --maxRows;
            }
            while (i < this.mTexts.size() && i < maxRows) {
                CharSequence str = this.mTexts.get(i);
                if (!TextUtils.isEmpty(str)) {
                    contentView.setViewVisibility(rowIds[i], 0);
                    contentView.setTextViewText(rowIds[i], this.mBuilder.processLegacyText(str));
                    contentView.setViewPadding(rowIds[i], 0, topPadding, 0, 0);
                    this.handleInboxImageMargin(contentView, rowIds[i], first);
                    onlyViewId = first ? rowIds[i] : 0;
                    first = false;
                }
                ++i;
            }
            if (onlyViewId != 0) {
                topPadding = this.mBuilder.mContext.getResources().getDimensionPixelSize(17105015);
                contentView.setViewPadding(onlyViewId, 0, topPadding, 0, 0);
            }
            return contentView;
        }

        private final void $$robo$$android_app_Notification_InboxStyle$handleInboxImageMargin(RemoteViews contentView, int id2, boolean first) {
            int endMargin = 0;
            if (first) {
                boolean hasProgress;
                int max = ((Builder)this.mBuilder).mN.extras.getInt("android.progressMax", 0);
                boolean ind = ((Builder)this.mBuilder).mN.extras.getBoolean("android.progressIndeterminate");
                boolean bl = hasProgress = max != 0 || ind;
                if (this.mBuilder.mN.hasLargeIcon() && !hasProgress) {
                    endMargin = 17104961;
                }
            }
            contentView.setViewLayoutMarginEndDimen(id2, endMargin);
        }

        private void __constructor__() {
            this.$$robo$$android_app_Notification_InboxStyle$__constructor__();
        }

        public InboxStyle() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_InboxStyle$__constructor__(), 0, this);
        }

        private void __constructor__(Builder builder) {
            this.$$robo$$android_app_Notification_InboxStyle$__constructor__(builder);
        }

        public InboxStyle(Builder builder) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_InboxStyle$__constructor__(android.app.Notification$Builder ), 0, this, builder);
        }

        public InboxStyle setBigContentTitle(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("setBigContentTitle", $$robo$$android_app_Notification_InboxStyle$setBigContentTitle(java.lang.CharSequence ), 0, this, charSequence);
        }

        public InboxStyle setSummaryText(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("setSummaryText", $$robo$$android_app_Notification_InboxStyle$setSummaryText(java.lang.CharSequence ), 0, this, charSequence);
        }

        public InboxStyle addLine(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("addLine", $$robo$$android_app_Notification_InboxStyle$addLine(java.lang.CharSequence ), 0, this, charSequence);
        }

        @Override
        public void addExtras(Bundle bundle) {
            InvokeDynamicSupport.bootstrap("addExtras", $$robo$$android_app_Notification_InboxStyle$addExtras(android.os.Bundle ), 0, this, bundle);
        }

        @Override
        protected void restoreFromExtras(Bundle bundle) {
            InvokeDynamicSupport.bootstrap("restoreFromExtras", $$robo$$android_app_Notification_InboxStyle$restoreFromExtras(android.os.Bundle ), 0, this, bundle);
        }

        @Override
        public RemoteViews makeBigContentView() {
            return InvokeDynamicSupport.bootstrap("makeBigContentView", $$robo$$android_app_Notification_InboxStyle$makeBigContentView(), 0, this);
        }

        private void handleInboxImageMargin(RemoteViews remoteViews, int n, boolean bl) {
            InvokeDynamicSupport.bootstrap("handleInboxImageMargin", $$robo$$android_app_Notification_InboxStyle$handleInboxImageMargin(android.widget.RemoteViews int boolean ), 0, this, remoteViews, n, bl);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InboxStyle)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class MessagingStyle
    extends Style
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int MAXIMUM_RETAINED_MESSAGES = 25;
        CharSequence mUserDisplayName;
        CharSequence mConversationTitle;
        List<Message> mMessages;

        private void $$robo$$android_app_Notification_MessagingStyle$__constructor__() {
            this.mMessages = new ArrayList<Message>();
        }

        private void $$robo$$android_app_Notification_MessagingStyle$__constructor__(CharSequence userDisplayName) {
            this.mMessages = new ArrayList<Message>();
            this.mUserDisplayName = userDisplayName;
        }

        private final CharSequence $$robo$$android_app_Notification_MessagingStyle$getUserDisplayName() {
            return this.mUserDisplayName;
        }

        private final MessagingStyle $$robo$$android_app_Notification_MessagingStyle$setConversationTitle(CharSequence conversationTitle) {
            this.mConversationTitle = conversationTitle;
            return this;
        }

        private final CharSequence $$robo$$android_app_Notification_MessagingStyle$getConversationTitle() {
            return this.mConversationTitle;
        }

        private final MessagingStyle $$robo$$android_app_Notification_MessagingStyle$addMessage(CharSequence text, long timestamp, CharSequence sender) {
            this.mMessages.add(new Message(text, timestamp, sender));
            if (this.mMessages.size() > 25) {
                this.mMessages.remove(0);
            }
            return this;
        }

        private final MessagingStyle $$robo$$android_app_Notification_MessagingStyle$addMessage(Message message) {
            this.mMessages.add(message);
            if (this.mMessages.size() > 25) {
                this.mMessages.remove(0);
            }
            return this;
        }

        private final List<Message> $$robo$$android_app_Notification_MessagingStyle$getMessages() {
            return this.mMessages;
        }

        private final void $$robo$$android_app_Notification_MessagingStyle$addExtras(Bundle extras) {
            super.addExtras(extras);
            if (this.mUserDisplayName != null) {
                extras.putCharSequence("android.selfDisplayName", this.mUserDisplayName);
            }
            if (this.mConversationTitle != null) {
                extras.putCharSequence("android.conversationTitle", this.mConversationTitle);
            }
            if (!this.mMessages.isEmpty()) {
                extras.putParcelableArray("android.messages", Message.getBundleArrayForMessages(this.mMessages));
            }
            this.fixTitleAndTextExtras(extras);
        }

        private final void $$robo$$android_app_Notification_MessagingStyle$fixTitleAndTextExtras(Bundle extras) {
            CharSequence title;
            CharSequence sender;
            CharSequence text;
            Message m = this.findLatestIncomingMessage();
            CharSequence charSequence = text = m == null ? null : m.mText;
            CharSequence charSequence2 = m == null ? null : (sender = TextUtils.isEmpty(m.mSender) ? this.mUserDisplayName : m.mSender);
            if (!TextUtils.isEmpty(this.mConversationTitle)) {
                if (!TextUtils.isEmpty(sender)) {
                    BidiFormatter bidi = BidiFormatter.getInstance();
                    title = this.mBuilder.mContext.getString(17040846, bidi.unicodeWrap(this.mConversationTitle), bidi.unicodeWrap(m.mSender));
                } else {
                    title = this.mConversationTitle;
                }
            } else {
                title = sender;
            }
            if (title != null) {
                extras.putCharSequence("android.title", title);
            }
            if (text != null) {
                extras.putCharSequence("android.text", text);
            }
        }

        private final void $$robo$$android_app_Notification_MessagingStyle$restoreFromExtras(Bundle extras) {
            super.restoreFromExtras(extras);
            this.mMessages.clear();
            this.mUserDisplayName = extras.getCharSequence("android.selfDisplayName");
            this.mConversationTitle = extras.getCharSequence("android.conversationTitle");
            Parcelable[] parcelables = extras.getParcelableArray("android.messages");
            if (parcelables != null && parcelables instanceof Parcelable[]) {
                this.mMessages = Message.getMessagesFromBundleArray(parcelables);
            }
        }

        private final RemoteViews $$robo$$android_app_Notification_MessagingStyle$makeContentView() {
            CharSequence title;
            Message m = this.findLatestIncomingMessage();
            CharSequence charSequence = this.mConversationTitle != null ? this.mConversationTitle : (title = m == null ? null : m.mSender);
            CharSequence text = m == null ? null : (this.mConversationTitle != null ? this.makeMessageLine(m) : m.mText);
            return this.mBuilder.applyStandardTemplate(this.mBuilder.getBaseLayoutResource(), false, title, text);
        }

        private final Message $$robo$$android_app_Notification_MessagingStyle$findLatestIncomingMessage() {
            for (int i = this.mMessages.size() - 1; i >= 0; --i) {
                Message m = this.mMessages.get(i);
                if (TextUtils.isEmpty(m.mSender)) continue;
                return m;
            }
            if (!this.mMessages.isEmpty()) {
                return this.mMessages.get(this.mMessages.size() - 1);
            }
            return null;
        }

        private final RemoteViews $$robo$$android_app_Notification_MessagingStyle$makeBigContentView() {
            int[] rowIds;
            boolean hasTitle;
            CharSequence title = !TextUtils.isEmpty(((Style)this).mBigContentTitle) ? ((Style)this).mBigContentTitle : this.mConversationTitle;
            boolean bl = hasTitle = !TextUtils.isEmpty(title);
            if (this.mMessages.size() == 1) {
                CharSequence text;
                CharSequence bigTitle;
                if (hasTitle) {
                    bigTitle = title;
                    text = this.makeMessageLine(this.mMessages.get(0));
                } else {
                    bigTitle = this.mMessages.get(0).mSender;
                    text = this.mMessages.get(0).mText;
                }
                RemoteViews contentView = this.mBuilder.applyStandardTemplateWithActions(this.mBuilder.getBigTextLayoutResource(), false, bigTitle, null);
                BigTextStyle.applyBigTextContentView(this.mBuilder, contentView, text);
                return contentView;
            }
            RemoteViews contentView = this.mBuilder.applyStandardTemplateWithActions(this.mBuilder.getMessagingLayoutResource(), false, title, null);
            for (int rowId : rowIds = new int[]{16909238, 16909239, 16909240, 16909241, 16909242, 16909243, 16909244}) {
                contentView.setViewVisibility(rowId, 8);
            }
            contentView.setViewLayoutMarginBottomDimen(16909247, hasTitle ? 17104973 : 0);
            contentView.setInt(16909246, "setNumIndentLines", !this.mBuilder.mN.hasLargeIcon() ? 0 : (hasTitle ? 1 : 2));
            int contractedChildId = -1;
            Message contractedMessage = this.findLatestIncomingMessage();
            int firstMessage = Math.max(0, this.mMessages.size() - rowIds.length);
            for (int i = 0; firstMessage + i < this.mMessages.size() && i < rowIds.length; ++i) {
                Message m = this.mMessages.get(firstMessage + i);
                int rowId = rowIds[i];
                contentView.setViewVisibility(rowId, 0);
                contentView.setTextViewText(rowId, this.makeMessageLine(m));
                if (contractedMessage != m) continue;
                contractedChildId = rowId;
            }
            contentView.setInt(16909246, "setContractedChildId", contractedChildId);
            return contentView;
        }

        private final CharSequence $$robo$$android_app_Notification_MessagingStyle$makeMessageLine(Message m) {
            BidiFormatter bidi = BidiFormatter.getInstance();
            SpannableStringBuilder sb = new SpannableStringBuilder();
            if (TextUtils.isEmpty(m.mSender)) {
                CharSequence replyName = this.mUserDisplayName == null ? "" : this.mUserDisplayName;
                sb.append(bidi.unicodeWrap(replyName), MessagingStyle.makeFontColorSpan(this.mBuilder.resolveContrastColor()), 0);
            } else {
                sb.append(bidi.unicodeWrap(m.mSender), MessagingStyle.makeFontColorSpan(-16777216), 0);
            }
            CharSequence text = m.mText == null ? "" : m.mText;
            ((SpannableStringBuilder)sb.append("  ")).append(bidi.unicodeWrap(text));
            return sb;
        }

        private final RemoteViews $$robo$$android_app_Notification_MessagingStyle$makeHeadsUpContentView() {
            CharSequence title;
            Message m = this.findLatestIncomingMessage();
            CharSequence charSequence = this.mConversationTitle != null ? this.mConversationTitle : (title = m == null ? null : m.mSender);
            CharSequence text = m == null ? null : (this.mConversationTitle != null ? this.makeMessageLine(m) : m.mText);
            return this.mBuilder.applyStandardTemplateWithActions(this.mBuilder.getBigBaseLayoutResource(), false, title, text);
        }

        private static final TextAppearanceSpan $$robo$$android_app_Notification_MessagingStyle$makeFontColorSpan(int color2) {
            return new TextAppearanceSpan(null, 0, 0, ColorStateList.valueOf(color2), null);
        }

        private void __constructor__() {
            this.$$robo$$android_app_Notification_MessagingStyle$__constructor__();
        }

        MessagingStyle() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_MessagingStyle$__constructor__(), 0, this);
        }

        private void __constructor__(CharSequence charSequence) {
            this.$$robo$$android_app_Notification_MessagingStyle$__constructor__(charSequence);
        }

        public MessagingStyle(CharSequence charSequence) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_MessagingStyle$__constructor__(java.lang.CharSequence ), 0, this, charSequence);
        }

        public CharSequence getUserDisplayName() {
            return InvokeDynamicSupport.bootstrap("getUserDisplayName", $$robo$$android_app_Notification_MessagingStyle$getUserDisplayName(), 0, this);
        }

        public MessagingStyle setConversationTitle(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("setConversationTitle", $$robo$$android_app_Notification_MessagingStyle$setConversationTitle(java.lang.CharSequence ), 0, this, charSequence);
        }

        public CharSequence getConversationTitle() {
            return InvokeDynamicSupport.bootstrap("getConversationTitle", $$robo$$android_app_Notification_MessagingStyle$getConversationTitle(), 0, this);
        }

        public MessagingStyle addMessage(CharSequence charSequence, long l, CharSequence charSequence2) {
            return InvokeDynamicSupport.bootstrap("addMessage", $$robo$$android_app_Notification_MessagingStyle$addMessage(java.lang.CharSequence long java.lang.CharSequence ), 0, this, charSequence, l, charSequence2);
        }

        public MessagingStyle addMessage(Message message) {
            return InvokeDynamicSupport.bootstrap("addMessage", $$robo$$android_app_Notification_MessagingStyle$addMessage(android.app.Notification$MessagingStyle$Message ), 0, this, message);
        }

        public List<Message> getMessages() {
            return InvokeDynamicSupport.bootstrap("getMessages", $$robo$$android_app_Notification_MessagingStyle$getMessages(), 0, this);
        }

        @Override
        public void addExtras(Bundle bundle) {
            InvokeDynamicSupport.bootstrap("addExtras", $$robo$$android_app_Notification_MessagingStyle$addExtras(android.os.Bundle ), 0, this, bundle);
        }

        private void fixTitleAndTextExtras(Bundle bundle) {
            InvokeDynamicSupport.bootstrap("fixTitleAndTextExtras", $$robo$$android_app_Notification_MessagingStyle$fixTitleAndTextExtras(android.os.Bundle ), 0, this, bundle);
        }

        @Override
        protected void restoreFromExtras(Bundle bundle) {
            InvokeDynamicSupport.bootstrap("restoreFromExtras", $$robo$$android_app_Notification_MessagingStyle$restoreFromExtras(android.os.Bundle ), 0, this, bundle);
        }

        @Override
        public RemoteViews makeContentView() {
            return InvokeDynamicSupport.bootstrap("makeContentView", $$robo$$android_app_Notification_MessagingStyle$makeContentView(), 0, this);
        }

        private Message findLatestIncomingMessage() {
            return InvokeDynamicSupport.bootstrap("findLatestIncomingMessage", $$robo$$android_app_Notification_MessagingStyle$findLatestIncomingMessage(), 0, this);
        }

        @Override
        public RemoteViews makeBigContentView() {
            return InvokeDynamicSupport.bootstrap("makeBigContentView", $$robo$$android_app_Notification_MessagingStyle$makeBigContentView(), 0, this);
        }

        private CharSequence makeMessageLine(Message message) {
            return InvokeDynamicSupport.bootstrap("makeMessageLine", $$robo$$android_app_Notification_MessagingStyle$makeMessageLine(android.app.Notification$MessagingStyle$Message ), 0, this, message);
        }

        @Override
        public RemoteViews makeHeadsUpContentView() {
            return InvokeDynamicSupport.bootstrap("makeHeadsUpContentView", $$robo$$android_app_Notification_MessagingStyle$makeHeadsUpContentView(), 0, this);
        }

        private static TextAppearanceSpan makeFontColorSpan(int n) {
            return InvokeDynamicSupport.bootstrapStatic("makeFontColorSpan", $$robo$$android_app_Notification_MessagingStyle$makeFontColorSpan(int ), 0, (int)n);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MessagingStyle)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
        public static final class Message
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            static String KEY_TEXT = "text";
            static String KEY_TIMESTAMP = "time";
            static String KEY_SENDER = "sender";
            static String KEY_DATA_MIME_TYPE = "type";
            static String KEY_DATA_URI = "uri";
            private CharSequence mText;
            private long mTimestamp;
            private CharSequence mSender;
            private String mDataMimeType;
            private Uri mDataUri;

            private void $$robo$$android_app_Notification_MessagingStyle_Message$__constructor__(CharSequence text, long timestamp, CharSequence sender) {
                this.mText = text;
                this.mTimestamp = timestamp;
                this.mSender = sender;
            }

            private final Message $$robo$$android_app_Notification_MessagingStyle_Message$setData(String dataMimeType, Uri dataUri) {
                this.mDataMimeType = dataMimeType;
                this.mDataUri = dataUri;
                return this;
            }

            private final CharSequence $$robo$$android_app_Notification_MessagingStyle_Message$getText() {
                return this.mText;
            }

            private final long $$robo$$android_app_Notification_MessagingStyle_Message$getTimestamp() {
                return this.mTimestamp;
            }

            private final CharSequence $$robo$$android_app_Notification_MessagingStyle_Message$getSender() {
                return this.mSender;
            }

            private final String $$robo$$android_app_Notification_MessagingStyle_Message$getDataMimeType() {
                return this.mDataMimeType;
            }

            private final Uri $$robo$$android_app_Notification_MessagingStyle_Message$getDataUri() {
                return this.mDataUri;
            }

            private final Bundle $$robo$$android_app_Notification_MessagingStyle_Message$toBundle() {
                Bundle bundle = new Bundle();
                if (this.mText != null) {
                    bundle.putCharSequence("text", this.mText);
                }
                bundle.putLong("time", this.mTimestamp);
                if (this.mSender != null) {
                    bundle.putCharSequence("sender", this.mSender);
                }
                if (this.mDataMimeType != null) {
                    bundle.putString("type", this.mDataMimeType);
                }
                if (this.mDataUri != null) {
                    bundle.putParcelable("uri", this.mDataUri);
                }
                return bundle;
            }

            private static final Bundle[] $$robo$$android_app_Notification_MessagingStyle_Message$getBundleArrayForMessages(List<Message> messages) {
                Bundle[] bundles = new Bundle[messages.size()];
                int N = messages.size();
                for (int i = 0; i < N; ++i) {
                    bundles[i] = messages.get(i).toBundle();
                }
                return bundles;
            }

            private static final List<Message> $$robo$$android_app_Notification_MessagingStyle_Message$getMessagesFromBundleArray(Parcelable[] bundles) {
                ArrayList<Message> messages = new ArrayList<Message>(bundles.length);
                for (int i = 0; i < bundles.length; ++i) {
                    Message message;
                    if (!(bundles[i] instanceof Bundle) || (message = Message.getMessageFromBundle((Bundle)bundles[i])) == null) continue;
                    messages.add(message);
                }
                return messages;
            }

            private static final Message $$robo$$android_app_Notification_MessagingStyle_Message$getMessageFromBundle(Bundle bundle) {
                try {
                    if (!bundle.containsKey("text") || !bundle.containsKey("time")) {
                        return null;
                    }
                    Message message = new Message(bundle.getCharSequence("text"), bundle.getLong("time"), bundle.getCharSequence("sender"));
                    if (bundle.containsKey("type") && bundle.containsKey("uri")) {
                        message.setData(bundle.getString("type"), (Uri)bundle.getParcelable("uri"));
                    }
                    return message;
                }
                catch (ClassCastException e) {
                    return null;
                }
            }

            private void __constructor__(CharSequence charSequence, long l, CharSequence charSequence2) {
                this.$$robo$$android_app_Notification_MessagingStyle_Message$__constructor__(charSequence, l, charSequence2);
            }

            public Message(CharSequence charSequence, long l, CharSequence charSequence2) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_MessagingStyle_Message$__constructor__(java.lang.CharSequence long java.lang.CharSequence ), 0, this, charSequence, l, charSequence2);
            }

            public Message setData(String string2, Uri uri) {
                return InvokeDynamicSupport.bootstrap("setData", $$robo$$android_app_Notification_MessagingStyle_Message$setData(java.lang.String android.net.Uri ), 0, this, string2, uri);
            }

            public CharSequence getText() {
                return InvokeDynamicSupport.bootstrap("getText", $$robo$$android_app_Notification_MessagingStyle_Message$getText(), 0, this);
            }

            public long getTimestamp() {
                return (long)InvokeDynamicSupport.bootstrap("getTimestamp", $$robo$$android_app_Notification_MessagingStyle_Message$getTimestamp(), 0, this);
            }

            public CharSequence getSender() {
                return InvokeDynamicSupport.bootstrap("getSender", $$robo$$android_app_Notification_MessagingStyle_Message$getSender(), 0, this);
            }

            public String getDataMimeType() {
                return InvokeDynamicSupport.bootstrap("getDataMimeType", $$robo$$android_app_Notification_MessagingStyle_Message$getDataMimeType(), 0, this);
            }

            public Uri getDataUri() {
                return InvokeDynamicSupport.bootstrap("getDataUri", $$robo$$android_app_Notification_MessagingStyle_Message$getDataUri(), 0, this);
            }

            private Bundle toBundle() {
                return InvokeDynamicSupport.bootstrap("toBundle", $$robo$$android_app_Notification_MessagingStyle_Message$toBundle(), 0, this);
            }

            static Bundle[] getBundleArrayForMessages(List<Message> list) {
                return InvokeDynamicSupport.bootstrapStatic("getBundleArrayForMessages", $$robo$$android_app_Notification_MessagingStyle_Message$getBundleArrayForMessages(java.util.List<android.app.Notification$MessagingStyle$Message> ), 0, list);
            }

            static List<Message> getMessagesFromBundleArray(Parcelable[] parcelableArray) {
                return InvokeDynamicSupport.bootstrapStatic("getMessagesFromBundleArray", $$robo$$android_app_Notification_MessagingStyle_Message$getMessagesFromBundleArray(android.os.Parcelable[] ), 0, (Parcelable[])parcelableArray);
            }

            static Message getMessageFromBundle(Bundle bundle) {
                return InvokeDynamicSupport.bootstrapStatic("getMessageFromBundle", $$robo$$android_app_Notification_MessagingStyle_Message$getMessageFromBundle(android.os.Bundle ), 0, (Bundle)bundle);
            }

            public /* synthetic */ Message() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Message)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    public static class BigTextStyle
    extends Style
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int MAX_LINES = 13;
        private static int LINES_CONSUMED_BY_ACTIONS = 4;
        private CharSequence mBigText;

        private void $$robo$$android_app_Notification_BigTextStyle$__constructor__() {
        }

        @Deprecated
        private void $$robo$$android_app_Notification_BigTextStyle$__constructor__(Builder builder) {
            this.setBuilder(builder);
        }

        private final BigTextStyle $$robo$$android_app_Notification_BigTextStyle$setBigContentTitle(CharSequence title) {
            this.internalSetBigContentTitle(Notification.safeCharSequence(title));
            return this;
        }

        private final BigTextStyle $$robo$$android_app_Notification_BigTextStyle$setSummaryText(CharSequence cs) {
            this.internalSetSummaryText(Notification.safeCharSequence(cs));
            return this;
        }

        private final BigTextStyle $$robo$$android_app_Notification_BigTextStyle$bigText(CharSequence cs) {
            this.mBigText = Notification.safeCharSequence(cs);
            return this;
        }

        private final void $$robo$$android_app_Notification_BigTextStyle$addExtras(Bundle extras) {
            super.addExtras(extras);
            extras.putCharSequence("android.bigText", this.mBigText);
        }

        private final void $$robo$$android_app_Notification_BigTextStyle$restoreFromExtras(Bundle extras) {
            super.restoreFromExtras(extras);
            this.mBigText = extras.getCharSequence("android.bigText");
        }

        private final RemoteViews $$robo$$android_app_Notification_BigTextStyle$makeBigContentView() {
            CharSequence text = this.mBuilder.getAllExtras().getCharSequence("android.text");
            this.mBuilder.getAllExtras().putCharSequence("android.text", null);
            RemoteViews contentView = this.getStandardView(this.mBuilder.getBigTextLayoutResource());
            this.mBuilder.getAllExtras().putCharSequence("android.text", text);
            CharSequence bigTextText = this.mBuilder.processLegacyText(this.mBigText);
            if (TextUtils.isEmpty(bigTextText)) {
                bigTextText = this.mBuilder.processLegacyText(text);
            }
            BigTextStyle.applyBigTextContentView(this.mBuilder, contentView, bigTextText);
            return contentView;
        }

        private static final void $$robo$$android_app_Notification_BigTextStyle$applyBigTextContentView(Builder builder, RemoteViews contentView, CharSequence bigTextText) {
            contentView.setTextViewText(16909237, bigTextText);
            contentView.setViewVisibility(16909237, TextUtils.isEmpty(bigTextText) ? 8 : 0);
            contentView.setInt(16909237, "setMaxLines", BigTextStyle.calculateMaxLines(builder));
            contentView.setBoolean(16909237, "setHasImage", builder.mN.hasLargeIcon());
        }

        private static final int $$robo$$android_app_Notification_BigTextStyle$calculateMaxLines(Builder builder) {
            boolean hasActions;
            int lineCount = 13;
            boolean bl = hasActions = builder.mActions.size() > 0;
            if (hasActions) {
                lineCount -= 4;
            }
            return lineCount;
        }

        private void __constructor__() {
            this.$$robo$$android_app_Notification_BigTextStyle$__constructor__();
        }

        public BigTextStyle() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_BigTextStyle$__constructor__(), 0, this);
        }

        private void __constructor__(Builder builder) {
            this.$$robo$$android_app_Notification_BigTextStyle$__constructor__(builder);
        }

        public BigTextStyle(Builder builder) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_BigTextStyle$__constructor__(android.app.Notification$Builder ), 0, this, builder);
        }

        public BigTextStyle setBigContentTitle(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("setBigContentTitle", $$robo$$android_app_Notification_BigTextStyle$setBigContentTitle(java.lang.CharSequence ), 0, this, charSequence);
        }

        public BigTextStyle setSummaryText(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("setSummaryText", $$robo$$android_app_Notification_BigTextStyle$setSummaryText(java.lang.CharSequence ), 0, this, charSequence);
        }

        public BigTextStyle bigText(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("bigText", $$robo$$android_app_Notification_BigTextStyle$bigText(java.lang.CharSequence ), 0, this, charSequence);
        }

        @Override
        public void addExtras(Bundle bundle) {
            InvokeDynamicSupport.bootstrap("addExtras", $$robo$$android_app_Notification_BigTextStyle$addExtras(android.os.Bundle ), 0, this, bundle);
        }

        @Override
        protected void restoreFromExtras(Bundle bundle) {
            InvokeDynamicSupport.bootstrap("restoreFromExtras", $$robo$$android_app_Notification_BigTextStyle$restoreFromExtras(android.os.Bundle ), 0, this, bundle);
        }

        @Override
        public RemoteViews makeBigContentView() {
            return InvokeDynamicSupport.bootstrap("makeBigContentView", $$robo$$android_app_Notification_BigTextStyle$makeBigContentView(), 0, this);
        }

        static void applyBigTextContentView(Builder builder, RemoteViews remoteViews, CharSequence charSequence) {
            InvokeDynamicSupport.bootstrapStatic("applyBigTextContentView", $$robo$$android_app_Notification_BigTextStyle$applyBigTextContentView(android.app.Notification$Builder android.widget.RemoteViews java.lang.CharSequence ), 0, (Builder)builder, (RemoteViews)remoteViews, (CharSequence)charSequence);
        }

        private static int calculateMaxLines(Builder builder) {
            return (int)InvokeDynamicSupport.bootstrapStatic("calculateMaxLines", $$robo$$android_app_Notification_BigTextStyle$calculateMaxLines(android.app.Notification$Builder ), 0, (Builder)builder);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BigTextStyle)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class BigPictureStyle
    extends Style
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Bitmap mPicture;
        private Icon mBigLargeIcon;
        private boolean mBigLargeIconSet;
        public static int MIN_ASHMEM_BITMAP_SIZE = 131072;

        private void $$robo$$android_app_Notification_BigPictureStyle$__constructor__() {
            this.mBigLargeIconSet = false;
        }

        @Deprecated
        private void $$robo$$android_app_Notification_BigPictureStyle$__constructor__(Builder builder) {
            this.mBigLargeIconSet = false;
            this.setBuilder(builder);
        }

        private final BigPictureStyle $$robo$$android_app_Notification_BigPictureStyle$setBigContentTitle(CharSequence title) {
            this.internalSetBigContentTitle(Notification.safeCharSequence(title));
            return this;
        }

        private final BigPictureStyle $$robo$$android_app_Notification_BigPictureStyle$setSummaryText(CharSequence cs) {
            this.internalSetSummaryText(Notification.safeCharSequence(cs));
            return this;
        }

        private final BigPictureStyle $$robo$$android_app_Notification_BigPictureStyle$bigPicture(Bitmap b) {
            this.mPicture = b;
            return this;
        }

        private final BigPictureStyle $$robo$$android_app_Notification_BigPictureStyle$bigLargeIcon(Bitmap b) {
            return this.bigLargeIcon(b != null ? Icon.createWithBitmap(b) : null);
        }

        private final BigPictureStyle $$robo$$android_app_Notification_BigPictureStyle$bigLargeIcon(Icon icon) {
            this.mBigLargeIconSet = true;
            this.mBigLargeIcon = icon;
            return this;
        }

        private final void $$robo$$android_app_Notification_BigPictureStyle$purgeResources() {
            super.purgeResources();
            if (this.mPicture != null && this.mPicture.isMutable() && this.mPicture.getAllocationByteCount() >= 131072) {
                this.mPicture = this.mPicture.createAshmemBitmap();
            }
            if (this.mBigLargeIcon != null) {
                this.mBigLargeIcon.convertToAshmem();
            }
        }

        private final RemoteViews $$robo$$android_app_Notification_BigPictureStyle$makeBigContentView() {
            Icon oldLargeIcon = null;
            if (this.mBigLargeIconSet) {
                oldLargeIcon = this.mBuilder.mN.mLargeIcon;
                this.mBuilder.mN.mLargeIcon = this.mBigLargeIcon;
            }
            RemoteViews contentView = this.getStandardView(this.mBuilder.getBigPictureLayoutResource());
            if (this.mSummaryTextSet) {
                contentView.setTextViewText(16908413, this.mBuilder.processLegacyText(this.mSummaryText));
                contentView.setViewVisibility(16908413, 0);
            }
            this.mBuilder.setContentMinHeight(contentView, this.mBuilder.mN.hasLargeIcon());
            if (this.mBigLargeIconSet) {
                this.mBuilder.mN.mLargeIcon = oldLargeIcon;
            }
            contentView.setImageViewBitmap(16909236, this.mPicture);
            return contentView;
        }

        private final void $$robo$$android_app_Notification_BigPictureStyle$addExtras(Bundle extras) {
            super.addExtras(extras);
            if (this.mBigLargeIconSet) {
                extras.putParcelable("android.largeIcon.big", this.mBigLargeIcon);
            }
            extras.putParcelable("android.picture", this.mPicture);
        }

        private final void $$robo$$android_app_Notification_BigPictureStyle$restoreFromExtras(Bundle extras) {
            super.restoreFromExtras(extras);
            if (extras.containsKey("android.largeIcon.big")) {
                this.mBigLargeIconSet = true;
                this.mBigLargeIcon = (Icon)extras.getParcelable("android.largeIcon.big");
            }
            this.mPicture = (Bitmap)extras.getParcelable("android.picture");
        }

        private final boolean $$robo$$android_app_Notification_BigPictureStyle$hasSummaryInHeader() {
            return false;
        }

        private void __constructor__() {
            this.$$robo$$android_app_Notification_BigPictureStyle$__constructor__();
        }

        public BigPictureStyle() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_BigPictureStyle$__constructor__(), 0, this);
        }

        private void __constructor__(Builder builder) {
            this.$$robo$$android_app_Notification_BigPictureStyle$__constructor__(builder);
        }

        public BigPictureStyle(Builder builder) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_BigPictureStyle$__constructor__(android.app.Notification$Builder ), 0, this, builder);
        }

        public BigPictureStyle setBigContentTitle(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("setBigContentTitle", $$robo$$android_app_Notification_BigPictureStyle$setBigContentTitle(java.lang.CharSequence ), 0, this, charSequence);
        }

        public BigPictureStyle setSummaryText(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("setSummaryText", $$robo$$android_app_Notification_BigPictureStyle$setSummaryText(java.lang.CharSequence ), 0, this, charSequence);
        }

        public BigPictureStyle bigPicture(Bitmap bitmap) {
            return InvokeDynamicSupport.bootstrap("bigPicture", $$robo$$android_app_Notification_BigPictureStyle$bigPicture(android.graphics.Bitmap ), 0, this, bitmap);
        }

        public BigPictureStyle bigLargeIcon(Bitmap bitmap) {
            return InvokeDynamicSupport.bootstrap("bigLargeIcon", $$robo$$android_app_Notification_BigPictureStyle$bigLargeIcon(android.graphics.Bitmap ), 0, this, bitmap);
        }

        public BigPictureStyle bigLargeIcon(Icon icon) {
            return InvokeDynamicSupport.bootstrap("bigLargeIcon", $$robo$$android_app_Notification_BigPictureStyle$bigLargeIcon(android.graphics.drawable.Icon ), 0, this, icon);
        }

        @Override
        public void purgeResources() {
            InvokeDynamicSupport.bootstrap("purgeResources", $$robo$$android_app_Notification_BigPictureStyle$purgeResources(), 0, this);
        }

        @Override
        public RemoteViews makeBigContentView() {
            return InvokeDynamicSupport.bootstrap("makeBigContentView", $$robo$$android_app_Notification_BigPictureStyle$makeBigContentView(), 0, this);
        }

        @Override
        public void addExtras(Bundle bundle) {
            InvokeDynamicSupport.bootstrap("addExtras", $$robo$$android_app_Notification_BigPictureStyle$addExtras(android.os.Bundle ), 0, this, bundle);
        }

        @Override
        protected void restoreFromExtras(Bundle bundle) {
            InvokeDynamicSupport.bootstrap("restoreFromExtras", $$robo$$android_app_Notification_BigPictureStyle$restoreFromExtras(android.os.Bundle ), 0, this, bundle);
        }

        @Override
        public boolean hasSummaryInHeader() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasSummaryInHeader", $$robo$$android_app_Notification_BigPictureStyle$hasSummaryInHeader(), 0, this);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BigPictureStyle)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class Style
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private CharSequence mBigContentTitle;
        protected CharSequence mSummaryText;
        protected boolean mSummaryTextSet;
        protected Builder mBuilder;

        private void $$robo$$android_app_Notification_Style$__constructor__() {
            this.mSummaryText = null;
            this.mSummaryTextSet = false;
        }

        private final void $$robo$$android_app_Notification_Style$internalSetBigContentTitle(CharSequence title) {
            this.mBigContentTitle = title;
        }

        private final void $$robo$$android_app_Notification_Style$internalSetSummaryText(CharSequence cs) {
            this.mSummaryText = cs;
            this.mSummaryTextSet = true;
        }

        private final void $$robo$$android_app_Notification_Style$setBuilder(Builder builder) {
            if (this.mBuilder != builder) {
                this.mBuilder = builder;
                if (this.mBuilder != null) {
                    this.mBuilder.setStyle(this);
                }
            }
        }

        private final void $$robo$$android_app_Notification_Style$checkBuilder() {
            if (this.mBuilder == null) {
                throw new IllegalArgumentException("Style requires a valid Builder object");
            }
        }

        private final RemoteViews $$robo$$android_app_Notification_Style$getStandardView(int layoutId) {
            this.checkBuilder();
            CharSequence oldBuilderContentTitle = this.mBuilder.getAllExtras().getCharSequence("android.title");
            if (this.mBigContentTitle != null) {
                this.mBuilder.setContentTitle(this.mBigContentTitle);
            }
            RemoteViews contentView = this.mBuilder.applyStandardTemplateWithActions(layoutId);
            this.mBuilder.getAllExtras().putCharSequence("android.title", oldBuilderContentTitle);
            if (this.mBigContentTitle != null && this.mBigContentTitle.equals("")) {
                contentView.setViewVisibility(16909247, 8);
            } else {
                contentView.setViewVisibility(16909247, 0);
            }
            return contentView;
        }

        private final RemoteViews $$robo$$android_app_Notification_Style$makeContentView() {
            return null;
        }

        private final RemoteViews $$robo$$android_app_Notification_Style$makeBigContentView() {
            return null;
        }

        private final RemoteViews $$robo$$android_app_Notification_Style$makeHeadsUpContentView() {
            return null;
        }

        private final void $$robo$$android_app_Notification_Style$addExtras(Bundle extras) {
            if (this.mSummaryTextSet) {
                extras.putCharSequence("android.summaryText", this.mSummaryText);
            }
            if (this.mBigContentTitle != null) {
                extras.putCharSequence("android.title.big", this.mBigContentTitle);
            }
            extras.putString("android.template", this.getClass().getName());
        }

        private final void $$robo$$android_app_Notification_Style$restoreFromExtras(Bundle extras) {
            if (extras.containsKey("android.summaryText")) {
                this.mSummaryText = extras.getCharSequence("android.summaryText");
                this.mSummaryTextSet = true;
            }
            if (extras.containsKey("android.title.big")) {
                this.mBigContentTitle = extras.getCharSequence("android.title.big");
            }
        }

        private final Notification $$robo$$android_app_Notification_Style$buildStyled(Notification wip) {
            this.addExtras(wip.extras);
            return wip;
        }

        private final void $$robo$$android_app_Notification_Style$purgeResources() {
        }

        private final Notification $$robo$$android_app_Notification_Style$build() {
            this.checkBuilder();
            return this.mBuilder.build();
        }

        private final boolean $$robo$$android_app_Notification_Style$hasProgress() {
            return true;
        }

        private final boolean $$robo$$android_app_Notification_Style$hasSummaryInHeader() {
            return true;
        }

        private final boolean $$robo$$android_app_Notification_Style$displayCustomViewInline() {
            return false;
        }

        private void __constructor__() {
            this.$$robo$$android_app_Notification_Style$__constructor__();
        }

        public Style() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_Style$__constructor__(), 0, this);
        }

        protected void internalSetBigContentTitle(CharSequence charSequence) {
            InvokeDynamicSupport.bootstrap("internalSetBigContentTitle", $$robo$$android_app_Notification_Style$internalSetBigContentTitle(java.lang.CharSequence ), 0, this, charSequence);
        }

        protected void internalSetSummaryText(CharSequence charSequence) {
            InvokeDynamicSupport.bootstrap("internalSetSummaryText", $$robo$$android_app_Notification_Style$internalSetSummaryText(java.lang.CharSequence ), 0, this, charSequence);
        }

        public void setBuilder(Builder builder) {
            InvokeDynamicSupport.bootstrap("setBuilder", $$robo$$android_app_Notification_Style$setBuilder(android.app.Notification$Builder ), 0, this, builder);
        }

        protected void checkBuilder() {
            InvokeDynamicSupport.bootstrap("checkBuilder", $$robo$$android_app_Notification_Style$checkBuilder(), 0, this);
        }

        protected RemoteViews getStandardView(int n) {
            return InvokeDynamicSupport.bootstrap("getStandardView", $$robo$$android_app_Notification_Style$getStandardView(int ), 0, this, n);
        }

        public RemoteViews makeContentView() {
            return InvokeDynamicSupport.bootstrap("makeContentView", $$robo$$android_app_Notification_Style$makeContentView(), 0, this);
        }

        public RemoteViews makeBigContentView() {
            return InvokeDynamicSupport.bootstrap("makeBigContentView", $$robo$$android_app_Notification_Style$makeBigContentView(), 0, this);
        }

        public RemoteViews makeHeadsUpContentView() {
            return InvokeDynamicSupport.bootstrap("makeHeadsUpContentView", $$robo$$android_app_Notification_Style$makeHeadsUpContentView(), 0, this);
        }

        public void addExtras(Bundle bundle) {
            InvokeDynamicSupport.bootstrap("addExtras", $$robo$$android_app_Notification_Style$addExtras(android.os.Bundle ), 0, this, bundle);
        }

        protected void restoreFromExtras(Bundle bundle) {
            InvokeDynamicSupport.bootstrap("restoreFromExtras", $$robo$$android_app_Notification_Style$restoreFromExtras(android.os.Bundle ), 0, this, bundle);
        }

        public Notification buildStyled(Notification notification) {
            return InvokeDynamicSupport.bootstrap("buildStyled", $$robo$$android_app_Notification_Style$buildStyled(android.app.Notification ), 0, this, notification);
        }

        public void purgeResources() {
            InvokeDynamicSupport.bootstrap("purgeResources", $$robo$$android_app_Notification_Style$purgeResources(), 0, this);
        }

        public Notification build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_app_Notification_Style$build(), 0, this);
        }

        protected boolean hasProgress() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasProgress", $$robo$$android_app_Notification_Style$hasProgress(), 0, this);
        }

        public boolean hasSummaryInHeader() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasSummaryInHeader", $$robo$$android_app_Notification_Style$hasSummaryInHeader(), 0, this);
        }

        public boolean displayCustomViewInline() {
            return (boolean)InvokeDynamicSupport.bootstrap("displayCustomViewInline", $$robo$$android_app_Notification_Style$displayCustomViewInline(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Style)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static String EXTRA_REBUILD_CONTENT_VIEW_ACTION_COUNT = "android.rebuild.contentViewActionCount";
        public static String EXTRA_REBUILD_BIG_CONTENT_VIEW_ACTION_COUNT = "android.rebuild.bigViewActionCount";
        public static String EXTRA_REBUILD_HEADS_UP_CONTENT_VIEW_ACTION_COUNT = "android.rebuild.hudViewActionCount";
        private static int MAX_ACTION_BUTTONS = 3;
        private Context mContext;
        private Notification mN;
        private Bundle mUserExtras;
        private Style mStyle;
        private ArrayList<Action> mActions;
        private ArrayList<String> mPersonList;
        private NotificationColorUtil mColorUtil;
        private boolean mColorUtilInited;
        private int mCachedContrastColor;
        private int mCachedContrastColorIsFor;

        private void $$robo$$android_app_Notification_Builder$__constructor__(Context context) {
        }

        private void $$robo$$android_app_Notification_Builder$__constructor__(Context context, Notification toAdopt) {
            this.mUserExtras = new Bundle();
            this.mActions = new ArrayList(3);
            this.mPersonList = new ArrayList();
            this.mColorUtilInited = false;
            this.mCachedContrastColor = 1;
            this.mCachedContrastColorIsFor = 1;
            this.mContext = context;
            if (toAdopt == null) {
                this.mN = new Notification();
                if (context.getApplicationInfo().targetSdkVersion < 24) {
                    this.mN.extras.putBoolean("android.showWhen", true);
                }
                this.mN.priority = 0;
                this.mN.visibility = 0;
            } else {
                String templateClass;
                this.mN = toAdopt;
                if (this.mN.actions != null) {
                    Collections.addAll(this.mActions, this.mN.actions);
                }
                if (this.mN.extras.containsKey("android.people")) {
                    Collections.addAll(this.mPersonList, this.mN.extras.getStringArray("android.people"));
                }
                if (this.mN.getSmallIcon() == null && this.mN.icon != 0) {
                    this.setSmallIcon(this.mN.icon);
                }
                if (this.mN.getLargeIcon() == null && this.mN.largeIcon != null) {
                    this.setLargeIcon(this.mN.largeIcon);
                }
                if (!TextUtils.isEmpty(templateClass = this.mN.extras.getString("android.template"))) {
                    Class<? extends Style> styleClass = Builder.getNotificationStyleClass(templateClass);
                    if (styleClass == null) {
                        Log.d("Notification", "Unknown style class: " + templateClass);
                    } else {
                        try {
                            Constructor<? extends Style> ctor = styleClass.getDeclaredConstructor(new Class[0]);
                            ctor.setAccessible(true);
                            Style style2 = ctor.newInstance(new Object[0]);
                            style2.restoreFromExtras(this.mN.extras);
                            if (style2 != null) {
                                this.setStyle(style2);
                            }
                        }
                        catch (Throwable t) {
                            Log.e("Notification", "Could not create Style", t);
                        }
                    }
                }
            }
        }

        private final NotificationColorUtil $$robo$$android_app_Notification_Builder$getColorUtil() {
            if (!this.mColorUtilInited) {
                this.mColorUtilInited = true;
                if (this.mContext.getApplicationInfo().targetSdkVersion < 21) {
                    this.mColorUtil = NotificationColorUtil.getInstance(this.mContext);
                }
            }
            return this.mColorUtil;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setWhen(long when) {
            this.mN.when = when;
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setShowWhen(boolean show) {
            this.mN.extras.putBoolean("android.showWhen", show);
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setUsesChronometer(boolean b) {
            this.mN.extras.putBoolean("android.showChronometer", b);
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setChronometerCountDown(boolean countDown) {
            this.mN.extras.putBoolean("android.chronometerCountDown", countDown);
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setSmallIcon(int icon) {
            return this.setSmallIcon(icon != 0 ? Icon.createWithResource(this.mContext, icon) : null);
        }

        private final Builder $$robo$$android_app_Notification_Builder$setSmallIcon(int icon, int level) {
            this.mN.iconLevel = level;
            return this.setSmallIcon(icon);
        }

        private final Builder $$robo$$android_app_Notification_Builder$setSmallIcon(Icon icon) {
            this.mN.setSmallIcon(icon);
            if (icon != null && icon.getType() == 2) {
                this.mN.icon = icon.getResId();
            }
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setContentTitle(CharSequence title) {
            this.mN.extras.putCharSequence("android.title", Notification.safeCharSequence(title));
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setContentText(CharSequence text) {
            this.mN.extras.putCharSequence("android.text", Notification.safeCharSequence(text));
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setSubText(CharSequence text) {
            this.mN.extras.putCharSequence("android.subText", Notification.safeCharSequence(text));
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setRemoteInputHistory(CharSequence[] text) {
            if (text == null) {
                this.mN.extras.putCharSequenceArray("android.remoteInputHistory", null);
            } else {
                int N = Math.min(5, text.length);
                CharSequence[] safe = new CharSequence[N];
                for (int i = 0; i < N; ++i) {
                    safe[i] = Notification.safeCharSequence(text[i]);
                }
                this.mN.extras.putCharSequenceArray("android.remoteInputHistory", safe);
            }
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setNumber(int number) {
            this.mN.number = number;
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setContentInfo(CharSequence info) {
            this.mN.extras.putCharSequence("android.infoText", Notification.safeCharSequence(info));
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setProgress(int max, int progress, boolean indeterminate) {
            this.mN.extras.putInt("android.progress", progress);
            this.mN.extras.putInt("android.progressMax", max);
            this.mN.extras.putBoolean("android.progressIndeterminate", indeterminate);
            return this;
        }

        @Deprecated
        private final Builder $$robo$$android_app_Notification_Builder$setContent(RemoteViews views) {
            return this.setCustomContentView(views);
        }

        private final Builder $$robo$$android_app_Notification_Builder$setCustomContentView(RemoteViews contentView) {
            this.mN.contentView = contentView;
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setCustomBigContentView(RemoteViews contentView) {
            this.mN.bigContentView = contentView;
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setCustomHeadsUpContentView(RemoteViews contentView) {
            this.mN.headsUpContentView = contentView;
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setContentIntent(PendingIntent intent) {
            this.mN.contentIntent = intent;
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setDeleteIntent(PendingIntent intent) {
            this.mN.deleteIntent = intent;
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setFullScreenIntent(PendingIntent intent, boolean highPriority) {
            this.mN.fullScreenIntent = intent;
            this.setFlag(128, highPriority);
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setTicker(CharSequence tickerText) {
            this.mN.tickerText = Notification.safeCharSequence(tickerText);
            return this;
        }

        @Deprecated
        private final Builder $$robo$$android_app_Notification_Builder$setTicker(CharSequence tickerText, RemoteViews views) {
            this.setTicker(tickerText);
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setLargeIcon(Bitmap b) {
            return this.setLargeIcon(b != null ? Icon.createWithBitmap(b) : null);
        }

        private final Builder $$robo$$android_app_Notification_Builder$setLargeIcon(Icon icon) {
            this.mN.mLargeIcon = icon;
            this.mN.extras.putParcelable("android.largeIcon", icon);
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setSound(Uri sound) {
            this.mN.sound = sound;
            this.mN.audioAttributes = AUDIO_ATTRIBUTES_DEFAULT;
            return this;
        }

        @Deprecated
        private final Builder $$robo$$android_app_Notification_Builder$setSound(Uri sound, int streamType) {
            this.mN.sound = sound;
            this.mN.audioStreamType = streamType;
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setSound(Uri sound, AudioAttributes audioAttributes) {
            this.mN.sound = sound;
            this.mN.audioAttributes = audioAttributes;
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setVibrate(long[] pattern) {
            this.mN.vibrate = pattern;
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setLights(int argb, int onMs, int offMs) {
            this.mN.ledARGB = argb;
            this.mN.ledOnMS = onMs;
            this.mN.ledOffMS = offMs;
            if (onMs != 0 || offMs != 0) {
                this.mN.flags |= 1;
            }
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setOngoing(boolean ongoing) {
            this.setFlag(2, ongoing);
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setOnlyAlertOnce(boolean onlyAlertOnce) {
            this.setFlag(8, onlyAlertOnce);
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setAutoCancel(boolean autoCancel) {
            this.setFlag(16, autoCancel);
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setLocalOnly(boolean localOnly) {
            this.setFlag(256, localOnly);
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setDefaults(int defaults) {
            this.mN.defaults = defaults;
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setPriority(int pri) {
            this.mN.priority = pri;
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setCategory(String category) {
            this.mN.category = category;
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$addPerson(String uri) {
            this.mPersonList.add(uri);
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setGroup(String groupKey) {
            this.mN.mGroupKey = groupKey;
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setGroupSummary(boolean isGroupSummary) {
            this.setFlag(512, isGroupSummary);
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setSortKey(String sortKey) {
            this.mN.mSortKey = sortKey;
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$addExtras(Bundle extras) {
            if (extras != null) {
                this.mUserExtras.putAll(extras);
            }
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setExtras(Bundle extras) {
            if (extras != null) {
                this.mUserExtras = extras;
            }
            return this;
        }

        private final Bundle $$robo$$android_app_Notification_Builder$getExtras() {
            return this.mUserExtras;
        }

        private final Bundle $$robo$$android_app_Notification_Builder$getAllExtras() {
            Bundle saveExtras = (Bundle)this.mUserExtras.clone();
            saveExtras.putAll(this.mN.extras);
            return saveExtras;
        }

        @Deprecated
        private final Builder $$robo$$android_app_Notification_Builder$addAction(int icon, CharSequence title, PendingIntent intent) {
            this.mActions.add(new Action(icon, Notification.safeCharSequence(title), intent));
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$addAction(Action action) {
            this.mActions.add(action);
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setActions(Action ... actions) {
            this.mActions.clear();
            for (int i = 0; i < actions.length; ++i) {
                this.mActions.add(actions[i]);
            }
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setStyle(Style style2) {
            if (this.mStyle != style2) {
                this.mStyle = style2;
                if (this.mStyle != null) {
                    this.mStyle.setBuilder(this);
                    this.mN.extras.putString("android.template", style2.getClass().getName());
                } else {
                    this.mN.extras.remove("android.template");
                }
            }
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setVisibility(int visibility) {
            this.mN.visibility = visibility;
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setPublicVersion(Notification n) {
            if (n != null) {
                this.mN.publicVersion = new Notification();
                n.cloneInto(this.mN.publicVersion, true);
            } else {
                this.mN.publicVersion = null;
            }
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$extend(Extender extender) {
            extender.extend(this);
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setFlag(int mask, boolean value) {
            this.mN.flags = value ? (this.mN.flags |= mask) : (this.mN.flags &= ~mask);
            return this;
        }

        private final Builder $$robo$$android_app_Notification_Builder$setColor(int argb) {
            this.mN.color = argb;
            this.sanitizeColor();
            return this;
        }

        private final Drawable $$robo$$android_app_Notification_Builder$getProfileBadgeDrawable() {
            if (this.mContext.getUserId() == 0) {
                return null;
            }
            return this.mContext.getPackageManager().getUserBadgeForDensityNoBackground(new UserHandle(this.mContext.getUserId()), 0);
        }

        private final Bitmap $$robo$$android_app_Notification_Builder$getProfileBadge() {
            Drawable badge = this.getProfileBadgeDrawable();
            if (badge == null) {
                return null;
            }
            int size = this.mContext.getResources().getDimensionPixelSize(17105017);
            Bitmap bitmap = Bitmap.createBitmap(size, size, Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            badge.setBounds(0, 0, size, size);
            badge.draw(canvas);
            return bitmap;
        }

        private final void $$robo$$android_app_Notification_Builder$bindProfileBadge(RemoteViews contentView) {
            Bitmap profileBadge = this.getProfileBadge();
            if (profileBadge != null) {
                contentView.setImageViewBitmap(16909231, profileBadge);
                contentView.setViewVisibility(16909231, 0);
            }
        }

        private final void $$robo$$android_app_Notification_Builder$resetStandardTemplate(RemoteViews contentView) {
            this.resetNotificationHeader(contentView);
            this.resetContentMargins(contentView);
            contentView.setViewVisibility(16908356, 8);
            contentView.setViewVisibility(16908310, 8);
            contentView.setTextViewText(16908310, null);
            contentView.setViewVisibility(16908413, 8);
            contentView.setTextViewText(16908413, null);
            contentView.setViewVisibility(16909248, 8);
            contentView.setTextViewText(16909248, null);
            contentView.setViewVisibility(16908301, 8);
        }

        private final void $$robo$$android_app_Notification_Builder$resetNotificationHeader(RemoteViews contentView) {
            contentView.setImageViewResource(16908294, 0);
            contentView.setBoolean(16909224, "setExpanded", false);
            contentView.setTextViewText(16909225, null);
            contentView.setViewVisibility(16909229, 8);
            contentView.setViewVisibility(16909227, 8);
            contentView.setTextViewText(16909227, null);
            contentView.setViewVisibility(16909226, 8);
            contentView.setViewVisibility(16909228, 8);
            contentView.setViewVisibility(16908436, 8);
            contentView.setImageViewIcon(16909231, null);
            contentView.setViewVisibility(16909231, 8);
        }

        private final void $$robo$$android_app_Notification_Builder$resetContentMargins(RemoteViews contentView) {
            contentView.setViewLayoutMarginEndDimen(16909247, 0);
            contentView.setViewLayoutMarginEndDimen(16908413, 0);
        }

        private final RemoteViews $$robo$$android_app_Notification_Builder$applyStandardTemplate(int resId) {
            return this.applyStandardTemplate(resId, true);
        }

        private final RemoteViews $$robo$$android_app_Notification_Builder$applyStandardTemplate(int resId, boolean hasProgress) {
            Bundle ex = this.mN.extras;
            CharSequence title = this.processLegacyText(ex.getCharSequence("android.title"));
            CharSequence text = this.processLegacyText(ex.getCharSequence("android.text"));
            return this.applyStandardTemplate(resId, hasProgress, title, text);
        }

        private final RemoteViews $$robo$$android_app_Notification_Builder$applyStandardTemplate(int resId, boolean hasProgress, CharSequence title, CharSequence text) {
            BuilderRemoteViews contentView = new BuilderRemoteViews(this.mContext.getApplicationInfo(), resId);
            this.resetStandardTemplate(contentView);
            Bundle ex = this.mN.extras;
            this.bindNotificationHeader(contentView);
            this.bindLargeIcon(contentView);
            boolean showProgress = this.handleProgressBar(hasProgress, contentView, ex);
            if (title != null) {
                contentView.setViewVisibility(16908310, 0);
                contentView.setTextViewText(16908310, title);
                contentView.setViewLayoutWidth(16908310, showProgress ? -2 : -1);
            }
            if (text != null) {
                int textId = showProgress ? 16909248 : 16908413;
                contentView.setTextViewText(textId, text);
                contentView.setViewVisibility(textId, 0);
            }
            this.setContentMinHeight(contentView, showProgress || this.mN.hasLargeIcon());
            return contentView;
        }

        private final void $$robo$$android_app_Notification_Builder$setContentMinHeight(RemoteViews remoteView, boolean hasMinHeight) {
            int minHeight = 0;
            if (hasMinHeight) {
                minHeight = this.mContext.getResources().getDimensionPixelSize(17104969);
            }
            remoteView.setInt(16909233, "setMinimumHeight", minHeight);
        }

        private final boolean $$robo$$android_app_Notification_Builder$handleProgressBar(boolean hasProgress, RemoteViews contentView, Bundle ex) {
            int max = ex.getInt("android.progressMax", 0);
            int progress = ex.getInt("android.progress", 0);
            boolean ind = ex.getBoolean("android.progressIndeterminate");
            if (hasProgress && (max != 0 || ind)) {
                contentView.setViewVisibility(16908301, 0);
                contentView.setProgressBar(16908301, max, progress, ind);
                contentView.setProgressBackgroundTintList(16908301, ColorStateList.valueOf(this.mContext.getColor(17170514)));
                if (this.mN.color != 0) {
                    ColorStateList colorStateList = ColorStateList.valueOf(this.resolveContrastColor());
                    contentView.setProgressTintList(16908301, colorStateList);
                    contentView.setProgressIndeterminateTintList(16908301, colorStateList);
                }
                return true;
            }
            contentView.setViewVisibility(16908301, 8);
            return false;
        }

        private final void $$robo$$android_app_Notification_Builder$bindLargeIcon(RemoteViews contentView) {
            if (this.mN.mLargeIcon == null && this.mN.largeIcon != null) {
                this.mN.mLargeIcon = Icon.createWithBitmap(this.mN.largeIcon);
            }
            if (this.mN.mLargeIcon != null) {
                contentView.setViewVisibility(16908356, 0);
                contentView.setImageViewIcon(16908356, this.mN.mLargeIcon);
                this.processLargeLegacyIcon(this.mN.mLargeIcon, contentView);
                int endMargin = 17104961;
                contentView.setViewLayoutMarginEndDimen(16909247, endMargin);
                contentView.setViewLayoutMarginEndDimen(16908413, endMargin);
                contentView.setViewLayoutMarginEndDimen(16908301, endMargin);
            }
        }

        private final void $$robo$$android_app_Notification_Builder$bindNotificationHeader(RemoteViews contentView) {
            this.bindSmallIcon(contentView);
            this.bindHeaderAppName(contentView);
            this.bindHeaderText(contentView);
            this.bindHeaderChronometerAndTime(contentView);
            this.bindExpandButton(contentView);
            this.bindProfileBadge(contentView);
        }

        private final void $$robo$$android_app_Notification_Builder$bindExpandButton(RemoteViews contentView) {
            contentView.setDrawableParameters(16909230, false, -1, this.resolveContrastColor(), PorterDuff.Mode.SRC_ATOP, -1);
            contentView.setInt(16909224, "setOriginalNotificationColor", this.resolveContrastColor());
        }

        private final void $$robo$$android_app_Notification_Builder$bindHeaderChronometerAndTime(RemoteViews contentView) {
            if (this.showsTimeOrChronometer()) {
                contentView.setViewVisibility(16909228, 0);
                if (this.mN.extras.getBoolean("android.showChronometer")) {
                    contentView.setViewVisibility(16909229, 0);
                    contentView.setLong(16909229, "setBase", this.mN.when + (SystemClock.elapsedRealtime() - InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System")));
                    contentView.setBoolean(16909229, "setStarted", true);
                    boolean countsDown = this.mN.extras.getBoolean("android.chronometerCountDown");
                    contentView.setChronometerCountDown(16909229, countsDown);
                } else {
                    contentView.setViewVisibility(16908436, 0);
                    contentView.setLong(16908436, "setTime", this.mN.when);
                }
            } else {
                contentView.setLong(16908436, "setTime", this.mN.when != 0L ? this.mN.when : this.mN.creationTime);
            }
        }

        private final void $$robo$$android_app_Notification_Builder$bindHeaderText(RemoteViews contentView) {
            CharSequence headerText = this.mN.extras.getCharSequence("android.subText");
            if (headerText == null && this.mStyle != null && this.mStyle.mSummaryTextSet && this.mStyle.hasSummaryInHeader()) {
                headerText = this.mStyle.mSummaryText;
            }
            if (headerText == null && this.mContext.getApplicationInfo().targetSdkVersion < 24 && this.mN.extras.getCharSequence("android.infoText") != null) {
                headerText = this.mN.extras.getCharSequence("android.infoText");
            }
            if (headerText != null) {
                contentView.setTextViewText(16909227, this.processLegacyText(headerText));
                contentView.setViewVisibility(16909227, 0);
                contentView.setViewVisibility(16909226, 0);
            }
        }

        private final String $$robo$$android_app_Notification_Builder$loadHeaderAppName() {
            CharSequence name = null;
            PackageManager pm = this.mContext.getPackageManager();
            if (this.mN.extras.containsKey("android.substName")) {
                String pkg = this.mContext.getPackageName();
                String subName = this.mN.extras.getString("android.substName");
                if (0 == pm.checkPermission("android.permission.SUBSTITUTE_NOTIFICATION_APP_NAME", pkg)) {
                    name = subName;
                } else {
                    Log.w("Notification", "warning: pkg " + pkg + " attempting to substitute app name '" + subName + "' without holding perm " + "android.permission.SUBSTITUTE_NOTIFICATION_APP_NAME");
                }
            }
            if (TextUtils.isEmpty(name)) {
                name = pm.getApplicationLabel(this.mContext.getApplicationInfo());
            }
            if (TextUtils.isEmpty(name)) {
                return null;
            }
            return String.valueOf(name);
        }

        private final void $$robo$$android_app_Notification_Builder$bindHeaderAppName(RemoteViews contentView) {
            contentView.setTextViewText(16909225, this.loadHeaderAppName());
            contentView.setTextColor(16909225, this.resolveContrastColor());
        }

        private final void $$robo$$android_app_Notification_Builder$bindSmallIcon(RemoteViews contentView) {
            if (this.mN.mSmallIcon == null && this.mN.icon != 0) {
                this.mN.mSmallIcon = Icon.createWithResource(this.mContext, this.mN.icon);
            }
            contentView.setImageViewIcon(16908294, this.mN.mSmallIcon);
            this.processSmallIconColor(this.mN.mSmallIcon, contentView);
        }

        private final boolean $$robo$$android_app_Notification_Builder$showsTimeOrChronometer() {
            return this.mN.showsTime() || this.mN.showsChronometer();
        }

        private final void $$robo$$android_app_Notification_Builder$resetStandardTemplateWithActions(RemoteViews big) {
            big.setViewVisibility(16909214, 8);
            big.removeAllViews(16909214);
            big.setViewVisibility(16909219, 8);
            big.setTextViewText(16909223, null);
            big.setViewVisibility(16909222, 8);
            big.setTextViewText(16909222, null);
            big.setViewVisibility(16909221, 8);
            big.setTextViewText(16909221, null);
            big.setViewLayoutMarginBottomDimen(16909234, 0);
        }

        private final RemoteViews $$robo$$android_app_Notification_Builder$applyStandardTemplateWithActions(int layoutId) {
            Bundle ex = this.mN.extras;
            CharSequence title = this.processLegacyText(ex.getCharSequence("android.title"));
            CharSequence text = this.processLegacyText(ex.getCharSequence("android.text"));
            return this.applyStandardTemplateWithActions(layoutId, true, title, text);
        }

        private final RemoteViews $$robo$$android_app_Notification_Builder$applyStandardTemplateWithActions(int layoutId, boolean hasProgress, CharSequence title, CharSequence text) {
            RemoteViews big = this.applyStandardTemplate(layoutId, hasProgress, title, text);
            this.resetStandardTemplateWithActions(big);
            boolean validRemoteInput = false;
            int N = this.mActions.size();
            if (N > 0) {
                big.setViewVisibility(16909218, 0);
                big.setViewVisibility(16909214, 0);
                big.setViewLayoutMarginBottomDimen(16909234, 17104963);
                if (N > 3) {
                    N = 3;
                }
                for (int i = 0; i < N; ++i) {
                    Action action = this.mActions.get(i);
                    validRemoteInput |= this.hasValidRemoteInput(action);
                    RemoteViews button = this.generateActionButton(action);
                    big.addView(16909214, button);
                }
            } else {
                big.setViewVisibility(16909218, 8);
            }
            CharSequence[] replyText = this.mN.extras.getCharSequenceArray("android.remoteInputHistory");
            if (validRemoteInput && replyText != null && replyText.length > 0 && !TextUtils.isEmpty(replyText[0])) {
                big.setViewVisibility(16909219, 0);
                big.setTextViewText(16909223, replyText[0]);
                if (replyText.length > 1 && !TextUtils.isEmpty(replyText[1])) {
                    big.setViewVisibility(16909222, 0);
                    big.setTextViewText(16909222, replyText[1]);
                    if (replyText.length > 2 && !TextUtils.isEmpty(replyText[2])) {
                        big.setViewVisibility(16909221, 0);
                        big.setTextViewText(16909221, replyText[2]);
                    }
                }
            }
            return big;
        }

        private final boolean $$robo$$android_app_Notification_Builder$hasValidRemoteInput(Action action) {
            if (TextUtils.isEmpty(action.title) || action.actionIntent == null) {
                return false;
            }
            RemoteInput[] remoteInputs = action.getRemoteInputs();
            if (remoteInputs == null) {
                return false;
            }
            for (RemoteInput r : remoteInputs) {
                CharSequence[] choices = r.getChoices();
                if (!r.getAllowFreeFormInput() && (choices == null || choices.length == 0)) continue;
                return true;
            }
            return false;
        }

        private final RemoteViews $$robo$$android_app_Notification_Builder$createContentView() {
            RemoteViews styleView;
            if (!(this.mN.contentView == null || this.mStyle != null && this.mStyle.displayCustomViewInline())) {
                return this.mN.contentView;
            }
            if (this.mStyle != null && (styleView = this.mStyle.makeContentView()) != null) {
                return styleView;
            }
            return this.applyStandardTemplate(this.getBaseLayoutResource());
        }

        private final RemoteViews $$robo$$android_app_Notification_Builder$createBigContentView() {
            RemoteViews result = null;
            if (!(this.mN.bigContentView == null || this.mStyle != null && this.mStyle.displayCustomViewInline())) {
                return this.mN.bigContentView;
            }
            if (this.mStyle != null) {
                result = this.mStyle.makeBigContentView();
                this.hideLine1Text(result);
            } else if (this.mActions.size() != 0) {
                result = this.applyStandardTemplateWithActions(this.getBigBaseLayoutResource());
            }
            this.adaptNotificationHeaderForBigContentView(result);
            return result;
        }

        private final RemoteViews $$robo$$android_app_Notification_Builder$makeNotificationHeader() {
            BuilderRemoteViews header = new BuilderRemoteViews(this.mContext.getApplicationInfo(), 17367178);
            this.resetNotificationHeader(header);
            this.bindNotificationHeader(header);
            return header;
        }

        private final void $$robo$$android_app_Notification_Builder$hideLine1Text(RemoteViews result) {
            if (result != null) {
                result.setViewVisibility(16909248, 8);
            }
        }

        private final void $$robo$$android_app_Notification_Builder$adaptNotificationHeaderForBigContentView(RemoteViews result) {
            if (result != null) {
                result.setBoolean(16909224, "setExpanded", true);
            }
        }

        private final RemoteViews $$robo$$android_app_Notification_Builder$createHeadsUpContentView() {
            if (!(this.mN.headsUpContentView == null || this.mStyle != null && this.mStyle.displayCustomViewInline())) {
                return this.mN.headsUpContentView;
            }
            if (this.mStyle != null) {
                RemoteViews styleView = this.mStyle.makeHeadsUpContentView();
                if (styleView != null) {
                    return styleView;
                }
            } else if (this.mActions.size() == 0) {
                return null;
            }
            return this.applyStandardTemplateWithActions(this.getBigBaseLayoutResource());
        }

        private final RemoteViews $$robo$$android_app_Notification_Builder$makePublicContentView() {
            if (this.mN.publicVersion != null) {
                Builder builder = Builder.recoverBuilder(this.mContext, this.mN.publicVersion);
                return builder.createContentView();
            }
            Bundle savedBundle = this.mN.extras;
            Style style2 = this.mStyle;
            this.mStyle = null;
            Icon largeIcon = this.mN.mLargeIcon;
            this.mN.mLargeIcon = null;
            Bitmap largeIconLegacy = this.mN.largeIcon;
            this.mN.largeIcon = null;
            Bundle publicExtras = new Bundle();
            publicExtras.putBoolean("android.showWhen", savedBundle.getBoolean("android.showWhen"));
            publicExtras.putBoolean("android.showChronometer", savedBundle.getBoolean("android.showChronometer"));
            publicExtras.putBoolean("android.chronometerCountDown", savedBundle.getBoolean("android.chronometerCountDown"));
            publicExtras.putCharSequence("android.title", this.mContext.getString(17039674));
            this.mN.extras = publicExtras;
            RemoteViews publicView = this.applyStandardTemplate(this.getBaseLayoutResource());
            this.mN.extras = savedBundle;
            this.mN.mLargeIcon = largeIcon;
            this.mN.largeIcon = largeIconLegacy;
            this.mStyle = style2;
            return publicView;
        }

        private final RemoteViews $$robo$$android_app_Notification_Builder$generateActionButton(Action action) {
            boolean tombstone = action.actionIntent == null;
            BuilderRemoteViews button = new BuilderRemoteViews(this.mContext.getApplicationInfo(), tombstone ? this.getActionTombstoneLayoutResource() : this.getActionLayoutResource());
            Icon ai = action.getIcon();
            button.setTextViewText(16909215, this.processLegacyText(action.title));
            if (!tombstone) {
                button.setOnClickPendingIntent(16909215, action.actionIntent);
            }
            button.setContentDescription(16909215, action.title);
            if (action.mRemoteInputs != null) {
                button.setRemoteInputs(16909215, action.mRemoteInputs);
            }
            if (this.mN.color != 0) {
                button.setTextColor(16909215, this.resolveContrastColor());
            }
            return button;
        }

        private final boolean $$robo$$android_app_Notification_Builder$isLegacy() {
            return this.getColorUtil() != null;
        }

        private final CharSequence $$robo$$android_app_Notification_Builder$processLegacyText(CharSequence charSequence) {
            if (this.isLegacy()) {
                return this.getColorUtil().invertCharSequenceColors(charSequence);
            }
            return charSequence;
        }

        private final void $$robo$$android_app_Notification_Builder$processSmallIconColor(Icon smallIcon, RemoteViews contentView) {
            boolean colorable;
            boolean bl = colorable = !this.isLegacy() || this.getColorUtil().isGrayscaleIcon(this.mContext, smallIcon);
            if (colorable) {
                contentView.setDrawableParameters(16908294, false, -1, this.resolveContrastColor(), PorterDuff.Mode.SRC_ATOP, -1);
            }
            contentView.setInt(16909224, "setOriginalIconColor", colorable ? this.resolveContrastColor() : -1);
        }

        private final void $$robo$$android_app_Notification_Builder$processLargeLegacyIcon(Icon largeIcon, RemoteViews contentView) {
            if (largeIcon != null && this.isLegacy() && this.getColorUtil().isGrayscaleIcon(this.mContext, largeIcon)) {
                contentView.setDrawableParameters(16908294, false, -1, this.resolveContrastColor(), PorterDuff.Mode.SRC_ATOP, -1);
            }
        }

        private final void $$robo$$android_app_Notification_Builder$sanitizeColor() {
            if (this.mN.color != 0) {
                this.mN.color |= 0xFF000000;
            }
        }

        private final int $$robo$$android_app_Notification_Builder$resolveContrastColor() {
            if (this.mCachedContrastColorIsFor == this.mN.color && this.mCachedContrastColor != 1) {
                return this.mCachedContrastColor;
            }
            int contrasted = NotificationColorUtil.resolveContrastColor(this.mContext, this.mN.color);
            this.mCachedContrastColorIsFor = this.mN.color;
            this.mCachedContrastColor = contrasted;
            return this.mCachedContrastColor;
        }

        private final Notification $$robo$$android_app_Notification_Builder$buildUnstyled() {
            if (this.mActions.size() > 0) {
                this.mN.actions = new Action[this.mActions.size()];
                this.mActions.toArray(this.mN.actions);
            }
            if (!this.mPersonList.isEmpty()) {
                this.mN.extras.putStringArray("android.people", this.mPersonList.toArray(new String[this.mPersonList.size()]));
            }
            if (this.mN.bigContentView != null || this.mN.contentView != null || this.mN.headsUpContentView != null) {
                this.mN.extras.putBoolean("android.contains.customView", true);
            }
            return this.mN;
        }

        private static final Builder $$robo$$android_app_Notification_Builder$recoverBuilder(Context context, Notification n) {
            Context builderContext;
            ApplicationInfo applicationInfo = (ApplicationInfo)n.extras.getParcelable("android.appInfo");
            if (applicationInfo != null) {
                try {
                    builderContext = context.createApplicationContext(applicationInfo, 4);
                }
                catch (PackageManager.NameNotFoundException e) {
                    Log.e("Notification", "ApplicationInfo " + applicationInfo + " not found");
                    builderContext = context;
                }
            } else {
                builderContext = context;
            }
            return new Builder(builderContext, n);
        }

        private static final Class<? extends Style> $$robo$$android_app_Notification_Builder$getNotificationStyleClass(String templateClass) {
            Class[] classes;
            for (Class innerClass : classes = new Class[]{BigTextStyle.class, BigPictureStyle.class, InboxStyle.class, MediaStyle.class, DecoratedCustomViewStyle.class, DecoratedMediaCustomViewStyle.class, MessagingStyle.class}) {
                if (!templateClass.equals(innerClass.getName())) continue;
                return innerClass;
            }
            return null;
        }

        @Deprecated
        private final Notification $$robo$$android_app_Notification_Builder$getNotification() {
            return this.build();
        }

        private final Notification $$robo$$android_app_Notification_Builder$build() {
            if (this.mUserExtras != null) {
                this.mN.extras = this.getAllExtras();
            }
            this.mN.creationTime = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
            Notification.addFieldsFromContext(this.mContext, this.mN);
            this.buildUnstyled();
            if (this.mStyle != null) {
                this.mStyle.buildStyled(this.mN);
            }
            if (!(this.mContext.getApplicationInfo().targetSdkVersion >= 24 || this.mStyle != null && this.mStyle.displayCustomViewInline())) {
                if (this.mN.contentView == null) {
                    this.mN.contentView = this.createContentView();
                    this.mN.extras.putInt("android.rebuild.contentViewActionCount", this.mN.contentView.getSequenceNumber());
                }
                if (this.mN.bigContentView == null) {
                    this.mN.bigContentView = this.createBigContentView();
                    if (this.mN.bigContentView != null) {
                        this.mN.extras.putInt("android.rebuild.bigViewActionCount", this.mN.bigContentView.getSequenceNumber());
                    }
                }
                if (this.mN.headsUpContentView == null) {
                    this.mN.headsUpContentView = this.createHeadsUpContentView();
                    if (this.mN.headsUpContentView != null) {
                        this.mN.extras.putInt("android.rebuild.hudViewActionCount", this.mN.headsUpContentView.getSequenceNumber());
                    }
                }
            }
            if ((this.mN.defaults & 4) != 0) {
                this.mN.flags |= 1;
            }
            return this.mN;
        }

        private final Notification $$robo$$android_app_Notification_Builder$buildInto(Notification n) {
            this.build().cloneInto(n, true);
            return n;
        }

        private static final Notification $$robo$$android_app_Notification_Builder$maybeCloneStrippedForDelivery(Notification n) {
            boolean stripHeadsUpContentView;
            String templateClass = n.extras.getString("android.template");
            if (!TextUtils.isEmpty(templateClass) && Builder.getNotificationStyleClass(templateClass) == null) {
                return n;
            }
            boolean stripContentView = n.contentView instanceof BuilderRemoteViews && n.extras.getInt("android.rebuild.contentViewActionCount", -1) == n.contentView.getSequenceNumber();
            boolean stripBigContentView = n.bigContentView instanceof BuilderRemoteViews && n.extras.getInt("android.rebuild.bigViewActionCount", -1) == n.bigContentView.getSequenceNumber();
            boolean bl = stripHeadsUpContentView = n.headsUpContentView instanceof BuilderRemoteViews && n.extras.getInt("android.rebuild.hudViewActionCount", -1) == n.headsUpContentView.getSequenceNumber();
            if (!(stripContentView || stripBigContentView || stripHeadsUpContentView)) {
                return n;
            }
            Object clone = n.clone();
            if (stripContentView) {
                ((Notification)clone).contentView = null;
                ((Notification)clone).extras.remove("android.rebuild.contentViewActionCount");
            }
            if (stripBigContentView) {
                ((Notification)clone).bigContentView = null;
                ((Notification)clone).extras.remove("android.rebuild.bigViewActionCount");
            }
            if (stripHeadsUpContentView) {
                ((Notification)clone).headsUpContentView = null;
                ((Notification)clone).extras.remove("android.rebuild.hudViewActionCount");
            }
            return clone;
        }

        private final int $$robo$$android_app_Notification_Builder$getBaseLayoutResource() {
            return 17367179;
        }

        private final int $$robo$$android_app_Notification_Builder$getBigBaseLayoutResource() {
            return 17367180;
        }

        private final int $$robo$$android_app_Notification_Builder$getBigPictureLayoutResource() {
            return 17367182;
        }

        private final int $$robo$$android_app_Notification_Builder$getBigTextLayoutResource() {
            return 17367183;
        }

        private final int $$robo$$android_app_Notification_Builder$getInboxLayoutResource() {
            return 0x1090090;
        }

        private final int $$robo$$android_app_Notification_Builder$getMessagingLayoutResource() {
            return 17367186;
        }

        private final int $$robo$$android_app_Notification_Builder$getActionLayoutResource() {
            return 17367173;
        }

        private final int $$robo$$android_app_Notification_Builder$getActionTombstoneLayoutResource() {
            return 17367175;
        }

        private void __constructor__(Context context) {
            this.$$robo$$android_app_Notification_Builder$__constructor__(context);
        }

        public Builder(Context context) {
            this(context, null);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_Builder$__constructor__(android.content.Context ), 0, this, context);
        }

        private void __constructor__(Context context, Notification notification) {
            this.$$robo$$android_app_Notification_Builder$__constructor__(context, notification);
        }

        public Builder(Context context, Notification notification) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_Builder$__constructor__(android.content.Context android.app.Notification ), 0, this, context, notification);
        }

        private NotificationColorUtil getColorUtil() {
            return InvokeDynamicSupport.bootstrap("getColorUtil", $$robo$$android_app_Notification_Builder$getColorUtil(), 0, this);
        }

        public Builder setWhen(long l) {
            return InvokeDynamicSupport.bootstrap("setWhen", $$robo$$android_app_Notification_Builder$setWhen(long ), 0, this, l);
        }

        public Builder setShowWhen(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setShowWhen", $$robo$$android_app_Notification_Builder$setShowWhen(boolean ), 0, this, bl);
        }

        public Builder setUsesChronometer(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setUsesChronometer", $$robo$$android_app_Notification_Builder$setUsesChronometer(boolean ), 0, this, bl);
        }

        public Builder setChronometerCountDown(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setChronometerCountDown", $$robo$$android_app_Notification_Builder$setChronometerCountDown(boolean ), 0, this, bl);
        }

        public Builder setSmallIcon(int n) {
            return InvokeDynamicSupport.bootstrap("setSmallIcon", $$robo$$android_app_Notification_Builder$setSmallIcon(int ), 0, this, n);
        }

        public Builder setSmallIcon(int n, int n2) {
            return InvokeDynamicSupport.bootstrap("setSmallIcon", $$robo$$android_app_Notification_Builder$setSmallIcon(int int ), 0, this, n, n2);
        }

        public Builder setSmallIcon(Icon icon) {
            return InvokeDynamicSupport.bootstrap("setSmallIcon", $$robo$$android_app_Notification_Builder$setSmallIcon(android.graphics.drawable.Icon ), 0, this, icon);
        }

        public Builder setContentTitle(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("setContentTitle", $$robo$$android_app_Notification_Builder$setContentTitle(java.lang.CharSequence ), 0, this, charSequence);
        }

        public Builder setContentText(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("setContentText", $$robo$$android_app_Notification_Builder$setContentText(java.lang.CharSequence ), 0, this, charSequence);
        }

        public Builder setSubText(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("setSubText", $$robo$$android_app_Notification_Builder$setSubText(java.lang.CharSequence ), 0, this, charSequence);
        }

        public Builder setRemoteInputHistory(CharSequence[] charSequenceArray) {
            return InvokeDynamicSupport.bootstrap("setRemoteInputHistory", $$robo$$android_app_Notification_Builder$setRemoteInputHistory(java.lang.CharSequence[] ), 0, this, charSequenceArray);
        }

        public Builder setNumber(int n) {
            return InvokeDynamicSupport.bootstrap("setNumber", $$robo$$android_app_Notification_Builder$setNumber(int ), 0, this, n);
        }

        public Builder setContentInfo(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("setContentInfo", $$robo$$android_app_Notification_Builder$setContentInfo(java.lang.CharSequence ), 0, this, charSequence);
        }

        public Builder setProgress(int n, int n2, boolean bl) {
            return InvokeDynamicSupport.bootstrap("setProgress", $$robo$$android_app_Notification_Builder$setProgress(int int boolean ), 0, this, n, n2, bl);
        }

        @Deprecated
        public Builder setContent(RemoteViews remoteViews) {
            return InvokeDynamicSupport.bootstrap("setContent", $$robo$$android_app_Notification_Builder$setContent(android.widget.RemoteViews ), 0, this, remoteViews);
        }

        public Builder setCustomContentView(RemoteViews remoteViews) {
            return InvokeDynamicSupport.bootstrap("setCustomContentView", $$robo$$android_app_Notification_Builder$setCustomContentView(android.widget.RemoteViews ), 0, this, remoteViews);
        }

        public Builder setCustomBigContentView(RemoteViews remoteViews) {
            return InvokeDynamicSupport.bootstrap("setCustomBigContentView", $$robo$$android_app_Notification_Builder$setCustomBigContentView(android.widget.RemoteViews ), 0, this, remoteViews);
        }

        public Builder setCustomHeadsUpContentView(RemoteViews remoteViews) {
            return InvokeDynamicSupport.bootstrap("setCustomHeadsUpContentView", $$robo$$android_app_Notification_Builder$setCustomHeadsUpContentView(android.widget.RemoteViews ), 0, this, remoteViews);
        }

        public Builder setContentIntent(PendingIntent pendingIntent) {
            return InvokeDynamicSupport.bootstrap("setContentIntent", $$robo$$android_app_Notification_Builder$setContentIntent(android.app.PendingIntent ), 0, this, pendingIntent);
        }

        public Builder setDeleteIntent(PendingIntent pendingIntent) {
            return InvokeDynamicSupport.bootstrap("setDeleteIntent", $$robo$$android_app_Notification_Builder$setDeleteIntent(android.app.PendingIntent ), 0, this, pendingIntent);
        }

        public Builder setFullScreenIntent(PendingIntent pendingIntent, boolean bl) {
            return InvokeDynamicSupport.bootstrap("setFullScreenIntent", $$robo$$android_app_Notification_Builder$setFullScreenIntent(android.app.PendingIntent boolean ), 0, this, pendingIntent, bl);
        }

        public Builder setTicker(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("setTicker", $$robo$$android_app_Notification_Builder$setTicker(java.lang.CharSequence ), 0, this, charSequence);
        }

        @Deprecated
        public Builder setTicker(CharSequence charSequence, RemoteViews remoteViews) {
            return InvokeDynamicSupport.bootstrap("setTicker", $$robo$$android_app_Notification_Builder$setTicker(java.lang.CharSequence android.widget.RemoteViews ), 0, this, charSequence, remoteViews);
        }

        public Builder setLargeIcon(Bitmap bitmap) {
            return InvokeDynamicSupport.bootstrap("setLargeIcon", $$robo$$android_app_Notification_Builder$setLargeIcon(android.graphics.Bitmap ), 0, this, bitmap);
        }

        public Builder setLargeIcon(Icon icon) {
            return InvokeDynamicSupport.bootstrap("setLargeIcon", $$robo$$android_app_Notification_Builder$setLargeIcon(android.graphics.drawable.Icon ), 0, this, icon);
        }

        public Builder setSound(Uri uri) {
            return InvokeDynamicSupport.bootstrap("setSound", $$robo$$android_app_Notification_Builder$setSound(android.net.Uri ), 0, this, uri);
        }

        @Deprecated
        public Builder setSound(Uri uri, int n) {
            return InvokeDynamicSupport.bootstrap("setSound", $$robo$$android_app_Notification_Builder$setSound(android.net.Uri int ), 0, this, uri, n);
        }

        public Builder setSound(Uri uri, AudioAttributes audioAttributes) {
            return InvokeDynamicSupport.bootstrap("setSound", $$robo$$android_app_Notification_Builder$setSound(android.net.Uri android.media.AudioAttributes ), 0, this, uri, audioAttributes);
        }

        public Builder setVibrate(long[] lArray) {
            return InvokeDynamicSupport.bootstrap("setVibrate", $$robo$$android_app_Notification_Builder$setVibrate(long[] ), 0, this, lArray);
        }

        public Builder setLights(int n, int n2, int n3) {
            return InvokeDynamicSupport.bootstrap("setLights", $$robo$$android_app_Notification_Builder$setLights(int int int ), 0, this, n, n2, n3);
        }

        public Builder setOngoing(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setOngoing", $$robo$$android_app_Notification_Builder$setOngoing(boolean ), 0, this, bl);
        }

        public Builder setOnlyAlertOnce(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setOnlyAlertOnce", $$robo$$android_app_Notification_Builder$setOnlyAlertOnce(boolean ), 0, this, bl);
        }

        public Builder setAutoCancel(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setAutoCancel", $$robo$$android_app_Notification_Builder$setAutoCancel(boolean ), 0, this, bl);
        }

        public Builder setLocalOnly(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setLocalOnly", $$robo$$android_app_Notification_Builder$setLocalOnly(boolean ), 0, this, bl);
        }

        public Builder setDefaults(int n) {
            return InvokeDynamicSupport.bootstrap("setDefaults", $$robo$$android_app_Notification_Builder$setDefaults(int ), 0, this, n);
        }

        public Builder setPriority(int n) {
            return InvokeDynamicSupport.bootstrap("setPriority", $$robo$$android_app_Notification_Builder$setPriority(int ), 0, this, n);
        }

        public Builder setCategory(String string2) {
            return InvokeDynamicSupport.bootstrap("setCategory", $$robo$$android_app_Notification_Builder$setCategory(java.lang.String ), 0, this, string2);
        }

        public Builder addPerson(String string2) {
            return InvokeDynamicSupport.bootstrap("addPerson", $$robo$$android_app_Notification_Builder$addPerson(java.lang.String ), 0, this, string2);
        }

        public Builder setGroup(String string2) {
            return InvokeDynamicSupport.bootstrap("setGroup", $$robo$$android_app_Notification_Builder$setGroup(java.lang.String ), 0, this, string2);
        }

        public Builder setGroupSummary(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setGroupSummary", $$robo$$android_app_Notification_Builder$setGroupSummary(boolean ), 0, this, bl);
        }

        public Builder setSortKey(String string2) {
            return InvokeDynamicSupport.bootstrap("setSortKey", $$robo$$android_app_Notification_Builder$setSortKey(java.lang.String ), 0, this, string2);
        }

        public Builder addExtras(Bundle bundle) {
            return InvokeDynamicSupport.bootstrap("addExtras", $$robo$$android_app_Notification_Builder$addExtras(android.os.Bundle ), 0, this, bundle);
        }

        public Builder setExtras(Bundle bundle) {
            return InvokeDynamicSupport.bootstrap("setExtras", $$robo$$android_app_Notification_Builder$setExtras(android.os.Bundle ), 0, this, bundle);
        }

        public Bundle getExtras() {
            return InvokeDynamicSupport.bootstrap("getExtras", $$robo$$android_app_Notification_Builder$getExtras(), 0, this);
        }

        private Bundle getAllExtras() {
            return InvokeDynamicSupport.bootstrap("getAllExtras", $$robo$$android_app_Notification_Builder$getAllExtras(), 0, this);
        }

        @Deprecated
        public Builder addAction(int n, CharSequence charSequence, PendingIntent pendingIntent) {
            return InvokeDynamicSupport.bootstrap("addAction", $$robo$$android_app_Notification_Builder$addAction(int java.lang.CharSequence android.app.PendingIntent ), 0, this, n, charSequence, pendingIntent);
        }

        public Builder addAction(Action action) {
            return InvokeDynamicSupport.bootstrap("addAction", $$robo$$android_app_Notification_Builder$addAction(android.app.Notification$Action ), 0, this, action);
        }

        public Builder setActions(Action ... actionArray) {
            return InvokeDynamicSupport.bootstrap("setActions", $$robo$$android_app_Notification_Builder$setActions(android.app.Notification$Action[] ), 0, this, actionArray);
        }

        public Builder setStyle(Style style2) {
            return InvokeDynamicSupport.bootstrap("setStyle", $$robo$$android_app_Notification_Builder$setStyle(android.app.Notification$Style ), 0, this, style2);
        }

        public Builder setVisibility(int n) {
            return InvokeDynamicSupport.bootstrap("setVisibility", $$robo$$android_app_Notification_Builder$setVisibility(int ), 0, this, n);
        }

        public Builder setPublicVersion(Notification notification) {
            return InvokeDynamicSupport.bootstrap("setPublicVersion", $$robo$$android_app_Notification_Builder$setPublicVersion(android.app.Notification ), 0, this, notification);
        }

        public Builder extend(Extender extender) {
            return InvokeDynamicSupport.bootstrap("extend", $$robo$$android_app_Notification_Builder$extend(android.app.Notification$Extender ), 0, this, extender);
        }

        public Builder setFlag(int n, boolean bl) {
            return InvokeDynamicSupport.bootstrap("setFlag", $$robo$$android_app_Notification_Builder$setFlag(int boolean ), 0, this, n, bl);
        }

        public Builder setColor(int n) {
            return InvokeDynamicSupport.bootstrap("setColor", $$robo$$android_app_Notification_Builder$setColor(int ), 0, this, n);
        }

        private Drawable getProfileBadgeDrawable() {
            return InvokeDynamicSupport.bootstrap("getProfileBadgeDrawable", $$robo$$android_app_Notification_Builder$getProfileBadgeDrawable(), 0, this);
        }

        private Bitmap getProfileBadge() {
            return InvokeDynamicSupport.bootstrap("getProfileBadge", $$robo$$android_app_Notification_Builder$getProfileBadge(), 0, this);
        }

        private void bindProfileBadge(RemoteViews remoteViews) {
            InvokeDynamicSupport.bootstrap("bindProfileBadge", $$robo$$android_app_Notification_Builder$bindProfileBadge(android.widget.RemoteViews ), 0, this, remoteViews);
        }

        private void resetStandardTemplate(RemoteViews remoteViews) {
            InvokeDynamicSupport.bootstrap("resetStandardTemplate", $$robo$$android_app_Notification_Builder$resetStandardTemplate(android.widget.RemoteViews ), 0, this, remoteViews);
        }

        private void resetNotificationHeader(RemoteViews remoteViews) {
            InvokeDynamicSupport.bootstrap("resetNotificationHeader", $$robo$$android_app_Notification_Builder$resetNotificationHeader(android.widget.RemoteViews ), 0, this, remoteViews);
        }

        private void resetContentMargins(RemoteViews remoteViews) {
            InvokeDynamicSupport.bootstrap("resetContentMargins", $$robo$$android_app_Notification_Builder$resetContentMargins(android.widget.RemoteViews ), 0, this, remoteViews);
        }

        private RemoteViews applyStandardTemplate(int n) {
            return InvokeDynamicSupport.bootstrap("applyStandardTemplate", $$robo$$android_app_Notification_Builder$applyStandardTemplate(int ), 0, this, n);
        }

        private RemoteViews applyStandardTemplate(int n, boolean bl) {
            return InvokeDynamicSupport.bootstrap("applyStandardTemplate", $$robo$$android_app_Notification_Builder$applyStandardTemplate(int boolean ), 0, this, n, bl);
        }

        private RemoteViews applyStandardTemplate(int n, boolean bl, CharSequence charSequence, CharSequence charSequence2) {
            return InvokeDynamicSupport.bootstrap("applyStandardTemplate", $$robo$$android_app_Notification_Builder$applyStandardTemplate(int boolean java.lang.CharSequence java.lang.CharSequence ), 0, this, n, bl, charSequence, charSequence2);
        }

        void setContentMinHeight(RemoteViews remoteViews, boolean bl) {
            InvokeDynamicSupport.bootstrap("setContentMinHeight", $$robo$$android_app_Notification_Builder$setContentMinHeight(android.widget.RemoteViews boolean ), 0, this, remoteViews, bl);
        }

        private boolean handleProgressBar(boolean bl, RemoteViews remoteViews, Bundle bundle) {
            return (boolean)InvokeDynamicSupport.bootstrap("handleProgressBar", $$robo$$android_app_Notification_Builder$handleProgressBar(boolean android.widget.RemoteViews android.os.Bundle ), 0, this, bl, remoteViews, bundle);
        }

        private void bindLargeIcon(RemoteViews remoteViews) {
            InvokeDynamicSupport.bootstrap("bindLargeIcon", $$robo$$android_app_Notification_Builder$bindLargeIcon(android.widget.RemoteViews ), 0, this, remoteViews);
        }

        private void bindNotificationHeader(RemoteViews remoteViews) {
            InvokeDynamicSupport.bootstrap("bindNotificationHeader", $$robo$$android_app_Notification_Builder$bindNotificationHeader(android.widget.RemoteViews ), 0, this, remoteViews);
        }

        private void bindExpandButton(RemoteViews remoteViews) {
            InvokeDynamicSupport.bootstrap("bindExpandButton", $$robo$$android_app_Notification_Builder$bindExpandButton(android.widget.RemoteViews ), 0, this, remoteViews);
        }

        private void bindHeaderChronometerAndTime(RemoteViews remoteViews) {
            InvokeDynamicSupport.bootstrap("bindHeaderChronometerAndTime", $$robo$$android_app_Notification_Builder$bindHeaderChronometerAndTime(android.widget.RemoteViews ), 0, this, remoteViews);
        }

        private void bindHeaderText(RemoteViews remoteViews) {
            InvokeDynamicSupport.bootstrap("bindHeaderText", $$robo$$android_app_Notification_Builder$bindHeaderText(android.widget.RemoteViews ), 0, this, remoteViews);
        }

        public String loadHeaderAppName() {
            return InvokeDynamicSupport.bootstrap("loadHeaderAppName", $$robo$$android_app_Notification_Builder$loadHeaderAppName(), 0, this);
        }

        private void bindHeaderAppName(RemoteViews remoteViews) {
            InvokeDynamicSupport.bootstrap("bindHeaderAppName", $$robo$$android_app_Notification_Builder$bindHeaderAppName(android.widget.RemoteViews ), 0, this, remoteViews);
        }

        private void bindSmallIcon(RemoteViews remoteViews) {
            InvokeDynamicSupport.bootstrap("bindSmallIcon", $$robo$$android_app_Notification_Builder$bindSmallIcon(android.widget.RemoteViews ), 0, this, remoteViews);
        }

        private boolean showsTimeOrChronometer() {
            return (boolean)InvokeDynamicSupport.bootstrap("showsTimeOrChronometer", $$robo$$android_app_Notification_Builder$showsTimeOrChronometer(), 0, this);
        }

        private void resetStandardTemplateWithActions(RemoteViews remoteViews) {
            InvokeDynamicSupport.bootstrap("resetStandardTemplateWithActions", $$robo$$android_app_Notification_Builder$resetStandardTemplateWithActions(android.widget.RemoteViews ), 0, this, remoteViews);
        }

        private RemoteViews applyStandardTemplateWithActions(int n) {
            return InvokeDynamicSupport.bootstrap("applyStandardTemplateWithActions", $$robo$$android_app_Notification_Builder$applyStandardTemplateWithActions(int ), 0, this, n);
        }

        private RemoteViews applyStandardTemplateWithActions(int n, boolean bl, CharSequence charSequence, CharSequence charSequence2) {
            return InvokeDynamicSupport.bootstrap("applyStandardTemplateWithActions", $$robo$$android_app_Notification_Builder$applyStandardTemplateWithActions(int boolean java.lang.CharSequence java.lang.CharSequence ), 0, this, n, bl, charSequence, charSequence2);
        }

        private boolean hasValidRemoteInput(Action action) {
            return (boolean)InvokeDynamicSupport.bootstrap("hasValidRemoteInput", $$robo$$android_app_Notification_Builder$hasValidRemoteInput(android.app.Notification$Action ), 0, this, action);
        }

        public RemoteViews createContentView() {
            return InvokeDynamicSupport.bootstrap("createContentView", $$robo$$android_app_Notification_Builder$createContentView(), 0, this);
        }

        public RemoteViews createBigContentView() {
            return InvokeDynamicSupport.bootstrap("createBigContentView", $$robo$$android_app_Notification_Builder$createBigContentView(), 0, this);
        }

        public RemoteViews makeNotificationHeader() {
            return InvokeDynamicSupport.bootstrap("makeNotificationHeader", $$robo$$android_app_Notification_Builder$makeNotificationHeader(), 0, this);
        }

        private void hideLine1Text(RemoteViews remoteViews) {
            InvokeDynamicSupport.bootstrap("hideLine1Text", $$robo$$android_app_Notification_Builder$hideLine1Text(android.widget.RemoteViews ), 0, this, remoteViews);
        }

        private void adaptNotificationHeaderForBigContentView(RemoteViews remoteViews) {
            InvokeDynamicSupport.bootstrap("adaptNotificationHeaderForBigContentView", $$robo$$android_app_Notification_Builder$adaptNotificationHeaderForBigContentView(android.widget.RemoteViews ), 0, this, remoteViews);
        }

        public RemoteViews createHeadsUpContentView() {
            return InvokeDynamicSupport.bootstrap("createHeadsUpContentView", $$robo$$android_app_Notification_Builder$createHeadsUpContentView(), 0, this);
        }

        public RemoteViews makePublicContentView() {
            return InvokeDynamicSupport.bootstrap("makePublicContentView", $$robo$$android_app_Notification_Builder$makePublicContentView(), 0, this);
        }

        private RemoteViews generateActionButton(Action action) {
            return InvokeDynamicSupport.bootstrap("generateActionButton", $$robo$$android_app_Notification_Builder$generateActionButton(android.app.Notification$Action ), 0, this, action);
        }

        private boolean isLegacy() {
            return (boolean)InvokeDynamicSupport.bootstrap("isLegacy", $$robo$$android_app_Notification_Builder$isLegacy(), 0, this);
        }

        private CharSequence processLegacyText(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("processLegacyText", $$robo$$android_app_Notification_Builder$processLegacyText(java.lang.CharSequence ), 0, this, charSequence);
        }

        private void processSmallIconColor(Icon icon, RemoteViews remoteViews) {
            InvokeDynamicSupport.bootstrap("processSmallIconColor", $$robo$$android_app_Notification_Builder$processSmallIconColor(android.graphics.drawable.Icon android.widget.RemoteViews ), 0, this, icon, remoteViews);
        }

        private void processLargeLegacyIcon(Icon icon, RemoteViews remoteViews) {
            InvokeDynamicSupport.bootstrap("processLargeLegacyIcon", $$robo$$android_app_Notification_Builder$processLargeLegacyIcon(android.graphics.drawable.Icon android.widget.RemoteViews ), 0, this, icon, remoteViews);
        }

        private void sanitizeColor() {
            InvokeDynamicSupport.bootstrap("sanitizeColor", $$robo$$android_app_Notification_Builder$sanitizeColor(), 0, this);
        }

        int resolveContrastColor() {
            return (int)InvokeDynamicSupport.bootstrap("resolveContrastColor", $$robo$$android_app_Notification_Builder$resolveContrastColor(), 0, this);
        }

        public Notification buildUnstyled() {
            return InvokeDynamicSupport.bootstrap("buildUnstyled", $$robo$$android_app_Notification_Builder$buildUnstyled(), 0, this);
        }

        public static Builder recoverBuilder(Context context, Notification notification) {
            return InvokeDynamicSupport.bootstrapStatic("recoverBuilder", $$robo$$android_app_Notification_Builder$recoverBuilder(android.content.Context android.app.Notification ), 0, (Context)context, (Notification)notification);
        }

        private static Class<? extends Style> getNotificationStyleClass(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("getNotificationStyleClass", $$robo$$android_app_Notification_Builder$getNotificationStyleClass(java.lang.String ), 0, (String)string2);
        }

        @Deprecated
        public Notification getNotification() {
            return InvokeDynamicSupport.bootstrap("getNotification", $$robo$$android_app_Notification_Builder$getNotification(), 0, this);
        }

        public Notification build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_app_Notification_Builder$build(), 0, this);
        }

        public Notification buildInto(Notification notification) {
            return InvokeDynamicSupport.bootstrap("buildInto", $$robo$$android_app_Notification_Builder$buildInto(android.app.Notification ), 0, this, notification);
        }

        public static Notification maybeCloneStrippedForDelivery(Notification notification) {
            return InvokeDynamicSupport.bootstrapStatic("maybeCloneStrippedForDelivery", $$robo$$android_app_Notification_Builder$maybeCloneStrippedForDelivery(android.app.Notification ), 0, (Notification)notification);
        }

        private int getBaseLayoutResource() {
            return (int)InvokeDynamicSupport.bootstrap("getBaseLayoutResource", $$robo$$android_app_Notification_Builder$getBaseLayoutResource(), 0, this);
        }

        private int getBigBaseLayoutResource() {
            return (int)InvokeDynamicSupport.bootstrap("getBigBaseLayoutResource", $$robo$$android_app_Notification_Builder$getBigBaseLayoutResource(), 0, this);
        }

        private int getBigPictureLayoutResource() {
            return (int)InvokeDynamicSupport.bootstrap("getBigPictureLayoutResource", $$robo$$android_app_Notification_Builder$getBigPictureLayoutResource(), 0, this);
        }

        private int getBigTextLayoutResource() {
            return (int)InvokeDynamicSupport.bootstrap("getBigTextLayoutResource", $$robo$$android_app_Notification_Builder$getBigTextLayoutResource(), 0, this);
        }

        private int getInboxLayoutResource() {
            return (int)InvokeDynamicSupport.bootstrap("getInboxLayoutResource", $$robo$$android_app_Notification_Builder$getInboxLayoutResource(), 0, this);
        }

        private int getMessagingLayoutResource() {
            return (int)InvokeDynamicSupport.bootstrap("getMessagingLayoutResource", $$robo$$android_app_Notification_Builder$getMessagingLayoutResource(), 0, this);
        }

        private int getActionLayoutResource() {
            return (int)InvokeDynamicSupport.bootstrap("getActionLayoutResource", $$robo$$android_app_Notification_Builder$getActionLayoutResource(), 0, this);
        }

        private int getActionTombstoneLayoutResource() {
            return (int)InvokeDynamicSupport.bootstrap("getActionTombstoneLayoutResource", $$robo$$android_app_Notification_Builder$getActionTombstoneLayoutResource(), 0, this);
        }

        public /* synthetic */ Builder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Action
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Bundle mExtras;
        private Icon mIcon;
        private RemoteInput[] mRemoteInputs;
        private boolean mAllowGeneratedReplies;
        @Deprecated
        public int icon;
        public CharSequence title;
        public PendingIntent actionIntent;
        public static Parcelable.Creator<Action> CREATOR;

        private void $$robo$$android_app_Notification_Action$__constructor__(Parcel in) {
            this.mAllowGeneratedReplies = false;
            if (in.readInt() != 0) {
                this.mIcon = Icon.CREATOR.createFromParcel(in);
                if (this.mIcon.getType() == 2) {
                    this.icon = this.mIcon.getResId();
                }
            }
            this.title = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            if (in.readInt() == 1) {
                this.actionIntent = PendingIntent.CREATOR.createFromParcel(in);
            }
            this.mExtras = Bundle.setDefusable(in.readBundle(), true);
            this.mRemoteInputs = in.createTypedArray(RemoteInput.CREATOR);
            this.mAllowGeneratedReplies = in.readInt() == 1;
        }

        @Deprecated
        private void $$robo$$android_app_Notification_Action$__constructor__(int icon, CharSequence title, PendingIntent intent) {
        }

        private void $$robo$$android_app_Notification_Action$__constructor__(Icon icon, CharSequence title, PendingIntent intent, Bundle extras, RemoteInput[] remoteInputs, boolean allowGeneratedReplies) {
            this.mAllowGeneratedReplies = false;
            this.mIcon = icon;
            if (icon != null && icon.getType() == 2) {
                this.icon = icon.getResId();
            }
            this.title = title;
            this.actionIntent = intent;
            this.mExtras = extras != null ? extras : new Bundle();
            this.mRemoteInputs = remoteInputs;
            this.mAllowGeneratedReplies = allowGeneratedReplies;
        }

        private final Icon $$robo$$android_app_Notification_Action$getIcon() {
            if (this.mIcon == null && this.icon != 0) {
                this.mIcon = Icon.createWithResource("", this.icon);
            }
            return this.mIcon;
        }

        private final Bundle $$robo$$android_app_Notification_Action$getExtras() {
            return this.mExtras;
        }

        private final boolean $$robo$$android_app_Notification_Action$getAllowGeneratedReplies() {
            return this.mAllowGeneratedReplies;
        }

        private final RemoteInput[] $$robo$$android_app_Notification_Action$getRemoteInputs() {
            return this.mRemoteInputs;
        }

        private final Action $$robo$$android_app_Notification_Action$clone() {
            return new Action(this.getIcon(), this.title, this.actionIntent, new Bundle(this.mExtras), this.getRemoteInputs(), this.getAllowGeneratedReplies());
        }

        private final int $$robo$$android_app_Notification_Action$describeContents() {
            return 0;
        }

        private final void $$robo$$android_app_Notification_Action$writeToParcel(Parcel out, int flags) {
            Icon ic = this.getIcon();
            if (ic != null) {
                out.writeInt(1);
                ic.writeToParcel(out, 0);
            } else {
                out.writeInt(0);
            }
            TextUtils.writeToParcel(this.title, out, flags);
            if (this.actionIntent != null) {
                out.writeInt(1);
                this.actionIntent.writeToParcel(out, flags);
            } else {
                out.writeInt(0);
            }
            out.writeBundle(this.mExtras);
            out.writeTypedArray(this.mRemoteInputs, flags);
            out.writeInt(this.mAllowGeneratedReplies ? 1 : 0);
        }

        private /* synthetic */ void $$robo$$android_app_Notification_Action$__constructor__(Icon x0, CharSequence x1, PendingIntent x2, Bundle x3, RemoteInput[] x4, boolean x5, 1 x6) {
        }

        private /* synthetic */ void $$robo$$android_app_Notification_Action$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<Action>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_app_Notification_Action_1$__constructor__() {
                }

                private final Action $$robo$$android_app_Notification_Action_1$createFromParcel(Parcel in) {
                    return new Action(in);
                }

                private final Action[] $$robo$$android_app_Notification_Action_1$newArray(int size) {
                    return new Action[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_app_Notification_Action_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_Action_1$__constructor__(), 0, this);
                }

                @Override
                public Action createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_app_Notification_Action_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public Action[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_app_Notification_Action_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_app_Notification_Action$__constructor__(parcel);
        }

        private Action(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_Action$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        private void __constructor__(int n, CharSequence charSequence, PendingIntent pendingIntent) {
            this.$$robo$$android_app_Notification_Action$__constructor__(n, charSequence, pendingIntent);
        }

        public Action(int n, CharSequence charSequence, PendingIntent pendingIntent) {
            this(Icon.createWithResource("", n), charSequence, pendingIntent, new Bundle(), null, false);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_Action$__constructor__(int java.lang.CharSequence android.app.PendingIntent ), 0, this, n, charSequence, pendingIntent);
        }

        private void __constructor__(Icon icon, CharSequence charSequence, PendingIntent pendingIntent, Bundle bundle, RemoteInput[] remoteInputArray, boolean bl) {
            this.$$robo$$android_app_Notification_Action$__constructor__(icon, charSequence, pendingIntent, bundle, remoteInputArray, bl);
        }

        private Action(Icon icon, CharSequence charSequence, PendingIntent pendingIntent, Bundle bundle, RemoteInput[] remoteInputArray, boolean bl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_Action$__constructor__(android.graphics.drawable.Icon java.lang.CharSequence android.app.PendingIntent android.os.Bundle android.app.RemoteInput[] boolean ), 0, this, icon, charSequence, pendingIntent, bundle, remoteInputArray, bl);
        }

        public Icon getIcon() {
            return InvokeDynamicSupport.bootstrap("getIcon", $$robo$$android_app_Notification_Action$getIcon(), 0, this);
        }

        public Bundle getExtras() {
            return InvokeDynamicSupport.bootstrap("getExtras", $$robo$$android_app_Notification_Action$getExtras(), 0, this);
        }

        public boolean getAllowGeneratedReplies() {
            return (boolean)InvokeDynamicSupport.bootstrap("getAllowGeneratedReplies", $$robo$$android_app_Notification_Action$getAllowGeneratedReplies(), 0, this);
        }

        public RemoteInput[] getRemoteInputs() {
            return InvokeDynamicSupport.bootstrap("getRemoteInputs", $$robo$$android_app_Notification_Action$getRemoteInputs(), 0, this);
        }

        public Action clone() {
            return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_app_Notification_Action$clone(), 0, this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_app_Notification_Action$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_app_Notification_Action$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        private /* synthetic */ void __constructor__(Icon icon, CharSequence charSequence, PendingIntent pendingIntent, Bundle bundle, RemoteInput[] remoteInputArray, boolean bl, 1 var7_7) {
            this.$$robo$$android_app_Notification_Action$__constructor__(icon, charSequence, pendingIntent, bundle, remoteInputArray, bl, var7_7);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_app_Notification_Action$__constructor__(parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(Action.class);
        }

        public /* synthetic */ Action() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Action)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
        public static final class WearableExtender
        implements Extender,
        ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            private static String EXTRA_WEARABLE_EXTENSIONS = "android.wearable.EXTENSIONS";
            private static String KEY_FLAGS = "flags";
            private static String KEY_IN_PROGRESS_LABEL = "inProgressLabel";
            private static String KEY_CONFIRM_LABEL = "confirmLabel";
            private static String KEY_CANCEL_LABEL = "cancelLabel";
            private static int FLAG_AVAILABLE_OFFLINE = 1;
            private static int FLAG_HINT_LAUNCHES_ACTIVITY = 2;
            private static int DEFAULT_FLAGS = 1;
            private int mFlags;
            private CharSequence mInProgressLabel;
            private CharSequence mConfirmLabel;
            private CharSequence mCancelLabel;

            private void $$robo$$android_app_Notification_Action_WearableExtender$__constructor__() {
                this.mFlags = 1;
            }

            private void $$robo$$android_app_Notification_Action_WearableExtender$__constructor__(Action action) {
                this.mFlags = 1;
                Bundle wearableBundle = action.getExtras().getBundle("android.wearable.EXTENSIONS");
                if (wearableBundle != null) {
                    this.mFlags = wearableBundle.getInt("flags", 1);
                    this.mInProgressLabel = wearableBundle.getCharSequence("inProgressLabel");
                    this.mConfirmLabel = wearableBundle.getCharSequence("confirmLabel");
                    this.mCancelLabel = wearableBundle.getCharSequence("cancelLabel");
                }
            }

            private final Builder $$robo$$android_app_Notification_Action_WearableExtender$extend(Builder builder) {
                Bundle wearableBundle = new Bundle();
                if (this.mFlags != 1) {
                    wearableBundle.putInt("flags", this.mFlags);
                }
                if (this.mInProgressLabel != null) {
                    wearableBundle.putCharSequence("inProgressLabel", this.mInProgressLabel);
                }
                if (this.mConfirmLabel != null) {
                    wearableBundle.putCharSequence("confirmLabel", this.mConfirmLabel);
                }
                if (this.mCancelLabel != null) {
                    wearableBundle.putCharSequence("cancelLabel", this.mCancelLabel);
                }
                builder.getExtras().putBundle("android.wearable.EXTENSIONS", wearableBundle);
                return builder;
            }

            private final WearableExtender $$robo$$android_app_Notification_Action_WearableExtender$clone() {
                WearableExtender that = new WearableExtender();
                that.mFlags = this.mFlags;
                that.mInProgressLabel = this.mInProgressLabel;
                that.mConfirmLabel = this.mConfirmLabel;
                that.mCancelLabel = this.mCancelLabel;
                return that;
            }

            private final WearableExtender $$robo$$android_app_Notification_Action_WearableExtender$setAvailableOffline(boolean availableOffline) {
                this.setFlag(1, availableOffline);
                return this;
            }

            private final boolean $$robo$$android_app_Notification_Action_WearableExtender$isAvailableOffline() {
                return (this.mFlags & 1) != 0;
            }

            private final void $$robo$$android_app_Notification_Action_WearableExtender$setFlag(int mask, boolean value) {
                this.mFlags = value ? (this.mFlags |= mask) : (this.mFlags &= ~mask);
            }

            private final WearableExtender $$robo$$android_app_Notification_Action_WearableExtender$setInProgressLabel(CharSequence label) {
                this.mInProgressLabel = label;
                return this;
            }

            private final CharSequence $$robo$$android_app_Notification_Action_WearableExtender$getInProgressLabel() {
                return this.mInProgressLabel;
            }

            private final WearableExtender $$robo$$android_app_Notification_Action_WearableExtender$setConfirmLabel(CharSequence label) {
                this.mConfirmLabel = label;
                return this;
            }

            private final CharSequence $$robo$$android_app_Notification_Action_WearableExtender$getConfirmLabel() {
                return this.mConfirmLabel;
            }

            private final WearableExtender $$robo$$android_app_Notification_Action_WearableExtender$setCancelLabel(CharSequence label) {
                this.mCancelLabel = label;
                return this;
            }

            private final CharSequence $$robo$$android_app_Notification_Action_WearableExtender$getCancelLabel() {
                return this.mCancelLabel;
            }

            private final WearableExtender $$robo$$android_app_Notification_Action_WearableExtender$setHintLaunchesActivity(boolean hintLaunchesActivity) {
                this.setFlag(2, hintLaunchesActivity);
                return this;
            }

            private final boolean $$robo$$android_app_Notification_Action_WearableExtender$getHintLaunchesActivity() {
                return (this.mFlags & 2) != 0;
            }

            private void __constructor__() {
                this.$$robo$$android_app_Notification_Action_WearableExtender$__constructor__();
            }

            public WearableExtender() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_Action_WearableExtender$__constructor__(), 0, this);
            }

            private void __constructor__(Action action) {
                this.$$robo$$android_app_Notification_Action_WearableExtender$__constructor__(action);
            }

            public WearableExtender(Action action) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_Action_WearableExtender$__constructor__(android.app.Notification$Action ), 0, this, action);
            }

            @Override
            public Builder extend(Builder builder) {
                return InvokeDynamicSupport.bootstrap("extend", $$robo$$android_app_Notification_Action_WearableExtender$extend(android.app.Notification$Action$Builder ), 0, this, builder);
            }

            public WearableExtender clone() {
                return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_app_Notification_Action_WearableExtender$clone(), 0, this);
            }

            public WearableExtender setAvailableOffline(boolean bl) {
                return InvokeDynamicSupport.bootstrap("setAvailableOffline", $$robo$$android_app_Notification_Action_WearableExtender$setAvailableOffline(boolean ), 0, this, bl);
            }

            public boolean isAvailableOffline() {
                return (boolean)InvokeDynamicSupport.bootstrap("isAvailableOffline", $$robo$$android_app_Notification_Action_WearableExtender$isAvailableOffline(), 0, this);
            }

            private void setFlag(int n, boolean bl) {
                InvokeDynamicSupport.bootstrap("setFlag", $$robo$$android_app_Notification_Action_WearableExtender$setFlag(int boolean ), 0, this, n, bl);
            }

            public WearableExtender setInProgressLabel(CharSequence charSequence) {
                return InvokeDynamicSupport.bootstrap("setInProgressLabel", $$robo$$android_app_Notification_Action_WearableExtender$setInProgressLabel(java.lang.CharSequence ), 0, this, charSequence);
            }

            public CharSequence getInProgressLabel() {
                return InvokeDynamicSupport.bootstrap("getInProgressLabel", $$robo$$android_app_Notification_Action_WearableExtender$getInProgressLabel(), 0, this);
            }

            public WearableExtender setConfirmLabel(CharSequence charSequence) {
                return InvokeDynamicSupport.bootstrap("setConfirmLabel", $$robo$$android_app_Notification_Action_WearableExtender$setConfirmLabel(java.lang.CharSequence ), 0, this, charSequence);
            }

            public CharSequence getConfirmLabel() {
                return InvokeDynamicSupport.bootstrap("getConfirmLabel", $$robo$$android_app_Notification_Action_WearableExtender$getConfirmLabel(), 0, this);
            }

            public WearableExtender setCancelLabel(CharSequence charSequence) {
                return InvokeDynamicSupport.bootstrap("setCancelLabel", $$robo$$android_app_Notification_Action_WearableExtender$setCancelLabel(java.lang.CharSequence ), 0, this, charSequence);
            }

            public CharSequence getCancelLabel() {
                return InvokeDynamicSupport.bootstrap("getCancelLabel", $$robo$$android_app_Notification_Action_WearableExtender$getCancelLabel(), 0, this);
            }

            public WearableExtender setHintLaunchesActivity(boolean bl) {
                return InvokeDynamicSupport.bootstrap("setHintLaunchesActivity", $$robo$$android_app_Notification_Action_WearableExtender$setHintLaunchesActivity(boolean ), 0, this, bl);
            }

            public boolean getHintLaunchesActivity() {
                return (boolean)InvokeDynamicSupport.bootstrap("getHintLaunchesActivity", $$robo$$android_app_Notification_Action_WearableExtender$getHintLaunchesActivity(), 0, this);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WearableExtender)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        public static interface Extender
        extends InstrumentedInterface {
            public Builder extend(Builder var1);
        }

        @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
        public static final class Builder
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            private Icon mIcon;
            private CharSequence mTitle;
            private PendingIntent mIntent;
            private boolean mAllowGeneratedReplies;
            private Bundle mExtras;
            private ArrayList<RemoteInput> mRemoteInputs;

            @Deprecated
            private void $$robo$$android_app_Notification_Action_Builder$__constructor__(int icon, CharSequence title, PendingIntent intent) {
            }

            private void $$robo$$android_app_Notification_Action_Builder$__constructor__(Icon icon, CharSequence title, PendingIntent intent) {
            }

            private void $$robo$$android_app_Notification_Action_Builder$__constructor__(Action action) {
            }

            private void $$robo$$android_app_Notification_Action_Builder$__constructor__(Icon icon, CharSequence title, PendingIntent intent, Bundle extras, RemoteInput[] remoteInputs) {
                this.mIcon = icon;
                this.mTitle = title;
                this.mIntent = intent;
                this.mExtras = extras;
                if (remoteInputs != null) {
                    this.mRemoteInputs = new ArrayList(remoteInputs.length);
                    Collections.addAll(this.mRemoteInputs, remoteInputs);
                }
            }

            private final Builder $$robo$$android_app_Notification_Action_Builder$addExtras(Bundle extras) {
                if (extras != null) {
                    this.mExtras.putAll(extras);
                }
                return this;
            }

            private final Bundle $$robo$$android_app_Notification_Action_Builder$getExtras() {
                return this.mExtras;
            }

            private final Builder $$robo$$android_app_Notification_Action_Builder$addRemoteInput(RemoteInput remoteInput) {
                if (this.mRemoteInputs == null) {
                    this.mRemoteInputs = new ArrayList();
                }
                this.mRemoteInputs.add(remoteInput);
                return this;
            }

            private final Builder $$robo$$android_app_Notification_Action_Builder$setAllowGeneratedReplies(boolean allowGeneratedReplies) {
                this.mAllowGeneratedReplies = allowGeneratedReplies;
                return this;
            }

            private final Builder $$robo$$android_app_Notification_Action_Builder$extend(Extender extender) {
                extender.extend(this);
                return this;
            }

            private final Action $$robo$$android_app_Notification_Action_Builder$build() {
                RemoteInput[] remoteInputs = this.mRemoteInputs != null ? this.mRemoteInputs.toArray(new RemoteInput[this.mRemoteInputs.size()]) : null;
                return new Action(this.mIcon, this.mTitle, this.mIntent, this.mExtras, remoteInputs, this.mAllowGeneratedReplies);
            }

            private void __constructor__(int n, CharSequence charSequence, PendingIntent pendingIntent) {
                this.$$robo$$android_app_Notification_Action_Builder$__constructor__(n, charSequence, pendingIntent);
            }

            public Builder(int n, CharSequence charSequence, PendingIntent pendingIntent) {
                this(Icon.createWithResource("", n), charSequence, pendingIntent, new Bundle(), null);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_Action_Builder$__constructor__(int java.lang.CharSequence android.app.PendingIntent ), 0, this, n, charSequence, pendingIntent);
            }

            private void __constructor__(Icon icon, CharSequence charSequence, PendingIntent pendingIntent) {
                this.$$robo$$android_app_Notification_Action_Builder$__constructor__(icon, charSequence, pendingIntent);
            }

            public Builder(Icon icon, CharSequence charSequence, PendingIntent pendingIntent) {
                this(icon, charSequence, pendingIntent, new Bundle(), null);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_Action_Builder$__constructor__(android.graphics.drawable.Icon java.lang.CharSequence android.app.PendingIntent ), 0, this, icon, charSequence, pendingIntent);
            }

            private void __constructor__(Action action) {
                this.$$robo$$android_app_Notification_Action_Builder$__constructor__(action);
            }

            public Builder(Action action) {
                this(action.getIcon(), action.title, action.actionIntent, new Bundle(action.mExtras), action.getRemoteInputs());
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_Action_Builder$__constructor__(android.app.Notification$Action ), 0, this, action);
            }

            private void __constructor__(Icon icon, CharSequence charSequence, PendingIntent pendingIntent, Bundle bundle, RemoteInput[] remoteInputArray) {
                this.$$robo$$android_app_Notification_Action_Builder$__constructor__(icon, charSequence, pendingIntent, bundle, remoteInputArray);
            }

            private Builder(Icon icon, CharSequence charSequence, PendingIntent pendingIntent, Bundle bundle, RemoteInput[] remoteInputArray) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Notification_Action_Builder$__constructor__(android.graphics.drawable.Icon java.lang.CharSequence android.app.PendingIntent android.os.Bundle android.app.RemoteInput[] ), 0, this, icon, charSequence, pendingIntent, bundle, remoteInputArray);
            }

            public Builder addExtras(Bundle bundle) {
                return InvokeDynamicSupport.bootstrap("addExtras", $$robo$$android_app_Notification_Action_Builder$addExtras(android.os.Bundle ), 0, this, bundle);
            }

            public Bundle getExtras() {
                return InvokeDynamicSupport.bootstrap("getExtras", $$robo$$android_app_Notification_Action_Builder$getExtras(), 0, this);
            }

            public Builder addRemoteInput(RemoteInput remoteInput) {
                return InvokeDynamicSupport.bootstrap("addRemoteInput", $$robo$$android_app_Notification_Action_Builder$addRemoteInput(android.app.RemoteInput ), 0, this, remoteInput);
            }

            public Builder setAllowGeneratedReplies(boolean bl) {
                return InvokeDynamicSupport.bootstrap("setAllowGeneratedReplies", $$robo$$android_app_Notification_Action_Builder$setAllowGeneratedReplies(boolean ), 0, this, bl);
            }

            public Builder extend(Extender extender) {
                return InvokeDynamicSupport.bootstrap("extend", $$robo$$android_app_Notification_Action_Builder$extend(android.app.Notification$Action$Extender ), 0, this, extender);
            }

            public Action build() {
                return InvokeDynamicSupport.bootstrap("build", $$robo$$android_app_Notification_Action_Builder$build(), 0, this);
            }

            public /* synthetic */ Builder() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }
}

