/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentManagerImpl;
import android.app.FragmentTransaction;
import android.app.SharedElementCallback;
import android.graphics.Rect;
import android.transition.Transition;
import android.transition.TransitionManager;
import android.transition.TransitionSet;
import android.util.ArrayMap;
import android.util.Log;
import android.util.LogWriter;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import com.android.internal.util.FastPrintWriter;
import com.google.errorprone.annotations.DoNotMock;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class BackStackRecord
extends FragmentTransaction
implements FragmentManager.BackStackEntry,
Runnable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String TAG = "FragmentManager";
    FragmentManagerImpl mManager;
    static int OP_NULL = 0;
    static int OP_ADD = 1;
    static int OP_REPLACE = 2;
    static int OP_REMOVE = 3;
    static int OP_HIDE = 4;
    static int OP_SHOW = 5;
    static int OP_DETACH = 6;
    static int OP_ATTACH = 7;
    Op mHead;
    Op mTail;
    int mNumOp;
    int mEnterAnim;
    int mExitAnim;
    int mPopEnterAnim;
    int mPopExitAnim;
    int mTransition;
    int mTransitionStyle;
    boolean mAddToBackStack;
    boolean mAllowAddToBackStack;
    String mName;
    boolean mCommitted;
    int mIndex;
    int mBreadCrumbTitleRes;
    CharSequence mBreadCrumbTitleText;
    int mBreadCrumbShortTitleRes;
    CharSequence mBreadCrumbShortTitleText;
    ArrayList<String> mSharedElementSourceNames;
    ArrayList<String> mSharedElementTargetNames;

    private final String $$robo$$android_app_BackStackRecord$toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("BackStackEntry{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        if (this.mIndex >= 0) {
            sb.append(" #");
            sb.append(this.mIndex);
        }
        if (this.mName != null) {
            sb.append(" ");
            sb.append(this.mName);
        }
        sb.append("}");
        return sb.toString();
    }

    private final void $$robo$$android_app_BackStackRecord$dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        this.dump(prefix, writer, true);
    }

    private final void $$robo$$android_app_BackStackRecord$dump(String prefix, PrintWriter writer, boolean full) {
        if (full) {
            writer.print(prefix);
            writer.print("mName=");
            writer.print(this.mName);
            writer.print(" mIndex=");
            writer.print(this.mIndex);
            writer.print(" mCommitted=");
            writer.println(this.mCommitted);
            if (this.mTransition != 0) {
                writer.print(prefix);
                writer.print("mTransition=#");
                writer.print(Integer.toHexString(this.mTransition));
                writer.print(" mTransitionStyle=#");
                writer.println(Integer.toHexString(this.mTransitionStyle));
            }
            if (this.mEnterAnim != 0 || this.mExitAnim != 0) {
                writer.print(prefix);
                writer.print("mEnterAnim=#");
                writer.print(Integer.toHexString(this.mEnterAnim));
                writer.print(" mExitAnim=#");
                writer.println(Integer.toHexString(this.mExitAnim));
            }
            if (this.mPopEnterAnim != 0 || this.mPopExitAnim != 0) {
                writer.print(prefix);
                writer.print("mPopEnterAnim=#");
                writer.print(Integer.toHexString(this.mPopEnterAnim));
                writer.print(" mPopExitAnim=#");
                writer.println(Integer.toHexString(this.mPopExitAnim));
            }
            if (this.mBreadCrumbTitleRes != 0 || this.mBreadCrumbTitleText != null) {
                writer.print(prefix);
                writer.print("mBreadCrumbTitleRes=#");
                writer.print(Integer.toHexString(this.mBreadCrumbTitleRes));
                writer.print(" mBreadCrumbTitleText=");
                writer.println(this.mBreadCrumbTitleText);
            }
            if (this.mBreadCrumbShortTitleRes != 0 || this.mBreadCrumbShortTitleText != null) {
                writer.print(prefix);
                writer.print("mBreadCrumbShortTitleRes=#");
                writer.print(Integer.toHexString(this.mBreadCrumbShortTitleRes));
                writer.print(" mBreadCrumbShortTitleText=");
                writer.println(this.mBreadCrumbShortTitleText);
            }
        }
        if (this.mHead != null) {
            writer.print(prefix);
            writer.println("Operations:");
            String innerPrefix = prefix + "    ";
            Op op = this.mHead;
            int num = 0;
            while (op != null) {
                String cmdStr;
                switch (op.cmd) {
                    case 0: {
                        cmdStr = "NULL";
                        break;
                    }
                    case 1: {
                        cmdStr = "ADD";
                        break;
                    }
                    case 2: {
                        cmdStr = "REPLACE";
                        break;
                    }
                    case 3: {
                        cmdStr = "REMOVE";
                        break;
                    }
                    case 4: {
                        cmdStr = "HIDE";
                        break;
                    }
                    case 5: {
                        cmdStr = "SHOW";
                        break;
                    }
                    case 6: {
                        cmdStr = "DETACH";
                        break;
                    }
                    case 7: {
                        cmdStr = "ATTACH";
                        break;
                    }
                    default: {
                        cmdStr = "cmd=" + op.cmd;
                    }
                }
                writer.print(prefix);
                writer.print("  Op #");
                writer.print(num);
                writer.print(": ");
                writer.print(cmdStr);
                writer.print(" ");
                writer.println(op.fragment);
                if (full) {
                    if (op.enterAnim != 0 || op.exitAnim != 0) {
                        writer.print(innerPrefix);
                        writer.print("enterAnim=#");
                        writer.print(Integer.toHexString(op.enterAnim));
                        writer.print(" exitAnim=#");
                        writer.println(Integer.toHexString(op.exitAnim));
                    }
                    if (op.popEnterAnim != 0 || op.popExitAnim != 0) {
                        writer.print(innerPrefix);
                        writer.print("popEnterAnim=#");
                        writer.print(Integer.toHexString(op.popEnterAnim));
                        writer.print(" popExitAnim=#");
                        writer.println(Integer.toHexString(op.popExitAnim));
                    }
                }
                if (op.removed != null && op.removed.size() > 0) {
                    for (int i = 0; i < op.removed.size(); ++i) {
                        writer.print(innerPrefix);
                        if (op.removed.size() == 1) {
                            writer.print("Removed: ");
                        } else {
                            if (i == 0) {
                                writer.println("Removed:");
                            }
                            writer.print(innerPrefix);
                            writer.print("  #");
                            writer.print(i);
                            writer.print(": ");
                        }
                        writer.println(op.removed.get(i));
                    }
                }
                op = op.next;
                ++num;
            }
        }
    }

    private void $$robo$$android_app_BackStackRecord$__constructor__(FragmentManagerImpl manager) {
        this.mAllowAddToBackStack = true;
        this.mIndex = -1;
        this.mManager = manager;
    }

    private final int $$robo$$android_app_BackStackRecord$getId() {
        return this.mIndex;
    }

    private final int $$robo$$android_app_BackStackRecord$getBreadCrumbTitleRes() {
        return this.mBreadCrumbTitleRes;
    }

    private final int $$robo$$android_app_BackStackRecord$getBreadCrumbShortTitleRes() {
        return this.mBreadCrumbShortTitleRes;
    }

    private final CharSequence $$robo$$android_app_BackStackRecord$getBreadCrumbTitle() {
        if (this.mBreadCrumbTitleRes != 0) {
            return this.mManager.mHost.getContext().getText(this.mBreadCrumbTitleRes);
        }
        return this.mBreadCrumbTitleText;
    }

    private final CharSequence $$robo$$android_app_BackStackRecord$getBreadCrumbShortTitle() {
        if (this.mBreadCrumbShortTitleRes != 0) {
            return this.mManager.mHost.getContext().getText(this.mBreadCrumbShortTitleRes);
        }
        return this.mBreadCrumbShortTitleText;
    }

    private final void $$robo$$android_app_BackStackRecord$addOp(Op op) {
        if (this.mHead == null) {
            this.mHead = this.mTail = op;
        } else {
            op.prev = this.mTail;
            this.mTail.next = op;
            this.mTail = op;
        }
        op.enterAnim = this.mEnterAnim;
        op.exitAnim = this.mExitAnim;
        op.popEnterAnim = this.mPopEnterAnim;
        op.popExitAnim = this.mPopExitAnim;
        ++this.mNumOp;
    }

    private final FragmentTransaction $$robo$$android_app_BackStackRecord$add(Fragment fragment, String tag) {
        this.doAddOp(0, fragment, tag, 1);
        return this;
    }

    private final FragmentTransaction $$robo$$android_app_BackStackRecord$add(int containerViewId, Fragment fragment) {
        this.doAddOp(containerViewId, fragment, null, 1);
        return this;
    }

    private final FragmentTransaction $$robo$$android_app_BackStackRecord$add(int containerViewId, Fragment fragment, String tag) {
        this.doAddOp(containerViewId, fragment, tag, 1);
        return this;
    }

    private final void $$robo$$android_app_BackStackRecord$doAddOp(int containerViewId, Fragment fragment, String tag, int opcmd) {
        fragment.mFragmentManager = this.mManager;
        if (tag != null) {
            if (fragment.mTag != null && !tag.equals(fragment.mTag)) {
                throw new IllegalStateException("Can't change tag of fragment " + fragment + ": was " + fragment.mTag + " now " + tag);
            }
            fragment.mTag = tag;
        }
        if (containerViewId != 0) {
            if (containerViewId == -1) {
                throw new IllegalArgumentException("Can't add fragment " + fragment + " with tag " + tag + " to container view with no id");
            }
            if (fragment.mFragmentId != 0 && fragment.mFragmentId != containerViewId) {
                throw new IllegalStateException("Can't change container ID of fragment " + fragment + ": was " + fragment.mFragmentId + " now " + containerViewId);
            }
            fragment.mContainerId = fragment.mFragmentId = containerViewId;
        }
        Op op = new Op();
        op.cmd = opcmd;
        op.fragment = fragment;
        this.addOp(op);
    }

    private final FragmentTransaction $$robo$$android_app_BackStackRecord$replace(int containerViewId, Fragment fragment) {
        return this.replace(containerViewId, fragment, null);
    }

    private final FragmentTransaction $$robo$$android_app_BackStackRecord$replace(int containerViewId, Fragment fragment, String tag) {
        if (containerViewId == 0) {
            throw new IllegalArgumentException("Must use non-zero containerViewId");
        }
        this.doAddOp(containerViewId, fragment, tag, 2);
        return this;
    }

    private final FragmentTransaction $$robo$$android_app_BackStackRecord$remove(Fragment fragment) {
        Op op = new Op();
        op.cmd = 3;
        op.fragment = fragment;
        this.addOp(op);
        return this;
    }

    private final FragmentTransaction $$robo$$android_app_BackStackRecord$hide(Fragment fragment) {
        Op op = new Op();
        op.cmd = 4;
        op.fragment = fragment;
        this.addOp(op);
        return this;
    }

    private final FragmentTransaction $$robo$$android_app_BackStackRecord$show(Fragment fragment) {
        Op op = new Op();
        op.cmd = 5;
        op.fragment = fragment;
        this.addOp(op);
        return this;
    }

    private final FragmentTransaction $$robo$$android_app_BackStackRecord$detach(Fragment fragment) {
        Op op = new Op();
        op.cmd = 6;
        op.fragment = fragment;
        this.addOp(op);
        return this;
    }

    private final FragmentTransaction $$robo$$android_app_BackStackRecord$attach(Fragment fragment) {
        Op op = new Op();
        op.cmd = 7;
        op.fragment = fragment;
        this.addOp(op);
        return this;
    }

    private final FragmentTransaction $$robo$$android_app_BackStackRecord$setCustomAnimations(int enter, int exit) {
        return this.setCustomAnimations(enter, exit, 0, 0);
    }

    private final FragmentTransaction $$robo$$android_app_BackStackRecord$setCustomAnimations(int enter, int exit, int popEnter, int popExit) {
        this.mEnterAnim = enter;
        this.mExitAnim = exit;
        this.mPopEnterAnim = popEnter;
        this.mPopExitAnim = popExit;
        return this;
    }

    private final FragmentTransaction $$robo$$android_app_BackStackRecord$setTransition(int transition2) {
        this.mTransition = transition2;
        return this;
    }

    private final FragmentTransaction $$robo$$android_app_BackStackRecord$addSharedElement(View sharedElement, String name) {
        String transitionName = sharedElement.getTransitionName();
        if (transitionName == null) {
            throw new IllegalArgumentException("Unique transitionNames are required for all sharedElements");
        }
        if (this.mSharedElementSourceNames == null) {
            this.mSharedElementSourceNames = new ArrayList();
            this.mSharedElementTargetNames = new ArrayList();
        }
        this.mSharedElementSourceNames.add(transitionName);
        this.mSharedElementTargetNames.add(name);
        return this;
    }

    private final FragmentTransaction $$robo$$android_app_BackStackRecord$setTransitionStyle(int styleRes) {
        this.mTransitionStyle = styleRes;
        return this;
    }

    private final FragmentTransaction $$robo$$android_app_BackStackRecord$addToBackStack(String name) {
        if (!this.mAllowAddToBackStack) {
            throw new IllegalStateException("This FragmentTransaction is not allowed to be added to the back stack.");
        }
        this.mAddToBackStack = true;
        this.mName = name;
        return this;
    }

    private final boolean $$robo$$android_app_BackStackRecord$isAddToBackStackAllowed() {
        return this.mAllowAddToBackStack;
    }

    private final FragmentTransaction $$robo$$android_app_BackStackRecord$disallowAddToBackStack() {
        if (this.mAddToBackStack) {
            throw new IllegalStateException("This transaction is already being added to the back stack");
        }
        this.mAllowAddToBackStack = false;
        return this;
    }

    private final FragmentTransaction $$robo$$android_app_BackStackRecord$setBreadCrumbTitle(int res) {
        this.mBreadCrumbTitleRes = res;
        this.mBreadCrumbTitleText = null;
        return this;
    }

    private final FragmentTransaction $$robo$$android_app_BackStackRecord$setBreadCrumbTitle(CharSequence text) {
        this.mBreadCrumbTitleRes = 0;
        this.mBreadCrumbTitleText = text;
        return this;
    }

    private final FragmentTransaction $$robo$$android_app_BackStackRecord$setBreadCrumbShortTitle(int res) {
        this.mBreadCrumbShortTitleRes = res;
        this.mBreadCrumbShortTitleText = null;
        return this;
    }

    private final FragmentTransaction $$robo$$android_app_BackStackRecord$setBreadCrumbShortTitle(CharSequence text) {
        this.mBreadCrumbShortTitleRes = 0;
        this.mBreadCrumbShortTitleText = text;
        return this;
    }

    private final void $$robo$$android_app_BackStackRecord$bumpBackStackNesting(int amt) {
        if (!this.mAddToBackStack) {
            return;
        }
        if (FragmentManagerImpl.DEBUG) {
            Log.v("FragmentManager", "Bump nesting in " + this + " by " + amt);
        }
        Op op = this.mHead;
        while (op != null) {
            if (op.fragment != null) {
                op.fragment.mBackStackNesting += amt;
                if (FragmentManagerImpl.DEBUG) {
                    Log.v("FragmentManager", "Bump nesting of " + op.fragment + " to " + op.fragment.mBackStackNesting);
                }
            }
            if (op.removed != null) {
                for (int i = op.removed.size() - 1; i >= 0; --i) {
                    Fragment r = op.removed.get(i);
                    r.mBackStackNesting += amt;
                    if (!FragmentManagerImpl.DEBUG) continue;
                    Log.v("FragmentManager", "Bump nesting of " + r + " to " + r.mBackStackNesting);
                }
            }
            op = op.next;
        }
    }

    private final int $$robo$$android_app_BackStackRecord$commit() {
        return this.commitInternal(false);
    }

    private final int $$robo$$android_app_BackStackRecord$commitAllowingStateLoss() {
        return this.commitInternal(true);
    }

    private final void $$robo$$android_app_BackStackRecord$commitNow() {
        this.disallowAddToBackStack();
        this.mManager.execSingleAction(this, false);
    }

    private final void $$robo$$android_app_BackStackRecord$commitNowAllowingStateLoss() {
        this.disallowAddToBackStack();
        this.mManager.execSingleAction(this, true);
    }

    private final int $$robo$$android_app_BackStackRecord$commitInternal(boolean allowStateLoss) {
        if (this.mCommitted) {
            throw new IllegalStateException("commit already called");
        }
        if (FragmentManagerImpl.DEBUG) {
            Log.v("FragmentManager", "Commit: " + this);
            LogWriter logw = new LogWriter(2, "FragmentManager");
            FastPrintWriter pw = new FastPrintWriter(logw, false, 1024);
            this.dump("  ", null, pw, null);
            ((PrintWriter)pw).flush();
        }
        this.mCommitted = true;
        this.mIndex = this.mAddToBackStack ? this.mManager.allocBackStackIndex(this) : -1;
        this.mManager.enqueueAction(this, allowStateLoss);
        return this.mIndex;
    }

    private final void $$robo$$android_app_BackStackRecord$run() {
        if (FragmentManagerImpl.DEBUG) {
            Log.v("FragmentManager", "Run: " + this);
        }
        if (this.mAddToBackStack && this.mIndex < 0) {
            throw new IllegalStateException("addToBackStack() called after commit()");
        }
        this.bumpBackStackNesting(1);
        if (this.mManager.mCurState >= 1) {
            SparseArray<Fragment> firstOutFragments = new SparseArray<Fragment>();
            SparseArray<Fragment> lastInFragments = new SparseArray<Fragment>();
            this.calculateFragments(firstOutFragments, lastInFragments);
            this.beginTransition(firstOutFragments, lastInFragments, false);
        }
        Op op = this.mHead;
        while (op != null) {
            switch (op.cmd) {
                case 1: {
                    Fragment f = op.fragment;
                    f.mNextAnim = op.enterAnim;
                    this.mManager.addFragment(f, false);
                    break;
                }
                case 2: {
                    Fragment f = op.fragment;
                    int containerId = f.mContainerId;
                    if (this.mManager.mAdded != null) {
                        for (int i = this.mManager.mAdded.size() - 1; i >= 0; --i) {
                            Fragment old = this.mManager.mAdded.get(i);
                            if (FragmentManagerImpl.DEBUG) {
                                Log.v("FragmentManager", "OP_REPLACE: adding=" + f + " old=" + old);
                            }
                            if (old.mContainerId != containerId) continue;
                            if (old == f) {
                                f = null;
                                op.fragment = null;
                                continue;
                            }
                            if (op.removed == null) {
                                op.removed = new ArrayList();
                            }
                            op.removed.add(old);
                            old.mNextAnim = op.exitAnim;
                            if (this.mAddToBackStack) {
                                ++old.mBackStackNesting;
                                if (FragmentManagerImpl.DEBUG) {
                                    Log.v("FragmentManager", "Bump nesting of " + old + " to " + old.mBackStackNesting);
                                }
                            }
                            this.mManager.removeFragment(old, this.mTransition, this.mTransitionStyle);
                        }
                    }
                    if (f == null) break;
                    f.mNextAnim = op.enterAnim;
                    this.mManager.addFragment(f, false);
                    break;
                }
                case 3: {
                    Fragment f = op.fragment;
                    f.mNextAnim = op.exitAnim;
                    this.mManager.removeFragment(f, this.mTransition, this.mTransitionStyle);
                    break;
                }
                case 4: {
                    Fragment f = op.fragment;
                    f.mNextAnim = op.exitAnim;
                    this.mManager.hideFragment(f, this.mTransition, this.mTransitionStyle);
                    break;
                }
                case 5: {
                    Fragment f = op.fragment;
                    f.mNextAnim = op.enterAnim;
                    this.mManager.showFragment(f, this.mTransition, this.mTransitionStyle);
                    break;
                }
                case 6: {
                    Fragment f = op.fragment;
                    f.mNextAnim = op.exitAnim;
                    this.mManager.detachFragment(f, this.mTransition, this.mTransitionStyle);
                    break;
                }
                case 7: {
                    Fragment f = op.fragment;
                    f.mNextAnim = op.enterAnim;
                    this.mManager.attachFragment(f, this.mTransition, this.mTransitionStyle);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown cmd: " + op.cmd);
                }
            }
            op = op.next;
        }
        this.mManager.moveToState(this.mManager.mCurState, this.mTransition, this.mTransitionStyle, true);
        if (this.mAddToBackStack) {
            this.mManager.addBackStackState(this);
        }
    }

    private static final void $$robo$$android_app_BackStackRecord$setFirstOut(SparseArray<Fragment> firstOutFragments, SparseArray<Fragment> lastInFragments, Fragment fragment) {
        int containerId;
        if (fragment != null && (containerId = fragment.mContainerId) != 0 && !fragment.isHidden()) {
            if (fragment.isAdded() && fragment.getView() != null && firstOutFragments.get(containerId) == null) {
                firstOutFragments.put(containerId, fragment);
            }
            if (lastInFragments.get(containerId) == fragment) {
                lastInFragments.remove(containerId);
            }
        }
    }

    private final void $$robo$$android_app_BackStackRecord$setLastIn(SparseArray<Fragment> firstOutFragments, SparseArray<Fragment> lastInFragments, Fragment fragment) {
        if (fragment != null) {
            int containerId = fragment.mContainerId;
            if (containerId != 0) {
                if (!fragment.isAdded()) {
                    lastInFragments.put(containerId, fragment);
                }
                if (firstOutFragments.get(containerId) == fragment) {
                    firstOutFragments.remove(containerId);
                }
            }
            if (fragment.mState < 1 && this.mManager.mCurState >= 1) {
                this.mManager.makeActive(fragment);
                this.mManager.moveToState(fragment, 1, 0, 0, false);
            }
        }
    }

    private final void $$robo$$android_app_BackStackRecord$calculateFragments(SparseArray<Fragment> firstOutFragments, SparseArray<Fragment> lastInFragments) {
        if (!this.mManager.mContainer.onHasView()) {
            return;
        }
        Op op = this.mHead;
        while (op != null) {
            switch (op.cmd) {
                case 1: {
                    this.setLastIn(firstOutFragments, lastInFragments, op.fragment);
                    break;
                }
                case 2: {
                    Fragment f = op.fragment;
                    if (this.mManager.mAdded != null) {
                        for (int i = 0; i < this.mManager.mAdded.size(); ++i) {
                            Fragment old = this.mManager.mAdded.get(i);
                            if (f != null && old.mContainerId != f.mContainerId) continue;
                            if (old == f) {
                                f = null;
                                lastInFragments.remove(old.mContainerId);
                                continue;
                            }
                            BackStackRecord.setFirstOut(firstOutFragments, lastInFragments, old);
                        }
                    }
                    this.setLastIn(firstOutFragments, lastInFragments, op.fragment);
                    break;
                }
                case 3: {
                    BackStackRecord.setFirstOut(firstOutFragments, lastInFragments, op.fragment);
                    break;
                }
                case 4: {
                    BackStackRecord.setFirstOut(firstOutFragments, lastInFragments, op.fragment);
                    break;
                }
                case 5: {
                    this.setLastIn(firstOutFragments, lastInFragments, op.fragment);
                    break;
                }
                case 6: {
                    BackStackRecord.setFirstOut(firstOutFragments, lastInFragments, op.fragment);
                    break;
                }
                case 7: {
                    this.setLastIn(firstOutFragments, lastInFragments, op.fragment);
                }
            }
            op = op.next;
        }
    }

    private final void $$robo$$android_app_BackStackRecord$calculateBackFragments(SparseArray<Fragment> firstOutFragments, SparseArray<Fragment> lastInFragments) {
        if (!this.mManager.mContainer.onHasView()) {
            return;
        }
        Op op = this.mTail;
        while (op != null) {
            switch (op.cmd) {
                case 1: {
                    BackStackRecord.setFirstOut(firstOutFragments, lastInFragments, op.fragment);
                    break;
                }
                case 2: {
                    if (op.removed != null) {
                        for (int i = op.removed.size() - 1; i >= 0; --i) {
                            this.setLastIn(firstOutFragments, lastInFragments, op.removed.get(i));
                        }
                    }
                    BackStackRecord.setFirstOut(firstOutFragments, lastInFragments, op.fragment);
                    break;
                }
                case 3: {
                    this.setLastIn(firstOutFragments, lastInFragments, op.fragment);
                    break;
                }
                case 4: {
                    this.setLastIn(firstOutFragments, lastInFragments, op.fragment);
                    break;
                }
                case 5: {
                    BackStackRecord.setFirstOut(firstOutFragments, lastInFragments, op.fragment);
                    break;
                }
                case 6: {
                    this.setLastIn(firstOutFragments, lastInFragments, op.fragment);
                    break;
                }
                case 7: {
                    BackStackRecord.setFirstOut(firstOutFragments, lastInFragments, op.fragment);
                }
            }
            op = op.prev;
        }
    }

    private final TransitionState $$robo$$android_app_BackStackRecord$beginTransition(SparseArray<Fragment> firstOutFragments, SparseArray<Fragment> lastInFragments, boolean isBack) {
        int containerId;
        int i;
        TransitionState state = new TransitionState(this);
        state.nonExistentView = new View(this.mManager.mHost.getContext());
        for (i = 0; i < firstOutFragments.size(); ++i) {
            containerId = firstOutFragments.keyAt(i);
            this.configureTransitions(containerId, state, isBack, firstOutFragments, lastInFragments);
        }
        for (i = 0; i < lastInFragments.size(); ++i) {
            containerId = lastInFragments.keyAt(i);
            if (firstOutFragments.get(containerId) != null) continue;
            this.configureTransitions(containerId, state, isBack, firstOutFragments, lastInFragments);
        }
        return state;
    }

    private static final Transition $$robo$$android_app_BackStackRecord$cloneTransition(Transition transition2) {
        if (transition2 != null) {
            transition2 = ((Transition)transition2).clone();
        }
        return transition2;
    }

    private static final Transition $$robo$$android_app_BackStackRecord$getEnterTransition(Fragment inFragment, boolean isBack) {
        if (inFragment == null) {
            return null;
        }
        return BackStackRecord.cloneTransition(isBack ? inFragment.getReenterTransition() : inFragment.getEnterTransition());
    }

    private static final Transition $$robo$$android_app_BackStackRecord$getExitTransition(Fragment outFragment, boolean isBack) {
        if (outFragment == null) {
            return null;
        }
        return BackStackRecord.cloneTransition(isBack ? outFragment.getReturnTransition() : outFragment.getExitTransition());
    }

    private static final TransitionSet $$robo$$android_app_BackStackRecord$getSharedElementTransition(Fragment inFragment, Fragment outFragment, boolean isBack) {
        if (inFragment == null || outFragment == null) {
            return null;
        }
        Transition transition2 = BackStackRecord.cloneTransition(isBack ? outFragment.getSharedElementReturnTransition() : inFragment.getSharedElementEnterTransition());
        if (transition2 == null) {
            return null;
        }
        TransitionSet transitionSet = new TransitionSet();
        transitionSet.addTransition(transition2);
        return transitionSet;
    }

    private static final ArrayList<View> $$robo$$android_app_BackStackRecord$captureExitingViews(Transition exitTransition, Fragment outFragment, ArrayMap<String, View> namedViews, View nonExistentView) {
        ArrayList<View> viewList = null;
        if (exitTransition != null) {
            viewList = new ArrayList<View>();
            View root = outFragment.getView();
            root.captureTransitioningViews(viewList);
            if (namedViews != null) {
                viewList.removeAll(namedViews.values());
            }
            if (!viewList.isEmpty()) {
                viewList.add(nonExistentView);
                BackStackRecord.addTargets(exitTransition, viewList);
            }
        }
        return viewList;
    }

    private final ArrayMap<String, View> $$robo$$android_app_BackStackRecord$remapSharedElements(TransitionState state, Fragment outFragment, boolean isBack) {
        ArrayMap<String, View> namedViews = new ArrayMap<String, View>();
        if (this.mSharedElementSourceNames != null) {
            outFragment.getView().findNamedViews(namedViews);
            if (isBack) {
                namedViews.retainAll(this.mSharedElementTargetNames);
            } else {
                namedViews = BackStackRecord.remapNames(this.mSharedElementSourceNames, this.mSharedElementTargetNames, namedViews);
            }
        }
        if (isBack) {
            outFragment.mEnterTransitionCallback.onMapSharedElements(this.mSharedElementTargetNames, namedViews);
            this.setBackNameOverrides(state, namedViews, false);
        } else {
            outFragment.mExitTransitionCallback.onMapSharedElements(this.mSharedElementTargetNames, namedViews);
            this.setNameOverrides(state, namedViews, false);
        }
        return namedViews;
    }

    private final ArrayList<View> $$robo$$android_app_BackStackRecord$addTransitionTargets(TransitionState state, Transition enterTransition, TransitionSet sharedElementTransition, Transition exitTransition, Transition overallTransition, View container, Fragment inFragment, Fragment outFragment, ArrayList<View> hiddenFragmentViews, boolean isBack, ArrayList<View> sharedElementTargets) {
        if (enterTransition == null && sharedElementTransition == null && overallTransition == null) {
            return null;
        }
        ArrayList<View> enteringViews = new ArrayList<View>();
        container.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(this, container, inFragment, hiddenFragmentViews, overallTransition, sharedElementTransition, state, isBack, sharedElementTargets, exitTransition, enterTransition, outFragment, enteringViews){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ View val$container;
            /* synthetic */ Fragment val$inFragment;
            /* synthetic */ ArrayList val$hiddenFragmentViews;
            /* synthetic */ Transition val$overallTransition;
            /* synthetic */ TransitionSet val$sharedElementTransition;
            /* synthetic */ TransitionState val$state;
            /* synthetic */ boolean val$isBack;
            /* synthetic */ ArrayList val$sharedElementTargets;
            /* synthetic */ Transition val$exitTransition;
            /* synthetic */ Transition val$enterTransition;
            /* synthetic */ Fragment val$outFragment;
            /* synthetic */ ArrayList val$enteringViews;
            /* synthetic */ BackStackRecord this$0;

            private void $$robo$$android_app_BackStackRecord_1$__constructor__(BackStackRecord this$0, View view, Fragment fragment, ArrayList arrayList, Transition transition2, TransitionSet transitionSet, TransitionState transitionState, boolean bl, ArrayList arrayList2, Transition transition3, Transition transition4, Fragment fragment2, ArrayList arrayList3) {
            }

            private final boolean $$robo$$android_app_BackStackRecord_1$onPreDraw() {
                this.val$container.getViewTreeObserver().removeOnPreDrawListener(this);
                if (this.val$inFragment != null) {
                    this.this$0.excludeHiddenFragments(this.val$hiddenFragmentViews, this.val$inFragment.mContainerId, this.val$overallTransition);
                }
                ArrayMap namedViews = null;
                if (this.val$sharedElementTransition != null) {
                    namedViews = this.this$0.mapSharedElementsIn(this.val$state, this.val$isBack, this.val$inFragment);
                    BackStackRecord.removeTargets(this.val$sharedElementTransition, this.val$sharedElementTargets);
                    this.val$sharedElementTargets.remove(this.val$state.nonExistentView);
                    BackStackRecord.excludeViews(this.val$exitTransition, this.val$sharedElementTransition, this.val$sharedElementTargets, false);
                    BackStackRecord.excludeViews(this.val$enterTransition, this.val$sharedElementTransition, this.val$sharedElementTargets, false);
                    BackStackRecord.setSharedElementTargets(this.val$sharedElementTransition, this.val$state.nonExistentView, namedViews, this.val$sharedElementTargets);
                    this.this$0.setEpicenterIn(namedViews, this.val$state);
                    this.this$0.callSharedElementEnd(this.val$state, this.val$inFragment, this.val$outFragment, this.val$isBack, namedViews);
                }
                if (this.val$enterTransition != null) {
                    this.val$enterTransition.removeTarget(this.val$state.nonExistentView);
                    View view = this.val$inFragment.getView();
                    if (view != null) {
                        view.captureTransitioningViews(this.val$enteringViews);
                        if (namedViews != null) {
                            this.val$enteringViews.removeAll(namedViews.values());
                        }
                        this.val$enteringViews.add(this.val$state.nonExistentView);
                        BackStackRecord.addTargets(this.val$enterTransition, this.val$enteringViews);
                    }
                    this.this$0.setSharedElementEpicenter(this.val$enterTransition, this.val$state);
                }
                BackStackRecord.excludeViews(this.val$exitTransition, this.val$enterTransition, this.val$enteringViews, true);
                BackStackRecord.excludeViews(this.val$exitTransition, this.val$sharedElementTransition, this.val$sharedElementTargets, true);
                BackStackRecord.excludeViews(this.val$enterTransition, this.val$sharedElementTransition, this.val$sharedElementTargets, true);
                return true;
            }

            private void __constructor__(BackStackRecord backStackRecord, View view, Fragment fragment, ArrayList arrayList, Transition transition2, TransitionSet transitionSet, TransitionState transitionState, boolean bl, ArrayList arrayList2, Transition transition3, Transition transition4, Fragment fragment2, ArrayList arrayList3) {
                this.$$robo$$android_app_BackStackRecord_1$__constructor__(backStackRecord, view, fragment, arrayList, transition2, transitionSet, transitionState, bl, arrayList2, transition3, transition4, fragment2, arrayList3);
            }
            {
                this.this$0 = backStackRecord;
                this.val$container = view;
                this.val$inFragment = fragment;
                this.val$hiddenFragmentViews = arrayList;
                this.val$overallTransition = transition2;
                this.val$sharedElementTransition = transitionSet;
                this.val$state = transitionState;
                this.val$isBack = bl;
                this.val$sharedElementTargets = arrayList2;
                this.val$exitTransition = transition3;
                this.val$enterTransition = transition4;
                this.val$outFragment = fragment2;
                this.val$enteringViews = arrayList3;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_BackStackRecord_1$__constructor__(android.app.BackStackRecord android.view.View android.app.Fragment java.util.ArrayList android.transition.Transition android.transition.TransitionSet android.app.BackStackRecord$TransitionState boolean java.util.ArrayList android.transition.Transition android.transition.Transition android.app.Fragment java.util.ArrayList ), 0, this, backStackRecord, view, fragment, arrayList, transition2, transitionSet, transitionState, bl, arrayList2, transition3, transition4, fragment2, arrayList3);
            }

            @Override
            public boolean onPreDraw() {
                return (boolean)InvokeDynamicSupport.bootstrap("onPreDraw", $$robo$$android_app_BackStackRecord_1$onPreDraw(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        return enteringViews;
    }

    private final void $$robo$$android_app_BackStackRecord$callSharedElementEnd(TransitionState state, Fragment inFragment, Fragment outFragment, boolean isBack, ArrayMap<String, View> namedViews) {
        SharedElementCallback sharedElementCallback = isBack ? outFragment.mEnterTransitionCallback : inFragment.mEnterTransitionCallback;
        ArrayList<String> names = new ArrayList<String>(namedViews.keySet());
        ArrayList<View> views = new ArrayList<View>(namedViews.values());
        sharedElementCallback.onSharedElementEnd(names, views, null);
    }

    private final void $$robo$$android_app_BackStackRecord$setEpicenterIn(ArrayMap<String, View> namedViews, TransitionState state) {
        View epicenter;
        if (this.mSharedElementTargetNames != null && !namedViews.isEmpty() && (epicenter = namedViews.get(this.mSharedElementTargetNames.get(0))) != null) {
            state.enteringEpicenterView = epicenter;
        }
    }

    private final ArrayMap<String, View> $$robo$$android_app_BackStackRecord$mapSharedElementsIn(TransitionState state, boolean isBack, Fragment inFragment) {
        ArrayMap<String, View> namedViews = this.mapEnteringSharedElements(state, inFragment, isBack);
        if (isBack) {
            inFragment.mExitTransitionCallback.onMapSharedElements(this.mSharedElementTargetNames, namedViews);
            this.setBackNameOverrides(state, namedViews, true);
        } else {
            inFragment.mEnterTransitionCallback.onMapSharedElements(this.mSharedElementTargetNames, namedViews);
            this.setNameOverrides(state, namedViews, true);
        }
        return namedViews;
    }

    private static final Transition $$robo$$android_app_BackStackRecord$mergeTransitions(Transition enterTransition, Transition exitTransition, Transition sharedElementTransition, Fragment inFragment, boolean isBack) {
        Transition transition2;
        boolean overlap = true;
        if (enterTransition != null && exitTransition != null && inFragment != null) {
            boolean bl = overlap = isBack ? inFragment.getAllowReturnTransitionOverlap() : inFragment.getAllowEnterTransitionOverlap();
        }
        if (overlap) {
            TransitionSet transitionSet = new TransitionSet();
            if (enterTransition != null) {
                transitionSet.addTransition(enterTransition);
            }
            if (exitTransition != null) {
                transitionSet.addTransition(exitTransition);
            }
            if (sharedElementTransition != null) {
                transitionSet.addTransition(sharedElementTransition);
            }
            transition2 = transitionSet;
        } else {
            Transition staggered = null;
            if (exitTransition != null && enterTransition != null) {
                staggered = new TransitionSet().addTransition(exitTransition).addTransition(enterTransition).setOrdering(1);
            } else if (exitTransition != null) {
                staggered = exitTransition;
            } else if (enterTransition != null) {
                staggered = enterTransition;
            }
            if (sharedElementTransition != null) {
                TransitionSet together = new TransitionSet();
                if (staggered != null) {
                    together.addTransition(staggered);
                }
                together.addTransition(sharedElementTransition);
                transition2 = together;
            } else {
                transition2 = staggered;
            }
        }
        return transition2;
    }

    private final void $$robo$$android_app_BackStackRecord$configureTransitions(int containerId, TransitionState state, boolean isBack, SparseArray<Fragment> firstOutFragments, SparseArray<Fragment> lastInFragments) {
        ViewGroup sceneRoot = (ViewGroup)this.mManager.mContainer.onFindViewById(containerId);
        if (sceneRoot != null) {
            Transition transition2;
            View epicenterView;
            ArrayList<View> exitingViews;
            Fragment inFragment = lastInFragments.get(containerId);
            Fragment outFragment = firstOutFragments.get(containerId);
            Transition enterTransition = BackStackRecord.getEnterTransition(inFragment, isBack);
            TransitionSet sharedElementTransition = BackStackRecord.getSharedElementTransition(inFragment, outFragment, isBack);
            Transition exitTransition = BackStackRecord.getExitTransition(outFragment, isBack);
            if (enterTransition == null && sharedElementTransition == null && exitTransition == null) {
                return;
            }
            if (enterTransition != null) {
                enterTransition.addTarget(state.nonExistentView);
            }
            ArrayMap<String, View> namedViews = null;
            ArrayList<View> sharedElementTargets = new ArrayList<View>();
            if (sharedElementTransition != null) {
                namedViews = this.remapSharedElements(state, outFragment, isBack);
                BackStackRecord.setSharedElementTargets(sharedElementTransition, state.nonExistentView, namedViews, sharedElementTargets);
                SharedElementCallback callback = isBack ? outFragment.mEnterTransitionCallback : inFragment.mEnterTransitionCallback;
                ArrayList<String> names = new ArrayList<String>(namedViews.keySet());
                ArrayList<View> views = new ArrayList<View>(namedViews.values());
                callback.onSharedElementStart(names, views, null);
            }
            if ((exitingViews = BackStackRecord.captureExitingViews(exitTransition, outFragment, namedViews, state.nonExistentView)) == null || exitingViews.isEmpty()) {
                exitTransition = null;
            }
            BackStackRecord.excludeViews(enterTransition, exitTransition, exitingViews, true);
            BackStackRecord.excludeViews(enterTransition, sharedElementTransition, sharedElementTargets, true);
            BackStackRecord.excludeViews(exitTransition, sharedElementTransition, sharedElementTargets, true);
            if (this.mSharedElementTargetNames != null && namedViews != null && (epicenterView = namedViews.get(this.mSharedElementTargetNames.get(0))) != null) {
                if (exitTransition != null) {
                    BackStackRecord.setEpicenter(exitTransition, epicenterView);
                }
                if (sharedElementTransition != null) {
                    BackStackRecord.setEpicenter(sharedElementTransition, epicenterView);
                }
            }
            if ((transition2 = BackStackRecord.mergeTransitions(enterTransition, exitTransition, sharedElementTransition, inFragment, isBack)) != null) {
                ArrayList<View> hiddenFragments = new ArrayList<View>();
                ArrayList<View> enteringViews = this.addTransitionTargets(state, enterTransition, sharedElementTransition, exitTransition, transition2, sceneRoot, inFragment, outFragment, hiddenFragments, isBack, sharedElementTargets);
                transition2.setNameOverrides(state.nameOverrides);
                transition2.excludeTarget(state.nonExistentView, true);
                this.excludeHiddenFragments(hiddenFragments, containerId, transition2);
                TransitionManager.beginDelayedTransition(sceneRoot, transition2);
                this.removeTargetedViewsFromTransitions(sceneRoot, state.nonExistentView, enterTransition, enteringViews, exitTransition, exitingViews, sharedElementTransition, sharedElementTargets, transition2, hiddenFragments);
            }
        }
    }

    private static final void $$robo$$android_app_BackStackRecord$setSharedElementTargets(TransitionSet transition2, View nonExistentView, ArrayMap<String, View> namedViews, ArrayList<View> sharedElementTargets) {
        sharedElementTargets.clear();
        sharedElementTargets.addAll(namedViews.values());
        List<View> views = transition2.getTargets();
        views.clear();
        int count = sharedElementTargets.size();
        for (int i = 0; i < count; ++i) {
            View view = sharedElementTargets.get(i);
            BackStackRecord.bfsAddViewChildren(views, view);
        }
        sharedElementTargets.add(nonExistentView);
        BackStackRecord.addTargets(transition2, sharedElementTargets);
    }

    private static final void $$robo$$android_app_BackStackRecord$bfsAddViewChildren(List<View> views, View startView) {
        int startIndex = views.size();
        if (BackStackRecord.containedBeforeIndex(views, startView, startIndex)) {
            return;
        }
        views.add(startView);
        for (int index = startIndex; index < views.size(); ++index) {
            View view = views.get(index);
            if (!(view instanceof ViewGroup)) continue;
            ViewGroup viewGroup = (ViewGroup)view;
            int childCount = viewGroup.getChildCount();
            for (int childIndex = 0; childIndex < childCount; ++childIndex) {
                View child = viewGroup.getChildAt(childIndex);
                if (BackStackRecord.containedBeforeIndex(views, child, startIndex)) continue;
                views.add(child);
            }
        }
    }

    private static final boolean $$robo$$android_app_BackStackRecord$containedBeforeIndex(List<View> views, View view, int maxIndex) {
        for (int i = 0; i < maxIndex; ++i) {
            if (views.get(i) != view) continue;
            return true;
        }
        return false;
    }

    private static final void $$robo$$android_app_BackStackRecord$excludeViews(Transition transition2, Transition fromTransition, ArrayList<View> views, boolean exclude) {
        if (transition2 != null) {
            int viewCount = fromTransition == null ? 0 : views.size();
            for (int i = 0; i < viewCount; ++i) {
                transition2.excludeTarget(views.get(i), exclude);
            }
        }
    }

    private final void $$robo$$android_app_BackStackRecord$removeTargetedViewsFromTransitions(ViewGroup sceneRoot, View nonExistingView, Transition enterTransition, ArrayList<View> enteringViews, Transition exitTransition, ArrayList<View> exitingViews, Transition sharedElementTransition, ArrayList<View> sharedElementTargets, Transition overallTransition, ArrayList<View> hiddenViews) {
        if (overallTransition != null) {
            sceneRoot.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(this, sceneRoot, enterTransition, enteringViews, exitTransition, exitingViews, sharedElementTransition, sharedElementTargets, hiddenViews, overallTransition, nonExistingView){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ ViewGroup val$sceneRoot;
                /* synthetic */ Transition val$enterTransition;
                /* synthetic */ ArrayList val$enteringViews;
                /* synthetic */ Transition val$exitTransition;
                /* synthetic */ ArrayList val$exitingViews;
                /* synthetic */ Transition val$sharedElementTransition;
                /* synthetic */ ArrayList val$sharedElementTargets;
                /* synthetic */ ArrayList val$hiddenViews;
                /* synthetic */ Transition val$overallTransition;
                /* synthetic */ View val$nonExistingView;
                /* synthetic */ BackStackRecord this$0;

                private void $$robo$$android_app_BackStackRecord_2$__constructor__(BackStackRecord this$0, ViewGroup viewGroup, Transition transition2, ArrayList arrayList, Transition transition3, ArrayList arrayList2, Transition transition4, ArrayList arrayList3, ArrayList arrayList4, Transition transition5, View view) {
                }

                private final boolean $$robo$$android_app_BackStackRecord_2$onPreDraw() {
                    this.val$sceneRoot.getViewTreeObserver().removeOnPreDrawListener(this);
                    if (this.val$enterTransition != null) {
                        BackStackRecord.removeTargets(this.val$enterTransition, this.val$enteringViews);
                        BackStackRecord.excludeViews(this.val$enterTransition, this.val$exitTransition, this.val$exitingViews, false);
                        BackStackRecord.excludeViews(this.val$enterTransition, this.val$sharedElementTransition, this.val$sharedElementTargets, false);
                    }
                    if (this.val$exitTransition != null) {
                        BackStackRecord.removeTargets(this.val$exitTransition, this.val$exitingViews);
                        BackStackRecord.excludeViews(this.val$exitTransition, this.val$enterTransition, this.val$enteringViews, false);
                        BackStackRecord.excludeViews(this.val$exitTransition, this.val$sharedElementTransition, this.val$sharedElementTargets, false);
                    }
                    if (this.val$sharedElementTransition != null) {
                        BackStackRecord.removeTargets(this.val$sharedElementTransition, this.val$sharedElementTargets);
                    }
                    int numViews = this.val$hiddenViews.size();
                    for (int i = 0; i < numViews; ++i) {
                        this.val$overallTransition.excludeTarget((View)this.val$hiddenViews.get(i), false);
                    }
                    this.val$overallTransition.excludeTarget(this.val$nonExistingView, false);
                    return true;
                }

                private void __constructor__(BackStackRecord backStackRecord, ViewGroup viewGroup, Transition transition2, ArrayList arrayList, Transition transition3, ArrayList arrayList2, Transition transition4, ArrayList arrayList3, ArrayList arrayList4, Transition transition5, View view) {
                    this.$$robo$$android_app_BackStackRecord_2$__constructor__(backStackRecord, viewGroup, transition2, arrayList, transition3, arrayList2, transition4, arrayList3, arrayList4, transition5, view);
                }
                {
                    this.this$0 = backStackRecord;
                    this.val$sceneRoot = viewGroup;
                    this.val$enterTransition = transition2;
                    this.val$enteringViews = arrayList;
                    this.val$exitTransition = transition3;
                    this.val$exitingViews = arrayList2;
                    this.val$sharedElementTransition = transition4;
                    this.val$sharedElementTargets = arrayList3;
                    this.val$hiddenViews = arrayList4;
                    this.val$overallTransition = transition5;
                    this.val$nonExistingView = view;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_BackStackRecord_2$__constructor__(android.app.BackStackRecord android.view.ViewGroup android.transition.Transition java.util.ArrayList android.transition.Transition java.util.ArrayList android.transition.Transition java.util.ArrayList java.util.ArrayList android.transition.Transition android.view.View ), 0, this, backStackRecord, viewGroup, transition2, arrayList, transition3, arrayList2, transition4, arrayList3, arrayList4, transition5, view);
                }

                @Override
                public boolean onPreDraw() {
                    return (boolean)InvokeDynamicSupport.bootstrap("onPreDraw", $$robo$$android_app_BackStackRecord_2$onPreDraw(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
    }

    private static final void $$robo$$android_app_BackStackRecord$removeTargets(Transition transition2, ArrayList<View> views) {
        block3: {
            List<View> targets;
            block2: {
                if (!(transition2 instanceof TransitionSet)) break block2;
                TransitionSet set = (TransitionSet)transition2;
                int numTransitions = set.getTransitionCount();
                for (int i = 0; i < numTransitions; ++i) {
                    Transition child = set.getTransitionAt(i);
                    BackStackRecord.removeTargets(child, views);
                }
                break block3;
            }
            if (BackStackRecord.hasSimpleTarget(transition2) || (targets = transition2.getTargets()) == null || targets.size() != views.size() || !targets.containsAll(views)) break block3;
            for (int i = views.size() - 1; i >= 0; --i) {
                transition2.removeTarget(views.get(i));
            }
        }
    }

    private static final void $$robo$$android_app_BackStackRecord$addTargets(Transition transition2, ArrayList<View> views) {
        block3: {
            List<View> targets;
            block2: {
                if (!(transition2 instanceof TransitionSet)) break block2;
                TransitionSet set = (TransitionSet)transition2;
                int numTransitions = set.getTransitionCount();
                for (int i = 0; i < numTransitions; ++i) {
                    Transition child = set.getTransitionAt(i);
                    BackStackRecord.addTargets(child, views);
                }
                break block3;
            }
            if (BackStackRecord.hasSimpleTarget(transition2) || !BackStackRecord.isNullOrEmpty(targets = transition2.getTargets())) break block3;
            int numViews = views.size();
            for (int i = 0; i < numViews; ++i) {
                transition2.addTarget(views.get(i));
            }
        }
    }

    private static final boolean $$robo$$android_app_BackStackRecord$hasSimpleTarget(Transition transition2) {
        return !BackStackRecord.isNullOrEmpty(transition2.getTargetIds()) || !BackStackRecord.isNullOrEmpty(transition2.getTargetNames()) || !BackStackRecord.isNullOrEmpty(transition2.getTargetTypes());
    }

    private static final boolean $$robo$$android_app_BackStackRecord$isNullOrEmpty(List list) {
        return list == null || list.isEmpty();
    }

    private static final ArrayMap<String, View> $$robo$$android_app_BackStackRecord$remapNames(ArrayList<String> inMap, ArrayList<String> toGoInMap, ArrayMap<String, View> namedViews) {
        ArrayMap<String, View> remappedViews = new ArrayMap<String, View>();
        if (!namedViews.isEmpty()) {
            int numKeys = inMap.size();
            for (int i = 0; i < numKeys; ++i) {
                View view = namedViews.get(inMap.get(i));
                if (view == null) continue;
                remappedViews.put(toGoInMap.get(i), view);
            }
        }
        return remappedViews;
    }

    private final ArrayMap<String, View> $$robo$$android_app_BackStackRecord$mapEnteringSharedElements(TransitionState state, Fragment inFragment, boolean isBack) {
        ArrayMap<String, View> namedViews = new ArrayMap<String, View>();
        View root = inFragment.getView();
        if (root != null && this.mSharedElementSourceNames != null) {
            root.findNamedViews(namedViews);
            if (isBack) {
                namedViews = BackStackRecord.remapNames(this.mSharedElementSourceNames, this.mSharedElementTargetNames, namedViews);
            } else {
                namedViews.retainAll(this.mSharedElementTargetNames);
            }
        }
        return namedViews;
    }

    private final void $$robo$$android_app_BackStackRecord$excludeHiddenFragments(ArrayList<View> hiddenFragmentViews, int containerId, Transition transition2) {
        if (this.mManager.mAdded != null) {
            for (int i = 0; i < this.mManager.mAdded.size(); ++i) {
                Fragment fragment = this.mManager.mAdded.get(i);
                if (fragment.mView == null || fragment.mContainer == null || fragment.mContainerId != containerId) continue;
                if (fragment.mHidden) {
                    if (hiddenFragmentViews.contains(fragment.mView)) continue;
                    transition2.excludeTarget(fragment.mView, true);
                    hiddenFragmentViews.add(fragment.mView);
                    continue;
                }
                transition2.excludeTarget(fragment.mView, false);
                hiddenFragmentViews.remove(fragment.mView);
            }
        }
    }

    private static final void $$robo$$android_app_BackStackRecord$setEpicenter(Transition transition2, View view) {
        Rect epicenter = new Rect();
        view.getBoundsOnScreen(epicenter);
        transition2.setEpicenterCallback((Transition.EpicenterCallback)new ShadowedObject(epicenter){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ Rect val$epicenter;

            private void $$robo$$android_app_BackStackRecord_3$__constructor__(Rect rect) {
            }

            private final Rect $$robo$$android_app_BackStackRecord_3$onGetEpicenter(Transition transition2) {
                return this.val$epicenter;
            }

            private void __constructor__(Rect rect) {
                this.$$robo$$android_app_BackStackRecord_3$__constructor__(rect);
            }
            {
                this.val$epicenter = rect;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_BackStackRecord_3$__constructor__(android.graphics.Rect ), 0, this, rect);
            }

            @Override
            public Rect onGetEpicenter(Transition transition2) {
                return InvokeDynamicSupport.bootstrap("onGetEpicenter", $$robo$$android_app_BackStackRecord_3$onGetEpicenter(android.transition.Transition ), 0, this, transition2);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$android_app_BackStackRecord$setSharedElementEpicenter(Transition transition2, TransitionState state) {
        transition2.setEpicenterCallback((Transition.EpicenterCallback)new ShadowedObject(this, state){
            public transient /* synthetic */ Object __robo_data__;
            private Rect mEpicenter;
            /* synthetic */ TransitionState val$state;
            /* synthetic */ BackStackRecord this$0;

            private void $$robo$$android_app_BackStackRecord_4$__constructor__(BackStackRecord this$0, TransitionState transitionState) {
            }

            private final Rect $$robo$$android_app_BackStackRecord_4$onGetEpicenter(Transition transition2) {
                if (this.mEpicenter == null && this.val$state.enteringEpicenterView != null) {
                    this.mEpicenter = new Rect();
                    this.val$state.enteringEpicenterView.getBoundsOnScreen(this.mEpicenter);
                }
                return this.mEpicenter;
            }

            private void __constructor__(BackStackRecord backStackRecord, TransitionState transitionState) {
                this.$$robo$$android_app_BackStackRecord_4$__constructor__(backStackRecord, transitionState);
            }
            {
                this.this$0 = backStackRecord;
                this.val$state = transitionState;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_BackStackRecord_4$__constructor__(android.app.BackStackRecord android.app.BackStackRecord$TransitionState ), 0, this, backStackRecord, transitionState);
            }

            @Override
            public Rect onGetEpicenter(Transition transition2) {
                return InvokeDynamicSupport.bootstrap("onGetEpicenter", $$robo$$android_app_BackStackRecord_4$onGetEpicenter(android.transition.Transition ), 0, this, transition2);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final TransitionState $$robo$$android_app_BackStackRecord$popFromBackStack(boolean doStateMove, TransitionState state, SparseArray<Fragment> firstOutFragments, SparseArray<Fragment> lastInFragments) {
        if (FragmentManagerImpl.DEBUG) {
            Log.v("FragmentManager", "popFromBackStack: " + this);
            LogWriter logw = new LogWriter(2, "FragmentManager");
            FastPrintWriter pw = new FastPrintWriter(logw, false, 1024);
            this.dump("  ", null, pw, null);
            ((PrintWriter)pw).flush();
        }
        if (this.mManager.mCurState >= 1) {
            if (state == null) {
                if (firstOutFragments.size() != 0 || lastInFragments.size() != 0) {
                    state = this.beginTransition(firstOutFragments, lastInFragments, true);
                }
            } else if (!doStateMove) {
                BackStackRecord.setNameOverrides(state, this.mSharedElementTargetNames, this.mSharedElementSourceNames);
            }
        }
        this.bumpBackStackNesting(-1);
        Op op = this.mTail;
        while (op != null) {
            switch (op.cmd) {
                case 1: {
                    Fragment f = op.fragment;
                    f.mNextAnim = op.popExitAnim;
                    this.mManager.removeFragment(f, FragmentManagerImpl.reverseTransit(this.mTransition), this.mTransitionStyle);
                    break;
                }
                case 2: {
                    Fragment f = op.fragment;
                    if (f != null) {
                        f.mNextAnim = op.popExitAnim;
                        this.mManager.removeFragment(f, FragmentManagerImpl.reverseTransit(this.mTransition), this.mTransitionStyle);
                    }
                    if (op.removed == null) break;
                    for (int i = 0; i < op.removed.size(); ++i) {
                        Fragment old = op.removed.get(i);
                        old.mNextAnim = op.popEnterAnim;
                        this.mManager.addFragment(old, false);
                    }
                    break;
                }
                case 3: {
                    Fragment f = op.fragment;
                    f.mNextAnim = op.popEnterAnim;
                    this.mManager.addFragment(f, false);
                    break;
                }
                case 4: {
                    Fragment f = op.fragment;
                    f.mNextAnim = op.popEnterAnim;
                    this.mManager.showFragment(f, FragmentManagerImpl.reverseTransit(this.mTransition), this.mTransitionStyle);
                    break;
                }
                case 5: {
                    Fragment f = op.fragment;
                    f.mNextAnim = op.popExitAnim;
                    this.mManager.hideFragment(f, FragmentManagerImpl.reverseTransit(this.mTransition), this.mTransitionStyle);
                    break;
                }
                case 6: {
                    Fragment f = op.fragment;
                    f.mNextAnim = op.popEnterAnim;
                    this.mManager.attachFragment(f, FragmentManagerImpl.reverseTransit(this.mTransition), this.mTransitionStyle);
                    break;
                }
                case 7: {
                    Fragment f = op.fragment;
                    f.mNextAnim = op.popExitAnim;
                    this.mManager.detachFragment(f, FragmentManagerImpl.reverseTransit(this.mTransition), this.mTransitionStyle);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown cmd: " + op.cmd);
                }
            }
            op = op.prev;
        }
        if (doStateMove) {
            this.mManager.moveToState(this.mManager.mCurState, FragmentManagerImpl.reverseTransit(this.mTransition), this.mTransitionStyle, true);
            state = null;
        }
        if (this.mIndex >= 0) {
            this.mManager.freeBackStackIndex(this.mIndex);
            this.mIndex = -1;
        }
        return state;
    }

    private static final void $$robo$$android_app_BackStackRecord$setNameOverride(ArrayMap<String, String> overrides, String source, String target) {
        if (source != null && target != null && !source.equals(target)) {
            for (int index = 0; index < overrides.size(); ++index) {
                if (!source.equals(overrides.valueAt(index))) continue;
                overrides.setValueAt(index, target);
                return;
            }
            overrides.put(source, target);
        }
    }

    private static final void $$robo$$android_app_BackStackRecord$setNameOverrides(TransitionState state, ArrayList<String> sourceNames, ArrayList<String> targetNames) {
        if (sourceNames != null && targetNames != null) {
            for (int i = 0; i < sourceNames.size(); ++i) {
                String source = sourceNames.get(i);
                String target = targetNames.get(i);
                BackStackRecord.setNameOverride(state.nameOverrides, source, target);
            }
        }
    }

    private final void $$robo$$android_app_BackStackRecord$setBackNameOverrides(TransitionState state, ArrayMap<String, View> namedViews, boolean isEnd) {
        int targetCount = this.mSharedElementTargetNames == null ? 0 : this.mSharedElementTargetNames.size();
        int sourceCount = this.mSharedElementSourceNames == null ? 0 : this.mSharedElementSourceNames.size();
        int count = Math.min(targetCount, sourceCount);
        for (int i = 0; i < count; ++i) {
            String source = this.mSharedElementSourceNames.get(i);
            String originalTarget = this.mSharedElementTargetNames.get(i);
            View view = namedViews.get(originalTarget);
            if (view == null) continue;
            String target = view.getTransitionName();
            if (isEnd) {
                BackStackRecord.setNameOverride(state.nameOverrides, source, target);
                continue;
            }
            BackStackRecord.setNameOverride(state.nameOverrides, target, source);
        }
    }

    private final void $$robo$$android_app_BackStackRecord$setNameOverrides(TransitionState state, ArrayMap<String, View> namedViews, boolean isEnd) {
        int count = namedViews == null ? 0 : namedViews.size();
        for (int i = 0; i < count; ++i) {
            String source = namedViews.keyAt(i);
            String target = namedViews.valueAt(i).getTransitionName();
            if (isEnd) {
                BackStackRecord.setNameOverride(state.nameOverrides, source, target);
                continue;
            }
            BackStackRecord.setNameOverride(state.nameOverrides, target, source);
        }
    }

    private final String $$robo$$android_app_BackStackRecord$getName() {
        return this.mName;
    }

    private final int $$robo$$android_app_BackStackRecord$getTransition() {
        return this.mTransition;
    }

    private final int $$robo$$android_app_BackStackRecord$getTransitionStyle() {
        return this.mTransitionStyle;
    }

    private final boolean $$robo$$android_app_BackStackRecord$isEmpty() {
        return this.mNumOp == 0;
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_app_BackStackRecord$toString(), 0, this);
    }

    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_app_BackStackRecord$dump(java.lang.String java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, string2, fileDescriptor, printWriter, stringArray);
    }

    void dump(String string2, PrintWriter printWriter, boolean bl) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_app_BackStackRecord$dump(java.lang.String java.io.PrintWriter boolean ), 0, this, string2, printWriter, bl);
    }

    private void __constructor__(FragmentManagerImpl fragmentManagerImpl) {
        this.$$robo$$android_app_BackStackRecord$__constructor__(fragmentManagerImpl);
    }

    public BackStackRecord(FragmentManagerImpl fragmentManagerImpl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_BackStackRecord$__constructor__(android.app.FragmentManagerImpl ), 0, this, fragmentManagerImpl);
    }

    @Override
    public int getId() {
        return (int)InvokeDynamicSupport.bootstrap("getId", $$robo$$android_app_BackStackRecord$getId(), 0, this);
    }

    @Override
    public int getBreadCrumbTitleRes() {
        return (int)InvokeDynamicSupport.bootstrap("getBreadCrumbTitleRes", $$robo$$android_app_BackStackRecord$getBreadCrumbTitleRes(), 0, this);
    }

    @Override
    public int getBreadCrumbShortTitleRes() {
        return (int)InvokeDynamicSupport.bootstrap("getBreadCrumbShortTitleRes", $$robo$$android_app_BackStackRecord$getBreadCrumbShortTitleRes(), 0, this);
    }

    @Override
    public CharSequence getBreadCrumbTitle() {
        return InvokeDynamicSupport.bootstrap("getBreadCrumbTitle", $$robo$$android_app_BackStackRecord$getBreadCrumbTitle(), 0, this);
    }

    @Override
    public CharSequence getBreadCrumbShortTitle() {
        return InvokeDynamicSupport.bootstrap("getBreadCrumbShortTitle", $$robo$$android_app_BackStackRecord$getBreadCrumbShortTitle(), 0, this);
    }

    void addOp(Op op) {
        InvokeDynamicSupport.bootstrap("addOp", $$robo$$android_app_BackStackRecord$addOp(android.app.BackStackRecord$Op ), 0, this, op);
    }

    @Override
    public FragmentTransaction add(Fragment fragment, String string2) {
        return InvokeDynamicSupport.bootstrap("add", $$robo$$android_app_BackStackRecord$add(android.app.Fragment java.lang.String ), 0, this, fragment, string2);
    }

    @Override
    public FragmentTransaction add(int n, Fragment fragment) {
        return InvokeDynamicSupport.bootstrap("add", $$robo$$android_app_BackStackRecord$add(int android.app.Fragment ), 0, this, n, fragment);
    }

    @Override
    public FragmentTransaction add(int n, Fragment fragment, String string2) {
        return InvokeDynamicSupport.bootstrap("add", $$robo$$android_app_BackStackRecord$add(int android.app.Fragment java.lang.String ), 0, this, n, fragment, string2);
    }

    private void doAddOp(int n, Fragment fragment, String string2, int n2) {
        InvokeDynamicSupport.bootstrap("doAddOp", $$robo$$android_app_BackStackRecord$doAddOp(int android.app.Fragment java.lang.String int ), 0, this, n, fragment, string2, n2);
    }

    @Override
    public FragmentTransaction replace(int n, Fragment fragment) {
        return InvokeDynamicSupport.bootstrap("replace", $$robo$$android_app_BackStackRecord$replace(int android.app.Fragment ), 0, this, n, fragment);
    }

    @Override
    public FragmentTransaction replace(int n, Fragment fragment, String string2) {
        return InvokeDynamicSupport.bootstrap("replace", $$robo$$android_app_BackStackRecord$replace(int android.app.Fragment java.lang.String ), 0, this, n, fragment, string2);
    }

    @Override
    public FragmentTransaction remove(Fragment fragment) {
        return InvokeDynamicSupport.bootstrap("remove", $$robo$$android_app_BackStackRecord$remove(android.app.Fragment ), 0, this, fragment);
    }

    @Override
    public FragmentTransaction hide(Fragment fragment) {
        return InvokeDynamicSupport.bootstrap("hide", $$robo$$android_app_BackStackRecord$hide(android.app.Fragment ), 0, this, fragment);
    }

    @Override
    public FragmentTransaction show(Fragment fragment) {
        return InvokeDynamicSupport.bootstrap("show", $$robo$$android_app_BackStackRecord$show(android.app.Fragment ), 0, this, fragment);
    }

    @Override
    public FragmentTransaction detach(Fragment fragment) {
        return InvokeDynamicSupport.bootstrap("detach", $$robo$$android_app_BackStackRecord$detach(android.app.Fragment ), 0, this, fragment);
    }

    @Override
    public FragmentTransaction attach(Fragment fragment) {
        return InvokeDynamicSupport.bootstrap("attach", $$robo$$android_app_BackStackRecord$attach(android.app.Fragment ), 0, this, fragment);
    }

    @Override
    public FragmentTransaction setCustomAnimations(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("setCustomAnimations", $$robo$$android_app_BackStackRecord$setCustomAnimations(int int ), 0, this, n, n2);
    }

    @Override
    public FragmentTransaction setCustomAnimations(int n, int n2, int n3, int n4) {
        return InvokeDynamicSupport.bootstrap("setCustomAnimations", $$robo$$android_app_BackStackRecord$setCustomAnimations(int int int int ), 0, this, n, n2, n3, n4);
    }

    @Override
    public FragmentTransaction setTransition(int n) {
        return InvokeDynamicSupport.bootstrap("setTransition", $$robo$$android_app_BackStackRecord$setTransition(int ), 0, this, n);
    }

    @Override
    public FragmentTransaction addSharedElement(View view, String string2) {
        return InvokeDynamicSupport.bootstrap("addSharedElement", $$robo$$android_app_BackStackRecord$addSharedElement(android.view.View java.lang.String ), 0, this, view, string2);
    }

    @Override
    public FragmentTransaction setTransitionStyle(int n) {
        return InvokeDynamicSupport.bootstrap("setTransitionStyle", $$robo$$android_app_BackStackRecord$setTransitionStyle(int ), 0, this, n);
    }

    @Override
    public FragmentTransaction addToBackStack(String string2) {
        return InvokeDynamicSupport.bootstrap("addToBackStack", $$robo$$android_app_BackStackRecord$addToBackStack(java.lang.String ), 0, this, string2);
    }

    @Override
    public boolean isAddToBackStackAllowed() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAddToBackStackAllowed", $$robo$$android_app_BackStackRecord$isAddToBackStackAllowed(), 0, this);
    }

    @Override
    public FragmentTransaction disallowAddToBackStack() {
        return InvokeDynamicSupport.bootstrap("disallowAddToBackStack", $$robo$$android_app_BackStackRecord$disallowAddToBackStack(), 0, this);
    }

    @Override
    public FragmentTransaction setBreadCrumbTitle(int n) {
        return InvokeDynamicSupport.bootstrap("setBreadCrumbTitle", $$robo$$android_app_BackStackRecord$setBreadCrumbTitle(int ), 0, this, n);
    }

    @Override
    public FragmentTransaction setBreadCrumbTitle(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("setBreadCrumbTitle", $$robo$$android_app_BackStackRecord$setBreadCrumbTitle(java.lang.CharSequence ), 0, this, charSequence);
    }

    @Override
    public FragmentTransaction setBreadCrumbShortTitle(int n) {
        return InvokeDynamicSupport.bootstrap("setBreadCrumbShortTitle", $$robo$$android_app_BackStackRecord$setBreadCrumbShortTitle(int ), 0, this, n);
    }

    @Override
    public FragmentTransaction setBreadCrumbShortTitle(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("setBreadCrumbShortTitle", $$robo$$android_app_BackStackRecord$setBreadCrumbShortTitle(java.lang.CharSequence ), 0, this, charSequence);
    }

    void bumpBackStackNesting(int n) {
        InvokeDynamicSupport.bootstrap("bumpBackStackNesting", $$robo$$android_app_BackStackRecord$bumpBackStackNesting(int ), 0, this, n);
    }

    @Override
    public int commit() {
        return (int)InvokeDynamicSupport.bootstrap("commit", $$robo$$android_app_BackStackRecord$commit(), 0, this);
    }

    @Override
    public int commitAllowingStateLoss() {
        return (int)InvokeDynamicSupport.bootstrap("commitAllowingStateLoss", $$robo$$android_app_BackStackRecord$commitAllowingStateLoss(), 0, this);
    }

    @Override
    public void commitNow() {
        InvokeDynamicSupport.bootstrap("commitNow", $$robo$$android_app_BackStackRecord$commitNow(), 0, this);
    }

    @Override
    public void commitNowAllowingStateLoss() {
        InvokeDynamicSupport.bootstrap("commitNowAllowingStateLoss", $$robo$$android_app_BackStackRecord$commitNowAllowingStateLoss(), 0, this);
    }

    int commitInternal(boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("commitInternal", $$robo$$android_app_BackStackRecord$commitInternal(boolean ), 0, this, bl);
    }

    @Override
    public void run() {
        InvokeDynamicSupport.bootstrap("run", $$robo$$android_app_BackStackRecord$run(), 0, this);
    }

    private static void setFirstOut(SparseArray<Fragment> sparseArray, SparseArray<Fragment> sparseArray2, Fragment fragment) {
        InvokeDynamicSupport.bootstrapStatic("setFirstOut", $$robo$$android_app_BackStackRecord$setFirstOut(android.util.SparseArray<android.app.Fragment> android.util.SparseArray<android.app.Fragment> android.app.Fragment ), 0, sparseArray, sparseArray2, (Fragment)fragment);
    }

    private void setLastIn(SparseArray<Fragment> sparseArray, SparseArray<Fragment> sparseArray2, Fragment fragment) {
        InvokeDynamicSupport.bootstrap("setLastIn", $$robo$$android_app_BackStackRecord$setLastIn(android.util.SparseArray<android.app.Fragment> android.util.SparseArray<android.app.Fragment> android.app.Fragment ), 0, this, sparseArray, sparseArray2, fragment);
    }

    private void calculateFragments(SparseArray<Fragment> sparseArray, SparseArray<Fragment> sparseArray2) {
        InvokeDynamicSupport.bootstrap("calculateFragments", $$robo$$android_app_BackStackRecord$calculateFragments(android.util.SparseArray<android.app.Fragment> android.util.SparseArray<android.app.Fragment> ), 0, this, sparseArray, sparseArray2);
    }

    public void calculateBackFragments(SparseArray<Fragment> sparseArray, SparseArray<Fragment> sparseArray2) {
        InvokeDynamicSupport.bootstrap("calculateBackFragments", $$robo$$android_app_BackStackRecord$calculateBackFragments(android.util.SparseArray<android.app.Fragment> android.util.SparseArray<android.app.Fragment> ), 0, this, sparseArray, sparseArray2);
    }

    private TransitionState beginTransition(SparseArray<Fragment> sparseArray, SparseArray<Fragment> sparseArray2, boolean bl) {
        return InvokeDynamicSupport.bootstrap("beginTransition", $$robo$$android_app_BackStackRecord$beginTransition(android.util.SparseArray<android.app.Fragment> android.util.SparseArray<android.app.Fragment> boolean ), 0, this, sparseArray, sparseArray2, bl);
    }

    private static Transition cloneTransition(Transition transition2) {
        return InvokeDynamicSupport.bootstrapStatic("cloneTransition", $$robo$$android_app_BackStackRecord$cloneTransition(android.transition.Transition ), 0, (Transition)transition2);
    }

    private static Transition getEnterTransition(Fragment fragment, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("getEnterTransition", $$robo$$android_app_BackStackRecord$getEnterTransition(android.app.Fragment boolean ), 0, (Fragment)fragment, (boolean)bl);
    }

    private static Transition getExitTransition(Fragment fragment, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("getExitTransition", $$robo$$android_app_BackStackRecord$getExitTransition(android.app.Fragment boolean ), 0, (Fragment)fragment, (boolean)bl);
    }

    private static TransitionSet getSharedElementTransition(Fragment fragment, Fragment fragment2, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("getSharedElementTransition", $$robo$$android_app_BackStackRecord$getSharedElementTransition(android.app.Fragment android.app.Fragment boolean ), 0, (Fragment)fragment, (Fragment)fragment2, (boolean)bl);
    }

    private static ArrayList<View> captureExitingViews(Transition transition2, Fragment fragment, ArrayMap<String, View> arrayMap, View view) {
        return InvokeDynamicSupport.bootstrapStatic("captureExitingViews", $$robo$$android_app_BackStackRecord$captureExitingViews(android.transition.Transition android.app.Fragment android.util.ArrayMap<java.lang.String, android.view.View> android.view.View ), 0, (Transition)transition2, (Fragment)fragment, arrayMap, (View)view);
    }

    private ArrayMap<String, View> remapSharedElements(TransitionState transitionState, Fragment fragment, boolean bl) {
        return InvokeDynamicSupport.bootstrap("remapSharedElements", $$robo$$android_app_BackStackRecord$remapSharedElements(android.app.BackStackRecord$TransitionState android.app.Fragment boolean ), 0, this, transitionState, fragment, bl);
    }

    private ArrayList<View> addTransitionTargets(TransitionState transitionState, Transition transition2, TransitionSet transitionSet, Transition transition3, Transition transition4, View view, Fragment fragment, Fragment fragment2, ArrayList<View> arrayList, boolean bl, ArrayList<View> arrayList2) {
        return InvokeDynamicSupport.bootstrap("addTransitionTargets", $$robo$$android_app_BackStackRecord$addTransitionTargets(android.app.BackStackRecord$TransitionState android.transition.Transition android.transition.TransitionSet android.transition.Transition android.transition.Transition android.view.View android.app.Fragment android.app.Fragment java.util.ArrayList<android.view.View> boolean java.util.ArrayList<android.view.View> ), 0, this, transitionState, transition2, transitionSet, transition3, transition4, view, fragment, fragment2, arrayList, bl, arrayList2);
    }

    private void callSharedElementEnd(TransitionState transitionState, Fragment fragment, Fragment fragment2, boolean bl, ArrayMap<String, View> arrayMap) {
        InvokeDynamicSupport.bootstrap("callSharedElementEnd", $$robo$$android_app_BackStackRecord$callSharedElementEnd(android.app.BackStackRecord$TransitionState android.app.Fragment android.app.Fragment boolean android.util.ArrayMap<java.lang.String, android.view.View> ), 0, this, transitionState, fragment, fragment2, bl, arrayMap);
    }

    private void setEpicenterIn(ArrayMap<String, View> arrayMap, TransitionState transitionState) {
        InvokeDynamicSupport.bootstrap("setEpicenterIn", $$robo$$android_app_BackStackRecord$setEpicenterIn(android.util.ArrayMap<java.lang.String, android.view.View> android.app.BackStackRecord$TransitionState ), 0, this, arrayMap, transitionState);
    }

    private ArrayMap<String, View> mapSharedElementsIn(TransitionState transitionState, boolean bl, Fragment fragment) {
        return InvokeDynamicSupport.bootstrap("mapSharedElementsIn", $$robo$$android_app_BackStackRecord$mapSharedElementsIn(android.app.BackStackRecord$TransitionState boolean android.app.Fragment ), 0, this, transitionState, bl, fragment);
    }

    private static Transition mergeTransitions(Transition transition2, Transition transition3, Transition transition4, Fragment fragment, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("mergeTransitions", $$robo$$android_app_BackStackRecord$mergeTransitions(android.transition.Transition android.transition.Transition android.transition.Transition android.app.Fragment boolean ), 0, (Transition)transition2, (Transition)transition3, (Transition)transition4, (Fragment)fragment, (boolean)bl);
    }

    private void configureTransitions(int n, TransitionState transitionState, boolean bl, SparseArray<Fragment> sparseArray, SparseArray<Fragment> sparseArray2) {
        InvokeDynamicSupport.bootstrap("configureTransitions", $$robo$$android_app_BackStackRecord$configureTransitions(int android.app.BackStackRecord$TransitionState boolean android.util.SparseArray<android.app.Fragment> android.util.SparseArray<android.app.Fragment> ), 0, this, n, transitionState, bl, sparseArray, sparseArray2);
    }

    private static void setSharedElementTargets(TransitionSet transitionSet, View view, ArrayMap<String, View> arrayMap, ArrayList<View> arrayList) {
        InvokeDynamicSupport.bootstrapStatic("setSharedElementTargets", $$robo$$android_app_BackStackRecord$setSharedElementTargets(android.transition.TransitionSet android.view.View android.util.ArrayMap<java.lang.String, android.view.View> java.util.ArrayList<android.view.View> ), 0, (TransitionSet)transitionSet, (View)view, arrayMap, arrayList);
    }

    private static void bfsAddViewChildren(List<View> list, View view) {
        InvokeDynamicSupport.bootstrapStatic("bfsAddViewChildren", $$robo$$android_app_BackStackRecord$bfsAddViewChildren(java.util.List<android.view.View> android.view.View ), 0, list, (View)view);
    }

    private static boolean containedBeforeIndex(List<View> list, View view, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("containedBeforeIndex", $$robo$$android_app_BackStackRecord$containedBeforeIndex(java.util.List<android.view.View> android.view.View int ), 0, list, (View)view, (int)n);
    }

    private static void excludeViews(Transition transition2, Transition transition3, ArrayList<View> arrayList, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("excludeViews", $$robo$$android_app_BackStackRecord$excludeViews(android.transition.Transition android.transition.Transition java.util.ArrayList<android.view.View> boolean ), 0, (Transition)transition2, (Transition)transition3, arrayList, (boolean)bl);
    }

    private void removeTargetedViewsFromTransitions(ViewGroup viewGroup, View view, Transition transition2, ArrayList<View> arrayList, Transition transition3, ArrayList<View> arrayList2, Transition transition4, ArrayList<View> arrayList3, Transition transition5, ArrayList<View> arrayList4) {
        InvokeDynamicSupport.bootstrap("removeTargetedViewsFromTransitions", $$robo$$android_app_BackStackRecord$removeTargetedViewsFromTransitions(android.view.ViewGroup android.view.View android.transition.Transition java.util.ArrayList<android.view.View> android.transition.Transition java.util.ArrayList<android.view.View> android.transition.Transition java.util.ArrayList<android.view.View> android.transition.Transition java.util.ArrayList<android.view.View> ), 0, this, viewGroup, view, transition2, arrayList, transition3, arrayList2, transition4, arrayList3, transition5, arrayList4);
    }

    public static void removeTargets(Transition transition2, ArrayList<View> arrayList) {
        InvokeDynamicSupport.bootstrapStatic("removeTargets", $$robo$$android_app_BackStackRecord$removeTargets(android.transition.Transition java.util.ArrayList<android.view.View> ), 0, (Transition)transition2, arrayList);
    }

    public static void addTargets(Transition transition2, ArrayList<View> arrayList) {
        InvokeDynamicSupport.bootstrapStatic("addTargets", $$robo$$android_app_BackStackRecord$addTargets(android.transition.Transition java.util.ArrayList<android.view.View> ), 0, (Transition)transition2, arrayList);
    }

    private static boolean hasSimpleTarget(Transition transition2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("hasSimpleTarget", $$robo$$android_app_BackStackRecord$hasSimpleTarget(android.transition.Transition ), 0, (Transition)transition2);
    }

    private static boolean isNullOrEmpty(List list) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isNullOrEmpty", $$robo$$android_app_BackStackRecord$isNullOrEmpty(java.util.List ), 0, (List)list);
    }

    private static ArrayMap<String, View> remapNames(ArrayList<String> arrayList, ArrayList<String> arrayList2, ArrayMap<String, View> arrayMap) {
        return InvokeDynamicSupport.bootstrapStatic("remapNames", $$robo$$android_app_BackStackRecord$remapNames(java.util.ArrayList<java.lang.String> java.util.ArrayList<java.lang.String> android.util.ArrayMap<java.lang.String, android.view.View> ), 0, arrayList, arrayList2, arrayMap);
    }

    private ArrayMap<String, View> mapEnteringSharedElements(TransitionState transitionState, Fragment fragment, boolean bl) {
        return InvokeDynamicSupport.bootstrap("mapEnteringSharedElements", $$robo$$android_app_BackStackRecord$mapEnteringSharedElements(android.app.BackStackRecord$TransitionState android.app.Fragment boolean ), 0, this, transitionState, fragment, bl);
    }

    private void excludeHiddenFragments(ArrayList<View> arrayList, int n, Transition transition2) {
        InvokeDynamicSupport.bootstrap("excludeHiddenFragments", $$robo$$android_app_BackStackRecord$excludeHiddenFragments(java.util.ArrayList<android.view.View> int android.transition.Transition ), 0, this, arrayList, n, transition2);
    }

    private static void setEpicenter(Transition transition2, View view) {
        InvokeDynamicSupport.bootstrapStatic("setEpicenter", $$robo$$android_app_BackStackRecord$setEpicenter(android.transition.Transition android.view.View ), 0, (Transition)transition2, (View)view);
    }

    private void setSharedElementEpicenter(Transition transition2, TransitionState transitionState) {
        InvokeDynamicSupport.bootstrap("setSharedElementEpicenter", $$robo$$android_app_BackStackRecord$setSharedElementEpicenter(android.transition.Transition android.app.BackStackRecord$TransitionState ), 0, this, transition2, transitionState);
    }

    public TransitionState popFromBackStack(boolean bl, TransitionState transitionState, SparseArray<Fragment> sparseArray, SparseArray<Fragment> sparseArray2) {
        return InvokeDynamicSupport.bootstrap("popFromBackStack", $$robo$$android_app_BackStackRecord$popFromBackStack(boolean android.app.BackStackRecord$TransitionState android.util.SparseArray<android.app.Fragment> android.util.SparseArray<android.app.Fragment> ), 0, this, bl, transitionState, sparseArray, sparseArray2);
    }

    private static void setNameOverride(ArrayMap<String, String> arrayMap, String string2, String string3) {
        InvokeDynamicSupport.bootstrapStatic("setNameOverride", $$robo$$android_app_BackStackRecord$setNameOverride(android.util.ArrayMap<java.lang.String, java.lang.String> java.lang.String java.lang.String ), 0, arrayMap, (String)string2, (String)string3);
    }

    private static void setNameOverrides(TransitionState transitionState, ArrayList<String> arrayList, ArrayList<String> arrayList2) {
        InvokeDynamicSupport.bootstrapStatic("setNameOverrides", $$robo$$android_app_BackStackRecord$setNameOverrides(android.app.BackStackRecord$TransitionState java.util.ArrayList<java.lang.String> java.util.ArrayList<java.lang.String> ), 0, (TransitionState)transitionState, arrayList, arrayList2);
    }

    private void setBackNameOverrides(TransitionState transitionState, ArrayMap<String, View> arrayMap, boolean bl) {
        InvokeDynamicSupport.bootstrap("setBackNameOverrides", $$robo$$android_app_BackStackRecord$setBackNameOverrides(android.app.BackStackRecord$TransitionState android.util.ArrayMap<java.lang.String, android.view.View> boolean ), 0, this, transitionState, arrayMap, bl);
    }

    private void setNameOverrides(TransitionState transitionState, ArrayMap<String, View> arrayMap, boolean bl) {
        InvokeDynamicSupport.bootstrap("setNameOverrides", $$robo$$android_app_BackStackRecord$setNameOverrides(android.app.BackStackRecord$TransitionState android.util.ArrayMap<java.lang.String, android.view.View> boolean ), 0, this, transitionState, arrayMap, bl);
    }

    @Override
    public String getName() {
        return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_app_BackStackRecord$getName(), 0, this);
    }

    public int getTransition() {
        return (int)InvokeDynamicSupport.bootstrap("getTransition", $$robo$$android_app_BackStackRecord$getTransition(), 0, this);
    }

    public int getTransitionStyle() {
        return (int)InvokeDynamicSupport.bootstrap("getTransitionStyle", $$robo$$android_app_BackStackRecord$getTransitionStyle(), 0, this);
    }

    @Override
    public boolean isEmpty() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEmpty", $$robo$$android_app_BackStackRecord$isEmpty(), 0, this);
    }

    public /* synthetic */ BackStackRecord() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BackStackRecord)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class TransitionState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public ArrayMap<String, String> nameOverrides;
        public View enteringEpicenterView;
        public View nonExistentView;
        /* synthetic */ BackStackRecord this$0;

        private void $$robo$$android_app_BackStackRecord_TransitionState$__constructor__(BackStackRecord this$0) {
            this.nameOverrides = new ArrayMap();
        }

        private void __constructor__(BackStackRecord backStackRecord) {
            this.$$robo$$android_app_BackStackRecord_TransitionState$__constructor__(backStackRecord);
        }

        public TransitionState(BackStackRecord backStackRecord) {
            this.this$0 = backStackRecord;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_BackStackRecord_TransitionState$__constructor__(android.app.BackStackRecord ), 0, this, backStackRecord);
        }

        public /* synthetic */ TransitionState() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TransitionState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Op
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        Op next;
        Op prev;
        int cmd;
        Fragment fragment;
        int enterAnim;
        int exitAnim;
        int popEnterAnim;
        int popExitAnim;
        ArrayList<Fragment> removed;

        private void $$robo$$android_app_BackStackRecord_Op$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_app_BackStackRecord_Op$__constructor__();
        }

        Op() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_BackStackRecord_Op$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Op)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

