/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityManager;
import android.app.ActivityManagerNative;
import android.app.IProcessObserver;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.SparseArray;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AppImportanceMonitor
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    Context mContext;
    SparseArray<AppEntry> mApps;
    IProcessObserver mProcessObserver;
    static int MSG_UPDATE = 1;
    Handler mHandler;

    private void $$robo$$android_app_AppImportanceMonitor$__constructor__(Context context, Looper looper) {
        this.mApps = new SparseArray();
        this.mProcessObserver = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ AppImportanceMonitor this$0;

            private void $$robo$$android_app_AppImportanceMonitor_1$__constructor__(AppImportanceMonitor this$0) {
            }

            private final void $$robo$$android_app_AppImportanceMonitor_1$onForegroundActivitiesChanged(int pid, int uid, boolean foregroundActivities) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_app_AppImportanceMonitor_1$onProcessStateChanged(int pid, int uid, int procState) {
                SparseArray<AppEntry> sparseArray = this.this$0.mApps;
                synchronized (sparseArray) {
                    this.this$0.updateImportanceLocked(pid, uid, ActivityManager.RunningAppProcessInfo.procStateToImportance(procState), true);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_app_AppImportanceMonitor_1$onProcessDied(int pid, int uid) {
                SparseArray<AppEntry> sparseArray = this.this$0.mApps;
                synchronized (sparseArray) {
                    this.this$0.updateImportanceLocked(pid, uid, 1000, true);
                }
            }

            private void __constructor__(AppImportanceMonitor appImportanceMonitor) {
                this.$$robo$$android_app_AppImportanceMonitor_1$__constructor__(appImportanceMonitor);
            }
            {
                this.this$0 = appImportanceMonitor;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_AppImportanceMonitor_1$__constructor__(android.app.AppImportanceMonitor ), 0, this, appImportanceMonitor);
            }

            @Override
            public void onForegroundActivitiesChanged(int n, int n2, boolean bl) {
                InvokeDynamicSupport.bootstrap("onForegroundActivitiesChanged", $$robo$$android_app_AppImportanceMonitor_1$onForegroundActivitiesChanged(int int boolean ), 0, this, n, n2, bl);
            }

            @Override
            public void onProcessStateChanged(int n, int n2, int n3) {
                InvokeDynamicSupport.bootstrap("onProcessStateChanged", $$robo$$android_app_AppImportanceMonitor_1$onProcessStateChanged(int int int ), 0, this, n, n2, n3);
            }

            @Override
            public void onProcessDied(int n, int n2) {
                InvokeDynamicSupport.bootstrap("onProcessDied", $$robo$$android_app_AppImportanceMonitor_1$onProcessDied(int int ), 0, this, n, n2);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mContext = context;
        this.mHandler = new ShadowedObject(this, looper){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ AppImportanceMonitor this$0;

            private void $$robo$$android_app_AppImportanceMonitor_2$__constructor__(AppImportanceMonitor this$0, Looper looper) {
            }

            private final void $$robo$$android_app_AppImportanceMonitor_2$handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        this.this$0.onImportanceChanged(msg.arg1, msg.arg2 & 0xFFFF, msg.arg2 >> 16);
                        break;
                    }
                    default: {
                        super.handleMessage(msg);
                    }
                }
            }

            private void __constructor__(AppImportanceMonitor appImportanceMonitor, Looper looper) {
                this.$$robo$$android_app_AppImportanceMonitor_2$__constructor__(appImportanceMonitor, looper);
            }
            {
                this.this$0 = appImportanceMonitor;
                super(looper);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_AppImportanceMonitor_2$__constructor__(android.app.AppImportanceMonitor android.os.Looper ), 0, this, appImportanceMonitor, looper);
            }

            @Override
            public void handleMessage(Message message) {
                InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_app_AppImportanceMonitor_2$handleMessage(android.os.Message ), 0, this, message);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        try {
            ActivityManagerNative.getDefault().registerProcessObserver(this.mProcessObserver);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        List<ActivityManager.RunningAppProcessInfo> apps = am.getRunningAppProcesses();
        if (apps != null) {
            for (int i = 0; i < apps.size(); ++i) {
                ActivityManager.RunningAppProcessInfo app = apps.get(i);
                this.updateImportanceLocked(app.uid, app.pid, app.importance, false);
            }
        }
    }

    private final int $$robo$$android_app_AppImportanceMonitor$getImportance(int uid) {
        AppEntry ent = this.mApps.get(uid);
        if (ent == null) {
            return 1000;
        }
        return ent.importance;
    }

    private final void $$robo$$android_app_AppImportanceMonitor$onImportanceChanged(int uid, int importance, int oldImportance) {
    }

    private final void $$robo$$android_app_AppImportanceMonitor$updateImportanceLocked(int uid, int pid, int importance, boolean repChange) {
        AppEntry ent = this.mApps.get(uid);
        if (ent == null) {
            ent = new AppEntry(uid);
            this.mApps.put(uid, ent);
        }
        if (importance >= 1000) {
            ent.procs.remove(pid);
        } else {
            ent.procs.put(pid, importance);
        }
        this.updateImportanceLocked(ent, repChange);
    }

    private final void $$robo$$android_app_AppImportanceMonitor$updateImportanceLocked(AppEntry ent, boolean repChange) {
        int appImp = 1000;
        for (int i = 0; i < ent.procs.size(); ++i) {
            int procImp = ent.procs.valueAt(i);
            if (procImp >= appImp) continue;
            appImp = procImp;
        }
        if (appImp != ent.importance) {
            int impCode = appImp | ent.importance << 16;
            ent.importance = appImp;
            if (appImp >= 1000) {
                this.mApps.remove(ent.uid);
            }
            if (repChange) {
                this.mHandler.obtainMessage(1, ent.uid, impCode).sendToTarget();
            }
        }
    }

    private void __constructor__(Context context, Looper looper) {
        this.$$robo$$android_app_AppImportanceMonitor$__constructor__(context, looper);
    }

    public AppImportanceMonitor(Context context, Looper looper) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_AppImportanceMonitor$__constructor__(android.content.Context android.os.Looper ), 0, this, context, looper);
    }

    public int getImportance(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getImportance", $$robo$$android_app_AppImportanceMonitor$getImportance(int ), 0, this, n);
    }

    public void onImportanceChanged(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("onImportanceChanged", $$robo$$android_app_AppImportanceMonitor$onImportanceChanged(int int int ), 0, this, n, n2, n3);
    }

    void updateImportanceLocked(int n, int n2, int n3, boolean bl) {
        InvokeDynamicSupport.bootstrap("updateImportanceLocked", $$robo$$android_app_AppImportanceMonitor$updateImportanceLocked(int int int boolean ), 0, this, n, n2, n3, bl);
    }

    void updateImportanceLocked(AppEntry appEntry, boolean bl) {
        InvokeDynamicSupport.bootstrap("updateImportanceLocked", $$robo$$android_app_AppImportanceMonitor$updateImportanceLocked(android.app.AppImportanceMonitor$AppEntry boolean ), 0, this, appEntry, bl);
    }

    public /* synthetic */ AppImportanceMonitor() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AppImportanceMonitor)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class AppEntry
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int uid;
        SparseArray<Integer> procs;
        int importance;

        private void $$robo$$android_app_AppImportanceMonitor_AppEntry$__constructor__(int _uid) {
            this.procs = new SparseArray(1);
            this.importance = 1000;
            this.uid = _uid;
        }

        private void __constructor__(int n) {
            this.$$robo$$android_app_AppImportanceMonitor_AppEntry$__constructor__(n);
        }

        AppEntry(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_AppImportanceMonitor_AppEntry$__constructor__(int ), 0, this, n);
        }

        public /* synthetic */ AppEntry() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AppEntry)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

