/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Activity;
import android.app.ActivityManagerNative;
import android.app.IActivityContainer;
import android.app.IActivityContainerCallback;
import android.app.PendingIntent;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.IIntentSender;
import android.content.Intent;
import android.content.IntentSender;
import android.graphics.SurfaceTexture;
import android.os.IBinder;
import android.os.OperationCanceledException;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.InputEvent;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.android.internal.annotations.GuardedBy;
import dalvik.system.CloseGuard;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ActivityView
extends ViewGroup
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "ActivityView";
    private static boolean DEBUG = false;
    private static int MSG_SET_SURFACE = 1;
    private static int CPU_COUNT;
    private static int MINIMUM_POOL_SIZE = 1;
    private static int MAXIMUM_POOL_SIZE;
    private static int KEEP_ALIVE = 1;
    private static ThreadFactory sThreadFactory;
    private static BlockingQueue<Runnable> sPoolWorkQueue;
    private static Executor sExecutor;
    private SerialExecutor mExecutor;
    private int mDensityDpi;
    private TextureView mTextureView;
    @GuardedBy(value="mActivityContainerLock")
    private ActivityContainerWrapper mActivityContainer;
    private Object mActivityContainerLock;
    private Activity mActivity;
    private int mWidth;
    private int mHeight;
    private Surface mSurface;
    private int mLastVisibility;
    private ActivityViewCallback mActivityViewCallback;

    private void $$robo$$android_app_ActivityView$__constructor__(Context context) {
    }

    private void $$robo$$android_app_ActivityView$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_app_ActivityView$__constructor__(Context context, AttributeSet attrs, int defStyle) {
        this.mExecutor = new SerialExecutor();
        this.mActivityContainerLock = new Object();
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                this.mActivity = (Activity)context;
                break;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        if (this.mActivity == null) {
            throw new IllegalStateException("The ActivityView's Context is not an Activity.");
        }
        try {
            this.mActivityContainer = new ActivityContainerWrapper(ActivityManagerNative.getDefault().createVirtualActivityContainer(this.mActivity.getActivityToken(), new ActivityContainerCallback(this)));
        }
        catch (RemoteException e) {
            throw new RuntimeException("ActivityView: Unable to create ActivityContainer. " + e);
        }
        this.mTextureView = new TextureView(context);
        this.mTextureView.setSurfaceTextureListener(new ActivityViewSurfaceTextureListener(this));
        this.addView(this.mTextureView);
        WindowManager wm = (WindowManager)this.mActivity.getSystemService("window");
        DisplayMetrics metrics = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(metrics);
        this.mDensityDpi = metrics.densityDpi;
        this.mLastVisibility = this.getVisibility();
    }

    private final void $$robo$$android_app_ActivityView$onLayout(boolean changed, int l, int t, int r, int b) {
        this.mTextureView.layout(0, 0, r - l, b - t);
    }

    private final void $$robo$$android_app_ActivityView$onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (this.mSurface != null && (visibility == 8 || this.mLastVisibility == 8)) {
            Surface surface = visibility == 8 ? null : this.mSurface;
            this.setSurfaceAsync(surface, this.mWidth, this.mHeight, this.mDensityDpi, false);
        }
        this.mLastVisibility = visibility;
    }

    private final boolean $$robo$$android_app_ActivityView$injectInputEvent(InputEvent event) {
        return this.mActivityContainer != null && this.mActivityContainer.injectEvent(event);
    }

    private final boolean $$robo$$android_app_ActivityView$onTouchEvent(MotionEvent event) {
        return this.injectInputEvent(event) || super.onTouchEvent(event);
    }

    private final boolean $$robo$$android_app_ActivityView$onGenericMotionEvent(MotionEvent event) {
        if (event.isFromSource(2) && this.injectInputEvent(event)) {
            return true;
        }
        return super.onGenericMotionEvent(event);
    }

    private final void $$robo$$android_app_ActivityView$onAttachedToWindow() {
    }

    private final void $$robo$$android_app_ActivityView$onDetachedFromWindow() {
    }

    private final boolean $$robo$$android_app_ActivityView$isAttachedToDisplay() {
        return this.mSurface != null;
    }

    private final void $$robo$$android_app_ActivityView$startActivity(Intent intent) {
        if (this.mActivityContainer == null) {
            throw new IllegalStateException("Attempt to call startActivity after release");
        }
        if (this.mSurface == null) {
            throw new IllegalStateException("Surface not yet created.");
        }
        if (this.mActivityContainer.startActivity(intent) == -6) {
            throw new OperationCanceledException();
        }
    }

    private final void $$robo$$android_app_ActivityView$startActivity(IntentSender intentSender) {
        if (this.mActivityContainer == null) {
            throw new IllegalStateException("Attempt to call startActivity after release");
        }
        if (this.mSurface == null) {
            throw new IllegalStateException("Surface not yet created.");
        }
        IIntentSender iIntentSender = intentSender.getTarget();
        if (this.mActivityContainer.startActivityIntentSender(iIntentSender) == -6) {
            throw new OperationCanceledException();
        }
    }

    private final void $$robo$$android_app_ActivityView$startActivity(PendingIntent pendingIntent) {
        if (this.mActivityContainer == null) {
            throw new IllegalStateException("Attempt to call startActivity after release");
        }
        if (this.mSurface == null) {
            throw new IllegalStateException("Surface not yet created.");
        }
        IIntentSender iIntentSender = pendingIntent.getTarget();
        if (this.mActivityContainer.startActivityIntentSender(iIntentSender) == -6) {
            throw new OperationCanceledException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_ActivityView$release() {
        if (this.mActivityContainer == null) {
            Log.e("ActivityView", "Duplicate call to release");
            return;
        }
        Object object = this.mActivityContainerLock;
        synchronized (object) {
            this.mActivityContainer.release();
            this.mActivityContainer = null;
        }
        if (this.mSurface != null) {
            this.mSurface.release();
            this.mSurface = null;
        }
        this.mTextureView.setSurfaceTextureListener(null);
    }

    private final void $$robo$$android_app_ActivityView$setSurfaceAsync(Surface surface, int width, int height, int densityDpi, boolean callback) {
        this.mExecutor.execute(new Runnable(this, surface, width, height, densityDpi, callback){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ Surface val$surface;
            /* synthetic */ int val$width;
            /* synthetic */ int val$height;
            /* synthetic */ int val$densityDpi;
            /* synthetic */ boolean val$callback;
            /* synthetic */ ActivityView this$0;

            private void $$robo$$android_app_ActivityView_2$__constructor__(ActivityView this$0, Surface surface, int n, int n2, int n3, boolean bl) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_app_ActivityView_2$run() {
                try {
                    Object object = this.this$0.mActivityContainerLock;
                    synchronized (object) {
                        if (this.this$0.mActivityContainer != null) {
                            this.this$0.mActivityContainer.setSurface(this.val$surface, this.val$width, this.val$height, this.val$densityDpi);
                        }
                    }
                }
                catch (RemoteException e) {
                    throw new RuntimeException("ActivityView: Unable to set surface of ActivityContainer. ", e);
                }
                if (this.val$callback) {
                    this.this$0.post(new Runnable(this){
                        public transient /* synthetic */ Object __robo_data__;
                        /* synthetic */ 2 this$1;

                        private void $$robo$$android_app_ActivityView_2_1$__constructor__(2 this$1) {
                        }

                        private final void $$robo$$android_app_ActivityView_2_1$run() {
                            if (this.this$1.this$0.mActivityViewCallback != null) {
                                if (this.this$1.val$surface != null) {
                                    this.this$1.this$0.mActivityViewCallback.onSurfaceAvailable(this.this$1.this$0);
                                } else {
                                    this.this$1.this$0.mActivityViewCallback.onSurfaceDestroyed(this.this$1.this$0);
                                }
                            }
                        }

                        private void __constructor__(2 var1_1) {
                            this.$$robo$$android_app_ActivityView_2_1$__constructor__(var1_1);
                        }
                        {
                            this.this$1 = var1_1;
                            this.$$robo$init();
                            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityView_2_1$__constructor__(android.app.ActivityView$2 ), 0, this, var1_1);
                        }

                        @Override
                        public void run() {
                            InvokeDynamicSupport.bootstrap("run", $$robo$$android_app_ActivityView_2_1$run(), 0, this);
                        }
                        {
                            this.$$robo$init();
                        }

                        protected /* synthetic */ void $$robo$init() {
                            if (this.__robo_data__ == null) {
                                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                            }
                        }

                        public /* synthetic */ Object $$robo$getData() {
                            return this.__robo_data__;
                        }
                    });
                }
            }

            private void __constructor__(ActivityView activityView, Surface surface, int n, int n2, int n3, boolean bl) {
                this.$$robo$$android_app_ActivityView_2$__constructor__(activityView, surface, n, n2, n3, bl);
            }
            {
                this.this$0 = activityView;
                this.val$surface = surface;
                this.val$width = n;
                this.val$height = n2;
                this.val$densityDpi = n3;
                this.val$callback = bl;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityView_2$__constructor__(android.app.ActivityView android.view.Surface int int int boolean ), 0, this, activityView, surface, n, n2, n3, bl);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_app_ActivityView_2$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$android_app_ActivityView$setCallback(ActivityViewCallback callback) {
        this.mActivityViewCallback = callback;
        if (this.mSurface != null) {
            this.mActivityViewCallback.onSurfaceAvailable(this);
        }
    }

    static void __staticInitializer__() {
        CPU_COUNT = Runtime.getRuntime().availableProcessors();
        MAXIMUM_POOL_SIZE = CPU_COUNT * 2 + 1;
        sThreadFactory = new ThreadFactory(){
            public transient /* synthetic */ Object __robo_data__;
            private AtomicInteger mCount;

            private void $$robo$$android_app_ActivityView_1$__constructor__() {
                this.mCount = new AtomicInteger(1);
            }

            private final Thread $$robo$$android_app_ActivityView_1$newThread(Runnable r) {
                return new Thread(r, "ActivityView #" + this.mCount.getAndIncrement());
            }

            private void __constructor__() {
                this.$$robo$$android_app_ActivityView_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityView_1$__constructor__(), 0, this);
            }

            @Override
            public Thread newThread(Runnable runnable) {
                return InvokeDynamicSupport.bootstrap("newThread", $$robo$$android_app_ActivityView_1$newThread(java.lang.Runnable ), 0, this, runnable);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        sPoolWorkQueue = new LinkedBlockingQueue<Runnable>(128);
        sExecutor = new ThreadPoolExecutor(1, MAXIMUM_POOL_SIZE, 1L, TimeUnit.SECONDS, sPoolWorkQueue, sThreadFactory);
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_app_ActivityView$__constructor__(context);
    }

    public ActivityView(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityView$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_app_ActivityView$__constructor__(context, attributeSet);
    }

    public ActivityView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityView$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_app_ActivityView$__constructor__(context, attributeSet, n);
    }

    public ActivityView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityView$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$android_app_ActivityView$onLayout(boolean int int int int ), 0, this, bl, n, n2, n3, n4);
    }

    @Override
    protected void onVisibilityChanged(View view, int n) {
        InvokeDynamicSupport.bootstrap("onVisibilityChanged", $$robo$$android_app_ActivityView$onVisibilityChanged(android.view.View int ), 0, this, view, n);
    }

    private boolean injectInputEvent(InputEvent inputEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("injectInputEvent", $$robo$$android_app_ActivityView$injectInputEvent(android.view.InputEvent ), 0, this, inputEvent);
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$android_app_ActivityView$onTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onGenericMotionEvent", $$robo$$android_app_ActivityView$onGenericMotionEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public void onAttachedToWindow() {
        InvokeDynamicSupport.bootstrap("onAttachedToWindow", $$robo$$android_app_ActivityView$onAttachedToWindow(), 0, this);
    }

    @Override
    public void onDetachedFromWindow() {
        InvokeDynamicSupport.bootstrap("onDetachedFromWindow", $$robo$$android_app_ActivityView$onDetachedFromWindow(), 0, this);
    }

    public boolean isAttachedToDisplay() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAttachedToDisplay", $$robo$$android_app_ActivityView$isAttachedToDisplay(), 0, this);
    }

    public void startActivity(Intent intent) {
        InvokeDynamicSupport.bootstrap("startActivity", $$robo$$android_app_ActivityView$startActivity(android.content.Intent ), 0, this, intent);
    }

    public void startActivity(IntentSender intentSender) {
        InvokeDynamicSupport.bootstrap("startActivity", $$robo$$android_app_ActivityView$startActivity(android.content.IntentSender ), 0, this, intentSender);
    }

    public void startActivity(PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("startActivity", $$robo$$android_app_ActivityView$startActivity(android.app.PendingIntent ), 0, this, pendingIntent);
    }

    public void release() {
        InvokeDynamicSupport.bootstrap("release", $$robo$$android_app_ActivityView$release(), 0, this);
    }

    private void setSurfaceAsync(Surface surface, int n, int n2, int n3, boolean bl) {
        InvokeDynamicSupport.bootstrap("setSurfaceAsync", $$robo$$android_app_ActivityView$setSurfaceAsync(android.view.Surface int int int boolean ), 0, this, surface, n, n2, n3, bl);
    }

    public void setCallback(ActivityViewCallback activityViewCallback) {
        InvokeDynamicSupport.bootstrap("setCallback", $$robo$$android_app_ActivityView$setCallback(android.app.ActivityView$ActivityViewCallback ), 0, this, activityViewCallback);
    }

    static {
        RobolectricInternals.classInitializing(ActivityView.class);
    }

    public /* synthetic */ ActivityView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActivityView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class ActivityContainerWrapper
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private IActivityContainer mIActivityContainer;
        private CloseGuard mGuard;
        boolean mOpened;

        private void $$robo$$android_app_ActivityView_ActivityContainerWrapper$__constructor__(IActivityContainer container) {
            this.mGuard = CloseGuard.get();
            this.mIActivityContainer = container;
            this.mOpened = true;
            this.mGuard.open("release");
        }

        private final void $$robo$$android_app_ActivityView_ActivityContainerWrapper$attachToDisplay(int displayId) {
            try {
                this.mIActivityContainer.attachToDisplay(displayId);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        private final void $$robo$$android_app_ActivityView_ActivityContainerWrapper$setSurface(Surface surface, int width, int height, int density) throws RemoteException {
            this.mIActivityContainer.setSurface(surface, width, height, density);
        }

        private final int $$robo$$android_app_ActivityView_ActivityContainerWrapper$startActivity(Intent intent) {
            try {
                return this.mIActivityContainer.startActivity(intent);
            }
            catch (RemoteException e) {
                throw new RuntimeException("ActivityView: Unable to startActivity. " + e);
            }
        }

        private final int $$robo$$android_app_ActivityView_ActivityContainerWrapper$startActivityIntentSender(IIntentSender intentSender) {
            try {
                return this.mIActivityContainer.startActivityIntentSender(intentSender);
            }
            catch (RemoteException e) {
                throw new RuntimeException("ActivityView: Unable to startActivity from IntentSender. " + e);
            }
        }

        private final int $$robo$$android_app_ActivityView_ActivityContainerWrapper$getDisplayId() {
            try {
                return this.mIActivityContainer.getDisplayId();
            }
            catch (RemoteException e) {
                return -1;
            }
        }

        private final boolean $$robo$$android_app_ActivityView_ActivityContainerWrapper$injectEvent(InputEvent event) {
            try {
                return this.mIActivityContainer.injectEvent(event);
            }
            catch (RemoteException e) {
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_app_ActivityView_ActivityContainerWrapper$release() {
            CloseGuard closeGuard = this.mGuard;
            synchronized (closeGuard) {
                if (this.mOpened) {
                    try {
                        this.mIActivityContainer.release();
                        this.mGuard.close();
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    this.mOpened = false;
                }
            }
        }

        private final void $$robo$$android_app_ActivityView_ActivityContainerWrapper$finalize() throws Throwable {
            try {
                if (this.mGuard != null) {
                    this.mGuard.warnIfOpen();
                    this.release();
                }
            }
            finally {
                super.finalize();
            }
        }

        private void __constructor__(IActivityContainer iActivityContainer) {
            this.$$robo$$android_app_ActivityView_ActivityContainerWrapper$__constructor__(iActivityContainer);
        }

        ActivityContainerWrapper(IActivityContainer iActivityContainer) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityView_ActivityContainerWrapper$__constructor__(android.app.IActivityContainer ), 0, this, iActivityContainer);
        }

        void attachToDisplay(int n) {
            InvokeDynamicSupport.bootstrap("attachToDisplay", $$robo$$android_app_ActivityView_ActivityContainerWrapper$attachToDisplay(int ), 0, this, n);
        }

        void setSurface(Surface surface, int n, int n2, int n3) throws RemoteException {
            InvokeDynamicSupport.bootstrap("setSurface", $$robo$$android_app_ActivityView_ActivityContainerWrapper$setSurface(android.view.Surface int int int ), 0, this, surface, n, n2, n3);
        }

        int startActivity(Intent intent) {
            return (int)InvokeDynamicSupport.bootstrap("startActivity", $$robo$$android_app_ActivityView_ActivityContainerWrapper$startActivity(android.content.Intent ), 0, this, intent);
        }

        int startActivityIntentSender(IIntentSender iIntentSender) {
            return (int)InvokeDynamicSupport.bootstrap("startActivityIntentSender", $$robo$$android_app_ActivityView_ActivityContainerWrapper$startActivityIntentSender(android.content.IIntentSender ), 0, this, iIntentSender);
        }

        int getDisplayId() {
            return (int)InvokeDynamicSupport.bootstrap("getDisplayId", $$robo$$android_app_ActivityView_ActivityContainerWrapper$getDisplayId(), 0, this);
        }

        boolean injectEvent(InputEvent inputEvent) {
            return (boolean)InvokeDynamicSupport.bootstrap("injectEvent", $$robo$$android_app_ActivityView_ActivityContainerWrapper$injectEvent(android.view.InputEvent ), 0, this, inputEvent);
        }

        void release() {
            InvokeDynamicSupport.bootstrap("release", $$robo$$android_app_ActivityView_ActivityContainerWrapper$release(), 0, this);
        }

        protected void finalize() throws Throwable {
            InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_app_ActivityView_ActivityContainerWrapper$finalize(), 0, this);
        }

        public /* synthetic */ ActivityContainerWrapper() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActivityContainerWrapper)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class ActivityContainerCallback
    extends IActivityContainerCallback.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private WeakReference<ActivityView> mActivityViewWeakReference;

        private void $$robo$$android_app_ActivityView_ActivityContainerCallback$__constructor__(ActivityView activityView) {
            this.mActivityViewWeakReference = new WeakReference<ActivityView>(activityView);
        }

        private final void $$robo$$android_app_ActivityView_ActivityContainerCallback$setVisible(IBinder container, boolean visible) {
        }

        private final void $$robo$$android_app_ActivityView_ActivityContainerCallback$onAllActivitiesComplete(IBinder container) {
            ActivityViewCallback callback;
            ActivityView activityView = (ActivityView)this.mActivityViewWeakReference.get();
            if (activityView != null && (callback = activityView.mActivityViewCallback) != null) {
                WeakReference<ActivityViewCallback> callbackRef = new WeakReference<ActivityViewCallback>(callback);
                activityView.post(new Runnable(this, callbackRef, activityView){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ WeakReference val$callbackRef;
                    /* synthetic */ ActivityView val$activityView;
                    /* synthetic */ ActivityContainerCallback this$0;

                    private void $$robo$$android_app_ActivityView_ActivityContainerCallback_1$__constructor__(ActivityContainerCallback this$0, WeakReference weakReference, ActivityView activityView) {
                    }

                    private final void $$robo$$android_app_ActivityView_ActivityContainerCallback_1$run() {
                        ActivityViewCallback callback = (ActivityViewCallback)this.val$callbackRef.get();
                        if (callback != null) {
                            callback.onAllActivitiesComplete(this.val$activityView);
                        }
                    }

                    private void __constructor__(ActivityContainerCallback activityContainerCallback, WeakReference weakReference, ActivityView activityView) {
                        this.$$robo$$android_app_ActivityView_ActivityContainerCallback_1$__constructor__(activityContainerCallback, weakReference, activityView);
                    }
                    {
                        this.this$0 = activityContainerCallback;
                        this.val$callbackRef = weakReference;
                        this.val$activityView = activityView;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityView_ActivityContainerCallback_1$__constructor__(android.app.ActivityView$ActivityContainerCallback java.lang.ref.WeakReference android.app.ActivityView ), 0, this, activityContainerCallback, weakReference, activityView);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_app_ActivityView_ActivityContainerCallback_1$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }
        }

        private void __constructor__(ActivityView activityView) {
            this.$$robo$$android_app_ActivityView_ActivityContainerCallback$__constructor__(activityView);
        }

        ActivityContainerCallback(ActivityView activityView) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityView_ActivityContainerCallback$__constructor__(android.app.ActivityView ), 0, this, activityView);
        }

        @Override
        public void setVisible(IBinder iBinder, boolean bl) {
            InvokeDynamicSupport.bootstrap("setVisible", $$robo$$android_app_ActivityView_ActivityContainerCallback$setVisible(android.os.IBinder boolean ), 0, this, iBinder, bl);
        }

        @Override
        public void onAllActivitiesComplete(IBinder iBinder) {
            InvokeDynamicSupport.bootstrap("onAllActivitiesComplete", $$robo$$android_app_ActivityView_ActivityContainerCallback$onAllActivitiesComplete(android.os.IBinder ), 0, this, iBinder);
        }

        public /* synthetic */ ActivityContainerCallback() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActivityContainerCallback)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class ActivityViewSurfaceTextureListener
    implements TextureView.SurfaceTextureListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ ActivityView this$0;

        private void $$robo$$android_app_ActivityView_ActivityViewSurfaceTextureListener$__constructor__(ActivityView activityView) {
        }

        private final void $$robo$$android_app_ActivityView_ActivityViewSurfaceTextureListener$onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int width, int height) {
            if (this.this$0.mActivityContainer == null) {
                return;
            }
            this.this$0.mWidth = width;
            this.this$0.mHeight = height;
            this.this$0.mSurface = new Surface(surfaceTexture);
            this.this$0.setSurfaceAsync(this.this$0.mSurface, this.this$0.mWidth, this.this$0.mHeight, this.this$0.mDensityDpi, true);
        }

        private final void $$robo$$android_app_ActivityView_ActivityViewSurfaceTextureListener$onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int width, int height) {
            if (this.this$0.mActivityContainer == null) {
                return;
            }
        }

        private final boolean $$robo$$android_app_ActivityView_ActivityViewSurfaceTextureListener$onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
            if (this.this$0.mActivityContainer == null) {
                return true;
            }
            this.this$0.mSurface.release();
            this.this$0.mSurface = null;
            this.this$0.setSurfaceAsync(null, this.this$0.mWidth, this.this$0.mHeight, this.this$0.mDensityDpi, true);
            return true;
        }

        private final void $$robo$$android_app_ActivityView_ActivityViewSurfaceTextureListener$onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        }

        private /* synthetic */ void $$robo$$android_app_ActivityView_ActivityViewSurfaceTextureListener$__constructor__(ActivityView x0, 1 x1) {
        }

        private void __constructor__(ActivityView activityView) {
            this.$$robo$$android_app_ActivityView_ActivityViewSurfaceTextureListener$__constructor__(activityView);
        }

        private ActivityViewSurfaceTextureListener(ActivityView activityView) {
            this.this$0 = activityView;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityView_ActivityViewSurfaceTextureListener$__constructor__(android.app.ActivityView ), 0, this, activityView);
        }

        @Override
        public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
            InvokeDynamicSupport.bootstrap("onSurfaceTextureAvailable", $$robo$$android_app_ActivityView_ActivityViewSurfaceTextureListener$onSurfaceTextureAvailable(android.graphics.SurfaceTexture int int ), 0, this, surfaceTexture, n, n2);
        }

        @Override
        public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
            InvokeDynamicSupport.bootstrap("onSurfaceTextureSizeChanged", $$robo$$android_app_ActivityView_ActivityViewSurfaceTextureListener$onSurfaceTextureSizeChanged(android.graphics.SurfaceTexture int int ), 0, this, surfaceTexture, n, n2);
        }

        @Override
        public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
            return (boolean)InvokeDynamicSupport.bootstrap("onSurfaceTextureDestroyed", $$robo$$android_app_ActivityView_ActivityViewSurfaceTextureListener$onSurfaceTextureDestroyed(android.graphics.SurfaceTexture ), 0, this, surfaceTexture);
        }

        @Override
        public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
            InvokeDynamicSupport.bootstrap("onSurfaceTextureUpdated", $$robo$$android_app_ActivityView_ActivityViewSurfaceTextureListener$onSurfaceTextureUpdated(android.graphics.SurfaceTexture ), 0, this, surfaceTexture);
        }

        private /* synthetic */ void __constructor__(ActivityView activityView, 1 var2_2) {
            this.$$robo$$android_app_ActivityView_ActivityViewSurfaceTextureListener$__constructor__(activityView, var2_2);
        }

        public /* synthetic */ ActivityViewSurfaceTextureListener() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActivityViewSurfaceTextureListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class ActivityViewCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_app_ActivityView_ActivityViewCallback$__constructor__() {
        }

        public abstract void onAllActivitiesComplete(ActivityView var1);

        public abstract void onSurfaceAvailable(ActivityView var1);

        public abstract void onSurfaceDestroyed(ActivityView var1);

        private void __constructor__() {
            this.$$robo$$android_app_ActivityView_ActivityViewCallback$__constructor__();
        }

        public ActivityViewCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityView_ActivityViewCallback$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActivityViewCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class SerialExecutor
    implements Executor,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private ArrayDeque<Runnable> mTasks;
        private Runnable mActive;

        private void $$robo$$android_app_ActivityView_SerialExecutor$__constructor__() {
            this.mTasks = new ArrayDeque();
        }

        private final synchronized void $$robo$$android_app_ActivityView_SerialExecutor$execute(Runnable r) {
            this.mTasks.offer(new Runnable(this, r){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Runnable val$r;
                /* synthetic */ SerialExecutor this$0;

                private void $$robo$$android_app_ActivityView_SerialExecutor_1$__constructor__(SerialExecutor this$0, Runnable runnable) {
                }

                private final void $$robo$$android_app_ActivityView_SerialExecutor_1$run() {
                    try {
                        this.val$r.run();
                    }
                    finally {
                        this.this$0.scheduleNext();
                    }
                }

                private void __constructor__(SerialExecutor serialExecutor, Runnable runnable) {
                    this.$$robo$$android_app_ActivityView_SerialExecutor_1$__constructor__(serialExecutor, runnable);
                }
                {
                    this.this$0 = serialExecutor;
                    this.val$r = runnable;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityView_SerialExecutor_1$__constructor__(android.app.ActivityView$SerialExecutor java.lang.Runnable ), 0, this, serialExecutor, runnable);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_app_ActivityView_SerialExecutor_1$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
            if (this.mActive == null) {
                this.scheduleNext();
            }
        }

        private final synchronized void $$robo$$android_app_ActivityView_SerialExecutor$scheduleNext() {
            this.mActive = this.mTasks.poll();
            if (this.mActive != null) {
                sExecutor.execute(this.mActive);
            }
        }

        private /* synthetic */ void $$robo$$android_app_ActivityView_SerialExecutor$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_app_ActivityView_SerialExecutor$__constructor__();
        }

        private SerialExecutor() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityView_SerialExecutor$__constructor__(), 0, this);
        }

        @Override
        public synchronized void execute(Runnable runnable) {
            InvokeDynamicSupport.bootstrap("execute", $$robo$$android_app_ActivityView_SerialExecutor$execute(java.lang.Runnable ), 0, this, runnable);
        }

        protected synchronized void scheduleNext() {
            InvokeDynamicSupport.bootstrap("scheduleNext", $$robo$$android_app_ActivityView_SerialExecutor$scheduleNext(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_app_ActivityView_SerialExecutor$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SerialExecutor)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

