/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.app.ActivityThread;
import android.app.Application;
import android.util.ArrayMap;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class AnimatorSet
extends Animator
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "AnimatorSet";
    private ArrayList<Animator> mPlayingSet;
    private ArrayMap<Animator, Node> mNodeMap;
    private ArrayList<Node> mNodes;
    private AnimatorSetListener mSetListener;
    private boolean mTerminated;
    private boolean mDependencyDirty;
    private boolean mStarted;
    private long mStartDelay;
    private ValueAnimator mDelayAnim;
    private Node mRootNode;
    private long mDuration;
    private TimeInterpolator mInterpolator;
    private boolean mReversible;
    private long mTotalDuration;
    private boolean mShouldIgnoreEndWithoutStart;

    private void $$robo$$android_animation_AnimatorSet$__constructor__() {
        this.mPlayingSet = new ArrayList();
        this.mNodeMap = new ArrayMap();
        this.mNodes = new ArrayList();
        this.mSetListener = new AnimatorSetListener(this);
        this.mTerminated = false;
        this.mDependencyDirty = false;
        this.mStarted = false;
        this.mStartDelay = 0L;
        this.mDelayAnim = ValueAnimator.ofFloat(0.0f, 1.0f).setDuration(0L);
        this.mRootNode = new Node(this.mDelayAnim);
        this.mDuration = -1L;
        this.mInterpolator = null;
        this.mReversible = true;
        this.mTotalDuration = 0L;
        this.mNodeMap.put(this.mDelayAnim, this.mRootNode);
        this.mNodes.add(this.mRootNode);
        Application app = ActivityThread.currentApplication();
        this.mShouldIgnoreEndWithoutStart = app == null || app.getApplicationInfo() == null ? true : app.getApplicationInfo().targetSdkVersion < 24;
    }

    private final void $$robo$$android_animation_AnimatorSet$playTogether(Animator ... items) {
        if (items != null) {
            Builder builder = this.play(items[0]);
            for (int i = 1; i < items.length; ++i) {
                builder.with(items[i]);
            }
        }
    }

    private final void $$robo$$android_animation_AnimatorSet$playTogether(Collection<Animator> items) {
        if (items != null && items.size() > 0) {
            Builder builder = null;
            for (Animator anim2 : items) {
                if (builder == null) {
                    builder = this.play(anim2);
                    continue;
                }
                builder.with(anim2);
            }
        }
    }

    private final void $$robo$$android_animation_AnimatorSet$playSequentially(Animator ... items) {
        if (items != null) {
            if (items.length == 1) {
                this.play(items[0]);
            } else {
                this.mReversible = false;
                for (int i = 0; i < items.length - 1; ++i) {
                    this.play(items[i]).before(items[i + 1]);
                }
            }
        }
    }

    private final void $$robo$$android_animation_AnimatorSet$playSequentially(List<Animator> items) {
        if (items != null && items.size() > 0) {
            if (items.size() == 1) {
                this.play(items.get(0));
            } else {
                this.mReversible = false;
                for (int i = 0; i < items.size() - 1; ++i) {
                    this.play(items.get(i)).before(items.get(i + 1));
                }
            }
        }
    }

    private final ArrayList<Animator> $$robo$$android_animation_AnimatorSet$getChildAnimations() {
        ArrayList<Animator> childList = new ArrayList<Animator>();
        int size = this.mNodes.size();
        for (int i = 0; i < size; ++i) {
            Node node = this.mNodes.get(i);
            if (node == this.mRootNode) continue;
            childList.add(node.mAnimation);
        }
        return childList;
    }

    private final void $$robo$$android_animation_AnimatorSet$setTarget(Object target) {
        int size = this.mNodes.size();
        for (int i = 0; i < size; ++i) {
            Node node = this.mNodes.get(i);
            Animator animation = node.mAnimation;
            if (animation instanceof AnimatorSet) {
                ((AnimatorSet)animation).setTarget(target);
                continue;
            }
            if (!(animation instanceof ObjectAnimator)) continue;
            ((ObjectAnimator)animation).setTarget(target);
        }
    }

    private final int $$robo$$android_animation_AnimatorSet$getChangingConfigurations() {
        int conf = super.getChangingConfigurations();
        int nodeCount = this.mNodes.size();
        for (int i = 0; i < nodeCount; ++i) {
            conf |= this.mNodes.get((int)i).mAnimation.getChangingConfigurations();
        }
        return conf;
    }

    private final void $$robo$$android_animation_AnimatorSet$setInterpolator(TimeInterpolator interpolator2) {
        this.mInterpolator = interpolator2;
    }

    private final TimeInterpolator $$robo$$android_animation_AnimatorSet$getInterpolator() {
        return this.mInterpolator;
    }

    private final Builder $$robo$$android_animation_AnimatorSet$play(Animator anim2) {
        if (anim2 != null) {
            return new Builder(this, anim2);
        }
        return null;
    }

    private final void $$robo$$android_animation_AnimatorSet$cancel() {
        this.mTerminated = true;
        if (this.isStarted()) {
            ArrayList tmpListeners = null;
            if (this.mListeners != null) {
                tmpListeners = (ArrayList)this.mListeners.clone();
                int size = tmpListeners.size();
                for (int i = 0; i < size; ++i) {
                    ((Animator.AnimatorListener)tmpListeners.get(i)).onAnimationCancel(this);
                }
            }
            ArrayList<Animator> playingSet = new ArrayList<Animator>(this.mPlayingSet);
            int setSize = playingSet.size();
            for (int i = 0; i < setSize; ++i) {
                playingSet.get(i).cancel();
            }
            if (tmpListeners != null) {
                int size = tmpListeners.size();
                for (int i = 0; i < size; ++i) {
                    ((Animator.AnimatorListener)tmpListeners.get(i)).onAnimationEnd(this);
                }
            }
            this.mStarted = false;
        }
    }

    private final void $$robo$$android_animation_AnimatorSet$end() {
        if (this.mShouldIgnoreEndWithoutStart && !this.isStarted()) {
            return;
        }
        this.mTerminated = true;
        if (this.isStarted()) {
            this.endRemainingAnimations();
        }
        if (this.mListeners != null) {
            ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
            for (int i = 0; i < tmpListeners.size(); ++i) {
                ((Animator.AnimatorListener)tmpListeners.get(i)).onAnimationEnd(this);
            }
        }
        this.mStarted = false;
    }

    private final void $$robo$$android_animation_AnimatorSet$endRemainingAnimations() {
        ArrayList<Animator> remainingList = new ArrayList<Animator>(this.mNodes.size());
        remainingList.addAll(this.mPlayingSet);
        int index = 0;
        while (index < remainingList.size()) {
            Animator anim2 = (Animator)remainingList.get(index);
            anim2.end();
            ++index;
            Node node = this.mNodeMap.get(anim2);
            if (node.mChildNodes == null) continue;
            int childSize = node.mChildNodes.size();
            for (int i = 0; i < childSize; ++i) {
                Node child = node.mChildNodes.get(i);
                if (child.mLatestParent != node) continue;
                remainingList.add(child.mAnimation);
            }
        }
    }

    private final boolean $$robo$$android_animation_AnimatorSet$isRunning() {
        int size = this.mNodes.size();
        for (int i = 0; i < size; ++i) {
            Node node = this.mNodes.get(i);
            if (node == this.mRootNode || !node.mAnimation.isStarted()) continue;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_animation_AnimatorSet$isStarted() {
        return this.mStarted;
    }

    private final long $$robo$$android_animation_AnimatorSet$getStartDelay() {
        return this.mStartDelay;
    }

    private final void $$robo$$android_animation_AnimatorSet$setStartDelay(long startDelay) {
        long delta;
        if (startDelay < 0L) {
            Log.w("AnimatorSet", "Start delay should always be non-negative");
            startDelay = 0L;
        }
        if ((delta = startDelay - this.mStartDelay) == 0L) {
            return;
        }
        this.mStartDelay = startDelay;
        if (this.mStartDelay > 0L) {
            this.mReversible = false;
        }
        if (!this.mDependencyDirty) {
            int size = this.mNodes.size();
            for (int i = 0; i < size; ++i) {
                Node node = this.mNodes.get(i);
                if (node == this.mRootNode) {
                    node.mEndTime = this.mStartDelay;
                    continue;
                }
                node.mStartTime = node.mStartTime == -1L ? -1L : node.mStartTime + delta;
                node.mEndTime = node.mEndTime == -1L ? -1L : node.mEndTime + delta;
            }
            if (this.mTotalDuration != -1L) {
                this.mTotalDuration += delta;
            }
        }
    }

    private final long $$robo$$android_animation_AnimatorSet$getDuration() {
        return this.mDuration;
    }

    private final AnimatorSet $$robo$$android_animation_AnimatorSet$setDuration(long duration) {
        if (duration < 0L) {
            throw new IllegalArgumentException("duration must be a value of zero or greater");
        }
        this.mDependencyDirty = true;
        this.mDuration = duration;
        return this;
    }

    private final void $$robo$$android_animation_AnimatorSet$setupStartValues() {
        int size = this.mNodes.size();
        for (int i = 0; i < size; ++i) {
            Node node = this.mNodes.get(i);
            if (node == this.mRootNode) continue;
            node.mAnimation.setupStartValues();
        }
    }

    private final void $$robo$$android_animation_AnimatorSet$setupEndValues() {
        int size = this.mNodes.size();
        for (int i = 0; i < size; ++i) {
            Node node = this.mNodes.get(i);
            if (node == this.mRootNode) continue;
            node.mAnimation.setupEndValues();
        }
    }

    private final void $$robo$$android_animation_AnimatorSet$pause() {
        boolean previouslyPaused = this.mPaused;
        super.pause();
        if (!previouslyPaused && this.mPaused) {
            if (this.mDelayAnim.isStarted()) {
                this.mDelayAnim.pause();
            } else {
                int size = this.mNodes.size();
                for (int i = 0; i < size; ++i) {
                    Node node = this.mNodes.get(i);
                    if (node == this.mRootNode) continue;
                    node.mAnimation.pause();
                }
            }
        }
    }

    private final void $$robo$$android_animation_AnimatorSet$resume() {
        boolean previouslyPaused = this.mPaused;
        super.resume();
        if (previouslyPaused && !this.mPaused) {
            if (this.mDelayAnim.isStarted()) {
                this.mDelayAnim.resume();
            } else {
                int size = this.mNodes.size();
                for (int i = 0; i < size; ++i) {
                    Node node = this.mNodes.get(i);
                    if (node == this.mRootNode) continue;
                    node.mAnimation.resume();
                }
            }
        }
    }

    private final void $$robo$$android_animation_AnimatorSet$start() {
        Node node;
        int i;
        this.mTerminated = false;
        this.mStarted = true;
        this.mPaused = false;
        int size = this.mNodes.size();
        for (i = 0; i < size; ++i) {
            node = this.mNodes.get(i);
            node.mEnded = false;
            node.mAnimation.setAllowRunningAsynchronously(false);
        }
        if (this.mInterpolator != null) {
            for (i = 0; i < size; ++i) {
                node = this.mNodes.get(i);
                node.mAnimation.setInterpolator(this.mInterpolator);
            }
        }
        this.updateAnimatorsDuration();
        this.createDependencyGraph();
        boolean setIsEmpty = false;
        if (this.mStartDelay > 0L) {
            this.start(this.mRootNode);
        } else if (this.mNodes.size() > 1) {
            this.onChildAnimatorEnded(this.mDelayAnim);
        } else {
            setIsEmpty = true;
        }
        if (this.mListeners != null) {
            ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
            int numListeners = tmpListeners.size();
            for (int i2 = 0; i2 < numListeners; ++i2) {
                ((Animator.AnimatorListener)tmpListeners.get(i2)).onAnimationStart(this);
            }
        }
        if (setIsEmpty) {
            this.onChildAnimatorEnded(this.mDelayAnim);
        }
    }

    private final void $$robo$$android_animation_AnimatorSet$updateAnimatorsDuration() {
        if (this.mDuration >= 0L) {
            int size = this.mNodes.size();
            for (int i = 0; i < size; ++i) {
                Node node = this.mNodes.get(i);
                node.mAnimation.setDuration(this.mDuration);
            }
        }
        this.mDelayAnim.setDuration(this.mStartDelay);
    }

    private final void $$robo$$android_animation_AnimatorSet$start(Node node) {
        Animator anim2 = node.mAnimation;
        this.mPlayingSet.add(anim2);
        anim2.addListener(this.mSetListener);
        anim2.start();
    }

    private final AnimatorSet $$robo$$android_animation_AnimatorSet$clone() {
        Node node;
        int n;
        AnimatorSet anim2 = (AnimatorSet)super.clone();
        int nodeCount = this.mNodes.size();
        anim2.mTerminated = false;
        anim2.mStarted = false;
        anim2.mPlayingSet = new ArrayList();
        anim2.mNodeMap = new ArrayMap();
        anim2.mNodes = new ArrayList(nodeCount);
        anim2.mReversible = this.mReversible;
        anim2.mSetListener = new AnimatorSetListener(anim2);
        for (n = 0; n < nodeCount; ++n) {
            node = this.mNodes.get(n);
            Object nodeClone = node.clone();
            node.mTmpClone = (Node)nodeClone;
            anim2.mNodes.add((Node)nodeClone);
            anim2.mNodeMap.put(((Node)nodeClone).mAnimation, (Node)nodeClone);
            ArrayList<Animator.AnimatorListener> cloneListeners = ((Node)nodeClone).mAnimation.getListeners();
            if (cloneListeners == null) continue;
            for (int i = cloneListeners.size() - 1; i >= 0; --i) {
                Animator.AnimatorListener listener = cloneListeners.get(i);
                if (!(listener instanceof AnimatorSetListener)) continue;
                cloneListeners.remove(i);
            }
        }
        anim2.mRootNode = this.mRootNode.mTmpClone;
        anim2.mDelayAnim = (ValueAnimator)anim2.mRootNode.mAnimation;
        for (int i = 0; i < nodeCount; ++i) {
            int j;
            node = this.mNodes.get(i);
            ((Node)node).mTmpClone.mLatestParent = node.mLatestParent == null ? null : node.mLatestParent.mTmpClone;
            int size = node.mChildNodes == null ? 0 : node.mChildNodes.size();
            for (j = 0; j < size; ++j) {
                ((Node)node).mTmpClone.mChildNodes.set(j, node.mChildNodes.get(j).mTmpClone);
            }
            size = node.mSiblings == null ? 0 : node.mSiblings.size();
            for (j = 0; j < size; ++j) {
                ((Node)node).mTmpClone.mSiblings.set(j, node.mSiblings.get(j).mTmpClone);
            }
            size = node.mParents == null ? 0 : node.mParents.size();
            for (j = 0; j < size; ++j) {
                ((Node)node).mTmpClone.mParents.set(j, node.mParents.get(j).mTmpClone);
            }
        }
        for (n = 0; n < nodeCount; ++n) {
            this.mNodes.get(n).mTmpClone = null;
        }
        return anim2;
    }

    private final void $$robo$$android_animation_AnimatorSet$onChildAnimatorEnded(Animator animation) {
        Node animNode = this.mNodeMap.get(animation);
        animNode.mEnded = true;
        if (!this.mTerminated) {
            ArrayList<Node> children = animNode.mChildNodes;
            int childrenSize = children == null ? 0 : children.size();
            for (int i = 0; i < childrenSize; ++i) {
                if (((Node)children.get((int)i)).mLatestParent != animNode) continue;
                this.start((Node)children.get(i));
            }
            boolean allDone = true;
            int size = this.mNodes.size();
            for (int i = 0; i < size; ++i) {
                if (this.mNodes.get((int)i).mEnded) continue;
                allDone = false;
                break;
            }
            if (allDone) {
                if (this.mListeners != null) {
                    ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
                    int numListeners = tmpListeners.size();
                    for (int i = 0; i < numListeners; ++i) {
                        ((Animator.AnimatorListener)tmpListeners.get(i)).onAnimationEnd(this);
                    }
                }
                this.mStarted = false;
                this.mPaused = false;
            }
        }
    }

    private final boolean $$robo$$android_animation_AnimatorSet$canReverse() {
        if (!this.mReversible) {
            return false;
        }
        int size = this.mNodes.size();
        for (int i = 0; i < size; ++i) {
            Node node = this.mNodes.get(i);
            if (node.mAnimation.canReverse() && node.mAnimation.getStartDelay() <= 0L) continue;
            return false;
        }
        return true;
    }

    private final void $$robo$$android_animation_AnimatorSet$reverse() {
        if (this.canReverse()) {
            int size = this.mNodes.size();
            for (int i = 0; i < size; ++i) {
                Node node = this.mNodes.get(i);
                node.mAnimation.reverse();
            }
        }
    }

    private final String $$robo$$android_animation_AnimatorSet$toString() {
        String returnVal = "AnimatorSet@" + Integer.toHexString(this.hashCode()) + "{";
        int size = this.mNodes.size();
        for (int i = 0; i < size; ++i) {
            Node node = this.mNodes.get(i);
            returnVal = returnVal + "\n    " + node.mAnimation.toString();
        }
        return returnVal + "\n}";
    }

    private final void $$robo$$android_animation_AnimatorSet$printChildCount() {
        ArrayList<Node> list = new ArrayList<Node>(this.mNodes.size());
        list.add(this.mRootNode);
        Log.d("AnimatorSet", "Current tree: ");
        int index = 0;
        while (index < list.size()) {
            int listSize = list.size();
            StringBuilder builder = new StringBuilder();
            while (index < listSize) {
                Node node = (Node)list.get(index);
                int num = 0;
                if (node.mChildNodes != null) {
                    for (int i = 0; i < node.mChildNodes.size(); ++i) {
                        Node child = node.mChildNodes.get(i);
                        if (child.mLatestParent != node) continue;
                        ++num;
                        list.add(child);
                    }
                }
                builder.append(" ");
                builder.append(num);
                ++index;
            }
            Log.d("AnimatorSet", builder.toString());
        }
    }

    private final void $$robo$$android_animation_AnimatorSet$createDependencyGraph() {
        Node node;
        int i;
        if (!this.mDependencyDirty) {
            boolean durationChanged = false;
            for (i = 0; i < this.mNodes.size(); ++i) {
                Animator anim2 = this.mNodes.get((int)i).mAnimation;
                if (this.mNodes.get((int)i).mTotalDuration == anim2.getTotalDuration()) continue;
                durationChanged = true;
                break;
            }
            if (!durationChanged) {
                return;
            }
        }
        this.mDependencyDirty = false;
        int size = this.mNodes.size();
        for (i = 0; i < size; ++i) {
            this.mNodes.get((int)i).mParentsAdded = false;
        }
        for (i = 0; i < size; ++i) {
            int j;
            node = this.mNodes.get(i);
            if (node.mParentsAdded) continue;
            node.mParentsAdded = true;
            if (node.mSiblings == null) continue;
            this.findSiblings(node, node.mSiblings);
            node.mSiblings.remove(node);
            int siblingSize = node.mSiblings.size();
            for (j = 0; j < siblingSize; ++j) {
                node.addParents(node.mSiblings.get((int)j).mParents);
            }
            for (j = 0; j < siblingSize; ++j) {
                Node sibling = node.mSiblings.get(j);
                sibling.addParents(node.mParents);
                sibling.mParentsAdded = true;
            }
        }
        for (i = 0; i < size; ++i) {
            node = this.mNodes.get(i);
            if (node == this.mRootNode || node.mParents != null) continue;
            node.addParent(this.mRootNode);
        }
        ArrayList<Node> visited = new ArrayList<Node>(this.mNodes.size());
        this.mRootNode.mStartTime = 0L;
        this.mRootNode.mEndTime = this.mDelayAnim.getDuration();
        this.updatePlayTime(this.mRootNode, visited);
        long maxEndTime = 0L;
        for (int i2 = 0; i2 < size; ++i2) {
            Node node2 = this.mNodes.get(i2);
            node2.mTotalDuration = node2.mAnimation.getTotalDuration();
            if (node2.mEndTime == -1L) {
                maxEndTime = -1L;
                break;
            }
            maxEndTime = node2.mEndTime > maxEndTime ? node2.mEndTime : maxEndTime;
        }
        this.mTotalDuration = maxEndTime;
    }

    private final void $$robo$$android_animation_AnimatorSet$updatePlayTime(Node parent, ArrayList<Node> visited) {
        if (parent.mChildNodes == null) {
            if (parent == this.mRootNode) {
                for (int i = 0; i < this.mNodes.size(); ++i) {
                    Node node = this.mNodes.get(i);
                    if (node == this.mRootNode) continue;
                    node.mStartTime = -1L;
                    node.mEndTime = -1L;
                }
            }
            return;
        }
        visited.add(parent);
        int childrenSize = parent.mChildNodes.size();
        for (int i = 0; i < childrenSize; ++i) {
            Node child = parent.mChildNodes.get(i);
            int index = visited.indexOf(child);
            if (index >= 0) {
                for (int j = index; j < visited.size(); ++j) {
                    visited.get((int)j).mLatestParent = null;
                    visited.get((int)j).mStartTime = -1L;
                    visited.get((int)j).mEndTime = -1L;
                }
                child.mStartTime = -1L;
                child.mEndTime = -1L;
                child.mLatestParent = null;
                Log.w("AnimatorSet", "Cycle found in AnimatorSet: " + this);
                continue;
            }
            if (child.mStartTime != -1L) {
                if (parent.mEndTime == -1L) {
                    child.mLatestParent = parent;
                    child.mStartTime = -1L;
                    child.mEndTime = -1L;
                } else {
                    long duration;
                    if (parent.mEndTime >= child.mStartTime) {
                        child.mLatestParent = parent;
                        child.mStartTime = parent.mEndTime;
                    }
                    child.mEndTime = (duration = child.mAnimation.getTotalDuration()) == -1L ? -1L : child.mStartTime + duration;
                }
            }
            this.updatePlayTime(child, visited);
        }
        visited.remove(parent);
    }

    private final void $$robo$$android_animation_AnimatorSet$findSiblings(Node node, ArrayList<Node> siblings) {
        if (!siblings.contains(node)) {
            siblings.add(node);
            if (node.mSiblings == null) {
                return;
            }
            for (int i = 0; i < node.mSiblings.size(); ++i) {
                this.findSiblings(node.mSiblings.get(i), siblings);
            }
        }
    }

    private final boolean $$robo$$android_animation_AnimatorSet$shouldPlayTogether() {
        this.updateAnimatorsDuration();
        this.createDependencyGraph();
        return this.mRootNode.mChildNodes.size() == this.mNodes.size() - 1;
    }

    private final long $$robo$$android_animation_AnimatorSet$getTotalDuration() {
        this.updateAnimatorsDuration();
        this.createDependencyGraph();
        return this.mTotalDuration;
    }

    private final Node $$robo$$android_animation_AnimatorSet$getNodeForAnimation(Animator anim2) {
        Node node = this.mNodeMap.get(anim2);
        if (node == null) {
            node = new Node(anim2);
            this.mNodeMap.put(anim2, node);
            this.mNodes.add(node);
        }
        return node;
    }

    private void __constructor__() {
        this.$$robo$$android_animation_AnimatorSet$__constructor__();
    }

    public AnimatorSet() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_AnimatorSet$__constructor__(), 0, this);
    }

    public void playTogether(Animator ... animatorArray) {
        InvokeDynamicSupport.bootstrap("playTogether", $$robo$$android_animation_AnimatorSet$playTogether(android.animation.Animator[] ), 0, this, animatorArray);
    }

    public void playTogether(Collection<Animator> collection) {
        InvokeDynamicSupport.bootstrap("playTogether", $$robo$$android_animation_AnimatorSet$playTogether(java.util.Collection<android.animation.Animator> ), 0, this, collection);
    }

    public void playSequentially(Animator ... animatorArray) {
        InvokeDynamicSupport.bootstrap("playSequentially", $$robo$$android_animation_AnimatorSet$playSequentially(android.animation.Animator[] ), 0, this, animatorArray);
    }

    public void playSequentially(List<Animator> list) {
        InvokeDynamicSupport.bootstrap("playSequentially", $$robo$$android_animation_AnimatorSet$playSequentially(java.util.List<android.animation.Animator> ), 0, this, list);
    }

    public ArrayList<Animator> getChildAnimations() {
        return InvokeDynamicSupport.bootstrap("getChildAnimations", $$robo$$android_animation_AnimatorSet$getChildAnimations(), 0, this);
    }

    @Override
    public void setTarget(Object object) {
        InvokeDynamicSupport.bootstrap("setTarget", $$robo$$android_animation_AnimatorSet$setTarget(java.lang.Object ), 0, this, object);
    }

    @Override
    public int getChangingConfigurations() {
        return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_animation_AnimatorSet$getChangingConfigurations(), 0, this);
    }

    @Override
    public void setInterpolator(TimeInterpolator timeInterpolator) {
        InvokeDynamicSupport.bootstrap("setInterpolator", $$robo$$android_animation_AnimatorSet$setInterpolator(android.animation.TimeInterpolator ), 0, this, timeInterpolator);
    }

    @Override
    public TimeInterpolator getInterpolator() {
        return InvokeDynamicSupport.bootstrap("getInterpolator", $$robo$$android_animation_AnimatorSet$getInterpolator(), 0, this);
    }

    public Builder play(Animator animator2) {
        return InvokeDynamicSupport.bootstrap("play", $$robo$$android_animation_AnimatorSet$play(android.animation.Animator ), 0, this, animator2);
    }

    @Override
    public void cancel() {
        InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_animation_AnimatorSet$cancel(), 0, this);
    }

    @Override
    public void end() {
        InvokeDynamicSupport.bootstrap("end", $$robo$$android_animation_AnimatorSet$end(), 0, this);
    }

    private void endRemainingAnimations() {
        InvokeDynamicSupport.bootstrap("endRemainingAnimations", $$robo$$android_animation_AnimatorSet$endRemainingAnimations(), 0, this);
    }

    @Override
    public boolean isRunning() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRunning", $$robo$$android_animation_AnimatorSet$isRunning(), 0, this);
    }

    @Override
    public boolean isStarted() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStarted", $$robo$$android_animation_AnimatorSet$isStarted(), 0, this);
    }

    @Override
    public long getStartDelay() {
        return (long)InvokeDynamicSupport.bootstrap("getStartDelay", $$robo$$android_animation_AnimatorSet$getStartDelay(), 0, this);
    }

    @Override
    public void setStartDelay(long l) {
        InvokeDynamicSupport.bootstrap("setStartDelay", $$robo$$android_animation_AnimatorSet$setStartDelay(long ), 0, this, l);
    }

    @Override
    public long getDuration() {
        return (long)InvokeDynamicSupport.bootstrap("getDuration", $$robo$$android_animation_AnimatorSet$getDuration(), 0, this);
    }

    @Override
    public AnimatorSet setDuration(long l) {
        return InvokeDynamicSupport.bootstrap("setDuration", $$robo$$android_animation_AnimatorSet$setDuration(long ), 0, this, l);
    }

    @Override
    public void setupStartValues() {
        InvokeDynamicSupport.bootstrap("setupStartValues", $$robo$$android_animation_AnimatorSet$setupStartValues(), 0, this);
    }

    @Override
    public void setupEndValues() {
        InvokeDynamicSupport.bootstrap("setupEndValues", $$robo$$android_animation_AnimatorSet$setupEndValues(), 0, this);
    }

    @Override
    public void pause() {
        InvokeDynamicSupport.bootstrap("pause", $$robo$$android_animation_AnimatorSet$pause(), 0, this);
    }

    @Override
    public void resume() {
        InvokeDynamicSupport.bootstrap("resume", $$robo$$android_animation_AnimatorSet$resume(), 0, this);
    }

    @Override
    public void start() {
        InvokeDynamicSupport.bootstrap("start", $$robo$$android_animation_AnimatorSet$start(), 0, this);
    }

    private void updateAnimatorsDuration() {
        InvokeDynamicSupport.bootstrap("updateAnimatorsDuration", $$robo$$android_animation_AnimatorSet$updateAnimatorsDuration(), 0, this);
    }

    void start(Node node) {
        InvokeDynamicSupport.bootstrap("start", $$robo$$android_animation_AnimatorSet$start(android.animation.AnimatorSet$Node ), 0, this, node);
    }

    @Override
    public AnimatorSet clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_animation_AnimatorSet$clone(), 0, this);
    }

    private void onChildAnimatorEnded(Animator animator2) {
        InvokeDynamicSupport.bootstrap("onChildAnimatorEnded", $$robo$$android_animation_AnimatorSet$onChildAnimatorEnded(android.animation.Animator ), 0, this, animator2);
    }

    @Override
    public boolean canReverse() {
        return (boolean)InvokeDynamicSupport.bootstrap("canReverse", $$robo$$android_animation_AnimatorSet$canReverse(), 0, this);
    }

    @Override
    public void reverse() {
        InvokeDynamicSupport.bootstrap("reverse", $$robo$$android_animation_AnimatorSet$reverse(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_animation_AnimatorSet$toString(), 0, this);
    }

    private void printChildCount() {
        InvokeDynamicSupport.bootstrap("printChildCount", $$robo$$android_animation_AnimatorSet$printChildCount(), 0, this);
    }

    private void createDependencyGraph() {
        InvokeDynamicSupport.bootstrap("createDependencyGraph", $$robo$$android_animation_AnimatorSet$createDependencyGraph(), 0, this);
    }

    private void updatePlayTime(Node node, ArrayList<Node> arrayList) {
        InvokeDynamicSupport.bootstrap("updatePlayTime", $$robo$$android_animation_AnimatorSet$updatePlayTime(android.animation.AnimatorSet$Node java.util.ArrayList<android.animation.AnimatorSet$Node> ), 0, this, node, arrayList);
    }

    private void findSiblings(Node node, ArrayList<Node> arrayList) {
        InvokeDynamicSupport.bootstrap("findSiblings", $$robo$$android_animation_AnimatorSet$findSiblings(android.animation.AnimatorSet$Node java.util.ArrayList<android.animation.AnimatorSet$Node> ), 0, this, node, arrayList);
    }

    public boolean shouldPlayTogether() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldPlayTogether", $$robo$$android_animation_AnimatorSet$shouldPlayTogether(), 0, this);
    }

    @Override
    public long getTotalDuration() {
        return (long)InvokeDynamicSupport.bootstrap("getTotalDuration", $$robo$$android_animation_AnimatorSet$getTotalDuration(), 0, this);
    }

    private Node getNodeForAnimation(Animator animator2) {
        return InvokeDynamicSupport.bootstrap("getNodeForAnimation", $$robo$$android_animation_AnimatorSet$getNodeForAnimation(android.animation.Animator ), 0, this, animator2);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AnimatorSet)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Node mCurrentNode;
        /* synthetic */ AnimatorSet this$0;

        private void $$robo$$android_animation_AnimatorSet_Builder$__constructor__(AnimatorSet this$0, Animator anim2) {
            this$0.mDependencyDirty = true;
            this.mCurrentNode = this$0.getNodeForAnimation(anim2);
        }

        private final Builder $$robo$$android_animation_AnimatorSet_Builder$with(Animator anim2) {
            Node node = this.this$0.getNodeForAnimation(anim2);
            this.mCurrentNode.addSibling(node);
            return this;
        }

        private final Builder $$robo$$android_animation_AnimatorSet_Builder$before(Animator anim2) {
            this.this$0.mReversible = false;
            Node node = this.this$0.getNodeForAnimation(anim2);
            this.mCurrentNode.addChild(node);
            return this;
        }

        private final Builder $$robo$$android_animation_AnimatorSet_Builder$after(Animator anim2) {
            this.this$0.mReversible = false;
            Node node = this.this$0.getNodeForAnimation(anim2);
            this.mCurrentNode.addParent(node);
            return this;
        }

        private final Builder $$robo$$android_animation_AnimatorSet_Builder$after(long delay) {
            ValueAnimator anim2 = ValueAnimator.ofFloat(0.0f, 1.0f);
            anim2.setDuration(delay);
            this.after(anim2);
            return this;
        }

        private void __constructor__(AnimatorSet animatorSet, Animator animator2) {
            this.$$robo$$android_animation_AnimatorSet_Builder$__constructor__(animatorSet, animator2);
        }

        Builder(AnimatorSet animatorSet, Animator animator2) {
            this.this$0 = animatorSet;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_AnimatorSet_Builder$__constructor__(android.animation.AnimatorSet android.animation.Animator ), 0, this, animatorSet, animator2);
        }

        public Builder with(Animator animator2) {
            return InvokeDynamicSupport.bootstrap("with", $$robo$$android_animation_AnimatorSet_Builder$with(android.animation.Animator ), 0, this, animator2);
        }

        public Builder before(Animator animator2) {
            return InvokeDynamicSupport.bootstrap("before", $$robo$$android_animation_AnimatorSet_Builder$before(android.animation.Animator ), 0, this, animator2);
        }

        public Builder after(Animator animator2) {
            return InvokeDynamicSupport.bootstrap("after", $$robo$$android_animation_AnimatorSet_Builder$after(android.animation.Animator ), 0, this, animator2);
        }

        public Builder after(long l) {
            return InvokeDynamicSupport.bootstrap("after", $$robo$$android_animation_AnimatorSet_Builder$after(long ), 0, this, l);
        }

        public /* synthetic */ Builder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class Node
    implements Cloneable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        Animator mAnimation;
        ArrayList<Node> mChildNodes;
        private Node mTmpClone;
        boolean mEnded;
        ArrayList<Node> mSiblings;
        ArrayList<Node> mParents;
        Node mLatestParent;
        boolean mParentsAdded;
        long mStartTime;
        long mEndTime;
        long mTotalDuration;

        private void $$robo$$android_animation_AnimatorSet_Node$__constructor__(Animator animation) {
            this.mChildNodes = null;
            this.mTmpClone = null;
            this.mEnded = false;
            this.mLatestParent = null;
            this.mParentsAdded = false;
            this.mStartTime = 0L;
            this.mEndTime = 0L;
            this.mTotalDuration = 0L;
            this.mAnimation = animation;
        }

        private final Node $$robo$$android_animation_AnimatorSet_Node$clone() {
            try {
                Node node = (Node)super.clone();
                node.mAnimation = this.mAnimation.clone();
                if (this.mChildNodes != null) {
                    node.mChildNodes = new ArrayList<Node>(this.mChildNodes);
                }
                if (this.mSiblings != null) {
                    node.mSiblings = new ArrayList<Node>(this.mSiblings);
                }
                if (this.mParents != null) {
                    node.mParents = new ArrayList<Node>(this.mParents);
                }
                node.mEnded = false;
                return node;
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError();
            }
        }

        private final void $$robo$$android_animation_AnimatorSet_Node$addChild(Node node) {
            if (this.mChildNodes == null) {
                this.mChildNodes = new ArrayList();
            }
            if (!this.mChildNodes.contains(node)) {
                this.mChildNodes.add(node);
                node.addParent(this);
            }
        }

        private final void $$robo$$android_animation_AnimatorSet_Node$addSibling(Node node) {
            if (this.mSiblings == null) {
                this.mSiblings = new ArrayList();
            }
            if (!this.mSiblings.contains(node)) {
                this.mSiblings.add(node);
                node.addSibling(this);
            }
        }

        private final void $$robo$$android_animation_AnimatorSet_Node$addParent(Node node) {
            if (this.mParents == null) {
                this.mParents = new ArrayList();
            }
            if (!this.mParents.contains(node)) {
                this.mParents.add(node);
                node.addChild(this);
            }
        }

        private final void $$robo$$android_animation_AnimatorSet_Node$addParents(ArrayList<Node> parents) {
            if (parents == null) {
                return;
            }
            int size = parents.size();
            for (int i = 0; i < size; ++i) {
                this.addParent(parents.get(i));
            }
        }

        private void __constructor__(Animator animator2) {
            this.$$robo$$android_animation_AnimatorSet_Node$__constructor__(animator2);
        }

        public Node(Animator animator2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_AnimatorSet_Node$__constructor__(android.animation.Animator ), 0, this, animator2);
        }

        public Node clone() {
            return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_animation_AnimatorSet_Node$clone(), 0, this);
        }

        void addChild(Node node) {
            InvokeDynamicSupport.bootstrap("addChild", $$robo$$android_animation_AnimatorSet_Node$addChild(android.animation.AnimatorSet$Node ), 0, this, node);
        }

        public void addSibling(Node node) {
            InvokeDynamicSupport.bootstrap("addSibling", $$robo$$android_animation_AnimatorSet_Node$addSibling(android.animation.AnimatorSet$Node ), 0, this, node);
        }

        public void addParent(Node node) {
            InvokeDynamicSupport.bootstrap("addParent", $$robo$$android_animation_AnimatorSet_Node$addParent(android.animation.AnimatorSet$Node ), 0, this, node);
        }

        public void addParents(ArrayList<Node> arrayList) {
            InvokeDynamicSupport.bootstrap("addParents", $$robo$$android_animation_AnimatorSet_Node$addParents(java.util.ArrayList<android.animation.AnimatorSet$Node> ), 0, this, arrayList);
        }

        public /* synthetic */ Node() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Node)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class AnimatorSetListener
    implements Animator.AnimatorListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private AnimatorSet mAnimatorSet;

        private void $$robo$$android_animation_AnimatorSet_AnimatorSetListener$__constructor__(AnimatorSet animatorSet) {
            this.mAnimatorSet = animatorSet;
        }

        private final void $$robo$$android_animation_AnimatorSet_AnimatorSetListener$onAnimationCancel(Animator animation) {
            ArrayList listeners;
            if (!this.mAnimatorSet.mTerminated && this.mAnimatorSet.mPlayingSet.size() == 0 && (listeners = this.mAnimatorSet.mListeners) != null) {
                int numListeners = listeners.size();
                for (int i = 0; i < numListeners; ++i) {
                    ((Animator.AnimatorListener)listeners.get(i)).onAnimationCancel(this.mAnimatorSet);
                }
            }
        }

        private final void $$robo$$android_animation_AnimatorSet_AnimatorSetListener$onAnimationEnd(Animator animation) {
            animation.removeListener(this);
            this.mAnimatorSet.mPlayingSet.remove(animation);
            this.mAnimatorSet.onChildAnimatorEnded(animation);
        }

        private final void $$robo$$android_animation_AnimatorSet_AnimatorSetListener$onAnimationRepeat(Animator animation) {
        }

        private final void $$robo$$android_animation_AnimatorSet_AnimatorSetListener$onAnimationStart(Animator animation) {
        }

        private void __constructor__(AnimatorSet animatorSet) {
            this.$$robo$$android_animation_AnimatorSet_AnimatorSetListener$__constructor__(animatorSet);
        }

        AnimatorSetListener(AnimatorSet animatorSet) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_AnimatorSet_AnimatorSetListener$__constructor__(android.animation.AnimatorSet ), 0, this, animatorSet);
        }

        @Override
        public void onAnimationCancel(Animator animator2) {
            InvokeDynamicSupport.bootstrap("onAnimationCancel", $$robo$$android_animation_AnimatorSet_AnimatorSetListener$onAnimationCancel(android.animation.Animator ), 0, this, animator2);
        }

        @Override
        public void onAnimationEnd(Animator animator2) {
            InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$android_animation_AnimatorSet_AnimatorSetListener$onAnimationEnd(android.animation.Animator ), 0, this, animator2);
        }

        @Override
        public void onAnimationRepeat(Animator animator2) {
            InvokeDynamicSupport.bootstrap("onAnimationRepeat", $$robo$$android_animation_AnimatorSet_AnimatorSetListener$onAnimationRepeat(android.animation.Animator ), 0, this, animator2);
        }

        @Override
        public void onAnimationStart(Animator animator2) {
            InvokeDynamicSupport.bootstrap("onAnimationStart", $$robo$$android_animation_AnimatorSet_AnimatorSetListener$onAnimationStart(android.animation.Animator ), 0, this, animator2);
        }

        public /* synthetic */ AnimatorSetListener() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AnimatorSetListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

