/*
 * Decompiled with CFR 0.152.
 */
package android.accessibilityservice;

import android.graphics.Path;
import android.graphics.PathMeasure;
import android.graphics.RectF;
import android.view.MotionEvent;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class GestureDescription
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int MAX_STROKE_COUNT = 10;
    private static long MAX_GESTURE_DURATION_MS = 60000L;
    private List<StrokeDescription> mStrokes;
    private float[] mTempPos;

    private static final int $$robo$$android_accessibilityservice_GestureDescription$getMaxStrokeCount() {
        return 10;
    }

    private static final long $$robo$$android_accessibilityservice_GestureDescription$getMaxGestureDuration() {
        return 60000L;
    }

    private void $$robo$$android_accessibilityservice_GestureDescription$__constructor__() {
        this.mStrokes = new ArrayList<StrokeDescription>();
        this.mTempPos = new float[2];
    }

    private void $$robo$$android_accessibilityservice_GestureDescription$__constructor__(List<StrokeDescription> strokes) {
        this.mStrokes = new ArrayList<StrokeDescription>();
        this.mTempPos = new float[2];
        this.mStrokes.addAll(strokes);
    }

    private final int $$robo$$android_accessibilityservice_GestureDescription$getStrokeCount() {
        return this.mStrokes.size();
    }

    private final StrokeDescription $$robo$$android_accessibilityservice_GestureDescription$getStroke(int index) {
        return this.mStrokes.get(index);
    }

    private final long $$robo$$android_accessibilityservice_GestureDescription$getNextKeyPointAtLeast(long offset) {
        long nextKeyPoint = Long.MAX_VALUE;
        for (int i = 0; i < this.mStrokes.size(); ++i) {
            long thisEndTime;
            long thisStartTime = this.mStrokes.get((int)i).mStartTime;
            if (thisStartTime < nextKeyPoint && thisStartTime >= offset) {
                nextKeyPoint = thisStartTime;
            }
            if ((thisEndTime = this.mStrokes.get((int)i).mEndTime) >= nextKeyPoint || thisEndTime < offset) continue;
            nextKeyPoint = thisEndTime;
        }
        return nextKeyPoint == Long.MAX_VALUE ? -1L : nextKeyPoint;
    }

    private final int $$robo$$android_accessibilityservice_GestureDescription$getPointsForTime(long time, TouchPoint[] touchPoints) {
        int numPointsFound = 0;
        for (int i = 0; i < this.mStrokes.size(); ++i) {
            StrokeDescription strokeDescription = this.mStrokes.get(i);
            if (!strokeDescription.hasPointForTime(time)) continue;
            touchPoints[numPointsFound].mPathIndex = i;
            touchPoints[numPointsFound].mIsStartOfPath = time == strokeDescription.mStartTime;
            touchPoints[numPointsFound].mIsEndOfPath = time == strokeDescription.mEndTime;
            strokeDescription.getPosForTime(time, this.mTempPos);
            touchPoints[numPointsFound].mX = Math.round(this.mTempPos[0]);
            touchPoints[numPointsFound].mY = Math.round(this.mTempPos[1]);
            ++numPointsFound;
        }
        return numPointsFound;
    }

    private static final long $$robo$$android_accessibilityservice_GestureDescription$getTotalDuration(List<StrokeDescription> paths) {
        long latestEnd = Long.MIN_VALUE;
        for (int i = 0; i < paths.size(); ++i) {
            StrokeDescription path = paths.get(i);
            latestEnd = Math.max(latestEnd, path.mEndTime);
        }
        return Math.max(latestEnd, 0L);
    }

    private /* synthetic */ void $$robo$$android_accessibilityservice_GestureDescription$__constructor__(List x0, 1 x1) {
    }

    public static int getMaxStrokeCount() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getMaxStrokeCount", $$robo$$android_accessibilityservice_GestureDescription$getMaxStrokeCount(), 0);
    }

    public static long getMaxGestureDuration() {
        return (long)InvokeDynamicSupport.bootstrapStatic("getMaxGestureDuration", $$robo$$android_accessibilityservice_GestureDescription$getMaxGestureDuration(), 0);
    }

    private void __constructor__() {
        this.$$robo$$android_accessibilityservice_GestureDescription$__constructor__();
    }

    private GestureDescription() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accessibilityservice_GestureDescription$__constructor__(), 0, this);
    }

    private void __constructor__(List<StrokeDescription> list) {
        this.$$robo$$android_accessibilityservice_GestureDescription$__constructor__(list);
    }

    private GestureDescription(List<StrokeDescription> list) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accessibilityservice_GestureDescription$__constructor__(java.util.List<android.accessibilityservice.GestureDescription$StrokeDescription> ), 0, this, list);
    }

    public int getStrokeCount() {
        return (int)InvokeDynamicSupport.bootstrap("getStrokeCount", $$robo$$android_accessibilityservice_GestureDescription$getStrokeCount(), 0, this);
    }

    public StrokeDescription getStroke(int n) {
        return InvokeDynamicSupport.bootstrap("getStroke", $$robo$$android_accessibilityservice_GestureDescription$getStroke(int ), 0, this, n);
    }

    private long getNextKeyPointAtLeast(long l) {
        return (long)InvokeDynamicSupport.bootstrap("getNextKeyPointAtLeast", $$robo$$android_accessibilityservice_GestureDescription$getNextKeyPointAtLeast(long ), 0, this, l);
    }

    private int getPointsForTime(long l, TouchPoint[] touchPointArray) {
        return (int)InvokeDynamicSupport.bootstrap("getPointsForTime", $$robo$$android_accessibilityservice_GestureDescription$getPointsForTime(long android.accessibilityservice.GestureDescription$TouchPoint[] ), 0, this, l, touchPointArray);
    }

    private static long getTotalDuration(List<StrokeDescription> list) {
        return (long)InvokeDynamicSupport.bootstrapStatic("getTotalDuration", $$robo$$android_accessibilityservice_GestureDescription$getTotalDuration(java.util.List<android.accessibilityservice.GestureDescription$StrokeDescription> ), 0, list);
    }

    private /* synthetic */ void __constructor__(List list, 1 var2_2) {
        this.$$robo$$android_accessibilityservice_GestureDescription$__constructor__(list, var2_2);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GestureDescription)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class MotionEventGenerator
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int EVENT_META_STATE = 0;
        private static int EVENT_BUTTON_STATE = 0;
        private static int EVENT_DEVICE_ID = 0;
        private static int EVENT_EDGE_FLAGS = 0;
        private static int EVENT_SOURCE = 4098;
        private static int EVENT_FLAGS = 0;
        private static float EVENT_X_PRECISION = 1.0f;
        private static float EVENT_Y_PRECISION = 1.0f;
        private static TouchPoint[] sCurrentTouchPoints;
        private static TouchPoint[] sLastTouchPoints;
        private static MotionEvent.PointerCoords[] sPointerCoords;
        private static MotionEvent.PointerProperties[] sPointerProps;

        private void $$robo$$android_accessibilityservice_GestureDescription_MotionEventGenerator$__constructor__() {
        }

        private static final List<MotionEvent> $$robo$$android_accessibilityservice_GestureDescription_MotionEventGenerator$getMotionEventsFromGestureDescription(GestureDescription description, int sampleTimeMs) {
            ArrayList<MotionEvent> motionEvents = new ArrayList<MotionEvent>();
            TouchPoint[] currentTouchPoints = MotionEventGenerator.getCurrentTouchPoints(description.getStrokeCount());
            int lastTouchPointSize = 0;
            TouchPoint[] lastTouchPoints = MotionEventGenerator.getLastTouchPoints(description.getStrokeCount());
            long timeSinceGestureStart = 0L;
            long nextKeyPointTime = description.getNextKeyPointAtLeast(timeSinceGestureStart);
            while (nextKeyPointTime >= 0L) {
                timeSinceGestureStart = lastTouchPointSize == 0 ? nextKeyPointTime : Math.min(nextKeyPointTime, timeSinceGestureStart + (long)sampleTimeMs);
                int currentTouchPointSize = description.getPointsForTime(timeSinceGestureStart, currentTouchPoints);
                MotionEventGenerator.appendMoveEventIfNeeded(motionEvents, lastTouchPoints, lastTouchPointSize, currentTouchPoints, currentTouchPointSize, timeSinceGestureStart);
                lastTouchPointSize = MotionEventGenerator.appendUpEvents(motionEvents, lastTouchPoints, lastTouchPointSize, currentTouchPoints, currentTouchPointSize, timeSinceGestureStart);
                lastTouchPointSize = MotionEventGenerator.appendDownEvents(motionEvents, lastTouchPoints, lastTouchPointSize, currentTouchPoints, currentTouchPointSize, timeSinceGestureStart);
                nextKeyPointTime = description.getNextKeyPointAtLeast(timeSinceGestureStart + 1L);
            }
            return motionEvents;
        }

        private static final TouchPoint[] $$robo$$android_accessibilityservice_GestureDescription_MotionEventGenerator$getCurrentTouchPoints(int requiredCapacity) {
            if (sCurrentTouchPoints == null || sCurrentTouchPoints.length < requiredCapacity) {
                sCurrentTouchPoints = new TouchPoint[requiredCapacity];
                for (int i = 0; i < requiredCapacity; ++i) {
                    MotionEventGenerator.sCurrentTouchPoints[i] = new TouchPoint();
                }
            }
            return sCurrentTouchPoints;
        }

        private static final TouchPoint[] $$robo$$android_accessibilityservice_GestureDescription_MotionEventGenerator$getLastTouchPoints(int requiredCapacity) {
            if (sLastTouchPoints == null || sLastTouchPoints.length < requiredCapacity) {
                sLastTouchPoints = new TouchPoint[requiredCapacity];
                for (int i = 0; i < requiredCapacity; ++i) {
                    MotionEventGenerator.sLastTouchPoints[i] = new TouchPoint();
                }
            }
            return sLastTouchPoints;
        }

        private static final MotionEvent.PointerCoords[] $$robo$$android_accessibilityservice_GestureDescription_MotionEventGenerator$getPointerCoords(int requiredCapacity) {
            if (sPointerCoords == null || sPointerCoords.length < requiredCapacity) {
                sPointerCoords = new MotionEvent.PointerCoords[requiredCapacity];
                for (int i = 0; i < requiredCapacity; ++i) {
                    MotionEventGenerator.sPointerCoords[i] = new MotionEvent.PointerCoords();
                }
            }
            return sPointerCoords;
        }

        private static final MotionEvent.PointerProperties[] $$robo$$android_accessibilityservice_GestureDescription_MotionEventGenerator$getPointerProps(int requiredCapacity) {
            if (sPointerProps == null || sPointerProps.length < requiredCapacity) {
                sPointerProps = new MotionEvent.PointerProperties[requiredCapacity];
                for (int i = 0; i < requiredCapacity; ++i) {
                    MotionEventGenerator.sPointerProps[i] = new MotionEvent.PointerProperties();
                }
            }
            return sPointerProps;
        }

        private static final void $$robo$$android_accessibilityservice_GestureDescription_MotionEventGenerator$appendMoveEventIfNeeded(List<MotionEvent> motionEvents, TouchPoint[] lastTouchPoints, int lastTouchPointsSize, TouchPoint[] currentTouchPoints, int currentTouchPointsSize, long currentTime) {
            boolean moveFound = false;
            for (int i = 0; i < currentTouchPointsSize; ++i) {
                int lastPointsIndex = MotionEventGenerator.findPointByPathIndex(lastTouchPoints, lastTouchPointsSize, currentTouchPoints[i].mPathIndex);
                if (lastPointsIndex < 0) continue;
                moveFound |= lastTouchPoints[lastPointsIndex].mX != currentTouchPoints[i].mX || lastTouchPoints[lastPointsIndex].mY != currentTouchPoints[i].mY;
                lastTouchPoints[lastPointsIndex].copyFrom(currentTouchPoints[i]);
            }
            if (moveFound) {
                long downTime = motionEvents.get(motionEvents.size() - 1).getDownTime();
                motionEvents.add(MotionEventGenerator.obtainMotionEvent(downTime, currentTime, 2, lastTouchPoints, lastTouchPointsSize));
            }
        }

        private static final int $$robo$$android_accessibilityservice_GestureDescription_MotionEventGenerator$appendUpEvents(List<MotionEvent> motionEvents, TouchPoint[] lastTouchPoints, int lastTouchPointsSize, TouchPoint[] currentTouchPoints, int currentTouchPointsSize, long currentTime) {
            for (int i = 0; i < currentTouchPointsSize; ++i) {
                int indexOfUpEvent;
                if (!currentTouchPoints[i].mIsEndOfPath || (indexOfUpEvent = MotionEventGenerator.findPointByPathIndex(lastTouchPoints, lastTouchPointsSize, currentTouchPoints[i].mPathIndex)) < 0) continue;
                long downTime = motionEvents.get(motionEvents.size() - 1).getDownTime();
                int action = lastTouchPointsSize == 1 ? 1 : 6;
                motionEvents.add(MotionEventGenerator.obtainMotionEvent(downTime, currentTime, action |= indexOfUpEvent << 8, lastTouchPoints, lastTouchPointsSize));
                for (int j = indexOfUpEvent; j < lastTouchPointsSize - 1; ++j) {
                    lastTouchPoints[j].copyFrom(lastTouchPoints[j + 1]);
                }
                --lastTouchPointsSize;
            }
            return lastTouchPointsSize;
        }

        private static final int $$robo$$android_accessibilityservice_GestureDescription_MotionEventGenerator$appendDownEvents(List<MotionEvent> motionEvents, TouchPoint[] lastTouchPoints, int lastTouchPointsSize, TouchPoint[] currentTouchPoints, int currentTouchPointsSize, long currentTime) {
            for (int i = 0; i < currentTouchPointsSize; ++i) {
                if (!currentTouchPoints[i].mIsStartOfPath) continue;
                lastTouchPoints[lastTouchPointsSize++].copyFrom(currentTouchPoints[i]);
                int action = lastTouchPointsSize == 1 ? 0 : 5;
                long downTime = action == 0 ? currentTime : motionEvents.get(motionEvents.size() - 1).getDownTime();
                motionEvents.add(MotionEventGenerator.obtainMotionEvent(downTime, currentTime, action |= i << 8, lastTouchPoints, lastTouchPointsSize));
            }
            return lastTouchPointsSize;
        }

        private static final MotionEvent $$robo$$android_accessibilityservice_GestureDescription_MotionEventGenerator$obtainMotionEvent(long downTime, long eventTime, int action, TouchPoint[] touchPoints, int touchPointsSize) {
            MotionEvent.PointerCoords[] pointerCoords = MotionEventGenerator.getPointerCoords(touchPointsSize);
            MotionEvent.PointerProperties[] pointerProperties = MotionEventGenerator.getPointerProps(touchPointsSize);
            for (int i = 0; i < touchPointsSize; ++i) {
                pointerProperties[i].id = touchPoints[i].mPathIndex;
                pointerProperties[i].toolType = 0;
                pointerCoords[i].clear();
                pointerCoords[i].pressure = 1.0f;
                pointerCoords[i].size = 1.0f;
                pointerCoords[i].x = touchPoints[i].mX;
                pointerCoords[i].y = touchPoints[i].mY;
            }
            return MotionEvent.obtain(downTime, eventTime, action, touchPointsSize, pointerProperties, pointerCoords, 0, 0, 1.0f, 1.0f, 0, 0, 4098, 0);
        }

        private static final int $$robo$$android_accessibilityservice_GestureDescription_MotionEventGenerator$findPointByPathIndex(TouchPoint[] touchPoints, int touchPointsSize, int pathIndex) {
            for (int i = 0; i < touchPointsSize; ++i) {
                if (touchPoints[i].mPathIndex != pathIndex) continue;
                return i;
            }
            return -1;
        }

        private void __constructor__() {
            this.$$robo$$android_accessibilityservice_GestureDescription_MotionEventGenerator$__constructor__();
        }

        MotionEventGenerator() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accessibilityservice_GestureDescription_MotionEventGenerator$__constructor__(), 0, this);
        }

        static List<MotionEvent> getMotionEventsFromGestureDescription(GestureDescription gestureDescription, int n) {
            return InvokeDynamicSupport.bootstrapStatic("getMotionEventsFromGestureDescription", $$robo$$android_accessibilityservice_GestureDescription_MotionEventGenerator$getMotionEventsFromGestureDescription(android.accessibilityservice.GestureDescription int ), 0, (GestureDescription)gestureDescription, (int)n);
        }

        private static TouchPoint[] getCurrentTouchPoints(int n) {
            return InvokeDynamicSupport.bootstrapStatic("getCurrentTouchPoints", $$robo$$android_accessibilityservice_GestureDescription_MotionEventGenerator$getCurrentTouchPoints(int ), 0, (int)n);
        }

        private static TouchPoint[] getLastTouchPoints(int n) {
            return InvokeDynamicSupport.bootstrapStatic("getLastTouchPoints", $$robo$$android_accessibilityservice_GestureDescription_MotionEventGenerator$getLastTouchPoints(int ), 0, (int)n);
        }

        private static MotionEvent.PointerCoords[] getPointerCoords(int n) {
            return InvokeDynamicSupport.bootstrapStatic("getPointerCoords", $$robo$$android_accessibilityservice_GestureDescription_MotionEventGenerator$getPointerCoords(int ), 0, (int)n);
        }

        private static MotionEvent.PointerProperties[] getPointerProps(int n) {
            return InvokeDynamicSupport.bootstrapStatic("getPointerProps", $$robo$$android_accessibilityservice_GestureDescription_MotionEventGenerator$getPointerProps(int ), 0, (int)n);
        }

        private static void appendMoveEventIfNeeded(List<MotionEvent> list, TouchPoint[] touchPointArray, int n, TouchPoint[] touchPointArray2, int n2, long l) {
            InvokeDynamicSupport.bootstrapStatic("appendMoveEventIfNeeded", $$robo$$android_accessibilityservice_GestureDescription_MotionEventGenerator$appendMoveEventIfNeeded(java.util.List<android.view.MotionEvent> android.accessibilityservice.GestureDescription$TouchPoint[] int android.accessibilityservice.GestureDescription$TouchPoint[] int long ), 0, list, (TouchPoint[])touchPointArray, (int)n, (TouchPoint[])touchPointArray2, (int)n2, (long)l);
        }

        private static int appendUpEvents(List<MotionEvent> list, TouchPoint[] touchPointArray, int n, TouchPoint[] touchPointArray2, int n2, long l) {
            return (int)InvokeDynamicSupport.bootstrapStatic("appendUpEvents", $$robo$$android_accessibilityservice_GestureDescription_MotionEventGenerator$appendUpEvents(java.util.List<android.view.MotionEvent> android.accessibilityservice.GestureDescription$TouchPoint[] int android.accessibilityservice.GestureDescription$TouchPoint[] int long ), 0, list, (TouchPoint[])touchPointArray, (int)n, (TouchPoint[])touchPointArray2, (int)n2, (long)l);
        }

        private static int appendDownEvents(List<MotionEvent> list, TouchPoint[] touchPointArray, int n, TouchPoint[] touchPointArray2, int n2, long l) {
            return (int)InvokeDynamicSupport.bootstrapStatic("appendDownEvents", $$robo$$android_accessibilityservice_GestureDescription_MotionEventGenerator$appendDownEvents(java.util.List<android.view.MotionEvent> android.accessibilityservice.GestureDescription$TouchPoint[] int android.accessibilityservice.GestureDescription$TouchPoint[] int long ), 0, list, (TouchPoint[])touchPointArray, (int)n, (TouchPoint[])touchPointArray2, (int)n2, (long)l);
        }

        private static MotionEvent obtainMotionEvent(long l, long l2, int n, TouchPoint[] touchPointArray, int n2) {
            return InvokeDynamicSupport.bootstrapStatic("obtainMotionEvent", $$robo$$android_accessibilityservice_GestureDescription_MotionEventGenerator$obtainMotionEvent(long long int android.accessibilityservice.GestureDescription$TouchPoint[] int ), 0, (long)l, (long)l2, (int)n, (TouchPoint[])touchPointArray, (int)n2);
        }

        private static int findPointByPathIndex(TouchPoint[] touchPointArray, int n, int n2) {
            return (int)InvokeDynamicSupport.bootstrapStatic("findPointByPathIndex", $$robo$$android_accessibilityservice_GestureDescription_MotionEventGenerator$findPointByPathIndex(android.accessibilityservice.GestureDescription$TouchPoint[] int int ), 0, (TouchPoint[])touchPointArray, (int)n, (int)n2);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MotionEventGenerator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class TouchPoint
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int mPathIndex;
        boolean mIsStartOfPath;
        boolean mIsEndOfPath;
        float mX;
        float mY;

        private void $$robo$$android_accessibilityservice_GestureDescription_TouchPoint$__constructor__() {
        }

        private final void $$robo$$android_accessibilityservice_GestureDescription_TouchPoint$copyFrom(TouchPoint other) {
            this.mPathIndex = other.mPathIndex;
            this.mIsStartOfPath = other.mIsStartOfPath;
            this.mIsEndOfPath = other.mIsEndOfPath;
            this.mX = other.mX;
            this.mY = other.mY;
        }

        private /* synthetic */ void $$robo$$android_accessibilityservice_GestureDescription_TouchPoint$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_accessibilityservice_GestureDescription_TouchPoint$__constructor__();
        }

        private TouchPoint() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accessibilityservice_GestureDescription_TouchPoint$__constructor__(), 0, this);
        }

        void copyFrom(TouchPoint touchPoint) {
            InvokeDynamicSupport.bootstrap("copyFrom", $$robo$$android_accessibilityservice_GestureDescription_TouchPoint$copyFrom(android.accessibilityservice.GestureDescription$TouchPoint ), 0, this, touchPoint);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_accessibilityservice_GestureDescription_TouchPoint$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TouchPoint)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class StrokeDescription
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        Path mPath;
        long mStartTime;
        long mEndTime;
        private float mTimeToLengthConversion;
        private PathMeasure mPathMeasure;
        float[] mTapLocation;

        private void $$robo$$android_accessibilityservice_GestureDescription_StrokeDescription$__constructor__(Path path, long startTime, long duration) {
            if (duration <= 0L) {
                throw new IllegalArgumentException("Duration must be positive");
            }
            if (startTime < 0L) {
                throw new IllegalArgumentException("Start time must not be negative");
            }
            RectF bounds = new RectF();
            path.computeBounds(bounds, false);
            if (bounds.bottom < 0.0f || bounds.top < 0.0f || bounds.right < 0.0f || bounds.left < 0.0f) {
                throw new IllegalArgumentException("Path bounds must not be negative");
            }
            if (path.isEmpty()) {
                throw new IllegalArgumentException("Path is empty");
            }
            this.mPath = new Path(path);
            this.mPathMeasure = new PathMeasure(path, false);
            if (this.mPathMeasure.getLength() == 0.0f) {
                Path tempPath = new Path(path);
                tempPath.lineTo(-1.0f, -1.0f);
                this.mTapLocation = new float[2];
                PathMeasure pathMeasure = new PathMeasure(tempPath, false);
                pathMeasure.getPosTan(0.0f, this.mTapLocation, null);
            }
            if (this.mPathMeasure.nextContour()) {
                throw new IllegalArgumentException("Path has more than one contour");
            }
            this.mPathMeasure.setPath(this.mPath, false);
            this.mStartTime = startTime;
            this.mEndTime = startTime + duration;
            this.mTimeToLengthConversion = this.getLength() / (float)duration;
        }

        private final Path $$robo$$android_accessibilityservice_GestureDescription_StrokeDescription$getPath() {
            return new Path(this.mPath);
        }

        private final long $$robo$$android_accessibilityservice_GestureDescription_StrokeDescription$getStartTime() {
            return this.mStartTime;
        }

        private final long $$robo$$android_accessibilityservice_GestureDescription_StrokeDescription$getDuration() {
            return this.mEndTime - this.mStartTime;
        }

        private final float $$robo$$android_accessibilityservice_GestureDescription_StrokeDescription$getLength() {
            return this.mPathMeasure.getLength();
        }

        private final boolean $$robo$$android_accessibilityservice_GestureDescription_StrokeDescription$getPosForTime(long time, float[] pos) {
            if (this.mTapLocation != null) {
                pos[0] = this.mTapLocation[0];
                pos[1] = this.mTapLocation[1];
                return true;
            }
            if (time == this.mEndTime) {
                return this.mPathMeasure.getPosTan(this.getLength(), pos, null);
            }
            float length = this.mTimeToLengthConversion * (float)(time - this.mStartTime);
            return this.mPathMeasure.getPosTan(length, pos, null);
        }

        private final boolean $$robo$$android_accessibilityservice_GestureDescription_StrokeDescription$hasPointForTime(long time) {
            return time >= this.mStartTime && time <= this.mEndTime;
        }

        private void __constructor__(Path path, long l, long l2) {
            this.$$robo$$android_accessibilityservice_GestureDescription_StrokeDescription$__constructor__(path, l, l2);
        }

        public StrokeDescription(Path path, long l, long l2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accessibilityservice_GestureDescription_StrokeDescription$__constructor__(android.graphics.Path long long ), 0, this, path, l, l2);
        }

        public Path getPath() {
            return InvokeDynamicSupport.bootstrap("getPath", $$robo$$android_accessibilityservice_GestureDescription_StrokeDescription$getPath(), 0, this);
        }

        public long getStartTime() {
            return (long)InvokeDynamicSupport.bootstrap("getStartTime", $$robo$$android_accessibilityservice_GestureDescription_StrokeDescription$getStartTime(), 0, this);
        }

        public long getDuration() {
            return (long)InvokeDynamicSupport.bootstrap("getDuration", $$robo$$android_accessibilityservice_GestureDescription_StrokeDescription$getDuration(), 0, this);
        }

        float getLength() {
            return (float)InvokeDynamicSupport.bootstrap("getLength", $$robo$$android_accessibilityservice_GestureDescription_StrokeDescription$getLength(), 0, this);
        }

        boolean getPosForTime(long l, float[] fArray) {
            return (boolean)InvokeDynamicSupport.bootstrap("getPosForTime", $$robo$$android_accessibilityservice_GestureDescription_StrokeDescription$getPosForTime(long float[] ), 0, this, l, fArray);
        }

        boolean hasPointForTime(long l) {
            return (boolean)InvokeDynamicSupport.bootstrap("hasPointForTime", $$robo$$android_accessibilityservice_GestureDescription_StrokeDescription$hasPointForTime(long ), 0, this, l);
        }

        public /* synthetic */ StrokeDescription() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StrokeDescription)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private List<StrokeDescription> mStrokes;

        private void $$robo$$android_accessibilityservice_GestureDescription_Builder$__constructor__() {
            this.mStrokes = new ArrayList<StrokeDescription>();
        }

        private final Builder $$robo$$android_accessibilityservice_GestureDescription_Builder$addStroke(StrokeDescription strokeDescription) {
            if (this.mStrokes.size() >= 10) {
                throw new IllegalStateException("Attempting to add too many strokes to a gesture");
            }
            this.mStrokes.add(strokeDescription);
            if (GestureDescription.getTotalDuration(this.mStrokes) > 60000L) {
                this.mStrokes.remove(strokeDescription);
                throw new IllegalStateException("Gesture would exceed maximum duration with new stroke");
            }
            return this;
        }

        private final GestureDescription $$robo$$android_accessibilityservice_GestureDescription_Builder$build() {
            if (this.mStrokes.size() == 0) {
                throw new IllegalStateException("Gestures must have at least one stroke");
            }
            return new GestureDescription(this.mStrokes);
        }

        private void __constructor__() {
            this.$$robo$$android_accessibilityservice_GestureDescription_Builder$__constructor__();
        }

        public Builder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accessibilityservice_GestureDescription_Builder$__constructor__(), 0, this);
        }

        public Builder addStroke(StrokeDescription strokeDescription) {
            return InvokeDynamicSupport.bootstrap("addStroke", $$robo$$android_accessibilityservice_GestureDescription_Builder$addStroke(android.accessibilityservice.GestureDescription$StrokeDescription ), 0, this, strokeDescription);
        }

        public GestureDescription build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_accessibilityservice_GestureDescription_Builder$build(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

