/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.bsi.longlong;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import org.roaringbitmap.bsi.BitmapSliceIndex;
import org.roaringbitmap.bsi.Pair;
import org.roaringbitmap.bsi.WritableUtils;
import org.roaringbitmap.longlong.Roaring64Bitmap;

public class Roaring64BitmapSliceIndex {
    private long maxValue;
    private long minValue;
    private Roaring64Bitmap[] bA;
    private Roaring64Bitmap ebM;
    private Boolean runOptimized = false;

    public Roaring64BitmapSliceIndex(long minValue, long maxValue) {
        if (minValue < 0L) {
            throw new IllegalArgumentException("Values should be non-negative");
        }
        this.bA = new Roaring64Bitmap[64 - Long.numberOfLeadingZeros(maxValue)];
        for (int i = 0; i < this.bA.length; ++i) {
            this.bA[i] = new Roaring64Bitmap();
        }
        this.ebM = new Roaring64Bitmap();
    }

    public Roaring64BitmapSliceIndex() {
        this(0L, 0L);
    }

    public void add(Roaring64BitmapSliceIndex otherBsi) {
        if (null == otherBsi || otherBsi.ebM.isEmpty()) {
            return;
        }
        this.ebM.or(otherBsi.ebM);
        if (otherBsi.bitCount() > this.bitCount()) {
            this.grow(otherBsi.bitCount());
        }
        for (int i = 0; i < otherBsi.bitCount(); ++i) {
            this.addDigit(otherBsi.bA[i], i);
        }
        this.minValue = this.minValue();
        this.maxValue = this.maxValue();
    }

    private void addDigit(Roaring64Bitmap foundSet, int i) {
        Roaring64Bitmap carry = Roaring64Bitmap.and((Roaring64Bitmap)this.bA[i], (Roaring64Bitmap)foundSet);
        this.bA[i].xor(foundSet);
        if (!carry.isEmpty()) {
            if (i + 1 >= this.bitCount()) {
                this.grow(this.bitCount() + 1);
            }
            this.addDigit(carry, i + 1);
        }
    }

    private long minValue() {
        if (this.ebM.isEmpty()) {
            return 0L;
        }
        Roaring64Bitmap minValuesId = this.ebM;
        for (int i = this.bA.length - 1; i >= 0; --i) {
            Roaring64Bitmap tmp = Roaring64Bitmap.andNot((Roaring64Bitmap)minValuesId, (Roaring64Bitmap)this.bA[i]);
            if (tmp.isEmpty()) continue;
            minValuesId = tmp;
        }
        return this.valueAt(minValuesId.first());
    }

    private long maxValue() {
        if (this.ebM.isEmpty()) {
            return 0L;
        }
        Roaring64Bitmap maxValuesId = this.ebM;
        for (int i = this.bA.length - 1; i >= 0; --i) {
            Roaring64Bitmap tmp = Roaring64Bitmap.and((Roaring64Bitmap)maxValuesId, (Roaring64Bitmap)this.bA[i]);
            if (tmp.isEmpty()) continue;
            maxValuesId = tmp;
        }
        return this.valueAt(maxValuesId.first());
    }

    private long valueAt(long columnId) {
        int value = 0;
        for (int i = 0; i < this.bitCount(); ++i) {
            if (!this.bA[i].contains(columnId)) continue;
            value |= 1 << i;
        }
        return value;
    }

    public void runOptimize() {
        this.ebM.runOptimize();
        for (Roaring64Bitmap integers : this.bA) {
            integers.runOptimize();
        }
        this.runOptimized = true;
    }

    public boolean hasRunCompression() {
        return this.runOptimized;
    }

    public Roaring64Bitmap getExistenceBitmap() {
        return this.ebM;
    }

    public int bitCount() {
        return this.bA.length;
    }

    public long getLongCardinality() {
        return this.ebM.getLongCardinality();
    }

    public Pair<Long, Boolean> getValue(long columnId) {
        boolean exists = this.ebM.contains(columnId);
        if (!exists) {
            return Pair.newPair(0L, false);
        }
        return Pair.newPair(this.valueAt(columnId), true);
    }

    private void clear() {
        this.maxValue = 0L;
        this.minValue = 0L;
        this.ebM = null;
        this.bA = null;
    }

    public void serialize(DataOutput output) throws IOException {
        WritableUtils.writeVLong(output, this.minValue);
        WritableUtils.writeVLong(output, this.maxValue);
        output.writeBoolean(this.runOptimized);
        this.ebM.serialize(output);
        WritableUtils.writeVInt(output, this.bA.length);
        for (Roaring64Bitmap rb : this.bA) {
            rb.serialize(output);
        }
    }

    public void deserialize(DataInput in) throws IOException {
        this.clear();
        this.minValue = WritableUtils.readVInt(in);
        this.maxValue = WritableUtils.readVInt(in);
        this.runOptimized = in.readBoolean();
        Roaring64Bitmap ebm = new Roaring64Bitmap();
        ebm.deserialize(in);
        this.ebM = ebm;
        int bitDepth = WritableUtils.readVInt(in);
        Roaring64Bitmap[] ba = new Roaring64Bitmap[bitDepth];
        for (int i = 0; i < bitDepth; ++i) {
            Roaring64Bitmap rb = new Roaring64Bitmap();
            rb.deserialize(in);
            ba[i] = rb;
        }
        this.bA = ba;
    }

    public void serialize(ByteBuffer buffer) throws IOException {
        buffer.putLong(this.minValue);
        buffer.putLong(this.maxValue);
        buffer.put(this.runOptimized != false ? (byte)1 : 0);
        this.ebM.serialize(buffer);
        buffer.putInt(this.bA.length);
        for (Roaring64Bitmap rb : this.bA) {
            rb.serialize(buffer);
        }
    }

    public void deserialize(ByteBuffer buffer) throws IOException {
        this.clear();
        this.minValue = buffer.getLong();
        this.maxValue = buffer.getLong();
        this.runOptimized = buffer.get() == 1;
        Roaring64Bitmap ebm = new Roaring64Bitmap();
        ebm.deserialize(buffer);
        this.ebM = ebm;
        buffer.position(buffer.position() + ebm.getSizeInBytes());
        int bitDepth = buffer.getInt();
        Roaring64Bitmap[] ba = new Roaring64Bitmap[bitDepth];
        for (int i = 0; i < bitDepth; ++i) {
            Roaring64Bitmap rb = new Roaring64Bitmap();
            rb.deserialize(buffer);
            ba[i] = rb;
            buffer.position(buffer.position() + rb.getSizeInBytes());
        }
        this.bA = ba;
    }

    public int serializedSizeInBytes() {
        int size = 0;
        for (Roaring64Bitmap rb : this.bA) {
            size += rb.getSizeInBytes();
        }
        return 21 + this.ebM.getSizeInBytes() + size;
    }

    public boolean valueExist(Long columnId) {
        return this.ebM.contains(columnId.longValue());
    }

    public void setValue(long columnId, long value) {
        this.ensureCapacityInternal(value, value);
        this.setValueInternal(columnId, value);
    }

    private void setValueInternal(long columnId, long value) {
        for (int i = 0; i < this.bitCount(); ++i) {
            if ((value & 1L << i) > 0L) {
                this.bA[i].add(new long[]{columnId});
                continue;
            }
            this.bA[i].remove(columnId);
        }
        this.ebM.add(new long[]{columnId});
    }

    private void ensureCapacityInternal(long minValue, long maxValue) {
        if (this.ebM.isEmpty()) {
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.grow(Long.toBinaryString(maxValue).length());
        } else if (this.minValue > minValue) {
            this.minValue = minValue;
        } else if (this.maxValue < maxValue) {
            this.maxValue = maxValue;
            this.grow(Long.toBinaryString(maxValue).length());
        }
    }

    private void grow(int newBitDepth) {
        int oldBitDepth = this.bA.length;
        if (oldBitDepth >= newBitDepth) {
            return;
        }
        Roaring64Bitmap[] newBA = new Roaring64Bitmap[newBitDepth];
        if (oldBitDepth != 0) {
            System.arraycopy(this.bA, 0, newBA, 0, oldBitDepth);
        }
        for (int i = newBitDepth - 1; i >= oldBitDepth; --i) {
            newBA[i] = new Roaring64Bitmap();
            if (!this.runOptimized.booleanValue()) continue;
            newBA[i].runOptimize();
        }
        this.bA = newBA;
    }

    public void setValues(List<Pair<Long, Long>> values) {
        long maxValue = values.stream().mapToLong(Pair::getRight).filter(Objects::nonNull).max().getAsLong();
        long minValue = values.stream().mapToLong(Pair::getRight).filter(Objects::nonNull).min().getAsLong();
        this.ensureCapacityInternal(minValue, maxValue);
        for (Pair<Long, Long> pair : values) {
            this.setValueInternal(pair.getKey(), pair.getValue());
        }
    }

    public void merge(Roaring64BitmapSliceIndex otherBsi) {
        if (null == otherBsi || otherBsi.ebM.isEmpty()) {
            return;
        }
        if (Roaring64Bitmap.intersects((Roaring64Bitmap)this.ebM, (Roaring64Bitmap)otherBsi.ebM)) {
            throw new IllegalArgumentException("merge can be used only in bsiA  bsiB  is null");
        }
        int bitDepth = Integer.max(this.bitCount(), otherBsi.bitCount());
        Roaring64Bitmap[] newBA = new Roaring64Bitmap[bitDepth];
        for (int i = 0; i < bitDepth; ++i) {
            Roaring64Bitmap current = i < this.bA.length ? this.bA[i] : new Roaring64Bitmap();
            Roaring64Bitmap other = i < otherBsi.bA.length ? otherBsi.bA[i] : new Roaring64Bitmap();
            newBA[i] = Roaring64Bitmap.or((Roaring64Bitmap)current, (Roaring64Bitmap)other);
            if (!this.runOptimized.booleanValue() && !otherBsi.runOptimized.booleanValue()) continue;
            newBA[i].runOptimize();
        }
        this.bA = newBA;
        this.ebM.or(otherBsi.ebM);
        this.runOptimized = this.runOptimized != false || otherBsi.runOptimized != false;
        this.maxValue = Long.max(this.maxValue, otherBsi.maxValue);
        this.minValue = Long.min(this.minValue, otherBsi.minValue);
    }

    public Roaring64BitmapSliceIndex clone() {
        Roaring64BitmapSliceIndex bitSliceIndex = new Roaring64BitmapSliceIndex();
        bitSliceIndex.minValue = this.minValue;
        bitSliceIndex.maxValue = this.maxValue;
        bitSliceIndex.ebM = this.ebM.clone();
        Roaring64Bitmap[] cloneBA = new Roaring64Bitmap[this.bitCount()];
        for (int i = 0; i < cloneBA.length; ++i) {
            cloneBA[i] = this.bA[i].clone();
        }
        bitSliceIndex.bA = cloneBA;
        bitSliceIndex.runOptimized = this.runOptimized;
        return bitSliceIndex;
    }

    private Roaring64Bitmap oNeilCompare(BitmapSliceIndex.Operation operation, long predicate, Roaring64Bitmap foundSet) {
        Roaring64Bitmap fixedFoundSet = foundSet == null ? this.ebM : foundSet;
        Roaring64Bitmap GT = new Roaring64Bitmap();
        Roaring64Bitmap LT = new Roaring64Bitmap();
        Roaring64Bitmap EQ = this.ebM;
        for (int i = this.bitCount() - 1; i >= 0; --i) {
            int bit = (int)(predicate >> i & 1L);
            if (bit == 1) {
                LT = Roaring64Bitmap.or((Roaring64Bitmap)LT, (Roaring64Bitmap)Roaring64Bitmap.andNot((Roaring64Bitmap)EQ, (Roaring64Bitmap)this.bA[i]));
                EQ = Roaring64Bitmap.and((Roaring64Bitmap)EQ, (Roaring64Bitmap)this.bA[i]);
                continue;
            }
            GT = Roaring64Bitmap.or((Roaring64Bitmap)GT, (Roaring64Bitmap)Roaring64Bitmap.and((Roaring64Bitmap)EQ, (Roaring64Bitmap)this.bA[i]));
            EQ = Roaring64Bitmap.andNot((Roaring64Bitmap)EQ, (Roaring64Bitmap)this.bA[i]);
        }
        EQ = Roaring64Bitmap.and((Roaring64Bitmap)fixedFoundSet, (Roaring64Bitmap)EQ);
        switch (operation) {
            case EQ: {
                return EQ;
            }
            case NEQ: {
                return Roaring64Bitmap.andNot((Roaring64Bitmap)fixedFoundSet, (Roaring64Bitmap)EQ);
            }
            case GT: {
                return Roaring64Bitmap.and((Roaring64Bitmap)GT, (Roaring64Bitmap)fixedFoundSet);
            }
            case LT: {
                return Roaring64Bitmap.and((Roaring64Bitmap)LT, (Roaring64Bitmap)fixedFoundSet);
            }
            case LE: {
                return Roaring64Bitmap.and((Roaring64Bitmap)Roaring64Bitmap.or((Roaring64Bitmap)LT, (Roaring64Bitmap)EQ), (Roaring64Bitmap)fixedFoundSet);
            }
            case GE: {
                return Roaring64Bitmap.and((Roaring64Bitmap)Roaring64Bitmap.or((Roaring64Bitmap)GT, (Roaring64Bitmap)EQ), (Roaring64Bitmap)fixedFoundSet);
            }
        }
        throw new IllegalArgumentException("");
    }

    public Roaring64Bitmap compare(BitmapSliceIndex.Operation operation, long startOrValue, long end, Roaring64Bitmap foundSet) {
        Roaring64Bitmap result = this.compareUsingMinMax(operation, startOrValue, end, foundSet);
        if (result != null) {
            return result;
        }
        switch (operation) {
            case EQ: {
                return this.oNeilCompare(BitmapSliceIndex.Operation.EQ, startOrValue, foundSet);
            }
            case NEQ: {
                return this.oNeilCompare(BitmapSliceIndex.Operation.NEQ, startOrValue, foundSet);
            }
            case GE: {
                return this.oNeilCompare(BitmapSliceIndex.Operation.GE, startOrValue, foundSet);
            }
            case GT: {
                return this.oNeilCompare(BitmapSliceIndex.Operation.GT, startOrValue, foundSet);
            }
            case LT: {
                return this.oNeilCompare(BitmapSliceIndex.Operation.LT, startOrValue, foundSet);
            }
            case LE: {
                return this.oNeilCompare(BitmapSliceIndex.Operation.LE, startOrValue, foundSet);
            }
            case RANGE: {
                Roaring64Bitmap left = this.oNeilCompare(BitmapSliceIndex.Operation.GE, startOrValue, foundSet);
                Roaring64Bitmap right = this.oNeilCompare(BitmapSliceIndex.Operation.LE, end, foundSet);
                return Roaring64Bitmap.and((Roaring64Bitmap)left, (Roaring64Bitmap)right);
            }
        }
        throw new IllegalArgumentException("not support operation!");
    }

    private Roaring64Bitmap compareUsingMinMax(BitmapSliceIndex.Operation operation, long startOrValue, long end, Roaring64Bitmap foundSet) {
        Roaring64Bitmap all = foundSet == null ? this.ebM.clone() : Roaring64Bitmap.and((Roaring64Bitmap)this.ebM, (Roaring64Bitmap)foundSet);
        Roaring64Bitmap empty = new Roaring64Bitmap();
        switch (operation) {
            case LT: {
                if (startOrValue > this.maxValue) {
                    return all;
                }
                if (startOrValue > this.minValue) break;
                return empty;
            }
            case LE: {
                if (startOrValue >= this.maxValue) {
                    return all;
                }
                if (startOrValue >= this.minValue) break;
                return empty;
            }
            case GT: {
                if (startOrValue < this.minValue) {
                    return all;
                }
                if (startOrValue < this.maxValue) break;
                return empty;
            }
            case GE: {
                if (startOrValue <= this.minValue) {
                    return all;
                }
                if (startOrValue <= this.maxValue) break;
                return empty;
            }
            case EQ: {
                if (this.minValue == this.maxValue && this.minValue == startOrValue) {
                    return all;
                }
                if (startOrValue >= this.minValue && startOrValue <= this.maxValue) break;
                return empty;
            }
            case NEQ: {
                if (this.minValue != this.maxValue) break;
                return this.minValue == startOrValue ? empty : all;
            }
            case RANGE: {
                if (startOrValue <= this.minValue && end >= this.maxValue) {
                    return all;
                }
                if (startOrValue <= this.maxValue && end >= this.minValue) break;
                return empty;
            }
            default: {
                return null;
            }
        }
        return null;
    }

    public Pair<Long, Long> sum(Roaring64Bitmap foundSet) {
        if (null == foundSet || foundSet.isEmpty()) {
            return Pair.newPair(0L, 0L);
        }
        long count = foundSet.getLongCardinality();
        Long sum = IntStream.range(0, this.bitCount()).mapToLong(x -> (1L << x) * Roaring64Bitmap.andCardinality((Roaring64Bitmap)this.bA[x], (Roaring64Bitmap)foundSet)).sum();
        return Pair.newPair(sum, count);
    }

    public Roaring64Bitmap topK(Roaring64Bitmap foundSet, long k) {
        if (null == foundSet || foundSet.isEmpty()) {
            return new Roaring64Bitmap();
        }
        if (k >= foundSet.getLongCardinality()) {
            return foundSet;
        }
        Roaring64Bitmap re = new Roaring64Bitmap();
        Roaring64Bitmap candidates = foundSet.clone();
        for (int x = this.bitCount() - 1; x >= 0 && !candidates.isEmpty() && k > 0L; --x) {
            long cardinality = Roaring64Bitmap.and((Roaring64Bitmap)candidates, (Roaring64Bitmap)this.bA[x]).getLongCardinality();
            if (cardinality > k) {
                candidates.and(this.bA[x]);
                continue;
            }
            re.or(Roaring64Bitmap.and((Roaring64Bitmap)candidates, (Roaring64Bitmap)this.bA[x]));
            candidates.andNot(this.bA[x]);
            k -= cardinality;
        }
        return re;
    }

    public Roaring64Bitmap transpose(Roaring64Bitmap foundSet) {
        Roaring64Bitmap re = new Roaring64Bitmap();
        Roaring64Bitmap fixedFoundSet = foundSet == null ? this.ebM : Roaring64Bitmap.and((Roaring64Bitmap)foundSet, (Roaring64Bitmap)this.ebM);
        fixedFoundSet.forEach(x -> re.add(new long[]{this.getValue(x).getKey()}));
        return re;
    }

    public Roaring64BitmapSliceIndex transposeWithCount(Roaring64Bitmap foundSet) {
        Roaring64BitmapSliceIndex re = new Roaring64BitmapSliceIndex();
        Roaring64Bitmap fixedFoundSet = foundSet == null ? this.ebM : Roaring64Bitmap.and((Roaring64Bitmap)foundSet, (Roaring64Bitmap)this.ebM);
        fixedFoundSet.forEach(x -> {
            long nk = this.getValue(x).getKey();
            if (re.valueExist(nk)) {
                re.setValue(nk, re.getValue(nk).getKey() + 1L);
            } else {
                re.setValue(nk, 1L);
            }
        });
        return re;
    }
}

