/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.bsi.buffer;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import org.roaringbitmap.bsi.BitmapSliceIndex;
import org.roaringbitmap.bsi.Pair;
import org.roaringbitmap.bsi.WritableUtils;
import org.roaringbitmap.bsi.buffer.BitSliceIndexBase;
import org.roaringbitmap.bsi.buffer.ImmutableBitSliceIndex;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class MutableBitSliceIndex
extends BitSliceIndexBase
implements BitmapSliceIndex {
    private boolean runOptimized;

    public MutableBitSliceIndex(int maxValue, int minValue, MutableRoaringBitmap[] bA, MutableRoaringBitmap ebM) {
        this.maxValue = maxValue;
        this.minValue = minValue;
        this.bA = bA;
        this.ebM = ebM;
    }

    public MutableBitSliceIndex(int minValue, int maxValue) {
        if (minValue < 0) {
            throw new IllegalArgumentException("Values should be non-negative");
        }
        this.bA = new MutableRoaringBitmap[32 - Integer.numberOfLeadingZeros(maxValue)];
        for (int i = 0; i < this.bA.length; ++i) {
            this.bA[i] = new MutableRoaringBitmap();
        }
        this.ebM = new MutableRoaringBitmap();
    }

    public MutableBitSliceIndex() {
        this(0, 0);
    }

    private void ensureCapacityInternal(int minValue, int maxValue) {
        if (this.ebM.isEmpty()) {
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.grow(Integer.toBinaryString(maxValue).length());
        } else if (this.minValue > minValue) {
            this.minValue = minValue;
        } else if (this.maxValue < maxValue) {
            this.maxValue = maxValue;
            this.grow(Integer.toBinaryString(maxValue).length());
        }
    }

    private void grow(int newBitDepth) {
        int oldBitDepth = this.bA.length;
        if (oldBitDepth >= newBitDepth) {
            return;
        }
        MutableRoaringBitmap[] newBA = new MutableRoaringBitmap[newBitDepth];
        if (oldBitDepth != 0) {
            System.arraycopy(this.bA, 0, newBA, 0, oldBitDepth);
        }
        for (int i = newBitDepth - 1; i >= oldBitDepth; --i) {
            newBA[i] = new MutableRoaringBitmap();
            if (!this.runOptimized) continue;
            newBA[i].runOptimize();
        }
        this.bA = newBA;
    }

    public void runOptimize() {
        this.ebM.toMutableRoaringBitmap().runOptimize();
        for (int i = 0; i < this.bA.length; ++i) {
            this.getMutableSlice(i).runOptimize();
        }
        this.runOptimized = true;
    }

    public boolean hasRunCompression() {
        return this.runOptimized;
    }

    public void addDigit(MutableRoaringBitmap foundSet, int i) {
        MutableRoaringBitmap carry = MutableRoaringBitmap.and((ImmutableRoaringBitmap)this.bA[i], (ImmutableRoaringBitmap)foundSet);
        this.getMutableSlice(i).xor((ImmutableRoaringBitmap)foundSet);
        if (!carry.isEmpty()) {
            if (i + 1 >= this.bitCount()) {
                this.grow(this.bitCount() + 1);
            }
            this.addDigit(carry, i + 1);
        }
    }

    public MutableRoaringBitmap getExistenceBitmap() {
        return (MutableRoaringBitmap)this.ebM;
    }

    public MutableRoaringBitmap getMutableSlice(int i) {
        return (MutableRoaringBitmap)this.bA[i];
    }

    @Override
    public void setValue(int columnId, int value) {
        this.ensureCapacityInternal(value, value);
        this.setValueInternal(columnId, value);
    }

    private void setValueInternal(int columnId, int value) {
        for (int i = 0; i < this.bitCount(); ++i) {
            if ((value & 1 << i) > 0) {
                this.getMutableSlice(i).add(columnId);
                continue;
            }
            this.getMutableSlice(i).remove(columnId);
        }
        this.getExistenceBitmap().add(columnId);
    }

    @Override
    public void setValues(List<Pair<Integer, Integer>> values, Integer currentMaxValue, Integer currentMinValue) {
        OptionalInt minValue;
        OptionalInt maxValue = currentMaxValue != null ? OptionalInt.of(currentMaxValue) : values.stream().mapToInt(Pair::getRight).max();
        OptionalInt optionalInt = minValue = currentMinValue != null ? OptionalInt.of(currentMinValue) : values.stream().mapToInt(Pair::getRight).min();
        if (!maxValue.isPresent() || !minValue.isPresent()) {
            throw new IllegalArgumentException("wrong input values list");
        }
        this.ensureCapacityInternal(minValue.getAsInt(), maxValue.getAsInt());
        for (Pair<Integer, Integer> pair : values) {
            this.setValue(pair.getKey(), pair.getValue());
        }
    }

    @Override
    public void setValues(List<Pair<Integer, Integer>> values) {
        int maxValue = values.stream().mapToInt(Pair::getRight).filter(Objects::nonNull).max().getAsInt();
        int minValue = values.stream().mapToInt(Pair::getRight).filter(Objects::nonNull).min().getAsInt();
        this.ensureCapacityInternal(minValue, maxValue);
        for (Pair<Integer, Integer> pair : values) {
            this.setValueInternal(pair.getKey(), pair.getValue());
        }
    }

    public void add(MutableBitSliceIndex otherBsi) {
        if (null == otherBsi || otherBsi.ebM.isEmpty()) {
            return;
        }
        this.getExistenceBitmap().or((ImmutableRoaringBitmap)otherBsi.getExistenceBitmap());
        if (otherBsi.bitCount() > this.bitCount()) {
            this.grow(otherBsi.bitCount());
        }
        for (int i = 0; i < otherBsi.bitCount(); ++i) {
            this.addDigit(otherBsi.getMutableSlice(i), i);
        }
        this.minValue = this.minValue();
        this.maxValue = this.maxValue();
    }

    private int minValue() {
        if (this.ebM.isEmpty()) {
            return 0;
        }
        MutableRoaringBitmap minValuesId = this.getExistenceBitmap();
        for (int i = this.bA.length - 1; i >= 0; --i) {
            MutableRoaringBitmap tmp = MutableRoaringBitmap.andNot((ImmutableRoaringBitmap)minValuesId, (ImmutableRoaringBitmap)this.bA[i]);
            if (tmp.isEmpty()) continue;
            minValuesId = tmp;
        }
        return this.valueAt(minValuesId.first());
    }

    private int maxValue() {
        if (this.ebM.isEmpty()) {
            return 0;
        }
        MutableRoaringBitmap maxValuesId = this.getExistenceBitmap();
        for (int i = this.bA.length - 1; i >= 0; --i) {
            MutableRoaringBitmap tmp = MutableRoaringBitmap.and((ImmutableRoaringBitmap)maxValuesId, (ImmutableRoaringBitmap)this.bA[i]);
            if (tmp.isEmpty()) continue;
            maxValuesId = tmp;
        }
        return this.valueAt(maxValuesId.first());
    }

    private int valueAt(int columnId) {
        int value = 0;
        for (int i = 0; i < this.bitCount(); ++i) {
            if (!this.bA[i].contains(columnId)) continue;
            value |= 1 << i;
        }
        return value;
    }

    public void merge(MutableBitSliceIndex otherBsi) {
        if (null == otherBsi || otherBsi.ebM.isEmpty()) {
            return;
        }
        if (MutableRoaringBitmap.intersects((ImmutableRoaringBitmap)this.ebM, (ImmutableRoaringBitmap)otherBsi.ebM)) {
            throw new IllegalArgumentException("merge can be used only in bsiA  bsiB  is null");
        }
        int bitDepth = Integer.max(this.bitCount(), otherBsi.bitCount());
        MutableRoaringBitmap[] newBA = new MutableRoaringBitmap[bitDepth];
        for (int i = 0; i < bitDepth; ++i) {
            MutableRoaringBitmap current = i < this.bA.length ? this.getMutableSlice(i) : new MutableRoaringBitmap();
            MutableRoaringBitmap other = i < otherBsi.bA.length ? otherBsi.getMutableSlice(i) : new MutableRoaringBitmap();
            newBA[i] = MutableRoaringBitmap.or((MutableRoaringBitmap)current, (MutableRoaringBitmap)other);
            if (!this.runOptimized && !otherBsi.runOptimized) continue;
            newBA[i].runOptimize();
        }
        this.bA = newBA;
        this.getExistenceBitmap().or((ImmutableRoaringBitmap)otherBsi.getExistenceBitmap());
        this.runOptimized = this.runOptimized || otherBsi.runOptimized;
        this.maxValue = Integer.max(this.maxValue, otherBsi.maxValue);
        this.minValue = Integer.min(this.minValue, otherBsi.minValue);
    }

    public MutableBitSliceIndex clone() {
        MutableBitSliceIndex bitSliceIndex = new MutableBitSliceIndex();
        bitSliceIndex.minValue = this.minValue;
        bitSliceIndex.maxValue = this.maxValue;
        bitSliceIndex.ebM = this.ebM.clone();
        MutableRoaringBitmap[] cloneBA = new MutableRoaringBitmap[this.bitCount()];
        for (int i = 0; i < cloneBA.length; ++i) {
            cloneBA[i] = this.getMutableSlice(i).clone();
        }
        bitSliceIndex.bA = cloneBA;
        bitSliceIndex.runOptimized = this.runOptimized;
        return bitSliceIndex;
    }

    @Override
    public void serialize(ByteBuffer buffer) {
        buffer.putInt(this.minValue);
        buffer.putInt(this.maxValue);
        buffer.put(this.runOptimized ? (byte)1 : 0);
        this.ebM.serialize(buffer);
        buffer.putInt(this.bA.length);
        for (ImmutableRoaringBitmap rb : this.bA) {
            rb.serialize(buffer);
        }
    }

    @Override
    public void serialize(DataOutput output) throws IOException {
        WritableUtils.writeVInt(output, this.minValue);
        WritableUtils.writeVInt(output, this.maxValue);
        output.writeBoolean(this.runOptimized);
        this.ebM.serialize(output);
        WritableUtils.writeVInt(output, this.bA.length);
        for (ImmutableRoaringBitmap rb : this.bA) {
            rb.serialize(output);
        }
    }

    private void clear() {
        this.maxValue = 0;
        this.minValue = 0;
        this.ebM = null;
        this.bA = null;
    }

    public void deserialize(ByteBuffer buffer) throws IOException {
        this.clear();
        this.minValue = buffer.getInt();
        this.maxValue = buffer.getInt();
        this.runOptimized = buffer.get() == 1;
        MutableRoaringBitmap ebm = new MutableRoaringBitmap();
        ebm.deserialize(buffer);
        this.ebM = ebm;
        buffer.position(buffer.position() + ebm.serializedSizeInBytes());
        int bitDepth = buffer.getInt();
        MutableRoaringBitmap[] ba = new MutableRoaringBitmap[bitDepth];
        for (int i = 0; i < bitDepth; ++i) {
            MutableRoaringBitmap rb = new MutableRoaringBitmap();
            rb.deserialize(buffer);
            ba[i] = rb;
            buffer.position(buffer.position() + rb.serializedSizeInBytes());
        }
        this.bA = ba;
    }

    public void deserialize(DataInput in) throws IOException {
        this.clear();
        this.minValue = WritableUtils.readVInt(in);
        this.maxValue = WritableUtils.readVInt(in);
        this.runOptimized = in.readBoolean();
        MutableRoaringBitmap ebm = new MutableRoaringBitmap();
        ebm.deserialize(in);
        this.ebM = ebm;
        int bitDepth = WritableUtils.readVInt(in);
        MutableRoaringBitmap[] ba = new MutableRoaringBitmap[bitDepth];
        for (int i = 0; i < bitDepth; ++i) {
            MutableRoaringBitmap rb = new MutableRoaringBitmap();
            rb.deserialize(in);
            ba[i] = rb;
        }
        this.bA = ba;
    }

    @Override
    public int serializedSizeInBytes() {
        int size = 0;
        for (ImmutableRoaringBitmap rb : this.bA) {
            size += rb.serializedSizeInBytes();
        }
        return 13 + this.ebM.serializedSizeInBytes() + size;
    }

    public ImmutableBitSliceIndex toImmutableBitSliceIndex() {
        ImmutableRoaringBitmap[] ibA = new ImmutableRoaringBitmap[this.bA.length];
        for (int i = 0; i < this.bA.length; ++i) {
            ibA[i] = this.bA[i];
        }
        ImmutableBitSliceIndex bsi = new ImmutableBitSliceIndex(this.maxValue, this.minValue, ibA, this.ebM);
        return bsi;
    }
}

