/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.bsi.buffer;

import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.roaringbitmap.bsi.BitmapSliceIndex;
import org.roaringbitmap.bsi.Pair;
import org.roaringbitmap.bsi.WritableUtils;
import org.roaringbitmap.bsi.buffer.BitSliceIndexBase;
import org.roaringbitmap.bsi.buffer.MutableBitSliceIndex;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class ImmutableBitSliceIndex
extends BitSliceIndexBase
implements BitmapSliceIndex {
    public ImmutableBitSliceIndex(int maxValue, int minValue, ImmutableRoaringBitmap[] bA, ImmutableRoaringBitmap ebM) {
        this.maxValue = maxValue;
        this.minValue = minValue;
        this.bA = bA;
        this.ebM = ebM;
    }

    public ImmutableBitSliceIndex() {
    }

    public ImmutableBitSliceIndex(ByteBuffer buffer) throws IOException {
        ImmutableRoaringBitmap ebm;
        this.clear();
        this.minValue = buffer.getInt();
        this.maxValue = buffer.getInt();
        this.ebM = ebm = new ImmutableRoaringBitmap(buffer);
        buffer.position(buffer.position() + ebm.serializedSizeInBytes());
        int bitDepth = buffer.getInt();
        ImmutableRoaringBitmap[] ba = new ImmutableRoaringBitmap[bitDepth];
        for (int i = 0; i < bitDepth; ++i) {
            ImmutableRoaringBitmap rb;
            ba[i] = rb = new ImmutableRoaringBitmap(buffer);
            buffer.position(buffer.position() + rb.serializedSizeInBytes());
        }
        this.bA = ba;
    }

    public void addDigit(ImmutableRoaringBitmap foundSet, int i) {
        throw new UnsupportedOperationException("ImmutableBSI don't support setValue");
    }

    public ImmutableRoaringBitmap getExistenceBitmap() {
        return this.ebM;
    }

    @Override
    public void setValue(int cid, int value) {
        throw new UnsupportedOperationException("ImmutableBSI don't support setValue");
    }

    @Override
    public void setValues(List<Pair<Integer, Integer>> values, Integer currentMaxValue, Integer currentMinValue) {
        throw new UnsupportedOperationException("ImmutableBSI don't support setValues");
    }

    @Override
    public void setValues(List<Pair<Integer, Integer>> values) {
        throw new UnsupportedOperationException("ImmutableBSI does not support setting values");
    }

    public void add(BitmapSliceIndex otherBitmapSliceIndex) {
        throw new UnsupportedOperationException("ImmutableBSI don't support add");
    }

    public void merge(BitmapSliceIndex otherBitmapSliceIndex) {
        throw new UnsupportedOperationException("ImmutableBSI don't support merge");
    }

    private void clear() {
        this.maxValue = 0;
        this.minValue = 0;
        this.ebM = null;
        this.bA = null;
    }

    @Override
    public void serialize(ByteBuffer buffer) {
        buffer.putInt(this.minValue);
        buffer.putInt(this.maxValue);
        this.ebM.serialize(buffer);
        buffer.putInt(this.bA.length);
        for (ImmutableRoaringBitmap rb : this.bA) {
            rb.serialize(buffer);
        }
    }

    @Override
    public void serialize(DataOutput output) throws IOException {
        WritableUtils.writeVInt(output, this.minValue);
        WritableUtils.writeVInt(output, this.maxValue);
        this.ebM.serialize(output);
        WritableUtils.writeVInt(output, this.bA.length);
        for (ImmutableRoaringBitmap rb : this.bA) {
            rb.serialize(output);
        }
    }

    @Override
    public int serializedSizeInBytes() {
        int size = 0;
        for (ImmutableRoaringBitmap rb : this.bA) {
            size += rb.serializedSizeInBytes();
        }
        return 13 + this.ebM.serializedSizeInBytes() + size;
    }

    public MutableBitSliceIndex toMutableBitSliceIndex() {
        MutableRoaringBitmap[] ibA = new MutableRoaringBitmap[this.bA.length];
        for (int i = 0; i < this.bA.length; ++i) {
            ibA[i] = this.bA[i].toMutableRoaringBitmap();
        }
        MutableBitSliceIndex bsi = new MutableBitSliceIndex(this.maxValue, this.minValue, ibA, this.ebM.toMutableRoaringBitmap());
        return bsi;
    }

    public ImmutableBitSliceIndex clone() {
        ImmutableBitSliceIndex bsi = new ImmutableBitSliceIndex();
        bsi.minValue = this.minValue;
        bsi.maxValue = this.maxValue;
        bsi.ebM = this.ebM.clone();
        ImmutableRoaringBitmap[] cloneBA = new ImmutableRoaringBitmap[this.bitCount()];
        for (int i = 0; i < cloneBA.length; ++i) {
            cloneBA[i] = this.bA[i].clone();
        }
        bsi.bA = cloneBA;
        return bsi;
    }
}

