/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.bsi.buffer;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.roaringbitmap.BatchIterator;
import org.roaringbitmap.PeekableIntIterator;
import org.roaringbitmap.bsi.BitmapSliceIndex;
import org.roaringbitmap.bsi.Pair;
import org.roaringbitmap.bsi.buffer.MutableBitSliceIndex;
import org.roaringbitmap.buffer.BufferFastAggregation;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class BitSliceIndexBase {
    protected int maxValue;
    protected int minValue;
    protected ImmutableRoaringBitmap[] bA;
    protected ImmutableRoaringBitmap ebM;

    public int bitCount() {
        return this.bA.length;
    }

    public long getLongCardinality() {
        return this.ebM.getLongCardinality();
    }

    public Pair<Integer, Boolean> getValue(int columnId) {
        boolean exists = this.ebM.contains(columnId);
        if (!exists) {
            return Pair.newPair(0, false);
        }
        int value = 0;
        for (int i = 0; i < this.bitCount(); ++i) {
            if (!this.bA[i].contains(columnId)) continue;
            value |= 1 << i;
        }
        return Pair.newPair(value, true);
    }

    public boolean valueExist(Long columnId) {
        return this.ebM.contains(columnId.intValue());
    }

    protected <R> List<CompletableFuture<R>> parallelExec(Function<int[], R> func, int parallelism, ImmutableRoaringBitmap foundSet, ExecutorService pool) {
        int batchSize = foundSet.getCardinality() / parallelism;
        batchSize = Math.max(batchSize, parallelism);
        batchSize = Math.min(batchSize, 65536);
        ArrayList<int[]> batches = new ArrayList<int[]>();
        BatchIterator batchIterator = foundSet.getBatchIterator();
        while (batchIterator.hasNext()) {
            int[] buffer = new int[batchSize];
            int cardinality = batchIterator.nextBatch(buffer);
            if (cardinality <= 0) continue;
            if (cardinality == batchSize) {
                batches.add(buffer);
                continue;
            }
            int[] buff = new int[cardinality];
            System.arraycopy(buffer, 0, buff, 0, cardinality);
            batches.add(buff);
        }
        ArrayList<CompletableFuture<R>> futures = new ArrayList<CompletableFuture<R>>();
        for (int[] batch : batches) {
            CompletableFuture<Object> future = this.invokeAsync(() -> func.apply(batch), null, pool);
            futures.add(future);
        }
        return futures;
    }

    protected <T> CompletableFuture<List<T>> allOf(List<CompletableFuture<T>> futuresList) {
        CompletableFuture<Void> allFuturesResult = CompletableFuture.allOf(futuresList.toArray(new CompletableFuture[0]));
        return allFuturesResult.thenApply(v -> futuresList.stream().map(CompletableFuture::join).collect(Collectors.toList()));
    }

    protected ImmutableRoaringBitmap parallelMR(int parallelism, ImmutableRoaringBitmap foundSet, Function<int[], ImmutableRoaringBitmap> func, ExecutorService pool) throws InterruptedException, ExecutionException {
        List futures = this.parallelExec(func, parallelism, foundSet, pool);
        this.allOf(futures);
        ImmutableRoaringBitmap[] rbs = new ImmutableRoaringBitmap[futures.size()];
        for (int i = 0; i < futures.size(); ++i) {
            rbs[i] = (ImmutableRoaringBitmap)futures.get(i).get();
        }
        return MutableRoaringBitmap.or((ImmutableRoaringBitmap[])rbs);
    }

    protected <T> CompletableFuture<T> invokeAsync(Supplier<T> supplier, Function<Exception, T> exceptionHandler, Executor forkJoinExecutor) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return supplier.get();
            }
            catch (Exception e) {
                if (exceptionHandler == null) {
                    throw e;
                }
                return exceptionHandler.apply(e);
            }
        }, forkJoinExecutor);
    }

    private ImmutableRoaringBitmap oNeilCompare(BitmapSliceIndex.Operation operation, int predicate, ImmutableRoaringBitmap foundSet) {
        ImmutableRoaringBitmap fixedFoundSet = foundSet == null ? this.ebM : foundSet;
        MutableRoaringBitmap GT = operation == BitmapSliceIndex.Operation.GT || operation == BitmapSliceIndex.Operation.GE ? new MutableRoaringBitmap() : null;
        MutableRoaringBitmap LT = operation == BitmapSliceIndex.Operation.LT || operation == BitmapSliceIndex.Operation.LE ? new MutableRoaringBitmap() : null;
        ImmutableRoaringBitmap EQ = this.ebM;
        for (int i = this.bitCount() - 1; i >= 0; --i) {
            int bit = predicate >> i & 1;
            if (bit == 1) {
                if (operation == BitmapSliceIndex.Operation.LT || operation == BitmapSliceIndex.Operation.LE) {
                    LT = ImmutableRoaringBitmap.or((ImmutableRoaringBitmap)LT, (ImmutableRoaringBitmap)ImmutableRoaringBitmap.andNot((ImmutableRoaringBitmap)EQ, (ImmutableRoaringBitmap)this.bA[i]));
                }
                EQ = ImmutableRoaringBitmap.and((ImmutableRoaringBitmap)EQ, (ImmutableRoaringBitmap)this.bA[i]);
                continue;
            }
            if (operation == BitmapSliceIndex.Operation.GT || operation == BitmapSliceIndex.Operation.GE) {
                GT = ImmutableRoaringBitmap.or((ImmutableRoaringBitmap)GT, (ImmutableRoaringBitmap)ImmutableRoaringBitmap.and((ImmutableRoaringBitmap)EQ, (ImmutableRoaringBitmap)this.bA[i]));
            }
            EQ = ImmutableRoaringBitmap.andNot((ImmutableRoaringBitmap)EQ, (ImmutableRoaringBitmap)this.bA[i]);
        }
        if (operation != BitmapSliceIndex.Operation.LT && operation != BitmapSliceIndex.Operation.GT) {
            EQ = ImmutableRoaringBitmap.and((ImmutableRoaringBitmap)fixedFoundSet, (ImmutableRoaringBitmap)EQ);
        }
        switch (operation) {
            case EQ: {
                return EQ;
            }
            case GT: {
                return ImmutableRoaringBitmap.and((ImmutableRoaringBitmap)GT, (ImmutableRoaringBitmap)fixedFoundSet);
            }
            case LT: {
                return ImmutableRoaringBitmap.and((ImmutableRoaringBitmap)LT, (ImmutableRoaringBitmap)fixedFoundSet);
            }
            case LE: {
                return ImmutableRoaringBitmap.or((ImmutableRoaringBitmap)LT, (ImmutableRoaringBitmap)EQ);
            }
            case GE: {
                return ImmutableRoaringBitmap.or((ImmutableRoaringBitmap)GT, (ImmutableRoaringBitmap)EQ);
            }
        }
        throw new IllegalArgumentException("");
    }

    private ImmutableRoaringBitmap owenGreatEqual(int predicate, ImmutableRoaringBitmap foundSet) {
        Object lastSpineGate = null;
        int beGtrThan = predicate - 1;
        ArrayList<Object> orInputs = new ArrayList<Object>();
        int leastSignifZero = Long.numberOfTrailingZeros(~beGtrThan);
        for (int workingBit = this.bitCount() - 1; workingBit >= leastSignifZero; --workingBit) {
            if (((long)beGtrThan & 1L << workingBit) == 0L) {
                if (lastSpineGate == null) {
                    orInputs.add(this.bA[workingBit]);
                    continue;
                }
                orInputs.add(MutableRoaringBitmap.and((ImmutableRoaringBitmap)lastSpineGate, (ImmutableRoaringBitmap)this.bA[workingBit]));
                continue;
            }
            lastSpineGate = lastSpineGate == null ? this.bA[workingBit] : ImmutableRoaringBitmap.and((ImmutableRoaringBitmap)lastSpineGate, (ImmutableRoaringBitmap)this.bA[workingBit]);
        }
        MutableRoaringBitmap result = BufferFastAggregation.horizontal_or((ImmutableRoaringBitmap[])orInputs.toArray(new ImmutableRoaringBitmap[0]));
        if (null == foundSet) {
            return result;
        }
        return ImmutableRoaringBitmap.and((ImmutableRoaringBitmap)result, (ImmutableRoaringBitmap)foundSet);
    }

    public MutableRoaringBitmap topK(ImmutableRoaringBitmap foundSet, int k) {
        MutableRoaringBitmap F;
        long n;
        ImmutableRoaringBitmap fixedFoundSet;
        ImmutableRoaringBitmap immutableRoaringBitmap = fixedFoundSet = foundSet == null ? this.ebM : foundSet;
        if ((long)k > fixedFoundSet.getLongCardinality() || k < 0) {
            throw new IllegalArgumentException("TopK param error,cardinality:" + fixedFoundSet.getLongCardinality() + " k:" + k);
        }
        MutableRoaringBitmap G = new MutableRoaringBitmap();
        ImmutableRoaringBitmap E = fixedFoundSet;
        for (int i = this.bitCount() - 1; i >= 0; --i) {
            MutableRoaringBitmap X = ImmutableRoaringBitmap.or((ImmutableRoaringBitmap)G, (ImmutableRoaringBitmap)ImmutableRoaringBitmap.and((ImmutableRoaringBitmap)E, (ImmutableRoaringBitmap)this.bA[i]));
            long n2 = X.getLongCardinality();
            if (n2 > (long)k) {
                E = ImmutableRoaringBitmap.and((ImmutableRoaringBitmap)E, (ImmutableRoaringBitmap)this.bA[i]);
                continue;
            }
            if (n2 < (long)k) {
                G = X;
                E = ImmutableRoaringBitmap.andNot((ImmutableRoaringBitmap)E, (ImmutableRoaringBitmap)this.bA[i]);
                continue;
            }
            E = ImmutableRoaringBitmap.and((ImmutableRoaringBitmap)E, (ImmutableRoaringBitmap)this.bA[i]);
            break;
        }
        if ((n = (F = ImmutableRoaringBitmap.or((ImmutableRoaringBitmap)G, (ImmutableRoaringBitmap)E)).getLongCardinality() - (long)k) > 0L) {
            PeekableIntIterator i = F.getIntIterator();
            while (i.hasNext() && n > 0L) {
                F.remove(i.next());
                --n;
            }
        }
        if (F.getCardinality() != k) {
            throw new RuntimeException("bugs found when compute topK");
        }
        return F;
    }

    public ImmutableRoaringBitmap rangeEQ(ImmutableRoaringBitmap foundSet, int predicate) {
        ImmutableRoaringBitmap result;
        ImmutableRoaringBitmap eqBitmap = this.ebM;
        if (foundSet != null) {
            eqBitmap = ImmutableRoaringBitmap.and((ImmutableRoaringBitmap)eqBitmap, (ImmutableRoaringBitmap)foundSet);
        }
        if ((result = this.compareUsingMinMax(BitmapSliceIndex.Operation.EQ, predicate, 0, foundSet)) != null) {
            return result;
        }
        for (int i = this.bA.length - 1; i >= 0; --i) {
            ImmutableRoaringBitmap slice = this.bA[i];
            int bit = predicate >> i & 1;
            eqBitmap = bit == 1 ? ImmutableRoaringBitmap.and((ImmutableRoaringBitmap)eqBitmap, (ImmutableRoaringBitmap)slice) : ImmutableRoaringBitmap.andNot((ImmutableRoaringBitmap)eqBitmap, (ImmutableRoaringBitmap)slice);
        }
        return eqBitmap;
    }

    public ImmutableRoaringBitmap rangeNEQ(ImmutableRoaringBitmap foundSet, int predicate) {
        ImmutableRoaringBitmap eqBitmap = this.rangeEQ(foundSet, predicate);
        return ImmutableRoaringBitmap.andNot((ImmutableRoaringBitmap)this.ebM, (ImmutableRoaringBitmap)eqBitmap);
    }

    public ImmutableRoaringBitmap rangeLT(ImmutableRoaringBitmap foundSet, int predicate) {
        return this.compare(BitmapSliceIndex.Operation.LT, predicate, 0, foundSet);
    }

    public ImmutableRoaringBitmap rangeLE(ImmutableRoaringBitmap foundSet, int predicate) {
        return this.compare(BitmapSliceIndex.Operation.LE, predicate, 0, foundSet);
    }

    public ImmutableRoaringBitmap rangeGT(ImmutableRoaringBitmap foundSet, int predicate) {
        return this.compare(BitmapSliceIndex.Operation.GT, predicate, 0, foundSet);
    }

    public ImmutableRoaringBitmap rangeGE(ImmutableRoaringBitmap foundSet, int predicate) {
        return this.compare(BitmapSliceIndex.Operation.GE, predicate, 0, foundSet);
    }

    public ImmutableRoaringBitmap range(ImmutableRoaringBitmap foundSet, int start, int end) {
        return this.compare(BitmapSliceIndex.Operation.RANGE, start, end, foundSet);
    }

    public ImmutableRoaringBitmap compare(BitmapSliceIndex.Operation operation, int startOrValue, int end, ImmutableRoaringBitmap foundSet) {
        ImmutableRoaringBitmap result = this.compareUsingMinMax(operation, startOrValue, end, foundSet);
        if (result != null) {
            return result;
        }
        switch (operation) {
            case EQ: {
                return this.rangeEQ(foundSet, startOrValue);
            }
            case NEQ: {
                return this.rangeNEQ(foundSet, startOrValue);
            }
            case GE: {
                return this.owenGreatEqual(startOrValue, foundSet);
            }
            case GT: {
                return this.oNeilCompare(BitmapSliceIndex.Operation.GT, startOrValue, foundSet);
            }
            case LT: {
                return this.oNeilCompare(BitmapSliceIndex.Operation.LT, startOrValue, foundSet);
            }
            case LE: {
                return this.oNeilCompare(BitmapSliceIndex.Operation.LE, startOrValue, foundSet);
            }
            case RANGE: {
                ImmutableRoaringBitmap left = this.owenGreatEqual(startOrValue, foundSet);
                ImmutableRoaringBitmap right = this.oNeilCompare(BitmapSliceIndex.Operation.LE, end, foundSet);
                return ImmutableRoaringBitmap.and((ImmutableRoaringBitmap)left, (ImmutableRoaringBitmap)right);
            }
        }
        throw new IllegalArgumentException("not support operation!");
    }

    private ImmutableRoaringBitmap compareUsingMinMax(BitmapSliceIndex.Operation operation, int startOrValue, int end, ImmutableRoaringBitmap foundSet) {
        ImmutableRoaringBitmap all = foundSet == null ? this.ebM.clone() : ImmutableRoaringBitmap.and((ImmutableRoaringBitmap)this.ebM, (ImmutableRoaringBitmap)foundSet);
        MutableRoaringBitmap empty = new MutableRoaringBitmap();
        switch (operation) {
            case LT: {
                if (startOrValue > this.maxValue) {
                    return all;
                }
                if (startOrValue > this.minValue) break;
                return empty;
            }
            case LE: {
                if (startOrValue >= this.maxValue) {
                    return all;
                }
                if (startOrValue >= this.minValue) break;
                return empty;
            }
            case GT: {
                if (startOrValue < this.minValue) {
                    return all;
                }
                if (startOrValue < this.maxValue) break;
                return empty;
            }
            case GE: {
                if (startOrValue <= this.minValue) {
                    return all;
                }
                if (startOrValue <= this.maxValue) break;
                return empty;
            }
            case EQ: {
                if (this.minValue == this.maxValue && this.minValue == startOrValue) {
                    return all;
                }
                if (startOrValue >= this.minValue && startOrValue <= this.maxValue) break;
                return empty;
            }
            case NEQ: {
                if (this.minValue != this.maxValue) break;
                return this.minValue == startOrValue ? empty : all;
            }
            case RANGE: {
                if (startOrValue <= this.minValue && end >= this.maxValue) {
                    return all;
                }
                if (startOrValue <= this.maxValue && end >= this.minValue) break;
                return empty;
            }
            default: {
                return null;
            }
        }
        return null;
    }

    public Pair<Long, Long> sum(ImmutableRoaringBitmap foundSet) {
        if (null == foundSet || foundSet.isEmpty()) {
            return Pair.newPair(0L, 0L);
        }
        long count = foundSet.getLongCardinality();
        Long sum = IntStream.range(0, this.bitCount()).mapToLong(x -> (long)(1 << x) * (long)ImmutableRoaringBitmap.andCardinality((ImmutableRoaringBitmap)this.bA[x], (ImmutableRoaringBitmap)foundSet)).sum();
        return Pair.newPair(sum, count);
    }

    public List<Pair<Integer, Integer>> toPairList() {
        ArrayList<Pair<Integer, Integer>> pairList = new ArrayList<Pair<Integer, Integer>>();
        this.ebM.forEach(cid -> pairList.add(Pair.newPair(cid, this.getValue(cid).getKey())));
        return pairList;
    }

    public List<Pair<Integer, Integer>> toPairList(ImmutableRoaringBitmap foundSet) {
        ArrayList<Pair<Integer, Integer>> pairList = new ArrayList<Pair<Integer, Integer>>();
        MutableRoaringBitmap bitmap = ImmutableRoaringBitmap.and((ImmutableRoaringBitmap)this.ebM, (ImmutableRoaringBitmap)foundSet);
        bitmap.forEach(cid -> pairList.add(Pair.newPair(cid, this.getValue(cid).getKey())));
        return pairList;
    }

    protected MutableBitSliceIndex transposeWithCount(int[] batch) {
        MutableBitSliceIndex result = new MutableBitSliceIndex();
        for (int columnId : batch) {
            Pair<Integer, Boolean> value = this.getValue(columnId);
            if (!value.getValue().booleanValue()) continue;
            Pair<Integer, Boolean> val = result.getValue(value.getKey());
            if (!val.getValue().booleanValue()) {
                result.setValue(value.getKey(), 1);
                continue;
            }
            int count = val.getKey() + 1;
            result.setValue(value.getKey(), count);
        }
        return result;
    }

    public MutableBitSliceIndex parallelTransposeWithCount(ImmutableRoaringBitmap foundSet, int parallelism, ExecutorService pool) throws ExecutionException, InterruptedException {
        ImmutableRoaringBitmap fixedFoundSet = foundSet == null ? this.ebM : foundSet;
        Function<int[], MutableBitSliceIndex> func = batch -> this.transposeWithCount((int[])batch);
        List futures = this.parallelExec(func, parallelism, fixedFoundSet, pool);
        this.allOf(futures);
        MutableBitSliceIndex result = new MutableBitSliceIndex();
        for (CompletableFuture bsiFuture : futures) {
            result.add((MutableBitSliceIndex)bsiFuture.get());
        }
        return result;
    }

    public ImmutableRoaringBitmap parallelIn(int parallelism, ImmutableRoaringBitmap foundSet, Set<Integer> values, ExecutorService pool) throws ExecutionException, InterruptedException {
        ImmutableRoaringBitmap fixedFoundSet = foundSet == null ? this.ebM : foundSet;
        Function<int[], ImmutableRoaringBitmap> func = batch -> this.batchIn((int[])batch, values);
        return this.parallelMR(parallelism, fixedFoundSet, func, pool);
    }

    protected ImmutableRoaringBitmap batchIn(int[] batch, Set<Integer> values) {
        MutableRoaringBitmap result = new MutableRoaringBitmap();
        for (int cID : batch) {
            Pair<Integer, Boolean> value = this.getValue(cID);
            if (!value.getValue().booleanValue() || !values.contains(value.getKey())) continue;
            result.add(cID);
        }
        return result;
    }
}

