/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.bsi;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class WritableUtils {
    public static void writeVInt(DataOutput stream, int i) throws IOException {
        WritableUtils.writeVLong(stream, i);
    }

    public static void writeVLong(DataOutput stream, long i) throws IOException {
        if (i >= -112L && i <= 127L) {
            stream.writeByte((byte)i);
            return;
        }
        int len = -112;
        if (i < 0L) {
            i ^= 0xFFFFFFFFFFFFFFFFL;
            len = -120;
        }
        long tmp = i;
        while (tmp != 0L) {
            tmp >>= 8;
            --len;
        }
        stream.writeByte((byte)len);
        for (int idx = len = len < -120 ? -(len + 120) : -(len + 112); idx != 0; --idx) {
            int shiftbits = (idx - 1) * 8;
            long mask = 255L << shiftbits;
            stream.writeByte((byte)((i & mask) >> shiftbits));
        }
    }

    public static long readVLong(DataInput stream) throws IOException {
        byte firstByte = stream.readByte();
        int len = WritableUtils.decodeVIntSize(firstByte);
        if (len == 1) {
            return firstByte;
        }
        long i = 0L;
        for (int idx = 0; idx < len - 1; ++idx) {
            byte b = stream.readByte();
            i <<= 8;
            i |= (long)(b & 0xFF);
        }
        return WritableUtils.isNegativeVInt(firstByte) ? i ^ 0xFFFFFFFFFFFFFFFFL : i;
    }

    public static int readVInt(DataInput stream) throws IOException {
        long n = WritableUtils.readVLong(stream);
        if (n > Integer.MAX_VALUE || n < Integer.MIN_VALUE) {
            throw new IOException("value too long to fit in integer");
        }
        return (int)n;
    }

    public static boolean isNegativeVInt(byte value) {
        return value < -120 || value >= -112 && value < 0;
    }

    public static int decodeVIntSize(byte value) {
        if (value >= -112) {
            return 1;
        }
        if (value < -120) {
            return -119 - value;
        }
        return -111 - value;
    }
}

