/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.bsi;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import org.roaringbitmap.RoaringBitmap;
import org.roaringbitmap.bsi.BitmapSliceIndex;
import org.roaringbitmap.bsi.Pair;
import org.roaringbitmap.bsi.WritableUtils;

public class RoaringBitmapSliceIndex
implements BitmapSliceIndex {
    private int maxValue;
    private int minValue;
    private RoaringBitmap[] bA;
    private RoaringBitmap ebM;
    private Boolean runOptimized = false;

    public RoaringBitmapSliceIndex(int minValue, int maxValue) {
        if (minValue < 0) {
            throw new IllegalArgumentException("Values should be non-negative");
        }
        this.bA = new RoaringBitmap[32 - Integer.numberOfLeadingZeros(maxValue)];
        for (int i = 0; i < this.bA.length; ++i) {
            this.bA[i] = new RoaringBitmap();
        }
        this.ebM = new RoaringBitmap();
    }

    public RoaringBitmapSliceIndex() {
        this(0, 0);
    }

    public void add(RoaringBitmapSliceIndex otherBsi) {
        if (null == otherBsi || otherBsi.ebM.isEmpty()) {
            return;
        }
        this.ebM.or(otherBsi.ebM);
        if (otherBsi.bitCount() > this.bitCount()) {
            this.grow(otherBsi.bitCount());
        }
        for (int i = 0; i < otherBsi.bitCount(); ++i) {
            this.addDigit(otherBsi.bA[i], i);
        }
        this.minValue = this.minValue();
        this.maxValue = this.maxValue();
    }

    private void addDigit(RoaringBitmap foundSet, int i) {
        RoaringBitmap carry = RoaringBitmap.and((RoaringBitmap)this.bA[i], (RoaringBitmap)foundSet);
        this.bA[i].xor(foundSet);
        if (!carry.isEmpty()) {
            if (i + 1 >= this.bitCount()) {
                this.grow(this.bitCount() + 1);
            }
            this.addDigit(carry, i + 1);
        }
    }

    private int minValue() {
        if (this.ebM.isEmpty()) {
            return 0;
        }
        RoaringBitmap minValuesId = this.ebM;
        for (int i = this.bA.length - 1; i >= 0; --i) {
            RoaringBitmap tmp = RoaringBitmap.andNot((RoaringBitmap)minValuesId, (RoaringBitmap)this.bA[i]);
            if (tmp.isEmpty()) continue;
            minValuesId = tmp;
        }
        return this.valueAt(minValuesId.first());
    }

    private int maxValue() {
        if (this.ebM.isEmpty()) {
            return 0;
        }
        RoaringBitmap maxValuesId = this.ebM;
        for (int i = this.bA.length - 1; i >= 0; --i) {
            RoaringBitmap tmp = RoaringBitmap.and((RoaringBitmap)maxValuesId, (RoaringBitmap)this.bA[i]);
            if (tmp.isEmpty()) continue;
            maxValuesId = tmp;
        }
        return this.valueAt(maxValuesId.first());
    }

    private int valueAt(int columnId) {
        int value = 0;
        for (int i = 0; i < this.bitCount(); ++i) {
            if (!this.bA[i].contains(columnId)) continue;
            value |= 1 << i;
        }
        return value;
    }

    public void runOptimize() {
        this.ebM.runOptimize();
        for (RoaringBitmap integers : this.bA) {
            integers.runOptimize();
        }
        this.runOptimized = true;
    }

    public boolean hasRunCompression() {
        return this.runOptimized;
    }

    public RoaringBitmap getExistenceBitmap() {
        return this.ebM;
    }

    @Override
    public int bitCount() {
        return this.bA.length;
    }

    @Override
    public long getLongCardinality() {
        return this.ebM.getLongCardinality();
    }

    @Override
    public Pair<Integer, Boolean> getValue(int columnId) {
        boolean exists = this.ebM.contains(columnId);
        if (!exists) {
            return Pair.newPair(0, false);
        }
        return Pair.newPair(this.valueAt(columnId), true);
    }

    private void clear() {
        this.maxValue = 0;
        this.minValue = 0;
        this.ebM = null;
        this.bA = null;
    }

    @Override
    public void serialize(DataOutput output) throws IOException {
        WritableUtils.writeVInt(output, this.minValue);
        WritableUtils.writeVInt(output, this.maxValue);
        output.writeBoolean(this.runOptimized);
        this.ebM.serialize(output);
        WritableUtils.writeVInt(output, this.bA.length);
        for (RoaringBitmap rb : this.bA) {
            rb.serialize(output);
        }
    }

    public void deserialize(DataInput in) throws IOException {
        this.clear();
        this.minValue = WritableUtils.readVInt(in);
        this.maxValue = WritableUtils.readVInt(in);
        this.runOptimized = in.readBoolean();
        RoaringBitmap ebm = new RoaringBitmap();
        ebm.deserialize(in);
        this.ebM = ebm;
        int bitDepth = WritableUtils.readVInt(in);
        RoaringBitmap[] ba = new RoaringBitmap[bitDepth];
        for (int i = 0; i < bitDepth; ++i) {
            RoaringBitmap rb = new RoaringBitmap();
            rb.deserialize(in);
            ba[i] = rb;
        }
        this.bA = ba;
    }

    @Override
    public void serialize(ByteBuffer buffer) {
        buffer.putInt(this.minValue);
        buffer.putInt(this.maxValue);
        buffer.put(this.runOptimized != false ? (byte)1 : 0);
        this.ebM.serialize(buffer);
        buffer.putInt(this.bA.length);
        for (RoaringBitmap rb : this.bA) {
            rb.serialize(buffer);
        }
    }

    public void deserialize(ByteBuffer buffer) throws IOException {
        this.clear();
        this.minValue = buffer.getInt();
        this.maxValue = buffer.getInt();
        this.runOptimized = buffer.get() == 1;
        RoaringBitmap ebm = new RoaringBitmap();
        ebm.deserialize(buffer);
        this.ebM = ebm;
        buffer.position(buffer.position() + ebm.serializedSizeInBytes());
        int bitDepth = buffer.getInt();
        RoaringBitmap[] ba = new RoaringBitmap[bitDepth];
        for (int i = 0; i < bitDepth; ++i) {
            RoaringBitmap rb = new RoaringBitmap();
            rb.deserialize(buffer);
            ba[i] = rb;
            buffer.position(buffer.position() + rb.serializedSizeInBytes());
        }
        this.bA = ba;
    }

    @Override
    public int serializedSizeInBytes() {
        int size = 0;
        for (RoaringBitmap rb : this.bA) {
            size += rb.serializedSizeInBytes();
        }
        return 13 + this.ebM.serializedSizeInBytes() + size;
    }

    public boolean valueExist(Long columnId) {
        return this.ebM.contains(columnId.intValue());
    }

    @Override
    public void setValue(int columnId, int value) {
        this.ensureCapacityInternal(value, value);
        this.setValueInternal(columnId, value);
    }

    private void setValueInternal(int columnId, int value) {
        for (int i = 0; i < this.bitCount(); ++i) {
            if ((value & 1 << i) > 0) {
                this.bA[i].add(columnId);
                continue;
            }
            this.bA[i].remove(columnId);
        }
        this.ebM.add(columnId);
    }

    private void ensureCapacityInternal(int minValue, int maxValue) {
        if (this.ebM.isEmpty()) {
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.grow(Integer.toBinaryString(maxValue).length());
        } else if (this.minValue > minValue) {
            this.minValue = minValue;
        } else if (this.maxValue < maxValue) {
            this.maxValue = maxValue;
            this.grow(Integer.toBinaryString(maxValue).length());
        }
    }

    private void grow(int newBitDepth) {
        int oldBitDepth = this.bA.length;
        if (oldBitDepth >= newBitDepth) {
            return;
        }
        RoaringBitmap[] newBA = new RoaringBitmap[newBitDepth];
        if (oldBitDepth != 0) {
            System.arraycopy(this.bA, 0, newBA, 0, oldBitDepth);
        }
        for (int i = newBitDepth - 1; i >= oldBitDepth; --i) {
            newBA[i] = new RoaringBitmap();
            if (!this.runOptimized.booleanValue()) continue;
            newBA[i].runOptimize();
        }
        this.bA = newBA;
    }

    @Override
    public void setValues(List<Pair<Integer, Integer>> values) {
        int maxValue = values.stream().mapToInt(Pair::getRight).filter(Objects::nonNull).max().getAsInt();
        int minValue = values.stream().mapToInt(Pair::getRight).filter(Objects::nonNull).min().getAsInt();
        this.ensureCapacityInternal(minValue, maxValue);
        for (Pair<Integer, Integer> pair : values) {
            this.setValueInternal(pair.getKey(), pair.getValue());
        }
    }

    @Override
    @Deprecated
    public void setValues(List<Pair<Integer, Integer>> values, Integer currentMaxValue, Integer currentMinValue) {
        int maxValue = currentMaxValue != null ? currentMaxValue.intValue() : values.stream().mapToInt(Pair::getRight).max().getAsInt();
        int minValue = currentMinValue != null ? currentMinValue.intValue() : values.stream().mapToInt(Pair::getRight).min().getAsInt();
        this.ensureCapacityInternal(minValue, maxValue);
        for (Pair<Integer, Integer> pair : values) {
            this.setValue(pair.getKey(), pair.getValue());
        }
    }

    public void merge(RoaringBitmapSliceIndex otherBsi) {
        if (null == otherBsi || otherBsi.ebM.isEmpty()) {
            return;
        }
        if (RoaringBitmap.intersects((RoaringBitmap)this.ebM, (RoaringBitmap)otherBsi.ebM)) {
            throw new IllegalArgumentException("merge can be used only in bsiA  bsiB  is null");
        }
        int bitDepth = Integer.max(this.bitCount(), otherBsi.bitCount());
        RoaringBitmap[] newBA = new RoaringBitmap[bitDepth];
        for (int i = 0; i < bitDepth; ++i) {
            RoaringBitmap current = i < this.bA.length ? this.bA[i] : new RoaringBitmap();
            RoaringBitmap other = i < otherBsi.bA.length ? otherBsi.bA[i] : new RoaringBitmap();
            newBA[i] = RoaringBitmap.or((RoaringBitmap)current, (RoaringBitmap)other);
            if (!this.runOptimized.booleanValue() && !otherBsi.runOptimized.booleanValue()) continue;
            newBA[i].runOptimize();
        }
        this.bA = newBA;
        this.ebM.or(otherBsi.ebM);
        this.runOptimized = this.runOptimized != false || otherBsi.runOptimized != false;
        this.maxValue = Integer.max(this.maxValue, otherBsi.maxValue);
        this.minValue = Integer.min(this.minValue, otherBsi.minValue);
    }

    public RoaringBitmapSliceIndex clone() {
        RoaringBitmapSliceIndex bitSliceIndex = new RoaringBitmapSliceIndex();
        bitSliceIndex.minValue = this.minValue;
        bitSliceIndex.maxValue = this.maxValue;
        bitSliceIndex.ebM = this.ebM.clone();
        RoaringBitmap[] cloneBA = new RoaringBitmap[this.bitCount()];
        for (int i = 0; i < cloneBA.length; ++i) {
            cloneBA[i] = this.bA[i].clone();
        }
        bitSliceIndex.bA = cloneBA;
        bitSliceIndex.runOptimized = this.runOptimized;
        return bitSliceIndex;
    }

    private RoaringBitmap oNeilCompare(BitmapSliceIndex.Operation operation, int predicate, RoaringBitmap foundSet) {
        RoaringBitmap fixedFoundSet = foundSet == null ? this.ebM : foundSet;
        RoaringBitmap GT = new RoaringBitmap();
        RoaringBitmap LT = new RoaringBitmap();
        RoaringBitmap EQ = this.ebM;
        for (int i = this.bitCount() - 1; i >= 0; --i) {
            int bit = predicate >> i & 1;
            if (bit == 1) {
                LT = RoaringBitmap.or((RoaringBitmap)LT, (RoaringBitmap)RoaringBitmap.andNot((RoaringBitmap)EQ, (RoaringBitmap)this.bA[i]));
                EQ = RoaringBitmap.and((RoaringBitmap)EQ, (RoaringBitmap)this.bA[i]);
                continue;
            }
            GT = RoaringBitmap.or((RoaringBitmap)GT, (RoaringBitmap)RoaringBitmap.and((RoaringBitmap)EQ, (RoaringBitmap)this.bA[i]));
            EQ = RoaringBitmap.andNot((RoaringBitmap)EQ, (RoaringBitmap)this.bA[i]);
        }
        EQ = RoaringBitmap.and((RoaringBitmap)fixedFoundSet, (RoaringBitmap)EQ);
        switch (operation) {
            case EQ: {
                return EQ;
            }
            case NEQ: {
                return RoaringBitmap.andNot((RoaringBitmap)fixedFoundSet, (RoaringBitmap)EQ);
            }
            case GT: {
                return RoaringBitmap.and((RoaringBitmap)GT, (RoaringBitmap)fixedFoundSet);
            }
            case LT: {
                return RoaringBitmap.and((RoaringBitmap)LT, (RoaringBitmap)fixedFoundSet);
            }
            case LE: {
                return RoaringBitmap.or((RoaringBitmap)LT, (RoaringBitmap)EQ);
            }
            case GE: {
                return RoaringBitmap.or((RoaringBitmap)GT, (RoaringBitmap)EQ);
            }
        }
        throw new IllegalArgumentException("");
    }

    public RoaringBitmap compare(BitmapSliceIndex.Operation operation, int startOrValue, int end, RoaringBitmap foundSet) {
        RoaringBitmap result = this.compareUsingMinMax(operation, startOrValue, end, foundSet);
        if (result != null) {
            return result;
        }
        switch (operation) {
            case EQ: {
                return this.oNeilCompare(BitmapSliceIndex.Operation.EQ, startOrValue, foundSet);
            }
            case NEQ: {
                return this.oNeilCompare(BitmapSliceIndex.Operation.NEQ, startOrValue, foundSet);
            }
            case GE: {
                return this.oNeilCompare(BitmapSliceIndex.Operation.GE, startOrValue, foundSet);
            }
            case GT: {
                return this.oNeilCompare(BitmapSliceIndex.Operation.GT, startOrValue, foundSet);
            }
            case LT: {
                return this.oNeilCompare(BitmapSliceIndex.Operation.LT, startOrValue, foundSet);
            }
            case LE: {
                return this.oNeilCompare(BitmapSliceIndex.Operation.LE, startOrValue, foundSet);
            }
            case RANGE: {
                RoaringBitmap left = this.oNeilCompare(BitmapSliceIndex.Operation.GE, startOrValue, foundSet);
                RoaringBitmap right = this.oNeilCompare(BitmapSliceIndex.Operation.LE, end, foundSet);
                return RoaringBitmap.and((RoaringBitmap)left, (RoaringBitmap)right);
            }
        }
        throw new IllegalArgumentException("not support operation!");
    }

    private RoaringBitmap compareUsingMinMax(BitmapSliceIndex.Operation operation, int startOrValue, int end, RoaringBitmap foundSet) {
        RoaringBitmap all = foundSet == null ? this.ebM.clone() : RoaringBitmap.and((RoaringBitmap)this.ebM, (RoaringBitmap)foundSet);
        RoaringBitmap empty = new RoaringBitmap();
        switch (operation) {
            case LT: {
                if (startOrValue > this.maxValue) {
                    return all;
                }
                if (startOrValue > this.minValue) break;
                return empty;
            }
            case LE: {
                if (startOrValue >= this.maxValue) {
                    return all;
                }
                if (startOrValue >= this.minValue) break;
                return empty;
            }
            case GT: {
                if (startOrValue < this.minValue) {
                    return all;
                }
                if (startOrValue < this.maxValue) break;
                return empty;
            }
            case GE: {
                if (startOrValue <= this.minValue) {
                    return all;
                }
                if (startOrValue <= this.maxValue) break;
                return empty;
            }
            case EQ: {
                if (this.minValue == this.maxValue && this.minValue == startOrValue) {
                    return all;
                }
                if (startOrValue >= this.minValue && startOrValue <= this.maxValue) break;
                return empty;
            }
            case NEQ: {
                if (this.minValue != this.maxValue) break;
                return this.minValue == startOrValue ? empty : all;
            }
            case RANGE: {
                if (startOrValue <= this.minValue && end >= this.maxValue) {
                    return all;
                }
                if (startOrValue <= this.maxValue && end >= this.minValue) break;
                return empty;
            }
            default: {
                return null;
            }
        }
        return null;
    }

    public Pair<Long, Long> sum(RoaringBitmap foundSet) {
        if (null == foundSet || foundSet.isEmpty()) {
            return Pair.newPair(0L, 0L);
        }
        long count = foundSet.getLongCardinality();
        Long sum = IntStream.range(0, this.bitCount()).mapToLong(x -> (long)(1 << x) * (long)RoaringBitmap.andCardinality((RoaringBitmap)this.bA[x], (RoaringBitmap)foundSet)).sum();
        return Pair.newPair(sum, count);
    }
}

