/*
 * Decompiled with CFR 0.152.
 */
package org.riftsaw.engine.internal;

import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.iapi.CacheProvider;
import org.apache.ode.il.cache.HashMapCache;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.riftsaw.engine.internal.InfinispanCache;

public class InfinispanCacheProvider
implements CacheProvider {
    private static Log logger = LogFactory.getLog(InfinispanCacheProvider.class);
    private Cache cache;

    public void start(Properties properties) throws Exception {
        try {
            EmbeddedCacheManager ecm = (EmbeddedCacheManager)new InitialContext().lookup("java:jboss/infinispan/container/" + properties.getProperty("cache-name", "cluster"));
            this.cache = ecm.getCache();
            this.cache.start();
        }
        catch (NamingException e) {
            logger.debug((Object)"Using the default HashMapCache as the cache provider", (Throwable)e);
        }
    }

    public <K, V> org.apache.ode.bpel.iapi.Cache<K, V> createCache() {
        if (this.cache == null) {
            return new HashMapCache();
        }
        return new InfinispanCache(this.cache);
    }

    public void stop() throws Exception {
        if (this.cache != null) {
            this.cache.stop();
        }
    }
}

