/*
 * Decompiled with CFR 0.152.
 */
package org.riftsaw.engine.internal;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.epr.EndpointFactory;
import org.apache.ode.bpel.epr.MutableEndpoint;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.EndpointReferenceContext;
import org.apache.ode.utils.DOMUtils;
import org.riftsaw.engine.internal.BPELEngineImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EndpointReferenceContextImpl
implements EndpointReferenceContext {
    private static final Log LOG = LogFactory.getLog(EndpointReferenceContextImpl.class);

    public EndpointReferenceContextImpl(BPELEngineImpl server) {
    }

    public EndpointReference resolveEndpointReference(Element element) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Resolving endpoint reference " + DOMUtils.domToString((Node)element)));
        }
        return EndpointFactory.createEndpoint((Element)element);
    }

    public EndpointReference convertEndpoint(QName qName, Element element) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Convert endpoint reference: qname=" + qName + " element=" + DOMUtils.domToString((Node)element)));
        }
        MutableEndpoint endpoint = EndpointFactory.convert((QName)qName, (Element)element);
        return endpoint;
    }

    public Map<?, ?> getConfigLookup(EndpointReference epr) {
        HashMap result = null;
        if (epr instanceof MutableEndpoint) {
            result = ((MutableEndpoint)epr).toMap();
        } else {
            result = new HashMap();
            LOG.debug((Object)"Map access not implemented");
        }
        return result;
    }
}

