/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.whatswrong.javautils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Counter<T>
extends HashMap<T, Integer> {
    @Override
    public Integer get(Object o) {
        Integer original = (Integer)super.get(o);
        return original == null ? 0 : original;
    }

    public void increment(T value, int howmuch) {
        Integer old = (Integer)super.get(value);
        this.put(value, old == null ? howmuch : old + howmuch);
    }

    public static Counter<String> loadFromFile(File file) throws IOException {
        Counter<String> result = new Counter<String>();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = reader.readLine();
        while (line != null) {
            if (!line.trim().equals("")) {
                String[] split = line.split("[ \t]");
                result.increment(split[0], Integer.valueOf(split[1]));
            }
            line = reader.readLine();
        }
        return result;
    }

    public List<Map.Entry<T, Integer>> sorted(final boolean descending) {
        ArrayList<Map.Entry<T, Integer>> sorted = new ArrayList<Map.Entry<T, Integer>>(this.entrySet());
        Collections.sort(sorted, new Comparator<Map.Entry<T, Integer>>(){

            @Override
            public int compare(Map.Entry<T, Integer> o1, Map.Entry<T, Integer> o2) {
                return (descending ? 1 : -1) * (o2.getValue() - o1.getValue());
            }
        });
        return sorted;
    }

    public void save(OutputStream outputStream) {
        PrintStream out = new PrintStream(outputStream);
        for (Map.Entry<T, Integer> entry : this.sorted(true)) {
            out.println(entry.getKey() + "\t" + entry.getValue());
        }
    }

    public int getMaximum() {
        int max = 0;
        for (Integer value : this.values()) {
            if (value <= max) continue;
            max = value;
        }
        return max;
    }
}

