/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.whatswrong.io;

import com.googlecode.whatswrong.NLPInstance;
import com.googlecode.whatswrong.SimpleGridBagConstraints;
import com.googlecode.whatswrong.io.CorpusFormat;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TheBeastFormat
implements CorpusFormat {
    private JPanel accessory = new JPanel(new GridBagLayout());
    private JTextField deps = new JTextField();
    private JTextField tokens = new JTextField();
    private JTextField spans = new JTextField();
    private CorpusFormat.Monitor monitor;

    public TheBeastFormat() {
        this.accessory.add((Component)new JLabel("Tokens:"), new SimpleGridBagConstraints(0, true));
        this.accessory.add((Component)this.tokens, new SimpleGridBagConstraints(0, false));
        this.accessory.add((Component)new JLabel("Deps:"), new SimpleGridBagConstraints(1, true));
        this.accessory.add((Component)this.deps, new SimpleGridBagConstraints(1, false));
        this.accessory.add((Component)new JLabel("Spans:"), new SimpleGridBagConstraints(2, true));
        this.accessory.add((Component)this.spans, new SimpleGridBagConstraints(2, false));
    }

    private static String unquote(String string) {
        return string.substring(1, string.length() - 1);
    }

    @Override
    public void setMonitor(CorpusFormat.Monitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public void loadProperties(Properties properties, String prefix) {
        this.deps.setText(properties.getProperty(prefix + ".thebeast.deps", ""));
        this.spans.setText(properties.getProperty(prefix + ".thebeast.spans", ""));
        this.tokens.setText(properties.getProperty(prefix + ".thebeast.tokens", ""));
    }

    @Override
    public void saveProperties(Properties properties, String prefix) {
        properties.setProperty(prefix + ".thebeast.deps", this.deps.getText());
        properties.setProperty(prefix + ".thebeast.spans", this.spans.getText());
        properties.setProperty(prefix + ".thebeast.tokens", this.tokens.getText());
    }

    @Override
    public String getName() {
        return "thebeast";
    }

    @Override
    public String getLongName() {
        return this.getName();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public JComponent getAccessory() {
        return this.accessory;
    }

    private Map<String, String> extractPredicatesFromString(String text) {
        HashMap<String, String> preds = new HashMap<String, String>();
        for (String s : text.split("[,]")) {
            int index = (s = s.trim()).indexOf(58);
            if (index == -1) {
                preds.put(s, s);
                continue;
            }
            String pred = s.substring(0, index);
            String as = s.substring(index + 1);
            preds.put(pred, as);
        }
        return preds;
    }

    @Override
    public List<NLPInstance> load(File file, int from, int to) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        Map<String, String> tokenPreds = this.extractPredicatesFromString(this.tokens.getText());
        Map<String, String> depPreds = this.extractPredicatesFromString(this.deps.getText());
        Map<String, String> spanPreds = this.extractPredicatesFromString(this.spans.getText());
        int instanceNr = 0;
        NLPInstance instance = new NLPInstance();
        String asToken = null;
        String asDep = null;
        String asSpan = null;
        ArrayList<NLPInstance> result = new ArrayList<NLPInstance>(1000);
        HashMap rows = new HashMap();
        for (String pred : tokenPreds.values()) {
            rows.put(pred, new ArrayList());
        }
        for (String pred : spanPreds.values()) {
            rows.put(pred, new ArrayList());
        }
        for (String pred : depPreds.values()) {
            rows.put(pred, new ArrayList());
        }
        String line = reader.readLine();
        while (line != null && instanceNr < to) {
            if (line.startsWith(">>")) {
                this.monitor.progressed(instanceNr);
                if (instanceNr++ > from && instanceNr > 1) {
                    for (String pred : tokenPreds.values()) {
                        this.addTokens((List)rows.get(pred), pred, instance);
                    }
                    instance.consistify();
                    for (String pred : depPreds.values()) {
                        this.addDeps((List)rows.get(pred), pred, instance);
                    }
                    for (String pred : spanPreds.values()) {
                        this.addSpans((List)rows.get(pred), pred, instance);
                    }
                    result.add(instance);
                    instance = new NLPInstance();
                    rows.clear();
                    for (String pred : tokenPreds.values()) {
                        rows.put(pred, new ArrayList());
                    }
                    for (String pred : spanPreds.values()) {
                        rows.put(pred, new ArrayList());
                    }
                    for (String pred : depPreds.values()) {
                        rows.put(pred, new ArrayList());
                    }
                }
            } else if (line.startsWith(">") && instanceNr > from) {
                String pred;
                pred = line.substring(1);
                asToken = tokenPreds.get(pred);
                asDep = depPreds.get(pred);
                asSpan = spanPreds.get(pred);
            } else if (!(line = line.trim()).equals("") && instanceNr > from) {
                StringTokenizer tokenizer = new StringTokenizer(line, "\t");
                ArrayList<String> row = new ArrayList<String>();
                while (tokenizer.hasMoreElements()) {
                    row.add(tokenizer.nextToken());
                }
                if (asToken != null) {
                    ((List)rows.get(asToken)).add(row);
                }
                if (asDep != null) {
                    ((List)rows.get(asDep)).add(row);
                }
                if (asSpan != null) {
                    ((List)rows.get(asSpan)).add(row);
                }
            }
            line = reader.readLine();
        }
        for (String pred : tokenPreds.values()) {
            this.addTokens((List)rows.get(pred), pred, instance);
        }
        instance.consistify();
        for (String pred : depPreds.values()) {
            this.addDeps((List)rows.get(pred), pred, instance);
        }
        for (String pred : spanPreds.values()) {
            this.addSpans((List)rows.get(pred), pred, instance);
        }
        result.add(instance);
        return result;
    }

    private void addTokens(List<List<String>> rows, String type, NLPInstance instance) {
        for (List<String> row : rows) {
            try {
                instance.addToken(Integer.parseInt(row.get(0))).addProperty(type, TheBeastFormat.unquote(row.get(1)));
            }
            catch (Exception e) {
                System.out.println("Could not load tokens from row " + row + " of rows " + rows + ", skipping this row.");
            }
        }
    }

    private void addDeps(List<List<String>> rows, String type, NLPInstance instance) {
        for (List<String> row : rows) {
            if (row.size() == 4) {
                instance.addDependency(Integer.parseInt(row.get(0)), Integer.parseInt(row.get(1)), TheBeastFormat.unquote(row.get(2)), type, TheBeastFormat.unquote(row.get(3)).replaceAll("-BR-", "\n\t"));
                continue;
            }
            instance.addDependency(Integer.parseInt(row.get(0)), Integer.parseInt(row.get(1)), TheBeastFormat.unquote(row.get(2)), type);
        }
    }

    private void addSpans(List<List<String>> rows, String type, NLPInstance instance) {
        for (List<String> row : rows) {
            if (row.size() == 3) {
                instance.addSpan(Integer.parseInt(row.get(0)), Integer.parseInt(row.get(1)), TheBeastFormat.unquote(row.get(2)), type);
                continue;
            }
            if (row.size() == 2) {
                int token = Integer.parseInt(row.get(0));
                instance.addSpan(token, token, TheBeastFormat.unquote(row.get(1)), type);
                continue;
            }
            if (row.size() != 4) continue;
            instance.addSpan(Integer.parseInt(row.get(0)), Integer.parseInt(row.get(1)), TheBeastFormat.unquote(row.get(2)), type, TheBeastFormat.unquote(row.get(3)).replaceAll("-BR-", "\n\t"));
        }
    }
}

