/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.whatswrong.io;

import com.googlecode.whatswrong.NLPInstance;
import com.googlecode.whatswrong.SimpleGridBagConstraints;
import com.googlecode.whatswrong.io.CoNLL2000;
import com.googlecode.whatswrong.io.CoNLL2002;
import com.googlecode.whatswrong.io.CoNLL2003;
import com.googlecode.whatswrong.io.CoNLL2004;
import com.googlecode.whatswrong.io.CoNLL2006;
import com.googlecode.whatswrong.io.CoNLL2008;
import com.googlecode.whatswrong.io.CoNLL2009;
import com.googlecode.whatswrong.io.CorpusFormat;
import com.googlecode.whatswrong.io.MaltTab;
import com.googlecode.whatswrong.io.TabProcessor;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabFormat
implements CorpusFormat {
    private JPanel accessory;
    private SortedMap<String, TabProcessor> processors = new TreeMap<String, TabProcessor>();
    private JComboBox type;
    private JCheckBox open;
    private CorpusFormat.Monitor monitor;

    public TabFormat() {
        this.addProcessor("CoNLL 2009", new CoNLL2009());
        this.addProcessor("CoNLL 2008", new CoNLL2008());
        this.addProcessor("CoNLL 2006", new CoNLL2006());
        this.addProcessor("CoNLL 2004", new CoNLL2004());
        this.addProcessor("CoNLL 2002", new CoNLL2002());
        this.addProcessor("CoNLL 2003", new CoNLL2003());
        this.addProcessor("CoNLL 2000", new CoNLL2000());
        this.addProcessor(new MaltTab());
        this.accessory = new JPanel(new GridBagLayout());
        this.type = new JComboBox<TabProcessor>(new Vector<TabProcessor>(this.processors.values()));
        this.type.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TabFormat.this.open.setEnabled(((TabProcessor)TabFormat.this.type.getSelectedItem()).supportsOpen());
            }
        });
        this.open = new JCheckBox("open", false);
        this.open.setToolTipText("If checked an additional file with same name but .open extension is also loaded");
        this.open.setEnabled(((TabProcessor)this.type.getSelectedItem()).supportsOpen());
        this.accessory.add((Component)new JLabel("Type:"), new SimpleGridBagConstraints(0, true));
        this.accessory.add((Component)this.type, new SimpleGridBagConstraints(0, false));
        this.accessory.add((Component)this.open, new SimpleGridBagConstraints(1, false));
    }

    public void addProcessor(String name, TabProcessor processor) {
        this.processors.put(name, processor);
    }

    public void addProcessor(TabProcessor processor) {
        this.processors.put(processor.toString(), processor);
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getName() {
        return "TAB-separated";
    }

    @Override
    public String getLongName() {
        return this.getName() + "(" + this.type.getSelectedItem().toString() + ")";
    }

    @Override
    public JComponent getAccessory() {
        return this.accessory;
    }

    @Override
    public void setMonitor(CorpusFormat.Monitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public void loadProperties(Properties properties, String prefix) {
        String yearString = properties.getProperty(prefix + ".tab.type", "CoNLL 2008");
        this.type.setSelectedItem(this.processors.get(yearString));
    }

    @Override
    public void saveProperties(Properties properties, String prefix) {
        properties.setProperty(prefix + ".tab.type", this.type.getSelectedItem().toString());
    }

    @Override
    public List<NLPInstance> load(File file, int from, int to) throws IOException {
        TabProcessor processor = (TabProcessor)this.type.getSelectedItem();
        List<NLPInstance> result = this.loadTabs(file, from, to, processor, false);
        if (this.open.isSelected()) {
            String filename = file.getName().substring(0, file.getName().lastIndexOf(46)) + ".open";
            File openFile = new File(file.getParent() + "/" + filename);
            List<NLPInstance> openCorpus = this.loadTabs(openFile, from, to, processor, true);
            for (int i = 0; i < openCorpus.size(); ++i) {
                result.get(i).merge(openCorpus.get(i));
            }
        }
        return result;
    }

    private List<NLPInstance> loadTabs(File file, int from, int to, TabProcessor processor, boolean open) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        ArrayList<NLPInstance> corpus = new ArrayList<NLPInstance>();
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        int instanceNr = 0;
        String line = reader.readLine();
        while (line != null && instanceNr < to) {
            if ((line = line.trim()).equals("")) {
                this.monitor.progressed(instanceNr);
                if (instanceNr++ >= from) {
                    NLPInstance instance = open ? processor.createOpen(rows) : processor.create(rows);
                    corpus.add(instance);
                    rows.clear();
                }
            } else if (instanceNr >= from) {
                rows.add(Arrays.asList(line.split("\\s+")));
            }
            line = reader.readLine();
        }
        if (rows.size() > 0) {
            corpus.add(open ? processor.createOpen(rows) : processor.create(rows));
        }
        return corpus;
    }

    public static void extractSpan03(List<? extends List<String>> rows, int column, String type, NLPInstance instance) {
        int index = 0;
        boolean inChunk = false;
        int begin = 0;
        String currentChunk = "";
        for (List<String> list : rows) {
            String chunk = list.get(column);
            int minus = chunk.indexOf(45);
            if (minus != -1) {
                String bio = chunk.substring(0, minus);
                String label = chunk.substring(minus + 1);
                if (inChunk) {
                    if ("B".equals(bio) || "I".equals(bio) && !label.equals(currentChunk)) {
                        instance.addSpan(begin, index - 1, currentChunk, type);
                        begin = index;
                        currentChunk = label;
                    }
                } else {
                    inChunk = true;
                    begin = index;
                    currentChunk = label;
                }
            } else if (inChunk) {
                instance.addSpan(begin, index - 1, currentChunk, type);
                inChunk = false;
            }
            ++index;
        }
        if (inChunk) {
            instance.addSpan(begin, index - 1, currentChunk, type);
        }
    }

    public static void extractSpan00(List<? extends List<String>> rows, int column, String type, NLPInstance instance) {
        int index = 0;
        boolean inChunk = false;
        int begin = 0;
        String currentChunk = "";
        for (List<String> list : rows) {
            String chunk = list.get(column);
            int minus = chunk.indexOf(45);
            if (minus != -1) {
                String bio = chunk.substring(0, minus);
                String label = chunk.substring(minus + 1);
                if ("B".equals(bio)) {
                    if (inChunk) {
                        instance.addSpan(begin, index - 1, currentChunk, type);
                    }
                    begin = index;
                    currentChunk = label;
                    inChunk = true;
                }
            } else if (inChunk) {
                instance.addSpan(begin, index - 1, currentChunk, type);
                inChunk = false;
            }
            ++index;
        }
    }

    public static void extractSpan05(List<? extends List<String>> rows, int column, String type, String prefix, NLPInstance instance) {
        int index = 0;
        int begin = 0;
        String currentChunk = "";
        for (List<String> list : rows) {
            String chunk = list.get(column);
            if (chunk.startsWith("(")) {
                currentChunk = chunk.substring(1, chunk.indexOf("*"));
                begin = index;
            }
            if (chunk.endsWith(")")) {
                instance.addSpan(begin, index, prefix + currentChunk, type);
            }
            ++index;
        }
    }
}

