/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.whatswrong.io;

import com.googlecode.whatswrong.Edge;
import com.googlecode.whatswrong.NLPInstance;
import com.googlecode.whatswrong.SimpleGridBagConstraints;
import com.googlecode.whatswrong.Token;
import com.googlecode.whatswrong.io.CorpusFormat;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.WildcardFileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BioNLP2009SharedTaskFormat
implements CorpusFormat {
    private JPanel accessory = new JPanel(new GridBagLayout());
    private JTextField txtExtensionField = new JTextField("txt");
    private JTextField proteinExtensionField = new JTextField("a1");
    private JTextField eventExtensionField = new JTextField("a2");
    private CorpusFormat.Monitor monitor;

    public BioNLP2009SharedTaskFormat() {
        this.accessory.add((Component)new JLabel("Text files:"), new SimpleGridBagConstraints(0, true));
        this.accessory.add((Component)this.txtExtensionField, new SimpleGridBagConstraints(0, false));
        this.accessory.add((Component)new JLabel("Protein files:"), new SimpleGridBagConstraints(1, true));
        this.accessory.add((Component)this.proteinExtensionField, new SimpleGridBagConstraints(1, false));
        this.accessory.add((Component)new JLabel("Event files:"), new SimpleGridBagConstraints(2, true));
        this.accessory.add((Component)this.eventExtensionField, new SimpleGridBagConstraints(2, false));
    }

    @Override
    public String getName() {
        return "BioNLP 2009 ST";
    }

    @Override
    public String getLongName() {
        return this.getName();
    }

    @Override
    public JComponent getAccessory() {
        return this.accessory;
    }

    @Override
    public void setMonitor(CorpusFormat.Monitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public void loadProperties(Properties properties, String prefix) {
        this.txtExtensionField.setText(properties.getProperty(prefix + ".bionlp09.txt", "txt"));
        this.proteinExtensionField.setText(properties.getProperty(prefix + ".bionlp09.protein", "a1"));
        this.eventExtensionField.setText(properties.getProperty(prefix + ".bionlp09.event", "a2"));
    }

    @Override
    public void saveProperties(Properties properties, String prefix) {
        properties.setProperty(prefix + ".bionlp09.txt", this.txtExtensionField.getText());
        properties.setProperty(prefix + ".bionlp09.protein", this.proteinExtensionField.getText());
        properties.setProperty(prefix + ".bionlp09.event", this.eventExtensionField.getText());
    }

    @Override
    public List<NLPInstance> load(File file, int from, int to) throws IOException {
        ArrayList<NLPInstance> result = new ArrayList<NLPInstance>();
        int index = 0;
        for (File txtFile : file.listFiles((FileFilter)new WildcardFileFilter("*." + this.txtExtensionField.getText().trim()))) {
            String filename = txtFile.getAbsolutePath();
            String prefix = filename.substring(0, filename.lastIndexOf("."));
            File proteinFile = new File(prefix + "." + this.proteinExtensionField.getText().trim());
            File eventFile = new File(prefix + "." + this.eventExtensionField.getText().trim());
            if (!proteinFile.exists() || !eventFile.exists()) continue;
            result.add(this.load(txtFile, proteinFile, eventFile));
            this.monitor.progressed(index++);
        }
        return result;
    }

    private NLPInstance load(File txtFile, File proteinFile, File eventFile) throws IOException {
        String id;
        String[] split;
        String line;
        TIntObjectHashMap charToToken = new TIntObjectHashMap();
        FileReader reader = new FileReader(txtFile);
        int currentIndex = 0;
        NLPInstance result = new NLPInstance();
        Token currentToken = result.addToken();
        StringBuffer currentTokenContent = new StringBuffer("");
        int character = reader.read();
        while (character != -1) {
            charToToken.put(currentIndex, (Object)currentToken);
            if (character == 32 || character == 10) {
                if (currentTokenContent.length() > 0) {
                    currentToken.addProperty("Word", currentTokenContent.toString());
                    currentToken.addProperty("Index", String.valueOf(result.getTokens().size() - 1));
                    currentTokenContent.setLength(0);
                    currentToken = result.addToken();
                }
            } else {
                currentTokenContent.append(Character.valueOf((char)character));
            }
            ++currentIndex;
            character = reader.read();
        }
        List proteinLines = IOUtils.readLines((Reader)new FileReader(proteinFile));
        LinkedHashMap<String, Token> id2Token = new LinkedHashMap<String, Token>();
        for (Object lineObject : proteinLines) {
            String line2 = (String)lineObject;
            String[] split2 = line2.split("\\s+");
            if (!split2[0].startsWith("T")) continue;
            String id2 = split2[0];
            String type = split2[1];
            int from = Integer.valueOf(split2[2]);
            int to = Integer.valueOf(split2[3]);
            Token fromToken = (Token)charToToken.get(from);
            Token toToken = (Token)charToToken.get(to);
            result.addEdge(fromToken, toToken, type, "protein", Edge.RenderType.span);
            id2Token.put(id2, toToken);
        }
        List eventLines = IOUtils.readLines((Reader)new FileReader(eventFile));
        for (Object lineObject : eventLines) {
            line = (String)lineObject;
            split = line.split("\\s+");
            id = split[0];
            if (id.startsWith("T")) {
                String type = split[1];
                int from = Integer.valueOf(split[2]);
                int to = Integer.valueOf(split[3]);
                Token fromToken = (Token)charToToken.get(from);
                Token toToken = (Token)charToToken.get(to);
                String termClass = type.equals("Entity") ? "entity" : "event";
                result.addEdge(fromToken, toToken, type, termClass, Edge.RenderType.span);
                id2Token.put(id, toToken);
                continue;
            }
            if (!id.startsWith("E")) continue;
            String[] typeAndMentionId = split[1].split("[:]");
            Token evenToken = (Token)id2Token.get(typeAndMentionId[1]);
            id2Token.put(id, evenToken);
        }
        for (Object lineObject : eventLines) {
            line = (String)lineObject;
            split = line.split("\\s+");
            id = split[0];
            if (!id.startsWith("E")) continue;
            Token evenToken = (Token)id2Token.get(id);
            for (int i = 2; i < split.length; ++i) {
                String[] roleAndId = split[i].split("[:]");
                Token argToken = (Token)id2Token.get(roleAndId[1]);
                if (argToken == null) {
                    throw new RuntimeException("There seems to be no mention associated with id " + roleAndId[1] + " for event " + id + " in file " + eventFile);
                }
                result.addEdge(new Edge(evenToken, argToken, roleAndId[0], id, "role", Edge.RenderType.dependency));
            }
        }
        return result;
    }

    public String toString() {
        return this.getName();
    }
}

