/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.whatswrong;

import com.googlecode.whatswrong.Bounds1D;
import com.googlecode.whatswrong.NLPInstance;
import com.googlecode.whatswrong.Token;
import com.googlecode.whatswrong.TokenProperty;
import com.googlecode.whatswrong.javautils.Pair;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenLayout {
    private HashMap<Pair<Token, Integer>, TextLayout> textLayouts = new HashMap();
    private HashMap<Token, Rectangle2D> bounds = new HashMap();
    private int rowHeight = 14;
    private int baseline = 0;
    private int margin = 20;
    private int fromSplitPoint = -1;
    private int toSplitPoint = -1;
    private int width;
    private int height;

    public void setRowHeight(int rowHeight) {
        this.rowHeight = rowHeight;
    }

    public void setBaseline(int baseline) {
        this.baseline = baseline;
    }

    public int getFromSplitPoint() {
        return this.fromSplitPoint;
    }

    public void setFromSplitPoint(int fromSplitPoint) {
        this.fromSplitPoint = fromSplitPoint;
    }

    public int getToSplitPoint() {
        return this.toSplitPoint;
    }

    public void setToSplitPoint(int toSplitPoint) {
        this.toSplitPoint = toSplitPoint;
    }

    public void setMargin(int margin) {
        this.margin = margin;
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public int getBaseline() {
        return this.baseline;
    }

    public int getMargin() {
        return this.margin;
    }

    public Map<Token, Bounds1D> estimateTokenBounds(NLPInstance instance, Map<Token, Integer> tokenWidths, Graphics2D g2d) {
        HashMap<Token, Bounds1D> result = new HashMap<Token, Bounds1D>();
        this.height = 0;
        List<Token> tokens = instance.getTokens();
        if (tokens.size() == 0) {
            return result;
        }
        int lastx = 0;
        int fromToken = this.fromSplitPoint == -1 ? 0 : instance.getSplitPoints().get(this.fromSplitPoint);
        int toToken = this.toSplitPoint == -1 ? tokens.size() : instance.getSplitPoints().get(this.toSplitPoint).intValue();
        for (int tokenIndex = fromToken; tokenIndex < toToken; ++tokenIndex) {
            Token token = tokens.get(tokenIndex);
            Font font = g2d.getFont();
            FontRenderContext frc = g2d.getFontRenderContext();
            int maxX = 0;
            int lasty = this.baseline + this.rowHeight;
            for (TokenProperty p : token.getSortedProperties()) {
                String property = token.getProperty(p);
                TextLayout layout = new TextLayout(property, font, frc);
                lasty += this.rowHeight;
                if (!(layout.getBounds().getMaxX() > (double)maxX)) continue;
                maxX = (int)layout.getBounds().getMaxX();
            }
            Integer requiredWidth = tokenWidths.get(token);
            if (requiredWidth != null && maxX < requiredWidth) {
                maxX = requiredWidth;
            }
            result.put(token, new Bounds1D(lastx, lastx + maxX));
            lastx += maxX + this.margin;
            if (lasty - this.rowHeight <= this.height) continue;
            this.height = lasty - this.rowHeight;
        }
        return result;
    }

    public Dimension layout(NLPInstance instance, Map<Token, Integer> tokenWidths, Graphics2D g2d) {
        List<Token> tokens = instance.getTokens();
        if (tokens.size() == 0) {
            this.height = 1;
            this.width = 1;
            return new Dimension(this.width, this.height);
        }
        this.textLayouts.clear();
        int lastx = 0;
        this.height = 0;
        g2d.setColor(Color.BLACK);
        int fromToken = this.fromSplitPoint == -1 ? 0 : instance.getSplitPoints().get(this.fromSplitPoint);
        int toToken = this.toSplitPoint == -1 ? tokens.size() : instance.getSplitPoints().get(this.toSplitPoint).intValue();
        for (int tokenIndex = fromToken; tokenIndex < toToken; ++tokenIndex) {
            Token token = tokens.get(tokenIndex);
            Font font = g2d.getFont();
            FontRenderContext frc = g2d.getFontRenderContext();
            int index = 0;
            int lasty = this.baseline + this.rowHeight;
            int maxX = 0;
            for (TokenProperty p : token.getSortedProperties()) {
                String property = token.getProperty(p);
                g2d.setColor(index == 0 ? Color.BLACK : Color.GRAY);
                TextLayout layout = new TextLayout(property, font, frc);
                layout.draw(g2d, lastx, lasty);
                lasty += this.rowHeight;
                if (layout.getBounds().getMaxX() > (double)maxX) {
                    maxX = (int)layout.getBounds().getMaxX();
                }
                this.textLayouts.put(new Pair<Token, Integer>(token, index++), layout);
            }
            Integer requiredWidth = tokenWidths.get(token);
            if (requiredWidth != null && maxX < requiredWidth) {
                maxX = requiredWidth;
            }
            this.bounds.put(token, new Rectangle(lastx, this.baseline, maxX, lasty - this.baseline));
            lastx += maxX + this.margin;
            if (lasty - this.rowHeight <= this.height) continue;
            this.height = lasty - this.rowHeight;
        }
        this.width = lastx - this.margin;
        return new Dimension(this.width, this.height + 2);
    }

    public TextLayout getPropertyTextLayout(Token vertex, int index) {
        return this.textLayouts.get(new Pair<Token, Integer>(vertex, index));
    }

    public Rectangle2D getBounds(Token vertex) {
        return this.bounds.get(vertex);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height + 4;
    }
}

