/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.whatswrong;

import com.googlecode.whatswrong.Bounds1D;
import com.googlecode.whatswrong.DependencyLayout;
import com.googlecode.whatswrong.Edge;
import com.googlecode.whatswrong.NLPCanvasRenderer;
import com.googlecode.whatswrong.NLPInstance;
import com.googlecode.whatswrong.SpanLayout;
import com.googlecode.whatswrong.Token;
import com.googlecode.whatswrong.TokenLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Map;

public class SingleSentenceRenderer
implements NLPCanvasRenderer {
    private SpanLayout spanLayout = new SpanLayout();
    private DependencyLayout dependencyLayout = new DependencyLayout();
    private TokenLayout tokenLayout = new TokenLayout();
    private boolean antiAliasing = true;
    private int startOfTokens = 0;
    private int startOfSpans = 0;

    public Dimension render(NLPInstance instance, Graphics2D graphics2D) {
        ArrayList<Token> tokens = new ArrayList<Token>(instance.getTokens());
        ArrayList<Edge> dependencies = new ArrayList<Edge>(instance.getEdges(Edge.RenderType.dependency));
        ArrayList<Edge> spans = new ArrayList<Edge>(instance.getEdges(Edge.RenderType.span));
        Map<Token, Integer> widths = this.spanLayout.estimateRequiredTokenWidths(spans, graphics2D);
        Map<Token, Bounds1D> tokenXBounds = this.tokenLayout.estimateTokenBounds(instance, widths, graphics2D);
        if (this.antiAliasing) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        int width = 0;
        int height = 0;
        Dimension dim = this.dependencyLayout.layoutEdges(dependencies, tokenXBounds, graphics2D);
        this.startOfTokens = height += dim.height;
        width = dim.width > width ? dim.width : width;
        graphics2D.translate(0, dim.height);
        dim = this.tokenLayout.layout(instance, widths, graphics2D);
        this.startOfSpans = height += dim.height;
        width = dim.width > width ? dim.width : width;
        graphics2D.translate(0, dim.height);
        dim = this.spanLayout.layoutEdges(spans, tokenXBounds, graphics2D);
        width = dim.width > width ? dim.width : width;
        return new Dimension(width, (height += dim.height) + 1);
    }

    public void setAntiAliasing(boolean antiAliasing) {
        this.antiAliasing = antiAliasing;
    }

    public void setMargin(int margin) {
        this.tokenLayout.setMargin(margin);
    }

    public int getMargin() {
        return this.tokenLayout.getMargin();
    }

    public Edge getEdgeAt(Point2D p, int radius) {
        System.out.println("dependencyLayout height = " + this.dependencyLayout.getHeight());
        if (p.getY() < (double)this.startOfTokens) {
            return this.dependencyLayout.getEdgeAt(p, radius);
        }
        Point2D.Double shifted = new Point2D.Double(p.getX(), p.getY() - (double)this.startOfSpans);
        return this.spanLayout.getEdgeAt(shifted, radius);
    }

    public void setHeightFactor(int heightFactor) {
        this.dependencyLayout.setHeightPerLevel(heightFactor);
        this.spanLayout.setHeightPerLevel(heightFactor);
    }

    public int getHeightFactor() {
        return this.dependencyLayout.getHeightPerLevel();
    }

    public void setCurved(boolean isCurved) {
        this.dependencyLayout.setCurve(isCurved);
        this.spanLayout.setCurve(isCurved);
    }

    public boolean isCurved() {
        return this.dependencyLayout.isCurve();
    }

    public void setEdgeTypeColor(String edgeType, Color color) {
        this.dependencyLayout.setColor(edgeType, color);
        this.spanLayout.setColor(edgeType, color);
    }

    public void setEdgeTypeOrder(String edgeType, int order) {
        this.spanLayout.setTypeOrder(edgeType, order);
    }

    public boolean isAntiAliasing() {
        return this.antiAliasing;
    }
}

