/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.whatswrong;

import com.googlecode.whatswrong.Edge;
import com.googlecode.whatswrong.NLPInstance;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NLPDiff {
    public NLPInstance diff(NLPInstance goldInstance, NLPInstance guessInstance) {
        String type;
        Edge edge;
        NLPInstance diff = new NLPInstance();
        diff.setRenderType(goldInstance.getRenderType());
        for (int splitPoint : goldInstance.getSplitPoints()) {
            diff.addSplitPoint(splitPoint);
        }
        diff.addTokens(goldInstance.getTokens());
        Set<EdgeIdentity> goldIdentities = NLPDiff.createIdentities(goldInstance.getEdges());
        Set<EdgeIdentity> guessIdentities = NLPDiff.createIdentities(guessInstance.getEdges());
        HashSet<EdgeIdentity> fn = new HashSet<EdgeIdentity>(goldIdentities);
        fn.removeAll(guessIdentities);
        HashSet<EdgeIdentity> fp = new HashSet<EdgeIdentity>(guessIdentities);
        fp.removeAll(goldIdentities);
        HashSet<EdgeIdentity> matches = new HashSet<EdgeIdentity>(goldIdentities);
        matches.retainAll(guessIdentities);
        for (EdgeIdentity edgeid : fn) {
            edge = edgeid.edge;
            type = edge.getType() + ":FN";
            diff.addEdge(new Edge(edge.getFrom(), edge.getTo(), edge.getLabel(), edge.getNote(), type, edge.getRenderType(), edge.getDescription()));
        }
        for (EdgeIdentity edgeId : fp) {
            edge = edgeId.edge;
            type = edge.getType() + ":FP";
            diff.addEdge(new Edge(edge.getFrom(), edge.getTo(), edge.getLabel(), edge.getNote(), type, edge.getRenderType(), edge.getDescription()));
        }
        for (EdgeIdentity edgeId : matches) {
            edge = edgeId.edge;
            diff.addEdge(new Edge(edge.getFrom(), edge.getTo(), edge.getLabel(), edge.getNote(), edge.getType() + ":Match", edge.getRenderType(), edge.getDescription()));
        }
        return diff;
    }

    private static Set<EdgeIdentity> createIdentities(Collection<Edge> edges) {
        HashSet<EdgeIdentity> result = new HashSet<EdgeIdentity>();
        for (Edge edge : edges) {
            result.add(new EdgeIdentity(edge));
        }
        return result;
    }

    private static class EdgeIdentity {
        private final int from;
        private final int to;
        private final String type;
        private final String label;
        public final Edge edge;

        EdgeIdentity(Edge edge) {
            this.edge = edge;
            this.from = edge.getFrom().getIndex();
            this.to = edge.getTo().getIndex();
            this.type = edge.getType();
            this.label = edge.getLabel();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EdgeIdentity that = (EdgeIdentity)o;
            if (this.from != that.from) {
                return false;
            }
            if (this.to != that.to) {
                return false;
            }
            if (this.label != null ? !this.label.equals(that.label) : that.label != null) {
                return false;
            }
            return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
        }

        public int hashCode() {
            int result = this.from;
            result = 31 * result + this.to;
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
            return result;
        }
    }
}

