/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.whatswrong;

import com.googlecode.whatswrong.NLPCanvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AppearancePanel
extends JPanel
implements NLPCanvas.Listener {
    private JSlider marginSlider;
    private JSlider heightSlider;
    private JCheckBox curved;
    private NLPCanvas nlpCanvas;
    private JCheckBox anti;

    public AppearancePanel(final NLPCanvas nlpCanvas) {
        super(new GridBagLayout());
        this.nlpCanvas = nlpCanvas;
        nlpCanvas.addListener(this);
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.marginSlider = new JSlider(0, 0, 100, nlpCanvas.getRenderer().getMargin());
        this.marginSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                nlpCanvas.getRenderer().setMargin(AppearancePanel.this.marginSlider.getValue());
                nlpCanvas.updateNLPGraphics();
            }
        });
        c.gridx = 0;
        c.anchor = 13;
        this.add((Component)new JLabel("Width:"), c);
        c.anchor = 17;
        c.gridx = 1;
        this.add((Component)this.marginSlider, c);
        this.marginSlider.setToolTipText("Margin between tokens");
        this.marginSlider.setMaximumSize(new Dimension(20, 50));
        this.heightSlider = new JSlider(0, 10, 50, nlpCanvas.getRenderer().getHeightFactor());
        this.heightSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                nlpCanvas.getRenderer().setHeightFactor(AppearancePanel.this.heightSlider.getValue());
                nlpCanvas.updateNLPGraphics();
            }
        });
        c.gridx = 0;
        c.anchor = 13;
        this.add((Component)new JLabel("Height:"), c);
        c.gridx = 1;
        c.anchor = 17;
        this.add((Component)this.heightSlider, c);
        this.heightSlider.setToolTipText("Tree height");
        this.heightSlider.setMaximumSize(new Dimension(20, 50));
        c.fill = 2;
        c.gridwidth = 2;
        c.gridx = 0;
        this.add((Component)new JSeparator(), c);
        c.fill = 0;
        c.gridwidth = 1;
        c.gridx = 0;
        c.anchor = 13;
        this.add((Component)new JLabel("Edges:"), c);
        c.gridx = 1;
        c.anchor = 17;
        this.curved = new JCheckBox("Curved", nlpCanvas.getRenderer().isCurved());
        this.curved.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                nlpCanvas.getRenderer().setCurved(AppearancePanel.this.curved.isSelected());
                nlpCanvas.updateNLPGraphics();
            }
        });
        this.add((Component)this.curved, c);
        c.fill = 0;
        c.gridwidth = 1;
        c.gridx = 1;
        c.anchor = 17;
        this.anti = new JCheckBox("Antialiasing", nlpCanvas.getRenderer().isAntiAliasing());
        this.anti.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                nlpCanvas.getRenderer().setAntiAliasing(AppearancePanel.this.anti.isSelected());
                nlpCanvas.updateNLPGraphics();
            }
        });
        this.add((Component)this.anti, c);
        c.fill = 0;
        c.gridwidth = 1;
        c.gridx = 1;
        c.anchor = 17;
        this.setMinimumSize(new Dimension(0, 150));
    }

    public void instanceChanged() {
        this.heightSlider.setValue(this.nlpCanvas.getRenderer().getHeightFactor());
        this.curved.setSelected(this.nlpCanvas.getRenderer().isCurved());
        this.marginSlider.setValue(this.nlpCanvas.getRenderer().getMargin());
        this.anti.setSelected(this.nlpCanvas.getRenderer().isAntiAliasing());
    }

    public void redrawn() {
    }
}

