/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.whatswrong;

import com.googlecode.whatswrong.Edge;
import com.googlecode.whatswrong.javautils.Counter;
import com.googlecode.whatswrong.javautils.HashMultiMapLinkedList;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEdgeLayout {
    protected int baseline = -1;
    protected int heightPerLevel = 15;
    protected int vertexExtraSpace = 12;
    protected boolean curve = true;
    private HashMap<String, Color> colors = new HashMap();
    private HashMap<String, BasicStroke> strokes = new HashMap();
    private BasicStroke defaultStroke = new BasicStroke();
    protected HashMap<Edge, Point> from;
    protected HashMap<Edge, Point> to;
    protected HashMap<Shape, Edge> shapes = new HashMap();
    private HashSet<Edge> selected = new HashSet();
    protected HashSet<Edge> visible = new HashSet();
    protected int maxHeight;
    protected int maxWidth;

    public void setColor(String type, Color color) {
        this.colors.put(type, color);
    }

    public void setStroke(String type, BasicStroke stroke) {
        this.strokes.put(type, stroke);
    }

    public BasicStroke getStroke(Edge edge) {
        BasicStroke stroke = this.getStroke(edge.getType());
        return this.selected.contains(edge) ? new BasicStroke(stroke.getLineWidth() + 1.5f, stroke.getEndCap(), stroke.getLineJoin(), stroke.getMiterLimit(), stroke.getDashArray(), stroke.getDashPhase()) : stroke;
    }

    public BasicStroke getStroke(String type) {
        for (String substring : this.strokes.keySet()) {
            if (!type.contains(substring)) continue;
            return this.strokes.get(substring);
        }
        return this.defaultStroke;
    }

    public Color getColor(String type) {
        for (String substring : this.colors.keySet()) {
            if (!type.contains(substring)) continue;
            return this.colors.get(substring);
        }
        return Color.BLACK;
    }

    public void addToSelection(Edge edge) {
        this.selected.add(edge);
    }

    public void removeFromSelection(Edge edge) {
        this.selected.remove(edge);
    }

    public void clearSelection() {
        this.selected.clear();
    }

    public void onlyShow(Collection<Edge> edges) {
        this.visible.clear();
        this.visible.addAll(edges);
    }

    public void showAll() {
        this.visible.clear();
    }

    public void toggleSelection(Edge edge) {
        if (this.selected.contains(edge)) {
            this.selected.remove(edge);
        } else {
            this.selected.add(edge);
        }
    }

    public Set<Edge> getSelected() {
        return Collections.unmodifiableSet(this.selected);
    }

    public void select(Edge edge) {
        this.selected.clear();
        this.selected.add(edge);
    }

    public Edge getEdgeAt(Point2D p, int radius) {
        Rectangle2D.Double cursor = new Rectangle2D.Double(p.getX() - (double)(radius / 2), p.getY() - (double)(radius / 2), radius, radius);
        double maxY = -2.147483648E9;
        Edge result = null;
        for (Shape s : this.shapes.keySet()) {
            if (!s.intersects(cursor) || !(s.getBounds().getY() > maxY)) continue;
            result = this.shapes.get(s);
            maxY = s.getBounds().getY();
        }
        return result;
    }

    protected int calculateDepth(HashMultiMapLinkedList<Edge, Edge> dominates, Counter<Edge> depth, Edge root) {
        if (depth.get(root) > 0) {
            return depth.get(root);
        }
        if (dominates.get(root).size() == 0) {
            return 0;
        }
        int max = 0;
        Iterator i$ = dominates.get(root).iterator();
        while (i$.hasNext()) {
            Edge children = (Edge)i$.next();
            int current = this.calculateDepth(dominates, depth, children);
            if (current <= max) continue;
            max = current;
        }
        depth.put(root, max + 1);
        return max + 1;
    }

    public Point getFrom(Edge edge) {
        return this.from.get(edge);
    }

    public Point getTo(Edge edge) {
        return this.to.get(edge);
    }

    public int getHeight() {
        return this.maxHeight;
    }

    public int getWidth() {
        return this.maxWidth;
    }

    public int getHeightPerLevel() {
        return this.heightPerLevel;
    }

    public boolean isCurve() {
        return this.curve;
    }

    public void setCurve(boolean curve) {
        this.curve = curve;
    }

    public void setBaseline(int baseline) {
        this.baseline = baseline;
    }

    public void setHeightPerLevel(int heightPerLevel) {
        this.heightPerLevel = heightPerLevel;
    }

    public void setVertexExtraSpace(int vertexExtraSpace) {
        this.vertexExtraSpace = vertexExtraSpace;
    }

    public int getVertexExtraSpace() {
        return this.vertexExtraSpace;
    }

    public int getBaseline() {
        return this.baseline;
    }
}

