package org.richfaces.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.richfaces.component.UIColorPicker;

public class HtmlColorPicker extends UIColorPicker{

static public final  String COMPONENT_FAMILY = "org.richfaces.ColorPicker";

static public final  String COMPONENT_TYPE = "org.richfaces.ColorPicker";

/*
* Defines a color mode for the component input. Possible values are hex, rgb.
*/
private  String _colorMode = null;

/*
* Defines whether the component will be rendered flat.
*/
private  Boolean _flat = null;

/*
* inputSize  is used to set the size of the edit box
*/
private  Integer _inputSize = null;

/*
* The client-side script method to be called before the component widget is opened
*/
private  String _onbeforeshow = null;

/*
* The client-side script method to be called when the element value is changed
*/
private  String _onchange = null;

/*
* The client-side script method to be called when the element is clicked
*/
private  String _onclick = null;

/*
* The client-side script method to be called when the element is double-clicked
*/
private  String _ondblclick = null;

/*
* The client-side script method to be called before the component widget is hidden
*/
private  String _onhide = null;

/*
* The client-side script method to be called when a key is pressed down over the element
*/
private  String _onkeydown = null;

/*
* The client-side script method to be called when a key is pressed over the element and released
*/
private  String _onkeypress = null;

/*
* The client-side script method to be called when a key is released
*/
private  String _onkeyup = null;

/*
* The client-side script method to be called when a mouse button is pressed down over the element
*/
private  String _onmousedown = null;

/*
* The client-side script method to be called when a pointer is moved within the element
*/
private  String _onmousemove = null;

/*
* The client-side script method to be called when a pointer is moved away from the element
*/
private  String _onmouseout = null;

/*
* The client-side script method to be called when a pointer is moved onto the element
*/
private  String _onmouseover = null;

/*
* The client-side script method to be called when a mouse button is released
*/
private  String _onmouseup = null;

/*
* The client-side script method to be called when the color is selected
*/
private  String _onselect = null;

/*
* The client-side script method to be called when the component widget is displayed
*/
private  String _onshow = null;

/*
* Defines the event that triggers the colorPicker. 
		        Default value is "onclick".
*/
private  String _showEvent = null;


public HtmlColorPicker(){
setRendererType("org.richfaces.ColorPickerRenderer");
}

public String getColorMode(){
	if (this._colorMode != null) {
		return this._colorMode;
	}
	ValueExpression ve = getValueExpression("colorMode");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "hex";
	

}

public void setColorMode(String _colorMode){
this._colorMode = _colorMode;
}

public Boolean getFlat(){
	if (this._flat != null) {
		return this._flat;
	}
	ValueExpression ve = getValueExpression("flat");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return false;
	

}

public void setFlat(Boolean _flat){
this._flat = _flat;
}

public Integer getInputSize(){
	if (this._inputSize != null) {
		return this._inputSize;
	}
	ValueExpression ve = getValueExpression("inputSize");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return 20;
	

}

public void setInputSize(Integer _inputSize){
this._inputSize = _inputSize;
}

public String getOnbeforeshow(){
	if (this._onbeforeshow != null) {
		return this._onbeforeshow;
	}
	ValueExpression ve = getValueExpression("onbeforeshow");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnbeforeshow(String _onbeforeshow){
this._onbeforeshow = _onbeforeshow;
}

public String getOnchange(){
	if (this._onchange != null) {
		return this._onchange;
	}
	ValueExpression ve = getValueExpression("onchange");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnchange(String _onchange){
this._onchange = _onchange;
}

public String getOnclick(){
	if (this._onclick != null) {
		return this._onclick;
	}
	ValueExpression ve = getValueExpression("onclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnclick(String _onclick){
this._onclick = _onclick;
}

public String getOndblclick(){
	if (this._ondblclick != null) {
		return this._ondblclick;
	}
	ValueExpression ve = getValueExpression("ondblclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOndblclick(String _ondblclick){
this._ondblclick = _ondblclick;
}

public String getOnhide(){
	if (this._onhide != null) {
		return this._onhide;
	}
	ValueExpression ve = getValueExpression("onhide");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnhide(String _onhide){
this._onhide = _onhide;
}

public String getOnkeydown(){
	if (this._onkeydown != null) {
		return this._onkeydown;
	}
	ValueExpression ve = getValueExpression("onkeydown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeydown(String _onkeydown){
this._onkeydown = _onkeydown;
}

public String getOnkeypress(){
	if (this._onkeypress != null) {
		return this._onkeypress;
	}
	ValueExpression ve = getValueExpression("onkeypress");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeypress(String _onkeypress){
this._onkeypress = _onkeypress;
}

public String getOnkeyup(){
	if (this._onkeyup != null) {
		return this._onkeyup;
	}
	ValueExpression ve = getValueExpression("onkeyup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeyup(String _onkeyup){
this._onkeyup = _onkeyup;
}

public String getOnmousedown(){
	if (this._onmousedown != null) {
		return this._onmousedown;
	}
	ValueExpression ve = getValueExpression("onmousedown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmousedown(String _onmousedown){
this._onmousedown = _onmousedown;
}

public String getOnmousemove(){
	if (this._onmousemove != null) {
		return this._onmousemove;
	}
	ValueExpression ve = getValueExpression("onmousemove");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmousemove(String _onmousemove){
this._onmousemove = _onmousemove;
}

public String getOnmouseout(){
	if (this._onmouseout != null) {
		return this._onmouseout;
	}
	ValueExpression ve = getValueExpression("onmouseout");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseout(String _onmouseout){
this._onmouseout = _onmouseout;
}

public String getOnmouseover(){
	if (this._onmouseover != null) {
		return this._onmouseover;
	}
	ValueExpression ve = getValueExpression("onmouseover");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseover(String _onmouseover){
this._onmouseover = _onmouseover;
}

public String getOnmouseup(){
	if (this._onmouseup != null) {
		return this._onmouseup;
	}
	ValueExpression ve = getValueExpression("onmouseup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseup(String _onmouseup){
this._onmouseup = _onmouseup;
}

public String getOnselect(){
	if (this._onselect != null) {
		return this._onselect;
	}
	ValueExpression ve = getValueExpression("onselect");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnselect(String _onselect){
this._onselect = _onselect;
}

public String getOnshow(){
	if (this._onshow != null) {
		return this._onshow;
	}
	ValueExpression ve = getValueExpression("onshow");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnshow(String _onshow){
this._onshow = _onshow;
}

public String getShowEvent(){
	if (this._showEvent != null) {
		return this._showEvent;
	}
	ValueExpression ve = getValueExpression("showEvent");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "onclick";
	

}

public void setShowEvent(String _showEvent){
this._showEvent = _showEvent;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[20];
state[0] = super.saveState(context);
state[1] = _colorMode;
state[2] = _flat;
state[3] = _inputSize;
state[4] = _onbeforeshow;
state[5] = _onchange;
state[6] = _onclick;
state[7] = _ondblclick;
state[8] = _onhide;
state[9] = _onkeydown;
state[10] = _onkeypress;
state[11] = _onkeyup;
state[12] = _onmousedown;
state[13] = _onmousemove;
state[14] = _onmouseout;
state[15] = _onmouseover;
state[16] = _onmouseup;
state[17] = _onselect;
state[18] = _onshow;
state[19] = _showEvent;
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_colorMode = (String)states[1];;
		_flat = (Boolean)states[2];;
		_inputSize = (Integer)states[3];;
		_onbeforeshow = (String)states[4];;
		_onchange = (String)states[5];;
		_onclick = (String)states[6];;
		_ondblclick = (String)states[7];;
		_onhide = (String)states[8];;
		_onkeydown = (String)states[9];;
		_onkeypress = (String)states[10];;
		_onkeyup = (String)states[11];;
		_onmousedown = (String)states[12];;
		_onmousemove = (String)states[13];;
		_onmouseout = (String)states[14];;
		_onmouseover = (String)states[15];;
		_onmouseup = (String)states[16];;
		_onselect = (String)states[17];;
		_onshow = (String)states[18];;
		_showEvent = (String)states[19];;
	
}

}
