/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.event.AjaxEvent;
import org.ajax4jsf.javascript.AjaxScript;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.javascript.JSReference;
import org.ajax4jsf.javascript.PrototypeScript;
import org.ajax4jsf.javascript.ScriptUtils;
import org.ajax4jsf.renderkit.AjaxComponentRendererBase;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.renderkit.RendererUtils;
import org.ajax4jsf.resource.InternetResource;
import org.richfaces.component.UIToolTip;
import org.richfaces.skin.Skin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolTipRenderer
extends AjaxComponentRendererBase {
    private static final String DIRECTION_AUTO = "auto";
    private static final String DIRECTION_BOTTOM_RIGHT = "bottom-right";
    private static final String AJAX_MODE = "ajax";
    private final InternetResource[] styles = new InternetResource[]{this.getResource("/org/richfaces/renderkit/html/css/tooltip.xcss")};
    private InternetResource[] stylesAll = null;
    private final InternetResource[] scripts = new InternetResource[]{new PrototypeScript(), new AjaxScript(), this.getResource("/org/richfaces/renderkit/html/scripts/jquery/jquery.js"), this.getResource("/org/richfaces/renderkit/html/scripts/utils.js"), this.getResource("/org/richfaces/renderkit/html/scripts/tooltip.js")};
    private InternetResource[] scriptsAll = null;
    private static final String COMMA = ",";
    private static final String QUOT = "\"";
    private static final String QUOT_COMMA = "\",";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InternetResource[] getStyles() {
        ToolTipRenderer toolTipRenderer = this;
        synchronized (toolTipRenderer) {
            if (this.stylesAll == null) {
                boolean ignoreThis;
                InternetResource[] rsrcs = super.getStyles();
                boolean ignoreSuper = rsrcs == null || rsrcs.length == 0;
                boolean bl = ignoreThis = this.styles == null || this.styles.length == 0;
                if (ignoreSuper) {
                    this.stylesAll = ignoreThis ? new InternetResource[0] : this.styles;
                } else if (ignoreThis) {
                    this.stylesAll = rsrcs;
                } else {
                    int i;
                    LinkedHashSet<InternetResource> rsrcsSet = new LinkedHashSet<InternetResource>();
                    for (i = 0; i < rsrcs.length; ++i) {
                        rsrcsSet.add(rsrcs[i]);
                    }
                    for (i = 0; i < this.styles.length; ++i) {
                        rsrcsSet.add(this.styles[i]);
                    }
                    this.stylesAll = rsrcsSet.toArray(new InternetResource[rsrcsSet.size()]);
                }
            }
        }
        return this.stylesAll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InternetResource[] getScripts() {
        ToolTipRenderer toolTipRenderer = this;
        synchronized (toolTipRenderer) {
            if (this.scriptsAll == null) {
                boolean ignoreThis;
                InternetResource[] rsrcs = super.getScripts();
                boolean ignoreSuper = rsrcs == null || rsrcs.length == 0;
                boolean bl = ignoreThis = this.scripts == null || this.scripts.length == 0;
                if (ignoreSuper) {
                    this.scriptsAll = ignoreThis ? new InternetResource[0] : this.scripts;
                } else if (ignoreThis) {
                    this.scriptsAll = rsrcs;
                } else {
                    int i;
                    LinkedHashSet<InternetResource> rsrcsSet = new LinkedHashSet<InternetResource>();
                    for (i = 0; i < rsrcs.length; ++i) {
                        rsrcsSet.add(rsrcs[i]);
                    }
                    for (i = 0; i < this.scripts.length; ++i) {
                        rsrcsSet.add(this.scripts[i]);
                    }
                    this.scriptsAll = rsrcsSet.toArray(new InternetResource[rsrcsSet.size()]);
                }
            }
        }
        return this.scriptsAll;
    }

    protected Class<? extends UIComponent> getComponentClass() {
        return UIToolTip.class;
    }

    public String getBgColor(FacesContext context, UIComponent component) {
        Skin skin = this.getSkin(context);
        return String.valueOf(skin.getParameter(context, "headerBackgroundColor"));
    }

    public String getColor(FacesContext context, UIComponent component) {
        Skin skin = this.getSkin(context);
        return String.valueOf(skin.getParameter(context, "headerTextColor"));
    }

    public Map<String, Object> buildEventOptions(FacesContext context, UIComponent component) {
        JSFunctionDefinition beforeUpdate;
        JSFunctionDefinition onComplete;
        Map eventOptions = AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)component, (boolean)true);
        String clientId = component.getClientId(context);
        String oncompleteTooltip = "; request.options.control.displayDiv();";
        String fireBeforeUpdateDOM = "; request.options.control.toolTip.style.display = 'none';";
        eventOptions.put("control", JSReference.THIS);
        if (eventOptions.containsKey("oncomplete")) {
            onComplete = (JSFunctionDefinition)eventOptions.get("oncomplete");
            onComplete.addToBody((Object)oncompleteTooltip);
            eventOptions.put("oncomplete", onComplete);
        } else {
            onComplete = new JSFunctionDefinition(new Object[0]);
            onComplete.addParameter((Object)"request");
            onComplete.addParameter((Object)"showEvent");
            onComplete.addParameter((Object)"data");
            onComplete.addToBody((Object)oncompleteTooltip);
            eventOptions.put("oncomplete", onComplete);
        }
        if (eventOptions.containsKey("onbeforedomupdate")) {
            beforeUpdate = (JSFunctionDefinition)eventOptions.get("onbeforedomupdate");
            beforeUpdate.addToBody((Object)fireBeforeUpdateDOM);
            eventOptions.put("onbeforedomupdate", beforeUpdate);
        } else {
            beforeUpdate = new JSFunctionDefinition(new Object[0]);
            beforeUpdate.addParameter((Object)"request");
            beforeUpdate.addParameter((Object)"event");
            beforeUpdate.addParameter((Object)"data");
            beforeUpdate.addToBody((Object)fireBeforeUpdateDOM);
            eventOptions.put("onbeforedomupdate", beforeUpdate);
        }
        return eventOptions;
    }

    public void insertScript(FacesContext context, UIComponent component) throws IOException {
        StringBuffer ret = new StringBuffer();
        ret.append("<script ");
        ret.append("type=\"text/javascript\" ");
        ret.append("id =\"script").append(component.getClientId(context)).append("\">\n");
        ret.append(this.constructJSVariable(context, component)).append("\n");
        ret.append("</script>");
        context.getResponseWriter().write(ret.toString());
    }

    public Map<String, Object> getParamsMap(FacesContext context, UIToolTip toolTip) {
        List children = toolTip.getChildren();
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        for (UIComponent child : children) {
            if (!(child instanceof UIParameter)) continue;
            UIParameter param = (UIParameter)child;
            paramsMap.put(param.getName(), param.getValue());
        }
        return paramsMap;
    }

    private String getTargetId(FacesContext context, UIComponent component) {
        UIToolTip toolTip = (UIToolTip)component;
        String forValue = toolTip.getFor();
        if (forValue != null && forValue.length() != 0) {
            UIComponent targetComponent = this.getUtils().findComponentFor(component, forValue);
            if (targetComponent != null) {
                return targetComponent.getClientId(context);
            }
            return forValue;
        }
        return component.getParent().getClientId(context);
    }

    public String constructJSVariable(FacesContext context, UIComponent component) {
        String eventHide;
        String eventShow;
        UIToolTip toolTip = (UIToolTip)component;
        String targetClientId = this.getTargetId(context, component);
        HashMap options = new HashMap();
        String string = eventShow = toolTip.isAttached() ? toolTip.getShowEvent() : "";
        if (eventShow.startsWith("on")) {
            eventShow = eventShow.substring(2);
        }
        RendererUtils utils = this.getUtils();
        utils.addToScriptHash(options, "showEvent", (Object)eventShow);
        String string2 = eventHide = toolTip.isAttached() ? toolTip.getHideEvent() : "";
        if (eventHide.startsWith("on")) {
            eventHide = eventHide.substring(2);
        }
        utils.addToScriptHash(options, "hideEvent", (Object)eventHide);
        utils.addToScriptHash(options, "delay", (Object)toolTip.getShowDelay(), "0");
        utils.addToScriptHash(options, "hideDelay", (Object)toolTip.getHideDelay(), "0");
        if (AJAX_MODE.equalsIgnoreCase(toolTip.getMode())) {
            JSFunctionDefinition ajaxFunc = new JSFunctionDefinition(new Object[]{"event"});
            JSFunction function = AjaxRendererUtils.buildAjaxFunction((UIComponent)component, (FacesContext)context);
            Map<String, Object> ajaxOptions = this.buildEventOptions(context, (UIComponent)toolTip);
            ajaxOptions.putAll(this.getParamsMap(context, toolTip));
            function.addParameter(ajaxOptions);
            ajaxFunc.addToBody((Object)function);
            utils.addToScriptHash(options, "ajaxFunction", (Object)ajaxFunc);
        }
        JSFunctionDefinition hideFunc = utils.getAsEventHandler(context, component, "onhide", "; return true;");
        utils.addToScriptHash(options, "onhide", (Object)hideFunc);
        JSFunctionDefinition showFunc = utils.getAsEventHandler(context, component, "onshow", "; return true;");
        utils.addToScriptHash(options, "onshow", (Object)showFunc);
        utils.addToScriptHash(options, "disabled", (Object)toolTip.isDisabled(), "false");
        String direction = toolTip.getDirection();
        if (DIRECTION_AUTO.equalsIgnoreCase(direction)) {
            direction = DIRECTION_BOTTOM_RIGHT;
        }
        utils.addToScriptHash(options, "direction", (Object)direction, DIRECTION_BOTTOM_RIGHT);
        utils.addToScriptHash(options, "followMouse", (Object)toolTip.isFollowMouse(), "false");
        utils.addToScriptHash(options, "horizontalOffset", (Object)toolTip.getHorizontalOffset(), "10");
        utils.addToScriptHash(options, "verticalOffset", (Object)toolTip.getVerticalOffset(), "10");
        StringBuffer ret = new StringBuffer();
        ret.append("new ToolTip(").append(QUOT).append(toolTip.getClientId(context)).append(QUOT_COMMA).append(QUOT).append(targetClientId).append(QUOT);
        if (!options.isEmpty()) {
            ret.append(COMMA).append(ScriptUtils.toScript(options));
        }
        ret.append(");");
        return ret.toString();
    }

    protected void doDecode(FacesContext context, UIComponent component) {
        UIToolTip tooltip = (UIToolTip)component;
        String clientId = tooltip.getClientId(context);
        if (context.getExternalContext().getRequestParameterMap().containsKey(clientId) && AJAX_MODE.equals(tooltip.getMode())) {
            new AjaxEvent(component).queue();
            new ActionEvent(component).queue();
        }
    }

    public void encodeTooltipText(FacesContext context, UIToolTip component) throws IOException {
        ResponseWriter responseWriter = context.getResponseWriter();
        responseWriter.startElement(component.getUsedElementType(), (UIComponent)component);
        String clientId = component.getClientId(context);
        Object value = component.getValue();
        responseWriter.writeAttribute("id", (Object)(clientId + "content"), null);
        if (AJAX_MODE.equals(component.getMode())) {
            AjaxContext ajaxContext = AjaxContext.getCurrentInstance();
            if (ajaxContext != null && ajaxContext.getAjaxAreasToRender().contains(clientId + "content")) {
                responseWriter.write(value != null ? value.toString() : "");
                super.renderChildren(context, (UIComponent)component);
            }
        } else {
            responseWriter.write(value != null ? value.toString() : "");
            super.renderChildren(context, (UIComponent)component);
        }
        responseWriter.endElement(component.getUsedElementType());
    }

    protected void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        try {
            ToolTipRenderer renderer = this.getRenderer((UIToolTip)component);
            renderer.doEncodeBegin(writer, context, component);
        }
        catch (Exception e) {
            throw new FacesException(e.getMessage(), (Throwable)e);
        }
    }

    protected void doEncodeChildren(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        try {
            ToolTipRenderer renderer = this.getRenderer((UIToolTip)component);
            renderer.doEncodeChildren(writer, context, component);
        }
        catch (Exception e) {
            throw new FacesException(e.getMessage(), (Throwable)e);
        }
    }

    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        try {
            ToolTipRenderer renderer = this.getRenderer((UIToolTip)component);
            renderer.doEncodeEnd(writer, context, component);
        }
        catch (Exception e) {
            throw new FacesException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    private ToolTipRenderer getRenderer(UIToolTip toolTip) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> rendererClass = "block".equals(toolTip.getLayout()) ? Class.forName("org.richfaces.renderkit.html.HtmlToolTipRendererBlock") : Class.forName("org.richfaces.renderkit.html.HtmlToolTipRenderer");
        return (ToolTipRenderer)((Object)rendererClass.newInstance());
    }
}

