/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.component.SequenceDataAdaptor;
import org.ajax4jsf.component.UIDataAdaptor;
import org.ajax4jsf.model.DataVisitor;
import org.ajax4jsf.renderkit.HeaderResourcesRendererBase;
import org.ajax4jsf.renderkit.RendererUtils;
import org.richfaces.component.Row;
import org.richfaces.renderkit.TableHolder;

public abstract class AbstractRowsRenderer
extends HeaderResourcesRendererBase
implements DataVisitor {
    public static final String[][] TABLE_EVENT_ATTRS = new String[][]{{"onclick", "onRowClick"}, {"ondblclick", "onRowDblClick"}, {"onmousemove", "onRowMouseMove"}, {"onmouseup", "onRowMouseUp"}, {"onmousedown", "onRowMouseDown"}, {"onmouseover", "onRowMouseOver"}, {"onmouseout", "onRowMouseOut"}};
    public static final String ROW_CLASS_KEY = AbstractRowsRenderer.class.getName() + ".rowClass";
    public static final String SKIN_ROW_CLASS_KEY = AbstractRowsRenderer.class.getName() + ".skinRowClass";
    public static final String CELL_CLASS_KEY = AbstractRowsRenderer.class.getName() + ".cellClass";
    public static final String SKIN_CELL_CLASS_KEY = AbstractRowsRenderer.class.getName() + ".skinCellClass";
    public static final String SKIN_FIRST_ROW_CLASS_KEY = AbstractRowsRenderer.class.getName() + ".firstRowSkinClass";

    public void process(FacesContext context, Object rowKey, Object argument) throws IOException {
        TableHolder holder = (TableHolder)argument;
        UIDataAdaptor table = holder.getTable();
        table.setRowKey(context, rowKey);
        this.encodeOneRow(context, holder);
        holder.nextRow();
    }

    public void encodeRows(FacesContext context, UIComponent component) throws IOException {
        this.encodeRows(context, component, new TableHolder((UIDataAdaptor)component));
    }

    protected void encodeRows(FacesContext context, UIComponent component, TableHolder tableHolder) throws IOException {
        UIDataAdaptor table = (UIDataAdaptor)component;
        Object key = table.getRowKey();
        table.captureOrigValue(context);
        table.walk(context, (DataVisitor)this, (Object)tableHolder);
        this.doCleanup(context, tableHolder);
        table.setRowKey(key);
        table.restoreOrigValue(context);
    }

    protected void doCleanup(FacesContext context, TableHolder tableHolder) throws IOException {
    }

    public abstract void encodeOneRow(FacesContext var1, TableHolder var2) throws IOException;

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        this.encodeRows(context, component);
    }

    public void encodeCaption(FacesContext context, SequenceDataAdaptor table) throws IOException {
        UIComponent caption = table.getFacet("caption");
        if (caption == null) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("caption", (UIComponent)table);
        String captionClass = (String)table.getAttributes().get("captionClass");
        captionClass = captionClass != null ? "rich-table-caption " + captionClass : "rich-table-caption";
        writer.writeAttribute("class", (Object)captionClass, "captionClass");
        String captionStyle = (String)table.getAttributes().get("captionStyle");
        if (captionStyle != null) {
            writer.writeAttribute("style", (Object)captionStyle, "captionStyle");
        }
        this.renderChild(context, caption);
        writer.endElement("caption");
    }

    protected void encodeRowEvents(FacesContext context, UIDataAdaptor table) throws IOException {
        RendererUtils utils2 = this.getUtils();
        for (int i = 0; i < TABLE_EVENT_ATTRS.length; ++i) {
            String[] attrs = TABLE_EVENT_ATTRS[i];
            utils2.encodeAttribute(context, (UIComponent)table, (Object)attrs[1], attrs[0]);
        }
    }

    protected void encodeStyleClass(ResponseWriter writer, Object parentPredefined, Object predefined, Object parent, Object custom) throws IOException {
        StringBuffer styleClass = new StringBuffer();
        if (null != parentPredefined) {
            styleClass.append(parentPredefined).append(" ");
        } else if (null != predefined) {
            styleClass.append(predefined).append(" ");
        }
        if (null != parent) {
            styleClass.append(parent).append(" ");
        }
        if (null != custom) {
            styleClass.append(custom);
        }
        if (styleClass.length() > 0) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
    }

    protected void encodeStyle(ResponseWriter writer, Object parentPredefined, Object predefined, Object parent, Object custom) throws IOException {
        StringBuffer style = new StringBuffer();
        if (null != parentPredefined) {
            style.append(parentPredefined).append(" ");
        } else if (null != predefined) {
            style.append(predefined).append(" ");
        }
        if (null != parent) {
            style.append(parent).append(" ");
        }
        if (null != custom) {
            style.append(custom);
        }
        if (style.length() > 0) {
            writer.writeAttribute("style", (Object)style, "style");
        }
    }

    protected void encodeCellChildren(FacesContext context, UIComponent cell, String skinFirstRowClass, String skinRowClass, String rowClass, String skinCellClass, String cellClass) throws IOException {
        Map requestMap = context.getExternalContext().getRequestMap();
        Object savedRowClass = requestMap.get(ROW_CLASS_KEY);
        if (null != rowClass) {
            requestMap.put(ROW_CLASS_KEY, rowClass);
        }
        Object savedSkinFirstRowClass = requestMap.get(SKIN_FIRST_ROW_CLASS_KEY);
        if (null != skinRowClass) {
            requestMap.put(SKIN_FIRST_ROW_CLASS_KEY, skinFirstRowClass);
        }
        Object savedSkinRowClass = requestMap.get(SKIN_ROW_CLASS_KEY);
        if (null != skinRowClass) {
            requestMap.put(SKIN_ROW_CLASS_KEY, skinRowClass);
        }
        Object savedCellClass = requestMap.get(CELL_CLASS_KEY);
        if (null != cellClass) {
            requestMap.put(CELL_CLASS_KEY, cellClass);
        }
        Object savedSkinCellClass = requestMap.get(SKIN_CELL_CLASS_KEY);
        if (null != skinCellClass) {
            requestMap.put(SKIN_CELL_CLASS_KEY, skinCellClass);
        }
        this.renderChild(context, cell);
        requestMap.put(ROW_CLASS_KEY, savedRowClass);
        requestMap.put(CELL_CLASS_KEY, savedCellClass);
        requestMap.put(SKIN_FIRST_ROW_CLASS_KEY, savedSkinFirstRowClass);
        requestMap.put(SKIN_ROW_CLASS_KEY, savedSkinRowClass);
        requestMap.put(SKIN_CELL_CLASS_KEY, savedSkinCellClass);
    }

    protected void encodeTableHeaderFacet(FacesContext context, int columns, ResponseWriter writer, UIComponent footer, String skinFirstRowClass, String skinRowClass, String skinCellClass, String footerClass, String element) throws IOException {
        boolean isColgroup = footer instanceof Row;
        if (!isColgroup) {
            writer.startElement("tr", footer);
            this.encodeStyleClass(writer, null, skinFirstRowClass, footerClass, null);
            writer.startElement(element, footer);
            this.encodeStyleClass(writer, null, skinCellClass, footerClass, null);
            if (columns > 0) {
                writer.writeAttribute("colspan", (Object)String.valueOf(columns), null);
            }
            writer.writeAttribute("scope", (Object)"colgroup", null);
        }
        this.encodeCellChildren(context, footer, skinFirstRowClass, skinRowClass, footerClass, skinCellClass, null);
        if (!isColgroup) {
            writer.endElement(element);
            writer.endElement("tr");
        }
    }
}

