/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import javax.el.ELContext;
import javax.el.ELException;
import javax.el.Expression;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.ajax4jsf.component.AjaxSupport;
import org.richfaces.component.Column;
import org.richfaces.model.ExtendedFilterField;
import org.richfaces.model.FilterField;
import org.richfaces.model.Ordering;
import org.richfaces.model.SortField2;

public abstract class UIColumn
extends javax.faces.component.UIColumn
implements Column {
    public static final String COMPONENT_TYPE = "org.richfaces.Column";
    public static final String COMPONENT_FAMILY = "org.richfaces.Column";
    private Ordering sortOrder = Ordering.UNSORTED;
    private String filterValue;

    public abstract String getSortIcon();

    public abstract void setSortIcon(String var1);

    public abstract String getSortIconAscending();

    public abstract void setSortIconAscending(String var1);

    public abstract String getSortIconDescending();

    public abstract void setSortIconDescending(String var1);

    public abstract boolean isVisible();

    public abstract void setVisible(boolean var1);

    public boolean isRendered() {
        return this.isRendered(true);
    }

    public boolean isRendered(boolean considerVisible) {
        boolean rendered = super.isRendered();
        if (considerVisible) {
            rendered = rendered && this.isVisible();
        }
        return rendered;
    }

    public FilterField getFilterField() {
        FilterField filterField = null;
        MethodExpression filterMethod = this.getFilterMethod();
        ValueExpression filterExpression = this.getValueExpression("filterExpression");
        ValueExpression filterBy = this.getValueExpression("filterBy");
        String filterValue = this.getFilterValue();
        if (filterMethod != null) {
            filterField = new FilterField((Expression)filterMethod);
        } else if (filterExpression != null) {
            filterField = new FilterField((Expression)filterExpression);
        } else if (filterBy != null) {
            filterField = new ExtendedFilterField((Expression)filterBy, filterValue);
        }
        return filterField;
    }

    public SortField2 getSortField() {
        SortField2 sortField2 = null;
        if (!Ordering.UNSORTED.equals((Object)this.getSortOrder())) {
            ValueExpression comparator = this.getValueExpression("comparator");
            ValueExpression sortBy = this.getValueExpression("sortBy");
            if (comparator != null) {
                sortField2 = new SortField2((Expression)comparator, this.getSortOrder());
            } else if (sortBy != null) {
                sortField2 = new SortField2((Expression)sortBy, this.getSortOrder());
            }
        }
        return sortField2;
    }

    public void toggleSortOrder() {
        if (Ordering.ASCENDING.equals((Object)this.getSortOrder())) {
            this.setSortOrder(Ordering.DESCENDING);
        } else {
            this.setSortOrder(Ordering.ASCENDING);
        }
    }

    public Ordering getSortOrder() {
        ValueExpression ve = this.getValueExpression("sortOrder");
        if (ve != null) {
            Ordering value = null;
            try {
                value = (Ordering)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
            return value;
        }
        return this.sortOrder;
    }

    public void setSortOrder(Ordering sortOrder) {
        ELContext context = this.getFacesContext().getELContext();
        ValueExpression ve = this.getValueExpression("sortOrder");
        if (ve != null && !ve.isReadOnly(context)) {
            try {
                ve.setValue(context, (Object)sortOrder);
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        } else {
            this.sortOrder = sortOrder;
        }
    }

    public String getFilterValue() {
        ValueExpression ve = this.getValueExpression("filterValue");
        if (ve != null) {
            String value = null;
            try {
                value = (String)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
            return value;
        }
        return this.filterValue;
    }

    public void setFilterValue(String filterValue) {
        ELContext context = this.getFacesContext().getELContext();
        ValueExpression ve = this.getValueExpression("filterValue");
        if (ve != null && !ve.isReadOnly(context)) {
            try {
                ve.setValue(context, (Object)filterValue);
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        } else {
            this.filterValue = filterValue;
        }
    }

    public Object saveState(FacesContext context) {
        Object[] state = new Object[]{super.saveState(context), this.filterValue, this.sortOrder};
        return state;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] states = (Object[])state;
        super.restoreState(context, states[0]);
        this.filterValue = (String)states[1];
        this.sortOrder = (Ordering)states[2];
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        for (UIComponent component : this.getChildren()) {
            component.processDecodes(context);
        }
        for (UIComponent component : this.getFacets().values()) {
            if (!this.isAjaxComponent(component)) continue;
            component.processDecodes(context);
        }
        this.decode(context);
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        for (UIComponent component : this.getChildren()) {
            component.processValidators(context);
        }
        for (UIComponent component : this.getFacets().values()) {
            if (!this.isAjaxComponent(component)) continue;
            component.processValidators(context);
        }
    }

    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        for (UIComponent component : this.getChildren()) {
            component.processUpdates(context);
        }
        for (UIComponent component : this.getFacets().values()) {
            if (!this.isAjaxComponent(component)) continue;
            component.processUpdates(context);
        }
    }

    private boolean isAjaxComponent(UIComponent component) {
        return component instanceof AjaxSupport;
    }
}

