package org.ajax4jsf.component.html;

import java.util.Date;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.ajax4jsf.component.UIMediaOutput;

public class MediaOutput extends UIMediaOutput{

static public final  String COMPONENT_FAMILY = "org.ajax4jsf.Resource";

static public final  String COMPONENT_TYPE = "org.ajax4jsf.MediaOutput";

/*
* This attribute assigns an access key to an element. An access key is a single character from the document character set. Note: Authors should consider the input method of the expected reader when specifying an accesskey
*/
private  String _accesskey = null;

/*
* Deprecated. This attribute specifies the position of an IMG, OBJECT, or APPLET with respect to its context.           
           The possible values are "bottom", "middle", "top", "left" and "right". The default value is "middle".
*/
private  String _align = null;

/*
* space-separated list of URIs
*/
private  String _archive = null;

/*
* Deprecated. This attribute specifies the width of an IMG or OBJECT border, in pixels. The default value for this attribute depends on the user agent
*/
private  String _border = null;

/*
* If "true", the resource is cached (on the server and the client sides).
*/
private  boolean _cacheable = false;

private  boolean _cacheableSet = false;

/*
* The character encoding of a resource designated by this hyperlink
*/
private  String _charset = null;

/*
* identifies an implementation
*/
private  String _classid = null;

/*
* base URI for classid, data, archive
*/
private  String _codebase = null;

/*
* content type for code
*/
private  String _codetype = null;

/*
* This attribute specifies the position and shape on the screen. The number and order of values depends on the shape being defined. Possible combinations:
            
            * rect: left-x, top-y, right-x, bottom-y.
            * circle: center-x, center-y, radius. Note. When the radius value is percentage value, user agents should calculate the final radius value based on the associated object's width and height. The radius should be the smaller value of the two.
            * poly: x1, y1, x2, y2, ..., xN, yN. The first x and y coordinate pair and the last should be the same to close the polygon. When these coordinate values are not the same, user agents should infer an additional coordinate pair to close the polygon.
            
            Coordinates are relative to the top, left corner of the object. All values are lengths. All values are separated by commas
*/
private  String _coords = null;

/*
* Method call expression to send generated resource to OutputStream. It must have two parameter with a type of java.io.OutputStream 
        and java.lang.Object ( deserialized value of data attribute )
*/
private  MethodExpression _createContentExpression = null;

/*
* declare but don't instantiate flag
*/
private  String _declare = null;

/*
* Direction indication for text that does not inherit
			directionality. Valid values are "LTR" (left-to-right)
			and "RTL" (right-to-left)
*/
private  String _dir = null;

/*
* Name of html element for resource link - may be &amp;lt;a&amp;gt; &amp;lt;img&amp;gt; &amp;lt;object&amp;gt; &amp;lt;applet&amp;gt; &amp;lt;script&amp;gt; or &amp;lt;link&amp;gt;
*/
private  String _element = null;

/*
* The attribute allows to manage caching and defines the period after which a resource is reloaded.
*/
private  Date _expires = null;

/*
* Base language of a resource specified with the href attribute; hreflang may only be used with href
*/
private  String _hreflang = null;

/*
* Deprecated. This attribute specifies the amount of white space to be inserted to the left and right of an IMG, APPLET, or OBJECT. The default value is not specified, but is generally a small, non-zero length
*/
private  String _hspace = null;

/*
* use server-side image map
*/
private  boolean _ismap = false;

private  boolean _ismapSet = false;

/*
* Code describing the language used in the generated markup for this component
*/
private  String _lang = null;

/*
* The attribute allows to manage caching. A browser can send request with the header "If-Modified-Since" for necessity of object reloading. If time of modification is earlier, then the framework doesn't call generation and return code 304.
*/
private  Date _lastModified = null;

/*
* Geterated content mime-type for append to response
				header ( 'image/jpeg' etc )
*/
private  String _mimeType = null;

/*
* JavaScript code. The onblur event occurs when an element loses focus either by the pointing device or by tabbing navigation. It may be used with the same elements as onfocus
*/
private  String _onblur = null;

/*
* The clientside script method to be called when the element is clicked
*/
private  String _onclick = null;

/*
* The client side script method to be called when the element is double-clicked
*/
private  String _ondblclick = null;

/*
* JavaScript code. The onfocus event occurs when an element gets focus
*/
private  String _onfocus = null;

/*
* The client side script method to be called when a key is pressed down over the element
*/
private  String _onkeydown = null;

/*
* The client side script method to be called when a key is pressed over the element and released
*/
private  String _onkeypress = null;

/*
* The client side script method to be called when a key is released
*/
private  String _onkeyup = null;

/*
* The client side script method to be called when a mouse button is pressed down over the element
*/
private  String _onmousedown = null;

/*
* The client side script method to be called when a pointer is moved within the element
*/
private  String _onmousemove = null;

/*
* The client side script method to be called when a pointer is moved away from the element
*/
private  String _onmouseout = null;

/*
* The client side script method to be called when a pointer is moved onto the element
*/
private  String _onmouseover = null;

/*
* The client side script method to be called when a mouse button is released
*/
private  String _onmouseup = null;

/*
* The relationship from the current document to the anchor specified by this hyperlink. The value of this attribute is a space-separated list of link types
*/
private  String _rel = null;

/*
* A reverse link from the anchor specified by this hyperlink to the current document. The value of this attribute is a space-separated list of link types
*/
private  String _rev = null;

/*
* If "true", a session for an object generation is restored.
*/
private  boolean _session = false;

private  boolean _sessionSet = false;

/*
* This attribute specifies the shape of a region. The possible values are "default", "rect", "circle" and "poly".
*/
private  String _shape = null;

/*
* message to show while loading
*/
private  String _standby = null;

/*
* CSS style(s) is/are to be applied when this component is rendered
*/
private  String _style = null;

/*
* Corresponds to the HTML class attribute
*/
private  String _styleClass = null;

/*
* This attribute specifies the position of the current element in the tabbing order for the current document. This value must be a number between 0 and 32767. User agents should ignore leading zeros
*/
private  String _tabindex = null;

/*
* This attribute specifies the name of a frame where a document is to be opened.
            
            By assigning a name to a frame via the name attribute, authors can refer to it as the "target" of links defined by other elements
*/
private  String _target = null;

/*
* Advisory title information about markup elements generated for this component
*/
private  String _title = null;

/*
* The content type of the resource designated by this hyperlink
*/
private  String _type = null;

/*
* Name of attribute for resource-link attribute ( 'href' for &amp;lt;a&amp;gt;, 'src' for &amp;lt;img&amp;gt; or &amp;lt;script&amp;gt;, etc)
*/
private  String _uriAttribute = null;

/*
* use client-side image map
*/
private  String _usemap = null;

/*
* Deprecated. This attribute specifies the amount of white space to be inserted above and below an IMG, APPLET, or OBJECT. The default value is not specified, but is generally a small, non-zero length
*/
private  String _vspace = null;


public MediaOutput(){
setRendererType("org.ajax4jsf.MediaOutputRenderer");
}

public String getAccesskey(){
	if (this._accesskey != null) {
		return this._accesskey;
	}
	ValueExpression ve = getValueExpression("accesskey");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setAccesskey(String _accesskey){
this._accesskey = _accesskey;
}

public String getAlign(){
	if (this._align != null) {
		return this._align;
	}
	ValueExpression ve = getValueExpression("align");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setAlign(String _align){
this._align = _align;
}

public String getArchive(){
	if (this._archive != null) {
		return this._archive;
	}
	ValueExpression ve = getValueExpression("archive");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setArchive(String _archive){
this._archive = _archive;
}

public String getBorder(){
	if (this._border != null) {
		return this._border;
	}
	ValueExpression ve = getValueExpression("border");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setBorder(String _border){
this._border = _border;
}

public boolean isCacheable(){
	if (this._cacheableSet) {
	    return (this._cacheable);
	}
	ValueExpression ve = getValueExpression("cacheable");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._cacheable);
	    }
	    
	    return value;
	} else {
	    return (this._cacheable);
	}

}

public void setCacheable(boolean _cacheable){
this._cacheable = _cacheable;
this._cacheableSet = true;
}

public String getCharset(){
	if (this._charset != null) {
		return this._charset;
	}
	ValueExpression ve = getValueExpression("charset");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setCharset(String _charset){
this._charset = _charset;
}

public String getClassid(){
	if (this._classid != null) {
		return this._classid;
	}
	ValueExpression ve = getValueExpression("classid");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setClassid(String _classid){
this._classid = _classid;
}

public String getCodebase(){
	if (this._codebase != null) {
		return this._codebase;
	}
	ValueExpression ve = getValueExpression("codebase");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setCodebase(String _codebase){
this._codebase = _codebase;
}

public String getCodetype(){
	if (this._codetype != null) {
		return this._codetype;
	}
	ValueExpression ve = getValueExpression("codetype");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setCodetype(String _codetype){
this._codetype = _codetype;
}

public String getCoords(){
	if (this._coords != null) {
		return this._coords;
	}
	ValueExpression ve = getValueExpression("coords");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setCoords(String _coords){
this._coords = _coords;
}

public MethodExpression getCreateContentExpression(){
return _createContentExpression;
}

public void setCreateContentExpression(MethodExpression _createContentExpression){
this._createContentExpression = _createContentExpression;
}

public String getDeclare(){
	if (this._declare != null) {
		return this._declare;
	}
	ValueExpression ve = getValueExpression("declare");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setDeclare(String _declare){
this._declare = _declare;
}

public String getDir(){
	if (this._dir != null) {
		return this._dir;
	}
	ValueExpression ve = getValueExpression("dir");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setDir(String _dir){
this._dir = _dir;
}

public String getElement(){
	if (this._element != null) {
		return this._element;
	}
	ValueExpression ve = getValueExpression("element");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setElement(String _element){
this._element = _element;
}

public Date getExpires(){
	if (this._expires != null) {
		return this._expires;
	}
	ValueExpression ve = getValueExpression("expires");
	if (ve != null) {
	    Date value = null;
	    
	    try {
			value = (Date) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setExpires(Date _expires){
this._expires = _expires;
}

public String getHreflang(){
	if (this._hreflang != null) {
		return this._hreflang;
	}
	ValueExpression ve = getValueExpression("hreflang");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setHreflang(String _hreflang){
this._hreflang = _hreflang;
}

public String getHspace(){
	if (this._hspace != null) {
		return this._hspace;
	}
	ValueExpression ve = getValueExpression("hspace");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setHspace(String _hspace){
this._hspace = _hspace;
}

public boolean isIsmap(){
	if (this._ismapSet) {
	    return (this._ismap);
	}
	ValueExpression ve = getValueExpression("ismap");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._ismap);
	    }
	    
	    return value;
	} else {
	    return (this._ismap);
	}

}

public void setIsmap(boolean _ismap){
this._ismap = _ismap;
this._ismapSet = true;
}

public String getLang(){
	if (this._lang != null) {
		return this._lang;
	}
	ValueExpression ve = getValueExpression("lang");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setLang(String _lang){
this._lang = _lang;
}

public Date getLastModified(){
	if (this._lastModified != null) {
		return this._lastModified;
	}
	ValueExpression ve = getValueExpression("lastModified");
	if (ve != null) {
	    Date value = null;
	    
	    try {
			value = (Date) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setLastModified(Date _lastModified){
this._lastModified = _lastModified;
}

public String getMimeType(){
	if (this._mimeType != null) {
		return this._mimeType;
	}
	ValueExpression ve = getValueExpression("mimeType");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setMimeType(String _mimeType){
this._mimeType = _mimeType;
}

public String getOnblur(){
	if (this._onblur != null) {
		return this._onblur;
	}
	ValueExpression ve = getValueExpression("onblur");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnblur(String _onblur){
this._onblur = _onblur;
}

public String getOnclick(){
	if (this._onclick != null) {
		return this._onclick;
	}
	ValueExpression ve = getValueExpression("onclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnclick(String _onclick){
this._onclick = _onclick;
}

public String getOndblclick(){
	if (this._ondblclick != null) {
		return this._ondblclick;
	}
	ValueExpression ve = getValueExpression("ondblclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOndblclick(String _ondblclick){
this._ondblclick = _ondblclick;
}

public String getOnfocus(){
	if (this._onfocus != null) {
		return this._onfocus;
	}
	ValueExpression ve = getValueExpression("onfocus");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnfocus(String _onfocus){
this._onfocus = _onfocus;
}

public String getOnkeydown(){
	if (this._onkeydown != null) {
		return this._onkeydown;
	}
	ValueExpression ve = getValueExpression("onkeydown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeydown(String _onkeydown){
this._onkeydown = _onkeydown;
}

public String getOnkeypress(){
	if (this._onkeypress != null) {
		return this._onkeypress;
	}
	ValueExpression ve = getValueExpression("onkeypress");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeypress(String _onkeypress){
this._onkeypress = _onkeypress;
}

public String getOnkeyup(){
	if (this._onkeyup != null) {
		return this._onkeyup;
	}
	ValueExpression ve = getValueExpression("onkeyup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeyup(String _onkeyup){
this._onkeyup = _onkeyup;
}

public String getOnmousedown(){
	if (this._onmousedown != null) {
		return this._onmousedown;
	}
	ValueExpression ve = getValueExpression("onmousedown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmousedown(String _onmousedown){
this._onmousedown = _onmousedown;
}

public String getOnmousemove(){
	if (this._onmousemove != null) {
		return this._onmousemove;
	}
	ValueExpression ve = getValueExpression("onmousemove");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmousemove(String _onmousemove){
this._onmousemove = _onmousemove;
}

public String getOnmouseout(){
	if (this._onmouseout != null) {
		return this._onmouseout;
	}
	ValueExpression ve = getValueExpression("onmouseout");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseout(String _onmouseout){
this._onmouseout = _onmouseout;
}

public String getOnmouseover(){
	if (this._onmouseover != null) {
		return this._onmouseover;
	}
	ValueExpression ve = getValueExpression("onmouseover");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseover(String _onmouseover){
this._onmouseover = _onmouseover;
}

public String getOnmouseup(){
	if (this._onmouseup != null) {
		return this._onmouseup;
	}
	ValueExpression ve = getValueExpression("onmouseup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseup(String _onmouseup){
this._onmouseup = _onmouseup;
}

public String getRel(){
	if (this._rel != null) {
		return this._rel;
	}
	ValueExpression ve = getValueExpression("rel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setRel(String _rel){
this._rel = _rel;
}

public String getRev(){
	if (this._rev != null) {
		return this._rev;
	}
	ValueExpression ve = getValueExpression("rev");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setRev(String _rev){
this._rev = _rev;
}

public boolean isSession(){
	if (this._sessionSet) {
	    return (this._session);
	}
	ValueExpression ve = getValueExpression("session");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._session);
	    }
	    
	    return value;
	} else {
	    return (this._session);
	}

}

public void setSession(boolean _session){
this._session = _session;
this._sessionSet = true;
}

public String getShape(){
	if (this._shape != null) {
		return this._shape;
	}
	ValueExpression ve = getValueExpression("shape");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setShape(String _shape){
this._shape = _shape;
}

public String getStandby(){
	if (this._standby != null) {
		return this._standby;
	}
	ValueExpression ve = getValueExpression("standby");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStandby(String _standby){
this._standby = _standby;
}

public String getStyle(){
	if (this._style != null) {
		return this._style;
	}
	ValueExpression ve = getValueExpression("style");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyle(String _style){
this._style = _style;
}

public String getStyleClass(){
	if (this._styleClass != null) {
		return this._styleClass;
	}
	ValueExpression ve = getValueExpression("styleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyleClass(String _styleClass){
this._styleClass = _styleClass;
}

public String getTabindex(){
	if (this._tabindex != null) {
		return this._tabindex;
	}
	ValueExpression ve = getValueExpression("tabindex");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setTabindex(String _tabindex){
this._tabindex = _tabindex;
}

public String getTarget(){
	if (this._target != null) {
		return this._target;
	}
	ValueExpression ve = getValueExpression("target");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setTarget(String _target){
this._target = _target;
}

public String getTitle(){
	if (this._title != null) {
		return this._title;
	}
	ValueExpression ve = getValueExpression("title");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setTitle(String _title){
this._title = _title;
}

public String getType(){
	if (this._type != null) {
		return this._type;
	}
	ValueExpression ve = getValueExpression("type");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setType(String _type){
this._type = _type;
}

public String getUriAttribute(){
	if (this._uriAttribute != null) {
		return this._uriAttribute;
	}
	ValueExpression ve = getValueExpression("uriAttribute");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setUriAttribute(String _uriAttribute){
this._uriAttribute = _uriAttribute;
}

public String getUsemap(){
	if (this._usemap != null) {
		return this._usemap;
	}
	ValueExpression ve = getValueExpression("usemap");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setUsemap(String _usemap){
this._usemap = _usemap;
}

public String getVspace(){
	if (this._vspace != null) {
		return this._vspace;
	}
	ValueExpression ve = getValueExpression("vspace");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setVspace(String _vspace){
this._vspace = _vspace;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[51];
state[0] = super.saveState(context);
state[1] = _accesskey;
state[2] = _align;
state[3] = _archive;
state[4] = _border;
state[5] = Boolean.valueOf(_cacheable);
state[6] = Boolean.valueOf(_cacheableSet);
state[7] = _charset;
state[8] = _classid;
state[9] = _codebase;
state[10] = _codetype;
state[11] = _coords;
state[12] = saveAttachedState(context, _createContentExpression);
state[13] = _declare;
state[14] = _dir;
state[15] = _element;
state[16] = saveAttachedState(context, _expires);
state[17] = _hreflang;
state[18] = _hspace;
state[19] = Boolean.valueOf(_ismap);
state[20] = Boolean.valueOf(_ismapSet);
state[21] = _lang;
state[22] = saveAttachedState(context, _lastModified);
state[23] = _mimeType;
state[24] = _onblur;
state[25] = _onclick;
state[26] = _ondblclick;
state[27] = _onfocus;
state[28] = _onkeydown;
state[29] = _onkeypress;
state[30] = _onkeyup;
state[31] = _onmousedown;
state[32] = _onmousemove;
state[33] = _onmouseout;
state[34] = _onmouseover;
state[35] = _onmouseup;
state[36] = _rel;
state[37] = _rev;
state[38] = Boolean.valueOf(_session);
state[39] = Boolean.valueOf(_sessionSet);
state[40] = _shape;
state[41] = _standby;
state[42] = _style;
state[43] = _styleClass;
state[44] = _tabindex;
state[45] = _target;
state[46] = _title;
state[47] = _type;
state[48] = _uriAttribute;
state[49] = _usemap;
state[50] = _vspace;
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_accesskey = (String)states[1];;
		_align = (String)states[2];;
		_archive = (String)states[3];;
		_border = (String)states[4];;
		_cacheable = ((Boolean)states[5]).booleanValue();
		_cacheableSet = ((Boolean)states[6]).booleanValue();
		_charset = (String)states[7];;
		_classid = (String)states[8];;
		_codebase = (String)states[9];;
		_codetype = (String)states[10];;
		_coords = (String)states[11];;
		_createContentExpression = (MethodExpression)restoreAttachedState(context, states[12]);
		_declare = (String)states[13];;
		_dir = (String)states[14];;
		_element = (String)states[15];;
		_expires = (Date)restoreAttachedState(context, states[16]);
		_hreflang = (String)states[17];;
		_hspace = (String)states[18];;
		_ismap = ((Boolean)states[19]).booleanValue();
		_ismapSet = ((Boolean)states[20]).booleanValue();
		_lang = (String)states[21];;
		_lastModified = (Date)restoreAttachedState(context, states[22]);
		_mimeType = (String)states[23];;
		_onblur = (String)states[24];;
		_onclick = (String)states[25];;
		_ondblclick = (String)states[26];;
		_onfocus = (String)states[27];;
		_onkeydown = (String)states[28];;
		_onkeypress = (String)states[29];;
		_onkeyup = (String)states[30];;
		_onmousedown = (String)states[31];;
		_onmousemove = (String)states[32];;
		_onmouseout = (String)states[33];;
		_onmouseover = (String)states[34];;
		_onmouseup = (String)states[35];;
		_rel = (String)states[36];;
		_rev = (String)states[37];;
		_session = ((Boolean)states[38]).booleanValue();
		_sessionSet = ((Boolean)states[39]).booleanValue();
		_shape = (String)states[40];;
		_standby = (String)states[41];;
		_style = (String)states[42];;
		_styleClass = (String)states[43];;
		_tabindex = (String)states[44];;
		_target = (String)states[45];;
		_title = (String)states[46];;
		_type = (String)states[47];;
		_uriAttribute = (String)states[48];;
		_usemap = (String)states[49];;
		_vspace = (String)states[50];;
	
}

}
