/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html.images;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.Date;
import javax.faces.context.FacesContext;
import org.ajax4jsf.resource.InternetResourceBuilder;
import org.ajax4jsf.resource.Java2Dresource;
import org.ajax4jsf.resource.PngRenderer;
import org.ajax4jsf.resource.ResourceContext;
import org.ajax4jsf.resource.ResourceRenderer;
import org.ajax4jsf.util.HtmlColor;
import org.ajax4jsf.util.Zipper2;
import org.richfaces.renderkit.html.images.ColorUtils;
import org.richfaces.skin.SkinFactory;

public class ProgressBarBg
extends Java2Dresource {
    private Dimension dim = new Dimension(24, 48);
    private Color progressbarBasicColor;

    public ProgressBarBg() {
        this.setRenderer((ResourceRenderer)new PngRenderer());
        this.setLastModified(new Date(InternetResourceBuilder.getInstance().getStartTime()));
    }

    protected Dimension getDimensions(ResourceContext resourceContext) {
        return this.dim;
    }

    public Dimension getDimensions(FacesContext facesContext, Object data) {
        return this.dim;
    }

    public boolean isCacheable(ResourceContext ctx) {
        return true;
    }

    protected void paint(ResourceContext context, Graphics2D g2d) {
        this.restoreData(context);
        Color progressbarBackgroundColor = this.progressbarBasicColor;
        Color progressbarSpiralColor = ColorUtils.adjustLightness(this.progressbarBasicColor, 0.2f);
        Color progressbarShadowStartColor = ColorUtils.overwriteAlpha(ColorUtils.adjustLightness(this.progressbarBasicColor, 0.7f), 0.6f);
        Color progressbarShadowEndColor = ColorUtils.overwriteAlpha(ColorUtils.adjustLightness(this.progressbarBasicColor, 0.3f), 0.6f);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(progressbarBackgroundColor);
        g2d.fillRect(0, 0, this.dim.width, this.dim.height);
        g2d.setColor(progressbarSpiralColor);
        for (int k : new int[]{-24, 0, 24}) {
            g2d.fillPolygon(new int[]{0, 24, 24, 0}, new int[]{24 + k, k, 12 + k, 36 + k}, 4);
        }
        g2d.setPaint(new GradientPaint(0.0f, 0.0f, progressbarShadowStartColor, 0.0f, 7.0f, progressbarShadowEndColor));
        g2d.fillRect(0, 0, this.dim.width, 7);
    }

    protected Object getDataToStore(FacesContext context, Object data) {
        byte[] retVal = new byte[3];
        this.progressbarBasicColor = this.getColorValueParameter(context, "selectControlColor");
        new Zipper2(retVal).addColor(this.progressbarBasicColor);
        return retVal;
    }

    protected Object deserializeData(byte[] objectArray) {
        if (objectArray != null) {
            Zipper2 zipper2 = new Zipper2(objectArray);
            this.progressbarBasicColor = zipper2.nextColor();
        }
        return objectArray;
    }

    private Color getColorValueParameter(FacesContext context, String name) {
        Color retVal = null;
        String color = (String)SkinFactory.getInstance().getSkin(context).getParameter(context, name);
        if (null == color || "".equals(color.trim())) {
            color = (String)SkinFactory.getInstance().getDefaultSkin(context).getParameter(context, name);
        }
        if (null != color && !"".equals(color.trim())) {
            retVal = HtmlColor.decode((String)color);
        }
        return retVal;
    }
}

