/**
 * License Agreement.
 *
 * Ajax4jsf 1.1 - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.renderkit.html;


// 
// Imports
//
import java.util.Iterator;
import java.util.Collection;
import java.util.Map;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.ComponentVariables;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.InternetResource;
//
//
//


import org.richfaces.renderkit.InplaceInputBaseRenderer;



/**
 * Renderer for component class org.richfaces.renderkit.html.InplaceInputRenderer
 */
public class InplaceInputRenderer extends InplaceInputBaseRenderer {

	public InplaceInputRenderer () {
		super();
	}

	// 
	// Declarations
	//
	private final InternetResource[] styles = {
						getResource("css/inplaceinput.xcss")
	};

private InternetResource[] stylesAll = null;

protected InternetResource[] getStyles() {
	synchronized (this) {
		if (stylesAll == null) {
			InternetResource[] rsrcs = super.getStyles();
			boolean ignoreSuper = rsrcs == null || rsrcs.length == 0;
			boolean ignoreThis = styles == null || styles.length == 0;
			
			if (ignoreSuper) {
				if (ignoreThis) {
					stylesAll = new InternetResource[0];	
				} else {
					stylesAll = styles;
				}
			} else {
				if (ignoreThis) {
					stylesAll = rsrcs;
				} else {
					java.util.Set rsrcsSet = new java.util.LinkedHashSet();

					for (int i = 0; i < rsrcs.length; i++ ) {
						rsrcsSet.add(rsrcs[i]);
					}

					for (int i = 0; i < styles.length; i++ ) {
						rsrcsSet.add(styles[i]);
					}

					stylesAll = (InternetResource[]) rsrcsSet.toArray(new InternetResource[rsrcsSet.size()]);
				}
			}
		}
	}
	
	return stylesAll;
}
	private final InternetResource[] scripts = {
						new org.ajax4jsf.javascript.PrototypeScript()
						,
				getResource("scripts/comboboxUtils.js")
						,
				getResource("scripts/utils.js")
						,
				getResource("scripts/inplaceinput.js")
						,
				getResource("scripts/inplaceinputstyles.js")
	};

private InternetResource[] scriptsAll = null;

protected InternetResource[] getScripts() {
	synchronized (this) {
		if (scriptsAll == null) {
			InternetResource[] rsrcs = super.getScripts();
			boolean ignoreSuper = rsrcs == null || rsrcs.length == 0;
			boolean ignoreThis = scripts == null || scripts.length == 0;
			
			if (ignoreSuper) {
				if (ignoreThis) {
					scriptsAll = new InternetResource[0];	
				} else {
					scriptsAll = scripts;
				}
			} else {
				if (ignoreThis) {
					scriptsAll = rsrcs;
				} else {
					java.util.Set rsrcsSet = new java.util.LinkedHashSet();

					for (int i = 0; i < rsrcs.length; i++ ) {
						rsrcsSet.add(rsrcs[i]);
					}

					for (int i = 0; i < scripts.length; i++ ) {
						rsrcsSet.add(scripts[i]);
					}

					scriptsAll = (InternetResource[]) rsrcsSet.toArray(new InternetResource[rsrcsSet.size()]);
				}
			}
		}
	}
	
	return scriptsAll;
}
	// 
	// 
	//


	private String convertToString(Object obj ) {
		return ( obj == null ? "" : obj.toString() );
	}
	private String convertToString(boolean b ) {
		return String.valueOf(b);
	}
	private String convertToString(int b ) {
		return b!=Integer.MIN_VALUE?String.valueOf(b):"";
	}
	private String convertToString(long b ) {
		return b!=Long.MIN_VALUE?String.valueOf(b):"";
	}
	
	private boolean isEmpty(Object o) {
		if (null == o) {
			return true;
		}
		if (o instanceof String ) {
			return (0 == ((String)o).length());
		}
		if (o instanceof Collection) {
			return (0 == ((Collection)o).size());
		}
		if (o instanceof Map) {
			return (0 == ((Map)o).size());
		}
		if (o.getClass().isArray()) {
			return (0 == ((Object [])o).length);
		}
		return false;
	}
	
	/**
	 * Get base component class, targetted for this renderer. Used for check arguments in decode/encode.
	 * @return
	 */
	protected Class getComponentClass() {
		return org.richfaces.component.UIInplaceInput.class;
	}


	public void doEncodeEnd(ResponseWriter writer, FacesContext context, org.richfaces.component.UIInplaceInput component, ComponentVariables variables) throws IOException {
	  variables.setVariable("saveIcon", getResource( "org.richfaces.renderkit.html.images.SaveControlIcon" ).getUri(context, component) );

variables.setVariable("cancelIcon", getResource( "org.richfaces.renderkit.html.images.CancelControlIcon" ).getUri(context, component) );

variables.setVariable("spacer", getResource( "images/spacer.gif" ).getUri(context, component) );

java.lang.String clientId = component.getClientId(context);

		
		String value = (String)component.getSubmittedValue();         
		if (value == null) {         
			value = getConvertedStringValue(context, component,component.getValue());
		}
		
		String fieldValue = value;
	   	if (value == null || value.trim().equals("")) {
	   		fieldValue = "";
	   		String defaultValue = (String)component.getAttributes().get("defaultLabel"); 
	   		if(defaultValue == null || defaultValue.trim().equals("")) {
	   		 	defaultValue = "\u00a0\u00a0\u00a0";    
	   		}
	   		value = defaultValue; 
	   	}
	   	
	   	variables.setVariable("value", value);
	   	variables.setVariable("fieldValue", fieldValue);
	   	
	   	String saveIcon =  (String)component.getAttributes().get("saveControlIcon");
	   	if (saveIcon != null && saveIcon.length() != 0 ) {
	   		variables.setVariable("saveIcon", org.richfaces.component.util.ViewUtil.getResourceURL(saveIcon ,context));
	   	}
	   	
	   	String cancelIcon =  (String)component.getAttributes().get("cancelControlIcon");
	   	if (cancelIcon != null && cancelIcon.length() != 0 ) {
	   		variables.setVariable("cancelIcon", org.richfaces.component.util.ViewUtil.getResourceURL(cancelIcon ,context));
	   	}
	   	
	   	String controlClass = (String)component.getAttributes().get("controlClass");
	   	variables.setVariable("controlClass", controlClass);
	   	String controlHoverClass = (String)component.getAttributes().get("controlHoverClass"); 
	   	variables.setVariable("controlHoverClass", controlHoverClass);
	   	String controlPressedClass = (String)component.getAttributes().get("controlPressedClass"); 
	   	variables.setVariable("controlPressedClass", controlPressedClass);
	   	
	   	String styleClass = (String)component.getAttributes().get("styleClass");
	   	styleClass = styleClass != null ? styleClass.trim() : "";
	   	variables.setVariable("styleClass", styleClass);
	   	
	   	String changedClass = (String)component.getAttributes().get("changedClass");
	   	changedClass = (changedClass != null ? changedClass.trim() : "") + " " + styleClass;
	   	variables.setVariable("changedClass", changedClass);
	   	
	   	String viewClass = (String)component.getAttributes().get("viewClass");
	   	viewClass = (viewClass != null ? viewClass.trim() : "") + " " + styleClass;
	   	variables.setVariable("viewClass", viewClass);
	   	
	   	String editClass = (String)component.getAttributes().get("editClass");
	   	editClass = (editClass != null ? editClass.trim() : "") + " " + styleClass;
	   	variables.setVariable("editClass", editClass);
		
	   	String layout = (String)component.getAttributes().get("layout");
	   	if (layout != null && layout.length() != 0) {
	   		if (!layout.equals("block")) {
	   			layout = "inline";
	   		}
	   	} else {
			layout = "inline";
	   	}
		
	   	if (layout.equals("inline")) {
	   		   	
	   	
	
writer.startElement("span", component);
			getUtils().writeAttribute(writer, "class", "rich-inplace rich-inplace-view " + convertToString(variables.getVariable("viewClass")) );
						getUtils().writeAttribute(writer, "id", clientId );
						getUtils().writeAttribute(writer, "style", "zoom: 1; " + convertToString(component.getAttributes().get("style")) );
			//
// pass thru attributes
//
getUtils().encodeAttributesFromArray(context,component,new String[] {
    "dir" ,
	    "lang" ,
	    "onclick" ,
	    "ondblclick" ,
	    "onkeydown" ,
	    "onkeypress" ,
	    "onkeyup" ,
	    "onmousedown" ,
	    "onmousemove" ,
	    "onmouseout" ,
	    "onmouseover" ,
	    "onmouseup" ,
	    "style" ,
	    "title" ,
	    "xml:lang" });
//
//
//


	   	} else {
	
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-inplace rich-inplace-view " + convertToString(variables.getVariable("viewClass")) );
						getUtils().writeAttribute(writer, "id", clientId );
						getUtils().writeAttribute(writer, "style", "zoom: 1; " + convertToString(component.getAttributes().get("style")) );
			//
// pass thru attributes
//
getUtils().encodeAttributesFromArray(context,component,new String[] {
    "align" ,
	    "dir" ,
	    "lang" ,
	    "onclick" ,
	    "ondblclick" ,
	    "onkeydown" ,
	    "onkeypress" ,
	    "onkeyup" ,
	    "onmousedown" ,
	    "onmousemove" ,
	    "onmouseout" ,
	    "onmouseover" ,
	    "onmouseup" ,
	    "style" ,
	    "title" ,
	    "xml:lang" });
//
//
//


	   	} 
	
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "autocomplete", "off" );
						getUtils().writeAttribute(writer, "class", "rich-inplace-field" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "tempValue" );
						getUtils().writeAttribute(writer, "onblur", component.getAttributes().get("onblur") );
						getUtils().writeAttribute(writer, "onclick", component.getAttributes().get("oninputclick") );
						getUtils().writeAttribute(writer, "ondblclick", component.getAttributes().get("oninputdblclick") );
						getUtils().writeAttribute(writer, "onfocus", component.getAttributes().get("onfocus") );
						getUtils().writeAttribute(writer, "onkeydown", component.getAttributes().get("oninputkeydown") );
						getUtils().writeAttribute(writer, "onkeypress", component.getAttributes().get("oninputkeypress") );
						getUtils().writeAttribute(writer, "onkeyup", component.getAttributes().get("oninputkeyup") );
						getUtils().writeAttribute(writer, "onmousedown", component.getAttributes().get("oninputmousedown") );
						getUtils().writeAttribute(writer, "onmousemove", component.getAttributes().get("oninputmousemove") );
						getUtils().writeAttribute(writer, "onmouseout", component.getAttributes().get("oninputmouseout") );
						getUtils().writeAttribute(writer, "onmouseover", component.getAttributes().get("oninputmouseover") );
						getUtils().writeAttribute(writer, "onmouseup", component.getAttributes().get("oninputmouseup") );
						getUtils().writeAttribute(writer, "onselect", component.getAttributes().get("onselect") );
						getUtils().writeAttribute(writer, "style", "clip:rect(0px 0px 0px 0px)" );
						getUtils().writeAttribute(writer, "type", "text" );
						getUtils().writeAttribute(writer, "value", variables.getVariable("fieldValue") );
			
writer.endElement("input");
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "id", convertToString(clientId) + "value" );
						getUtils().writeAttribute(writer, "name", clientId );
						getUtils().writeAttribute(writer, "type", "hidden" );
						getUtils().writeAttribute(writer, "value", variables.getVariable("fieldValue") );
			
writer.endElement("input");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-inplace-input-controls-set" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "bar" );
						getUtils().writeAttribute(writer, "style", "display:none;" );
			

				
				 if (isControlsFacetExists(context, component)) {
				     encodeControlsFacet(context, component);
				 } else {
				
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-inplace-shadow" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "btns_shadow" );
			
writer.startElement("table", component);
			getUtils().writeAttribute(writer, "border", "0" );
						getUtils().writeAttribute(writer, "cellpadding", "0" );
						getUtils().writeAttribute(writer, "cellspacing", "0" );
						getUtils().writeAttribute(writer, "class", "rich-inplace-shadow-size" );
			
writer.startElement("tbody", component);

writer.startElement("tr", component);

writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", "rich-inplace-shadow-tl" );
			
writer.startElement("img", component);
			getUtils().writeAttribute(writer, "alt", "" );
						getUtils().writeAttribute(writer, "height", "1" );
						getUtils().writeAttribute(writer, "src", variables.getVariable("spacer") );
						getUtils().writeAttribute(writer, "style", "border:0" );
						getUtils().writeAttribute(writer, "width", "10" );
			
writer.endElement("img");
writer.endElement("td");
writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", "rich-inplace-shadow-tr" );
			
writer.startElement("img", component);
			getUtils().writeAttribute(writer, "alt", "" );
						getUtils().writeAttribute(writer, "height", "10" );
						getUtils().writeAttribute(writer, "src", variables.getVariable("spacer") );
						getUtils().writeAttribute(writer, "style", "border:0" );
						getUtils().writeAttribute(writer, "width", "1" );
			
writer.endElement("img");
writer.endElement("td");
writer.endElement("tr");
writer.startElement("tr", component);

writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", "rich-inplace-shadow-bl" );
			
writer.startElement("img", component);
			getUtils().writeAttribute(writer, "alt", "" );
						getUtils().writeAttribute(writer, "height", "10" );
						getUtils().writeAttribute(writer, "src", variables.getVariable("spacer") );
						getUtils().writeAttribute(writer, "style", "border:0" );
						getUtils().writeAttribute(writer, "width", "1" );
			
writer.endElement("img");
writer.endElement("td");
writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", "rich-inplace-shadow-br" );
			
writer.startElement("img", component);
			getUtils().writeAttribute(writer, "alt", "" );
						getUtils().writeAttribute(writer, "height", "1" );
						getUtils().writeAttribute(writer, "src", variables.getVariable("spacer") );
						getUtils().writeAttribute(writer, "style", "border:0" );
						getUtils().writeAttribute(writer, "width", "10" );
			
writer.endElement("img");
writer.endElement("td");
writer.endElement("tr");
writer.endElement("tbody");
writer.endElement("table");
writer.endElement("div");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "id", convertToString(clientId) + "buttons" );
						getUtils().writeAttribute(writer, "style", "position:relative; width: 1px" );
			
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "class", "rich-inplace-control " + convertToString(variables.getVariable("controlClass")) );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "ok" );
						getUtils().writeAttribute(writer, "onmousedown", "this.className='rich-inplace-control-press " + convertToString(variables.getVariable("controlPressedClass")) + "'" );
						getUtils().writeAttribute(writer, "onmouseout", "this.className='rich-inplace-control " + convertToString(variables.getVariable("controlClass")) + "'" );
						getUtils().writeAttribute(writer, "onmouseover", "this.className='rich-inplace-control " + convertToString(variables.getVariable("controlHoverClass")) + "'" );
						getUtils().writeAttribute(writer, "onmouseup", "this.className='rich-inplace-control " + convertToString(variables.getVariable("controlClass")) + "'" );
						getUtils().writeAttribute(writer, "src", variables.getVariable("saveIcon") );
						getUtils().writeAttribute(writer, "type", "image" );
			
writer.endElement("input");
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "class", "rich-inplace-control " + convertToString(variables.getVariable("controlClass")) );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "cancel" );
						getUtils().writeAttribute(writer, "onmousedown", "this.className='rich-inplace-control-press  " + convertToString(variables.getVariable("controlPressedClass")) + "'" );
						getUtils().writeAttribute(writer, "onmouseout", "this.className='rich-inplace-control " + convertToString(variables.getVariable("controlClass")) + "'" );
						getUtils().writeAttribute(writer, "onmouseover", "this.className='rich-inplace-control " + convertToString(variables.getVariable("controlHoverClass")) + "'" );
						getUtils().writeAttribute(writer, "onmouseup", "this.className='rich-inplace-control " + convertToString(variables.getVariable("controlClass")) + "'" );
						getUtils().writeAttribute(writer, "src", variables.getVariable("cancelIcon") );
						getUtils().writeAttribute(writer, "type", "image" );
			
writer.endElement("input");
writer.endElement("div");

				
				 }
				 
			
writer.startElement("script", component);
			getUtils().writeAttribute(writer, "type", "text/javascript" );
			
writer.writeText(convertToString(convertToString(encodeScriptAttributes(context,component)) + ";\n			" + convertToString(encodeScriptEvents(context,component)) + ";\n						\n			var inplaceInputUserStyles = {\n					component:{\n						view :{\n							normal:'" + convertToString(variables.getVariable("viewClass")) + "', \n							hovered:'" + convertToString(component.getAttributes().get("viewHoverClass")) + "' \n						},\n						changed:{\n							normal:'" + convertToString(variables.getVariable("changedClass")) + "',\n							hovered:'" + convertToString(component.getAttributes().get("changedHoverClass")) + "'\n						},\n						editable:'" + convertToString(variables.getVariable("editClass")) + "'\n						 \n					}\n			};\n		\n			var inplaceInput = new Richfaces.InplaceInput('" + convertToString(clientId) + "', '" + convertToString(clientId) + "tempValue', '" + convertToString(clientId) + "value', '" + convertToString(clientId) + "tabber', \n													  attributes, events, inplaceInputUserStyles, new Richfaces.InplaceInputStyles(), ['" + convertToString(clientId) + "bar', \n													  '" + convertToString(clientId) + "ok', '" + convertToString(clientId) + "cancel', '" + convertToString(clientId) + "buttons','" + convertToString(clientId) + "btns_shadow']);"),null);

writer.endElement("script");
writer.endElement("div");

		if(isEmptyDefaultLabel(convertToString(variables.getVariable("value")))) {
			writer.write(convertToString(variables.getVariable("value")));
		} else {
			writer.writeText(convertToString(variables.getVariable("value")),null);
		}
		if (!layout.equals("inline")) {
	
writer.endElement("div");
	
	   	} else {
	
writer.endElement("span");

	   	}
	

	}		
	
	public void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeEnd(writer, context, (org.richfaces.component.UIInplaceInput)component, variables );

		ComponentsVariableResolver.removeVariables(this, component);
	}		
	

}
