/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.renderkit.HeaderResourcesRendererBase;
import org.richfaces.component.LayoutPosition;
import org.richfaces.component.UILayout;
import org.richfaces.component.UILayoutPanel;

public abstract class AbstractLayoutRenderer
extends HeaderResourcesRendererBase {
    public void renderLayout(FacesContext context, UILayout layout) throws IOException {
        UILayoutPanel top = null;
        UILayoutPanel bottom = null;
        UILayoutPanel left = null;
        UILayoutPanel right = null;
        UILayoutPanel center = null;
        int columns = 0;
        for (UIComponent child : layout.getChildren()) {
            if (!(child instanceof UILayoutPanel)) continue;
            UILayoutPanel layoutPanel = (UILayoutPanel)child;
            LayoutPosition position = layoutPanel.getPosition();
            if (LayoutPosition.top.equals((Object)position)) {
                if (null != top) {
                    throw new FacesException("Duplicate layoutPanel's with same position" + (Object)((Object)position));
                }
                top = layoutPanel;
                continue;
            }
            if (LayoutPosition.bottom.equals((Object)position)) {
                if (null != bottom) {
                    throw new FacesException("Duplicate layoutPanel's with same position" + (Object)((Object)position));
                }
                bottom = layoutPanel;
                continue;
            }
            if (LayoutPosition.left.equals((Object)position)) {
                if (null != left) {
                    throw new FacesException("Duplicate layoutPanel's with same position" + (Object)((Object)position));
                }
                left = layoutPanel;
                ++columns;
                continue;
            }
            if (LayoutPosition.right.equals((Object)position)) {
                if (null != right) {
                    throw new FacesException("Duplicate layoutPanel's with same position" + (Object)((Object)position));
                }
                right = layoutPanel;
                ++columns;
                continue;
            }
            if (null != position && !LayoutPosition.center.equals((Object)position)) continue;
            if (null != center) {
                throw new FacesException("Duplicate layoutPanel's with same position" + (Object)((Object)position));
            }
            center = layoutPanel;
            ++columns;
        }
        ResponseWriter writer = context.getResponseWriter();
        if (null != top) {
            this.renderChild(context, (UIComponent)top);
        }
        if (columns > 0) {
            if (null == left) {
                if (null == center) {
                    left = right;
                    right = null;
                } else {
                    left = center;
                    center = right;
                    right = null;
                }
            } else if (null == center) {
                center = right;
                right = null;
            }
            if (columns > 1) {
                writer.startElement("div", (UIComponent)layout);
                String yahooClass = this.calculateLayoutClass(left, right, center);
                writer.writeAttribute("class", (Object)yahooClass, null);
                left.getAttributes().put("first", "first");
                center.getAttributes().remove("first");
                this.renderChild(context, (UIComponent)left);
                this.renderChild(context, (UIComponent)center);
                if (null != right) {
                    right.getAttributes().remove("first");
                    this.renderChild(context, (UIComponent)right);
                }
                writer.endElement("div");
            } else {
                this.renderChild(context, (UIComponent)left);
            }
        }
        if (null != bottom) {
            this.renderChild(context, (UIComponent)bottom);
        }
    }

    protected String calculateLayoutClass(UILayoutPanel left, UILayoutPanel right, UILayoutPanel center) {
        String yahooClass = "yui-g";
        if (null != left && null != right && null != center) {
            yahooClass = "yui-gb";
        } else if (null != left && null != center) {
            int leftPart = 0;
            String leftWidth = left.getWidth();
            if (null != leftWidth) {
                leftPart = Integer.parseInt(leftWidth);
            }
            int rightPart = 0;
            String centerWidth = center.getWidth();
            if (null != centerWidth) {
                rightPart = Integer.parseInt(centerWidth);
                if (0 == leftPart && 0 > rightPart && centerWidth.endsWith("%")) {
                    leftPart = 100 - rightPart;
                }
            }
            if (0 > leftPart && 0 == rightPart && leftWidth.endsWith("%")) {
                rightPart = 100 - leftPart;
            }
            if (0 > leftPart && 0 > rightPart) {
                double ratio = (double)leftPart / (double)(leftPart + rightPart);
                yahooClass = ratio <= 0.25 ? "yui-gf" : (ratio <= 0.33 ? "yui-gd" : (ratio <= 0.66 ? "yui-gc" : "yui-ge"));
            }
        }
        return yahooClass;
    }
}

