/**
 * 
 */
package org.richfaces.renderkit;

import java.io.IOException;

import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

import org.ajax4jsf.renderkit.HeaderResourcesRendererBase;
import org.ajax4jsf.renderkit.RendererUtils.HTML;
import org.richfaces.component.LayoutPosition;
import org.richfaces.component.UILayout;
import org.richfaces.component.UILayoutPanel;

/**
 * @author asmirnov
 * 
 */
public abstract class AbstractLayoutRenderer extends
		HeaderResourcesRendererBase {

	public void renderLayout(FacesContext context, UILayout layout)
			throws IOException {
		// Detect layout content;
		UILayoutPanel top = null;
		UILayoutPanel bottom = null;
		UILayoutPanel left = null;
		UILayoutPanel right = null;
		UILayoutPanel center = null;
		int columns = 0;
		for (UIComponent child : layout.getChildren()) {
			if (child instanceof UILayoutPanel) {
				UILayoutPanel layoutPanel = (UILayoutPanel) child;
				LayoutPosition position = layoutPanel.getPosition();
				if (LayoutPosition.top.equals(position)) {
					if (null != top) {
						throw new FacesException(
								"Duplicate layoutPanel's with same position"
										+ position);
					}
					top = layoutPanel;
				} else if (LayoutPosition.bottom.equals(position)) {
					if (null != bottom) {
						throw new FacesException(
								"Duplicate layoutPanel's with same position"
										+ position);
					}
					bottom = layoutPanel;
				} else if (LayoutPosition.left.equals(position)) {
					if (null != left) {
						throw new FacesException(
								"Duplicate layoutPanel's with same position"
										+ position);
					}
					left = layoutPanel;
					columns++;
				} else if (LayoutPosition.right.equals(position)) {
					if (null != right) {
						throw new FacesException(
								"Duplicate layoutPanel's with same position"
										+ position);
					}
					right = layoutPanel;
					columns++;
				} else if (null == position
						|| LayoutPosition.center.equals(position)) {
					if (null != center) {
						throw new FacesException(
								"Duplicate layoutPanel's with same position"
										+ position);
					}
					center = layoutPanel;
					columns++;
				} else {

				}
			}
		}
		ResponseWriter writer = context.getResponseWriter();
		if (null != top) {
			renderChild(context, top);
		}
		if (columns > 0) {
			// Reorder panels to fill ordeg left->center->right.
			if (null == left) {
				if (null == center) {
					left = right;
					right = null;
				} else {
					left = center;
					center = right;
					right = null;
				}
			} else if (null == center) {
				center = right;
				right = null;
			}
			if (columns > 1) {
				// Render Y! CSS Grid
				writer.startElement(HTML.DIV_ELEM, layout);
				// calculate class.
				String yahooClass = calculateLayoutClass(left, right, center);
				writer.writeAttribute(HTML.class_ATTRIBUTE, yahooClass, null);
				left.getAttributes().put("first", "first");
				center.getAttributes().remove("first");
				renderChild(context, left);
				renderChild(context, center);
				if (null != right) {
					right.getAttributes().remove("first");
					renderChild(context, right);
				}
				writer.endElement(HTML.DIV_ELEM);
			} else {
				renderChild(context, left);
			}
		}
		if (null != bottom) {
			renderChild(context, bottom);
		}
	}

	/**
	 * @param left
	 * @param right
	 * @param center
	 * @return
	 */
	protected String calculateLayoutClass(UILayoutPanel left,
			UILayoutPanel right, UILayoutPanel center) {
		String yahooClass = "yui-g";
		if (null != left && null != right && null != center) {
			// We have only equal size for an three-column layout.
			yahooClass = "yui-gb";
		} else if(null != left && null != center){
			int leftPart = 0;
			String leftWidth = left.getWidth();
			if(null != leftWidth){
				leftPart = Integer.parseInt(leftWidth);
			}
			int rightPart = 0;
			String centerWidth = center.getWidth();
			if(null != centerWidth){
				rightPart = Integer.parseInt(centerWidth);
				if(0 ==leftPart && 0>rightPart && centerWidth.endsWith("%")){
					leftPart = 100 - rightPart;
				}
			}
			if(0 > leftPart && 0 == rightPart && leftWidth.endsWith("%")){
				rightPart = 100 - leftPart;
			}
			// Calculate properly class.
			if(0>leftPart && 0>rightPart){
				double ratio = (double)leftPart/(double)(leftPart+rightPart);
			if (ratio <= 0.25) {
				yahooClass = "yui-gf";
			} else if (ratio <= 0.33) {
				yahooClass = "yui-gd";
			} else if (ratio <= 0.66) {
				yahooClass = "yui-gc";
			} else {
				yahooClass = "yui-ge";
			}
			}
		}
		return yahooClass;
	}
}
