package org.richfaces.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.richfaces.component.UIInputNumberSpinner;

public class HtmlInputNumberSpinner extends UIInputNumberSpinner{

public final static  String COMPONENT_FAMILY = "org.richfaces.inputNumberSpinner";

public final static  String COMPONENT_TYPE = "org.richfaces.inputNumberSpinner";

/*
* This attribute assigns an access key to an element. An access key is a single character from the document character set. Note: Authors should consider the input method of the expected reader when specifying an accesskey
*/
private  String _accesskey = null;

/*
* For user agents that cannot display images, forms, or applets, this attribute specifies alternate text. The language of the alternate text is specified by the lang attribute
*/
private  String _alt = null;

/*
* An error message to use in client side validation events
*/
private  String _clientErrorMessage = null;

/*
* If "true" after the current value reaches the border value it is reversed to another border value
	    		after next increasing/decreasing. In other case possibilities of next increasing (or decreasing) will be locked. Default value is " true ".
*/
private  boolean _cycled = true;

private  boolean _cycledSet = false;

/*
* Disable browser's auto completion. Default value is "false"
*/
private  boolean _disableBrowserAutoComplete = false;

private  boolean _disableBrowserAutoCompleteSet = false;

/*
* When set for a form control, this boolean attribute disables the control for your input
*/
private  boolean _disabled = false;

private  boolean _disabledSet = false;

/*
* if "false" your's input to the text field using keyboard will be locked. Default value is "true"
*/
private  boolean _enableManualInput = true;

private  boolean _enableManualInputSet = false;

/*
* Class attribute for text field
*/
private  String _inputClass = null;

/*
* Attribute specifies the initial length of input in characters. Default value is "10".
*/
private  int _inputSize = 10;

private  boolean _inputSizeSet = false;

/*
* Style attribute for text field
*/
private  String _inputStyle = null;

/*
* A localized user presentable name for this component.
*/
private  String _label = null;

/*
* Maximum value. . Default value is "100".
*/
private  String _maxValue = null;

/*
* null
*/
private  int _maxlength = Integer.MIN_VALUE;

private  boolean _maxlengthSet = false;

/*
* Minimum value. Default value is "0".
*/
private  String _minValue = null;

/*
* HTML: script expression; the element lost the focus
*/
private  String _onblur = null;

/*
* HTML: script expression; the element value was changed
*/
private  String _onchange = null;

/*
* HTML: a script expression; a pointer button is clicked
*/
private  String _onclick = null;

/*
* HTML: a script expression; a pointer button is double-clicked
*/
private  String _ondblclick = null;

/*
* HTML: a script expression; a button "Down" is clicked
*/
private  String _ondownclick = null;

/*
* HTML: a script expression; event fires whenever an JavaScript error occurs
*/
private  String _onerror = null;

/*
* HTML: script expression; the element got the focus
*/
private  String _onfocus = null;

/*
* HTML: a script expression; a pointer button is clicked
*/
private  String _oninputclick = null;

/*
* HTML: a script expression; a pointer button is double-clicked
*/
private  String _oninputdblclick = null;

/*
* HTML: a script expression; a key is pressed down
*/
private  String _oninputkeydown = null;

/*
* HTML: a script expression; a key is pressed and released
*/
private  String _oninputkeypress = null;

/*
* HTML: a script expression; a key is released
*/
private  String _oninputkeyup = null;

/*
* HTML: script expression; a pointer button is pressed down
*/
private  String _oninputmousedown = null;

/*
* HTML: a script expression; a pointer is moved within
*/
private  String _oninputmousemove = null;

/*
* HTML: a script expression; a pointer is moved away
*/
private  String _oninputmouseout = null;

/*
* HTML: a script expression; a pointer is moved onto
*/
private  String _oninputmouseover = null;

/*
* HTML: script expression; a pointer button is released
*/
private  String _oninputmouseup = null;

/*
* null
*/
private  String _onkeydown = null;

/*
* null
*/
private  String _onkeypress = null;

/*
* null
*/
private  String _onkeyup = null;

/*
* HTML: script expression; a pointer button is pressed down
*/
private  String _onmousedown = null;

/*
* HTML: a script expression; a pointer is moved within
*/
private  String _onmousemove = null;

/*
* HTML: a script expression; a pointer is moved away
*/
private  String _onmouseout = null;

/*
* HTML: a script expression; a pointer is moved onto
*/
private  String _onmouseover = null;

/*
* HTML: script expression; a pointer button is released
*/
private  String _onmouseup = null;

/*
* HTML: script expression; some text is selected in a text field. This attribute may be used with the INPUT and TEXTAREA elements
*/
private  String _onselect = null;

/*
* HTML: a script expression; a button "Up" is clicked
*/
private  String _onupclick = null;

/*
* null
*/
private  int _size = Integer.MIN_VALUE;

private  boolean _sizeSet = false;

/*
* Parameter that determines the step between nearest values while using controls. Default value is "1"
*/
private  String _step = null;

/*
* CSS style(s) is/are to be applied when this component is rendered
*/
private  String _style = null;

/*
* Corresponds to the HTML class attribute
*/
private  String _styleClass = null;

/*
* This attribute specifies the position of the current element in the tabbing order for the current document. This value must be a number between 0 and 32767. User agents should ignore leading zeros
*/
private  String _tabindex = null;


public HtmlInputNumberSpinner(){
setRendererType("org.richfaces.InputNumberSpinnerRenderer");
}

public String getAccesskey(){
	if (this._accesskey != null) {
		return this._accesskey;
	}
	ValueExpression ve = getValueExpression("accesskey");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setAccesskey(String _accesskey){
this._accesskey = _accesskey;
}

public String getAlt(){
	if (this._alt != null) {
		return this._alt;
	}
	ValueExpression ve = getValueExpression("alt");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setAlt(String _alt){
this._alt = _alt;
}

public String getClientErrorMessage(){
	if (this._clientErrorMessage != null) {
		return this._clientErrorMessage;
	}
	ValueExpression ve = getValueExpression("clientErrorMessage");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setClientErrorMessage(String _clientErrorMessage){
this._clientErrorMessage = _clientErrorMessage;
}

public boolean isCycled(){
	if (this._cycledSet) {
	    return (this._cycled);
	}
	ValueExpression ve = getValueExpression("cycled");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._cycled);
	    }
	    
	    return value;
	} else {
	    return (this._cycled);
	}

}

public void setCycled(boolean _cycled){
this._cycled = _cycled;
this._cycledSet = true;
}

public boolean isDisableBrowserAutoComplete(){
	if (this._disableBrowserAutoCompleteSet) {
	    return (this._disableBrowserAutoComplete);
	}
	ValueExpression ve = getValueExpression("disableBrowserAutoComplete");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._disableBrowserAutoComplete);
	    }
	    
	    return value;
	} else {
	    return (this._disableBrowserAutoComplete);
	}

}

public void setDisableBrowserAutoComplete(boolean _disableBrowserAutoComplete){
this._disableBrowserAutoComplete = _disableBrowserAutoComplete;
this._disableBrowserAutoCompleteSet = true;
}

public boolean isDisabled(){
	if (this._disabledSet) {
	    return (this._disabled);
	}
	ValueExpression ve = getValueExpression("disabled");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._disabled);
	    }
	    
	    return value;
	} else {
	    return (this._disabled);
	}

}

public void setDisabled(boolean _disabled){
this._disabled = _disabled;
this._disabledSet = true;
}

public boolean isEnableManualInput(){
	if (this._enableManualInputSet) {
	    return (this._enableManualInput);
	}
	ValueExpression ve = getValueExpression("enableManualInput");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._enableManualInput);
	    }
	    
	    return value;
	} else {
	    return (this._enableManualInput);
	}

}

public void setEnableManualInput(boolean _enableManualInput){
this._enableManualInput = _enableManualInput;
this._enableManualInputSet = true;
}

public String getInputClass(){
	if (this._inputClass != null) {
		return this._inputClass;
	}
	ValueExpression ve = getValueExpression("inputClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setInputClass(String _inputClass){
this._inputClass = _inputClass;
}

public int getInputSize(){
	if (this._inputSizeSet) {
	    return (this._inputSize);
	}
	ValueExpression ve = getValueExpression("inputSize");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._inputSize);
	    }
	    
	    return value;
	} else {
	    return (this._inputSize);
	}

}

public void setInputSize(int _inputSize){
this._inputSize = _inputSize;
this._inputSizeSet = true;
}

public String getInputStyle(){
	if (this._inputStyle != null) {
		return this._inputStyle;
	}
	ValueExpression ve = getValueExpression("inputStyle");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setInputStyle(String _inputStyle){
this._inputStyle = _inputStyle;
}

public String getLabel(){
	if (this._label != null) {
		return this._label;
	}
	ValueExpression ve = getValueExpression("label");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setLabel(String _label){
this._label = _label;
}

public String getMaxValue(){
	if (this._maxValue != null) {
		return this._maxValue;
	}
	ValueExpression ve = getValueExpression("maxValue");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "100";
	

}

public void setMaxValue(String _maxValue){
this._maxValue = _maxValue;
}

public int getMaxlength(){
	if (this._maxlengthSet) {
	    return (this._maxlength);
	}
	ValueExpression ve = getValueExpression("maxlength");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._maxlength);
	    }
	    
	    return value;
	} else {
	    return (this._maxlength);
	}

}

public void setMaxlength(int _maxlength){
this._maxlength = _maxlength;
this._maxlengthSet = true;
}

public String getMinValue(){
	if (this._minValue != null) {
		return this._minValue;
	}
	ValueExpression ve = getValueExpression("minValue");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "0";
	

}

public void setMinValue(String _minValue){
this._minValue = _minValue;
}

public String getOnblur(){
	if (this._onblur != null) {
		return this._onblur;
	}
	ValueExpression ve = getValueExpression("onblur");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnblur(String _onblur){
this._onblur = _onblur;
}

public String getOnchange(){
	if (this._onchange != null) {
		return this._onchange;
	}
	ValueExpression ve = getValueExpression("onchange");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnchange(String _onchange){
this._onchange = _onchange;
}

public String getOnclick(){
	if (this._onclick != null) {
		return this._onclick;
	}
	ValueExpression ve = getValueExpression("onclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnclick(String _onclick){
this._onclick = _onclick;
}

public String getOndblclick(){
	if (this._ondblclick != null) {
		return this._ondblclick;
	}
	ValueExpression ve = getValueExpression("ondblclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOndblclick(String _ondblclick){
this._ondblclick = _ondblclick;
}

public String getOndownclick(){
	if (this._ondownclick != null) {
		return this._ondownclick;
	}
	ValueExpression ve = getValueExpression("ondownclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOndownclick(String _ondownclick){
this._ondownclick = _ondownclick;
}

public String getOnerror(){
	if (this._onerror != null) {
		return this._onerror;
	}
	ValueExpression ve = getValueExpression("onerror");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnerror(String _onerror){
this._onerror = _onerror;
}

public String getOnfocus(){
	if (this._onfocus != null) {
		return this._onfocus;
	}
	ValueExpression ve = getValueExpression("onfocus");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnfocus(String _onfocus){
this._onfocus = _onfocus;
}

public String getOninputclick(){
	if (this._oninputclick != null) {
		return this._oninputclick;
	}
	ValueExpression ve = getValueExpression("oninputclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOninputclick(String _oninputclick){
this._oninputclick = _oninputclick;
}

public String getOninputdblclick(){
	if (this._oninputdblclick != null) {
		return this._oninputdblclick;
	}
	ValueExpression ve = getValueExpression("oninputdblclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOninputdblclick(String _oninputdblclick){
this._oninputdblclick = _oninputdblclick;
}

public String getOninputkeydown(){
	if (this._oninputkeydown != null) {
		return this._oninputkeydown;
	}
	ValueExpression ve = getValueExpression("oninputkeydown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOninputkeydown(String _oninputkeydown){
this._oninputkeydown = _oninputkeydown;
}

public String getOninputkeypress(){
	if (this._oninputkeypress != null) {
		return this._oninputkeypress;
	}
	ValueExpression ve = getValueExpression("oninputkeypress");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOninputkeypress(String _oninputkeypress){
this._oninputkeypress = _oninputkeypress;
}

public String getOninputkeyup(){
	if (this._oninputkeyup != null) {
		return this._oninputkeyup;
	}
	ValueExpression ve = getValueExpression("oninputkeyup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOninputkeyup(String _oninputkeyup){
this._oninputkeyup = _oninputkeyup;
}

public String getOninputmousedown(){
	if (this._oninputmousedown != null) {
		return this._oninputmousedown;
	}
	ValueExpression ve = getValueExpression("oninputmousedown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOninputmousedown(String _oninputmousedown){
this._oninputmousedown = _oninputmousedown;
}

public String getOninputmousemove(){
	if (this._oninputmousemove != null) {
		return this._oninputmousemove;
	}
	ValueExpression ve = getValueExpression("oninputmousemove");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOninputmousemove(String _oninputmousemove){
this._oninputmousemove = _oninputmousemove;
}

public String getOninputmouseout(){
	if (this._oninputmouseout != null) {
		return this._oninputmouseout;
	}
	ValueExpression ve = getValueExpression("oninputmouseout");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOninputmouseout(String _oninputmouseout){
this._oninputmouseout = _oninputmouseout;
}

public String getOninputmouseover(){
	if (this._oninputmouseover != null) {
		return this._oninputmouseover;
	}
	ValueExpression ve = getValueExpression("oninputmouseover");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOninputmouseover(String _oninputmouseover){
this._oninputmouseover = _oninputmouseover;
}

public String getOninputmouseup(){
	if (this._oninputmouseup != null) {
		return this._oninputmouseup;
	}
	ValueExpression ve = getValueExpression("oninputmouseup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOninputmouseup(String _oninputmouseup){
this._oninputmouseup = _oninputmouseup;
}

public String getOnkeydown(){
	if (this._onkeydown != null) {
		return this._onkeydown;
	}
	ValueExpression ve = getValueExpression("onkeydown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeydown(String _onkeydown){
this._onkeydown = _onkeydown;
}

public String getOnkeypress(){
	if (this._onkeypress != null) {
		return this._onkeypress;
	}
	ValueExpression ve = getValueExpression("onkeypress");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeypress(String _onkeypress){
this._onkeypress = _onkeypress;
}

public String getOnkeyup(){
	if (this._onkeyup != null) {
		return this._onkeyup;
	}
	ValueExpression ve = getValueExpression("onkeyup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeyup(String _onkeyup){
this._onkeyup = _onkeyup;
}

public String getOnmousedown(){
	if (this._onmousedown != null) {
		return this._onmousedown;
	}
	ValueExpression ve = getValueExpression("onmousedown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmousedown(String _onmousedown){
this._onmousedown = _onmousedown;
}

public String getOnmousemove(){
	if (this._onmousemove != null) {
		return this._onmousemove;
	}
	ValueExpression ve = getValueExpression("onmousemove");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmousemove(String _onmousemove){
this._onmousemove = _onmousemove;
}

public String getOnmouseout(){
	if (this._onmouseout != null) {
		return this._onmouseout;
	}
	ValueExpression ve = getValueExpression("onmouseout");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseout(String _onmouseout){
this._onmouseout = _onmouseout;
}

public String getOnmouseover(){
	if (this._onmouseover != null) {
		return this._onmouseover;
	}
	ValueExpression ve = getValueExpression("onmouseover");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseover(String _onmouseover){
this._onmouseover = _onmouseover;
}

public String getOnmouseup(){
	if (this._onmouseup != null) {
		return this._onmouseup;
	}
	ValueExpression ve = getValueExpression("onmouseup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseup(String _onmouseup){
this._onmouseup = _onmouseup;
}

public String getOnselect(){
	if (this._onselect != null) {
		return this._onselect;
	}
	ValueExpression ve = getValueExpression("onselect");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnselect(String _onselect){
this._onselect = _onselect;
}

public String getOnupclick(){
	if (this._onupclick != null) {
		return this._onupclick;
	}
	ValueExpression ve = getValueExpression("onupclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnupclick(String _onupclick){
this._onupclick = _onupclick;
}

public int getSize(){
	if (this._sizeSet) {
	    return (this._size);
	}
	ValueExpression ve = getValueExpression("size");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._size);
	    }
	    
	    return value;
	} else {
	    return (this._size);
	}

}

public void setSize(int _size){
this._size = _size;
this._sizeSet = true;
}

public String getStep(){
	if (this._step != null) {
		return this._step;
	}
	ValueExpression ve = getValueExpression("step");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "1";
	

}

public void setStep(String _step){
this._step = _step;
}

public String getStyle(){
	if (this._style != null) {
		return this._style;
	}
	ValueExpression ve = getValueExpression("style");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyle(String _style){
this._style = _style;
}

public String getStyleClass(){
	if (this._styleClass != null) {
		return this._styleClass;
	}
	ValueExpression ve = getValueExpression("styleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyleClass(String _styleClass){
this._styleClass = _styleClass;
}

public String getTabindex(){
	if (this._tabindex != null) {
		return this._tabindex;
	}
	ValueExpression ve = getValueExpression("tabindex");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setTabindex(String _tabindex){
this._tabindex = _tabindex;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[54];
state[0] = super.saveState(context);
state[1] = _accesskey;
state[2] = _alt;
state[3] = _clientErrorMessage;
state[4] = Boolean.valueOf(_cycled);
state[5] = Boolean.valueOf(_cycledSet);
state[6] = Boolean.valueOf(_disableBrowserAutoComplete);
state[7] = Boolean.valueOf(_disableBrowserAutoCompleteSet);
state[8] = Boolean.valueOf(_disabled);
state[9] = Boolean.valueOf(_disabledSet);
state[10] = Boolean.valueOf(_enableManualInput);
state[11] = Boolean.valueOf(_enableManualInputSet);
state[12] = _inputClass;
state[13] = Integer.valueOf(_inputSize);
state[14] = Boolean.valueOf(_inputSizeSet);
state[15] = _inputStyle;
state[16] = _label;
state[17] = _maxValue;
state[18] = Integer.valueOf(_maxlength);
state[19] = Boolean.valueOf(_maxlengthSet);
state[20] = _minValue;
state[21] = _onblur;
state[22] = _onchange;
state[23] = _onclick;
state[24] = _ondblclick;
state[25] = _ondownclick;
state[26] = _onerror;
state[27] = _onfocus;
state[28] = _oninputclick;
state[29] = _oninputdblclick;
state[30] = _oninputkeydown;
state[31] = _oninputkeypress;
state[32] = _oninputkeyup;
state[33] = _oninputmousedown;
state[34] = _oninputmousemove;
state[35] = _oninputmouseout;
state[36] = _oninputmouseover;
state[37] = _oninputmouseup;
state[38] = _onkeydown;
state[39] = _onkeypress;
state[40] = _onkeyup;
state[41] = _onmousedown;
state[42] = _onmousemove;
state[43] = _onmouseout;
state[44] = _onmouseover;
state[45] = _onmouseup;
state[46] = _onselect;
state[47] = _onupclick;
state[48] = Integer.valueOf(_size);
state[49] = Boolean.valueOf(_sizeSet);
state[50] = _step;
state[51] = _style;
state[52] = _styleClass;
state[53] = _tabindex;
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_accesskey = (String)states[1];;
		_alt = (String)states[2];;
		_clientErrorMessage = (String)states[3];;
		_cycled = ((Boolean)states[4]).booleanValue();
		_cycledSet = ((Boolean)states[5]).booleanValue();
		_disableBrowserAutoComplete = ((Boolean)states[6]).booleanValue();
		_disableBrowserAutoCompleteSet = ((Boolean)states[7]).booleanValue();
		_disabled = ((Boolean)states[8]).booleanValue();
		_disabledSet = ((Boolean)states[9]).booleanValue();
		_enableManualInput = ((Boolean)states[10]).booleanValue();
		_enableManualInputSet = ((Boolean)states[11]).booleanValue();
		_inputClass = (String)states[12];;
		_inputSize = ((Integer)states[13]).intValue();
		_inputSizeSet = ((Boolean)states[14]).booleanValue();
		_inputStyle = (String)states[15];;
		_label = (String)states[16];;
		_maxValue = (String)states[17];;
		_maxlength = ((Integer)states[18]).intValue();
		_maxlengthSet = ((Boolean)states[19]).booleanValue();
		_minValue = (String)states[20];;
		_onblur = (String)states[21];;
		_onchange = (String)states[22];;
		_onclick = (String)states[23];;
		_ondblclick = (String)states[24];;
		_ondownclick = (String)states[25];;
		_onerror = (String)states[26];;
		_onfocus = (String)states[27];;
		_oninputclick = (String)states[28];;
		_oninputdblclick = (String)states[29];;
		_oninputkeydown = (String)states[30];;
		_oninputkeypress = (String)states[31];;
		_oninputkeyup = (String)states[32];;
		_oninputmousedown = (String)states[33];;
		_oninputmousemove = (String)states[34];;
		_oninputmouseout = (String)states[35];;
		_oninputmouseover = (String)states[36];;
		_oninputmouseup = (String)states[37];;
		_onkeydown = (String)states[38];;
		_onkeypress = (String)states[39];;
		_onkeyup = (String)states[40];;
		_onmousedown = (String)states[41];;
		_onmousemove = (String)states[42];;
		_onmouseout = (String)states[43];;
		_onmouseover = (String)states[44];;
		_onmouseup = (String)states[45];;
		_onselect = (String)states[46];;
		_onupclick = (String)states[47];;
		_size = ((Integer)states[48]).intValue();
		_sizeSet = ((Boolean)states[49]).booleanValue();
		_step = (String)states[50];;
		_style = (String)states[51];;
		_styleClass = (String)states[52];;
		_tabindex = (String)states[53];;
	
}

}
