package org.richfaces.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import org.richfaces.component.UIFileUpload;

public class HtmlFileUpload extends UIFileUpload{

public final static  String COMPONENT_FAMILY = "org.richfaces.component.FileUpload";

public final static  String COMPONENT_TYPE = "org.richfaces.component.FileUpload";

/*
* Files types allowed to upload
*/
private  String _acceptedTypes = null;

/*
* null
*/
private  Object _accessKey = null;

/*
* This attribute assigns an access key to an element. An access key is a single character from the document character set. Note: Authors should consider the input method of the expected reader when specifying an accesskey
*/
private  String _accesskey = null;

/*
* CSS style for add button
*/
private  String _addButtonClass = null;

/*
* CSS style for add button disabled
*/
private  String _addButtonClassDisabled = null;

/*
* Defines a label for an add button
*/
private  String _addControlLabel = null;

/*
* Boolean attribute which provides possibility to limit JSF tree processing(decoding, conversion/validation, value applying) to the component which send the request only.
				Default value is "false"
*/
private  boolean _ajaxSingle = false;

private  boolean _ajaxSingleSet = false;

/*
* null
*/
private  Object _align = null;

/*
* Attribute which allow the component to use the flash module that provides file upload functionality [false, true, auto]. Default value is "false"
*/
private  String _allowFlash = null;

/*
* For a user agents that cannot display images, forms, or applets, this attribute specifies alternate text. The language of the alternate text is specified by the lang attribute
*/
private  String _alt = null;

/*
* If this attribute is "true" files will be immediately removed from list after upload completed.
				Default value is "false".
*/
private  boolean _autoclear = false;

private  boolean _autoclearSet = false;

/*
* Defines a label for a cancel control
*/
private  String _cancelEntryControlLabel = null;

/*
* CSS style for clean button
*/
private  String _cleanButtonClass = null;

/*
* CSS style for clean button disabled
*/
private  String _cleanButtonClassDisabled = null;

/*
* Defines a label for a clearAll button
*/
private  String _clearAllControlLabel = null;

/*
* Defines a label for a clear control
*/
private  String _clearControlLabel = null;

/*
* null
*/
private  Object _contentType = null;

/*
* Attribute 'disabled' provides a possibility to make the whole component disabled if its value equals to "true".
				Default value is "false".
*/
private  boolean _disabled = false;

private  boolean _disabledSet = false;

/*
* Defines a label for a done label
*/
private  String _doneLabel = null;

/*
* CSS style upload file entry
*/
private  String _fileEntryClass = null;

/*
* CSS style upload file entry disabled
*/
private  String _fileEntryClassDisabled = null;

/*
* CSS style for upload enrty control
*/
private  String _fileEntryControlClass = null;

/*
* CSS style for upload enrty control disabled
*/
private  String _fileEntryControlClassDisabled = null;

/*
* null
*/
private  Object _fileName = null;

/*
* null
*/
private  Object _fileSize = null;

/*
* MethodExpression representing an action listener method
				that will be notified after file uploaded.
*/
private  MethodBinding _fileUploadListener = null;

/*
* If this attribute is true files will be immediately uploaded after they have been added in list.
				Default value is "false".
*/
private  boolean _immediateUpload = false;

private  boolean _immediateUploadSet = false;

/*
* Defines height of file list. Default value is "210px".
*/
private  String _listHeight = null;

/*
* Defines width of file list. Default value is "400px".
*/
private  String _listWidth = null;

/*
* Used for locale definition
*/
private  Object _locale = null;

/*
* Defines max files count allowed for upload (optional). Default value is "1".
*/
private  Integer _maxFilesQuantity = null;

/*
* null
*/
private  Object _maxLength = null;

/*
* null
*/
private  Object _maxlength = null;

/*
* Defines if component should allow to add files that were already in list. Default value is "false".
*/
private  boolean _noDuplicate = false;

private  boolean _noDuplicateSet = false;

/*
* HTML: script expression; a file is added.
*/
private  String _onadd = null;

/*
* HTML: script expression; the element lost the focus
*/
private  String _onblur = null;

/*
* HTML: script expression; the element value was changed
*/
private  String _onchange = null;

/*
* HTML: script expression; the file entries are cleared
*/
private  String _onclear = null;

/*
* HTML: a script expression; a pointer button is clicked
*/
private  String _onclick = null;

/*
* HTML: a script expression; a pointer button is double-clicked
*/
private  String _ondblclick = null;

/*
* HTML: script expression; the file uploading is interrupted according to any errors
*/
private  String _onerror = null;

/*
* HTML: script expression; a file is uploaded to the server
*/
private  String _onfileuploadcomplete = null;

/*
* HTML: script expression; the element got the focus
*/
private  String _onfocus = null;

/*
* HTML: a script expression; a key is pressed down
*/
private  String _onkeydown = null;

/*
* HTML: a script expression; a key is pressed and released
*/
private  String _onkeypress = null;

/*
* HTML: a script expression; a key is released
*/
private  String _onkeyup = null;

/*
* HTML: script expression; a pointer button is pressed down
*/
private  String _onmousedown = null;

/*
* HTML: a script expression; a pointer is moved within
*/
private  String _onmousemove = null;

/*
* HTML: a script expression; a pointer is moved away
*/
private  String _onmouseout = null;

/*
* HTML: a script expression; a pointer is moved onto
*/
private  String _onmouseover = null;

/*
* HTML: script expression; a pointer button is released
*/
private  String _onmouseup = null;

/*
* HTML: script expression; some text is selected in a text field. This attribute may be used with the INPUT and TEXTAREA elements
*/
private  String _onselect = null;

/*
* HTML: script expression; the file uploading is rejected by fiel size overflow
*/
private  String _onsizerejected = null;

/*
* HTML: script expression; the file type is rejected according to file types allowed
*/
private  String _ontyperejected = null;

/*
* HTML: script expression; the uploading is cancelled at client side
*/
private  String _onupload = null;

/*
* HTML: script expression; uploading is cancelled
*/
private  String _onuploadcanceled = null;

/*
* HTML: script expression; uploading all files from list is completed
*/
private  String _onuploadcomplete = null;

/*
* null
*/
private  Object _progressInfo = null;

/*
* Defines a label for a progress label
*/
private  String _progressLabel = null;

/*
* null
*/
private  Object _size = null;

/*
* Defines a label for a size error label
*/
private  String _sizeErrorLabel = null;

/*
* ID (in format of call UIComponent.findComponent()) of Request status component
*/
private  String _status = null;

/*
* CSS style for cancel button
*/
private  String _stopButtonClass = null;

/*
* CSS style for cancel button disabled
*/
private  String _stopButtonClassDisabled = null;

/*
* Defines a label for a stop button
*/
private  String _stopControlLabel = null;

/*
* Defines a label for a stop control
*/
private  String _stopEntryControlLabel = null;

/*
* CSS style(s) is/are to be applied when this component is rendered
*/
private  String _style = null;

/*
* Corresponds to the HTML class attribute
*/
private  String _styleClass = null;

/*
* This attribute specifies the position of the current element in the tabbing order for the current document. This value must be a number between 0 and 32767. User agents should ignore leading zeros
*/
private  String _tabindex = null;

/*
* Defines a label for a transfer error label
*/
private  String _transferErrorLabel = null;

/*
* CSS style for upload button
*/
private  String _uploadButtonClass = null;

/*
* CSS style for upload button disabled
*/
private  String _uploadButtonClassDisabled = null;

/*
* Defines a label for an upload button
*/
private  String _uploadControlLabel = null;

/*
* Collection of files uploaded
*/
private  Object _uploadData = null;

/*
* CSS style for upload list
*/
private  String _uploadListClass = null;

/*
* CSS style for upload list disabled
*/
private  String _uploadListClassDisabled = null;


public HtmlFileUpload(){
setRendererType("org.richfaces.renderkit.html.FileUploadRenderer");
}

public String getAcceptedTypes(){
	if (this._acceptedTypes != null) {
		return this._acceptedTypes;
	}
	ValueExpression ve = getValueExpression("acceptedTypes");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setAcceptedTypes(String _acceptedTypes){
this._acceptedTypes = _acceptedTypes;
}

public Object getAccessKey(){
	if (this._accessKey != null) {
		return this._accessKey;
	}
	ValueExpression ve = getValueExpression("accessKey");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setAccessKey(Object _accessKey){
this._accessKey = _accessKey;
}

public String getAccesskey(){
	if (this._accesskey != null) {
		return this._accesskey;
	}
	ValueExpression ve = getValueExpression("accesskey");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setAccesskey(String _accesskey){
this._accesskey = _accesskey;
}

public String getAddButtonClass(){
	if (this._addButtonClass != null) {
		return this._addButtonClass;
	}
	ValueExpression ve = getValueExpression("addButtonClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setAddButtonClass(String _addButtonClass){
this._addButtonClass = _addButtonClass;
}

public String getAddButtonClassDisabled(){
	if (this._addButtonClassDisabled != null) {
		return this._addButtonClassDisabled;
	}
	ValueExpression ve = getValueExpression("addButtonClassDisabled");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setAddButtonClassDisabled(String _addButtonClassDisabled){
this._addButtonClassDisabled = _addButtonClassDisabled;
}

public String getAddControlLabel(){
	if (this._addControlLabel != null) {
		return this._addControlLabel;
	}
	ValueExpression ve = getValueExpression("addControlLabel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setAddControlLabel(String _addControlLabel){
this._addControlLabel = _addControlLabel;
}

public boolean isAjaxSingle(){
	if (this._ajaxSingleSet) {
	    return (this._ajaxSingle);
	}
	ValueExpression ve = getValueExpression("ajaxSingle");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._ajaxSingle);
	    }
	    
	    return value;
	} else {
	    return (this._ajaxSingle);
	}

}

public void setAjaxSingle(boolean _ajaxSingle){
this._ajaxSingle = _ajaxSingle;
this._ajaxSingleSet = true;
}

public Object getAlign(){
	if (this._align != null) {
		return this._align;
	}
	ValueExpression ve = getValueExpression("align");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setAlign(Object _align){
this._align = _align;
}

public String getAllowFlash(){
	if (this._allowFlash != null) {
		return this._allowFlash;
	}
	ValueExpression ve = getValueExpression("allowFlash");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "false";
	

}

public void setAllowFlash(String _allowFlash){
this._allowFlash = _allowFlash;
}

public String getAlt(){
	if (this._alt != null) {
		return this._alt;
	}
	ValueExpression ve = getValueExpression("alt");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setAlt(String _alt){
this._alt = _alt;
}

public boolean isAutoclear(){
	if (this._autoclearSet) {
	    return (this._autoclear);
	}
	ValueExpression ve = getValueExpression("autoclear");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._autoclear);
	    }
	    
	    return value;
	} else {
	    return (this._autoclear);
	}

}

public void setAutoclear(boolean _autoclear){
this._autoclear = _autoclear;
this._autoclearSet = true;
}

public String getCancelEntryControlLabel(){
	if (this._cancelEntryControlLabel != null) {
		return this._cancelEntryControlLabel;
	}
	ValueExpression ve = getValueExpression("cancelEntryControlLabel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setCancelEntryControlLabel(String _cancelEntryControlLabel){
this._cancelEntryControlLabel = _cancelEntryControlLabel;
}

public String getCleanButtonClass(){
	if (this._cleanButtonClass != null) {
		return this._cleanButtonClass;
	}
	ValueExpression ve = getValueExpression("cleanButtonClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setCleanButtonClass(String _cleanButtonClass){
this._cleanButtonClass = _cleanButtonClass;
}

public String getCleanButtonClassDisabled(){
	if (this._cleanButtonClassDisabled != null) {
		return this._cleanButtonClassDisabled;
	}
	ValueExpression ve = getValueExpression("cleanButtonClassDisabled");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setCleanButtonClassDisabled(String _cleanButtonClassDisabled){
this._cleanButtonClassDisabled = _cleanButtonClassDisabled;
}

public String getClearAllControlLabel(){
	if (this._clearAllControlLabel != null) {
		return this._clearAllControlLabel;
	}
	ValueExpression ve = getValueExpression("clearAllControlLabel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setClearAllControlLabel(String _clearAllControlLabel){
this._clearAllControlLabel = _clearAllControlLabel;
}

public String getClearControlLabel(){
	if (this._clearControlLabel != null) {
		return this._clearControlLabel;
	}
	ValueExpression ve = getValueExpression("clearControlLabel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setClearControlLabel(String _clearControlLabel){
this._clearControlLabel = _clearControlLabel;
}

public Object getContentType(){
	if (this._contentType != null) {
		return this._contentType;
	}
	ValueExpression ve = getValueExpression("contentType");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setContentType(Object _contentType){
this._contentType = _contentType;
}

public boolean isDisabled(){
	if (this._disabledSet) {
	    return (this._disabled);
	}
	ValueExpression ve = getValueExpression("disabled");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._disabled);
	    }
	    
	    return value;
	} else {
	    return (this._disabled);
	}

}

public void setDisabled(boolean _disabled){
this._disabled = _disabled;
this._disabledSet = true;
}

public String getDoneLabel(){
	if (this._doneLabel != null) {
		return this._doneLabel;
	}
	ValueExpression ve = getValueExpression("doneLabel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setDoneLabel(String _doneLabel){
this._doneLabel = _doneLabel;
}

public String getFileEntryClass(){
	if (this._fileEntryClass != null) {
		return this._fileEntryClass;
	}
	ValueExpression ve = getValueExpression("fileEntryClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setFileEntryClass(String _fileEntryClass){
this._fileEntryClass = _fileEntryClass;
}

public String getFileEntryClassDisabled(){
	if (this._fileEntryClassDisabled != null) {
		return this._fileEntryClassDisabled;
	}
	ValueExpression ve = getValueExpression("fileEntryClassDisabled");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setFileEntryClassDisabled(String _fileEntryClassDisabled){
this._fileEntryClassDisabled = _fileEntryClassDisabled;
}

public String getFileEntryControlClass(){
	if (this._fileEntryControlClass != null) {
		return this._fileEntryControlClass;
	}
	ValueExpression ve = getValueExpression("fileEntryControlClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setFileEntryControlClass(String _fileEntryControlClass){
this._fileEntryControlClass = _fileEntryControlClass;
}

public String getFileEntryControlClassDisabled(){
	if (this._fileEntryControlClassDisabled != null) {
		return this._fileEntryControlClassDisabled;
	}
	ValueExpression ve = getValueExpression("fileEntryControlClassDisabled");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setFileEntryControlClassDisabled(String _fileEntryControlClassDisabled){
this._fileEntryControlClassDisabled = _fileEntryControlClassDisabled;
}

public Object getFileName(){
	if (this._fileName != null) {
		return this._fileName;
	}
	ValueExpression ve = getValueExpression("fileName");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setFileName(Object _fileName){
this._fileName = _fileName;
}

public Object getFileSize(){
	if (this._fileSize != null) {
		return this._fileSize;
	}
	ValueExpression ve = getValueExpression("fileSize");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setFileSize(Object _fileSize){
this._fileSize = _fileSize;
}

public MethodBinding getFileUploadListener(){
return _fileUploadListener;
}

public void setFileUploadListener(MethodBinding _fileUploadListener){
this._fileUploadListener = _fileUploadListener;
}

public boolean isImmediateUpload(){
	if (this._immediateUploadSet) {
	    return (this._immediateUpload);
	}
	ValueExpression ve = getValueExpression("immediateUpload");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._immediateUpload);
	    }
	    
	    return value;
	} else {
	    return (this._immediateUpload);
	}

}

public void setImmediateUpload(boolean _immediateUpload){
this._immediateUpload = _immediateUpload;
this._immediateUploadSet = true;
}

public String getListHeight(){
	if (this._listHeight != null) {
		return this._listHeight;
	}
	ValueExpression ve = getValueExpression("listHeight");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "210px";
	

}

public void setListHeight(String _listHeight){
this._listHeight = _listHeight;
}

public String getListWidth(){
	if (this._listWidth != null) {
		return this._listWidth;
	}
	ValueExpression ve = getValueExpression("listWidth");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "400px";
	

}

public void setListWidth(String _listWidth){
this._listWidth = _listWidth;
}

public Object getLocale(){
	if (this._locale != null) {
		return this._locale;
	}
	ValueExpression ve = getValueExpression("locale");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setLocale(Object _locale){
this._locale = _locale;
}

public Integer getMaxFilesQuantity(){
	if (this._maxFilesQuantity != null) {
		return this._maxFilesQuantity;
	}
	ValueExpression ve = getValueExpression("maxFilesQuantity");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return 1;
	

}

public void setMaxFilesQuantity(Integer _maxFilesQuantity){
this._maxFilesQuantity = _maxFilesQuantity;
}

public Object getMaxLength(){
	if (this._maxLength != null) {
		return this._maxLength;
	}
	ValueExpression ve = getValueExpression("maxLength");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setMaxLength(Object _maxLength){
this._maxLength = _maxLength;
}

public Object getMaxlength(){
	if (this._maxlength != null) {
		return this._maxlength;
	}
	ValueExpression ve = getValueExpression("maxlength");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setMaxlength(Object _maxlength){
this._maxlength = _maxlength;
}

public boolean isNoDuplicate(){
	if (this._noDuplicateSet) {
	    return (this._noDuplicate);
	}
	ValueExpression ve = getValueExpression("noDuplicate");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._noDuplicate);
	    }
	    
	    return value;
	} else {
	    return (this._noDuplicate);
	}

}

public void setNoDuplicate(boolean _noDuplicate){
this._noDuplicate = _noDuplicate;
this._noDuplicateSet = true;
}

public String getOnadd(){
	if (this._onadd != null) {
		return this._onadd;
	}
	ValueExpression ve = getValueExpression("onadd");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnadd(String _onadd){
this._onadd = _onadd;
}

public String getOnblur(){
	if (this._onblur != null) {
		return this._onblur;
	}
	ValueExpression ve = getValueExpression("onblur");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnblur(String _onblur){
this._onblur = _onblur;
}

public String getOnchange(){
	if (this._onchange != null) {
		return this._onchange;
	}
	ValueExpression ve = getValueExpression("onchange");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnchange(String _onchange){
this._onchange = _onchange;
}

public String getOnclear(){
	if (this._onclear != null) {
		return this._onclear;
	}
	ValueExpression ve = getValueExpression("onclear");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnclear(String _onclear){
this._onclear = _onclear;
}

public String getOnclick(){
	if (this._onclick != null) {
		return this._onclick;
	}
	ValueExpression ve = getValueExpression("onclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnclick(String _onclick){
this._onclick = _onclick;
}

public String getOndblclick(){
	if (this._ondblclick != null) {
		return this._ondblclick;
	}
	ValueExpression ve = getValueExpression("ondblclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOndblclick(String _ondblclick){
this._ondblclick = _ondblclick;
}

public String getOnerror(){
	if (this._onerror != null) {
		return this._onerror;
	}
	ValueExpression ve = getValueExpression("onerror");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnerror(String _onerror){
this._onerror = _onerror;
}

public String getOnfileuploadcomplete(){
	if (this._onfileuploadcomplete != null) {
		return this._onfileuploadcomplete;
	}
	ValueExpression ve = getValueExpression("onfileuploadcomplete");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnfileuploadcomplete(String _onfileuploadcomplete){
this._onfileuploadcomplete = _onfileuploadcomplete;
}

public String getOnfocus(){
	if (this._onfocus != null) {
		return this._onfocus;
	}
	ValueExpression ve = getValueExpression("onfocus");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnfocus(String _onfocus){
this._onfocus = _onfocus;
}

public String getOnkeydown(){
	if (this._onkeydown != null) {
		return this._onkeydown;
	}
	ValueExpression ve = getValueExpression("onkeydown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeydown(String _onkeydown){
this._onkeydown = _onkeydown;
}

public String getOnkeypress(){
	if (this._onkeypress != null) {
		return this._onkeypress;
	}
	ValueExpression ve = getValueExpression("onkeypress");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeypress(String _onkeypress){
this._onkeypress = _onkeypress;
}

public String getOnkeyup(){
	if (this._onkeyup != null) {
		return this._onkeyup;
	}
	ValueExpression ve = getValueExpression("onkeyup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeyup(String _onkeyup){
this._onkeyup = _onkeyup;
}

public String getOnmousedown(){
	if (this._onmousedown != null) {
		return this._onmousedown;
	}
	ValueExpression ve = getValueExpression("onmousedown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmousedown(String _onmousedown){
this._onmousedown = _onmousedown;
}

public String getOnmousemove(){
	if (this._onmousemove != null) {
		return this._onmousemove;
	}
	ValueExpression ve = getValueExpression("onmousemove");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmousemove(String _onmousemove){
this._onmousemove = _onmousemove;
}

public String getOnmouseout(){
	if (this._onmouseout != null) {
		return this._onmouseout;
	}
	ValueExpression ve = getValueExpression("onmouseout");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseout(String _onmouseout){
this._onmouseout = _onmouseout;
}

public String getOnmouseover(){
	if (this._onmouseover != null) {
		return this._onmouseover;
	}
	ValueExpression ve = getValueExpression("onmouseover");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseover(String _onmouseover){
this._onmouseover = _onmouseover;
}

public String getOnmouseup(){
	if (this._onmouseup != null) {
		return this._onmouseup;
	}
	ValueExpression ve = getValueExpression("onmouseup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseup(String _onmouseup){
this._onmouseup = _onmouseup;
}

public String getOnselect(){
	if (this._onselect != null) {
		return this._onselect;
	}
	ValueExpression ve = getValueExpression("onselect");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnselect(String _onselect){
this._onselect = _onselect;
}

public String getOnsizerejected(){
	if (this._onsizerejected != null) {
		return this._onsizerejected;
	}
	ValueExpression ve = getValueExpression("onsizerejected");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnsizerejected(String _onsizerejected){
this._onsizerejected = _onsizerejected;
}

public String getOntyperejected(){
	if (this._ontyperejected != null) {
		return this._ontyperejected;
	}
	ValueExpression ve = getValueExpression("ontyperejected");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOntyperejected(String _ontyperejected){
this._ontyperejected = _ontyperejected;
}

public String getOnupload(){
	if (this._onupload != null) {
		return this._onupload;
	}
	ValueExpression ve = getValueExpression("onupload");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnupload(String _onupload){
this._onupload = _onupload;
}

public String getOnuploadcanceled(){
	if (this._onuploadcanceled != null) {
		return this._onuploadcanceled;
	}
	ValueExpression ve = getValueExpression("onuploadcanceled");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnuploadcanceled(String _onuploadcanceled){
this._onuploadcanceled = _onuploadcanceled;
}

public String getOnuploadcomplete(){
	if (this._onuploadcomplete != null) {
		return this._onuploadcomplete;
	}
	ValueExpression ve = getValueExpression("onuploadcomplete");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnuploadcomplete(String _onuploadcomplete){
this._onuploadcomplete = _onuploadcomplete;
}

public Object getProgressInfo(){
	if (this._progressInfo != null) {
		return this._progressInfo;
	}
	ValueExpression ve = getValueExpression("progressInfo");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setProgressInfo(Object _progressInfo){
this._progressInfo = _progressInfo;
}

public String getProgressLabel(){
	if (this._progressLabel != null) {
		return this._progressLabel;
	}
	ValueExpression ve = getValueExpression("progressLabel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setProgressLabel(String _progressLabel){
this._progressLabel = _progressLabel;
}

public Object getSize(){
	if (this._size != null) {
		return this._size;
	}
	ValueExpression ve = getValueExpression("size");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setSize(Object _size){
this._size = _size;
}

public String getSizeErrorLabel(){
	if (this._sizeErrorLabel != null) {
		return this._sizeErrorLabel;
	}
	ValueExpression ve = getValueExpression("sizeErrorLabel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setSizeErrorLabel(String _sizeErrorLabel){
this._sizeErrorLabel = _sizeErrorLabel;
}

public String getStatus(){
	if (this._status != null) {
		return this._status;
	}
	ValueExpression ve = getValueExpression("status");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStatus(String _status){
this._status = _status;
}

public String getStopButtonClass(){
	if (this._stopButtonClass != null) {
		return this._stopButtonClass;
	}
	ValueExpression ve = getValueExpression("stopButtonClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStopButtonClass(String _stopButtonClass){
this._stopButtonClass = _stopButtonClass;
}

public String getStopButtonClassDisabled(){
	if (this._stopButtonClassDisabled != null) {
		return this._stopButtonClassDisabled;
	}
	ValueExpression ve = getValueExpression("stopButtonClassDisabled");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStopButtonClassDisabled(String _stopButtonClassDisabled){
this._stopButtonClassDisabled = _stopButtonClassDisabled;
}

public String getStopControlLabel(){
	if (this._stopControlLabel != null) {
		return this._stopControlLabel;
	}
	ValueExpression ve = getValueExpression("stopControlLabel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStopControlLabel(String _stopControlLabel){
this._stopControlLabel = _stopControlLabel;
}

public String getStopEntryControlLabel(){
	if (this._stopEntryControlLabel != null) {
		return this._stopEntryControlLabel;
	}
	ValueExpression ve = getValueExpression("stopEntryControlLabel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStopEntryControlLabel(String _stopEntryControlLabel){
this._stopEntryControlLabel = _stopEntryControlLabel;
}

public String getStyle(){
	if (this._style != null) {
		return this._style;
	}
	ValueExpression ve = getValueExpression("style");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyle(String _style){
this._style = _style;
}

public String getStyleClass(){
	if (this._styleClass != null) {
		return this._styleClass;
	}
	ValueExpression ve = getValueExpression("styleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyleClass(String _styleClass){
this._styleClass = _styleClass;
}

public String getTabindex(){
	if (this._tabindex != null) {
		return this._tabindex;
	}
	ValueExpression ve = getValueExpression("tabindex");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setTabindex(String _tabindex){
this._tabindex = _tabindex;
}

public String getTransferErrorLabel(){
	if (this._transferErrorLabel != null) {
		return this._transferErrorLabel;
	}
	ValueExpression ve = getValueExpression("transferErrorLabel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setTransferErrorLabel(String _transferErrorLabel){
this._transferErrorLabel = _transferErrorLabel;
}

public String getUploadButtonClass(){
	if (this._uploadButtonClass != null) {
		return this._uploadButtonClass;
	}
	ValueExpression ve = getValueExpression("uploadButtonClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setUploadButtonClass(String _uploadButtonClass){
this._uploadButtonClass = _uploadButtonClass;
}

public String getUploadButtonClassDisabled(){
	if (this._uploadButtonClassDisabled != null) {
		return this._uploadButtonClassDisabled;
	}
	ValueExpression ve = getValueExpression("uploadButtonClassDisabled");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setUploadButtonClassDisabled(String _uploadButtonClassDisabled){
this._uploadButtonClassDisabled = _uploadButtonClassDisabled;
}

public String getUploadControlLabel(){
	if (this._uploadControlLabel != null) {
		return this._uploadControlLabel;
	}
	ValueExpression ve = getValueExpression("uploadControlLabel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setUploadControlLabel(String _uploadControlLabel){
this._uploadControlLabel = _uploadControlLabel;
}

public Object getUploadData(){
	if (this._uploadData != null) {
		return this._uploadData;
	}
	ValueExpression ve = getValueExpression("uploadData");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setUploadData(Object _uploadData){
this._uploadData = _uploadData;
}

public String getUploadListClass(){
	if (this._uploadListClass != null) {
		return this._uploadListClass;
	}
	ValueExpression ve = getValueExpression("uploadListClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setUploadListClass(String _uploadListClass){
this._uploadListClass = _uploadListClass;
}

public String getUploadListClassDisabled(){
	if (this._uploadListClassDisabled != null) {
		return this._uploadListClassDisabled;
	}
	ValueExpression ve = getValueExpression("uploadListClassDisabled");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setUploadListClassDisabled(String _uploadListClassDisabled){
this._uploadListClassDisabled = _uploadListClassDisabled;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[82];
state[0] = super.saveState(context);
state[1] = _acceptedTypes;
state[2] = saveAttachedState(context, _accessKey);
state[3] = _accesskey;
state[4] = _addButtonClass;
state[5] = _addButtonClassDisabled;
state[6] = _addControlLabel;
state[7] = Boolean.valueOf(_ajaxSingle);
state[8] = Boolean.valueOf(_ajaxSingleSet);
state[9] = saveAttachedState(context, _align);
state[10] = _allowFlash;
state[11] = _alt;
state[12] = Boolean.valueOf(_autoclear);
state[13] = Boolean.valueOf(_autoclearSet);
state[14] = _cancelEntryControlLabel;
state[15] = _cleanButtonClass;
state[16] = _cleanButtonClassDisabled;
state[17] = _clearAllControlLabel;
state[18] = _clearControlLabel;
state[19] = saveAttachedState(context, _contentType);
state[20] = Boolean.valueOf(_disabled);
state[21] = Boolean.valueOf(_disabledSet);
state[22] = _doneLabel;
state[23] = _fileEntryClass;
state[24] = _fileEntryClassDisabled;
state[25] = _fileEntryControlClass;
state[26] = _fileEntryControlClassDisabled;
state[27] = saveAttachedState(context, _fileName);
state[28] = saveAttachedState(context, _fileSize);
state[29] = saveAttachedState(context, _fileUploadListener);
state[30] = Boolean.valueOf(_immediateUpload);
state[31] = Boolean.valueOf(_immediateUploadSet);
state[32] = _listHeight;
state[33] = _listWidth;
state[34] = saveAttachedState(context, _locale);
state[35] = _maxFilesQuantity;
state[36] = saveAttachedState(context, _maxLength);
state[37] = saveAttachedState(context, _maxlength);
state[38] = Boolean.valueOf(_noDuplicate);
state[39] = Boolean.valueOf(_noDuplicateSet);
state[40] = _onadd;
state[41] = _onblur;
state[42] = _onchange;
state[43] = _onclear;
state[44] = _onclick;
state[45] = _ondblclick;
state[46] = _onerror;
state[47] = _onfileuploadcomplete;
state[48] = _onfocus;
state[49] = _onkeydown;
state[50] = _onkeypress;
state[51] = _onkeyup;
state[52] = _onmousedown;
state[53] = _onmousemove;
state[54] = _onmouseout;
state[55] = _onmouseover;
state[56] = _onmouseup;
state[57] = _onselect;
state[58] = _onsizerejected;
state[59] = _ontyperejected;
state[60] = _onupload;
state[61] = _onuploadcanceled;
state[62] = _onuploadcomplete;
state[63] = saveAttachedState(context, _progressInfo);
state[64] = _progressLabel;
state[65] = saveAttachedState(context, _size);
state[66] = _sizeErrorLabel;
state[67] = _status;
state[68] = _stopButtonClass;
state[69] = _stopButtonClassDisabled;
state[70] = _stopControlLabel;
state[71] = _stopEntryControlLabel;
state[72] = _style;
state[73] = _styleClass;
state[74] = _tabindex;
state[75] = _transferErrorLabel;
state[76] = _uploadButtonClass;
state[77] = _uploadButtonClassDisabled;
state[78] = _uploadControlLabel;
state[79] = saveAttachedState(context, _uploadData);
state[80] = _uploadListClass;
state[81] = _uploadListClassDisabled;
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_acceptedTypes = (String)states[1];;
		_accessKey = (Object)restoreAttachedState(context, states[2]);
		_accesskey = (String)states[3];;
		_addButtonClass = (String)states[4];;
		_addButtonClassDisabled = (String)states[5];;
		_addControlLabel = (String)states[6];;
		_ajaxSingle = ((Boolean)states[7]).booleanValue();
		_ajaxSingleSet = ((Boolean)states[8]).booleanValue();
		_align = (Object)restoreAttachedState(context, states[9]);
		_allowFlash = (String)states[10];;
		_alt = (String)states[11];;
		_autoclear = ((Boolean)states[12]).booleanValue();
		_autoclearSet = ((Boolean)states[13]).booleanValue();
		_cancelEntryControlLabel = (String)states[14];;
		_cleanButtonClass = (String)states[15];;
		_cleanButtonClassDisabled = (String)states[16];;
		_clearAllControlLabel = (String)states[17];;
		_clearControlLabel = (String)states[18];;
		_contentType = (Object)restoreAttachedState(context, states[19]);
		_disabled = ((Boolean)states[20]).booleanValue();
		_disabledSet = ((Boolean)states[21]).booleanValue();
		_doneLabel = (String)states[22];;
		_fileEntryClass = (String)states[23];;
		_fileEntryClassDisabled = (String)states[24];;
		_fileEntryControlClass = (String)states[25];;
		_fileEntryControlClassDisabled = (String)states[26];;
		_fileName = (Object)restoreAttachedState(context, states[27]);
		_fileSize = (Object)restoreAttachedState(context, states[28]);
		_fileUploadListener = (MethodBinding)restoreAttachedState(context, states[29]);
		_immediateUpload = ((Boolean)states[30]).booleanValue();
		_immediateUploadSet = ((Boolean)states[31]).booleanValue();
		_listHeight = (String)states[32];;
		_listWidth = (String)states[33];;
		_locale = (Object)restoreAttachedState(context, states[34]);
		_maxFilesQuantity = (Integer)states[35];;
		_maxLength = (Object)restoreAttachedState(context, states[36]);
		_maxlength = (Object)restoreAttachedState(context, states[37]);
		_noDuplicate = ((Boolean)states[38]).booleanValue();
		_noDuplicateSet = ((Boolean)states[39]).booleanValue();
		_onadd = (String)states[40];;
		_onblur = (String)states[41];;
		_onchange = (String)states[42];;
		_onclear = (String)states[43];;
		_onclick = (String)states[44];;
		_ondblclick = (String)states[45];;
		_onerror = (String)states[46];;
		_onfileuploadcomplete = (String)states[47];;
		_onfocus = (String)states[48];;
		_onkeydown = (String)states[49];;
		_onkeypress = (String)states[50];;
		_onkeyup = (String)states[51];;
		_onmousedown = (String)states[52];;
		_onmousemove = (String)states[53];;
		_onmouseout = (String)states[54];;
		_onmouseover = (String)states[55];;
		_onmouseup = (String)states[56];;
		_onselect = (String)states[57];;
		_onsizerejected = (String)states[58];;
		_ontyperejected = (String)states[59];;
		_onupload = (String)states[60];;
		_onuploadcanceled = (String)states[61];;
		_onuploadcomplete = (String)states[62];;
		_progressInfo = (Object)restoreAttachedState(context, states[63]);
		_progressLabel = (String)states[64];;
		_size = (Object)restoreAttachedState(context, states[65]);
		_sizeErrorLabel = (String)states[66];;
		_status = (String)states[67];;
		_stopButtonClass = (String)states[68];;
		_stopButtonClassDisabled = (String)states[69];;
		_stopControlLabel = (String)states[70];;
		_stopEntryControlLabel = (String)states[71];;
		_style = (String)states[72];;
		_styleClass = (String)states[73];;
		_tabindex = (String)states[74];;
		_transferErrorLabel = (String)states[75];;
		_uploadButtonClass = (String)states[76];;
		_uploadButtonClassDisabled = (String)states[77];;
		_uploadControlLabel = (String)states[78];;
		_uploadData = (Object)restoreAttachedState(context, states[79]);
		_uploadListClass = (String)states[80];;
		_uploadListClassDisabled = (String)states[81];;
	
}

}
