/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import org.ajax4jsf.Messages;
import org.ajax4jsf.component.AjaxSupport;
import org.ajax4jsf.component.EventValueExpression;
import org.ajax4jsf.component.JavaScriptParameter;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSReference;
import org.ajax4jsf.javascript.ScriptUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.component.util.HtmlUtil;

public abstract class UIComponentControl
extends UIComponentBase
implements AjaxSupport {
    public static final String COMPONENT_TYPE = "org.richfaces.ComponentControl";
    public static final String COMPONENT_FAMILY = "org.richfaces.ComponentControl";
    private static final Log log = LogFactory.getLog(UIComponentControl.class);
    public static final String DISABLE_DEFAULT = "disableDefault";
    private boolean disableDefault = false;
    private boolean disableDefaultSet = false;
    public static final String ON_CONTEXT_MENU = "onContextMenu";

    public String getEventString() {
        String targetId = HtmlUtil.idsToIdSelector((String)this.getFor());
        targetId = HtmlUtil.expandIdSelector((String)targetId, (UIComponent)this, (FacesContext)FacesContext.getCurrentInstance());
        JSFunction invocation = new JSFunction("Richfaces.componentControl.performOperation", new Object[0]);
        invocation.addParameter((Object)new JSReference("event"));
        invocation.addParameter((Object)targetId);
        invocation.addParameter((Object)this.getOperation());
        invocation.addParameter((Object)new JSReference("{" + this.getEncodedParametersMap() + "}"));
        invocation.addParameter((Object)this.isDisableDefault());
        return invocation.toScript();
    }

    public String getEncodedParametersMap() {
        StringBuilder result = new StringBuilder();
        boolean shouldClose = false;
        String params = this.getParams();
        if (params != null && params.trim().length() != 0) {
            result.append(params);
            shouldClose = true;
        }
        for (UIComponent child : this.getChildren()) {
            if (!(child instanceof UIParameter)) continue;
            String name = ((UIParameter)child).getName();
            Object value = ((UIParameter)child).getValue();
            if (null == name) {
                FacesContext context = FacesContext.getCurrentInstance();
                throw new IllegalArgumentException(Messages.getMessage((String)"UNNAMED_PARAMETER_ERROR", (Object)this.getClientId(context)));
            }
            boolean escape = true;
            if (child instanceof JavaScriptParameter) {
                JavaScriptParameter actionParam = (JavaScriptParameter)child;
                boolean bl = escape = !actionParam.isNoEscape();
            }
            if (shouldClose) {
                result.append(", ");
            }
            ScriptUtils.addEncodedString((StringBuilder)result, (Object)name);
            result.append(": ");
            result.append(ScriptUtils.toScript((Object)(escape ? value : new JSReference(value.toString()))));
            shouldClose = true;
        }
        return result.toString();
    }

    public abstract String getEvent();

    public abstract void setEvent(String var1);

    public abstract String getFor();

    public abstract void setFor(String var1);

    public abstract String getParams();

    public abstract void setParams(String var1);

    public abstract String getOperation();

    public abstract void setOperation(String var1);

    public abstract String getAttachTo();

    public abstract void setAttachTo(String var1);

    protected String replaceClientIds(FacesContext context, UIComponent component, String selector) {
        return HtmlUtil.expandIdSelector((String)selector, (UIComponent)component, (FacesContext)context);
    }

    public void setParent(UIComponent parent) {
        super.setParent(parent);
        if (parent != null && parent.getFamily() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage((String)"CALLED_SET_PARENT", (Object)parent.getClass().getName()));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage((String)"DETECT_NEW_COMPONENT"));
            }
            this.setParentProperties(parent);
        }
    }

    public void setParentProperties(UIComponent parent) {
        String event = this.getEvent();
        if (event == null || event.length() == 0) {
            return;
        }
        String attachTo = this.getAttachTo();
        if (attachTo == null || attachTo.length() == 0) {
            parent.setValueExpression(event, (ValueExpression)new EventValueExpression((AjaxSupport)this));
        } else {
            ValueExpression vb = parent.getValueExpression(event);
            if (vb instanceof EventValueExpression) {
                parent.setValueExpression(event, null);
            }
        }
    }

    public abstract void setName(String var1);

    public abstract String getName();

    public abstract void setAttachTiming(String var1);

    public abstract String getAttachTiming();

    public boolean isDisableDefault() {
        if (this.disableDefaultSet) {
            return ON_CONTEXT_MENU.equalsIgnoreCase(this.getEvent());
        }
        ValueExpression ve = this.getValueExpression(DISABLE_DEFAULT);
        if (ve != null) {
            try {
                Boolean value = (Boolean)ve.getValue(this.getFacesContext().getELContext());
                if (value != null) {
                    return value;
                }
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return this.disableDefault;
    }

    public void setDisableDefault(boolean disableDefault) {
        this.disableDefault = disableDefault;
        this.disableDefaultSet = true;
    }

    public Object saveState(FacesContext context) {
        Object[] state = new Object[9];
        state[0] = super.saveState(context);
        state[1] = this.disableDefault;
        state[2] = this.disableDefaultSet;
        return state;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] states = (Object[])state;
        super.restoreState(context, states[0]);
        this.disableDefault = (Boolean)states[1];
        this.disableDefaultSet = (Boolean)states[2];
    }
}

