/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.antlr;

import antlr.LLkParser;
import antlr.NoViableAltException;
import antlr.ParserSharedInputState;
import antlr.RecognitionException;
import antlr.SemanticException;
import antlr.Token;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.collections.impl.BitSet;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.jboss.seam.text.SeamTextParser;
import org.richfaces.antlr.HtmlSeamTextParserTokenTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlSeamTextParser
extends LLkParser
implements HtmlSeamTextParserTokenTypes {
    private final String SEAMTEXT_MONOSPACE = "|";
    private final String SEAMTEXT_TWIDDLE = "~";
    private final String SEAMTEXT_HASH = "#";
    private final String SEAMTEXT_HAT = "^";
    private final String SEAMTEXT_PLUS = "+";
    private final String SEAMTEXT_STAR = "*";
    private final String SEAMTEXT_UNDERSCORE = "_";
    private final String SEAMTEXT_EQ = "=";
    private final String SEAMTEXT_BACKTICK = "`";
    private final String BLANK_LINE = "\n\n";
    private final String SEAM_DOUBLEQUOTE = "\"";
    private final String SEAM_OPEN = "[";
    private final String SEAM_CLOSE = "]";
    private final String SEAM_GT = ">";
    public boolean preformatted = false;
    protected Set<String> seamTextSymbols = new HashSet<String>(Arrays.asList("|", "~", "#", "^", "+", "*", "_", "=", "`", "\n\n", "\"", "[", "]", ">"));
    protected Set<String> htmlSeamTextElements = new HashSet<String>(Arrays.asList("del", "sup", "pre", "p", "q", "h1", "h2", "h3", "h4", "ul", "ol", "li", "i", "tt", "u", "a", "blockqoute"));
    protected Set<String> simpleHtmlSeamTextElements = new HashSet<String>(Arrays.asList("del", "sup", "pre", "q", "i", "tt", "u"));
    protected Set<String> formattedHtmlSeamTextElements = new HashSet<String>(Arrays.asList("ul", "ol", "li", "h1", "h2", "h3", "h4", "a", "p", "blockqoute"));
    private SeamTextParser.Sanitizer sanitizer = new SeamTextParser.DefaultSanitizer();
    private Stack<Token> htmlElementStack = new Stack();
    private StringBuilder mainBuilder = new StringBuilder();
    private String linkHolder;
    private int newlines;
    private boolean isHeaderProcessed = false;
    private StringBuilder builder = this.mainBuilder;
    public StringBuilder valueCollector;
    public static final String[] _tokenNames = new String[]{"<0>", "the end of the text", "<2>", "NULL_TREE_LOOKAHEAD", "a newline", "a space or tab", "letters or digits", "letters or digits", "a doublequote \\\"", "ESCAPED_LT", "ESCAPED_GT", "ESCAPED_AMP", "ESCAPED_QOUT", "ESCAPED_NBSP", "a punctuation character", "a single quote '", "a slash '/'", "a star '*'", "a bar or pipe '|'", "a caret '^'", "a plus '+'", "an equals '='", "a hash '#'", "the escaping blackslash '\\'", "a tilde '~'", "an underscore '_'", "an opening square bracket '['", "a closing square bracket ']'", "a backtick '`'", "a closing angle bracket '>'", "an opening angle bracket '<'", "an ampersand '&'"};
    public static final BitSet _tokenSet_0 = new BitSet(HtmlSeamTextParser.mk_tokenSet_0());

    public void setSanitizer(SeamTextParser.Sanitizer sanitizer) {
        this.sanitizer = sanitizer;
    }

    public String toString() {
        return this.builder.toString();
    }

    private void beginCapture() {
        this.builder = new StringBuilder();
    }

    private String endCapture() {
        String result = this.builder.toString();
        this.builder = this.mainBuilder;
        return result;
    }

    private void append(String ... strings) {
        for (String string : strings) {
            this.builder.append(string);
        }
    }

    public boolean isLink(Token token) {
        String name = token.getText().toLowerCase();
        return "a".equals(name);
    }

    private String createSeamTextLink(String link, String value) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        if (value != null) {
            builder.append(value.trim());
        }
        builder.append("=>");
        builder.append(link);
        builder.append("]");
        return builder.toString();
    }

    public boolean isHeader(Token token) {
        String name = token.getText().toLowerCase();
        return "h1".equals(name) || "h2".equals(name) || "h3".equals(name) || "h4".equals(name);
    }

    public String createSeamTextHeader(Token token) throws SemanticException {
        String name = token.getText();
        StringBuilder seamHeader = new StringBuilder();
        if ("h1".equals(name)) {
            seamHeader.append("\n\n").append("+");
        } else if ("h2".equals(name)) {
            seamHeader.append("\n\n").append("+").append("+");
        } else if ("h3".equals(name)) {
            seamHeader.append("\n\n").append("+").append("+").append("+");
        } else if ("h4".equals(name)) {
            seamHeader.append("\n\n").append("+").append("+").append("+").append("+");
        }
        return seamHeader.toString();
    }

    public boolean isParagraph(Token token) {
        String name = token.getText().toLowerCase();
        return "p".equals(name);
    }

    public String checkHeaderMarkup() throws TokenStreamException {
        Token token;
        int i = 0;
        StringBuilder result = new StringBuilder();
        boolean containText = false;
        do {
            if ((token = this.LT(++i)).getType() != 6) continue;
            if (this.isHeader(token)) break;
            result.append("\n");
            containText = true;
            break;
        } while (token.getType() != 1);
        if (!containText) {
            result.append("\n").append("<span></span>");
        }
        return result.toString();
    }

    public String checkParagraphMarkup() throws TokenStreamException {
        Token token;
        int i = 0;
        do {
            if ((token = this.LT(++i)).getType() != 6) continue;
            if (this.isParagraph(token) || this.isHeader(token) || this.isList(token)) break;
            return "\n\n";
        } while (token.getType() != 1);
        return "";
    }

    public String checkListMarkup() throws TokenStreamException {
        Token token;
        int i = 0;
        do {
            if ((token = this.LT(++i)).getType() != 6) continue;
            if (this.isParagraph(token) || this.isHeader(token)) break;
            return "\n\n";
        } while (token.getType() != 1);
        return "";
    }

    public String checkListItemMarkup() throws TokenStreamException {
        Token token;
        int i = 0;
        do {
            if ((token = this.LT(++i)).getType() != 6) continue;
            if (this.isList(token)) {
                return "";
            }
            if (!this.isListItem(token)) break;
            return "\n";
        } while (token.getType() != 1);
        return "";
    }

    public boolean isList(Token token) {
        String name = token.getText();
        return "ul".equals(name) || "ol".equals(name);
    }

    public boolean isListItem(Token token) {
        String name = token.getText().toLowerCase();
        return "li".equals(name);
    }

    public String createSeamTextList(Token token, Stack<Token> htmlElementStack) throws SemanticException {
        String seamText = null;
        Token parent = htmlElementStack.peek();
        String parentName = parent.getText().toLowerCase();
        if (parentName.equals("ul")) {
            seamText = "=";
        } else if (parentName.equals("ol")) {
            seamText = "#";
        } else {
            String message = "<li> must follow <ol> or <ul> not <" + parent.getText() + ">";
            throw new SemanticException(message, parent.getFilename(), parent.getLine(), parent.getColumn());
        }
        return seamText != null ? seamText : "";
    }

    public boolean isPlainHtmlRequired(Token name, Stack<Token> htmlElementStack) throws SemanticException {
        if (!this.isSeamTextElement(name)) {
            return true;
        }
        if (this.isSimpleSeamTextElement(name)) {
            return false;
        }
        if (this.isHeader(name) && !htmlElementStack.isEmpty()) {
            return true;
        }
        if (!(htmlElementStack.isEmpty() || "a".equals(name.getText().toLowerCase()) || "p".equals(name.getText().toLowerCase()))) {
            for (Token token : htmlElementStack) {
                if (!this.isHeader(token) && !this.isListItem(token)) continue;
                return true;
            }
        }
        return false;
    }

    public String getSimpleSeamText(Token token) throws SemanticException, TokenStreamException {
        String name = token.getText().toLowerCase();
        StringBuilder seamText = new StringBuilder();
        if ("tt".equals(name)) {
            seamText.append("|");
        } else if ("del".equals(name)) {
            seamText.append("~");
        } else if ("i".equals(name)) {
            seamText.append("*");
        } else if ("sup".equals(name)) {
            seamText.append("^");
        } else if ("u".equals(name)) {
            seamText.append("_");
        } else if ("pre".equals(name)) {
            seamText.append("`");
        } else if ("q".equals(name)) {
            seamText.append("\"");
        }
        return seamText.toString();
    }

    public String escapeSeamText(Token token, boolean preformatted) throws TokenStreamException {
        StringBuilder result = new StringBuilder();
        String tokenName = token.getText();
        if (preformatted) {
            if ("&lt;".equals(tokenName)) {
                result.append("<");
            } else if ("&amp;".equals(tokenName)) {
                result.append("&");
            } else if ("&gt;".equals(tokenName)) {
                result.append(">");
            } else if ("&quot;".equals(tokenName)) {
                result.append("\"");
            } else if (this.seamTextSymbols.contains(tokenName)) {
                result.append(tokenName);
            }
        } else if ("&lt;".equals(tokenName)) {
            result.append("\\<");
        } else if ("&amp;".equals(tokenName)) {
            result.append("\\&");
        } else if ("&gt;".equals(tokenName)) {
            result.append("\\>");
        } else if ("&quot;".equals(tokenName)) {
            result.append("\"");
        } else if ("\\".equals(tokenName)) {
            result.append("\\\\");
        } else if (this.seamTextSymbols.contains(tokenName)) {
            result.append("\\").append(tokenName);
        }
        return result.toString();
    }

    public boolean isSeamTextElement(Token element) {
        String name = element.getText().toLowerCase();
        return this.htmlSeamTextElements.contains(name);
    }

    public boolean isSimpleSeamTextElement(Token element) {
        String name = element.getText().toLowerCase();
        return this.simpleHtmlSeamTextElements.contains(name);
    }

    public boolean isFormattedHtmlSeamTextElement(Token element) {
        String name = element.getText().toLowerCase();
        return this.formattedHtmlSeamTextElements.contains(name);
    }

    public boolean isPreFormattedElement(Token element) {
        String name = element.getText().toLowerCase();
        return "pre".equals(name) || "tt".equals(name);
    }

    protected HtmlSeamTextParser(TokenBuffer tokenBuf, int k) {
        super(tokenBuf, k);
        this.tokenNames = _tokenNames;
    }

    public HtmlSeamTextParser(TokenBuffer tokenBuf) {
        this(tokenBuf, 4);
    }

    protected HtmlSeamTextParser(TokenStream lexer, int k) {
        super(lexer, k);
        this.tokenNames = _tokenNames;
    }

    public HtmlSeamTextParser(TokenStream lexer) {
        this(lexer, 4);
    }

    public HtmlSeamTextParser(ParserSharedInputState state) {
        super(state, 4);
        this.tokenNames = _tokenNames;
    }

    public final void startRule() throws RecognitionException, TokenStreamException {
        while (this.LA(1) == 4) {
            this.match(4);
        }
        switch (this.LA(1)) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                this.text();
                this.eof();
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void text() throws RecognitionException, TokenStreamException {
        int _cnt10 = 0;
        while (true) {
            if (_tokenSet_0.member(this.LA(1))) {
                switch (this.LA(1)) {
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: {
                        this.seamCharacters();
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 14: 
                    case 15: 
                    case 16: {
                        this.plain();
                        break;
                    }
                    case 30: {
                        this.html();
                        break;
                    }
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: {
                        this.htmlSpecialChars();
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                while (this.LA(1) == 4) {
                    this.match(4);
                    Token token = this.LT(2);
                    if (this.isParagraph(token) || !this.isHeaderProcessed) continue;
                    this.isHeaderProcessed = false;
                }
            } else {
                if (_cnt10 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            ++_cnt10;
        }
    }

    public final void eof() throws RecognitionException, TokenStreamException {
        this.match(1);
    }

    public final void seamCharacters() throws RecognitionException, TokenStreamException {
        Token hat = null;
        Token hash = null;
        Token open = null;
        Token close = null;
        Token twiddle = null;
        Token bar = null;
        Token eq = null;
        Token plus = null;
        Token backtick = null;
        Token st = null;
        Token e = null;
        Token gt = null;
        switch (this.LA(1)) {
            case 19: {
                hat = this.LT(1);
                this.match(19);
                this.append(this.escapeSeamText(hat, this.preformatted));
                break;
            }
            case 22: {
                hash = this.LT(1);
                this.match(22);
                this.append(this.escapeSeamText(hash, this.preformatted));
                break;
            }
            case 26: {
                open = this.LT(1);
                this.match(26);
                this.append(this.escapeSeamText(open, this.preformatted));
                break;
            }
            case 27: {
                close = this.LT(1);
                this.match(27);
                this.append(this.escapeSeamText(close, this.preformatted));
                break;
            }
            case 24: {
                twiddle = this.LT(1);
                this.match(24);
                this.append(this.escapeSeamText(twiddle, this.preformatted));
                break;
            }
            case 18: {
                bar = this.LT(1);
                this.match(18);
                this.append(this.escapeSeamText(bar, this.preformatted));
                break;
            }
            case 21: {
                eq = this.LT(1);
                this.match(21);
                this.append(this.escapeSeamText(eq, this.preformatted));
                break;
            }
            case 20: {
                plus = this.LT(1);
                this.match(20);
                this.append(this.escapeSeamText(plus, this.preformatted));
                break;
            }
            case 28: {
                backtick = this.LT(1);
                this.match(28);
                this.append(this.escapeSeamText(backtick, this.preformatted));
                break;
            }
            case 17: {
                st = this.LT(1);
                this.match(17);
                this.append(this.escapeSeamText(st, this.preformatted));
                break;
            }
            case 23: {
                e = this.LT(1);
                this.match(23);
                this.append(this.escapeSeamText(e, this.preformatted));
                break;
            }
            case 29: {
                gt = this.LT(1);
                this.match(29);
                this.append(this.escapeSeamText(gt, this.preformatted));
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void plain() throws RecognitionException, TokenStreamException {
        Token space = null;
        switch (this.LA(1)) {
            case 6: 
            case 7: {
                this.word();
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                this.punctuation();
                break;
            }
            case 5: {
                space = this.LT(1);
                this.match(5);
                this.append(space.getText());
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        Token token = this.LT(2);
        if (!this.isParagraph(token) && this.isHeaderProcessed) {
            this.isHeaderProcessed = false;
        }
    }

    public final void html() throws RecognitionException, TokenStreamException {
        this.openTag();
        while (true) {
            if (this.LA(1) == 5 && (this.LA(2) == 5 || this.LA(2) == 16 || this.LA(2) == 29)) {
                this.space();
                continue;
            }
            if (this.LA(1) != 5 || this.LA(2) != 6) break;
            this.space();
            this.attribute();
        }
        switch (this.LA(1)) {
            case 29: {
                this.beforeBody();
                this.body();
                this.closeTagWithBody();
                break;
            }
            case 16: {
                this.closeTagWithNoBody();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void htmlSpecialChars() throws RecognitionException, TokenStreamException {
        Token lt = null;
        Token gt = null;
        Token amp = null;
        Token qout = null;
        Token nbsp = null;
        switch (this.LA(1)) {
            case 8: {
                this.match(8);
                this.append("\"");
                break;
            }
            case 9: {
                lt = this.LT(1);
                this.match(9);
                this.append(this.escapeSeamText(lt, this.preformatted));
                break;
            }
            case 10: {
                gt = this.LT(1);
                this.match(10);
                this.append(this.escapeSeamText(gt, this.preformatted));
                break;
            }
            case 11: {
                amp = this.LT(1);
                this.match(11);
                this.append(this.escapeSeamText(amp, this.preformatted));
                break;
            }
            case 12: {
                qout = this.LT(1);
                this.match(12);
                this.append(this.escapeSeamText(qout, this.preformatted));
                break;
            }
            case 13: {
                nbsp = this.LT(1);
                this.match(13);
                this.append(" ");
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void word() throws RecognitionException, TokenStreamException {
        Token an = null;
        Token uc = null;
        switch (this.LA(1)) {
            case 6: {
                an = this.LT(1);
                this.match(6);
                this.append(an.getText());
                break;
            }
            case 7: {
                uc = this.LT(1);
                this.match(7);
                this.append(uc.getText());
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void punctuation() throws RecognitionException, TokenStreamException {
        Token p = null;
        Token sq = null;
        Token s = null;
        switch (this.LA(1)) {
            case 14: {
                p = this.LT(1);
                this.match(14);
                this.append(p.getText());
                break;
            }
            case 15: {
                sq = this.LT(1);
                this.match(15);
                this.append(sq.getText());
                break;
            }
            case 16: {
                s = this.LT(1);
                this.match(16);
                this.append(s.getText());
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void specialChars() throws RecognitionException, TokenStreamException {
        Token st = null;
        Token b = null;
        Token h = null;
        Token p = null;
        Token eq = null;
        Token hh = null;
        Token e = null;
        Token t = null;
        Token u = null;
        switch (this.LA(1)) {
            case 17: {
                st = this.LT(1);
                this.match(17);
                this.append(st.getText());
                break;
            }
            case 18: {
                b = this.LT(1);
                this.match(18);
                this.append(b.getText());
                break;
            }
            case 19: {
                h = this.LT(1);
                this.match(19);
                this.append(h.getText());
                break;
            }
            case 20: {
                p = this.LT(1);
                this.match(20);
                this.append(p.getText());
                break;
            }
            case 21: {
                eq = this.LT(1);
                this.match(21);
                this.append(eq.getText());
                break;
            }
            case 22: {
                hh = this.LT(1);
                this.match(22);
                this.append(hh.getText());
                break;
            }
            case 23: {
                e = this.LT(1);
                this.match(23);
                this.append(e.getText());
                break;
            }
            case 24: {
                t = this.LT(1);
                this.match(24);
                this.append(t.getText());
                break;
            }
            case 25: {
                u = this.LT(1);
                this.match(25);
                this.append(u.getText());
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void space() throws RecognitionException, TokenStreamException {
        Token s = null;
        s = this.LT(1);
        this.match(5);
        if (!this.htmlElementStack.isEmpty()) {
            Token token = this.htmlElementStack.pop();
            if (this.isPlainHtmlRequired(token, this.htmlElementStack)) {
                this.append(s.getText());
            }
            this.htmlElementStack.push(token);
        }
    }

    public final void newline() throws RecognitionException, TokenStreamException {
        Token n = null;
        n = this.LT(1);
        this.match(4);
        if (this.preformatted && this.valueCollector != null) {
            this.valueCollector.append(n.getText());
        }
    }

    public final void newlineOrEof() throws RecognitionException, TokenStreamException {
        switch (this.LA(1)) {
            case 4: {
                this.newline();
                break;
            }
            case 1: {
                this.match(1);
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void openTag() throws RecognitionException, TokenStreamException {
        Token name = null;
        try {
            this.match(30);
            name = this.LT(1);
            this.match(6);
            this.sanitizer.validateHtmlElement(name);
            Object token = null;
            if (this.isPreFormattedElement(name)) {
                this.preformatted = true;
            }
            if (!this.isPlainHtmlRequired(name, this.htmlElementStack)) {
                if (this.isFormattedHtmlSeamTextElement(name)) {
                    if (this.isLink(name) && this.valueCollector != null) {
                        this.append(this.valueCollector.toString());
                        this.valueCollector = null;
                    }
                    if (this.isList(name)) {
                        this.append("\n\n");
                    } else if (this.isListItem(name)) {
                        this.append(this.createSeamTextList(name, this.htmlElementStack));
                    } else if (this.isHeader(name)) {
                        this.append(this.createSeamTextHeader(name));
                    } else if (this.isParagraph(name) && !this.isHeaderProcessed && !this.isHeaderProcessed) {
                        this.append("\n\n");
                    }
                } else if (this.isSimpleSeamTextElement(name)) {
                    if (this.valueCollector != null) {
                        this.append(this.valueCollector.toString());
                        this.valueCollector = null;
                    }
                    this.append(this.getSimpleSeamText(name));
                }
            } else {
                if (this.valueCollector != null) {
                    this.append(this.valueCollector.toString());
                    this.valueCollector = null;
                }
                this.append("<");
                this.append(name.getText());
            }
            this.htmlElementStack.push(name);
        }
        catch (RecognitionException ex) {
            if (this.htmlElementStack.isEmpty()) {
                throw ex;
            }
            Token tok = this.htmlElementStack.peek();
            if (tok != null) {
                throw new HtmlRecognitionException(tok, ex);
            }
            throw ex;
        }
    }

    public final void attribute() throws RecognitionException, TokenStreamException {
        Token att = null;
        try {
            att = this.LT(1);
            this.match(6);
            while (this.LA(1) == 5) {
                this.space();
            }
            this.match(21);
            while (this.LA(1) == 5) {
                this.space();
            }
            this.match(8);
            Token token = this.htmlElementStack.pop();
            this.sanitizer.validateHtmlAttribute(token, att);
            boolean isPlainHtmlRequired = this.isPlainHtmlRequired(token, this.htmlElementStack);
            if (isPlainHtmlRequired) {
                this.append(att.getText());
                this.append("=\"");
            }
            this.beginCapture();
            this.attributeValue();
            String attValue = this.endCapture();
            this.sanitizer.validateHtmlAttributeValue(token, att, attValue);
            if (isPlainHtmlRequired) {
                this.append(attValue);
            } else if (this.isLink(token) && "href".equals(att.getText())) {
                this.linkHolder = attValue;
            }
            this.match(8);
            if (isPlainHtmlRequired) {
                this.append("\"");
            }
            this.htmlElementStack.push(token);
        }
        catch (RecognitionException ex) {
            if (this.htmlElementStack.isEmpty()) {
                throw ex;
            }
            Token tok = this.htmlElementStack.peek();
            if (tok != null) {
                throw new HtmlRecognitionException(tok, ex);
            }
            throw ex;
        }
    }

    public final void beforeBody() throws RecognitionException, TokenStreamException {
        try {
            this.match(29);
            Token name = this.htmlElementStack.pop();
            if (this.isPlainHtmlRequired(name, this.htmlElementStack)) {
                this.append(">");
            } else {
                Token token = this.LT(1);
                if ((this.isListItem(name) || this.isHeader(name)) && token.getType() != 5) {
                    this.append(" ");
                }
            }
            this.htmlElementStack.push(name);
        }
        catch (RecognitionException ex) {
            if (this.htmlElementStack.isEmpty()) {
                throw ex;
            }
            Token tok = this.htmlElementStack.peek();
            if (tok != null) {
                throw new HtmlRecognitionException(tok, ex);
            }
            throw ex;
        }
    }

    public final void body() throws RecognitionException, TokenStreamException {
        block9: while (true) {
            switch (this.LA(1)) {
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    this.beginCapture();
                    Token token = this.htmlElementStack.peek();
                    switch (this.LA(1)) {
                        case 17: 
                        case 18: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 26: 
                        case 27: 
                        case 28: 
                        case 29: {
                            this.seamCharacters();
                            break;
                        }
                        case 5: 
                        case 6: 
                        case 7: 
                        case 14: 
                        case 15: 
                        case 16: {
                            this.plain();
                            break;
                        }
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: {
                            this.htmlSpecialChars();
                            if (!this.isLink(token)) break;
                            String message = "Unexpected token <" + token.getText() + ">";
                            throw new SemanticException(message);
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    String plain = this.endCapture();
                    if (this.valueCollector == null) {
                        this.valueCollector = new StringBuilder();
                    }
                    if (this.isList(token)) continue block9;
                    this.valueCollector.append(plain);
                    continue block9;
                }
                case 4: {
                    this.newline();
                    continue block9;
                }
            }
            if (this.LA(1) != 30 || this.LA(2) != 6) break;
            this.html();
            if (this.valueCollector == null) continue;
            this.append(this.valueCollector.toString());
        }
    }

    public final void closeTagWithBody() throws RecognitionException, TokenStreamException {
        Token name = null;
        this.match(30);
        this.match(16);
        name = this.LT(1);
        this.match(6);
        this.match(29);
        Token token = this.htmlElementStack.pop();
        if (!token.getText().equals(name.getText())) {
            throw new RecognitionException("Can not convert to the Seam Text:  </" + token.getText() + ">" + " expected");
        }
        String value = "";
        if (this.valueCollector != null) {
            value = this.valueCollector.toString();
        }
        if (!this.isPlainHtmlRequired(name, this.htmlElementStack)) {
            if (this.isFormattedHtmlSeamTextElement(name)) {
                if (this.isLink(name)) {
                    this.append(this.createSeamTextLink(this.linkHolder, value.trim()));
                } else if (this.isParagraph(name)) {
                    this.append(value);
                    if (this.isHeaderProcessed) {
                        this.isHeaderProcessed = false;
                    }
                    this.append(this.checkParagraphMarkup());
                } else {
                    this.append(value);
                }
                if (this.isList(name)) {
                    this.append(this.checkListMarkup());
                } else if (this.isListItem(name)) {
                    this.append(this.checkListItemMarkup());
                } else if (this.isHeader(name)) {
                    this.append(this.checkHeaderMarkup());
                    this.isHeaderProcessed = true;
                }
            } else if (this.isSimpleSeamTextElement(name)) {
                this.append(value.trim());
                this.append(this.getSimpleSeamText(name));
            }
        } else {
            this.append(value);
            this.append("</");
            this.append(name.getText());
            this.append(">");
        }
        this.valueCollector = null;
        if (this.isPreFormattedElement(name)) {
            this.preformatted = false;
        }
    }

    public final void closeTagWithNoBody() throws RecognitionException, TokenStreamException {
        this.match(16);
        this.match(29);
        this.append("/>");
        this.htmlElementStack.pop();
    }

    public final void attributeValue() throws RecognitionException, TokenStreamException {
        Token an = null;
        Token p = null;
        Token s = null;
        Token space = null;
        try {
            block10: while (true) {
                switch (this.LA(1)) {
                    case 31: {
                        this.match(31);
                        this.append("&amp;");
                        continue block10;
                    }
                    case 6: {
                        an = this.LT(1);
                        this.match(6);
                        this.append(an.getText());
                        continue block10;
                    }
                    case 14: {
                        p = this.LT(1);
                        this.match(14);
                        this.append(p.getText());
                        continue block10;
                    }
                    case 16: {
                        s = this.LT(1);
                        this.match(16);
                        this.append(s.getText());
                        continue block10;
                    }
                    case 5: {
                        space = this.LT(1);
                        this.match(5);
                        this.append(space.getText());
                        continue block10;
                    }
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: {
                        this.specialChars();
                        continue block10;
                    }
                }
                break;
            }
        }
        catch (RecognitionException ex) {
            if (this.htmlElementStack.isEmpty()) {
                throw ex;
            }
            Token tok = this.htmlElementStack.peek();
            if (tok != null) {
                throw new HtmlRecognitionException(tok, ex);
            }
            throw ex;
        }
    }

    private static final long[] mk_tokenSet_0() {
        long[] data = new long[]{2113929184L, 0L};
        return data;
    }

    public class HtmlRecognitionException
    extends RecognitionException {
        Token openingElement;
        RecognitionException wrappedException;

        public HtmlRecognitionException(Token openingElement, RecognitionException wrappedException) {
            this.openingElement = openingElement;
            this.wrappedException = wrappedException;
        }

        public Token getOpeningElement() {
            return this.openingElement;
        }

        public String getMessage() {
            return this.wrappedException.getMessage();
        }

        public Throwable getCause() {
            return this.wrappedException;
        }
    }
}

