/**
 * License Agreement.
 *
 * Ajax4jsf 1.1 - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.renderkit.html;


// 
// Imports
//
import java.util.Iterator;
import java.util.Collection;
import java.util.Map;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.ComponentVariables;
//
//
//


import org.richfaces.renderkit.AbstractPageRenderer;



/**
 * Renderer for component class org.richfaces.renderkit.html.CssZendRenderer
 */
public class CssZendRenderer extends AbstractPageRenderer {

	public CssZendRenderer () {
		super();
	}

	// 
	// Declarations
	//
	// 
	// 
	//


	private String convertToString(Object obj ) {
		return ( obj == null ? "" : obj.toString() );
	}
	private String convertToString(boolean b ) {
		return String.valueOf(b);
	}
	private String convertToString(int b ) {
		return b!=Integer.MIN_VALUE?String.valueOf(b):"";
	}
	private String convertToString(long b ) {
		return b!=Long.MIN_VALUE?String.valueOf(b):"";
	}
	
	private boolean isEmpty(Object o) {
		if (null == o) {
			return true;
		}
		if (o instanceof String ) {
			return (0 == ((String)o).length());
		}
		if (o instanceof Collection) {
			return (0 == ((Collection)o).size());
		}
		if (o instanceof Map) {
			return (0 == ((Map)o).size());
		}
		if (o.getClass().isArray()) {
			return (0 == ((Object [])o).length);
		}
		return false;
	}
	
	/**
	 * Get base component class, targetted for this renderer. Used for check arguments in decode/encode.
	 * @return
	 */
	protected Class getComponentClass() {
		return org.richfaces.component.UIPage.class;
	}

	
	public void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component ) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeBegin(writer, context, (org.richfaces.component.UIPage)component, variables );
	}		

	public void doEncodeBegin(ResponseWriter writer, FacesContext context, org.richfaces.component.UIPage component, ComponentVariables variables ) throws IOException {
	    variables.setVariable("namespace", prolog(context,component) );
writer.startElement("html", component);
			getUtils().writeAttribute(writer, "lang", context.getViewRoot().getLocale() );
						getUtils().writeAttribute(writer, "xmlns", variables.getVariable("namespace") );
			
writer.startElement("head", component);

writer.startElement("title", component);

writer.writeText(convertToString(component.getAttributes().get("pageTitle")),null);

writer.endElement("title");
themeStyle(context, component);

themeScript(context, component);

UIComponent indexChildren_39 = component.getFacet("pageHeader");
if (null != indexChildren_39 && indexChildren_39 .isRendered()) {
	renderChild(context, indexChildren_39);
}

writer.endElement("head");
writer.startElement("body", component);
			getUtils().writeAttribute(writer, "id", "css-zen-garden" );
			//
// pass thru attributes
//
getUtils().encodeAttributesFromArray(context,component,new String[] {
    "alink" ,
	    "background" ,
	    "bgcolor" ,
	    "dir" ,
	    "lang" ,
	    "link" ,
	    "onclick" ,
	    "ondblclick" ,
	    "onkeydown" ,
	    "onkeypress" ,
	    "onkeyup" ,
	    "onload" ,
	    "onmousedown" ,
	    "onmousemove" ,
	    "onmouseout" ,
	    "onmouseover" ,
	    "onmouseup" ,
	    "onunload" ,
	    "style" ,
	    "text" ,
	    "title" ,
	    "vlink" ,
	    "xml:lang" });
//
//
//

writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-page " + convertToString(component.getAttributes().get("pageClass")) );
						getUtils().writeAttribute(writer, "id", "container" );
						getUtils().writeAttribute(writer, "style", component.getAttributes().get("pageStyle") );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "id", "intro" );
			
if ( Boolean.valueOf( String.valueOf(hasFacet(component,"header")) ).booleanValue() ) {


writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-page-header " + convertToString(component.getAttributes().get("headerClass")) );
						getUtils().writeAttribute(writer, "id", "pageHeader" );
			
UIComponent indexChildren_40 = component.getFacet("header");
if (null != indexChildren_40 && indexChildren_40 .isRendered()) {
	renderChild(context, indexChildren_40);
}

writer.endElement("div");
}
if ( Boolean.valueOf( String.valueOf(hasFacet(component,"summary")) ).booleanValue() ) {


writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-page-summary " + convertToString(component.getAttributes().get("summaryClass")) );
						getUtils().writeAttribute(writer, "id", "quickSummary" );
			
UIComponent indexChildren_41 = component.getFacet("summary");
if (null != indexChildren_41 && indexChildren_41 .isRendered()) {
	renderChild(context, indexChildren_41);
}

writer.endElement("div");
}
if ( Boolean.valueOf( String.valueOf(hasFacet(component,"preamble")) ).booleanValue() ) {


writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-page-preamble " + convertToString(component.getAttributes().get("preambleClass")) );
						getUtils().writeAttribute(writer, "id", "preamble" );
			
UIComponent indexChildren_42 = component.getFacet("preamble");
if (null != indexChildren_42 && indexChildren_42 .isRendered()) {
	renderChild(context, indexChildren_42);
}

writer.endElement("div");
}
writer.endElement("div");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-page-content " + convertToString(component.getAttributes().get("contentClass")) );
						getUtils().writeAttribute(writer, "id", "supportingText" );
			

	}		
	
    public void doEncodeChildren(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeChildren(writer, context, (org.richfaces.component.UIPage)component, variables );
	}		

    public void doEncodeChildren(ResponseWriter writer, FacesContext context, org.richfaces.component.UIPage component, ComponentVariables variables) throws IOException {
	    
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-page-body " + convertToString(component.getAttributes().get("bodyClass")) );
			
renderChildren(context, component);

writer.endElement("div");

	}		

	/* (non-Javadoc)
	 * @see javax.faces.render.Renderer#getRendersChildren()
	 */
	public boolean getRendersChildren() {
		return true;
	}

	public void doEncodeEnd(ResponseWriter writer, FacesContext context, org.richfaces.component.UIPage component, ComponentVariables variables) throws IOException {
	  
if ( Boolean.valueOf( String.valueOf(hasFacet(component,"footer")) ).booleanValue() ) {


writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-page-footer " + convertToString(component.getAttributes().get("footerClass")) );
						getUtils().writeAttribute(writer, "id", "footer" );
			
UIComponent indexChildren_43 = component.getFacet("footer");
if (null != indexChildren_43 && indexChildren_43 .isRendered()) {
	renderChild(context, indexChildren_43);
}

writer.endElement("div");
}
writer.endElement("div");
if ( Boolean.valueOf( String.valueOf(hasFacet(component,"sidebar")) ).booleanValue() ) {


writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-page-sidebar " + convertToString(component.getAttributes().get("styleClass")) );
						getUtils().writeAttribute(writer, "id", "linkList" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "id", "linkList2" );
			
UIComponent indexChildren_44 = component.getFacet("sidebar");
if (null != indexChildren_44 && indexChildren_44 .isRendered()) {
	renderChild(context, indexChildren_44);
}

writer.endElement("div");
writer.endElement("div");
}
writer.endElement("div");
writer.writeComment(convertToString(" These extra divs/spans may be used as catch-alls to add extra imagery. "));

writer.startElement("div", component);
			getUtils().writeAttribute(writer, "id", "extraDiv1" );
			
writer.startElement("span", component);

writer.endElement("span");
writer.endElement("div");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "id", "extraDiv2" );
			
writer.endElement("div");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "id", "extraDiv3" );
			
writer.endElement("div");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "id", "extraDiv4" );
			
writer.endElement("div");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "id", "extraDiv5" );
			
writer.endElement("div");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "id", "extraDiv6" );
			
writer.endElement("div");
writer.endElement("body");
writer.endElement("html");

	}		
	
	public void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeEnd(writer, context, (org.richfaces.component.UIPage)component, variables );

		ComponentsVariableResolver.removeVariables(this, component);
	}		
	

}
