/**
 * License Agreement.
 *
 *  JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007  Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.ScriptUtils;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.renderkit.RendererUtils.HTML;
import org.richfaces.component.UIPanelMenu;
import org.richfaces.component.UIPanelMenuGroup;
import org.richfaces.component.UIPanelMenuItem;
import org.richfaces.renderkit.PanelMenuRendererBase;

public class PanelMenuRenderer extends PanelMenuRendererBase {

	/* (non-Javadoc)
	 * @see org.ajax4jsf.framework.renderer.RendererBase#getComponentClass()
	 */
	
	private static final String FIRST_EXPANDED_ENCODED = "firstExpandedEncoded";

    protected Class<? extends UIComponent> getComponentClass() {
		return UIComponent.class;
	}
	
    // find and encode UIParameter's components
    public List<String> encodeParams(FacesContext context, UIPanelMenuItem menuItem) throws IOException {
    	
    	List<String> params = new ArrayList<String>();
    	
    	List<UIComponent> children = menuItem.getChildren();
    	for (Iterator<UIComponent> iterator = children.iterator(); iterator.hasNext();) {
    		UIComponent child = (UIComponent) iterator.next();
	
    		if(child instanceof UIParameter){
					
    			UIParameter param = (UIParameter)child;
				String name = param.getName();
				
				if (name != null) {
					Object value = param.getValue();
			        StringBuffer buff = new StringBuffer();
					buff.append("params[").append(ScriptUtils.toScript(name)).append("] = ")
					    .append(ScriptUtils.toScript(value)).append(";");
					params.add(buff.toString());
				}
			}
    	}
    	
    	return params;
    }
    
    @Override
    protected void preEncodeBegin(FacesContext context, UIComponent component)
            throws IOException {
        
        super.preEncodeBegin(context, component);
        
        // In case of encoding the UIPanelMenu in "expandSingle=true" mode
        // the value of "firstExpandedEncoded" attribute should be reset to
        // initial "false" state
        if (component instanceof UIPanelMenu) {
            UIPanelMenu panelMenu = (UIPanelMenu) component;
            if (panelMenu.isExpandSingle()) {
                panelMenu.getAttributes().put(FIRST_EXPANDED_ENCODED, false);
            }
        }
    }

	
	public void insertScript(FacesContext context, UIComponent component)
			throws IOException {
		
		StringBuffer buffer	= new StringBuffer();
		
		Set<String> itemNames = new HashSet<String>();
		
		UIPanelMenu panelMenu = (UIPanelMenu)component;
		
        Map<String, Integer> levels = new HashMap<String, Integer>();
        List<UIComponent> flatList = new LinkedList<UIComponent>();
		flatten(component.getChildren(), flatList, levels, 0);
		
		for (UIComponent child : flatList) {
			if (!(child instanceof UIPanelMenuItem || child instanceof UIPanelMenuGroup)) {
			    continue;
			}    
			
            boolean parentRendered = child.getParent().isRendered();
            if (!parentRendered) {
                child.getAttributes().put("rendered",Boolean.FALSE);
            }
            
            boolean childRendered = child.isRendered();
            if (!childRendered || !parentRendered || isParentDisabled(child)/* || !isParentExpended(child)*/) {
                continue;
            }
            
			boolean childDisabled = panelMenu.isDisabled() 
			    || child instanceof UIPanelMenuGroup ? ((UIPanelMenuGroup)child).isDisabled() : ((UIPanelMenuItem)child).isDisabled();
			
			
			String childName;
			if(child instanceof UIPanelMenuGroup){
				childName = ((UIPanelMenuGroup)child).getName();
			} else {
				childName = ((UIPanelMenuItem)child).getName();
			}
			
			if(itemNames.contains(childName)){
				throw new RuntimeException("Attibute \"name\" with value \"" + childName + "\" is already used in PanelMenu. It must be unique for every group/item.");
			} else {
				itemNames.add(childName);
			}
			
			buffer.append("var params = new Object();");

			if (child instanceof UIPanelMenuItem) {
				for (String param : encodeParams(context, (UIPanelMenuItem)child)) {
					buffer.append(param);
				}
			}
			
			buffer.append("new PanelMenuItem(ids, params,")
			      .append("{myId:'").append(child.getClientId(context)).append("',")
				  .append("parentId:'").append(child.getParent().getClientId(context)).append("'},")
				  .append("{type:").append(child instanceof UIPanelMenuItem ? "\"item\"":"\"node\"").append(",")
				  .append("onopen:").append(getOnOpen(panelMenu, child)).append(",")
				  .append("onclose:").append(getNoClose(panelMenu, child)).append(",")
				  .append("event:\"").append(getEvent(panelMenu)).append("\",")
				  .append("mode:\"").append(getItemMode(child)).append("\",")
				  .append("disabled:").append(childDisabled).append(",")
				  .append("target:\"").append(getTarget(child)).append("\",")		
				  .append("name:\"").append(childName).append("\"")
				  .append("},{").append(getHoveredStyle(panelMenu, child)).append("},")
			      .append(getHoverClass(panelMenu, child))
			      .append(levels.get(child.getClientId(context)))
			      .append(switchOnImagesIfNeeded(context,child));
			
			addActionIfNeeded(context,child,buffer);
			
			setExpandedIfNeeded(context,child,buffer);
			
			addAjaxFunction(context,child,buffer);
			
			addOnItemHover(panelMenu.getOnitemhover(), child, buffer);
			
			String iconPos;
			boolean isTopLevel = isTopLevel(child);
			if(child instanceof UIPanelMenuGroup){
				iconPos = isTopLevel ? panelMenu.getIconGroupTopPosition() : panelMenu.getIconGroupPosition();
			} else {
				iconPos = isTopLevel ? panelMenu.getIconItemTopPosition() : panelMenu.getIconItemPosition();
			}
			
			buffer.append(",\""+iconPos+'"');
			
			addImages(buffer, context, child, component.getClientId(context).toString());
			
			buffer.append(");\n");
		}
		
		ResponseWriter writer = context.getResponseWriter();
		writer.startElement(HTML.SCRIPT_ELEM, component);
		writer.writeAttribute(HTML.id_ATTRIBUTE, "script" + component.getClientId(context), null);
		writer.writeAttribute(HTML.TYPE_ATTR, "text/javascript", null);
		writer.writeText(getPanelMenuScript(context, panelMenu), null);
		writer.writeText(buffer, null);
		writer.endElement(HTML.SCRIPT_ELEM);
	}

    private String getNoClose(UIPanelMenu panelMenu, UIComponent child) {
        String onclose = (child instanceof UIPanelMenuGroup) && !((UIPanelMenuGroup)child).isDisabled() && !isParentDisabled(child) 
                ? panelMenu.getOngroupcollapse() + ";" + ((UIPanelMenuGroup)child).getOncollapse() : "";
        return "".equals(onclose) ? "\"\"" : "\"" + onclose + "\"";
    }

    private String getOnOpen(UIPanelMenu panelMenu, UIComponent child) {
        String onopen = (child instanceof UIPanelMenuGroup) &&  !((UIPanelMenuGroup)child).isDisabled() && !isParentDisabled(child) 
                ? panelMenu.getOngroupexpand() + ";" + ((UIPanelMenuGroup)child).getOnexpand() : "";
        return "".equals(onopen) ? "\"\"" : "\"" + onopen + "\"";
    }

    private String getTarget(UIComponent child) {
        Object target = child.getAttributes().get("target");
        return null == target ? "" : target.toString();
    }

    private String getHoverClass(UIPanelMenu panelMenu, UIComponent child) {
        String hoveredClass = (child instanceof UIPanelMenuGroup ? 
                panelMenu.getHoveredGroupClass() : panelMenu.getHoveredItemClass())
                + " " + (child instanceof UIPanelMenuGroup ? 
                        ((UIPanelMenuGroup)child).getHoverClass() : ((UIPanelMenuItem)child).getHoverClass());
        String [] hoveredClasses = hoveredClass.trim().split(" ");

        StringBuffer buffer = new StringBuffer();

        buffer.append("new Array(");
        for (int i = 0; i < hoveredClasses.length; i++) {
            if (!"".equals(hoveredClasses[i])) {
                buffer.append("\"").append(hoveredClasses[i]).append("\"");
                
                if (i != hoveredClasses.length - 1){
                    buffer.append(",");
                }
            }
        }
        buffer.append("),");
        
        return buffer.toString();
    }

    private String getHoveredStyle(UIPanelMenu panelMenu, UIComponent child) {
        String hoveredStyle = (child instanceof UIPanelMenuGroup 
                ? panelMenu.getHoveredGroupStyle() : panelMenu.getHoveredItemStyle()) + ";" + 
                        (child instanceof UIPanelMenuGroup ? ((UIPanelMenuGroup)child).getHoverStyle() : ((UIPanelMenuItem)child).getHoverStyle());
        String [] hoveredStyles = hoveredStyle.split(";");

        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < hoveredStyles.length; i++) {
            if (!"".equals(hoveredStyles[i])) {
                String [] temp = hoveredStyles[i].split(":");
                String cssName = temp[0].trim();
                String cssValue = temp[1].trim();
                buffer.append("\"" + cssName + "\": \"" + cssValue + "\"");
                if (i != hoveredStyles.length - 1) {
                    buffer.append(",");
                }
            }
        }

        return buffer.toString();
    }

    private String getEvent(UIPanelMenu panelMenu) {
        String event = panelMenu.getEvent();
        if ("".equals(event)) {
        	event = "click";
        } else if (event.startsWith("on")) {
        	event = event.substring(2);
        }
        return event;
    }

    private StringBuffer getPanelMenuScript(FacesContext context, UIPanelMenu parentMenu) {
        StringBuffer panelMenu = new StringBuffer();
		panelMenu.append("var ids = new PanelMenu('")
 				.append(parentMenu.getClientId(context).toString()) 
				.append("',")
				.append(parentMenu.isExpandSingle())
				.append(",").append("'").append(parentMenu.getSelectedName()).append("'")
				.append(").getIds();\n");
        return panelMenu;
    }
	
	public void flatten(List<UIComponent> children, List<UIComponent> flatList, 
	        Map<String, Integer> levels, int initialLevel) {
		
	    FacesContext context = FacesContext.getCurrentInstance();
		if (children == null) {
		    return;
		}
		
		for (Iterator<UIComponent> iter = children.iterator(); iter.hasNext();) {
			UIComponent child = iter.next();
			if (child instanceof UIPanelMenu){
				continue;
			}
			
			flatList.add(child);
			levels.put(child.getClientId(context), initialLevel);
			
			flatten(child.getChildren(), flatList, levels, initialLevel + 1);
		}
	}
	
	private String switchOnImagesIfNeeded(FacesContext context, UIComponent child)throws IOException {
		boolean isToplevel = isTopLevel(child);
		String customIconOpened	= "";
		String customIconClosed	= "";

		UIPanelMenu panelMenu = findMenu(child);
		if(panelMenu == null){
			return "";
		}
		String iconOpened = isToplevel ? panelMenu.getIconExpandedTopGroup() : panelMenu.getIconExpandedGroup();
		String iconClosed = isToplevel ? panelMenu.getIconCollapsedTopGroup() : panelMenu.getIconCollapsedGroup();

		try {
			customIconOpened = (String)child.getAttributes().get("iconOpened");
			customIconClosed = (String)child.getAttributes().get("iconClosed");
		} catch (Exception e) {}
		
		StringBuffer buffer = new StringBuffer();
		if (child instanceof UIPanelMenuItem){
			buffer.append(",false");
		} else {
			if (iconClosed.equals("custom") && iconOpened.equals("custom")){
				if (customIconClosed.equals("") && customIconOpened.equals("")){
					buffer.append(",false");
				} else {
					buffer.append(",true");
				}
			} else {
				buffer.append(",true");
			}
		}
		return buffer.toString();
	}
	
	private void addActionIfNeeded(FacesContext context,UIComponent child,StringBuffer buffer){
		//TODO by nick - dima - use CommandScriptBuilder
		if (child instanceof UIPanelMenuItem){
			if (((UIPanelMenuItem)child).getAction() == null){
				buffer.append(",false");	
			} else {
				buffer.append(",true");
			}
		} else {
			if (((UIPanelMenuGroup) child).getAction() != null && 
			        !((UIPanelMenuGroup)child).getAction().equals("")){
				buffer.append(",'panelMenuNodeAction'");
			} else {
				buffer.append(",false");
			}
		}
	}
	
	private void setExpandedIfNeeded(FacesContext context,UIComponent child,StringBuffer buffer){
		if(child instanceof UIPanelMenuItem){
			buffer.append(",false");
		} else {
			UIPanelMenuGroup group = (UIPanelMenuGroup)child;
			if(group.getValue() != null){
				buffer.append(",").append(group.getValue().toString());
			} else {
				PanelMenuGroupRenderer r =  (PanelMenuGroupRenderer)context.getRenderKit().getRenderer(group.getFamily(), group.getRendererType());
				boolean isNodeOpened;
				try {
					isNodeOpened = r.isOpened(context, child);
				} catch (IOException e) {
					isNodeOpened = false;
				}
				buffer.append(",").append(String.valueOf(isNodeOpened));
			}
		}
	}
	
	private void addImages(StringBuffer buffer,FacesContext context,UIComponent component,String id){
		UIPanelMenu panelMenu = findMenu(component);
		if(panelMenu == null){
			return;
		}
		boolean isTopLevel = isTopLevel(component);
		
		final String PANEL_MENU_SPACER_ICON = getIconByType(PANEL_MENU_SPACER_ICON_NAME, isTopLevel,context, component);

		if(component instanceof UIPanelMenuItem){
			UIPanelMenuItem item = (UIPanelMenuItem)component;
			
			String defaultItemIcon = null;
			String defaultItemIconSrc = null;
			String customItemIcon = null;
			String customIconSource = null;
			
			if(isTopLevel){
				if(item.isDisabled()){
					defaultItemIcon = panelMenu.getIconTopDisabledItem();
				} else {
					defaultItemIcon = panelMenu.getIconTopItem();
				}
				if(defaultItemIcon == null || defaultItemIcon.equals("")){
					if(item.isDisabled()){
						defaultItemIcon = panelMenu.getIconDisabledItem();
					} else {
						defaultItemIcon = panelMenu.getIconItem();
					}
				}
			} else {
				//isTopLevel == false
				if(defaultItemIcon == null || defaultItemIcon.equals("")){
					if(item.isDisabled()){
						defaultItemIcon = panelMenu.getIconDisabledItem();
					} else {
						defaultItemIcon = panelMenu.getIconItem();
					}
				}
			}
			
			if(defaultItemIcon != null && defaultItemIcon.equals("none")){
				defaultItemIconSrc = PANEL_MENU_SPACER_ICON;
			} else {
				defaultItemIconSrc = getIconByType(defaultItemIcon, isTopLevel,context, component);
			}
			
			customItemIcon = item.isDisabled() ? item.getIconDisabled() : item.getIcon();
			if(customItemIcon != null && customItemIcon.equals("none")){
				customIconSource = PANEL_MENU_SPACER_ICON;
			} else {
				customIconSource = getIconByType(customItemIcon, isTopLevel,context, component);
			}
			
			if(customItemIcon != null && !customItemIcon.equals("")){
				buffer.append(",\""+customIconSource).append("\",\""+customIconSource+"\" ");
			} else if (defaultItemIcon != null && !defaultItemIcon.equals("")){
				buffer.append(",\""+defaultItemIconSrc).append("\",\""+defaultItemIconSrc+"\" ");
			} else {
				buffer.append(",\""+PANEL_MENU_SPACER_ICON).append("\",\""+PANEL_MENU_SPACER_ICON+"\" ");
			}
			buffer.append(",\"\" ");
			
		} else if(component instanceof UIPanelMenuGroup){
			UIPanelMenuGroup group = (UIPanelMenuGroup)component;

			String defaultIconNodeClosed = isTopLevel ? (group.isDisabled() ? panelMenu.getIconTopDisableGroup() : panelMenu.getIconCollapsedTopGroup()) : (group.isDisabled() ? panelMenu.getIconDisabledGroup() : panelMenu.getIconCollapsedGroup());
			
			if(isTopLevel){
				if(group.isDisabled()){
					defaultIconNodeClosed = panelMenu.getIconTopDisableGroup();
					if(defaultIconNodeClosed == null || defaultIconNodeClosed.equals("")){
						defaultIconNodeClosed = panelMenu.getIconDisabledGroup();
					}
				} else {
					defaultIconNodeClosed = panelMenu.getIconCollapsedTopGroup();
					if(defaultIconNodeClosed == null || defaultIconNodeClosed.equals("")){
						defaultIconNodeClosed = panelMenu.getIconCollapsedGroup();
					}
				}
			} else {
				if(group.isDisabled()){
					defaultIconNodeClosed = panelMenu.getIconDisabledGroup();
				} else {
					defaultIconNodeClosed = panelMenu.getIconCollapsedGroup();
				}
			}
			
			String defaultIconNodeOpened = isTopLevel ? panelMenu.getIconExpandedTopGroup() : panelMenu.getIconExpandedGroup();
			
			if(isTopLevel){
				defaultIconNodeOpened = panelMenu.getIconExpandedTopGroup();
				if(defaultIconNodeOpened == null || defaultIconNodeOpened.equals("")){
					defaultIconNodeOpened = panelMenu.getIconExpandedGroup();
				}
			} else {
				defaultIconNodeOpened = panelMenu.getIconExpandedGroup();
			}

			String defaultIconNodeOpenedSrc	= getIconByType(defaultIconNodeOpened, isTopLevel,context, component);
			String iconExpanded = group.isDisabled() ? group.getIconDisabled() : group.getIconExpanded();
			String iconExpandedSource = getIconByType(iconExpanded,isTopLevel,context,component);
			if(iconExpanded != null && !iconExpanded.equals("")){
				buffer.append(",\"" + iconExpandedSource + '"');
			} else if(defaultIconNodeOpened != null && !defaultIconNodeOpened.equals("")){
				buffer.append(",\"" + defaultIconNodeOpenedSrc + '"');
			} else {
				buffer.append(",\"" + PANEL_MENU_SPACER_ICON + '"');
			}

            String defaultIconNodeClosedSrc = getIconByType(defaultIconNodeClosed, isTopLevel,context, component);
			String iconCollapsed = group.isDisabled() ? group.getIconDisabled() : group.getIconCollapsed();
			String iconCollapsedSource = getIconByType(iconCollapsed,isTopLevel,context,component);
			if(iconCollapsed != null && !iconCollapsed.equals("")){
				buffer.append(",\"" + iconCollapsedSource + '"');	
			} else if(defaultIconNodeClosed != null && !defaultIconNodeClosed.equals("")){
				buffer.append(",\"" + defaultIconNodeClosedSrc + '"');
			} else {
				buffer.append(",\"" + PANEL_MENU_SPACER_ICON + '"');
			}
		}
		buffer.append(",\"" + PANEL_MENU_SPACER_ICON + "\"");
	}
			
	protected void addAjaxFunction(FacesContext context, UIComponent child, StringBuffer buffer) {
		JSFunction function = AjaxRendererUtils.buildAjaxFunction(child, context);
        Map<String, Object> eventOptions = 
            AjaxRendererUtils.buildEventOptions(context, child);
        function.addParameter(eventOptions);
        
        buffer.append(",\"");
        function.appendScript(buffer);
        buffer.append("\"");
	}
	
	protected void addOnItemHover(String menuOnItemHover, UIComponent child,
            StringBuffer buffer) {
        buffer.append(",\"");
        if (child instanceof UIPanelMenuItem) {
            if (menuOnItemHover != null && !menuOnItemHover.equals(""))
                buffer.append(menuOnItemHover);
        }
        buffer.append("\"");
    }
	
	public void renderChildren(FacesContext facesContext, UIComponent component)throws IOException {
	    if(!(component instanceof UIPanelMenu)) {
	        return;
	    }

		UIPanelMenu panelMenu = (UIPanelMenu)component;
		for (Iterator<UIComponent> it = component.getChildren().iterator(); it.hasNext();) {
			UIComponent child = (UIComponent) it.next();
			if (child instanceof UIPanelMenuGroup) {
				UIPanelMenuGroup group = (UIPanelMenuGroup)child;

				if (panelMenu.isExpandSingle()) {	
					if (!(Boolean)panelMenu.getAttributes().get(FIRST_EXPANDED_ENCODED)) {
						if (group.isExpanded()) {
							panelMenu.getAttributes().put(FIRST_EXPANDED_ENCODED, true);
						}
					} else {
						group.setExpanded(false);
						if ((Boolean)group.getValue()) {
							group.setValue(null);
						}
					}
				}						
			}
			renderChild(facesContext, child);
		}
	}
	
	public void doDecode(FacesContext context, UIComponent component) {
		Map<String, String> requestMap = context.getExternalContext().getRequestParameterMap();
		String menuClientId = component.getClientId(context);
		UIPanelMenu menu = ((UIPanelMenu)component);
		Object selectedItemName = requestMap.get(menuClientId + "selectedItemName");
		if(selectedItemName != null){
			menu.setSubmittedValue(selectedItemName);
		}
	}
	
}
