package org.richfaces.renderkit;

import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.renderkit.HeaderResourcesRendererBase;
import org.ajax4jsf.util.InputUtils;
import org.richfaces.component.UIColorPicker;

public abstract class ColorPickerRendererBase  extends HeaderResourcesRendererBase{

	public void decode(FacesContext context, UIComponent component){
		ExternalContext external = context.getExternalContext();
		Map requestParams = external.getRequestParameterMap();
		UIColorPicker colorPicker = (UIColorPicker)component;
		String clientId = colorPicker.getClientId(context);
		String submittedValue = (String)requestParams.get(clientId);
		
		if (submittedValue != null) {
			colorPicker.setSubmittedValue(submittedValue);
		}
	}	
	
	public String getInputValue(FacesContext context, UIInput input) {
		String inputValue = "";
		
		String submittedValue = (String) input.getSubmittedValue();
		if (submittedValue != null) {
			inputValue = submittedValue;
		} else {
			Object value = input.getValue();
			if (value != null) {
				inputValue = InputUtils.getConvertedStringValue(context, input, value);
			}
		}
		
		return inputValue;
	}
	public void addPopupToAjaxRendered(FacesContext context, UIColorPicker component) {
		AjaxContext ajaxContext = AjaxContext.getCurrentInstance(context);
		Set<String> ajaxRenderedAreas = ajaxContext.getAjaxRenderedAreas();
		String clientId = component.getClientId(context);
		if (ajaxContext.isAjaxRequest() && ajaxRenderedAreas.contains(clientId)) {
			ajaxRenderedAreas.add(clientId + "-colorPicker-popup");
			ajaxRenderedAreas.add(clientId + "-colorPicker-script");
		}
	}
}