/**
 * 
 */
package org.richfaces.renderkit;

import java.io.IOException;

import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

import org.ajax4jsf.renderkit.HeaderResourcesRendererBase;
import org.ajax4jsf.renderkit.RendererUtils.HTML;
import org.richfaces.component.LayoutPosition;
import org.richfaces.component.UILayout;
import org.richfaces.component.UILayoutPanel;

/**
 * @author asmirnov
 *
 */
public abstract class AbstractLayoutRenderer extends
		HeaderResourcesRendererBase {

	public void renderLayout(FacesContext context, UILayout layout) throws IOException {
		// Detect layout content;
		UILayoutPanel top = null;
		UILayoutPanel bottom = null;
		UILayoutPanel left = null;
		UILayoutPanel right = null;
		UILayoutPanel center = null;
		int columns = 0;
		for (UIComponent child : layout.getChildren()) {
			if (child instanceof UILayoutPanel) {
				UILayoutPanel layoutPanel = (UILayoutPanel) child;
				LayoutPosition position = layoutPanel.getPosition();
				if( LayoutPosition.top.equals(position)){
					if(null != top){
						throw new FacesException("Duplicate layoutPanel's with same position"+position);
					}
					top = layoutPanel;
				} else if( LayoutPosition.bottom.equals(position)){
					if(null != bottom){
						throw new FacesException("Duplicate layoutPanel's with same position"+position);
					}
					bottom = layoutPanel;
				} else if( LayoutPosition.left.equals(position)){
					if(null != left){
						throw new FacesException("Duplicate layoutPanel's with same position"+position);
					}
					left = layoutPanel;
					columns++;
				} else if( LayoutPosition.right.equals(position)){
					if(null != right){
						throw new FacesException("Duplicate layoutPanel's with same position"+position);
					}
					right = layoutPanel;
					columns++;
				} else if( null == position || LayoutPosition.center.equals(position)){
					if(null != center){
						throw new FacesException("Duplicate layoutPanel's with same position"+position);
					}
					center = layoutPanel;
					columns++;
				} else {
					
				}
			}
		}
		if(columns>0 && null == center){
			throw new FacesException("Center layout panel for multi-column layout is not defined");			
		}
		ResponseWriter writer = context.getResponseWriter();
		if(null != top){
			renderChild(context, top);
		}
		if(columns>1){
			// Render Y! CSS Grid
			writer.startElement(HTML.DIV_ELEM, layout);
			// calculate class.
			String yahooClass = "yui-g";
			if(columns >2){
				yahooClass = "yui-gb";
			} else {
				Object width = center.getAttributes().get("width");
				if("75%".equals(width)){
					yahooClass = "yui-gc";
				} else if("66%".equals(width)){
					yahooClass = "yui-gd";
				}
			}
			writer.writeAttribute(HTML.class_ATTRIBUTE, yahooClass, null);
			if(null != left){
				left.getAttributes().put("first", "first");
				center.getAttributes().remove("first");
				renderChild(context, left);
			} else {
				center.getAttributes().put("first", "first");
			}
			renderChild(context, center);
			if(null != right){
				right.getAttributes().remove("first");
				renderChild(context, right);				
			}
			writer.endElement(HTML.DIV_ELEM);
		} else if (columns == 1) {
			renderChild(context, center);			
		}
		if(null != bottom){
			renderChild(context, bottom);
		}
	}
}
