package org.richfaces.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.richfaces.component.UIComponentControl;

public class HtmlComponentControl extends UIComponentControl{

public final static  String COMPONENT_FAMILY = "org.richfaces.ComponentControl";

public final static  String COMPONENT_TYPE = "org.richfaces.ComponentControl";

/*
* Defines the page loading phase when componentControl is attached to another component. Default value is "onavailable"
*/
private  String _attachTiming = null;

/*
* Client identifier of the component or id of the existing DOM element that is a source
				for given event. If attachTo is defined, the event is attached on the client according
				to the attachTiming attribute.
				If attachTo is not defined, the event is attached on the server to the closest in the
				component tree parent component.
*/
private  String _attachTo = null;

/*
* The Event that is used to trigger the operation on the target component
*/
private  String _event = null;

/*
* Client identifier of the target component.
*/
private  String _for = null;

/*
* The optional name of the function that might be used to trigger the operation on the target component
*/
private  String _name = null;

/*
* onsubmit
*/
private  String _onsubmit = null;

/*
* The function of JavaScript API that will be invoked. The API method
				is attached to the 'component' property of the root DOM element that represents
				the target component. The function has two parameters - event and params. See: 'params'
				attribute for details.
*/
private  String _operation = null;

/*
* The set of parameters passed to the function of Javascript API that will be invoked. 
				The JSON syntax is used to define the parameters, but without open and closed curve 
				bracket.
				As an alternative, the set of f:param can be used to define the parameters passed to the 
				API function. If both way are used to define the parameters, both set are concatenated.
				if names are equals, the f:param has a priority.
*/
private  String _params = null;


public HtmlComponentControl(){
setRendererType("org.richfaces.ComponentControlRenderer");
}

public String getAttachTiming(){
	if (this._attachTiming != null) {
		return this._attachTiming;
	}
	ValueExpression ve = getValueExpression("attachTiming");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "onavailable";
	

}

public void setAttachTiming(String _attachTiming){
this._attachTiming = _attachTiming;
}

public String getAttachTo(){
	if (this._attachTo != null) {
		return this._attachTo;
	}
	ValueExpression ve = getValueExpression("attachTo");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setAttachTo(String _attachTo){
this._attachTo = _attachTo;
}

public String getEvent(){
	if (this._event != null) {
		return this._event;
	}
	ValueExpression ve = getValueExpression("event");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setEvent(String _event){
this._event = _event;
}

public String getFor(){
	if (this._for != null) {
		return this._for;
	}
	ValueExpression ve = getValueExpression("for");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setFor(String _for){
this._for = _for;
}

public String getName(){
	if (this._name != null) {
		return this._name;
	}
	ValueExpression ve = getValueExpression("name");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setName(String _name){
this._name = _name;
}

public String getOnsubmit(){
	if (this._onsubmit != null) {
		return this._onsubmit;
	}
	ValueExpression ve = getValueExpression("onsubmit");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnsubmit(String _onsubmit){
this._onsubmit = _onsubmit;
}

public String getOperation(){
	if (this._operation != null) {
		return this._operation;
	}
	ValueExpression ve = getValueExpression("operation");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOperation(String _operation){
this._operation = _operation;
}

public String getParams(){
	if (this._params != null) {
		return this._params;
	}
	ValueExpression ve = getValueExpression("params");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setParams(String _params){
this._params = _params;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[9];
state[0] = super.saveState(context);
state[1] = _attachTiming;
state[2] = _attachTo;
state[3] = _event;
state[4] = _for;
state[5] = _name;
state[6] = _onsubmit;
state[7] = _operation;
state[8] = _params;
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_attachTiming = (String)states[1];;
		_attachTo = (String)states[2];;
		_event = (String)states[3];;
		_for = (String)states[4];;
		_name = (String)states[5];;
		_onsubmit = (String)states[6];;
		_operation = (String)states[7];;
		_params = (String)states[8];;
	
}

}
